;COPYRIGHT (C) 1983 SemiDisk Systems, Inc.
	PAGE	65
	TITLE	'SEMIDISK RELOCATER BY MICHAEL ENKELIS'
TRUE	EQU	-1
FALSE	EQU	NOT TRUE
;
MEG8		EQU	TRUE		;SET TRUE IF 8MEG SYSTEM
					;SET FALSE IF 256K BOARD
VER		EQU	5		;INSTALLER VER
EXTECO		EQU	'0'
MODSLVL		EQU	'2'
INTECO		EQU	'1'
DRV		EQU	4		;DRIVER VER (FOR SYNC CHECK)
;

CR		EQU	0DH
LF		EQU	0AH

;
;
SEMI$BASE	EQU	128		;<- BASE OF SemiDisk PORTS
SEMI$DATA	EQU	SEMI$BASE+0
SEMI$BYTE	EQU	SEMI$BASE+1
SEMI$TRACK	EQU	SEMI$BASE+2
SEMI$SECTOR	EQU	SEMI$BASE+3
;
;
	IF	MEG8
TOPS		EQU	255		;LAST SECTOR IN SYSTEM
SECSIZ		EQU	16		;#SECTORS ON FULL BOARD
BOARD		EQU	16		;#BOARDS FULL SYSTEM
	ELSE
TOPS		EQU	15		;LAST SECTOR IN SYSTEM
SECSIZ		EQU	02		;#SECTORS PER ROW
BOARD		EQU	08		;#ROWS ON BOARD
	ENDIF
;
;		COMMANDS:
;					ENABLED DISABLED DEFAULT
;
; ?:		SELECT SEMIDISK UNIT	.	.	E:
; AVVV		BASE ADDRESS		.	.	128
; P?		PARITY ERROR REPORT	+	-	+
; B?		HYPER-BOOT MODE		+	-	+
; S?		SAVE OPTION CHANGES	+	-	+
; Z?		AUTO FORMAT Semidisk	+	-	+
; V?		READ AFTER WRITE VERIFY +	-	+
; M?		DISK MAPPING		+	-	+
; TVVV		TRACKS FOR SPOOLER	1	0	1
; LVV		LOCATE DRIVER		.	00	00
;
;
; W		WHO WROTE THIS DRIVER
; O		DISPLAY OPTION(S) SELECTED
; R		REMOVE SEMIDISK DRIVER FROM MEMORY
; ?n		DISPLAY HELP TEXT, FROM PAGE n (1-4)
; / OR <SPACE>	SWITCH SEPARATORS
;
;
;	OPTION BITS & FLAGS
;
;	?OPT	OPTION FLAGS LABLE
;
;	BITS	FLAG		ON / OFF
;
;	7	PARITY REPORT	 0    1
;	6	HYPER BOOT	 0    1
;	5	READ AFTER WRITE 1    0
;	4	DISK MAPPING     1    0
;	3	SIZE
;	2	SIZE
;	1	SIZE
;	0	SIZE
;
;	?ME	UNIT SELECT FLAGS
;	BITS	3-0	PRIMARY UNIT
;
;		04		E:
;
;	DRV$VER	DRIVER FLAGS
;	BITS	0-3	DRIVER VER
;	BITS	4-5	SemiDisk MODEL
;	BIT	6	SPOOLER BUILT
;	BIT	7	Z80 CODE
;
;		TO GENERATE DRIVER.REL
;
;1)	MAC DRIVER $ PZ SZ	;MAKE BASE 0 HEX FILE
;2)	REN DRIVER.HX0=DRIVER.HEX
;3)	MAC DRIVER $ PZ SZ +R	;MAKE BASE 100 HEX FILE
;4)	PIP DRIVER.HEX=DRIVER.HX0,DRIVER.HEX
;5)	GENMOD DRIVER.HEX DRIVER.REL
;6)	ERA DRIVER.HEX		;CLEAN UP DISK
;7)	ERA DRIVER.HX0		;CLEAN UP DISK
;
;
;		TO GENERATE SEMIDISK.COM
;1)	MAC SEMIDISK $PZ SZ	;MAKE HEX FILE (NUMB OUTPUT IS OFFSET)
;2)	DDT			;START DDT
;3)	F100,2000,0		;CLEAR MEMORY
;4)	IDRIVER.REL		;INSERT DRIVER.REL NAME
;5)	R1600			;READ WITH OFFSET (NUMB. FROM MAC ASMB)
;6)	ISEMIDISK.HEX		;INSERT SEMIDISK.HEX NAME
;7)	R			;READ WITHOUT OFFSET
;8)	G0			;WARM BOOT CP/M
;9)	SAVE 30 SEMIDISK.COM	;SAVE MEMORY IMAGE AS .COM FILE
;10)	ERA SEMIDISK.HEX	;CLEAN UP DISK
;
;
	ORG	100H
;
	JMP	PAST		;RANDOM RECORD 0
;
TEST:	DB	00H		;TESTING FLAG
CURDAT: DB	8,8,8,8,VER+'0',INTECO,' 13-APR-83'
MIKE:	DB	CR,LF
	DB	'Copyright 1983, COMPUTEK',CR,LF
	DB	'		Michael A. Enkelis',CR,LF
	DB	'		All Rights Reserved.',CR,LF
	DB	LF
SDSYS:	DB	'Copyright 1982, SemiDisk Systems',CR,LF
	DB	'		P.O. Box GG',CR,LF
	DB	'		Beaverton, OR,  97075',CR,LF
	DB	'		All Rights Reserved.$'
	DB	8,32,26
;
;	SYSTEM TABLE		;RANDOM RECORD 1
;
OPT:	DB	30H		;OPTION FLAGS
ME:	DB	04H		;PRIMARY UNIT
STRKS:	DB	00H		;SPOOL TRACKS
AREA:	DW	0000H		;DRIVER AREA
BASE:	DB	SEMI$BASE	;BASE PORT
PFLAG:	DB	'+'		;PARITY REPORT FLAG
BFLAG:	DB	'+'		;HYPER BOOT FLAG
VFLAG:	DB	'+'		;VERIFY FLAG
MFLAG:	DB	'+'		;MAP DISKS FLAG
ZFLAG:	DB	'+'		;ZERO ON BOOT FLAG
;
PAST:	LXI	H,0	;HL=0
	DAD	SP	;HL=STACK POINTER
	SHLD	STACK1	;SAVE POINTER
	LXI	SP,STACK;CREATE LOCAL STACK SPACE
;
;	STEP 0	CHECK FOR CP/M 2.X
;
	MVI	C,12	;RETURN VERSION #
	CALL	5	;OF CP/M
	CPI	20H	;MUST BE >= 2.0
	LXI	D,WARN	;WARN USER
	JC	EXIT1	;CAN'T DO THIS
;
;	AND FOR CORRECT DRIVER
;
	LDA	DRV$VER ;GET DRIVER VER
	ANI	00001111B
	CPI	DRV	;MATCH?
	LXI	D,SYNC	;SYNC ERROR
	JNZ	EXIT1	;BETWEEN INSTALL & DRIVER
;
;	STEP 1	SELECT SEMIDISK ACTIVE CODE
;	AND DECODE SWITCHES
;
	MVI	A,1	;SET UPDATE SWITCH=NORMAL MODE
	STA	UPDATE	;
	DCR	A	;A=0
	STA	REMOPT	;SET REMOVE OPTION FLAG FALSE
	LXI	H,80H	;GET TBASE (LENGTH BYTE)
	ADD	M	;A=COMMAND LENGTH
	JZ	MEG	;USE DEFAULT.
	INX	H	;HL=START OF BUFFER
	PUSH	H	;SAVE IT
	ADD	L	;A=LENGTH+BUFFER BASE
	MOV	L,A	;HL=END OF BUFFER
	MVI	M,0	;MARK END OF BUFFER
	POP	H	;HL=BASE OF BUFFER
;
SWITCHS:CALL	SCAN	;SCAN FOR SWITCHES
	JC	MEG	;END-OF-LINE FOUND
	INX	H	;ADVANCE SCAN POINTER
	JMP	SWITCHS ;AND DECODE NEXT SWITCH
;
PARITY: INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	DCX	H	;BACKUP SCAN
	MVI	B,10000000B
	CALL	PMSET	;DECODE +/- SWITCH
;
SAVON:	MVI	A,255	;A=ON VALUE
	STA	UPDATE	;SET UPDATE FLAG
	XRA	A	;CLEAR ACC
	RET		;DECODE NEXT
;
WBOOT:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	DCX	H	;BACKUP SCAN
	LDA	ME	;CHECK IF A: ACTIVE
	ORA	A
	LXI	D,NOHB	;REPORT MUST HAVE HYPER BOOT
	JZ	EXIT1	;ON AT ALL TIMES
	CALL	LEGAL	;CHECK IF LOGGED INTO SEMIDISK
	MVI	B,01000000B
	CALL	PMSET	;DECODE +/- SWITCH
	JMP	SAVON	;S+
;
;	SELECT SemiDisk UNIT
;
PDISK:	DCX	H	;BACKUP SCAN POINTER
	MOV	A,M	;GET DISK UNIT LETTER
	INX	H	;ADVANCE SCAN POINTER
	CPI	'P'	;TOO BIG?
	LXI	D,INVALID
	JNC	EXIT1	;YES
	ANI	15	;MASK OFF INVALID BITS
	DCR	A	;RANGE DOWN (A:=0...)
	JNZ	PDISK1	;DRIVE B: TO O:
	LDA	OPT	;GET HYPER-BOOT OPTION
	ANI	01000000B
	LXI	D,NOHB	;REPORT MUST HAVE HYPER BOOT
	JNZ	EXIT1	;IF OFF, REPORT ERROR
PDISK1: STA	ME	;ACTIVATE SEMIDISK UNIT
	MOV	A,M	;MUST BE ":"
	CPI	':'	;AFTER DRIVE
	LXI	D,INVALID
	JNZ	EXIT1	;HOW?
	JMP	SAVON	;S+
;
;	THIS RELOCATES PORTS OF SemiDisk
;	
SDREL:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	CALL	LEGAL	;CHECK IF LOGGED INTO SEMIDISK
	XCHG		;DE=SCAN POINTER
	CALL	GETDEC	;CONVERT BUFFER TO DECIMAL
	CALL	ENDRD	;RELOCATE SEMIDISK PORTS
	XCHG		;HL=NEW SCAN POINTER
	JMP	SAVON	;S+
SDREL0: DCX	H	;BACK UP SCAN POINTER
	JMP	SAVON	;S+
;
;	SPOOL TRACKS
;
SPLTRK:	INX	H	;POINT TO NUMBER
	XCHG		;DE=SCAN POINTER
	CALL	GETDEC	;CONVERT BUFFER TO DECIMAL
	XRA	A
	CMP	H	;TOO BIG?
	JNZ	SPT0	;YES, THROW AWAY
	MOV	A,L	;GET VALUE
	CPI	250+1	;TOO BIG?
	JNC	SPT0	;YES, THROW AWAY
	STA	STRKS	;SAVE VALUE
SPT0:	XCHG		;HL=NEW SCAN POINTER
	JMP	SAVON	;S+
;
;	LOCATE DRIVER
;
LOCATE:	INX	H
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	XCHG		;DE=SCAN POINTER
	CALL	GETDEC	;CONVERT BUFFER TO DECIMAL
	MOV	A,H
	ORA	L
	JZ	LC0	;LOCATE DISABLED
	INR	H	;CLEAR ZFLAG
	DCR	H	;ANYTHING IN H REG?
	JNZ	HROK	;YES, SKIP COPY
	MOV	H,L	;ELSE COPY L TO H
HROK:	LDA	2	;A=CBIOS BASE
	CMP	H	;OK?
	JNC	LC1	;TOO LOW
	MVI	L,255	;LOCATE ENABLED
LC0:	SHLD	AREA	;SAVE FLAG,BASE
	XCHG		;HL=NEW SCAN POINTER
	JMP	SAVON	;S+
LC1:	LXI	D,ODD+2
	JMP	EXIT1	;STOP NOW
;
;	DISPLAY AUTHOR INFO
;
WHO:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	CALL	SIZE1	;DISPLAY SYSTEM SIZE
	LXI	D,CURDAT;POINT TO WHO WROTE THIS
	JMP	EXIT1	;PRINT MESSAGE
;
;	ENABLE/DISABLE READ AFTER WRITE
;
VERIFY: INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	DCX	H	;BACKUP SCAN
	MVI	B,00100000B
	CALL	PMSET	;DECODE +/- SWITCH
	CALL	PINV	;INVERT SWITCH VALUE
	JMP	SAVON	;S+
;
;	DISPLAY CURRENT OPTION SWITCH SETINGS
;
OPTION: INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP OPTION DISPLAY
;
	LDA	BASE	;GET BASE ADDRESS
	LXI	H,DECBUF;HL=DECIMAL BUFFER
	MVI	B,100
	CALL	DEC1	;/100
	MVI	B,10
	CALL	DEC1	;/10
	ADI	'0'
	MOV	M,A	;SAVE IN BUFFER ONES DIGIT
;
	LDA	STRKS	;GET SPOOL TRACKS
	LXI	H,DECB1	;HL=DECIMAL BUFFER
	MVI	B,100
	CALL	DEC1	;/100
	MVI	B,10
	CALL	DEC1	;/10
	ADI	'0'
	MOV	M,A	;SAVE IN BUFFER ONES DIGIT
;
;	DECODE OPTIONS
	LXI	D,OPT	;DE=POINTER TO OPTIONS
	LDAX	D	;GET FLAGS
	ANI	1000$0000B
	MVI	A,'+'
	JZ	VU1
	MVI	A,'-'
VU1:	STA	PFLG+1	;PARITY OFF
	LDAX	D	;GET OPTIONS
	ANI	0100$0000B
	MVI	A,'+'
	JZ	VU2
	MVI	A,'-'
VU2:	STA	BFLG+1	;BOOT SPECIAL
	LDAX	D	;GET OPTIONS
	ANI	0010$0000B
	MVI	A,'+'
	JNZ	VU3
	MVI	A,'-'
VU3:	STA	VFLG+1	;READ AFTER WRITE
	LDA	ZFLAG
	STA	ZFG+1	;ZERO ENABLE
	LDA	MFLAG	;GET MAP FLAG
	STA	MFLG+1
;
	CALL	SIZE1	;SHOW DRIVER SIZE
	LDA	DRV$VER	;GET VER#
	PUSH	PSW
	ANI	10000000B
	LXI	D,I8080
	JZ	VP1
	LXI	D,Z80
VP1:	CALL	PRINT1
	POP	PSW
	PUSH	PSW
	ANI	00110000B
	LXI	D,SD$I
	JZ	VP2
	CPI	00010000B
	LXI	D,SD$II
	JZ	VP2
	CPI	00100000B
	LXI	D,SD$QX10
	JZ	VP2
	LXI	D,SD$XXX
VP2:	CALL	PRINT1
	POP	PSW
	ANI	01000000B
	LXI	D,SSM
	CNZ	PRINT1
;
	LXI	D,VERMSG
	CALL	PRINT1
;
	LDA	AREA	;LOCATED?
	ORA	A
	JZ	NLC	;NOPE
	LXI	D,LMSG
	CALL	PRINT1
	LDA	AREA+1	;GET HIGH ADDR
	CALL	HEOUT	;SEND AS HEX
	XRA	A
	CALL	HEOUT	;00
	MVI	E,'H'
	MVI	C,2
	CALL	5
NLC:
;
;	DISPLAY ACTIVE UNIT CODES
	LDA	ME	;GET UNIT SELECTS
	ADI	'A'	;ADD ASCII BIAS
	STA	AMSG+1	;SAVE IN TEXT
	LXI	D,AMSG
	JMP	EXIT1
;
DEC1:	MVI	M,'0'-1
	INR	M
	SUB	B
	JNC	DEC1+2
	ADD	B
	INX	H
	RET
;
; HEX TO ASCII OUTPUT
HEOUT:	MOV	D,A
	RRC
	RRC
	RRC
	RRC
	CALL	HEOU1
	MOV	A,D
HEOU1:	ANI	0FH
	ADI	48
	CPI	58
	JC	HEOU2
	ADI	7
HEOU2:	MOV	E,A
	PUSH	D
	MVI	C,2
	CALL	5
	POP	D
	RET
;
;	INVERT OPTION FLAG
;
PINV:	LDA	OPT	;GET OPTIONS FLAGS
	XRA	B	;INVERT BIT
	STA	OPT	;SAVE INVERTED BIT
	RET
;
;	SAVE SWITCH MUST BE LAST OF THE SWITCHES!
;
SAVE:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	CPI	'+'	;ON?
	JZ	SAVON	;YES
	CPI	'-'	;OFF?
	RNZ		;NOPE
	XRA	A	;YES
	STA	UPDATE	;KILL SAVE OPT
	RET
;
;	DECODE MAP SWITCH
;
MAP:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	CPI	'+'	;ON?
	JZ	MAP1	;YES
	CPI	'-'	;OFF?
	RNZ		;NOPE
	STA	MFLAG
	LDA	OPT
	ANI	11101111B
	STA	OPT
	JMP	SAVON
	
MAP1:	STA	MFLAG	;SET FLAG
	LDA	OPT
	ORI	00010000B
	STA	OPT
	JMP	SAVON	;S+
;
;	ASK TO AUTO ZERO BOARD
;
ZAP:	INX	H	;ADVANCE SCAN POINTER
	MOV	A,M	;GET SWITCH FLAG
	CPI	':'	;CHECK FOR DRIVE SPEC
	JZ	SDREL0	;SKIP ADDRESS SET
	MOV	A,M
	CPI	'-'
	JNZ	ZP1
	STA	ZFLAG	;SET SWITCH
	XRA	A
	STA	REMOPT+1
	JMP	SAVON	;Z-/S+

ZP1:	CPI	'+'
	RNZ		;BAD OPTION
	STA	ZFLAG	;SET FLAG ON
	PUSH	H	;SAVE SCAN POINTER
	LXI	D,SURE	;CHECK FOR SURE
	CALL	PRINT1
	LXI	D,BUF	;POINT TO ANSWER BUFFER
	MVI	C,10	;READ CONSOLE COMMAND
	CALL	5	;PASS TO BDOS
	LXI	H,BUF+1 ;GET LENGTH BYTE
	XRA	A	;ZERO ACC
	ADD	M	;A.=LENGTH OF ANSWER
	JZ	ZAPN	;ZERO=NO ZAP
;
;	DECODE "YES" ANSWER
	MOV	C,A	;C=LENGTH
	INX	H	;+HL
	MOV	A,M
	CPI	'Y'	;"Y"
	JZ	ZAPY	;NOT YES
	CPI	'y'	;"y"
	JNZ	ZAPN	;NOT YES
ZAPY:	MVI	A,1
	STA	REMOPT+1
	CALL	SLF	;SEND LF
	POP	H	;GET SCAN POINTER
	JMP	SAVON	;Z+/S+
;
;	ANSWER IS NO
;
ZAPN:	XRA	A
	STA	REMOPT+1
	CALL	SLF	;SEND LF
	POP	H	;GET SCAN POINTER
	RET		;SAVE OFF
;
;	DISPLAY HELP TEXT
;
HELP:	INX	H	;ADVANCE SCAN POINTER
	XCHG		;DE=COMMAND LINE
	CALL	GETDEC	;DECODE PAGE SELECT
	MOV	A,L	;A=PAGE # (1,2,3,4)
	CPI	4	;#4?
	JZ	H4	;YES
	CPI	3	;#3?
	JZ	H3	;YES
	CPI	2	;#2?
	JZ	H2	;YES
;
H1:	LXI	D,HLP1	;POINT TO HELP TXT
	CALL	PRINT	;PAGE #1
	CALL	PRWAT	;WAIT FOR <RETURN>
H2:	LXI	D,HLP2	;HELP TEXT #2
	CALL	PRINT	;PAGE #2
	CALL	PRWAT	;WAIT FOR <RETURN>
H3:	LXI	D,HLP3	;HELP TEXT #3
	CALL	PRINT	;PAGE #3
	CALL	PRWAT	;WAIT FOR <RETURN>
H4:	LXI	D,HLP4	;HELP TEXT #4
	CALL	PRINT	;PAGE #4
	JMP	EXIT2	;ALL DONE
;
PRINT:	PUSH	D	;SAVE POINTER
	LXI	D,HLP	;POINT TO HELP TXT
	CALL	PRINT1
	POP	D	;RESTORE POINTER
PRINT1:	MVI	C,9	;DISPLAY TEXT
	CALL	5
	RET
;
PRWAT:	LXI	D,NPMSG ;ASK FOR NEXT PAGE
	CALL	PRINT1
PRSIT:	MVI	C,6	;DIRECT MODE COMMAND
	MVI	E,0FFH	;MODE=INPUT
	CALL	5	;GET KEY
	CPI	3	;^C
	JZ	EXIT2	;YES
	CPI	CR	;<RETURN>?
	JNZ	PRSIT	;PRINT WAIT LOOP
	RET		;RETURN TO HELP
;
;	REMOVE DRIVER OPTION
;
REM:	CALL	LEGAL	;CHECK IF LOGGED INTO SEMIDISK
	MVI	A,255	;SWITCH TO ACTIVE STATE
	STA	REMOPT	;
	JMP	RELOAD	;REMOVE DRIVER,DON'T CHECK SIZE
;
;	AUTOMATIC SIZE CHECK & SET
;
MEG:	LDA	BASE	;GET BASE PORT
	STA	IPP$1	;FIX DATA PORT
	STA	IPP$X1	;
	STA	IPP$2	;
	STA	IPP$X2	;
	INR	A	;
	STA	IPP$3	;FIX BYTE PORT
	INR	A	;
	STA	IPP$4	;FIX TRACK PORT
	INR	A	;
	STA	IPP$5	;FIX SECTOR PORT
	STA	IPP$6	;FIX STATUS CLEAR PORT
;
IPP$6	EQU	$+1	;SD$II CLEAR STATUS
	IN	SEMI$SECTOR
;
	MVI	L,1	;DEFAULT FOR .5 MEGABYTE
	LDA	TEST	;SKIP AUTO SIZE
	ANI	2	;TEST?
	CZ	FNDSIZ	;FIND SIZE, RETURN ACC
	INR	L
	DCR	L	;BOARD/ROW NUMBER= 0
	JNZ	MEMSET	;NO, REPORT FOUND SYSTEM SIZE
	CALL	NFOUND	;BOARD NOT FOUND,ASK FOR NEW ADDRESS
	CALL	SAVON	;SET S+ SWITCH
	JMP	MEG	;TRY AGAIN
;
;	A=SECTOR#, L=BOARD#
;
MEMSET: MVI	H,0	;CLEAR ERROR COUNT FLAG
	PUSH	PSW	;SAVE SECTOR#
	LDA	TEST	;SKIP VALID SECTOR TESTS
	ANI	1	;TEST
	JNZ	TNXT	;YES, SKIP VALID TEST CHECK
	POP	PSW	;ELSE DO TEST VALID CHECK
	PUSH	H	;SAVE H&L (BOARD # IN L)
;
;	VALID SYSTEM TEST
;
MEMCON: DCR	L	;DOWN A BOARD
	JZ	MEMVAL	;IF LAST BOARD?
	SUI	SECSIZ	;ELSE, DOWN A SECTOR/ROW
	PUSH	PSW	;SAVE SECTOR #
	CALL	MEMTST	;TEST IF SECTOR FOUND
	CNZ	MEMBAD	;SECTOR NOT FOUND
	POP	PSW	;GET SECTOR # BACK
	JMP	MEMCON	;CONTINUE TEST
;
;	ALL SECTORS FOUND
MEMVAL: INR	H	;TEST ERROR
	DCR	H	;FLAG
	POP	H	;RESTORE H&L (BOARD # IN L)
	JNZ	EXIT2	;EXIT BECAUSE OF ERRORS
	JMP	MEMV1	;ELSE, SET SIZE
TNXT:	POP	PSW	;RESTORE SECTOR#
;
MEMV1:	DCR	L	;RANGE DOWN (1->0,2->1)
	LDA	OPT	;GET OPTIONS FLAGS
	PUSH	PSW	;SAVE FLAGS
	ANI	0000$1111B
	CMP	L	;NEW SIZE=OLD SIZE?
	CNZ	SAVON	;NO, SET S+ SWITCH
	POP	PSW	;RESTORE FLAGS
	ANI	1111$0000B
	ORA	L	;SET NEW SIZE
	STA	OPT	;SAVE OPTIONS FLAGS
	DAD	H	;*2
	DAD	H	;*4
	DAD	H	;*8
	DAD	H	;*16
	LXI	D,MEGTAB;BASE OF TABLE
	DAD	D	;HL=MEGABYTE POINTER
	LXI	D,DPB	;POINT TO DPB IN DRIVER
	MVI	B,15	;15 BYTES PER TABLE ENTRY
	CALL	COPY	;MOVE M(HL) -> M(DE) @B BYTES
	JMP	RELOAD
;
;	SHOW BAD BOARD NUMBER
;
MEMBAD: PUSH	H	;SAVE HL
	PUSH	H	;
	LXI	D,BAD2	;MESSAGE POINTER
	CALL	PRINT1
	POP	H	;GET HL BACK
	MOV	A,L	;GET BOARD #
	LXI	H,BUF	;HL=CONVERT BUFFER
	PUSH	H	;SAVE POINTER
	MVI	B,10
	CALL	DEC1
	ADI	'0'
	MOV	M,A
	INX	H
	MVI	M,'$'	;MARK END OF CONVERT BUFFER
	POP	D	;DE=POINTER TO CONVERT BUFFER
	CALL	PRINT1
	POP	H	;GET BACK HL
	INR	H	;ADD ONE TO ERROR FLAG COUNT
	RET		;ALL DONE
;
;	CALCULATE BASE OF SEMIDISK DRIVER
;
RELOAD:	CALL	HUNT	;HUNT FOR BDOS BASE
	XCHG		;HL=BASE OF BDOS
	SHLD	RELOC	;SAVE BASE (XX00H)
	JNZ	AUTHOR	;DRIVER NOT LOADED
;
;	DRIVER IS LOADED
;	NOW UNLOAD DRIVER FROM MEMORY
;
	XCHG		;HL=BASE OF DRIVER
	MVI	M,0	;REMOVE DRIVER FLAG
	DCX	H	;BACK UP 1
	MVI	M,0	;REMOVE DRIVER FLAG
	PUSH	H
;
;	IF LOCATED ABOVE CP/M
;	  SKIP THIS SECTION
;
	LDA	AREA	;GET OFFSET
	ORA	A
	JNZ	RL0
;
;	RESTORE BDOS BASE
;
;	5: JMP BDOS
;
	XCHG		;DE=BASE OF DRIVER
	LHLD	LENGTH	;HL=MODULE LENGTH
	DAD	D	;
	MVI	L,0	;HL=BASE OF CCP
	LXI	D,806H	;DE=OFFSET FROM CCP TO BDOS
	DAD	D	;HL=BASE OF BDOS
	SHLD	6	;RESTORE LOW JUMP
;
;	RESTORE:WBOOT
;
;	0: JMP WBOOT
;
RL0:	LHLD	1	;HL=BIOS ENTRY: WBOOT
	XCHG		;INTO DE
	POP	H	;HL=DRIVER BASE
	MVI	L,27H	;HL=DRIVER ENTRY: @WBOOT
	LDA	DRV$VER
	ANI	01000000B
	JZ	RL1	;RELOAD SPOOLER?
;
;	SPOOLER INSTALLED
	MVI	B,16*3
	CALL	COPY	;COPY M(HL) -> M(DE) FOR B BYTES
	JMP	RL2	;ALL DONE
;
;	SPOOLER NOT INSTALLED
RL1:	MVI	B,3	;B=NUMBER OF BYTES TO COPY
	CALL	COPY	;DO IT
;
;	RESTORE:
;	HOME,SELDK,SETTK,SETSC,SETDM,READ,WRITE,LISTS,SECTR
;
	MVI	E,18H	;DE=BIOS ENTRY: HOME
	MVI	B,9*3	;B=TABLE LENGTH
	CALL	COPY	;COPY M(HL) -> M(DE) FOR B BYTES
;
RL2:	LDA	REMOPT	;GET REMOVE OPTION
	ORA	A	;ACTIVE?
	LXI	D,GONE	;TELL DRIVER IS NOW GONE
	JNZ	EXIT1	;YES,DRIVER NOW REMOVED
	JMP	RELOAD	;RELOAD DRIVER
;
;	STEP 2	PRINT SIGNON STRING
;
AUTHOR: LDA	REMOPT	;GET REMOVE SWITCH
	ORA	A	;ACTIVE?
	LXI	D,GONE1 ;DRIVER IS REMOVED
	JNZ	EXIT1	;YES,DRIVER WAS REMOVED
	CALL	SIZE1	;DISPLAY SYSTEM SIZE
;
;	CHECK IF PRESERVE SYSTEM IN EFFECT
;
;	UPDATE: +1= NO SWITCHES USED
;	UPDATE: 0 = S- (NO UPDATE)
;	UPDATE: -1= S+ (UPDATE FLAGS)
;
	LDA	UPDATE	;GET UPDATE FLAG
	CPI	1	;TEST FOR NORMAL MODE
	JZ	STEP3	;NORMAL RUN
	INR	A	;-1 TO 0 or 0 to 1
	PUSH	PSW	;SAVE FLAGS
	LXI	D,NOTPRM;WARN THAT S- WAS USED
	MVI	C,9	;COMMAND=PRINT
	CNZ	5	;A=1, REPORT S-
	POP	PSW	;RESTORE FLAGS
	CZ	PRZV	;S+, SAVE SYSTEM CHANGES
;
;
STEP3:	LHLD	OPT	;GET OPTIONS
	SHLD	?OPT	;SET DRIVER FLAGS
	LDA	AREA	;GET LOCATE FLAG
	STA	OFFSET	;SAVE FLAG
	LDA	STRKS	;GET SPOOL TRACKS
	STA	TRKMIN	;SAVE NUMBER
;
;	STEP 4	RELOCATE DRIVER CODE UNDER CCP
;	RELOC = BASE WHERE DRIVER WILL GO
;	?BDOS = BASE OF DRIVER CODE
;	?BDOS+LENGTH = REL. BIT TABLE
;
	LHLD	LENGTH	;GET MODULE LENGTH
	MOV	B,H	;INTO BC
	MOV	C,L
	LHLD	RELOC	;HL=BASE OF REL. CODE
	PUSH	H	;SAVE DEST FOR ENTRY WHEN RELOC IS DONE
	LXI	D,SERIAL;POINTER TO CODE ORG'ED FOR 0

MOVREL: PUSH	B	;SAVE LENGTH
	PUSH	H	;SAVE DEST
MOVE:	LDAX	D	;GET A BYTE FROM CODE 1 IMAGE
	MOV	M,A	;MOVE TO DEST
	INX	D	;BUMP CODE 1 POINTER
	INX	H	;BUMP DEST POINTER
	DCX	B	;MOVED WHOLE THING YET?
	MOV	A,B
	ORA	C
	JNZ	MOVE

	POP	H	;GET DEST BACK
	POP	B	;GET LENGTH BACK
	PUSH	D	;PUSH BASE OF RELTBL
	MOV	D,H	;BIAS IN REG D
NEWBYT: XTHL		;GET RELOC TBL ADR
	MOV	E,M	;KEEP A REL BYTE IN REG E
	INX	H	;BUMP RELOC TBL POINTER
	XTHL		;PUT TBL PTR BACK
RELBYT: MOV	A,E	;GET RELOC BYTE
	RLC		;MOVE A BIT INTO CARY
	MOV	E,A	;SAVE THE REST OF THE RELOC BITS
	JNC	NOREL	;BIT WAS 0, DON'T RELOCATE THIS BYTE
	MOV	A,D	;GET BIAS TO ADD
	ADD	M	;ADD TO BYTE FROM DEST
	MOV	M,A
NOREL:	INX	H	;BUMP DEST POINTER
	DCX	B	;DONE WITH ALL BYTES?
	MOV	A,B
	ORA	C
	JZ	MVDONE	;YUP - VECTOR TO REL BASE
	MOV	A,L	;NOPE - TEST IF AT 8 BYTE BOUNDRY
	ANI	7	;IF SO, TIME FOR A NEW BYTE FROM TABLE
	JNZ	RELBYT	;NOT AT BOUNDRY
	JMP	NEWBYT	;AT A BOUNDRY
;
;	STEP 5		;
;
MVDONE:	POP	B	;CLEAN STACK
	LXI	H,STEP6
	XTHL		;SAVE ON STACK
	LDA	BASE	;A=BASE PORT
	PCHL		;INSTALL DRIVER

;	STEP 6	CHECK LOCAL SWITCHES
;
;	CHECK IF Z+
;
STEP6:	LDA	ZFLAG	;GET OPTION FLAGS
	CPI	'+'
	CZ	INIZ	;AUTO ZERO?
;
;	CHECK IF B-
;
	LDA	OPT	;GET OPTIONS
	ANI	01000000B
	CNZ	HYPER	;CREATE WARMBOOT.COM
;
;	REPORT DISK NOW ACTIVE
;
	MVI	C,13	;C=RESET CP/M SYSTEM
	CALL	5	;PASS TO BDOS
	LDA	ME	;GET DRIVE #
	ADI	'A'	;MAKE ASCII
	STA	PRI	;SAVE IN SIGON STRING
	LXI	D,MSG	;REPORT ACTIVE
;
;	PRINT TEXT & RESTORE STACK
;
EXIT1:	MVI	C,9
	CALL	5
EXIT2:	LHLD	STACK1	;HL=STACK POINTER OF CP/M
	SPHL		;RESTORE STACK
	LDA	REMOPT	;GET R FLAG
	ORA	A	;TEST IT
	JNZ	0	;WARM BOOT IF TRUE
	RET		;BACK TO CP/M
;
;	CHECK IF LOGED INTO SemiDisk
;
LEGAL:	PUSH	H	;SAVE TEXT PONTER
	CALL	HUNT	;HUNT FOR BDOS BASE
	XCHG		;DE=DRIVER BASE
	POP	H	;RESTORE TEXT POINTER
	RNZ		;LOGGED INTO SemiDisk?
;
; DRIVER IS LOADED
; CHECK IF ACTIVE UNIT
;
	LDA	4	;GET CURRENT DISK #
	ANI	15	;STRIP USER CODE NUMBER
	MOV	B,A	;SAVE DRIVE
	MVI	E,12H	;DE=?ME
	LDAX	D	;GET SemiDisk DRIVE CODE
	ANI	15	;STRIP USER CODE NUMBER
	CMP	B	;ARE WE ACTIVE?
	RNZ		;NOPE
	MOV	A,M	;GET OPTION
	STA	INVALI2 ;SHOVE INTO ERROR TEXT
	LXI	D,INVALI1
	JMP	EXIT1	;	
;
; RETURN DE=DRIVER ADDR (RELOCATED)
;
HUNT:	LDA	AREA	;GET LOCATE FLAG
	ORA	A	;TEST IT
	JZ	HUNT1	;DRIVER ABOVE CP/M
;
;	DRIVER  ABOVE  CP/M
;
	LDA	AREA+1	;GET ADDR
	MOV	D,A	;INTO D
	MVI	E,0	;DE=LOAD BASE (XX00H)
	MOV	H,D	;COPY TO H
	JMP	HUNT2	;LOADED?
;
;	DRIVER  BELOW  CP/M
;
HUNT1:	LHLD	6	;GET BASE OF BDOS
	LXI	D,-806H ;DE=OFFSET FROM BDOS TO CCP
	DAD	D	;HL=BASE OF CCP
	XCHG		;SWAP TO DE
	LHLD	LENGTH	;HL=LENGTH OF DRIVER MODULE
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	XCHG		;DE= -OFFSET
	DAD	D
	XCHG		;DE=LOAD BASE (XX00H)
	LHLD	6	;GET BASE OF BDOS
;
;	NOW CHECK IF DRIVER WAS EVER LOADED
;
HUNT2:	MVI	L,13H	;HL=LOADED FLAGS (BASE+5)
	MOV	A,M	;GET HIGH
	CPI	051H	;FOUND LOADED FLAG?
	RNZ		;NOPE,COLD RELOAD OPERATION!
	INX	H	;BASE+6
	MOV	A,M
	CPI	06DH	;FOUND LOADED FLAG?
	RET		;NOPE,COLD RELOAD OPERATION!
;
;	RETURN SYSTEM SIZE IN REG L
;	L=0 IF INVALID BOARD ADDRESS
;
FNDSIZ: MVI	L,BOARD	;L=NUMBER OF BOARDS/ROWS
	MVI	A,TOPS	;A=LAST SECTOR ALLOWED
AUTOM:	PUSH	PSW	;SAVE IT
	CALL	MEMTST	;FOUND VALID SECTOR?
	JZ	AUTOF	;YES,RETURN REG L=BOARD NUMB
	POP	PSW	;GET LAST SECTOR#
	SUI	SECSIZ	;DOWN A SECTOR
	DCR	L	;DOWN A BOARD
	JNZ	AUTOM	;LOOP NEXT
	RET		;RETURN REG L =0
;
;	RETURN L=BOARD#, A=SECTOR/ROW#
;
AUTOF:	POP	PSW
	RET
;
SIZE:	CALL	FNDSIZ	;FIND SIZE
	JMP	SIZE2	;DISPLAY IT
SIZE1:	LDA	OPT	;GET LAST SIZE BUILT
	ANI	0000$1111B
	INR	A	;ADD ONE
	MOV	L,A	;INTO L
SIZE2:	MVI	H,0	;CLEAR H
	DAD	H	;*2
	DAD	H	;*4
	DAD	H	;*8
	LXI	D,SGN0-8;BASE OF SIZE DISPLAY TABLE
	DAD	D	;HL=BASE OF TEXT
	XCHG		;DE=HL
SHOWIT: CALL	PRINT1	;DISPLAY SYSTEM
	LXI	D,SIGNON;SIGON TEXT
	JMP	PRINT1	;AND RETURN
;
COPY:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	COPY
	RET
;
HYPER:	LDA	AREA	;GET LOCATE FLAG
	ORA	A	;SET?
	RNZ		;YES, SKIP B-
	LXI	D,FCB1	;POINT TO FCB
	LDA	ME	;GET UNIT CODE
	INR	A	;CONVERT INTO CP/M DRIVE
	STAX	D	;INTO FCB
	PUSH	D	;SAVE PNTR
	MVI	C,17	;SEARCH FIRST
	CALL	5
	POP	D	;RESTORE PNTR
	INR	A
	RNZ		;FILE FOUND
	PUSH	D	;SAVE PNTR
	MVI	C,22	;MAKE FILE
	CALL	5
	POP	D	;RESTORE PNTR
	INR	A
	JZ	OERROR	;OPEN ERROR
	XRA	A	;CLEAR ACC
	STA	FCB1+32 ;CR=0
	PUSH	D	;SAVE PNTR
	LXI	D,FAST	;FAST RELOAD
	MVI	C,26	;SET DMA
	CALL	5
	POP	D	;RESTORE PNTR
	PUSH	D	;SAVE PNTR
	MVI	C,21	;WRITE SECTOR
	CALL	5
	POP	D	;RESTORE PNTR
	INR	A
	JZ	WERROR	;WRITE ERROR
	PUSH	D	;SAVE PNTR
	MVI	C,16	;CLOSE FILE
	CALL	5
	POP	D
	INR	A
	JZ	CERROR	;CLOSE ERROR
	MVI	A,'C' OR 128
	STA	FCB1+9
	MVI	C,30	;SET ATTR
	CALL	5
	LXI	D,80H	;FAST RELOAD
	MVI	C,26	;SET DMA
	CALL	5
	RET
;
FCB1:	DB	0	;DRIVE
	DB	'WARMBOOT'
	DB	'C'
	DB	'O' OR 128
	DB	'M'
	DW	0,0,0,0
	DW	0,0,0,0
	DW	0,0,0,0
	DW	0,0
FAST:	DB	02AH,039H,000H	;LHLD 39H
	DB	02EH,013H	;MVI L,13H
	DB	07EH,0FEH,051H	;MOV A,M : CPI 51H
	DB	0C2H,01AH,001H	;JNZ ERROR
	DB	023H
	DB	07EH,0FEH,050H	;MOV A,M : CPI 50H
	DB	0C2H,01AH,001H	;JNZ ERROR
	DB	036H,06DH	;MVI M,6DH
	DB	02EH,006H	;MVI L,6H
	DB	022H,006H,000H	;SHLD 6H
	DB	0C9H		;RET
	DB	011H,022H,001H	;ERROR: LXI D,TEXT
	DB	00EH,009H	;MVI C,9H
	DB	0C3H,005H,000H	;JMP 5H
	DB	'SemiDisk warm boot error.'
	DB	'	REBOOT CP/M$'
;
PRZV:	MVI	C,13	;C=RESET CP/M SYSTEM
	CALL	5	;PASS TO BDOS
	LDA	4	;GET CURRENT DISK
	ANI	15	;STRIP USER NUMBER
	MOV	E,A	;INTO REG E
	MVI	C,14	;C=SELECT DISK
	CALL	5	;SELECT DISK UNIT
;
	XRA	A	;GET A=00
	STA	UPDATE	;CLEAR UPDATE FLAG
	LXI	D,PAUSE ;PLEASE WAIT
	CALL	PRINT1
;
	LXI	D,FCB	;POINT TO FCB
	MVI	C,15	;OPEN FILE
	CALL	5	;
	INR	A	;OPEN ERROR?
	JZ	OERROR	;YES
	XRA	A	;CLEAR ACC
	STA	FCB+32	;SET CURRENT RECORD=0
	STA	FCB+35	;CLEAR OVERFLOW
	LXI	H,1	;RANDOM RECORD 1
	SHLD	FCB+33	;SET RANDOM RECORD
;
	LXI	D,180H
	MVI	C,26	;SET DMA
	CALL	5
	LXI	D,FCB	;POINT TO FCB
	MVI	C,34	;WRITE RANDOM
	CALL	5	;
	PUSH	PSW
	LXI	D,80H
	MVI	C,26	;SET DMA
	CALL	5
	POP	PSW
	ORA	A
	JNZ	WERROR	;WRITE ERROR
;
	LXI	D,FCB	;POINT TO FCB
	MVI	C,16	;CLOSE FILE
	CALL	5	;
	INR	A	;CLOSE ERROR?
	RNZ
;
OERROR:			;OPEN
WERROR:			;WRITE
CERROR:			;CLOSE
	LXI	D,UPERR ;REPORT UPDATE ERROR
	JMP	PRINT1
;
;	ZERO SEMIDISK BOARD
;
INIZ:	LDA	REMOPT+1
	CPI	1
	JZ	INIZ1
	XRA	A	;A=ZERO
	CALL	SET$T	;SET TRACK#
	CALL	SET$S	;SET SECTOR#
	CALL	GET	;CHECK FOR BOARD CLEARED
	CPI	080H	;EMPTY FLAG
	RZ		;ALREADY FORMATTED?
;
INIZ1:	LDA	DRV$VER	;GET DRIVER CODE
	ANI	0010$0000B
	JZ	INIZ2	;SemiDisk QX10?
	LXI	H,8192
	MVI	C,128

INIZ1F:	MVI	M,0EDH	;Z80 OUT (C),R CODE
	INX	H
	MVI	M,079H	;R=ACC.
	INX	H
	MVI	M,004H	;INR B
	INX	H
	DCR	C	;COUNT IT
	JNZ	INIZ1F	;NOT DONE?
	MVI	M,RET	;8080 RETURN CODE INTO ACC
	LDA	BASE	;GET PORT #
	STA	IN$PP	;PATCH CODE
	JMP	INIZ3	
;
INIZ2:	LXI	H,8192
	MVI	C,128
	LDA	BASE	;GET PORT #
INIZ2F:	MVI	M,OUT	;8080 OUTPUT CODE
	INX	H
	MOV	M,A	;AND PORT NUMBER
	INX	H
	DCR	C	;COUNT IT
	JNZ	INIZ2F	;NOT DONE?
	MVI	M,RET	;8080 RETURN CODE INTO ACC
;
INIZ3:	LDA	OPT	;GET SYSTEM SIZE
	ANI	0000$1111B
	MVI	D,0
	MOV	E,A
	LXI	H,MODTAB
	DAD	D
	MOV	A,M
	STA	ZFLG	;SET FLAGS
	LXI	D,ZWAIT ;TELL USER TO WAIT
	CALL	PRINT1
;
;	CLEAR PARITY TRACKS
	MVI	B,0	;FIRST TRACK
	MVI	C,1	;LAST TRACK
	MVI	H,080H	;FILL DATA
	CALL	TLOOP	;TRACK FILL LOOP
;
;	CLEAR DATA TRACKS
	MVI	B,2	;FIRST TRACK
	MVI	C,255	;LAST TRACK
	MVI	H,0E5H	;FILL DATA
;
;	TRACK FILL LOOP
TLOOP:	MOV	A,B	;GET TRACK #
	CALL	SET$T	;SET TRACK#
	MVI	L,0	;ZERO SECTOR NUMBER
SLOOP:	MOV	A,L	;GET SECTOR #
	CALL	SET$S	;SET SECTOR#
;
	PUSH	B
	XRA	A
	CALL	SET$B	;SET BYTE#
	MOV	A,H	;GET FILL DATA
IN$PP	EQU	$+1
	MVI	C,SEMI$DATA
	CALL	8192	;ERASE SECTOR
	POP	B	;RESTORE B&C
;
ZFLG:	EQU	$+1
	MVI	A,00	;SECTOR TEST FLAG
	CMP	L	;LAST SECTOR WRITEN
	JZ	SYES	;YES
	INR	L	;NOPE
	JMP	SLOOP	;FILL NEXT SECTOR
SYES:	MOV	A,B	;A=CURRENT TRACK #
	CMP	C	;LAST TRACK DONE
	RZ		;YES
	ANI	15	;TRACK MOD 16
	JNZ	SNZR	;TRACK NOT AT BOUNDARY
	PUSH	H	;SAVE HL
	PUSH	D	;SAVE DE
	PUSH	B	;SAVE BC
	MVI	C,2	;OUTPUT COMMAND
	MVI	E,'.'	;DOT EVERY 16 TRACKS
	CALL	5	;SEND TO BDOS
	POP	B	;RESTORE BC
	POP	D	;RESTORE DE
	POP	H	;RESTORE HL
SNZR:	INR	B	;NOPE
	JMP	TLOOP	;FILL NEXT TRACK
;
;
RELDSK:	CALL	PRINT1
ASKUSR: LXI	D,WHERE ;GET WHERE TO PUT IT MSG
	CALL	PRINT1
;
;	LOAD INPUT BUFFER
;
	LXI	H,0
	SHLD	BUF+2
	LXI	D,BUF
	MVI	C,10	;READ BUFFER CMD.
	CALL	5	;PASS TO BDOS
	LXI	D,BUF+2 ;DE=BUFFER BASE
;
;	CONVERT INPUT BUFFER
;	INTO DECIMAL (HL)
;
GETDEC:	LXI	H,LENGTH+2
GD0:	LDAX	D	;GET CHAR
	ORA	A	;EOC?
	JZ	GD1	;YES
	CPI	'/'	;EOC?
	JZ	GD1	;YES
	CPI	' '	;EOC?
	JZ	GD1	;YES
	CPI	'D'	;HEX?
	JZ	GD1	;YES
	CPI	'H'	;DECIMAL?
	JZ	GD2	;YES
	MOV	M,A	;INTO BUFFER
	INX	H
	INX	D
	JMP	GD0	;NEXT

GD1:	MVI	M,0	;END MARKER
	PUSH	D	;DE=SCAN
	LXI	D,LENGTH+2
	LXI	H,0	;CLEAR HL
GDEC0:	LDAX	D	;GET DATA
	ORA	A	;SET FLAGS
	JZ	GDEC1	;END OF BUFFER?
	INX	D	;DE+1
	SUI	'0'	;STRIP ASCII BIAS
	CPI	10	;NOT A DIGIT?
	JNC	GDEC1	;END OF CONVERT
	DAD	H
	MOV	C,L
	MOV	B,H
	DAD	H
	DAD	H
	DAD	B
	ADD	L
	MOV	L,A
	JNC	GDEC0	;READ IF NOT OVERFLOW
	INR	H	;FIX OVERFLOW
	JMP	GDEC0
GDEC1:	POP	D	;DE=SCAN
	RET		;HL=VALUE

GD2:	MVI	M,0	;END MARKER
	PUSH	D	;DE=SCAN
	LXI	D,LENGTH+2
	LXI	H,0	;CLEAR HL
GHEX0:	LDAX	D	;READ CHAR
	ORA	A	;EOB?
	JZ	GHEX1	;YES
	INX	D
	CPI	'9'+1	;0-9?
	JC	DIG	;YES
	SUI	'A'	;A-F
	JC	GHEX1	;OVERFLOW
	CPI	'F'-'A'+1
	JNC	GHEX1	;OVERFLOW
	ADI	10
	DB	1
DIG:	SUI	'0'
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ORA	L
	MOV	L,A
	JMP	GHEX0
GHEX1:	POP	D	;DE=SCAN
	RET		;HL=VALUE
;
;
NFOUND: LXI	D,BAD1	;SEMIDISK NOT ADDRESSED
	CALL	RELDSK	;READ & CONVERT BUFFER
;
;	TEST FOR LEGAL PORT NUMBER
;
ENDRD:	XRA	A	;CLEAR ACC.
	CMP	H	;H MUST BE = 000
	JNZ	REL1	;RE-ASK USER
	MOV	A,L	;GET BASE PORT #
	CPI	248+1	;CHECK FOR I/O WRAP OVER
	JNC	REL1	;RE-ASK USER
	ANI	3	;CHECK FOR EVEN BASE
	JZ	REL2	;RE-ASK USER
REL1:	LXI	D,ODD	;ODD ADDRESS ERROR
	CALL	RELDSK	;REPORT ERROR
	JMP	ENDRD	;CHECK ANSWER
REL2:	MOV	A,L	;FIX DATA PORTS
	STA	BASE	;SET BASE PORT
;
SLF:	PUSH	D	;SAVE D&E
	MVI	E,LF	;SEND OUT LINE FEED
	MVI	C,2	;CONSOLE TYPE CMMD
	CALL	5	;CALL BDOS
	POP	D	;RESTORE D&E
	RET
;
SCAN:	MOV	A,M	;GET SCAN FROM MEMORY
	ORA	A	;TEST FOR END-OF-LINE
	STC		;SET CARRY=TRUE
	RZ		;END-OF-LINE FOUND
	CPI	'/'	;CHECK FOR "/"
	JNZ	SCAN0	;NOT FOUND
SCANB:	INX	H	;ADVANCE SCAN POINTER
	JMP	SCAN	;AND TEST FOR END-OF-LINE
SCAN0:	CPI	' '	;CHECK FOR " "
	JZ	SCANB	;AND ADVANCE SCAN POINTER IF MATCH
SCAN1:	LXI	D,CMDTBL
	LDAX	D	;GET COMMAND FROM TABLE
	ORA	A	;TEST FOR END-OF-TABLE
	RZ		;EXIT IF END OF TABLE
	INX	D	;BUMP COMMAND POINTER +1
	CMP	M	;COMMAND=INPUT SWITCH?
	JZ	SCAN2	;YES
	INX	D	;NOPE, BUMP COMMAND POINTER +1
	INX	D	;BUMP COMMAND POINTER +1
	JMP	SCAN1+3 ;AND TRY FOR NEXT COMMAND
SCAN2:	PUSH	H	;SAVE SCAN POINTER
	XCHG		;DE=SCAN POINTER,HL=XXX
	MOV	A,M	;GET LOW ADDR OF HANDLER
	INX	H
	MOV	H,M	;GET HIGH ADDR OF HANDLER
	MOV	L,A	;HL=COMMAND HANDLER
	XTHL		;RESTORE SCAN POINTER
	RET
;
PMSET:	INX	H	;SCAN POINTER +1
	MOV	A,M	;GET +/- SWITCH
	CPI	'-'	;IS IT OFF (-)
	JNZ	MSET	;NOPE
PSET:	LDA	OPT	;GET SWITCH FLAGS
	ORA	B	;SET BIT ON
SSET:	STA	OPT	;SAVE SWITCH SETTING
	RET		;DECODE NEXT SWITCH
MSET:	CPI	'+'	;IS IT ON (+)
	JNZ	NSET	;NOPE
BOFF:	CALL	PSET	;SET BIT ON
	XRA	B	;CMA BIT
	JMP	SSET	;AND SAVE SWITCH SETTING
NSET:	DCX	H	;BACK UP SCAN POINTER
	RET		;AND TRY TO DECODE SWITCH
;
;	'MEMTST' TEST SemiDisk SECTOR WITHOUT CHANGING DATA
;
MEMTST: PUSH	PSW	;SAVE SECTOR#
	XRA	A	;ACC=0
	CALL	SET$T	;SET TRACK#
	POP	PSW	;RESTORE SECTOR#
	CALL	SET$S	;SET SECTOR#
	CALL	GET	;
	MOV	C,A	;C=DATA READ FROM SEMIDISK
	PUSH	B
	MVI	A,0E5H	;TEST CODE BYTE
	CALL	PUT	;
	CALL	GET	;
	CPI	0E5H	;VALID DATA?
	POP	B	;C=OLD DATA
	PUSH	PSW	;SAVE FLAGS
	MOV	A,C	;A=OLD DATA
	CALL	PUT	;
	POP	PSW	;GET TEST FLAG BACK
	RET
;
PUT:	PUSH	B	;SAVE B&C
	PUSH	PSW	;SAVE DATA BYTE
	XRA	A	;A=ZERO
	CALL	SET$B	;BYTE POINTER =0
	JZ	PUT$1	;SKIP QX10 CODE
	POP	PSW	;GET DATA BYTE
IPP$X1	EQU	$+1
	MVI	C,SEMI$DATA
	DB	0EDH,079H
	POP	B	;RESTORE B&C
	RET
PUT$1:	POP	PSW	;GET DATA BYTE
IPP$1	EQU	$+1
	OUT	SEMI$DATA
	POP	B	;RESTORE B&C
	RET

GET:	PUSH	B	;SAVE B&C
	XRA	A	;A=ZERO
	CALL	SET$B	;BYTE POINTER =0
	JZ	GET$1	;SKIP QX10 CODE
IPP$X2	EQU	$+1
	MVI	C,SEMI$DATA
	DB	0EDH,078H
	POP	B	;RESTORE B&C
	RET
IPP$2	EQU	$+1
GET$1:	IN	SEMI$DATA
	POP	B	;RESTORE B&C
	RET
;
; KILLS REG B ON EXIT
;
SET$B:	MOV	B,A
	LDA	DRV$VER	;GET DRIVER CODE
	ANI	00100000B
	RNZ		;SemiDisk QX10?
	MOV	A,B	;RESTORE BYTE COUNTER
IPP$3	EQU	$+1
	OUT	SEMI$BYTE
	RET

IPP$4	EQU	$+1
SET$T:	OUT	SEMI$TRACK
	RET

SET$S:	PUSH	PSW	;SAVE SECTOR #
	LDA	DRV$VER	;GET DRIVER CODE
	ANI	00100000B
	JZ	SET$S1	;SemiDisk QX10?
	POP	PSW	;GET SECTOR #
;	CMA		;INVERT IT
	PUSH	PSW	;SAVE FOR NEXT INST.
SET$S1:	POP	PSW	;RESTORE SECTOR #
IPP$5	EQU	$+1
	OUT	SEMI$SECTOR
	RET
;
;-----------------------;
;
;	THIS IS THE COMMAND TABLE
;
CMDTBL: DB	':'	;DISK SELECT
	DW	PDISK
	DB	'A'	;SEMIDISK ADDRESS
	DW	SDREL
	DB	'B'	;WARM BOOT
	DW	WBOOT
	DB	'L'	;LOCATE
	DW	LOCATE
	DB	'M'	;MAP DISABLE
	DW	MAP
	DB	'O'	;OPTION DISPLAY
	DW	OPTION
	DB	'P'	;PARITY
	DW	PARITY
	DB	'R'	;REMOVE DRIVER
	DW	REM
	DB	'S'	;SAVE
	DW	SAVE
	DB	'T'	;TRACKS
	DW	SPLTRK
	DB	'V'	;VERIFY
	DW	VERIFY
	DB	'W'	;WHO WROTE THIS
	DW	WHO
	DB	'Z'	;ZERO BOARD
	DW	ZAP
	DB	'?'	;HELP
	DW	HELP
	DW	0,0	;END-OF-COMMAND TABLE FLAG
;
;	FORMAT TABLE
;
	IF	MEG8
MODTAB: DB	15
	DB	31
	DB	47
	DB	63
	DB	79
	DB	95
	DB	111
	DB	127
	DB	143
	DB	159
	DB	175
	DB	191
	DB	207
	DB	223
	DB	239
	DB	255
	ELSE
MODTAB:	DB	1
	DB	3
	DB	5
	DB	7
	DB	9
	DB	11
	DB	13
	DB	15
	ENDIF
;
	IF	MEG8
;
;	DISK PARM TABLES
;	 (UP TO 8 MEG)
;
;	512K		BLOCK SIZE=2048
MEGTAB:	DW	16	;<SPT> Total number of sectors per track
	DB	4	;<BSH> Data allocation block shift factor
	DB	15	;<BLM> Block mask
	DB	1	;<EXM> Extent mask
	DW	252	;<DSM> Disk size-1
	DW	127	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	1. MEG		BLOCK SIZE=4096
	DW	32
	DB	5
	DB	31
	DB	3
	DW	252
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	1.5 MEG		BLOCK SIZE=4096
	DW	48
	DB	5
	DB	31
	DB	1
	DW	378
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	2.0 MEG		BLOCK SIZE=4096
	DW	64
	DB	5
	DB	31
	DB	1
	DW	505
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	2.5 MEG		BLOCK SIZE=4096
	DW	80
	DB	5
	DB	31
	DB	1
	DW	631
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	3.0 MEG		BLOCK SIZE=4096
	DW	96
	DB	5
	DB	31
	DB	1
	DW	758
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	3.5 MEG		BLOCK SIZE=4096
	DW	112
	DB	5
	DB	31
	DB	1
	DW	884
	DW	255
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	4.0 MEG		BLOCK SIZE=8192
	DW	128
	DB	6
	DB	63
	DB	3
	DW	505
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	4.5 MEG		BLOCK SIZE=8192
	DW	144
	DB	6
	DB	63
	DB	3
	DW	568
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	5.0 MEG		BLOCK SIZE=8192
	DW	160
	DB	6
	DB	63
	DB	3
	DW	631
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	5.5 MEG		BLOCK SIZE=8192
	DW	176
	DB	6
	DB	63
	DB	3
	DW	694
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	6.0 MEG		BLOCK SIZE=8192
	DW	192
	DB	6
	DB	63
	DB	3
	DW	758
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	6.5 MEG		BLOCK SIZE=8192
	DW	208
	DB	6
	DB	63
	DB	3
	DW	821
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	7.0 MEG		BLOCK SIZE=8192
	DW	224
	DB	6
	DB	63
	DB	3
	DW	884
	DW	511
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	7.5 MEG		BLOCK SIZE=16384
	DW	240
	DB	7
	DB	127
	DB	7
	DW	473
	DW	1023
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
;	8.0 MEG		BLOCK SIZE=16384
	DW	256
	DB	7
	DB	127
	DB	7
	DW	505
	DW	1023
	DB	192
	DB	0
	DW	0
	DW	2
	DB	0
	ELSE
;
;	DISK PARM TABLES
;	 (UP TO 512k)
;
;	64K		BLOCK SIZE=1024
MEGTAB:	DW	2	;<SPT> Total number of sectors per track
	DB	3	;<BSH> Data allocation block shift factor
	DB	7	;<BLM> Block mask
	DB	0	;<EXM> Extent mask
	DW	62	;<DSM> Disk size-1
	DW	63	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	128K		BLOCK SIZE=1024
	DW	4	;<SPT> Total number of sectors per track
	DB	3	;<BSH> Data allocation block shift factor
	DB	7	;<BLM> Block mask
	DB	0	;<EXM> Extent mask
	DW	125	;<DSM> Disk size-1
	DW	63	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	192K		BLOCK SIZE=1024
	DW	6	;<SPT> Total number of sectors per track
	DB	3	;<BSH> Data allocation block shift factor
	DB	7	;<BLM> Block mask
	DB	0	;<EXM> Extent mask
	DW	188	;<DSM> Disk size-1
	DW	63	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	256K		BLOCK SIZE=1024
	DW	8	;<SPT> Total number of sectors per track
	DB	3	;<BSH> Data allocation block shift factor
	DB	7	;<BLM> Block mask
	DB	0	;<EXM> Extent mask
	DW	252	;<DSM> Disk size-1
	DW	63	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	320K		BLOCK SIZE=2048
	DW	10	;<SPT> Total number of sectors per track
	DB	4	;<BSH> Data allocation block shift factor
	DB	15	;<BLM> Block mask
	DB	1	;<EXM> Extent mask
	DW	157	;<DSM> Disk size-1
	DW	127	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	384K		BLOCK SIZE=2048
	DW	12	;<SPT> Total number of sectors per track
	DB	4	;<BSH> Data allocation block shift factor
	DB	15	;<BLM> Block mask
	DB	1	;<EXM> Extent mask
	DW	188	;<DSM> Disk size-1
	DW	127	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	448K		BLOCK SIZE=2048
	DW	14	;<SPT> Total number of sectors per track
	DB	4	;<BSH> Data allocation block shift factor
	DB	15	;<BLM> Block mask
	DB	1	;<EXM> Extent mask
	DW	220	;<DSM> Disk size-1
	DW	127	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
;	512K		BLOCK SIZE=2048
	DW	16	;<SPT> Total number of sectors per track
	DB	4	;<BSH> Data allocation block shift factor
	DB	15	;<BLM> Block mask
	DB	1	;<EXM> Extent mask
	DW	252	;<DSM> Disk size-1
	DW	127	;<DRM> Total number of directory entries-1
	DB	192	;<AL0>
	DB	0	;<AL1>
	DW	0	;<CKS> Number of checked entries
	DW	2	;<OFF> Number of reserved tracks
	DB	0	;<fill byte> not part of CP/M
	ENDIF
;
FCB:	DB	0
	DB	'SEMIDISK'
	DB	'COM'
	DW	0,0,0,0
	DW	0,0,0,0
	DW	0,0,0,0
	DW	0,0
;
PAUSE:	DB	'Please wait.  $'
UPERR:	DB	CR,LF,'ERROR 1: Cannot update SEMIDISK.COM $'
ODD:	DB	CR,LF
	DB	CR,LF,'ERROR 2: Invalid base address$'
INVALID:DB	CR,LF,'ERROR 3: Invalid drive selected$'
INVALI1:DB	CR,LF,'ERROR 4: Cannot use "'
INVALI2:DB	'?" option when logged into SemiDisk$'
GONE1:	DB	CR,LF,'ERROR 5: SemiDisk driver not installed$'
WARN:	DB	CR,LF,'ERROR 6: CP/M Must be version 2.X$'
BAD1:	DB	CR,LF,'ERROR 7: SemiDisk NOT found/addressed.$'
	IF	MEG8
BAD2:	DB	CR,LF,'ERROR 8: SemiDisk not in configuration, Board $'
	ELSE
BAD2:	DB	CR,LF,'ERROR 8: SemiDisk not in configuration, Row $'
	ENDIF
SYNC:	DB	CR,LF,'ERROR 9: Driver not in SYNC with install$'
NOHB:	DB	CR,LF,'ERROR 10: HYPER-BOOT can not be disabled with'
	DB	' SemiDisk selected as drive A:.$'
WHERE:	DB	CR,LF
	DB	'Please enter a new SemiDisk base port, '
	DB	'from 0 to 248 decimal. ?$'
SURE:	DB	'Zero SemiDisk, are you sure <Yes/No> ?$'
ZWAIT:	DB	'Clearing SemiDisk$'
GONE:	DB	CR,LF,'SemiDisk driver removed$'
NOTPRM: DB	'S- option in effect.  This configuration is'
	DB	' not saved!'
	DB	CR,LF,'$'
;
;	HELP TEXT
;
HLP:	DB	CR,LF
	DB	LF
	DB	LF
	DB	'	SemiDisk Install Program Option Switches$'
HLP1:	DB	'	PAGE 1',CR,LF
	DB	LF
	DB	LF
	DB	LF
	DB	'Annn	Set SemiDisk base address.',CR,LF
	DB	'	nnn must be in decimal range 0-248',CR,LF
	DB	LF
	DB	'B+	Enable Hyper-Boot.',CR,LF
	DB	'	SemiDisk may be drive A:.',CR,LF
	DB	LF
	DB	'B-	Disable Hyper-Boot.',CR,LF
	DB	'	SemiDisk may not be drive A:.',CR,LF
	DB	'	WARMBOOT.COM created as a SYSTEM COMMAND on SemiDisk.',CR,LF
	DB	LF
	DB	'd:	Select default drive of SemiDisk.',CR,LF
	DB	'	If hyper-boot disabled, MUST be in the range of B: to O:',CR,LF
	DB	'	else if hyper-boot enabled, MUST be in the range of A: to O:',CR,LF
	DB	LF
	DB	'$'

HLP2:	DB	'	PAGE 2',CR,LF
	DB	LF
	DB	LF
	DB	LF
	DB	'V+	Enable read after write option',CR,LF
	DB	LF
	DB	'V-	Disable read after write option',CR,LF
	DB	LF
	DB	'P+	Enable parity error reporting.',CR,LF
	DB	LF
	DB	'P-	Disable parity error reporting.',CR,LF
	DB	LF
	DB	'R	Remove SemiDisk driver.',CR,LF
	DB	LF
	DB	'S+	Update SEMIDISK.COM with current options.',CR,LF
	DB	LF
	DB	'S-	Install SemiDisk without updating SEMIDISK.COM',CR,LF
	DB	'	S- MUST be the last option switch specified.',CR,LF
	DB	'$'

HLP3:	DB	'	PAGE 3',CR,LF
	DB	LF
	DB	LF
	DB	LF
	DB	'Z+	Enable Auto-Format.  Format the SemiDisk',CR,LF
	DB	'	when installed unless valid data found.',CR,LF
	DB	LF
	DB	'Z-	Disable Auto-Format.',CR,LF
	DB	LF
	DB	'M+	Enable disk mapping.  Use with multi-drive systems.'
	DB	CR,LF,LF
	DB	'M-	Disable disk mapping.  Use with single drive system.'
	DB	CR,LF,LF
	DB	'?n	Display help menus, n selects starting page.',CR,LF
	DB	'	Page number 4 is a quick reference guide.',CR,LF
	DB	LF
	DB	'W	Display who wrote this driver.',CR,LF
	DB	LF
	DB	'O	Display current option configuration.',CR
	DB	'$'

HLP4:	DB	'	PAGE 4',CR,LF
	DB LF
	DB LF
	DB LF
	DB 'Ann *	Set address		B+-  *	Hyper-Boot enable/disable',CR,LF
	DB 'Tnn *	Tracks for spooler	Lnn  *	Locate driver',CR,LF
	DB 'd:	SemiDisk select		P+-	Parity report enable/disable',CR,LF
	DB 'V+-	Verify enable/disable	Z+-	Auto-Format enable/disable',CR,LF
	DB '?n	Help menu display	S-   #	Disable update',CR,LF
	DB 'M+-	Disk mapping switch	R   *@	Remove SemiDisk',CR,LF
	DB 'W   @	Who wrote this		O    @	Option display',CR,LF
	DB	LF
	DB	LF
	DB	'	*	(This function cannot be used when logged into',CR,LF
	DB	'		the SemiDisk.)',CR,LF
	DB	LF
	DB	'	@	(This function will return to CP/M)',CR,LF
	DB	LF
	DB	'	#	(This MUST be the last command switch)',CR,LF
	DB	LF
	DB	'Standard configuration is: '
	DB	'SEMIDISK E:/ A128/ B+/ M+/ P+/ V-/ T1/ Z+ ',CR,LF
	DB	'$'
;
NPMSG:	DB	CR,LF
	DB	LF
	DB	LF
	DB	'	Press <RETURN> for next page. $'
Z80:	DB	'Z80 $'
I8080:	DB	'8080 $'
SD$I:	DB	'SemiDisk I$'
SD$II:	DB	'SemiDisk II$'
SD$QX10:DB	'SemiDisk QX10$'
SD$XXX:	DB	'GENERIC SemiDisk$'
SSM:	DB	' with SemiSpool$'
VERMSG: DB	CR,LF
	DB	'SemiDisk base='
DECBUF: DB	'???,'
	DB	'Spool tracks='
DECB1:	DB	'???,'
PFLG:	DB	'P?,'
BFLG:	DB	'B?,'
VFLG:	DB	'V?,'
ZFG:	DB	'Z?,'
MFLG:	DB	'M?$'
LMSG:	DB	',Driver located=$'
AMSG:	DB	',?:$'
;
	db	'?$',0,0,0,0,0,0
	IF	MEG8
SGN0:	db	'512k$',0,0,0
	db	'1.0 meg$'
	db	'1.5 meg$'
	db	'2.0 meg$'
	db	'2.5 meg$'
	db	'3.0 meg$'
	db	'3.5 meg$'
	db	'4.0 meg$'
	db	'4.5 meg$'
	db	'5.0 meg$'
	db	'5.5 meg$'
	db	'6.0 meg$'
	db	'6.5 meg$'
	db	'7.0 meg$'
	db	'7.5 meg$'
	db	'8.0 meg$'
	ELSE
SGN0:	db	'64k$',0,0,0,0
	db	'128k$',0,0,0
	db	'192k$',0,0,0
	db	'256k$',0,0,0
	db	'320k$',0,0,0
	db	'384k$',0,0,0
	db	'448k$',0,0,0
	db	'512k$',0,0,0
	ENDIF
;
SIGNON: DB	' SemiDisk (tm) install.	Version '
	DB	VER+'0','.',EXTECO,MODSLVL,CR,LF,'$'
MSG:	DB	CR,LF,'SemiDisk active '
PRI:	DB	'?:$'
;
RELOC:	DW	0	;WHERE DRIVER WILL GO
BIOS:	DW	0	;BASE OF USER BIOS
UPDATE: DB	0	;UPDATE FLAGS 'FLAG'
BUF:	DB	8	;2 RADIX+5 DIGITS + RETURN KEY
	DB	0	;ZERO LENGTH BYTE
	DW	0,0,0,0	;CLEAR BUFFER TO ZERO
	DW	0	;SAFETY SPACE
REMOPT: DW	0	;REMOVE DRIVER SWITCH
STACK1: DW	0	;CP/M STACK POINTER
STACK	EQU	8152	;STACK AT 8K-40 BYTES
;
XBASE:	ORG	1700h	;Allow 5.8k for the Install section

	DS	1
LENGTH: DS	2
	ORG	XBASE+100H
;
;	+++ BIOS SAVE TABLE
;
XB:	DS	2048
SERIAL: EQU	XB+00H	;SERIAL NUMBER
?OPT:	EQU	XB+11H	;OPTIONS BYTE
?ME:	EQU	XB+12H	;UNIT SELECT BYTE
?FLAG:	EQU	XB+13H	;LOADED FLAGS
DRV$VER EQU	XB+15H	;DRIVER VER#
OFFSET:	EQU	XB+16H	;LOCATED ABOVE BIOS FLAG
TRKMIN:	EQU	XB+17H	;FIRST SPOOL TRACK
DPB:	EQU	XB+18H	;DPB
@TBL:	EQU	XB+27H	;BIOS SAVE TABLE
;
	ORG	XBASE-100H	;DISPLAY DRIVER BIAS
	END	100H
