; z80dasm 1.1.6
; command line: z80dasm -a -l -g 0x00 -t -s PX4OSout.sym -S PX4OS.sym -r default -b PX4OSblkdat.txt -o PX4OS.dis2.asm PX4OS.BIN

	org	00000h
RBDOS1:	equ 0x0005
MELODY:	equ 0x6ec5
USERBIOS:	equ 0xef2d
ALRMSOND:	equ 0xef3e
ATSHUTOFF:	equ 0xef40
ATSOTIME:	equ 0xef41
ALRMMSTDS:	equ 0xef43
MENUFG:	equ 0xef44
MENUDRV:	equ 0xef45
FTYPETBL:	equ 0xef50
ALRMTP:	equ 0xef8a
ALRMAD:	equ 0xef8b
ALRMST:	equ 0xef8d
TIMER0:	equ 0xef8f
VERDFLT:	equ 0xefbe
BTRYFG:	equ 0xefee
YPFCMFLG:	equ 0xf017
YSFCMFLG:	equ 0xf018
BRKFLG:	equ 0xf019
CSTOPFLG:	equ 0xf01a
CTRLHELP:	equ 0xf0d1
SYSCTLR1:	equ 0xf279
TAPMOD:	equ 0xf2e1
DFTATR:	equ 0xf2e4
ALRMTIME:	equ 0xf308
FRCENTN:	equ 0xf311
IFRCECNT:	equ 0xf312
PRTFLG:	equ 0xf339
OPNMOD:	equ 0xf355
BIOSFN:	equ 0xf357
AUTOSTRT:	equ 0xf3bd
ALRMMSG:	equ 0xf3df
RIOBYTE:	equ 0xf529
BIOSERROR:	equ 0xf52b
OLDBNK:	equ 0xf52c
USRSBI:	equ 0xf535
CRGDEV:	equ 0xf53f
SAVEIX:	equ 0xf540
SAVEIY:	equ 0xf542
YLCOUNTRY:	equ 0xf777
YSIZERAM:	equ 0xf77a
TACATR:	equ 0xf7d1
RBDOS2:	equ 0xff90

COLDRST:
	nop			;0000	00 	. 
l0001h:
	jr OSTART		;0001	18 66 	. f 
l0003h:
	jp BDOSTABL		;0003	c3 0a 1c 	. . . 
l0006h:
	jp BIOSTBL		;0006	c3 ff 2a 	. . * 
l0009h:
	jp MTOSTBL		;0009	c3 56 5e 	. V ^ 
l000ch:
	jp MIOSTBL		;000c	c3 31 6b 	. 1 k 
l000fh:
	jp GOBACK		;000f	c3 37 29 	. 7 ) 
l0012h:
	jp SETERR		;0012	c3 94 1b 	. . . 
l0015h:
	jp RSTERR		;0015	c3 9b 1b 	. . . 
l0018h:
	jp CALADRS		;0018	c3 f8 04 	. . . 
l001bh:
	jp BIOSJTLD		;001b	c3 01 1b 	. . . 
l001eh:
	jp RAMDKMNT		;001e	c3 2e 36 	. . 6 
l0021h:
	jp MDFDPB		;0021	c3 83 04 	. . . 
l0024h:
	jp RAMCRFMT		;0024	c3 97 35 	. . 5 
sub_0027h:
	jp XMAKDIR		;0027	c3 7e 6a 	. ~ j 
sub_002ah:
	jp XMOUNT		;002a	c3 83 6a 	. . j 
sub_002dh:
	jp XREMOVE		;002d	c3 88 6a 	. . j 
	jp EPSSND		;0030	c3 94 4a 	. . J 
	jp ESPRCV		;0033	c3 9a 4a 	. . J 
	jp XREDSP		;0036	c3 6e 53 	. n S 
	jp XFONTGET		;0039	c3 50 4d 	. P M 
	jp XUSRSCRN		;003c	c3 31 59 	. 1 Y 
	jp XSETSCRN		;003f	c3 29 59 	. ) Y 
	jp XSETCUSR		;0042	c3 be 05 	. . . 
	jp XWTVRAM		;0045	c3 ad 05 	. . . 
	jp MELODY		;0048	c3 c5 6e 	. . n 
	jp WRT7508		;004b	c3 61 3c 	. a < 
	jp CMD7508		;004e	c3 6f 3c 	. o < 
	jp HSRST		;0051	c3 f8 46 	. . F 
	jp HSSCOM		;0054	c3 0d 47 	. . G 
l0057h:
	jp HSSDAT		;0057	c3 12 47 	. . G 
	jp HSRCV		;005a	c3 23 47 	. # G 
	jp HSSBL		;005d	c3 2c 47 	. , G 
	jp HSRBL		;0060	c3 3d 47 	. = G 
	jp HSRK		;0063	c3 52 47 	. R G 
	jp CHKMOD		;0066	c3 11 46 	. . F 
OSTART:
	di			;0069	f3 	. 
	ld sp,0fddbh		;006a	31 db fd 	1 . . 
	im 2		;006d	ed 5e 	. ^ 
	ld a,0ffh		;006f	3e ff 	> . 
	ld i,a		;0071	ed 47 	. G 
	call sub_0241h		;0073	cd 41 02 	. A . 
	call sub_4604h		;0076	cd 04 46 	. . F 
	ld a,(0f370h)		;0079	3a 70 f3 	: p . 
	dec a			;007c	3d 	= 
	jr z,l0089h		;007d	28 0a 	( . 
l007fh:
	call sub_0225h		;007f	cd 25 02 	. % . 
	ld hl,(0f373h)		;0082	2a 73 f3 	* s . 
	sbc hl,de		;0085	ed 52 	. R 
	jr nz,l00ceh		;0087	20 45 	  E 
l0089h:
	ld a,(0ef29h)		;0089	3a 29 ef 	: ) . 
sub_008ch:
	and 040h		;008c	e6 40 	. @ 
	jr nz,l00ceh		;008e	20 3e 	  > 
l0090h:
	ld c,002h		;0090	0e 02 	. . 
sub_0092h:
	call CMD7508		;0092	cd 6f 3c 	. o < 
	cp 0c0h		;0095	fe c0 	. . 
	jr c,l0090h		;0097	38 f7 	8 . 
	bit 3,a		;0099	cb 5f 	. _ 
	jr nz,l00ceh		;009b	20 31 	  1 
	and 0fbh		;009d	e6 fb 	. . 
	bit 4,a		;009f	cb 67 	. g 
	jr z,l00a5h		;00a1	28 02 	( . 
	or 004h		;00a3	f6 04 	. . 
l00a5h:
	and 007h		;00a5	e6 07 	. . 
l00a7h:
	ld hl,0f36fh		;00a7	21 6f f3 	! o . 
	sla a		;00aa	cb 27 	. ' 
l00ach:
	or (hl)			;00ac	b6 	. 
	inc hl			;00ad	23 	# 
	sla a		;00ae	cb 27 	. ' 
	or (hl)			;00b0	b6 	. 
	ld c,a			;00b1	4f 	O 
	ld (hl),001h		;00b2	36 01 	6 . 
	rrca			;00b4	0f 	. 
	rrca			;00b5	0f 	. 
	and 001h		;00b6	e6 01 	. . 
sub_00b8h:
	dec hl			;00b8	2b 	+ 
	ld (hl),a			;00b9	77 	w 
	ld hl,l066eh		;00ba	21 6e 06 	! n . 
sub_00bdh:
	ld b,000h		;00bd	06 00 	. . 
	add hl,bc			;00bf	09 	. 
l00c0h:
	ld a,(hl)			;00c0	7e 	~ 
	rrca			;00c1	0f 	. 
	jr c,l012fh		;00c2	38 6b 	8 k 
	rrca			;00c4	0f 	. 
	jp c,l01d6h		;00c5	da d6 01 	. . . 
	rrca			;00c8	0f 	. 
	jr c,l00fch		;00c9	38 31 	8 1 
l00cbh:
	jr l00fch		;00cb	18 2f 	. / 
l00cdh:
	pop af			;00cd	f1 	. 
l00ceh:
	ld hl,0f368h		;00ce	21 68 f3 	! h . 
	ld de,0f369h		;00d1	11 69 f3 	. i . 
	ld bc,l0c97h		;00d4	01 97 0c 	. . . 
	ld (hl),0efh		;00d7	36 ef 	6 . 
	ldir		;00d9	ed b0 	. . 
l00dbh:
	ld c,003h		;00db	0e 03 	. . 
	call WRT7508		;00dd	cd 61 3c 	. a < 
	ld a,006h		;00e0	3e 06 	> . 
	ld (0f371h),a		;00e2	32 71 f3 	2 q . 
	ld a,001h		;00e5	3e 01 	> . 
	ld (0f370h),a		;00e7	32 70 f3 	2 p . 
	call sub_023ch		;00ea	cd 3c 02 	. < . 
	ld c,008h		;00ed	0e 08 	. . 
sub_00efh:
	call CMD7508		;00ef	cd 6f 3c 	. o < 
	and 001h		;00f2	e6 01 	. . 
l00f4h:
	ld (0f36fh),a		;00f4	32 6f f3 	2 o . 
	call sub_0352h		;00f7	cd 52 03 	. R . 
	jr l0116h		;00fa	18 1a 	. . 
l00fch:
	call sub_08aeh		;00fc	cd ae 08 	. . . 
l00ffh:
	and 018h		;00ff	e6 18 	. . 
l0101h:
	xor 018h		;0101	ee 18 	. . 
	jr z,l00dbh		;0103	28 d6 	( . 
	ld a,(BTRYFG)		;0105	3a ee ef 	: . . 
l0108h:
	or a			;0108	b7 	. 
sub_0109h:
	jr z,l0111h		;0109	28 06 	( . 
	ld a,(0f310h)		;010b	3a 10 f3 	: . . 
l010eh:
	or a			;010e	b7 	. 
	jr z,l012fh		;010f	28 1e 	( . 
l0111h:
	ld c,003h		;0111	0e 03 	. . 
sub_0113h:
	call WRT7508		;0113	cd 61 3c 	. a < 
l0116h:
	ld a,005h		;0116	3e 05 	> . 
	ld (0f371h),a		;0118	32 71 f3 	2 q . 
l011bh:
	call sub_023ch		;011b	cd 3c 02 	. < . 
	call sub_0440h		;011e	cd 40 04 	. @ . 
	xor a			;0121	af 	. 
	ld (0ef29h),a		;0122	32 29 ef 	2 ) . 
l0125h:
	ld (0f52eh),a		;0125	32 2e f5 	2 . . 
	ld ix,0eb00h		;0128	dd 21 00 eb 	. ! . . 
	call 0ed15h		;012c	cd 15 ed 	. . . 
l012fh:
	ld a,001h		;012f	3e 01 	> . 
	ld (0f371h),a		;0131	32 71 f3 	2 q . 
l0134h:
	call sub_024eh		;0134	cd 4e 02 	. N . 
	ld a,b			;0137	78 	x 
	cp c			;0138	b9 	. 
sub_0139h:
	jr nz,l00dbh		;0139	20 a0 	  . 
	ld c,00ah		;013b	0e 0a 	. . 
	call CMD7508		;013d	cd 6f 3c 	. o < 
l0140h:
	ld c,a			;0140	4f 	O 
	ld a,(0f775h)		;0141	3a 75 f7 	: u . 
	xor c			;0144	a9 	. 
	and 080h		;0145	e6 80 	. . 
	jr z,l0156h		;0147	28 0d 	( . 
	ld hl,l7bd3h		;0149	21 d3 7b 	! . { 
	ld de,MENUDRV		;014c	11 45 ef 	. E . 
	ld bc,l0009h+2		;014f	01 0b 00 	. . . 
	ldir		;0152	ed b0 	. . 
	jr l0111h		;0154	18 bb 	. . 
l0156h:
	ld a,(BTRYFG)		;0156	3a ee ef 	: . . 
l0159h:
	push af			;0159	f5 	. 
	xor a			;015a	af 	. 
l015bh:
	ld (0ef29h),a		;015b	32 29 ef 	2 ) . 
	ld (0f4dch),a		;015e	32 dc f4 	2 . . 
	ld (BTRYFG),a		;0161	32 ee ef 	2 . . 
	ld (0f4ddh),a		;0164	32 dd f4 	2 . . 
	ld (PRTFLG),a		;0167	32 39 f3 	2 9 . 
	dec a			;016a	3d 	= 
	ld (0efd2h),a		;016b	32 d2 ef 	2 . . 
	call XUSRSCRN		;016e	cd 31 59 	. 1 Y 
	call sub_0346h		;0171	cd 46 03 	. F . 
	call sub_0474h		;0174	cd 74 04 	. t . 
	ld a,(0f310h)		;0177	3a 10 f3 	: . . 
	or a			;017a	b7 	. 
	jr z,l0192h		;017b	28 15 	( . 
	pop af			;017d	f1 	. 
	ld hl,(0ef3ah)		;017e	2a 3a ef 	* : . 
	call sub_6ec3h		;0181	cd c3 6e 	. . n 
	call sub_0339h		;0184	cd 39 03 	. 9 . 
	xor a			;0187	af 	. 
	ld (0f52eh),a		;0188	32 2e f5 	2 . . 
	ld ix,0eb03h		;018b	dd 21 03 eb 	. ! . . 
	call 0ed15h		;018f	cd 15 ed 	. . . 
l0192h:
	dec a			;0192	3d 	= 
	ld (0f310h),a		;0193	32 10 f3 	2 . . 
l0196h:
	pop af			;0196	f1 	. 
	or a			;0197	b7 	. 
l0198h:
	jr z,l01a4h		;0198	28 0a 	( . 
	ld a,(0ef93h)		;019a	3a 93 ef 	: . . 
	bit 2,a		;019d	cb 57 	. W 
	ld c,039h		;019f	0e 39 	. 9 
	call nz,WRT7508		;01a1	c4 61 3c 	. a < 
l01a4h:
	ld hl,(0ef3ch)		;01a4	2a 3c ef 	* < . 
l01a7h:
	call sub_6ec3h		;01a7	cd c3 6e 	. . n 
	call sub_3802h		;01aa	cd 02 38 	. . 8 
l01adh:
	ld hl,0f473h		;01ad	21 73 f4 	! s . 
	ld de,0efefh		;01b0	11 ef ef 	. . . 
	ld bc,l0003h+1		;01b3	01 04 00 	. . . 
	ldir		;01b6	ed b0 	. . 
	xor a			;01b8	af 	. 
	ld (0f371h),a		;01b9	32 71 f3 	2 q . 
	ld a,(0f53eh)		;01bc	3a 3e f5 	: > . 
	out (004h),a		;01bf	d3 04 	. . 
	ld sp,(0f36bh)		;01c1	ed 7b 6b f3 	. { k . 
	ld a,(0f36dh)		;01c5	3a 6d f3 	: m . 
	ld (0efd2h),a		;01c8	32 d2 ef 	2 . . 
	pop hl			;01cb	e1 	. 
	pop de			;01cc	d1 	. 
	pop bc			;01cd	c1 	. 
	pop af			;01ce	f1 	. 
	ex af,af'			;01cf	08 	. 
sub_01d0h:
	exx			;01d0	d9 	. 
	pop iy		;01d1	fd e1 	. . 
	pop ix		;01d3	dd e1 	. . 
sub_01d5h:
	ret			;01d5	c9 	. 
l01d6h:
	ld a,00ah		;01d6	3e 0a 	> . 
sub_01d8h:
	ld (0f4d9h),a		;01d8	32 d9 f4 	2 . . 
	ld a,001h		;01db	3e 01 	> . 
sub_01ddh:
	ld (0ef8eh),a		;01dd	32 8e ef 	2 . . 
	ld (ALRMST),a		;01e0	32 8d ef 	2 . . 
	call sub_027eh		;01e3	cd 7e 02 	. ~ . 
	call 0ffc0h		;01e6	cd c0 ff 	. . . 
	ld a,(ALRMTP)		;01e9	3a 8a ef 	: . . 
	inc a			;01ec	3c 	< 
	ld (0f371h),a		;01ed	32 71 f3 	2 q . 
	cp 003h		;01f0	fe 03 	. . 
	jr z,l021bh		;01f2	28 27 	( ' 
	ld hl,0ef29h		;01f4	21 29 ef 	! ) . 
	set 0,(hl)		;01f7	cb c6 	. . 
	push hl			;01f9	e5 	. 
	call sub_02b5h		;01fa	cd b5 02 	. . . 
l01fdh:
	xor a			;01fd	af 	. 
	ld (0f4dch),a		;01fe	32 dc f4 	2 . . 
l0201h:
	ld (BTRYFG),a		;0201	32 ee ef 	2 . . 
	ei			;0204	fb 	. 
	call sub_0a5ch		;0205	cd 5c 0a 	. \ . 
	di			;0208	f3 	. 
l0209h:
	pop hl			;0209	e1 	. 
	res 0,(hl)		;020a	cb 86 	. . 
	ld a,(0f4dch)		;020c	3a dc f4 	: . . 
l020fh:
	or a			;020f	b7 	. 
	jp nz,l0134h		;0210	c2 34 01 	. 4 . 
	call 0ffc3h		;0213	cd c3 ff 	. . . 
	ld c,0ffh		;0216	0e ff 	. . 
	jp l2ab7h		;0218	c3 b7 2a 	. . * 
l021bh:
	ld c,a			;021b	4f 	O 
	ld hl,(ALRMSOND)		;021c	2a 3e ef 	* > . 
	call MELODY		;021f	cd c5 6e 	. . n 
l0222h:
	jp l0134h		;0222	c3 34 01 	. 4 . 
sub_0225h:
	ld hl,0ef1fh		;0225	21 1f ef 	! . . 
	ld de,COLDRST		;0228	11 00 00 	. . . 
	ld bc,l0222h+2		;022b	01 24 02 	. $ . 
l022eh:
	ld a,d			;022e	7a 	z 
	add a,(hl)			;022f	86 	. 
sub_0230h:
	ld d,a			;0230	57 	W 
	inc hl			;0231	23 	# 
	ld a,e			;0232	7b 	{ 
	add a,(hl)			;0233	86 	. 
	ld e,a			;0234	5f 	_ 
	inc hl			;0235	23 	# 
	dec bc			;0236	0b 	. 
	ld a,b			;0237	78 	x 
	or c			;0238	b1 	. 
	jr nz,l022eh		;0239	20 f3 	  . 
	ret			;023b	c9 	. 
sub_023ch:
	ld a,009h		;023c	3e 09 	> . 
	ld (0f53eh),a		;023e	32 3e f5 	2 > . 
sub_0241h:
	ld a,002h		;0241	3e 02 	> . 
	ld (0f53dh),a		;0243	32 3d f5 	2 = . 
	out (005h),a		;0246	d3 05 	. . 
	ld a,0ffh		;0248	3e ff 	> . 
	ld (0f534h),a		;024a	32 34 f5 	2 4 . 
	ret			;024d	c9 	. 
sub_024eh:
	call sub_027eh		;024e	cd 7e 02 	. ~ . 
	ld a,(0f53eh)		;0251	3a 3e f5 	: > . 
	push af			;0254	f5 	. 
	xor a			;0255	af 	. 
	out (004h),a		;0256	d3 04 	. . 
	call sub_02b5h		;0258	cd b5 02 	. . . 
	call sub_33fch		;025b	cd fc 33 	. . 3 
sub_025eh:
	call sub_02dfh		;025e	cd df 02 	. . . 
	call sub_34dch		;0261	cd dc 34 	. . 4 
	or a			;0264	b7 	. 
	call sub_354bh		;0265	cd 4b 35 	. K 5 
	ld a,(0ef9ch)		;0268	3a 9c ef 	: . . 
	or a			;026b	b7 	. 
	call RAMDKMNT		;026c	cd 2e 36 	. . 6 
	ld c,a			;026f	4f 	O 
	ld a,(YSIZERAM)		;0270	3a 7a f7 	: z . 
	ld b,a			;0273	47 	G 
	push bc			;0274	c5 	. 
	call MDFDPB		;0275	cd 83 04 	. . . 
	pop bc			;0278	c1 	. 
	di			;0279	f3 	. 
	pop af			;027a	f1 	. 
	out (004h),a		;027b	d3 04 	. . 
	ret			;027d	c9 	. 
sub_027eh:
	ld a,009h		;027e	3e 09 	> . 
	out (004h),a		;0280	d3 04 	. . 
	ld a,(0f295h)		;0282	3a 95 f2 	: . . 
	out (008h),a		;0285	d3 08 	. . 
	ld a,006h		;0287	3e 06 	> . 
l0289h:
	out (00ah),a		;0289	d3 0a 	. . 
	ld a,043h		;028b	3e 43 	> C 
	out (00bh),a		;028d	d3 0b 	. . 
	ld a,(0f001h)		;028f	3a 01 f0 	: . . 
	out (000h),a		;0292	d3 00 	. . 
	xor a			;0294	af 	. 
	out (016h),a		;0295	d3 16 	. . 
	ld a,(0f005h)		;0297	3a 05 f0 	: . . 
	out (018h),a		;029a	d3 18 	. . 
	ld a,(0f006h)		;029c	3a 06 f0 	: . . 
	or 002h		;029f	f6 02 	. . 
	ld (0f006h),a		;02a1	32 06 f0 	2 . . 
	out (019h),a		;02a4	d3 19 	. . 
	ld a,(0f003h)		;02a6	3a 03 f0 	: . . 
l02a9h:
	out (015h),a		;02a9	d3 15 	. . 
l02abh:
	ld a,(0f004h)		;02ab	3a 04 f0 	: . . 
	out (016h),a		;02ae	d3 16 	. . 
	ld a,0ffh		;02b0	3e ff 	> . 
	out (017h),a		;02b2	d3 17 	. . 
	ret			;02b4	c9 	. 
sub_02b5h:
	in a,(010h)		;02b5	db 10 	. . 
	call sub_6b28h		;02b7	cd 28 6b 	. ( k 
	jr nz,l02d7h		;02ba	20 1b 	  . 
	call sub_6e5eh		;02bc	cd 5e 6e 	. ^ n 
	call sub_647ah		;02bf	cd 7a 64 	. z d 
	ld b,015h		;02c2	06 15 	. . 
	call z,sub_6afbh		;02c4	cc fb 6a 	. . j 
	ld a,(0f7c4h)		;02c7	3a c4 f7 	: . . 
	cp 048h		;02ca	fe 48 	. H 
	jr nz,l02d7h		;02cc	20 09 	  . 
	ld a,(0f371h)		;02ce	3a 71 f3 	: q . 
	cp 005h		;02d1	fe 05 	. . 
	call c,sub_6e4dh		;02d3	dc 4d 6e 	. M n 
	ret			;02d6	c9 	. 
l02d7h:
	ld a,(0efc0h)		;02d7	3a c0 ef 	: . . 
	or a			;02da	b7 	. 
l02dbh:
	call nz,sub_65efh		;02db	c4 ef 65 	. . e 
	ret			;02de	c9 	. 
sub_02dfh:
	ld hl,0f532h		;02df	21 32 f5 	! 2 . 
	ld a,(0ef97h)		;02e2	3a 97 ef 	: . . 
	and 030h		;02e5	e6 30 	. 0 
	or 080h		;02e7	f6 80 	. . 
l02e9h:
	ld (hl),a			;02e9	77 	w 
	inc hl			;02ea	23 	# 
	ld a,(0ef98h)		;02eb	3a 98 ef 	: . . 
	and 030h		;02ee	e6 30 	. 0 
l02f0h:
	or 0c0h		;02f0	f6 c0 	. . 
l02f2h:
	ld (hl),a			;02f2	77 	w 
	ret			;02f3	c9 	. 
sub_02f4h:
	ld a,0ffh		;02f4	3e ff 	> . 
	ld (0f310h),a		;02f6	32 10 f3 	2 . . 
	ld hl,0f530h		;02f9	21 30 f5 	! 0 . 
	ld (hl),000h		;02fc	36 00 	6 . 
	inc hl			;02fe	23 	# 
	ld (hl),040h		;02ff	36 40 	6 @ 
l0301h:
	call sub_1ab3h		;0301	cd b3 1a 	. . . 
	call sub_1aa7h		;0304	cd a7 1a 	. . . 
	call sub_024eh		;0307	cd 4e 02 	. N . 
	ld hl,l5dfeh		;030a	21 fe 5d 	! . ] 
l030dh:
	ld de,0e940h		;030d	11 40 e9 	. @ . 
	ld bc,l000ch		;0310	01 0c 00 	. . . 
	ldir		;0313	ed b0 	. . 
	ld c,01dh		;0315	0e 1d 	. . 
	call WRT7508		;0317	cd 61 3c 	. a < 
	ld bc,l0a29h		;031a	01 29 0a 	. ) . 
	ld hl,0ef93h		;031d	21 93 ef 	! . . 
l0320h:
	bit 2,(hl)		;0320	cb 56 	. V 
	jr z,l0327h		;0322	28 03 	( . 
	ld bc,l0e39h		;0324	01 39 0e 	. 9 . 
l0327h:
	call WRT7508		;0327	cd 61 3c 	. a < 
	ld (hl),b			;032a	70 	p 
	ld c,00ah		;032b	0e 0a 	. . 
	call CMD7508		;032d	cd 6f 3c 	. o < 
	ld (0f775h),a		;0330	32 75 f7 	2 u . 
l0333h:
	call sub_2d26h		;0333	cd 26 2d 	. & - 
	call 03a47h		;0336	cd 47 3a 	. G : 
sub_0339h:
	xor a			;0339	af 	. 
l033ah:
	ld (0f2aah),a		;033a	32 aa f2 	2 . . 
	ld hl,0eff3h		;033d	21 f3 ef 	! . . 
	call sub_0593h		;0340	cd 93 05 	. . . 
l0343h:
	call sub_59f9h		;0343	cd f9 59 	. . Y 
sub_0346h:
	ld hl,0efb6h		;0346	21 b6 ef 	! . . 
	ld (hl),080h		;0349	36 80 	6 . 
	ld a,(0f2a0h)		;034b	3a a0 f2 	: . . 
	or (hl)			;034e	b6 	. 
l034fh:
	out (009h),a		;034f	d3 09 	. . 
	ret			;0351	c9 	. 
sub_0352h:
	call sub_1b24h		;0352	cd 24 1b 	. $ . 
	call sub_02f4h		;0355	cd f4 02 	. . . 
l0358h:
	ld hl,0e940h		;0358	21 40 e9 	! @ . 
	ld bc,l00c0h		;035b	01 c0 00 	. . . 
	call sub_5986h		;035e	cd 86 59 	. . Y 
	call XSETSCRN		;0361	cd 29 59 	. ) Y 
	ld a,040h		;0364	3e 40 	> @ 
	ld (0ef29h),a		;0366	32 29 ef 	2 ) . 
	ei			;0369	fb 	. 
	ld hl,l068eh		;036a	21 8e 06 	! . . 
	call sub_0589h		;036d	cd 89 05 	. . . 
	ld bc,00219h		;0370	01 19 02 	. . . 
	ld d,00ch		;0373	16 0c 	. . 
	call sub_0548h		;0375	cd 48 05 	. H . 
	ld hl,0f447h		;0378	21 47 f4 	! G . 
	ld de,0f419h		;037b	11 19 f4 	. . . 
	call sub_1153h		;037e	cd 53 11 	. S . 
	ld hl,(0f419h)		;0381	2a 19 f4 	* . . 
	ld a,(0f41bh)		;0384	3a 1b f4 	: . . 
	ld (0f419h),a		;0387	32 19 f4 	2 . . 
	ld (0f41ah),hl		;038a	22 1a f4 	" . . 
	ld c,0ffh		;038d	0e ff 	. . 
	call sub_415dh		;038f	cd 5d 41 	. ] A 
	ld hl,l06beh		;0392	21 be 06 	! . . 
	call sub_0589h		;0395	cd 89 05 	. . . 
l0398h:
	ld bc,l030dh+1		;0398	01 0e 03 	. . . 
	ld d,001h		;039b	16 01 	. . 
	call sub_0548h		;039d	cd 48 05 	. H . 
	ld a,0ffh		;03a0	3e ff 	> . 
	ld hl,0f419h		;03a2	21 19 f4 	! . . 
	push hl			;03a5	e5 	. 
	ld bc,l0006h		;03a6	01 06 00 	. . . 
	call sub_598bh		;03a9	cd 8b 59 	. . Y 
	ld a,(0f447h)		;03ac	3a 47 f4 	: G . 
	and 00fh		;03af	e6 0f 	. . 
	ld (de),a			;03b1	12 	. 
	ld c,0ffh		;03b2	0e ff 	. . 
	pop de			;03b4	d1 	. 
	call sub_415dh		;03b5	cd 5d 41 	. ] A 
l03b8h:
	xor a			;03b8	af 	. 
	ld (0ef2ch),a		;03b9	32 2c ef 	2 , . 
	call RAMDKMNT		;03bc	cd 2e 36 	. . 6 
	jr c,l03c9h		;03bf	38 08 	8 . 
l03c1h:
	ld (YSIZERAM),a		;03c1	32 7a f7 	2 z . 
	ld (0ef96h),a		;03c4	32 96 ef 	2 . . 
	jr l03f1h		;03c7	18 28 	. ( 
l03c9h:
	ld hl,l06ceh		;03c9	21 ce 06 	! . . 
	call sub_0589h		;03cc	cd 89 05 	. . . 
l03cfh:
	ld hl,l3632h		;03cf	21 32 36 	! 2 6 
	ld bc,00417h		;03d2	01 17 04 	. . . 
	ld d,002h		;03d5	16 02 	. . 
	call sub_054bh		;03d7	cd 4b 05 	. K . 
	ld hl,0f444h		;03da	21 44 f4 	! D . 
	call sub_1783h		;03dd	cd 83 17 	. . . 
	jr c,l03c9h		;03e0	38 e7 	8 . 
	ld a,l			;03e2	7d 	} 
	ld (0ef2ch),a		;03e3	32 2c ef 	2 , . 
	ld (YSIZERAM),a		;03e6	32 7a f7 	2 z . 
	cp 001h		;03e9	fe 01 	. . 
	jr z,l03c9h		;03eb	28 dc 	( . 
	cp 024h		;03ed	fe 24 	. $ 
	jr nc,l03c9h		;03ef	30 d8 	0 . 
l03f1h:
	ld hl,l06eah		;03f1	21 ea 06 	! . . 
	call sub_0589h		;03f4	cd 89 05 	. . . 
	ld bc,l0517h		;03f7	01 17 05 	. . . 
	ld d,003h		;03fa	16 03 	. . 
	call sub_0548h		;03fc	cd 48 05 	. H . 
	ld hl,0f445h		;03ff	21 45 f4 	! E . 
l0402h:
	call sub_1783h		;0402	cd 83 17 	. . . 
	jr c,l03b8h		;0405	38 b1 	8 . 
	ld a,l			;0407	7d 	} 
l0408h:
	ld (USERBIOS),a		;0408	32 2d ef 	2 - . 
	call sub_052eh		;040b	cd 2e 05 	. . . 
l040eh:
	jr nc,l03b8h		;040e	30 a8 	0 . 
	di			;0410	f3 	. 
l0411h:
	call CALADRS		;0411	cd f8 04 	. . . 
	ld a,0c3h		;0414	3e c3 	> . 
	ld (0f368h),a		;0416	32 68 f3 	2 h . 
	ld (0f369h),bc		;0419	ed 43 69 f3 	. C i . 
	ld (0ef94h),bc		;041d	ed 43 94 ef 	. C . . 
	ld (0ef26h),de		;0421	ed 53 26 ef 	. S & . 
	ld (0ef24h),ix		;0425	dd 22 24 ef 	. " $ . 
	ld (0ef22h),iy		;0429	fd 22 22 ef 	. " " . 
	ld a,(0ef2ch)		;042d	3a 2c ef 	: , . 
	or a			;0430	b7 	. 
	call RAMDKMNT		;0431	cd 2e 36 	. . 6 
	ld hl,AUTOSTRT		;0434	21 bd f3 	! . . 
	call sub_164bh		;0437	cd 4b 16 	. K . 
	ld hl,ALRMMSG		;043a	21 df f3 	! . . 
	jp sub_164bh		;043d	c3 4b 16 	. K . 
sub_0440h:
	call sub_02f4h		;0440	cd f4 02 	. . . 
	call sub_052eh		;0443	cd 2e 05 	. . . 
	jp nc,l00cdh		;0446	d2 cd 00 	. . . 
	call CALADRS		;0449	cd f8 04 	. . . 
	push bc			;044c	c5 	. 
	push de			;044d	d5 	. 
	push ix		;044e	dd e5 	. . 
	push iy		;0450	fd e5 	. . 
	ld hl,(0ef94h)		;0452	2a 94 ef 	* . . 
	ld bc,(0ef26h)		;0455	ed 4b 26 ef 	. K & . 
	add hl,bc			;0459	09 	. 
	ld bc,(0ef24h)		;045a	ed 4b 24 ef 	. K $ . 
	add hl,bc			;045e	09 	. 
	ld bc,(0ef22h)		;045f	ed 4b 22 ef 	. K " . 
	add hl,bc			;0463	09 	. 
	ld b,004h		;0464	06 04 	. . 
l0466h:
	pop de			;0466	d1 	. 
	or a			;0467	b7 	. 
	sbc hl,de		;0468	ed 52 	. R 
	djnz l0466h		;046a	10 fa 	. . 
	ld a,h			;046c	7c 	| 
	or l			;046d	b5 	. 
	jp nz,l00cdh		;046e	c2 cd 00 	. . . 
	call MDFDPB		;0471	cd 83 04 	. . . 
sub_0474h:
	ld hl,0ef2bh		;0474	21 2b ef 	! + . 
	ld a,(0ef96h)		;0477	3a 96 ef 	: . . 
	or (hl)			;047a	b6 	. 
	ld (hl),000h		;047b	36 00 	6 . 
	ld (0ef96h),a		;047d	32 96 ef 	2 . . 
	jp l3735h		;0480	c3 35 37 	. 5 7 
MDFDPB:
	ld b,001h		;0483	06 01 	. . 
	ld de,0800fh		;0485	11 0f 80 	. . . 
l0488h:
	ld a,(0ef9dh)		;0488	3a 9d ef 	: . . 
	or a			;048b	b7 	. 
	jr z,l0493h		;048c	28 05 	( . 
	ld b,a			;048e	47 	G 
l048fh:
	ld e,01fh		;048f	1e 1f 	. . 
	jr l049ah		;0491	18 07 	. . 
l0493h:
	ld a,(0ef9ch)		;0493	3a 9c ef 	: . . 
	or a			;0496	b7 	. 
	jr z,l049ah		;0497	28 01 	( . 
	ld b,a			;0499	47 	G 
l049ah:
	ld a,b			;049a	78 	x 
	ld hl,0f205h		;049b	21 05 f2 	! . . 
	call sub_04f0h		;049e	cd f0 04 	. . . 
	ld a,e			;04a1	7b 	{ 
	ld (0f207h),a		;04a2	32 07 f2 	2 . . 
	ld a,d			;04a5	7a 	z 
	ld (0f209h),a		;04a6	32 09 f2 	2 . . 
	ld bc,0f223h		;04a9	01 23 f2 	. # . 
	ld hl,0f214h		;04ac	21 14 f2 	! . . 
	ld de,(0ef97h)		;04af	ed 5b 97 ef 	. [ . . 
	call sub_04c9h		;04b3	cd c9 04 	. . . 
	ld a,(0ef9bh)		;04b6	3a 9b ef 	: . . 
	ld hl,0f250h		;04b9	21 50 f2 	! P . 
	call sub_04f0h		;04bc	cd f0 04 	. . . 
	ld bc,0f26eh		;04bf	01 6e f2 	. n . 
	ld hl,0f25fh		;04c2	21 5f f2 	! _ . 
	ld de,(0ef99h)		;04c5	ed 5b 99 ef 	. [ . . 
sub_04c9h:
	push bc			;04c9	c5 	. 
	ld b,000h		;04ca	06 00 	. . 
l04cch:
	ld a,e			;04cc	7b 	{ 
	cp 080h		;04cd	fe 80 	. . 
	jr c,l04dbh		;04cf	38 0a 	8 . 
	ld a,d			;04d1	7a 	z 
	cp 080h		;04d2	fe 80 	. . 
l04d4h:
	jr nc,l04d7h		;04d4	30 01 	0 . 
	ld b,a			;04d6	47 	G 
l04d7h:
	ld a,e			;04d7	7b 	{ 
	and 07fh		;04d8	e6 7f 	.  
	add a,b			;04da	80 	. 
l04dbh:
	call sub_04f0h		;04db	cd f0 04 	. . . 
	ld b,000h		;04de	06 00 	. . 
	ld a,d			;04e0	7a 	z 
	cp 080h		;04e1	fe 80 	. . 
	jr c,l04efh		;04e3	38 0a 	8 . 
	ld a,e			;04e5	7b 	{ 
	cp 080h		;04e6	fe 80 	. . 
	jr nc,l04ebh		;04e8	30 01 	0 . 
	ld b,a			;04ea	47 	G 
l04ebh:
	ld a,d			;04eb	7a 	z 
	and 07fh		;04ec	e6 7f 	.  
	add a,b			;04ee	80 	. 
l04efh:
	pop hl			;04ef	e1 	. 
sub_04f0h:
	ld b,000h		;04f0	06 00 	. . 
	ld c,a			;04f2	4f 	O 
	dec bc			;04f3	0b 	. 
	ld (hl),c			;04f4	71 	q 
	inc hl			;04f5	23 	# 
	ld (hl),b			;04f6	70 	p 
l04f7h:
	ret			;04f7	c9 	. 
CALADRS:
	ld hl,0cc00h		;04f8	21 00 cc 	! . . 
	xor a			;04fb	af 	. 
	ld c,a			;04fc	4f 	O 
	ld a,(USERBIOS)		;04fd	3a 2d ef 	: - . 
	ld b,a			;0500	47 	G 
l0501h:
	sbc hl,bc		;0501	ed 42 	. B 
	push hl			;0503	e5 	. 
	ld a,(0ef2ch)		;0504	3a 2c ef 	: , . 
	rlca			;0507	07 	. 
	rlca			;0508	07 	. 
	ld b,a			;0509	47 	G 
	or a			;050a	b7 	. 
	sbc hl,bc		;050b	ed 42 	. B 
	ld bc,l00ffh+1		;050d	01 00 01 	. . . 
	sbc hl,bc		;0510	ed 42 	. B 
	ld d,h			;0512	54 	T 
	ld e,l			;0513	5d 	] 
	ld bc,l00ffh+1		;0514	01 00 01 	. . . 
l0517h:
	sbc hl,bc		;0517	ed 42 	. B 
	push hl			;0519	e5 	. 
l051ah:
	pop ix		;051a	dd e1 	. . 
	ld (SAVEIX),ix		;051c	dd 22 40 f5 	. " @ . 
	ld bc,l0800h		;0520	01 00 08 	. . . 
	sbc hl,bc		;0523	ed 42 	. B 
	push hl			;0525	e5 	. 
	pop iy		;0526	fd e1 	. . 
	ld (SAVEIY),iy		;0528	fd 22 42 f5 	. " B . 
	pop bc			;052c	c1 	. 
	ret			;052d	c9 	. 
sub_052eh:
	ld a,(USERBIOS)		;052e	3a 2d ef 	: - . 
	or a			;0531	b7 	. 
	jr z,l0538h		;0532	28 04 	( . 
	dec a			;0534	3d 	= 
	srl a		;0535	cb 3f 	. ? 
	inc a			;0537	3c 	< 
l0538h:
	ld hl,0ef2ch		;0538	21 2c ef 	! , . 
	ld b,(hl)			;053b	46 	F 
	sla b		;053c	cb 20 	.   
	add a,b			;053e	80 	. 
	cp 048h		;053f	fe 48 	. H 
	ret c			;0541	d8 	. 
l0542h:
	xor a			;0542	af 	. 
	ld (hl),a			;0543	77 	w 
	ld (USERBIOS),a		;0544	32 2d ef 	2 - . 
	ret			;0547	c9 	. 
sub_0548h:
	ld hl,l3030h		;0548	21 30 30 	! 0 0 
sub_054bh:
	call sub_057ah		;054b	cd 7a 05 	. z . 
	ld (0f447h),hl		;054e	22 47 f4 	" G . 
	xor a			;0551	af 	. 
l0552h:
	ld e,a			;0552	5f 	_ 
	ld hl,0f447h		;0553	21 47 f4 	! G . 
l0556h:
	call sub_05e0h		;0556	cd e0 05 	. . . 
	push bc			;0559	c5 	. 
	push de			;055a	d5 	. 
	push hl			;055b	e5 	. 
l055ch:
	call sub_05cfh		;055c	cd cf 05 	. . . 
	cp 00dh		;055f	fe 0d 	. . 
	jr z,l0578h		;0561	28 15 	( . 
	cp 01ch		;0563	fe 1c 	. . 
	jr z,l0573h		;0565	28 0c 	( . 
	cp 01dh		;0567	fe 1d 	. . 
	jr z,l0573h		;0569	28 08 	( . 
	cp 030h		;056b	fe 30 	. 0 
	jr c,l055ch		;056d	38 ed 	8 . 
	cp 03ah		;056f	fe 3a 	. : 
	jr nc,l055ch		;0571	30 e9 	0 . 
l0573h:
	pop hl			;0573	e1 	. 
l0574h:
	pop de			;0574	d1 	. 
	pop bc			;0575	c1 	. 
	jr l0556h		;0576	18 de 	. . 
l0578h:
	jr l05a9h		;0578	18 2f 	. / 
sub_057ah:
	push hl			;057a	e5 	. 
	push bc			;057b	c5 	. 
	ld hl,0f444h		;057c	21 44 f4 	! D . 
	ld bc,00f30h		;057f	01 30 0f 	. 0 . 
l0582h:
	ld (hl),c			;0582	71 	q 
	inc hl			;0583	23 	# 
	djnz l0582h		;0584	10 fc 	. . 
	pop bc			;0586	c1 	. 
l0587h:
	pop hl			;0587	e1 	. 
	ret			;0588	c9 	. 
sub_0589h:
	ld a,(hl)			;0589	7e 	~ 
	inc hl			;058a	23 	# 
	or a			;058b	b7 	. 
	ret z			;058c	c8 	. 
	ld c,a			;058d	4f 	O 
	call sub_059dh		;058e	cd 9d 05 	. . . 
	jr sub_0589h		;0591	18 f6 	. . 
sub_0593h:
	ld c,(hl)			;0593	4e 	N 
	inc hl			;0594	23 	# 
	inc c			;0595	0c 	. 
	ret z			;0596	c8 	. 
	dec c			;0597	0d 	. 
	call sub_059dh		;0598	cd 9d 05 	. . . 
	jr sub_0593h		;059b	18 f6 	. . 
sub_059dh:
	push bc			;059d	c5 	. 
	push de			;059e	d5 	. 
	push hl			;059f	e5 	. 
l05a0h:
	call sub_29d2h		;05a0	cd d2 29 	. . ) 
	call sub_4d5dh		;05a3	cd 5d 4d 	. ] M 
l05a6h:
	call sub_29e6h		;05a6	cd e6 29 	. . ) 
l05a9h:
	pop hl			;05a9	e1 	. 
	pop de			;05aa	d1 	. 
	pop bc			;05ab	c1 	. 
	ret			;05ac	c9 	. 
XWTVRAM:
	push bc			;05ad	c5 	. 
	push de			;05ae	d5 	. 
	push hl			;05af	e5 	. 
	call sub_29d2h		;05b0	cd d2 29 	. . ) 
	call sub_4ef3h		;05b3	cd f3 4e 	. . N 
	ld hl,l4f84h		;05b6	21 84 4f 	! . O 
l05b9h:
	call sub_4d04h		;05b9	cd 04 4d 	. . M 
	jr l05a6h		;05bc	18 e8 	. . 
XSETCUSR:
	push bc			;05be	c5 	. 
	push de			;05bf	d5 	. 
	push hl			;05c0	e5 	. 
	call sub_29d2h		;05c1	cd d2 29 	. . ) 
	inc b			;05c4	04 	. 
	inc c			;05c5	0c 	. 
	ld (0f298h),bc		;05c6	ed 43 98 f2 	. C . . 
	ld hl,l55e5h		;05ca	21 e5 55 	! . U 
	jr l05b9h		;05cd	18 ea 	. . 
sub_05cfh:
	call sub_29d2h		;05cf	cd d2 29 	. . ) 
	call sub_385fh		;05d2	cd 5f 38 	. _ 8 
	jr l05ddh		;05d5	18 06 	. . 
sub_05d7h:
	call sub_29d2h		;05d7	cd d2 29 	. . ) 
	call sub_3831h		;05da	cd 31 38 	. 1 8 
l05ddh:
	jp sub_29e6h		;05dd	c3 e6 29 	. . ) 
sub_05e0h:
	push bc			;05e0	c5 	. 
	push hl			;05e1	e5 	. 
	push de			;05e2	d5 	. 
	ld d,000h		;05e3	16 00 	. . 
	add hl,de			;05e5	19 	. 
	pop de			;05e6	d1 	. 
	or a			;05e7	b7 	. 
	jr z,l0633h		;05e8	28 49 	( I 
	cp 008h		;05ea	fe 08 	. . 
	jr z,l060bh		;05ec	28 1d 	( . 
	cp 020h		;05ee	fe 20 	.   
	jr nc,l0602h		;05f0	30 10 	0 . 
	ld c,a			;05f2	4f 	O 
	cp 005h		;05f3	fe 05 	. . 
	jr z,l0619h		;05f5	28 22 	( " 
	cp 01dh		;05f7	fe 1d 	. . 
	jr z,l0624h		;05f9	28 29 	( ) 
l05fbh:
	cp 01ch		;05fb	fe 1c 	. . 
	jr z,l062bh		;05fd	28 2c 	( , 
l05ffh:
	pop hl			;05ff	e1 	. 
	pop bc			;0600	c1 	. 
l0601h:
	ret			;0601	c9 	. 
l0602h:
	ld (hl),a			;0602	77 	w 
	inc e			;0603	1c 	. 
	ld a,d			;0604	7a 	z 
	sub e			;0605	93 	. 
	jr nz,l064fh		;0606	20 47 	  G 
l0608h:
	dec e			;0608	1d 	. 
	jr l0633h		;0609	18 28 	. ( 
l060bh:
	inc e			;060b	1c 	. 
	dec e			;060c	1d 	. 
	jr z,l05ffh		;060d	28 f0 	( . 
	dec e			;060f	1d 	. 
	ld a,d			;0610	7a 	z 
l0611h:
	sub e			;0611	93 	. 
	dec a			;0612	3d 	= 
	dec hl			;0613	2b 	+ 
	call sub_065ah		;0614	cd 5a 06 	. Z . 
	jr l0633h		;0617	18 1a 	. . 
l0619h:
	ld a,d			;0619	7a 	z 
	sub e			;061a	93 	. 
	inc a			;061b	3c 	< 
	push bc			;061c	c5 	. 
	ld b,a			;061d	47 	G 
	call sub_1656h		;061e	cd 56 16 	. V . 
	pop bc			;0621	c1 	. 
	jr l0655h		;0622	18 31 	. 1 
l0624h:
	inc e			;0624	1c 	. 
	dec e			;0625	1d 	. 
	jr z,l05ffh		;0626	28 d7 	( . 
	dec e			;0628	1d 	. 
	jr l0655h		;0629	18 2a 	. * 
l062bh:
	inc e			;062b	1c 	. 
	ld a,d			;062c	7a 	z 
	sub e			;062d	93 	. 
	jr nz,l0655h		;062e	20 25 	  % 
	dec e			;0630	1d 	. 
	jr l05ffh		;0631	18 cc 	. . 
l0633h:
	push de			;0633	d5 	. 
	push bc			;0634	c5 	. 
	call sub_0649h		;0635	cd 49 06 	. I . 
l0638h:
	ld c,(hl)			;0638	4e 	N 
	call XWTVRAM		;0639	cd ad 05 	. . . 
	inc hl			;063c	23 	# 
	inc e			;063d	1c 	. 
	ld a,e			;063e	7b 	{ 
l063fh:
	cp d			;063f	ba 	. 
	jr nz,l0638h		;0640	20 f6 	  . 
	pop bc			;0642	c1 	. 
	pop de			;0643	d1 	. 
	call sub_0649h		;0644	cd 49 06 	. I . 
	jr l05ffh		;0647	18 b6 	. . 
sub_0649h:
	ld a,c			;0649	79 	y 
	add a,e			;064a	83 	. 
	ld c,a			;064b	4f 	O 
	jp XSETCUSR		;064c	c3 be 05 	. . . 
l064fh:
	ld c,(hl)			;064f	4e 	N 
	call XWTVRAM		;0650	cd ad 05 	. . . 
	jr l05ffh		;0653	18 aa 	. . 
l0655h:
	call sub_059dh		;0655	cd 9d 05 	. . . 
	jr l05ffh		;0658	18 a5 	. . 
sub_065ah:
	push bc			;065a	c5 	. 
	push de			;065b	d5 	. 
	push hl			;065c	e5 	. 
	ld d,h			;065d	54 	T 
	ld e,l			;065e	5d 	] 
	inc hl			;065f	23 	# 
	or a			;0660	b7 	. 
	jr z,l0668h		;0661	28 05 	( . 
	ld c,a			;0663	4f 	O 
	ld b,000h		;0664	06 00 	. . 
	ldir		;0666	ed b0 	. . 
l0668h:
	dec hl			;0668	2b 	+ 
	ld (hl),020h		;0669	36 20 	6   
	jp l05a9h		;066b	c3 a9 05 	. . . 
l066eh:
	ld bc,l0101h		;066e	01 01 01 	. . . 
	ld bc,l0101h		;0671	01 01 01 	. . . 
	ld bc,l0201h		;0674	01 01 02 	. . . 
	ld (bc),a			;0677	02 	. 
	ld (bc),a			;0678	02 	. 
l0679h:
	ld (bc),a			;0679	02 	. 
	ld bc,l0201h+1		;067a	01 02 02 	. . . 
	ld (bc),a			;067d	02 	. 
	inc b			;067e	04 	. 
	inc b			;067f	04 	. 
	inc b			;0680	04 	. 
	inc b			;0681	04 	. 
l0682h:
	inc b			;0682	04 	. 
	inc b			;0683	04 	. 
	inc b			;0684	04 	. 
	inc b			;0685	04 	. 
	inc b			;0686	04 	. 
	inc b			;0687	04 	. 
	inc b			;0688	04 	. 
	inc b			;0689	04 	. 
	inc b			;068a	04 	. 
	inc b			;068b	04 	. 
	inc b			;068c	04 	. 
	inc b			;068d	04 	. 
l068eh:
	dec de			;068e	1b 	. 
	or 00ch		;068f	f6 0c 	. . 
	ld d,e			;0691	53 	S 
	ld e,c			;0692	59 	Y 
	ld d,e			;0693	53 	S 
	ld d,h			;0694	54 	T 
	ld b,l			;0695	45 	E 
	ld c,l			;0696	4d 	M 
	jr nz,l06e2h		;0697	20 49 	  I 
	ld c,(hl)			;0699	4e 	N 
	ld c,c			;069a	49 	I 
	ld d,h			;069b	54 	T 
	ld c,c			;069c	49 	I 
	ld b,c			;069d	41 	A 
	ld c,h			;069e	4c 	L 
	ld c,c			;069f	49 	I 
	ld e,d			;06a0	5a 	Z 
	ld b,l			;06a1	45 	E 
	dec c			;06a2	0d 	. 
	ld a,(bc)			;06a3	0a 	. 
	ld a,(bc)			;06a4	0a 	. 
l06a5h:
	ld b,h			;06a5	44 	D 
	ld b,c			;06a6	41 	A 
	ld d,h			;06a7	54 	T 
	ld b,l			;06a8	45 	E 
	cpl			;06a9	2f 	/ 
	ld d,h			;06aa	54 	T 
	ld c,c			;06ab	49 	I 
	ld c,l			;06ac	4d 	M 
	ld b,l			;06ad	45 	E 
	jr nz,l06d8h		;06ae	20 28 	  ( 
	ld c,l			;06b0	4d 	M 
	ld c,l			;06b1	4d 	M 
	ld b,h			;06b2	44 	D 
	ld b,h			;06b3	44 	D 
	ld e,c			;06b4	59 	Y 
	ld e,c			;06b5	59 	Y 
	ld l,b			;06b6	68 	h 
	ld l,b			;06b7	68 	h 
	ld l,l			;06b8	6d 	m 
	ld l,l			;06b9	6d 	m 
	ld (hl),e			;06ba	73 	s 
	ld (hl),e			;06bb	73 	s 
	add hl,hl			;06bc	29 	) 
	nop			;06bd	00 	. 
l06beh:
	dec c			;06be	0d 	. 
	ld a,(bc)			;06bf	0a 	. 
	ld d,a			;06c0	57 	W 
	ld b,l			;06c1	45 	E 
	ld b,l			;06c2	45 	E 
	ld c,e			;06c3	4b 	K 
l06c4h:
	jr nz,$+42		;06c4	20 28 	  ( 
	jr nc,l06e8h		;06c6	30 20 	0   
	ld (hl),h			;06c8	74 	t 
	ld l,a			;06c9	6f 	o 
	jr nz,l0702h		;06ca	20 36 	  6 
	add hl,hl			;06cc	29 	) 
	nop			;06cd	00 	. 
l06ceh:
	dec de			;06ce	1b 	. 
	dec a			;06cf	3d 	= 
	inc h			;06d0	24 	$ 
	jr nz,l06edh		;06d1	20 1a 	  . 
	ld d,d			;06d3	52 	R 
	ld b,c			;06d4	41 	A 
	ld c,l			;06d5	4d 	M 
	jr nz,l071ch		;06d6	20 44 	  D 
l06d8h:
	ld c,c			;06d8	49 	I 
	ld d,e			;06d9	53 	S 
	ld c,e			;06da	4b 	K 
	jr nz,l0730h		;06db	20 53 	  S 
	ld c,c			;06dd	49 	I 
	ld e,d			;06de	5a 	Z 
	ld b,l			;06df	45 	E 
	jr nz,$+42		;06e0	20 28 	  ( 
l06e2h:
	sbc a,l			;06e2	9d 	. 
	ld sp,l2020h		;06e3	31 20 20 	1     
	ld c,e			;06e6	4b 	K 
	ld b,d			;06e7	42 	B 
l06e8h:
	add hl,hl			;06e8	29 	) 
	nop			;06e9	00 	. 
l06eah:
	dec de			;06ea	1b 	. 
	dec a			;06eb	3d 	= 
	dec h			;06ec	25 	% 
l06edh:
	jr nz,l0709h		;06ed	20 1a 	  . 
	ld d,l			;06ef	55 	U 
	ld d,e			;06f0	53 	S 
	ld b,l			;06f1	45 	E 
	ld d,d			;06f2	52 	R 
	ld b,d			;06f3	42 	B 
	ld c,c			;06f4	49 	I 
	ld c,a			;06f5	4f 	O 
	ld d,e			;06f6	53 	S 
	jr nz,$+85		;06f7	20 53 	  S 
	ld c,c			;06f9	49 	I 
	ld e,d			;06fa	5a 	Z 
	ld b,l			;06fb	45 	E 
	jr nz,$+42		;06fc	20 28 	  ( 
	sbc a,l			;06fe	9d 	. 
	ld (l3635h),a		;06ff	32 35 36 	2 5 6 
l0702h:
	jr nz,$+68		;0702	20 42 	  B 
	add hl,hl			;0704	29 	) 
	nop			;0705	00 	. 
sub_0706h:
	call sub_0b80h		;0706	cd 80 0b 	. . . 
l0709h:
	ld hl,0f008h		;0709	21 08 f0 	! . . 
l070ch:
	ld de,0f375h		;070c	11 75 f3 	. u . 
	ld bc,l0015h		;070f	01 15 00 	. . . 
	ldir		;0712	ed b0 	. . 
	ld hl,0f860h		;0714	21 60 f8 	! ` . 
	ld bc,l0021h		;0717	01 21 00 	. ! . 
	ldir		;071a	ed b0 	. . 
l071ch:
	ld h,b			;071c	60 	` 
	ld l,b			;071d	68 	h 
	ld (YPFCMFLG),hl		;071e	22 17 f0 	" . . 
	ld (BRKFLG),hl		;0721	22 19 f0 	" . . 
	ld a,(0f006h)		;0724	3a 06 f0 	: . . 
	ld (0f3ach),a		;0727	32 ac f3 	2 . . 
l072ah:
	call sub_5908h		;072a	cd 08 59 	. . Y 
	jp l086ch		;072d	c3 6c 08 	. l . 
l0730h:
	call sub_0b87h		;0730	cd 87 0b 	. . . 
sub_0733h:
	call sub_0b80h		;0733	cd 80 0b 	. . . 
	ld a,(0f00fh)		;0736	3a 0f f0 	: . . 
	ld (0f3adh),a		;0739	32 ad f3 	2 . . 
	ld a,(0f01ch)		;073c	3a 1c f0 	: . . 
	ld (0f3aeh),a		;073f	32 ae f3 	2 . . 
	ld hl,0f375h		;0742	21 75 f3 	! u . 
	ld de,0f008h		;0745	11 08 f0 	. . . 
	ld bc,l0015h		;0748	01 15 00 	. . . 
	ldir		;074b	ed b0 	. . 
	ld de,0f860h		;074d	11 60 f8 	. ` . 
	ld bc,l0021h		;0750	01 21 00 	. ! . 
	ldir		;0753	ed b0 	. . 
	ld hl,0f3ach		;0755	21 ac f3 	! . . 
	ld a,(hl)			;0758	7e 	~ 
	and 070h		;0759	e6 70 	. p 
	ld c,a			;075b	4f 	O 
	ld a,(0f006h)		;075c	3a 06 f0 	: . . 
	ld (hl),a			;075f	77 	w 
	call sub_3df0h		;0760	cd f0 3d 	. . = 
	ld a,0a1h		;0763	3e a1 	> . 
	ld (0f544h),a		;0765	32 44 f5 	2 D . 
	call sub_0851h		;0768	cd 51 08 	. Q . 
l076bh:
	jp sub_0b87h		;076b	c3 87 0b 	. . . 
sub_076eh:
	call sub_5a10h		;076e	cd 10 5a 	. . Z 
l0771h:
	xor a			;0771	af 	. 
	ld (0efb6h),a		;0772	32 b6 ef 	2 . . 
	ld a,(0f2a0h)		;0775	3a a0 f2 	: . . 
	out (009h),a		;0778	d3 09 	. . 
l077ah:
	ret			;077a	c9 	. 
l077bh:
	ld h,b			;077b	60 	` 
	xor 090h		;077c	ee 90 	. . 
	xor 0b2h		;077e	ee b2 	. . 
l0780h:
	xor 0ceh		;0780	ee ce 	. . 
	xor 0edh		;0782	ee ed 	. . 
	xor 0c3h		;0784	ee c3 	. . 
l0786h:
	ld b,0eah		;0786	06 ea 	. . 
	jp 0ec3ch		;0788	c3 3c ec 	. < . 
	jp 0ec41h		;078b	c3 41 ec 	. A . 
	jp 0ebffh		;078e	c3 ff eb 	. . . 
	jp 0ec9ah		;0791	c3 9a ec 	. . . 
	jp 0ec64h		;0794	c3 64 ec 	. d . 
	jp 0ec6ah		;0797	c3 6a ec 	. j . 
	jp 0ec5eh		;079a	c3 5e ec 	. ^ . 
	jp 0ec94h		;079d	c3 94 ec 	. . . 
	jp 0ec70h		;07a0	c3 70 ec 	. p . 
	jp 0eaebh		;07a3	c3 eb ea 	. . . 
sub_07a6h:
	ld hl,0efd3h		;07a6	21 d3 ef 	! . . 
	set 7,(hl)		;07a9	cb fe 	. . 
l07abh:
	xor a			;07ab	af 	. 
l07ach:
	ld (0f4d5h),a		;07ac	32 d5 f4 	2 . . 
	call sub_0b80h		;07af	cd 80 0b 	. . . 
	ei			;07b2	fb 	. 
	ld c,002h		;07b3	0e 02 	. . 
	call CMD7508		;07b5	cd 6f 3c 	. o < 
	ld (0f4d6h),a		;07b8	32 d6 f4 	2 . . 
l07bbh:
	cp 0c0h		;07bb	fe c0 	. . 
	jr c,l07f8h		;07bd	38 39 	8 9 
	push af			;07bf	f5 	. 
	and 007h		;07c0	e6 07 	. . 
	ld c,a			;07c2	4f 	O 
	ld hl,0f36fh		;07c3	21 6f f3 	! o . 
	ld b,(hl)			;07c6	46 	F 
	and 001h		;07c7	e6 01 	. . 
	ld (hl),a			;07c9	77 	w 
	ld a,c			;07ca	79 	y 
	srl b		;07cb	cb 38 	. 8 
l07cdh:
	rla			;07cd	17 	. 
l07ceh:
	ld hl,0efdeh		;07ce	21 de ef 	! . . 
	ld b,000h		;07d1	06 00 	. . 
	ld c,a			;07d3	4f 	O 
	add hl,bc			;07d4	09 	. 
	ld a,(hl)			;07d5	7e 	~ 
l07d6h:
	pop bc			;07d6	c1 	. 
	bit 5,b		;07d7	cb 68 	. h 
	jr z,l07ddh		;07d9	28 02 	( . 
	or 001h		;07db	f6 01 	. . 
l07ddh:
	ld (0f4d5h),a		;07dd	32 d5 f4 	2 . . 
	rrca			;07e0	0f 	. 
	call c,sub_0954h		;07e1	dc 54 09 	. T . 
	rrca			;07e4	0f 	. 
	call c,sub_090ch		;07e5	dc 0c 09 	. . . 
	rrca			;07e8	0f 	. 
	call c,sub_09a1h		;07e9	dc a1 09 	. . . 
	rrca			;07ec	0f 	. 
l07edh:
	call c,sub_08e0h		;07ed	dc e0 08 	. . . 
l07f0h:
	rrca			;07f0	0f 	. 
l07f1h:
	call c,sub_08e8h		;07f1	dc e8 08 	. . . 
l07f4h:
	di			;07f4	f3 	. 
	jp sub_0b87h		;07f5	c3 87 0b 	. . . 
l07f8h:
	ld hl,0f544h		;07f8	21 44 f5 	! D . 
	ld (hl),a			;07fb	77 	w 
	ld a,(0f775h)		;07fc	3a 75 f7 	: u . 
	rlca			;07ff	07 	. 
l0800h:
	ld c,010h		;0800	0e 10 	. . 
	jr nc,l080dh		;0802	30 09 	0 . 
	ld a,(0f01eh)		;0804	3a 1e f0 	: . . 
	and 003h		;0807	e6 03 	. . 
	jr z,l084ch		;0809	28 41 	( A 
	ld c,0b6h		;080b	0e b6 	. . 
l080dh:
	ld a,(hl)			;080d	7e 	~ 
l080eh:
	cp c			;080e	b9 	. 
	jr nz,l084ch		;080f	20 3b 	  ; 
	ld a,010h		;0811	3e 10 	> . 
	ld (hl),a			;0813	77 	w 
l0814h:
	call sub_08aeh		;0814	cd ae 08 	. . . 
	ld c,a			;0817	4f 	O 
	ld a,(0f775h)		;0818	3a 75 f7 	: u . 
	rlca			;081b	07 	. 
	ld b,003h		;081c	06 03 	. . 
	jr nc,l0828h		;081e	30 08 	0 . 
	ld a,(0f01eh)		;0820	3a 1e f0 	: . . 
	ld b,a			;0823	47 	G 
	and 002h		;0824	e6 02 	. . 
	jr z,l0838h		;0826	28 10 	( . 
l0828h:
	ld a,c			;0828	79 	y 
	and 001h		;0829	e6 01 	. . 
	ld (CSTOPFLG),a		;082b	32 1a f0 	2 . . 
	ld (0f01bh),a		;082e	32 1b f0 	2 . . 
	ld (0f309h),a		;0831	32 09 f3 	2 . . 
	xor a			;0834	af 	. 
	ld (0f31ah),a		;0835	32 1a f3 	2 . . 
l0838h:
	rrc b		;0838	cb 08 	. . 
	jr nc,l0840h		;083a	30 04 	0 . 
	dec a			;083c	3d 	= 
	ld (BRKFLG),a		;083d	32 19 f0 	2 . . 
l0840h:
	call sub_086fh		;0840	cd 6f 08 	. o . 
	ld hl,0f860h		;0843	21 60 f8 	! ` . 
	ld (0f00bh),hl		;0846	22 0b f0 	" . . 
	ld (0f00dh),hl		;0849	22 0d f0 	" . . 
l084ch:
	call sub_0851h		;084c	cd 51 08 	. Q . 
	jr l07f4h		;084f	18 a3 	. . 
sub_0851h:
	ld hl,(0f00bh)		;0851	2a 0b f0 	* . . 
	ld d,h			;0854	54 	T 
	ld e,l			;0855	5d 	] 
	inc hl			;0856	23 	# 
	ld a,l			;0857	7d 	} 
	cp 081h		;0858	fe 81 	. . 
	jr nz,l085fh		;085a	20 03 	  . 
	ld hl,0f860h		;085c	21 60 f8 	! ` . 
l085fh:
	ld a,(0f00dh)		;085f	3a 0d f0 	: . . 
	cp l			;0862	bd 	. 
	ret z			;0863	c8 	. 
	ld (0f00bh),hl		;0864	22 0b f0 	" . . 
	ld a,(0f544h)		;0867	3a 44 f5 	: D . 
	ld (de),a			;086a	12 	. 
	ret			;086b	c9 	. 
l086ch:
	call sub_08aeh		;086c	cd ae 08 	. . . 
sub_086fh:
	ld a,(0f00fh)		;086f	3a 0f f0 	: . . 
	and 034h		;0872	e6 34 	. 4 
	ld b,a			;0874	47 	G 
	ld a,(0f4d8h)		;0875	3a d8 f4 	: . . 
	bit 1,a		;0878	cb 4f 	. O 
	jr z,l087eh		;087a	28 02 	( . 
	set 1,b		;087c	cb c8 	. . 
l087eh:
	bit 0,a		;087e	cb 47 	. G 
	jr z,l0884h		;0880	28 02 	( . 
	set 7,b		;0882	cb f8 	. . 
l0884h:
	bit 3,a		;0884	cb 5f 	. _ 
	jr z,l088ah		;0886	28 02 	( . 
	set 6,b		;0888	cb f0 	. . 
l088ah:
	bit 4,a		;088a	cb 67 	. g 
	jr z,l0890h		;088c	28 02 	( . 
	set 0,b		;088e	cb c0 	. . 
l0890h:
	ld a,b			;0890	78 	x 
	jr l0898h		;0891	18 05 	. . 
sub_0893h:
	ld a,(0f00fh)		;0893	3a 0f f0 	: . . 
	and 034h		;0896	e6 34 	. 4 
l0898h:
	ld (0f00fh),a		;0898	32 0f f0 	2 . . 
	ld a,(0f775h)		;089b	3a 75 f7 	: u . 
	rlca			;089e	07 	. 
	ret c			;089f	d8 	. 
	jp l3daah		;08a0	c3 aa 3d 	. . = 
sub_08a3h:
	ld c,00eh		;08a3	0e 0e 	. . 
	call CMD7508		;08a5	cd 6f 3c 	. o < 
	ld bc,sub_0027h+1		;08a8	01 28 00 	. ( . 
	jp l45efh		;08ab	c3 ef 45 	. . E 
sub_08aeh:
	call sub_08a3h		;08ae	cd a3 08 	. . . 
	ld d,000h		;08b1	16 00 	. . 
l08b3h:
	ld c,002h		;08b3	0e 02 	. . 
	call CMD7508		;08b5	cd 6f 3c 	. o < 
	cp 0bfh		;08b8	fe bf 	. . 
	jr z,l08dbh		;08ba	28 1f 	( . 
	jr nc,l08b3h		;08bc	30 f5 	0 . 
	sub 0a2h		;08be	d6 a2 	. . 
	jr c,l08b3h		;08c0	38 f1 	8 . 
	cp 010h		;08c2	fe 10 	. . 
	jr c,l08c8h		;08c4	38 02 	8 . 
	sub 008h		;08c6	d6 08 	. . 
l08c8h:
	inc a			;08c8	3c 	< 
	ld hl,COLDRST		;08c9	21 00 00 	! . . 
	scf			;08cc	37 	7 
l08cdh:
	adc hl,hl		;08cd	ed 6a 	. j 
	dec a			;08cf	3d 	= 
	jr nz,l08cdh		;08d0	20 fb 	  . 
	ld a,d			;08d2	7a 	z 
	or h			;08d3	b4 	. 
	ld d,a			;08d4	57 	W 
	ld a,l			;08d5	7d 	} 
	cpl			;08d6	2f 	/ 
	and d			;08d7	a2 	. 
	ld d,a			;08d8	57 	W 
	jr l08b3h		;08d9	18 d8 	. . 
l08dbh:
	ld a,d			;08db	7a 	z 
	ld (0f4d8h),a		;08dc	32 d8 f4 	2 . . 
	ret			;08df	c9 	. 
sub_08e0h:
	push af			;08e0	f5 	. 
	ld a,0ffh		;08e1	3e ff 	> . 
	ld (BTRYFG),a		;08e3	32 ee ef 	2 . . 
	jr l08fdh		;08e6	18 15 	. . 
sub_08e8h:
	push af			;08e8	f5 	. 
	call sub_08aeh		;08e9	cd ae 08 	. . . 
	ld b,a			;08ec	47 	G 
	ld c,002h		;08ed	0e 02 	. . 
	ld a,(0ef2ah)		;08ef	3a 2a ef 	: * . 
	or a			;08f2	b7 	. 
	jr z,l08f9h		;08f3	28 04 	( . 
	xor b			;08f5	a8 	. 
	jr z,l08f9h		;08f6	28 01 	( . 
	dec c			;08f8	0d 	. 
l08f9h:
	ld a,c			;08f9	79 	y 
	ld (0f4ddh),a		;08fa	32 dd f4 	2 . . 
l08fdh:
	ld a,(0efefh)		;08fd	3a ef ef 	: . . 
sub_0900h:
	ld (0eff0h),a		;0900	32 f0 ef 	2 . . 
	or a			;0903	b7 	. 
	jr nz,l090ah		;0904	20 04 	  . 
	di			;0906	f3 	. 
	call sub_2d5eh		;0907	cd 5e 2d 	. ^ - 
l090ah:
	pop af			;090a	f1 	. 
	ret			;090b	c9 	. 
sub_090ch:
	push af			;090c	f5 	. 
	ld a,(0ef29h)		;090d	3a 29 ef 	: ) . 
	and 043h		;0910	e6 43 	. C 
	jr nz,l0952h		;0912	20 3e 	  > 
	ld hl,0ef8eh		;0914	21 8e ef 	! . . 
	ld a,(hl)			;0917	7e 	~ 
	or a			;0918	b7 	. 
	jr nz,l0942h		;0919	20 27 	  ' 
	inc (hl)			;091b	34 	4 
	ld hl,0f4d9h		;091c	21 d9 f4 	! . . 
	ld (hl),00ah		;091f	36 0a 	6 . 
	inc a			;0921	3c 	< 
	ld (ALRMST),a		;0922	32 8d ef 	2 . . 
	ld hl,0f4d7h		;0925	21 d7 f4 	! . . 
	set 3,(hl)		;0928	cb de 	. . 
	call 0ffc6h		;092a	cd c6 ff 	. . . 
	ld a,(0eff1h)		;092d	3a f1 ef 	: . . 
	ld (0eff2h),a		;0930	32 f2 ef 	2 . . 
	or a			;0933	b7 	. 
	jr nz,l093fh		;0934	20 09 	  . 
	call sub_0b87h		;0936	cd 87 0b 	. . . 
	call sub_0a5ch		;0939	cd 5c 0a 	. \ . 
	call sub_0b80h		;093c	cd 80 0b 	. . . 
l093fh:
	call 0ffc9h		;093f	cd c9 ff 	. . . 
l0942h:
	ld a,(0eff0h)		;0942	3a f0 ef 	: . . 
	or a			;0945	b7 	. 
	jr z,l0952h		;0946	28 0a 	( . 
	and 0dfh		;0948	e6 df 	. . 
	ld (0eff0h),a		;094a	32 f0 ef 	2 . . 
	jr nz,l0952h		;094d	20 03 	  . 
	call sub_2d5eh		;094f	cd 5e 2d 	. ^ - 
l0952h:
	pop af			;0952	f1 	. 
	ret			;0953	c9 	. 
sub_0954h:
	push af			;0954	f5 	. 
	ld hl,0f4d7h		;0955	21 d7 f4 	! . . 
	set 6,(hl)		;0958	cb f6 	. . 
	ld hl,(TIMER0)		;095a	2a 8f ef 	* . . 
	inc hl			;095d	23 	# 
	ld (TIMER0),hl		;095e	22 8f ef 	" . . 
	ld hl,(0ef91h)		;0961	2a 91 ef 	* . . 
	dec hl			;0964	2b 	+ 
	ld (0ef91h),hl		;0965	22 91 ef 	" . . 
	ld a,(0ef8eh)		;0968	3a 8e ef 	: . . 
	or a			;096b	b7 	. 
	jr z,l0978h		;096c	28 0a 	( . 
	ld hl,0f4d9h		;096e	21 d9 f4 	! . . 
	dec (hl)			;0971	35 	5 
	jr nz,l0978h		;0972	20 04 	  . 
	xor a			;0974	af 	. 
	ld (0ef8eh),a		;0975	32 8e ef 	2 . . 
l0978h:
	ld a,(0f313h)		;0978	3a 13 f3 	: . . 
	or a			;097b	b7 	. 
	jr z,l0990h		;097c	28 12 	( . 
	ld hl,(0f4dah)		;097e	2a da f4 	* . . 
	dec hl			;0981	2b 	+ 
	ld (0f4dah),hl		;0982	22 da f4 	" . . 
	ld a,h			;0985	7c 	| 
	or l			;0986	b5 	. 
	jr nz,l0990h		;0987	20 07 	  . 
	ld (0f313h),a		;0989	32 13 f3 	2 . . 
	dec a			;098c	3d 	= 
	ld (0f314h),a		;098d	32 14 f3 	2 . . 
l0990h:
	ld hl,0f4d1h		;0990	21 d1 f4 	! . . 
	ld a,(hl)			;0993	7e 	~ 
	or a			;0994	b7 	. 
	jr z,l099fh		;0995	28 08 	( . 
	dec a			;0997	3d 	= 
	ld (hl),a			;0998	77 	w 
	jr nz,l099fh		;0999	20 04 	  . 
	dec a			;099b	3d 	= 
	ld (0f4d2h),a		;099c	32 d2 f4 	2 . . 
l099fh:
	pop af			;099f	f1 	. 
	ret			;09a0	c9 	. 
sub_09a1h:
	push af			;09a1	f5 	. 
	ld a,0ffh		;09a2	3e ff 	> . 
	ld (0f4dch),a		;09a4	32 dc f4 	2 . . 
	pop af			;09a7	f1 	. 
	ret			;09a8	c9 	. 
l09a9h:
	res 6,(hl)		;09a9	cb b6 	. . 
	ld a,(0f6cbh)		;09ab	3a cb f6 	: . . 
sub_09aeh:
	ld hl,0efd3h		;09ae	21 d3 ef 	! . . 
	set 6,(hl)		;09b1	cb f6 	. . 
l09b3h:
	ld hl,0f787h		;09b3	21 87 f7 	! . . 
	bit 0,(hl)		;09b6	cb 46 	. F 
	ret z			;09b8	c8 	. 
	in a,(015h)		;09b9	db 15 	. . 
	bit 1,a		;09bb	cb 4f 	. O 
	ret z			;09bd	c8 	. 
	ld b,a			;09be	47 	G 
	rlca			;09bf	07 	. 
l09c0h:
	and 070h		;09c0	e6 70 	. p 
	ld d,a			;09c2	57 	W 
	ld a,b			;09c3	78 	x 
	and 080h		;09c4	e6 80 	. . 
	ld e,a			;09c6	5f 	_ 
	in a,(016h)		;09c7	db 16 	. . 
	and 010h		;09c9	e6 10 	. . 
	rrca			;09cb	0f 	. 
	or d			;09cc	b2 	. 
	or e			;09cd	b3 	. 
	or (hl)			;09ce	b6 	. 
	xor 088h		;09cf	ee 88 	. . 
	ld (hl),a			;09d1	77 	w 
	in a,(014h)		;09d2	db 14 	. . 
	ld bc,(0f79ah)		;09d4	ed 4b 9a f7 	. K . . 
	and b			;09d8	a0 	. 
	ld hl,0f79ch		;09d9	21 9c f7 	! . . 
	bit 4,(hl)		;09dc	cb 66 	. f 
	jr z,l09eah		;09de	28 0a 	( . 
	ld bc,(0ef2eh)		;09e0	ed 4b 2e ef 	. K . . 
	cp c			;09e4	b9 	. 
	jr z,l09a9h		;09e5	28 c2 	( . 
	cp b			;09e7	b8 	. 
	jr z,$-60		;09e8	28 c2 	( . 
l09eah:
	ld hl,0f787h		;09ea	21 87 f7 	! . . 
	bit 1,(hl)		;09ed	cb 4e 	. N 
	jr z,l09f4h		;09ef	28 03 	( . 
	set 2,(hl)		;09f1	cb d6 	. . 
	ret			;09f3	c9 	. 
l09f4h:
	ld hl,(0f78ah)		;09f4	2a 8a f7 	* . . 
	call 0ed46h		;09f7	cd 46 ed 	. F . 
	inc hl			;09fa	23 	# 
	ld d,h			;09fb	54 	T 
	ld e,l			;09fc	5d 	] 
	ld bc,(0f795h)		;09fd	ed 4b 95 f7 	. K . . 
	or a			;0a01	b7 	. 
	sbc hl,bc		;0a02	ed 42 	. B 
	ex de,hl			;0a04	eb 	. 
	jr nz,l0a0ah		;0a05	20 03 	  . 
	ld hl,(0f78ch)		;0a07	2a 8c f7 	* . . 
l0a0ah:
	ld (0f78ah),hl		;0a0a	22 8a f7 	" . . 
	ld bc,(0f788h)		;0a0d	ed 4b 88 f7 	. K . . 
	or a			;0a11	b7 	. 
l0a12h:
	sbc hl,bc		;0a12	ed 42 	. B 
	jr nz,l0a1bh		;0a14	20 05 	  . 
	ld hl,0f787h		;0a16	21 87 f7 	! . . 
	set 1,(hl)		;0a19	cb ce 	. . 
l0a1bh:
	ld hl,0f79ch		;0a1b	21 9c f7 	! . . 
	bit 2,(hl)		;0a1e	cb 56 	. V 
	ex de,hl			;0a20	eb 	. 
	jr z,l0a32h		;0a21	28 0f 	( . 
	cp 00eh		;0a23	fe 0e 	. . 
	jr z,l0a2bh		;0a25	28 04 	( . 
	cp 00fh		;0a27	fe 0f 	. . 
l0a29h:
	jr nz,l0a32h		;0a29	20 07 	  . 
l0a2bh:
	ld hl,(0f7a1h)		;0a2b	2a a1 f7 	* . . 
	inc hl			;0a2e	23 	# 
	ld (0f7a1h),hl		;0a2f	22 a1 f7 	" . . 
l0a32h:
	ld hl,(0f79fh)		;0a32	2a 9f f7 	* . . 
	inc hl			;0a35	23 	# 
	ld (0f79fh),hl		;0a36	22 9f f7 	" . . 
	ex de,hl			;0a39	eb 	. 
	bit 4,(hl)		;0a3a	cb 66 	. f 
	jp z,l09b3h		;0a3c	ca b3 09 	. . . 
	bit 5,(hl)		;0a3f	cb 6e 	. n 
	jp nz,l09b3h		;0a41	c2 b3 09 	. . . 
	ld hl,(0f799h)		;0a44	2a 99 f7 	* . . 
	sbc hl,de		;0a47	ed 52 	. R 
	jp nc,l09b3h		;0a49	d2 b3 09 	. . . 
l0a4ch:
	call sub_4334h		;0a4c	cd 34 43 	. 4 C 
	jr z,l0a4ch		;0a4f	28 fb 	( . 
	ld a,(0ef2fh)		;0a51	3a 2f ef 	: / . 
	out (014h),a		;0a54	d3 14 	. . 
	ld hl,0f79ch		;0a56	21 9c f7 	! . . 
	set 5,(hl)		;0a59	cb ee 	. . 
	ret			;0a5b	c9 	. 
sub_0a5ch:
	ld hl,0efefh		;0a5c	21 ef ef 	! . . 
	set 5,(hl)		;0a5f	cb ee 	. . 
	xor a			;0a61	af 	. 
	ld (0eff2h),a		;0a62	32 f2 ef 	2 . . 
	inc hl			;0a65	23 	# 
	or (hl)			;0a66	b6 	. 
	jr z,l0a6bh		;0a67	28 02 	( . 
	set 5,(hl)		;0a69	cb ee 	. . 
l0a6bh:
	ld hl,0ef29h		;0a6b	21 29 ef 	! ) . 
	set 1,(hl)		;0a6e	cb ce 	. . 
	ld a,(0efd1h)		;0a70	3a d1 ef 	: . . 
	push af			;0a73	f5 	. 
	ld a,(TIMER0)		;0a74	3a 8f ef 	: . . 
	ld hl,(ALRMTIME)		;0a77	2a 08 f3 	* . . 
	add a,l			;0a7a	85 	. 
	ld (0f4deh),a		;0a7b	32 de f4 	2 . . 
	call sub_0ae5h		;0a7e	cd e5 0a 	. . . 
	call sub_0706h		;0a81	cd 06 07 	. . . 
	call sub_0b28h		;0a84	cd 28 0b 	. ( . 
	ld c,003h		;0a87	0e 03 	. . 
	ld hl,(ALRMSOND)		;0a89	2a 3e ef 	* > . 
	call MELODY		;0a8c	cd c5 6e 	. . n 
	jr l0aafh		;0a8f	18 1e 	. . 
l0a91h:
	ld a,(0eff0h)		;0a91	3a f0 ef 	: . . 
	or a			;0a94	b7 	. 
	jr nz,l0abch		;0a95	20 25 	  % 
	ld hl,0ef29h		;0a97	21 29 ef 	! ) . 
	bit 0,(hl)		;0a9a	cb 46 	. F 
	jr z,l0aa4h		;0a9c	28 06 	( . 
	ld a,(0f4dch)		;0a9e	3a dc f4 	: . . 
	or a			;0aa1	b7 	. 
	jr nz,l0abch		;0aa2	20 18 	  . 
l0aa4h:
	ld a,(TIMER0)		;0aa4	3a 8f ef 	: . . 
	ld hl,0f4deh		;0aa7	21 de f4 	! . . 
	cp (hl)			;0aaa	be 	. 
	jp p,l0abch		;0aab	f2 bc 0a 	. . . 
	halt			;0aae	76 	v 
l0aafh:
	call sub_05d7h		;0aaf	cd d7 05 	. . . 
	or a			;0ab2	b7 	. 
	jr z,l0a91h		;0ab3	28 dc 	( . 
	call sub_05cfh		;0ab5	cd cf 05 	. . . 
	cp 01bh		;0ab8	fe 1b 	. . 
	jr nz,l0aafh		;0aba	20 f3 	  . 
l0abch:
	call 0ffcch		;0abc	cd cc ff 	. . . 
	call sub_0733h		;0abf	cd 33 07 	. 3 . 
	ld a,(0ef29h)		;0ac2	3a 29 ef 	: ) . 
	and 005h		;0ac5	e6 05 	. . 
	call z,XUSRSCRN		;0ac7	cc 31 59 	. 1 Y 
	pop af			;0aca	f1 	. 
	ld (0efd1h),a		;0acb	32 d1 ef 	2 . . 
	ld hl,0eff0h		;0ace	21 f0 ef 	! . . 
	or a			;0ad1	b7 	. 
	jr z,l0adah		;0ad2	28 06 	( . 
	ld a,(hl)			;0ad4	7e 	~ 
	or a			;0ad5	b7 	. 
	jr z,l0adah		;0ad6	28 02 	( . 
	set 7,(hl)		;0ad8	cb fe 	. . 
l0adah:
	dec hl			;0ada	2b 	+ 
	res 5,(hl)		;0adb	cb ae 	. . 
	ld hl,0ef29h		;0add	21 29 ef 	! ) . 
	res 1,(hl)		;0ae0	cb 8e 	. . 
	jp sub_3802h		;0ae2	c3 02 38 	. . 8 
sub_0ae5h:
	call sub_6b28h		;0ae5	cd 28 6b 	. ( k 
	ret nz			;0ae8	c0 	. 
	call HSRK		;0ae9	cd 52 47 	. R G 
	jp l6c13h		;0aec	c3 13 6c 	. . l 
l0aefh:
	inc c			;0aef	0c 	. 
	inc a			;0af0	3c 	< 
	ld b,c			;0af1	41 	A 
	ld c,h			;0af2	4c 	L 
	ld b,c			;0af3	41 	A 
	ld d,d			;0af4	52 	R 
	ld c,l			;0af5	4d 	M 
	jr nz,l0b4ch		;0af6	20 54 	  T 
	ld c,c			;0af8	49 	I 
	ld c,l			;0af9	4d 	M 
	ld b,l			;0afa	45 	E 
	ld a,009h		;0afb	3e 09 	> . 
	nop			;0afd	00 	. 
l0afeh:
	inc c			;0afe	0c 	. 
	inc a			;0aff	3c 	< 
	ld d,a			;0b00	57 	W 
	ld b,c			;0b01	41 	A 
	ld c,e			;0b02	4b 	K 
	ld b,l			;0b03	45 	E 
	jr nz,l0b5ah		;0b04	20 54 	  T 
l0b06h:
	ld c,c			;0b06	49 	I 
	ld c,l			;0b07	4d 	M 
	ld b,l			;0b08	45 	E 
	ld a,009h		;0b09	3e 09 	> . 
	nop			;0b0b	00 	. 
l0b0ch:
	dec c			;0b0c	0d 	. 
	ld a,(bc)			;0b0d	0a 	. 
l0b0eh:
	ld a,(bc)			;0b0e	0a 	. 
	jr nz,l0b31h		;0b0f	20 20 	    
	ld (l001eh+2),hl		;0b11	22 20 00 	"   . 
	jr nz,$+36		;0b14	20 22 	  " 
	dec c			;0b16	0d 	. 
	ld a,(bc)			;0b17	0a 	. 
	ld a,(bc)			;0b18	0a 	. 
	add hl,bc			;0b19	09 	. 
	ld d,b			;0b1a	50 	P 
	ld (hl),d			;0b1b	72 	r 
	ld h,l			;0b1c	65 	e 
	ld (hl),e			;0b1d	73 	s 
	ld (hl),e			;0b1e	73 	s 
	jr nz,$+71		;0b1f	20 45 	  E 
	ld d,e			;0b21	53 	S 
	ld b,e			;0b22	43 	C 
	jr nz,$+109		;0b23	20 6b 	  k 
	ld h,l			;0b25	65 	e 
	ld a,c			;0b26	79 	y 
	nop			;0b27	00 	. 
sub_0b28h:
	call sub_076eh		;0b28	cd 6e 07 	. n . 
	call XSETSCRN		;0b2b	cd 29 59 	. ) Y 
	ld hl,ALRMMSG		;0b2e	21 df f3 	! . . 
l0b31h:
	call sub_170ah		;0b31	cd 0a 17 	. . . 
	ld a,(ALRMTP)		;0b34	3a 8a ef 	: . . 
	ld hl,l0afeh		;0b37	21 fe 0a 	! . . 
	dec a			;0b3a	3d 	= 
	jr nz,l0b40h		;0b3b	20 03 	  . 
	ld hl,l0aefh		;0b3d	21 ef 0a 	! . . 
l0b40h:
	call sub_0589h		;0b40	cd 89 05 	. . . 
	ld a,(ALRMST)		;0b43	3a 8d ef 	: . . 
	push af			;0b46	f5 	. 
	ld c,084h		;0b47	0e 84 	. . 
	ld hl,0f401h		;0b49	21 01 f4 	! . . 
l0b4ch:
	call sub_10afh		;0b4c	cd af 10 	. . . 
	pop af			;0b4f	f1 	. 
	ld (ALRMST),a		;0b50	32 8d ef 	2 . . 
	ld hl,0f409h		;0b53	21 09 f4 	! . . 
	ld (hl),009h		;0b56	36 09 	6 . 
	inc hl			;0b58	23 	# 
	ex de,hl			;0b59	eb 	. 
l0b5ah:
	ld hl,0f410h		;0b5a	21 10 f4 	! . . 
	ld bc,RBDOS1		;0b5d	01 05 00 	. . . 
	ldir		;0b60	ed b0 	. . 
	xor a			;0b62	af 	. 
	ld (de),a			;0b63	12 	. 
	ld hl,0f404h		;0b64	21 04 f4 	! . . 
	call sub_0589h		;0b67	cd 89 05 	. . . 
	ld hl,l0b0ch		;0b6a	21 0c 0b 	! . . 
	call sub_0589h		;0b6d	cd 89 05 	. . . 
	push hl			;0b70	e5 	. 
	ld hl,0f419h		;0b71	21 19 f4 	! . . 
	ld a,020h		;0b74	3e 20 	>   
	call sub_17f3h		;0b76	cd f3 17 	. . . 
	pop hl			;0b79	e1 	. 
	call sub_0589h		;0b7a	cd 89 05 	. . . 
	jp l0343h		;0b7d	c3 43 03 	. C . 
sub_0b80h:
	ld a,(0f53eh)		;0b80	3a 3e f5 	: > . 
	res 0,a		;0b83	cb 87 	. . 
	jr l0b8ch		;0b85	18 05 	. . 
sub_0b87h:
	ld a,(0f53eh)		;0b87	3a 3e f5 	: > . 
	set 0,a		;0b8a	cb c7 	. . 
l0b8ch:
	ld (0f53eh),a		;0b8c	32 3e f5 	2 > . 
	out (004h),a		;0b8f	d3 04 	. . 
	ret			;0b91	c9 	. 
sub_0b92h:
	ld hl,0efd3h		;0b92	21 d3 ef 	! . . 
	set 3,(hl)		;0b95	cb de 	. . 
	ld a,004h		;0b97	3e 04 	> . 
	out (001h),a		;0b99	d3 01 	. . 
	jp l59dfh		;0b9b	c3 df 59 	. . Y 
l0b9eh:
	ld hl,0ef29h		;0b9e	21 29 ef 	! ) . 
	set 4,(hl)		;0ba1	cb e6 	. . 
	xor a			;0ba3	af 	. 
	ld (0f4cfh),a		;0ba4	32 cf f4 	2 . . 
	ld hl,MENUDRV		;0ba7	21 45 ef 	! E . 
	ld de,0f48ch		;0baa	11 8c f4 	. . . 
	ld bc,00043h		;0bad	01 43 00 	. C . 
	ldir		;0bb0	ed b0 	. . 
	call sub_1aa7h		;0bb2	cd a7 1a 	. . . 
	ld hl,l0003h+1		;0bb5	21 04 00 	! . . 
	call 0ec7ch		;0bb8	cd 7c ec 	. | . 
	srl a		;0bbb	cb 3f 	. ? 
	srl a		;0bbd	cb 3f 	. ? 
	srl a		;0bbf	cb 3f 	. ? 
	srl a		;0bc1	cb 3f 	. ? 
	ld e,a			;0bc3	5f 	_ 
	ld c,020h		;0bc4	0e 20 	.   
	call 01bc9h		;0bc6	cd c9 1b 	. . . 
	ld c,00dh		;0bc9	0e 0d 	. . 
	call 01bc9h		;0bcb	cd c9 1b 	. . . 
	ld ix,FTYPETBL		;0bce	dd 21 50 ef 	. ! P . 
	ld bc,00401h		;0bd2	01 01 04 	. . . 
l0bd5h:
	ld a,(ix+000h)		;0bd5	dd 7e 00 	. ~ . 
	cp 043h		;0bd8	fe 43 	. C 
	jr nz,l0beah		;0bda	20 0e 	  . 
	ld a,(ix+001h)		;0bdc	dd 7e 01 	. ~ . 
	cp 04fh		;0bdf	fe 4f 	. O 
	jr nz,l0beah		;0be1	20 07 	  . 
	ld a,(ix+002h)		;0be3	dd 7e 02 	. ~ . 
	cp 04dh		;0be6	fe 4d 	. M 
	jr z,l0bf2h		;0be8	28 08 	( . 
l0beah:
	inc c			;0bea	0c 	. 
	ld de,l000ch+2		;0beb	11 0e 00 	. . . 
	add ix,de		;0bee	dd 19 	. . 
	djnz l0bd5h		;0bf0	10 e3 	. . 
l0bf2h:
	ld a,c			;0bf2	79 	y 
	ld (0f48bh),a		;0bf3	32 8b f4 	2 . . 
	ld hl,l1179h		;0bf6	21 79 11 	! y . 
	call sub_0593h		;0bf9	cd 93 05 	. . . 
	xor a			;0bfc	af 	. 
	ld (0f43bh),a		;0bfd	32 3b f4 	2 ; . 
	ld (0f46dh),a		;0c00	32 6d f4 	2 m . 
	dec a			;0c03	3d 	= 
	ld (0f43ch),a		;0c04	32 3c f4 	2 < . 
	ld (0f470h),a		;0c07	32 70 f4 	2 p . 
	ld a,020h		;0c0a	3e 20 	>   
	ld (0f43fh),a		;0c0c	32 3f f4 	2 ? . 
	ld hl,l0501h		;0c0f	21 01 05 	! . . 
	ld (0f43dh),hl		;0c12	22 3d f4 	" = . 
	call sub_0d77h		;0c15	cd 77 0d 	. w . 
	ld a,(0f43bh)		;0c18	3a 3b f4 	: ; . 
	or a			;0c1b	b7 	. 
	jp z,l0cfah		;0c1c	ca fa 0c 	. . . 
	ld hl,0f473h		;0c1f	21 73 f4 	! s . 
	ld (hl),030h		;0c22	36 30 	6 0 
	inc hl			;0c24	23 	# 
	ld (hl),02fh		;0c25	36 2f 	6 / 
	inc hl			;0c27	23 	# 
l0c28h:
	ld a,(0f43ch)		;0c28	3a 3c f4 	: < . 
	add a,031h		;0c2b	c6 31 	. 1 
	ld (hl),a			;0c2d	77 	w 
	inc hl			;0c2e	23 	# 
	ld a,(0f43fh)		;0c2f	3a 3f f4 	: ? . 
	ld (hl),a			;0c32	77 	w 
	inc hl			;0c33	23 	# 
	ld (hl),0ffh		;0c34	36 ff 	6 . 
	ld a,(0f43ch)		;0c36	3a 3c f4 	: < . 
	ld b,a			;0c39	47 	G 
	inc b			;0c3a	04 	. 
	xor a			;0c3b	af 	. 
l0c3ch:
	push bc			;0c3c	c5 	. 
	push af			;0c3d	f5 	. 
	ld b,a			;0c3e	47 	G 
	ld c,001h		;0c3f	0e 01 	. . 
	call XSETCUSR		;0c41	cd be 05 	. . . 
	call sub_2cc2h		;0c44	cd c2 2c 	. . , 
	pop af			;0c47	f1 	. 
	push af			;0c48	f5 	. 
	ld b,a			;0c49	47 	G 
	ld c,00ch		;0c4a	0e 0c 	. . 
	call XSETCUSR		;0c4c	cd be 05 	. . . 
	ld b,00ah		;0c4f	06 0a 	. . 
l0c51h:
	ld c,020h		;0c51	0e 20 	.   
	call sub_059dh		;0c53	cd 9d 05 	. . . 
	djnz l0c51h		;0c56	10 f9 	. . 
	pop af			;0c58	f1 	. 
	push af			;0c59	f5 	. 
	ld b,a			;0c5a	47 	G 
	ld c,024h		;0c5b	0e 24 	. $ 
	call XSETCUSR		;0c5d	cd be 05 	. . . 
	ld hl,0f473h		;0c60	21 73 f4 	! s . 
	inc (hl)			;0c63	34 	4 
	call sub_0593h		;0c64	cd 93 05 	. . . 
	pop af			;0c67	f1 	. 
	add a,008h		;0c68	c6 08 	. . 
	pop bc			;0c6a	c1 	. 
	djnz l0c3ch		;0c6b	10 cf 	. . 
	xor a			;0c6d	af 	. 
	ld (0f440h),a		;0c6e	32 40 f4 	2 @ . 
	ld (0f441h),a		;0c71	32 41 f4 	2 A . 
	ld (0f442h),a		;0c74	32 42 f4 	2 B . 
	ld (0f4d0h),a		;0c77	32 d0 f4 	2 . . 
	call sub_0e55h		;0c7a	cd 55 0e 	. U . 
	call sub_3802h		;0c7d	cd 02 38 	. . 8 
l0c80h:
	halt			;0c80	76 	v 
l0c81h:
	ld de,l000ch+1		;0c81	11 0d 00 	. . . 
	call sub_1094h		;0c84	cd 94 10 	. . . 
	call sub_380eh		;0c87	cd 0e 38 	. . 8 
	call m,sub_2d75h		;0c8a	fc 75 2d 	. u - 
	ld a,(0f4cfh)		;0c8d	3a cf f4 	: . . 
	inc a			;0c90	3c 	< 
	jr nz,l0c9fh		;0c91	20 0c 	  . 
	call sub_0d03h		;0c93	cd 03 0d 	. . . 
	inc b			;0c96	04 	. 
l0c97h:
	dec b			;0c97	05 	. 
	jp nz,l0b9eh		;0c98	c2 9e 0b 	. . . 
	xor a			;0c9b	af 	. 
	ld (0f4cfh),a		;0c9c	32 cf f4 	2 . . 
l0c9fh:
	call sub_05d7h		;0c9f	cd d7 05 	. . . 
	or a			;0ca2	b7 	. 
	jr z,l0c80h		;0ca3	28 db 	( . 
	call sub_3802h		;0ca5	cd 02 38 	. . 8 
	call sub_05cfh		;0ca8	cd cf 05 	. . . 
	cp 01bh		;0cab	fe 1b 	. . 
	jr z,l0cfah		;0cad	28 4b 	( K 
	cp 00dh		;0caf	fe 0d 	. . 
	jr z,l0ce0h		;0cb1	28 2d 	( - 
	cp 008h		;0cb3	fe 08 	. . 
	jr z,l0cc3h		;0cb5	28 0c 	( . 
	cp 020h		;0cb7	fe 20 	.   
	jr nc,l0cc3h		;0cb9	30 08 	0 . 
	or a			;0cbb	b7 	. 
	jr z,l0c81h		;0cbc	28 c3 	( . 
	call sub_0e55h		;0cbe	cd 55 0e 	. U . 
	jr l0c81h		;0cc1	18 be 	. . 
l0cc3h:
	push af			;0cc3	f5 	. 
	ld c,000h		;0cc4	0e 00 	. . 
	ld a,(0f443h)		;0cc6	3a 43 f4 	: C . 
	ld b,a			;0cc9	47 	G 
	ld d,028h		;0cca	16 28 	. ( 
	ld a,(0f46dh)		;0ccc	3a 6d f4 	: m . 
	ld e,a			;0ccf	5f 	_ 
	ld hl,0f444h		;0cd0	21 44 f4 	! D . 
	pop af			;0cd3	f1 	. 
	call sub_05e0h		;0cd4	cd e0 05 	. . . 
	ld a,e			;0cd7	7b 	{ 
	ld (0f46dh),a		;0cd8	32 6d f4 	2 m . 
	call sub_108ah		;0cdb	cd 8a 10 	. . . 
	jr l0c81h		;0cde	18 a1 	. . 
l0ce0h:
	ld b,028h		;0ce0	06 28 	. ( 
	ld hl,0f46bh		;0ce2	21 6b f4 	! k . 
	call sub_177ah		;0ce5	cd 7a 17 	. z . 
	ld a,b			;0ce8	78 	x 
	or a			;0ce9	b7 	. 
	jr z,l0cfah		;0cea	28 0e 	( . 
	inc hl			;0cec	23 	# 
	ld (hl),00dh		;0ced	36 0d 	6 . 
	inc a			;0cef	3c 	< 
	ld (0f016h),a		;0cf0	32 16 f0 	2 . . 
	ld de,0f444h		;0cf3	11 44 f4 	. D . 
	ld (0f014h),de		;0cf6	ed 53 14 f0 	. S . . 
l0cfah:
	call sub_0339h		;0cfa	cd 39 03 	. 9 . 
	ld hl,0ef29h		;0cfd	21 29 ef 	! ) . 
	res 4,(hl)		;0d00	cb a6 	. . 
	ret			;0d02	c9 	. 
sub_0d03h:
	ld ix,MENUDRV		;0d03	dd 21 45 ef 	. ! E . 
	ld iy,0f48ch		;0d07	fd 21 8c f4 	. ! . . 
	ld b,043h		;0d0b	06 43 	. C 
l0d0dh:
	ld a,(ix+000h)		;0d0d	dd 7e 00 	. ~ . 
	cp (iy+000h)		;0d10	fd be 00 	. . . 
	ret nz			;0d13	c0 	. 
	inc ix		;0d14	dd 23 	. # 
	inc iy		;0d16	fd 23 	. # 
	djnz l0d0dh		;0d18	10 f3 	. . 
	ret			;0d1a	c9 	. 
sub_0d1bh:
	push af			;0d1b	f5 	. 
	push bc			;0d1c	c5 	. 
	push de			;0d1d	d5 	. 
	push hl			;0d1e	e5 	. 
	push ix		;0d1f	dd e5 	. . 
	push iy		;0d21	fd e5 	. . 
	ld a,(0f43bh)		;0d23	3a 3b f4 	: ; . 
	inc a			;0d26	3c 	< 
	cp 049h		;0d27	fe 49 	. I 
	jr nz,l0d32h		;0d29	20 07 	  . 
	ld a,02ah		;0d2b	3e 2a 	> * 
	ld (0f43fh),a		;0d2d	32 3f f4 	2 ? . 
	jr l0d6eh		;0d30	18 3c 	. < 
l0d32h:
	ld (0f43bh),a		;0d32	32 3b f4 	2 ; . 
	ld a,(0f46fh)		;0d35	3a 6f f4 	: o . 
	add a,014h		;0d38	c6 14 	. . 
	ld (0f46fh),a		;0d3a	32 6f f4 	2 o . 
	ld hl,0f43dh		;0d3d	21 3d f4 	! = . 
	inc (hl)			;0d40	34 	4 
	ld a,002h		;0d41	3e 02 	> . 
	cp (hl)			;0d43	be 	. 
	jr nz,l0d67h		;0d44	20 21 	  ! 
	xor a			;0d46	af 	. 
	ld (0f43dh),a		;0d47	32 3d f4 	2 = . 
	inc a			;0d4a	3c 	< 
	ld (0f46fh),a		;0d4b	32 6f f4 	2 o . 
	ld hl,0f470h		;0d4e	21 70 f4 	! p . 
	inc (hl)			;0d51	34 	4 
	ld a,(0f43eh)		;0d52	3a 3e f4 	: > . 
	inc a			;0d55	3c 	< 
	ld (0f43eh),a		;0d56	32 3e f4 	2 > . 
	cp 006h		;0d59	fe 06 	. . 
	jr nz,l0d67h		;0d5b	20 0a 	  . 
	xor a			;0d5d	af 	. 
	ld (0f43eh),a		;0d5e	32 3e f4 	2 > . 
	inc (hl)			;0d61	34 	4 
	inc (hl)			;0d62	34 	4 
	ld hl,0f43ch		;0d63	21 3c f4 	! < . 
	inc (hl)			;0d66	34 	4 
l0d67h:
	ld bc,(0f46fh)		;0d67	ed 4b 6f f4 	. K o . 
	call XSETCUSR		;0d6b	cd be 05 	. . . 
l0d6eh:
	pop iy		;0d6e	fd e1 	. . 
	pop ix		;0d70	dd e1 	. . 
	pop hl			;0d72	e1 	. 
	pop de			;0d73	d1 	. 
	pop bc			;0d74	c1 	. 
	pop af			;0d75	f1 	. 
	ret			;0d76	c9 	. 
sub_0d77h:
	call SETERR		;0d77	cd 94 1b 	. . . 
	ld de,0f8b1h		;0d7a	11 b1 f8 	. . . 
	ld c,01ah		;0d7d	0e 1a 	. . 
	call 01bc9h		;0d7f	cd c9 1b 	. . . 
	ld de,MENUDRV		;0d82	11 45 ef 	. E . 
	ld l,00ch		;0d85	2e 0c 	. . 
l0d87h:
	dec l			;0d87	2d 	- 
	jp z,l0e52h		;0d88	ca 52 0e 	. R . 
	ld a,(de)			;0d8b	1a 	. 
	inc de			;0d8c	13 	. 
	ld (0f444h),a		;0d8d	32 44 f4 	2 D . 
	sub 041h		;0d90	d6 41 	. A 
	jr c,l0d87h		;0d92	38 f3 	8 . 
	cp 00bh		;0d94	fe 0b 	. . 
	jr c,l0da0h		;0d96	38 08 	8 . 
	sub 020h		;0d98	d6 20 	.   
	jr c,l0d87h		;0d9a	38 eb 	8 . 
	cp 00bh		;0d9c	fe 0b 	. . 
	jr nc,l0d87h		;0d9e	30 e7 	0 . 
l0da0h:
	inc a			;0da0	3c 	< 
	ld ix,0f88dh		;0da1	dd 21 8d f8 	. ! . . 
	ld (ix+000h),a		;0da5	dd 77 00 	. w . 
	xor a			;0da8	af 	. 
	ld (ix+00ch),a		;0da9	dd 77 0c 	. w . 
	ld (ix+00fh),a		;0dac	dd 77 0f 	. w . 
	push de			;0daf	d5 	. 
	push hl			;0db0	e5 	. 
	ld b,00bh		;0db1	06 0b 	. . 
l0db3h:
	inc ix		;0db3	dd 23 	. # 
	ld (ix+000h),03fh		;0db5	dd 36 00 3f 	. 6 . ? 
	djnz l0db3h		;0db9	10 f8 	. . 
	ld de,0f88dh		;0dbb	11 8d f8 	. . . 
	ld c,011h		;0dbe	0e 11 	. . 
	call 01bc9h		;0dc0	cd c9 1b 	. . . 
	pop hl			;0dc3	e1 	. 
	pop de			;0dc4	d1 	. 
	bit 7,a		;0dc5	cb 7f 	.  
	jr nz,l0d87h		;0dc7	20 be 	  . 
l0dc9h:
	push de			;0dc9	d5 	. 
	push hl			;0dca	e5 	. 
	rlca			;0dcb	07 	. 
	rlca			;0dcc	07 	. 
	rlca			;0dcd	07 	. 
	rlca			;0dce	07 	. 
	rlca			;0dcf	07 	. 
	ld b,000h		;0dd0	06 00 	. . 
	ld c,a			;0dd2	4f 	O 
	ld ix,0f8b1h		;0dd3	dd 21 b1 f8 	. ! . . 
	add ix,bc		;0dd7	dd 09 	. . 
	res 7,(ix+009h)		;0dd9	dd cb 09 be 	. . . . 
	ld iy,FTYPETBL		;0ddd	fd 21 50 ef 	. ! P . 
	ld h,004h		;0de1	26 04 	& . 
l0de3h:
	ld a,(iy+000h)		;0de3	fd 7e 00 	. ~ . 
	add a,(iy+001h)		;0de6	fd 86 01 	. . . 
	add a,(iy+002h)		;0de9	fd 86 02 	. . . 
	cp 060h		;0dec	fe 60 	. ` 
	jr z,l0e39h		;0dee	28 49 	( I 
	ld a,(ix+009h)		;0df0	dd 7e 09 	. ~ . 
	cp (iy+000h)		;0df3	fd be 00 	. . . 
	jr nz,l0e39h		;0df6	20 41 	  A 
	ld a,(ix+00ah)		;0df8	dd 7e 0a 	. ~ . 
	cp (iy+001h)		;0dfb	fd be 01 	. . . 
	jr nz,l0e39h		;0dfe	20 39 	  9 
	ld a,(ix+00bh)		;0e00	dd 7e 0b 	. ~ . 
	cp (iy+002h)		;0e03	fd be 02 	. . . 
l0e06h:
	jr nz,l0e39h		;0e06	20 31 	  1 
	call sub_0d1bh		;0e08	cd 1b 0d 	. . . 
	ld a,(0f43fh)		;0e0b	3a 3f f4 	: ? . 
	cp 020h		;0e0e	fe 20 	.   
	jr z,l0e16h		;0e10	28 04 	( . 
	pop hl			;0e12	e1 	. 
	pop de			;0e13	d1 	. 
	jr l0e52h		;0e14	18 3c 	. < 
l0e16h:
	push ix		;0e16	dd e5 	. . 
	pop hl			;0e18	e1 	. 
	ld de,0f444h		;0e19	11 44 f4 	. D . 
	push de			;0e1c	d5 	. 
	inc hl			;0e1d	23 	# 
	inc de			;0e1e	13 	. 
	ld a,03ah		;0e1f	3e 3a 	> : 
	ld (de),a			;0e21	12 	. 
	inc de			;0e22	13 	. 
	ld bc,l0006h+2		;0e23	01 08 00 	. . . 
	ldir		;0e26	ed b0 	. . 
	ld a,020h		;0e28	3e 20 	>   
	ld (de),a			;0e2a	12 	. 
	inc de			;0e2b	13 	. 
	ld bc,l0003h		;0e2c	01 03 00 	. . . 
	ldir		;0e2f	ed b0 	. . 
	pop hl			;0e31	e1 	. 
	ld a,00eh		;0e32	3e 0e 	> . 
	call sub_17f3h		;0e34	cd f3 17 	. . . 
	jr l0e43h		;0e37	18 0a 	. . 
l0e39h:
	dec h			;0e39	25 	% 
	jr z,l0e43h		;0e3a	28 07 	( . 
	ld de,l000ch+2		;0e3c	11 0e 00 	. . . 
	add iy,de		;0e3f	fd 19 	. . 
	jr l0de3h		;0e41	18 a0 	. . 
l0e43h:
	ld c,012h		;0e43	0e 12 	. . 
	call 01bc9h		;0e45	cd c9 1b 	. . . 
	pop hl			;0e48	e1 	. 
	pop de			;0e49	d1 	. 
	inc a			;0e4a	3c 	< 
	jp z,l0d87h		;0e4b	ca 87 0d 	. . . 
	dec a			;0e4e	3d 	= 
	jp l0dc9h		;0e4f	c3 c9 0d 	. . . 
l0e52h:
	jp RSTERR		;0e52	c3 9b 1b 	. . . 
sub_0e55h:
	push af			;0e55	f5 	. 
	ld a,(0f440h)		;0e56	3a 40 f4 	: @ . 
	ld b,a			;0e59	47 	G 
	ld a,(0f441h)		;0e5a	3a 41 f4 	: A . 
	ld c,a			;0e5d	4f 	O 
	ld a,(0f442h)		;0e5e	3a 42 f4 	: B . 
	ld d,a			;0e61	57 	W 
	ld a,(0f43ch)		;0e62	3a 3c f4 	: < . 
	ld e,a			;0e65	5f 	_ 
	ld a,(0f43dh)		;0e66	3a 3d f4 	: = . 
	ld h,a			;0e69	67 	g 
	ld a,(0f43eh)		;0e6a	3a 3e f4 	: > . 
	ld l,a			;0e6d	6f 	o 
	pop af			;0e6e	f1 	. 
	or a			;0e6f	b7 	. 
	jp z,l0f49h		;0e70	ca 49 0f 	. I . 
	cp 01eh		;0e73	fe 1e 	. . 
	jr z,l0e91h		;0e75	28 1a 	( . 
	cp 01fh		;0e77	fe 1f 	. . 
	jr z,l0e9fh		;0e79	28 24 	( $ 
	cp 01ch		;0e7b	fe 1c 	. . 
	jr z,l0ebfh		;0e7d	28 40 	( @ 
	cp 01dh		;0e7f	fe 1d 	. . 
	jr z,l0ee3h		;0e81	28 60 	( ` 
	cp 011h		;0e83	fe 11 	. . 
	jr z,l0efbh		;0e85	28 74 	( t 
	cp 010h		;0e87	fe 10 	. . 
	jr z,l0f04h		;0e89	28 79 	( y 
	cp 014h		;0e8b	fe 14 	. . 
	jp z,l0f0dh		;0e8d	ca 0d 0f 	. . . 
	ret			;0e90	c9 	. 
l0e91h:
	call sub_1040h		;0e91	cd 40 10 	. @ . 
	jr nz,l0f04h		;0e94	20 6e 	  n 
	inc d			;0e96	14 	. 
	dec d			;0e97	15 	. 
	jp z,l0f2ch		;0e98	ca 2c 0f 	. , . 
	dec d			;0e9b	15 	. 
	jp l0f25h		;0e9c	c3 25 0f 	. % . 
l0e9fh:
	call sub_1040h		;0e9f	cd 40 10 	. @ . 
	jr nz,l0efbh		;0ea2	20 57 	  W 
	ld a,d			;0ea4	7a 	z 
	cp 005h		;0ea5	fe 05 	. . 
	jp z,l0f2ch		;0ea7	ca 2c 0f 	. , . 
	ld a,b			;0eaa	78 	x 
	cp e			;0eab	bb 	. 
	jr nz,l0ebbh		;0eac	20 0d 	  . 
	ld a,l			;0eae	7d 	} 
	sub d			;0eaf	92 	. 
	jp z,l0f2ch		;0eb0	ca 2c 0f 	. , . 
	dec a			;0eb3	3d 	= 
	jr nz,l0ebbh		;0eb4	20 05 	  . 
	ld a,h			;0eb6	7c 	| 
	cp c			;0eb7	b9 	. 
	jp c,l0f2ch		;0eb8	da 2c 0f 	. , . 
l0ebbh:
	inc d			;0ebb	14 	. 
	jp l0f25h		;0ebc	c3 25 0f 	. % . 
l0ebfh:
	ld a,c			;0ebf	79 	y 
	add a,d			;0ec0	82 	. 
	cp 006h		;0ec1	fe 06 	. . 
	jr z,l0edeh		;0ec3	28 19 	( . 
	ld a,b			;0ec5	78 	x 
	cp e			;0ec6	bb 	. 
	jr nz,l0ed1h		;0ec7	20 08 	  . 
	ld a,c			;0ec9	79 	y 
	cp h			;0eca	bc 	. 
	jr nz,l0ed1h		;0ecb	20 04 	  . 
	ld a,d			;0ecd	7a 	z 
	cp l			;0ece	bd 	. 
	jr z,l0edeh		;0ecf	28 0d 	( . 
l0ed1h:
	ld a,c			;0ed1	79 	y 
	cp 001h		;0ed2	fe 01 	. . 
	jr nz,l0edbh		;0ed4	20 05 	  . 
	xor a			;0ed6	af 	. 
	ld c,a			;0ed7	4f 	O 
	inc d			;0ed8	14 	. 
	jr l0f25h		;0ed9	18 4a 	. J 
l0edbh:
	inc c			;0edb	0c 	. 
	jr l0f25h		;0edc	18 47 	. G 
l0edeh:
	xor a			;0ede	af 	. 
	ld c,a			;0edf	4f 	O 
	ld d,a			;0ee0	57 	W 
	jr l0f25h		;0ee1	18 42 	. B 
l0ee3h:
	inc c			;0ee3	0c 	. 
	dec c			;0ee4	0d 	. 
	jr nz,l0ef8h		;0ee5	20 11 	  . 
	ld c,001h		;0ee7	0e 01 	. . 
	dec d			;0ee9	15 	. 
	ld a,d			;0eea	7a 	z 
	inc a			;0eeb	3c 	< 
	jr nz,l0f25h		;0eec	20 37 	  7 
	ld d,005h		;0eee	16 05 	. . 
	ld a,b			;0ef0	78 	x 
	cp e			;0ef1	bb 	. 
	jr nz,l0f25h		;0ef2	20 31 	  1 
	ld c,h			;0ef4	4c 	L 
	ld d,l			;0ef5	55 	U 
	jr l0f25h		;0ef6	18 2d 	. - 
l0ef8h:
	dec c			;0ef8	0d 	. 
	jr l0f25h		;0ef9	18 2a 	. * 
l0efbh:
	ld a,b			;0efb	78 	x 
	cp e			;0efc	bb 	. 
	jr z,l0f2ch		;0efd	28 2d 	( - 
	inc b			;0eff	04 	. 
l0f00h:
	ld c,011h		;0f00	0e 11 	. . 
	jr l0f1ah		;0f02	18 16 	. . 
l0f04h:
	inc b			;0f04	04 	. 
	dec b			;0f05	05 	. 
	jr z,l0f2ch		;0f06	28 24 	( $ 
	dec b			;0f08	05 	. 
	ld c,010h		;0f09	0e 10 	. . 
	jr l0f1ah		;0f0b	18 0d 	. . 
l0f0dh:
	inc b			;0f0d	04 	. 
l0f0eh:
	dec b			;0f0e	05 	. 
	jr z,l0f2ch		;0f0f	28 1b 	( . 
	ld b,000h		;0f11	06 00 	. . 
	ld c,01bh		;0f13	0e 1b 	. . 
	call sub_059dh		;0f15	cd 9d 05 	. . . 
	ld c,0d4h		;0f18	0e d4 	. . 
l0f1ah:
	call sub_059dh		;0f1a	cd 9d 05 	. . . 
	xor a			;0f1d	af 	. 
	ld c,a			;0f1e	4f 	O 
	ld d,a			;0f1f	57 	W 
	ld (0f4d0h),a		;0f20	32 d0 f4 	2 . . 
	jr l0f31h		;0f23	18 0c 	. . 
l0f25h:
	ld a,001h		;0f25	3e 01 	> . 
	ld (0f4d0h),a		;0f27	32 d0 f4 	2 . . 
	jr l0f31h		;0f2a	18 05 	. . 
l0f2ch:
	ld a,0ffh		;0f2c	3e ff 	> . 
	ld (0f4d0h),a		;0f2e	32 d0 f4 	2 . . 
l0f31h:
	ld a,b			;0f31	78 	x 
	ld (0f440h),a		;0f32	32 40 f4 	2 @ . 
	ld a,(0f441h)		;0f35	3a 41 f4 	: A . 
	ld (0f471h),a		;0f38	32 71 f4 	2 q . 
	ld a,(0f442h)		;0f3b	3a 42 f4 	: B . 
	ld (0f472h),a		;0f3e	32 72 f4 	2 r . 
	ld a,c			;0f41	79 	y 
	ld (0f441h),a		;0f42	32 41 f4 	2 A . 
	ld a,d			;0f45	7a 	z 
	ld (0f442h),a		;0f46	32 42 f4 	2 B . 
l0f49h:
	ld a,002h		;0f49	3e 02 	> . 
	ld (0f46eh),a		;0f4b	32 6e f4 	2 n . 
	ld a,0fah		;0f4e	3e fa 	> . 
	inc b			;0f50	04 	. 
l0f51h:
	add a,008h		;0f51	c6 08 	. . 
	djnz l0f51h		;0f53	10 fc 	. . 
	dec a			;0f55	3d 	= 
	ld (0f443h),a		;0f56	32 43 f4 	2 C . 
	inc a			;0f59	3c 	< 
	add a,d			;0f5a	82 	. 
	ld (0f470h),a		;0f5b	32 70 f4 	2 p . 
	inc c			;0f5e	0c 	. 
	dec c			;0f5f	0d 	. 
	jr z,l0f66h		;0f60	28 04 	( . 
	ld a,015h		;0f62	3e 15 	> . 
	jr l0f68h		;0f64	18 02 	. . 
l0f66h:
	xor a			;0f66	af 	. 
	inc a			;0f67	3c 	< 
l0f68h:
	ld (0f46fh),a		;0f68	32 6f f4 	2 o . 
	call sub_104bh		;0f6b	cd 4b 10 	. K . 
	ld de,l000ch+1		;0f6e	11 0d 00 	. . . 
	call sub_1094h		;0f71	cd 94 10 	. . . 
	call sub_513ch		;0f74	cd 3c 51 	. < Q 
	ld de,l00ffh+1		;0f77	11 00 01 	. . . 
	call sub_5038h		;0f7a	cd 38 50 	. 8 P 
	call sub_5202h		;0f7d	cd 02 52 	. . R 
	call sub_512ch		;0f80	cd 2c 51 	. , Q 
	ld hl,0f444h		;0f83	21 44 f4 	! D . 
	ld b,028h		;0f86	06 28 	. ( 
	call sub_1656h		;0f88	cd 56 16 	. V . 
	ld de,(0f46fh)		;0f8b	ed 5b 6f f4 	. [ o . 
	inc e			;0f8f	1c 	. 
	inc d			;0f90	14 	. 
	call sub_4fbeh		;0f91	cd be 4f 	. . O 
	ld de,0f444h		;0f94	11 44 f4 	. D . 
	ld bc,l000ch+2		;0f97	01 0e 00 	. . . 
	ldir		;0f9a	ed b0 	. . 
	ld ix,0f444h		;0f9c	dd 21 44 f4 	. ! D . 
	ld iy,FTYPETBL		;0fa0	fd 21 50 ef 	. ! P . 
	ld hl,0ef54h		;0fa4	21 54 ef 	! T . 
	ld de,l000ch+2		;0fa7	11 0e 00 	. . . 
	ld bc,l0402h		;0faa	01 02 04 	. . . 
l0fadh:
	ld a,(ix+00bh)		;0fad	dd 7e 0b 	. ~ . 
	cp (iy+000h)		;0fb0	fd be 00 	. . . 
	jr nz,l0fc6h		;0fb3	20 11 	  . 
	ld a,(ix+00ch)		;0fb5	dd 7e 0c 	. ~ . 
	cp (iy+001h)		;0fb8	fd be 01 	. . . 
	jr nz,l0fc6h		;0fbb	20 09 	  . 
	ld a,(ix+00dh)		;0fbd	dd 7e 0d 	. ~ . 
	cp (iy+002h)		;0fc0	fd be 02 	. . . 
	ld a,c			;0fc3	79 	y 
	jr z,l0fcch		;0fc4	28 06 	( . 
l0fc6h:
	inc c			;0fc6	0c 	. 
	add iy,de		;0fc7	fd 19 	. . 
	add hl,de			;0fc9	19 	. 
	djnz l0fadh		;0fca	10 e1 	. . 
l0fcch:
	ld (0f46eh),a		;0fcc	32 6e f4 	2 n . 
	dec a			;0fcf	3d 	= 
	ld b,a			;0fd0	47 	G 
	ld a,(0f48bh)		;0fd1	3a 8b f4 	: . . 
	cp b			;0fd4	b8 	. 
	ld a,b			;0fd5	78 	x 
	jr nz,l0fe7h		;0fd6	20 0f 	  . 
	ld a,020h		;0fd8	3e 20 	>   
	ld (ix+00bh),a		;0fda	dd 77 0b 	. w . 
	ld (ix+00ch),a		;0fdd	dd 77 0c 	. w . 
	ld (ix+00dh),a		;0fe0	dd 77 0d 	. w . 
	ld a,00bh		;0fe3	3e 0b 	> . 
	jr l1026h		;0fe5	18 3f 	. ? 
l0fe7h:
	push hl			;0fe7	e5 	. 
	ld a,02eh		;0fe8	3e 2e 	> . 
	ld (0f44eh),a		;0fea	32 4e f4 	2 N . 
	ld hl,0f444h		;0fed	21 44 f4 	! D . 
	push hl			;0ff0	e5 	. 
	pop de			;0ff1	d1 	. 
	ld b,00eh		;0ff2	06 0e 	. . 
l0ff4h:
	ld a,(hl)			;0ff4	7e 	~ 
	cp 020h		;0ff5	fe 20 	.   
	jr z,l0ffbh		;0ff7	28 02 	( . 
	ld (de),a			;0ff9	12 	. 
	inc de			;0ffa	13 	. 
l0ffbh:
	inc hl			;0ffb	23 	# 
	djnz l0ff4h		;0ffc	10 f6 	. . 
	push de			;0ffe	d5 	. 
	ex de,hl			;0fff	eb 	. 
	ld de,0f444h		;1000	11 44 f4 	. D . 
	sbc hl,de		;1003	ed 52 	. R 
	ld a,00ch		;1005	3e 0c 	> . 
	add a,l			;1007	85 	. 
	pop hl			;1008	e1 	. 
	push af			;1009	f5 	. 
	ld b,00eh		;100a	06 0e 	. . 
	call sub_1656h		;100c	cd 56 16 	. V . 
	ld hl,0f451h		;100f	21 51 f4 	! Q . 
	ld de,0f45ch		;1012	11 5c f4 	. \ . 
	ld bc,l000ch+2		;1015	01 0e 00 	. . . 
	lddr		;1018	ed b8 	. . 
	ld a,020h		;101a	3e 20 	>   
l101ch:
	ld (de),a			;101c	12 	. 
	inc hl			;101d	23 	# 
	ex de,hl			;101e	eb 	. 
	pop af			;101f	f1 	. 
	pop hl			;1020	e1 	. 
	ld bc,l0009h+1		;1021	01 0a 00 	. . . 
	ldir		;1024	ed b0 	. . 
l1026h:
	ld (0f46dh),a		;1026	32 6d f4 	2 m . 
	push af			;1029	f5 	. 
	ld c,000h		;102a	0e 00 	. . 
	inc a			;102c	3c 	< 
	ld d,a			;102d	57 	W 
	ld e,000h		;102e	1e 00 	. . 
	ld a,(0f443h)		;1030	3a 43 f4 	: C . 
	ld b,a			;1033	47 	G 
	ld hl,0f444h		;1034	21 44 f4 	! D . 
	xor a			;1037	af 	. 
	call sub_05e0h		;1038	cd e0 05 	. . . 
	pop af			;103b	f1 	. 
	ld e,a			;103c	5f 	_ 
	jp sub_108ah		;103d	c3 8a 10 	. . . 
sub_1040h:
	ld a,(0f775h)		;1040	3a 75 f7 	: u . 
	bit 7,a		;1043	cb 7f 	.  
	ret z			;1045	c8 	. 
	ld a,(0f01ch)		;1046	3a 1c f0 	: . . 
	or a			;1049	b7 	. 
	ret			;104a	c9 	. 
sub_104bh:
	ld a,(0f4d0h)		;104b	3a d0 f4 	: . . 
	inc a			;104e	3c 	< 
	ret z			;104f	c8 	. 
	cp 001h		;1050	fe 01 	. . 
	jr z,l105fh		;1052	28 0b 	( . 
	ld a,(0f471h)		;1054	3a 71 f4 	: q . 
	ld d,a			;1057	57 	W 
	ld a,(0f472h)		;1058	3a 72 f4 	: r . 
	ld e,a			;105b	5f 	_ 
	call sub_1069h		;105c	cd 69 10 	. i . 
l105fh:
	ld a,(0f441h)		;105f	3a 41 f4 	: A . 
	ld d,a			;1062	57 	W 
	ld a,(0f442h)		;1063	3a 42 f4 	: B . 
	ld e,a			;1066	5f 	_ 
	jr sub_1069h		;1067	18 00 	. . 
sub_1069h:
	inc d			;1069	14 	. 
	ld a,001h		;106a	3e 01 	> . 
	cp d			;106c	ba 	. 
	jr z,l1071h		;106d	28 02 	( . 
	ld d,015h		;106f	16 15 	. . 
l1071h:
	inc e			;1071	1c 	. 
	inc e			;1072	1c 	. 
	inc e			;1073	1c 	. 
	push de			;1074	d5 	. 
	ld hl,l119dh		;1075	21 9d 11 	! . . 
	call sub_0593h		;1078	cd 93 05 	. . . 
	pop de			;107b	d1 	. 
	ld c,e			;107c	4b 	K 
	call sub_059dh		;107d	cd 9d 05 	. . . 
	ld c,d			;1080	4a 	J 
	call sub_059dh		;1081	cd 9d 05 	. . . 
	ld hl,l11a0h		;1084	21 a0 11 	! . . 
	jp sub_0593h		;1087	c3 93 05 	. . . 
sub_108ah:
	ld a,c			;108a	79 	y 
	add a,e			;108b	83 	. 
	ld c,a			;108c	4f 	O 
	ld a,(0f443h)		;108d	3a 43 f4 	: C . 
	ld b,a			;1090	47 	G 
	jp XSETCUSR		;1091	c3 be 05 	. . . 
sub_1094h:
	push de			;1094	d5 	. 
	ld hl,0f473h		;1095	21 73 f4 	! s . 
	ld c,000h		;1098	0e 00 	. . 
	call sub_10afh		;109a	cd af 10 	. . . 
	pop de			;109d	d1 	. 
	ld b,015h		;109e	06 15 	. . 
	inc hl			;10a0	23 	# 
	inc hl			;10a1	23 	# 
l10a2h:
	ld c,(hl)			;10a2	4e 	N 
	push hl			;10a3	e5 	. 
	call sub_584bh		;10a4	cd 4b 58 	. K X 
	pop hl			;10a7	e1 	. 
	djnz l10abh		;10a8	10 01 	. . 
	ret			;10aa	c9 	. 
l10abh:
	inc hl			;10ab	23 	# 
	inc e			;10ac	1c 	. 
	jr l10a2h		;10ad	18 f3 	. . 
sub_10afh:
	push hl			;10af	e5 	. 
	push hl			;10b0	e5 	. 
	push hl			;10b1	e5 	. 
	ex de,hl			;10b2	eb 	. 
	call sub_2a87h		;10b3	cd 87 2a 	. . * 
	pop hl			;10b6	e1 	. 
	ld bc,l0006h		;10b7	01 06 00 	. . . 
	add hl,bc			;10ba	09 	. 
	ld b,(hl)			;10bb	46 	F 
	pop hl			;10bc	e1 	. 
	push bc			;10bd	c5 	. 
	push hl			;10be	e5 	. 
	pop de			;10bf	d1 	. 
	push hl			;10c0	e5 	. 
	call sub_1124h		;10c1	cd 24 11 	. $ . 
	ld bc,l0009h+2		;10c4	01 0b 00 	. . . 
	add hl,bc			;10c7	09 	. 
	push hl			;10c8	e5 	. 
	pop de			;10c9	d1 	. 
	add hl,bc			;10ca	09 	. 
	ex de,hl			;10cb	eb 	. 
	call sub_1118h		;10cc	cd 18 11 	. . . 
	ld b,006h		;10cf	06 06 	. . 
l10d1h:
	dec de			;10d1	1b 	. 
	djnz l10d1h		;10d2	10 fd 	. . 
	call sub_1118h		;10d4	cd 18 11 	. . . 
	pop hl			;10d7	e1 	. 
	ld bc,l0009h+1		;10d8	01 0a 00 	. . . 
	add hl,bc			;10db	09 	. 
	ex de,hl			;10dc	eb 	. 
	ld hl,01185h		;10dd	21 85 11 	! . . 
	pop bc			;10e0	c1 	. 
	inc b			;10e1	04 	. 
	ld a,b			;10e2	78 	x 
	cp 008h		;10e3	fe 08 	. . 
	jr c,l10ech		;10e5	38 05 	8 . 
	ld hl,01185h		;10e7	21 85 11 	! . . 
	jr l10f1h		;10ea	18 05 	. . 
l10ech:
	inc hl			;10ec	23 	# 
	inc hl			;10ed	23 	# 
	inc hl			;10ee	23 	# 
	djnz l10ech		;10ef	10 fb 	. . 
l10f1h:
	ld bc,l0003h		;10f1	01 03 00 	. . . 
	ldir		;10f4	ed b0 	. . 
	pop hl			;10f6	e1 	. 
	push hl			;10f7	e5 	. 
	ld bc,l0001h+1		;10f8	01 02 00 	. . . 
	add hl,bc			;10fb	09 	. 
	ld (hl),020h		;10fc	36 20 	6   
	inc bc			;10fe	03 	. 
	add hl,bc			;10ff	09 	. 
	ld (hl),02fh		;1100	36 2f 	6 / 
	add hl,bc			;1102	09 	. 
	ld (hl),020h		;1103	36 20 	6   
	inc hl			;1105	23 	# 
l1106h:
	ld (hl),028h		;1106	36 28 	6 ( 
	inc bc			;1108	03 	. 
	add hl,bc			;1109	09 	. 
	ld (hl),029h		;110a	36 29 	6 ) 
	inc hl			;110c	23 	# 
	ld (hl),020h		;110d	36 20 	6   
	dec bc			;110f	0b 	. 
	add hl,bc			;1110	09 	. 
	ld (hl),03ah		;1111	36 3a 	6 : 
	add hl,bc			;1113	09 	. 
	ld (hl),03ah		;1114	36 3a 	6 : 
	pop hl			;1116	e1 	. 
	ret			;1117	c9 	. 
sub_1118h:
	ld a,003h		;1118	3e 03 	> . 
l111ah:
	ld bc,l0001h+1		;111a	01 02 00 	. . . 
	lddr		;111d	ed b8 	. . 
	dec de			;111f	1b 	. 
	dec a			;1120	3d 	= 
	jr nz,l111ah		;1121	20 f7 	  . 
	ret			;1123	c9 	. 
sub_1124h:
	push hl			;1124	e5 	. 
	push de			;1125	d5 	. 
	ld bc,l0009h+2		;1126	01 0b 00 	. . . 
	add hl,bc			;1129	09 	. 
	ex de,hl			;112a	eb 	. 
	ld bc,RBDOS1		;112b	01 05 00 	. . . 
	add hl,bc			;112e	09 	. 
	ld b,006h		;112f	06 06 	. . 
l1131h:
	ld a,(hl)			;1131	7e 	~ 
	push af			;1132	f5 	. 
	call sub_1144h		;1133	cd 44 11 	. D . 
	pop af			;1136	f1 	. 
	rrca			;1137	0f 	. 
	rrca			;1138	0f 	. 
	rrca			;1139	0f 	. 
	rrca			;113a	0f 	. 
	call sub_1144h		;113b	cd 44 11 	. D . 
	dec hl			;113e	2b 	+ 
	djnz l1131h		;113f	10 f0 	. . 
	pop de			;1141	d1 	. 
	pop hl			;1142	e1 	. 
	ret			;1143	c9 	. 
sub_1144h:
	and 00fh		;1144	e6 0f 	. . 
	cp 00fh		;1146	fe 0f 	. . 
	jr z,l114eh		;1148	28 04 	( . 
	add a,030h		;114a	c6 30 	. 0 
	jr l1150h		;114c	18 02 	. . 
l114eh:
	ld a,02ah		;114e	3e 2a 	> * 
l1150h:
	ld (de),a			;1150	12 	. 
	dec de			;1151	1b 	. 
	ret			;1152	c9 	. 
sub_1153h:
	push hl			;1153	e5 	. 
	push de			;1154	d5 	. 
	ld b,006h		;1155	06 06 	. . 
l1157h:
	ld a,(hl)			;1157	7e 	~ 
	inc hl			;1158	23 	# 
	cp 02ah		;1159	fe 2a 	. * 
	jp nz,l1160h		;115b	c2 60 11 	. ` . 
	ld a,00fh		;115e	3e 0f 	> . 
l1160h:
	rla			;1160	17 	. 
	rla			;1161	17 	. 
	rla			;1162	17 	. 
	rla			;1163	17 	. 
	and 0f0h		;1164	e6 f0 	. . 
	ld c,a			;1166	4f 	O 
	ld a,(hl)			;1167	7e 	~ 
	inc hl			;1168	23 	# 
	cp 02ah		;1169	fe 2a 	. * 
	jr nz,l116fh		;116b	20 02 	  . 
	ld a,00fh		;116d	3e 0f 	> . 
l116fh:
	and 00fh		;116f	e6 0f 	. . 
	or c			;1171	b1 	. 
	ld (de),a			;1172	12 	. 
	inc de			;1173	13 	. 
	djnz l1157h		;1174	10 e1 	. . 
	pop de			;1176	d1 	. 
	pop hl			;1177	e1 	. 
	ret			;1178	c9 	. 
l1179h:
	dec de			;1179	1b 	. 
	ret nc			;117a	d0 	. 
	ld (l0c28h),a		;117b	32 28 0c 	2 ( . 
	dec de			;117e	1b 	. 
	sub 002h		;117f	d6 02 	. . 
	dec de			;1181	1b 	. 
	sub l			;1182	95 	. 
	ld bc,BIOSTBL		;1183	01 ff 2a 	. . * 
	ld hl,(0532ah)		;1186	2a 2a 53 	* * S 
	ld d,l			;1189	55 	U 
	ld c,(hl)			;118a	4e 	N 
	ld c,l			;118b	4d 	M 
	ld c,a			;118c	4f 	O 
	ld c,(hl)			;118d	4e 	N 
	ld d,h			;118e	54 	T 
	ld d,l			;118f	55 	U 
	ld b,l			;1190	45 	E 
	ld d,a			;1191	57 	W 
	ld b,l			;1192	45 	E 
	ld b,h			;1193	44 	D 
	ld d,h			;1194	54 	T 
	ld c,b			;1195	48 	H 
	ld d,l			;1196	55 	U 
	ld b,(hl)			;1197	46 	F 
	ld d,d			;1198	52 	R 
	ld c,c			;1199	49 	I 
	ld d,e			;119a	53 	S 
	ld b,c			;119b	41 	A 
	ld d,h			;119c	54 	T 
l119dh:
	dec de			;119d	1b 	. 
	jr z,$+1		;119e	28 ff 	( . 
l11a0h:
	nop			;11a0	00 	. 
	djnz $+1		;11a1	10 ff 	. . 
l11a3h:
	ld a,(0eff2h)		;11a3	3a f2 ef 	: . . 
	ld b,a			;11a6	47 	G 
	ld a,(0eff0h)		;11a7	3a f0 ef 	: . . 
	or b			;11aa	b0 	. 
	ret nz			;11ab	c0 	. 
	ld hl,0ef29h		;11ac	21 29 ef 	! ) . 
	ld a,(hl)			;11af	7e 	~ 
	and 007h		;11b0	e6 07 	. . 
	ret nz			;11b2	c0 	. 
	set 2,(hl)		;11b3	cb d6 	. . 
	ld hl,0efefh		;11b5	21 ef ef 	! . . 
	set 4,(hl)		;11b8	cb e6 	. . 
	ld hl,0eff1h		;11ba	21 f1 ef 	! . . 
	set 4,(hl)		;11bd	cb e6 	. . 
	ld a,(DFTATR)		;11bf	3a e4 f2 	: . . 
	ld (TACATR),a		;11c2	32 d1 f7 	2 . . 
	ld a,(VERDFLT)		;11c5	3a be ef 	: . . 
	ld (0efbfh),a		;11c8	32 bf ef 	2 . . 
	ld hl,YPFCMFLG		;11cb	21 17 f0 	! . . 
	ld a,(hl)			;11ce	7e 	~ 
	ld (0f4dfh),a		;11cf	32 df f4 	2 . . 
	ld a,0ffh		;11d2	3e ff 	> . 
	ld (hl),a			;11d4	77 	w 
	call sub_15e3h		;11d5	cd e3 15 	. . . 
	call XSETSCRN		;11d8	cd 29 59 	. ) Y 
l11dbh:
	call sub_076eh		;11db	cd 6e 07 	. n . 
	ld hl,l17feh		;11de	21 fe 17 	! . . 
	call sub_0593h		;11e1	cd 93 05 	. . . 
	call sub_1317h		;11e4	cd 17 13 	. . . 
	call sub_1322h		;11e7	cd 22 13 	. " . 
	call sub_12c5h		;11ea	cd c5 12 	. . . 
	call sub_12f2h		;11ed	cd f2 12 	. . . 
	call sub_12fdh		;11f0	cd fd 12 	. . . 
	call sub_133bh		;11f3	cd 3b 13 	. ; . 
	call l0343h		;11f6	cd 43 03 	. C . 
l11f9h:
	call sub_1634h		;11f9	cd 34 16 	. 4 . 
	ld hl,l1878h		;11fc	21 78 18 	! x . 
	call sub_0593h		;11ff	cd 93 05 	. . . 
	call sub_6b2bh		;1202	cd 2b 6b 	. + k 
	ld de,l0006h+2		;1205	11 08 00 	. . . 
	jr z,l120bh		;1208	28 01 	( . 
	add hl,de			;120a	19 	. 
l120bh:
	call sub_0593h		;120b	cd 93 05 	. . . 
l120eh:
	call sub_1345h		;120e	cd 45 13 	. E . 
	ld bc,l0517h		;1211	01 17 05 	. . . 
	call XSETCUSR		;1214	cd be 05 	. . . 
l1217h:
	ld hl,0eff2h		;1217	21 f2 ef 	! . . 
	bit 4,(hl)		;121a	cb 66 	. f 
	jr z,l1223h		;121c	28 05 	( . 
	call sub_0a5ch		;121e	cd 5c 0a 	. \ . 
	jr l11dbh		;1221	18 b8 	. . 
l1223h:
	ld hl,0eff0h		;1223	21 f0 ef 	! . . 
	ld a,(hl)			;1226	7e 	~ 
	and 0dfh		;1227	e6 df 	. . 
	ld (hl),a			;1229	77 	w 
	jr nz,l128eh		;122a	20 62 	  b 
	call sub_1696h		;122c	cd 96 16 	. . . 
	jr c,l11f9h		;122f	38 c8 	8 . 
	jr z,l128eh		;1231	28 5b 	( [ 
	inc c			;1233	0c 	. 
	jr z,l124dh		;1234	28 17 	( . 
	sub 031h		;1236	d6 31 	. 1 
	jp z,l135dh		;1238	ca 5d 13 	. ] . 
	dec a			;123b	3d 	= 
	jp z,l137eh		;123c	ca 7e 13 	. ~ . 
	dec a			;123f	3d 	= 
	jp z,l1448h		;1240	ca 48 14 	. H . 
	dec a			;1243	3d 	= 
	jp z,l1481h		;1244	ca 81 14 	. . . 
	dec a			;1247	3d 	= 
	jp z,l14feh		;1248	ca fe 14 	. . . 
	jr l1217h		;124b	18 ca 	. . 
l124dh:
	cp 0e9h		;124d	fe e9 	. . 
	jr z,l1217h		;124f	28 c6 	( . 
	ld b,a			;1251	47 	G 
	call sub_6b2bh		;1252	cd 2b 6b 	. + k 
	jr nz,l1217h		;1255	20 c0 	  . 
	ld a,(OPNMOD)		;1257	3a 55 f3 	: U . 
	or a			;125a	b7 	. 
	jr nz,l1217h		;125b	20 ba 	  . 
	ld a,(TAPMOD)		;125d	3a e1 f2 	: . . 
	or a			;1260	b7 	. 
	ld a,b			;1261	78 	x 
	jr nz,l126ah		;1262	20 06 	  . 
	cp 0e5h		;1264	fe e5 	. . 
	jr z,l1217h		;1266	28 af 	( . 
	jr l126eh		;1268	18 04 	. . 
l126ah:
	cp 0e5h		;126a	fe e5 	. . 
	jr nz,l1217h		;126c	20 a9 	  . 
l126eh:
	push bc			;126e	c5 	. 
	call sub_15dch		;126f	cd dc 15 	. . . 
	pop af			;1272	f1 	. 
	and 00fh		;1273	e6 0f 	. . 
	ld hl,l127ch		;1275	21 7c 12 	! | . 
	call sub_5e4ch		;1278	cd 4c 5e 	. L ^ 
	jp (hl)			;127b	e9 	. 
l127ch:
	ld a,l			;127c	7d 	} 
	dec d			;127d	15 	. 
	add a,c			;127e	81 	. 
	dec d			;127f	15 	. 
	adc a,b			;1280	88 	. 
	dec d			;1281	15 	. 
	adc a,l			;1282	8d 	. 
	dec d			;1283	15 	. 
	sub h			;1284	94 	. 
	dec d			;1285	15 	. 
	sbc a,c			;1286	99 	. 
	dec d			;1287	15 	. 
	cp l			;1288	bd 	. 
	dec d			;1289	15 	. 
	ret z			;128a	c8 	. 
	dec d			;128b	15 	. 
	sub 015h		;128c	d6 15 	. . 
l128eh:
	call sub_15dch		;128e	cd dc 15 	. . . 
	call XUSRSCRN		;1291	cd 31 59 	. 1 Y 
	ld a,(0f4dfh)		;1294	3a df f4 	: . . 
	ld (YPFCMFLG),a		;1297	32 17 f0 	2 . . 
	call sub_15f8h		;129a	cd f8 15 	. . . 
	ld hl,0eff1h		;129d	21 f1 ef 	! . . 
	call sub_12b8h		;12a0	cd b8 12 	. . . 
	ld hl,0efefh		;12a3	21 ef ef 	! . . 
	call sub_12b8h		;12a6	cd b8 12 	. . . 
	ld hl,0ef29h		;12a9	21 29 ef 	! ) . 
	bit 4,(hl)		;12ac	cb 66 	. f 
	jr z,l12b5h		;12ae	28 05 	( . 
	ld a,0ffh		;12b0	3e ff 	> . 
	ld (0f4cfh),a		;12b2	32 cf f4 	2 . . 
l12b5h:
	res 2,(hl)		;12b5	cb 96 	. . 
	ret			;12b7	c9 	. 
sub_12b8h:
	set 7,(hl)		;12b8	cb fe 	. . 
	res 4,(hl)		;12ba	cb a6 	. . 
	dec hl			;12bc	2b 	+ 
	bit 4,(hl)		;12bd	cb 66 	. f 
	ret z			;12bf	c8 	. 
	set 7,(hl)		;12c0	cb fe 	. . 
	res 4,(hl)		;12c2	cb a6 	. . 
	ret			;12c4	c9 	. 
sub_12c5h:
	ld bc,00120h		;12c5	01 20 01 	.   . 
	call XSETCUSR		;12c8	cd be 05 	. . . 
	ld a,(ALRMTP)		;12cb	3a 8a ef 	: . . 
	cp 002h		;12ce	fe 02 	. . 
	ld hl,l12edh		;12d0	21 ed 12 	! . . 
	jr z,l12deh		;12d3	28 09 	( . 
l12d5h:
	or a			;12d5	b7 	. 
	ld hl,012e8h		;12d6	21 e8 12 	! . . 
	jr z,l12deh		;12d9	28 03 	( . 
	ld hl,l12e3h		;12db	21 e3 12 	! . . 
l12deh:
	ld a,005h		;12de	3e 05 	> . 
l12e0h:
	jp sub_17f3h		;12e0	c3 f3 17 	. . . 
l12e3h:
	ld c,a			;12e3	4f 	O 
	ld c,(hl)			;12e4	4e 	N 
	jr nz,l1307h		;12e5	20 20 	    
	jr nz,l1338h		;12e7	20 4f 	  O 
	ld b,(hl)			;12e9	46 	F 
	ld b,(hl)			;12ea	46 	F 
	jr nz,l130dh		;12eb	20 20 	    
l12edh:
	ld c,a			;12ed	4f 	O 
	ld c,(hl)			;12ee	4e 	N 
	jr z,l1348h		;12ef	28 57 	( W 
	add hl,hl			;12f1	29 	) 
sub_12f2h:
	ld bc,00220h		;12f2	01 20 02 	.   . 
	call XSETCUSR		;12f5	cd be 05 	. . . 
	ld a,(AUTOSTRT)		;12f8	3a bd f3 	: . . 
	jr l12d5h		;12fb	18 d8 	. . 
sub_12fdh:
	ld bc,l0320h		;12fd	01 20 03 	.   . 
	call XSETCUSR		;1300	cd be 05 	. . . 
	ld a,(MENUFG)		;1303	3a 44 ef 	: D . 
	inc a			;1306	3c 	< 
l1307h:
	call l12d5h		;1307	cd d5 12 	. . . 
	ld bc,l030dh		;130a	01 0d 03 	. . . 
l130dh:
	call XSETCUSR		;130d	cd be 05 	. . . 
	ld a,00bh		;1310	3e 0b 	> . 
	ld hl,MENUDRV		;1312	21 45 ef 	! E . 
	jr l12e0h		;1315	18 c9 	. . 
sub_1317h:
	ld bc,0010dh		;1317	01 0d 01 	. . . 
	call XSETCUSR		;131a	cd be 05 	. . . 
	ld a,(YSIZERAM)		;131d	3a 7a f7 	: z . 
	jr l132bh		;1320	18 09 	. . 
sub_1322h:
	ld bc,0020dh		;1322	01 0d 02 	. . . 
	call XSETCUSR		;1325	cd be 05 	. . . 
	ld a,(USERBIOS)		;1328	3a 2d ef 	: - . 
l132bh:
	ld d,000h		;132b	16 00 	. . 
	ld e,a			;132d	5f 	_ 
	ld hl,0f419h		;132e	21 19 f4 	! . . 
	call sub_17a1h		;1331	cd a1 17 	. . . 
	inc hl			;1334	23 	# 
	inc hl			;1335	23 	# 
	ld a,003h		;1336	3e 03 	> . 
l1338h:
	jp sub_17f3h		;1338	c3 f3 17 	. . . 
sub_133bh:
	call sub_6b2bh		;133b	cd 2b 6b 	. + k 
	ret z			;133e	c8 	. 
	ld b,004h		;133f	06 04 	. . 
	call sub_1641h		;1341	cd 41 16 	. A . 
	ret			;1344	c9 	. 
sub_1345h:
	call sub_6b2bh		;1345	cd 2b 6b 	. + k 
l1348h:
	ret nz			;1348	c0 	. 
	ld a,(OPNMOD)		;1349	3a 55 f3 	: U . 
	or a			;134c	b7 	. 
	ret nz			;134d	c0 	. 
	ld hl,l18cbh		;134e	21 cb 18 	! . . 
	ld a,(TAPMOD)		;1351	3a e1 f2 	: . . 
	or a			;1354	b7 	. 
	jr z,l135ah		;1355	28 03 	( . 
	ld hl,l18f3h		;1357	21 f3 18 	! . . 
l135ah:
	jp sub_0593h		;135a	c3 93 05 	. . . 
l135dh:
	ld a,(0ef9bh)		;135d	3a 9b ef 	: . . 
	or a			;1360	b7 	. 
	jp z,l1217h		;1361	ca 17 12 	. . . 
	ld hl,l194bh		;1364	21 4b 19 	! K . 
	call sub_1619h		;1367	cd 19 16 	. . . 
l136ah:
	call sub_1696h		;136a	cd 96 16 	. . . 
	jr c,l137bh		;136d	38 0c 	8 . 
	jr z,l137bh		;136f	28 0a 	( . 
	sub 031h		;1371	d6 31 	. 1 
	jr z,l137bh		;1373	28 06 	( . 
	dec a			;1375	3d 	= 
	jr nz,l136ah		;1376	20 f2 	  . 
	call sub_3607h		;1378	cd 07 36 	. . 6 
l137bh:
	jp l11f9h		;137b	c3 f9 11 	. . . 
l137eh:
	ld a,(ALRMMSTDS)		;137e	3a 43 ef 	: C . 
	or a			;1381	b7 	. 
	jp nz,l1217h		;1382	c2 17 12 	. . . 
l1385h:
	ld hl,l1964h		;1385	21 64 19 	! d . 
	call sub_1619h		;1388	cd 19 16 	. . . 
l138bh:
	call sub_1696h		;138b	cd 96 16 	. . . 
	jr c,l13b2h		;138e	38 22 	8 " 
	jr z,l13b2h		;1390	28 20 	(   
	sub 031h		;1392	d6 31 	. 1 
	ld b,a			;1394	47 	G 
	jr z,l13a3h		;1395	28 0c 	( . 
	dec a			;1397	3d 	= 
	jr z,l13b7h		;1398	28 1d 	( . 
	dec a			;139a	3d 	= 
	jr z,l13b7h		;139b	28 1a 	( . 
	dec a			;139d	3d 	= 
	jp z,l142bh		;139e	ca 2b 14 	. + . 
	jr l138bh		;13a1	18 e8 	. . 
l13a3h:
	ld c,081h		;13a3	0e 81 	. . 
	call sub_4162h		;13a5	cd 62 41 	. b A 
	ld hl,ALRMMSG		;13a8	21 df f3 	! . . 
	call sub_164bh		;13ab	cd 4b 16 	. K . 
	xor a			;13ae	af 	. 
	ld (ALRMTP),a		;13af	32 8a ef 	2 . . 
l13b2h:
	call sub_12c5h		;13b2	cd c5 12 	. . . 
	jr l137bh		;13b5	18 c4 	. . 
l13b7h:
	push bc			;13b7	c5 	. 
	ld a,b			;13b8	78 	x 
	ld hl,l198ch		;13b9	21 8c 19 	! . . 
	dec a			;13bc	3d 	= 
	jr z,l13c2h		;13bd	28 03 	( . 
	ld hl,l1997h		;13bf	21 97 19 	! . . 
l13c2h:
	call sub_15fdh		;13c2	cd fd 15 	. . . 
	ld hl,l19a1h		;13c5	21 a1 19 	! . . 
	call sub_0593h		;13c8	cd 93 05 	. . . 
	call sub_140ch		;13cb	cd 0c 14 	. . . 
	ld bc,l060bh		;13ce	01 0b 06 	. . . 
	ld d,008h		;13d1	16 08 	. . 
	ld hl,0f41bh		;13d3	21 1b f4 	! . . 
	call sub_1679h		;13d6	cd 79 16 	. y . 
	pop bc			;13d9	c1 	. 
	jr c,l13b2h		;13da	38 d6 	8 . 
	push bc			;13dc	c5 	. 
	ld hl,0f419h		;13dd	21 19 f4 	! . . 
	ld de,0f401h		;13e0	11 01 f4 	. . . 
	call sub_1153h		;13e3	cd 53 11 	. S . 
	ld hl,0f406h		;13e6	21 06 f4 	! . . 
	xor a			;13e9	af 	. 
	ld (hl),a			;13ea	77 	w 
	inc hl			;13eb	23 	# 
	dec a			;13ec	3d 	= 
	ld (hl),a			;13ed	77 	w 
	pop bc			;13ee	c1 	. 
	ld hl,ALRMMSG		;13ef	21 df f3 	! . . 
	ld (0f409h),hl		;13f2	22 09 f4 	" . . 
	ld hl,0f408h		;13f5	21 08 f4 	! . . 
	ld a,(hl)			;13f8	7e 	~ 
	ld (hl),b			;13f9	70 	p 
	ld hl,ALRMMSG		;13fa	21 df f3 	! . . 
	cp b			;13fd	b8 	. 
	call nz,sub_164bh		;13fe	c4 4b 16 	. K . 
	ld c,082h		;1401	0e 82 	. . 
	call sub_4162h		;1403	cd 62 41 	. b A 
l1406h:
	call sub_12c5h		;1406	cd c5 12 	. . . 
	jp l1385h		;1409	c3 85 13 	. . . 
sub_140ch:
	ld a,(ALRMST)		;140c	3a 8d ef 	: . . 
	push af			;140f	f5 	. 
	ld de,0f401h		;1410	11 01 f4 	. . . 
	ld c,084h		;1413	0e 84 	. . 
	call sub_4162h		;1415	cd 62 41 	. b A 
l1418h:
	ld hl,0f419h		;1418	21 19 f4 	! . . 
	pop af			;141b	f1 	. 
	ld (ALRMST),a		;141c	32 8d ef 	2 . . 
	ld a,(ALRMTP)		;141f	3a 8a ef 	: . . 
	or a			;1422	b7 	. 
	jp nz,sub_1124h		;1423	c2 24 11 	. $ . 
	ld b,00ah		;1426	06 0a 	. . 
	jp sub_1656h		;1428	c3 56 16 	. V . 
l142bh:
	ld hl,l19ach		;142b	21 ac 19 	! . . 
	call sub_1603h		;142e	cd 03 16 	. . . 
	ld hl,ALRMMSG		;1431	21 df f3 	! . . 
	call sub_170ah		;1434	cd 0a 17 	. . . 
	ld d,020h		;1437	16 20 	.   
	call sub_1673h		;1439	cd 73 16 	. s . 
	jp c,l13b2h		;143c	da b2 13 	. . . 
	ld hl,ALRMMSG		;143f	21 df f3 	! . . 
	call sub_1743h		;1442	cd 43 17 	. C . 
	jp l1385h		;1445	c3 85 13 	. . . 
l1448h:
	ld hl,l19bbh		;1448	21 bb 19 	! . . 
	call sub_1619h		;144b	cd 19 16 	. . . 
l144eh:
	call sub_1696h		;144e	cd 96 16 	. . . 
	jr c,l147ch		;1451	38 29 	8 ) 
	jr z,l147ch		;1453	28 27 	( ' 
	sub 031h		;1455	d6 31 	. 1 
	jr z,l1476h		;1457	28 1d 	( . 
	dec a			;1459	3d 	= 
	jr nz,l144eh		;145a	20 f2 	  . 
	ld hl,l19d9h		;145c	21 d9 19 	! . . 
	call sub_1603h		;145f	cd 03 16 	. . . 
	ld hl,AUTOSTRT		;1462	21 bd f3 	! . . 
	push hl			;1465	e5 	. 
	call sub_170ah		;1466	cd 0a 17 	. . . 
	ld d,020h		;1469	16 20 	.   
	call sub_1673h		;146b	cd 73 16 	. s . 
	pop hl			;146e	e1 	. 
	jr c,l147fh		;146f	38 0e 	8 . 
	call sub_1743h		;1471	cd 43 17 	. C . 
	jr l147ch		;1474	18 06 	. . 
l1476h:
	ld hl,AUTOSTRT		;1476	21 bd f3 	! . . 
	call sub_164bh		;1479	cd 4b 16 	. K . 
l147ch:
	call sub_12f2h		;147c	cd f2 12 	. . . 
l147fh:
	jr l14fbh		;147f	18 7a 	. z 
l1481h:
	ld hl,l19ebh		;1481	21 eb 19 	! . . 
	call sub_1619h		;1484	cd 19 16 	. . . 
l1487h:
	call sub_1696h		;1487	cd 96 16 	. . . 
	jr c,l14fbh		;148a	38 6f 	8 o 
	jr z,l14fbh		;148c	28 6d 	( m 
	ld b,a			;148e	47 	G 
	sub 031h		;148f	d6 31 	. 1 
	jr z,l14a7h		;1491	28 14 	( . 
	dec a			;1493	3d 	= 
	jr z,l14a8h		;1494	28 12 	( . 
	dec a			;1496	3d 	= 
	jr z,l14b4h		;1497	28 1b 	( . 
	dec a			;1499	3d 	= 
	jr z,l14c8h		;149a	28 2c 	( , 
	dec a			;149c	3d 	= 
	jr z,l14c8h		;149d	28 29 	( ) 
	dec a			;149f	3d 	= 
	jr z,l14c8h		;14a0	28 26 	( & 
	dec a			;14a2	3d 	= 
	jr z,l14c8h		;14a3	28 23 	( # 
	jr l1487h		;14a5	18 e0 	. . 
l14a7h:
	dec a			;14a7	3d 	= 
l14a8h:
	ld (MENUFG),a		;14a8	32 44 ef 	2 D . 
	push af			;14ab	f5 	. 
	call sub_12fdh		;14ac	cd fd 12 	. . . 
	pop af			;14af	f1 	. 
	jr nz,l14fbh		;14b0	20 49 	  I 
	jr l1481h		;14b2	18 cd 	. . 
l14b4h:
	ld hl,l1a35h		;14b4	21 35 1a 	! 5 . 
	call sub_1603h		;14b7	cd 03 16 	. . . 
	ld hl,MENUDRV		;14ba	21 45 ef 	! E . 
	ld bc,l0009h+2		;14bd	01 0b 00 	. . . 
	call sub_165ch		;14c0	cd 5c 16 	. \ . 
	jr c,l14fbh		;14c3	38 36 	8 6 
	xor a			;14c5	af 	. 
	jr l14a8h		;14c6	18 e0 	. . 
l14c8h:
	push bc			;14c8	c5 	. 
	ld hl,l1a24h		;14c9	21 24 1a 	! $ . 
	call sub_1603h		;14cc	cd 03 16 	. . . 
	ld bc,00516h		;14cf	01 16 05 	. . . 
	call XSETCUSR		;14d2	cd be 05 	. . . 
	pop af			;14d5	f1 	. 
	sub 003h		;14d6	d6 03 	. . 
	ld c,a			;14d8	4f 	O 
	call sub_059dh		;14d9	cd 9d 05 	. . . 
	ld a,c			;14dc	79 	y 
	sub 030h		;14dd	d6 30 	. 0 
	ld hl,FTYPETBL		;14df	21 50 ef 	! P . 
	ld bc,l000ch+2		;14e2	01 0e 00 	. . . 
l14e5h:
	dec a			;14e5	3d 	= 
	jr z,l14ebh		;14e6	28 03 	( . 
	add hl,bc			;14e8	09 	. 
	jr l14e5h		;14e9	18 fa 	. . 
l14ebh:
	ld bc,l000ch+2		;14eb	01 0e 00 	. . . 
	call sub_165ch		;14ee	cd 5c 16 	. \ . 
	jr c,l14fbh		;14f1	38 08 	8 . 
	ld b,003h		;14f3	06 03 	. . 
	call 017e1h		;14f5	cd e1 17 	. . . 
	jp l1481h		;14f8	c3 81 14 	. . . 
l14fbh:
	jp l11f9h		;14fb	c3 f9 11 	. . . 
l14feh:
	call sub_6b2bh		;14fe	cd 2b 6b 	. + k 
l1501h:
	jp nz,l1217h		;1501	c2 17 12 	. . . 
	ld hl,l1a41h		;1504	21 41 1a 	! A . 
	call sub_1619h		;1507	cd 19 16 	. . . 
l150ah:
	call sub_1545h		;150a	cd 45 15 	. E . 
	call sub_1627h		;150d	cd 27 16 	. ' . 
	call sub_1696h		;1510	cd 96 16 	. . . 
	jr c,l14fbh		;1513	38 e6 	8 . 
	jr z,l14fbh		;1515	28 e4 	( . 
	ld hl,DFTATR		;1517	21 e4 f2 	! . . 
	push hl			;151a	e5 	. 
	ld hl,TACATR		;151b	21 d1 f7 	! . . 
	sub 031h		;151e	d6 31 	. 1 
	jr z,l152dh		;1520	28 0b 	( . 
	dec a			;1522	3d 	= 
	jr z,l1534h		;1523	28 0f 	( . 
	dec a			;1525	3d 	= 
	jr z,l153bh		;1526	28 13 	( . 
	dec a			;1528	3d 	= 
	jr z,l153ch		;1529	28 11 	( . 
	jr l1542h		;152b	18 15 	. . 
l152dh:
	set 7,(hl)		;152d	cb fe 	. . 
	pop hl			;152f	e1 	. 
	set 7,(hl)		;1530	cb fe 	. . 
	jr l1543h		;1532	18 0f 	. . 
l1534h:
	res 7,(hl)		;1534	cb be 	. . 
	pop hl			;1536	e1 	. 
	res 7,(hl)		;1537	cb be 	. . 
	jr l1543h		;1539	18 08 	. . 
l153bh:
	dec a			;153b	3d 	= 
l153ch:
	ld (VERDFLT),a		;153c	32 be ef 	2 . . 
	ld (0efbfh),a		;153f	32 bf ef 	2 . . 
l1542h:
	pop hl			;1542	e1 	. 
l1543h:
	jr l150ah		;1543	18 c5 	. . 
sub_1545h:
	ld bc,l0608h		;1545	01 08 06 	. . . 
	call sub_1643h		;1548	cd 43 16 	. C . 
	ld hl,l1a4ch		;154b	21 4c 1a 	! L . 
	ld d,004h		;154e	16 04 	. . 
	ld a,(DFTATR)		;1550	3a e4 f2 	: . . 
	rlca			;1553	07 	. 
	jr c,l155bh		;1554	38 05 	8 . 
	ld hl,l1a53h		;1556	21 53 1a 	! S . 
	ld d,007h		;1559	16 07 	. . 
l155bh:
	ld a,00fh		;155b	3e 0f 	> . 
	call sub_1572h		;155d	cd 72 15 	. r . 
	ld hl,l1a5dh		;1560	21 5d 1a 	! ] . 
	ld d,006h		;1563	16 06 	. . 
	ld a,(VERDFLT)		;1565	3a be ef 	: . . 
	or a			;1568	b7 	. 
	ld a,01bh		;1569	3e 1b 	> . 
	jr nz,sub_1572h		;156b	20 05 	  . 
	ld hl,l1a66h		;156d	21 66 1a 	! f . 
	ld d,009h		;1570	16 09 	. . 
sub_1572h:
	sub d			;1572	92 	. 
	ld c,a			;1573	4f 	O 
	ld b,006h		;1574	06 06 	. . 
	call XSETCUSR		;1576	cd be 05 	. . . 
	ld a,d			;1579	7a 	z 
	jp sub_17f3h		;157a	c3 f3 17 	. . . 
	ld b,006h		;157d	06 06 	. . 
	jr l158fh		;157f	18 0e 	. . 
	call 05eaah		;1581	cd aa 5e 	. . ^ 
	ld b,004h		;1584	06 04 	. . 
	jr l158fh		;1586	18 07 	. . 
	call sub_15dch		;1588	cd dc 15 	. . . 
	jr l15d9h		;158b	18 4c 	. L 
	ld b,008h		;158d	06 08 	. . 
l158fh:
	call sub_2ab4h		;158f	cd b4 2a 	. . * 
	jr l15d9h		;1592	18 45 	. E 
	call sub_6248h		;1594	cd 48 62 	. H b 
	jr l15d9h		;1597	18 40 	. @ 
	ld hl,l1a70h		;1599	21 70 1a 	! p . 
	call sub_0593h		;159c	cd 93 05 	. . . 
	call sub_002dh		;159f	cd 2d 00 	. - . 
l15a2h:
	or a			;15a2	b7 	. 
	jr z,l15bah		;15a3	28 15 	( . 
	ld hl,l1a88h		;15a5	21 88 1a 	! . . 
	call sub_0593h		;15a8	cd 93 05 	. . . 
l15abh:
	ld a,(0eff0h)		;15ab	3a f0 ef 	: . . 
	or a			;15ae	b7 	. 
	jr nz,l15bah		;15af	20 09 	  . 
	call sub_3831h		;15b1	cd 31 38 	. 1 8 
	or a			;15b4	b7 	. 
	jr z,l15abh		;15b5	28 f4 	( . 
	call sub_385fh		;15b7	cd 5f 38 	. _ 8 
l15bah:
	jp l11dbh		;15ba	c3 db 11 	. . . 
	ld hl,l1a78h		;15bd	21 78 1a 	! x . 
	call sub_0593h		;15c0	cd 93 05 	. . . 
	call sub_002ah		;15c3	cd 2a 00 	. * . 
	jr l15a2h		;15c6	18 da 	. . 
	ld hl,l1a7fh		;15c8	21 7f 1a 	!  . 
	call sub_0593h		;15cb	cd 93 05 	. . . 
	ld de,EPSONTXT2_start		;15ce	11 20 76 	.   v 
	call sub_0027h		;15d1	cd 27 00 	. ' . 
	jr l15a2h		;15d4	18 cc 	. . 
	call sub_5ff0h		;15d6	cd f0 5f 	. . _ 
l15d9h:
	jp l1217h		;15d9	c3 17 12 	. . . 
sub_15dch:
	call sub_6b2bh		;15dc	cd 2b 6b 	. + k 
	call z,sub_61d3h		;15df	cc d3 61 	. . a 
	ret			;15e2	c9 	. 
sub_15e3h:
	ld hl,0f328h		;15e3	21 28 f3 	! ( . 
	ld de,0f3afh		;15e6	11 af f3 	. . . 
	call sub_15f2h		;15e9	cd f2 15 	. . . 
	ld hl,l7fa3h		;15ec	21 a3 7f 	! .  
l15efh:
	ld de,0f328h		;15ef	11 28 f3 	. ( . 
sub_15f2h:
	ld bc,l000ch+2		;15f2	01 0e 00 	. . . 
	ldir		;15f5	ed b0 	. . 
	ret			;15f7	c9 	. 
sub_15f8h:
	ld hl,0f3afh		;15f8	21 af f3 	! . . 
	jr l15efh		;15fb	18 f2 	. . 
sub_15fdh:
	push hl			;15fd	e5 	. 
	ld hl,l192ah		;15fe	21 2a 19 	! * . 
	jr l1607h		;1601	18 04 	. . 
sub_1603h:
	push hl			;1603	e5 	. 
	ld hl,l1930h		;1604	21 30 19 	! 0 . 
l1607h:
	push hl			;1607	e5 	. 
	call sub_1634h		;1608	cd 34 16 	. 4 . 
	pop hl			;160b	e1 	. 
	call sub_0593h		;160c	cd 93 05 	. . . 
	pop hl			;160f	e1 	. 
	call sub_0593h		;1610	cd 93 05 	. . . 
	ld hl,l1938h		;1613	21 38 19 	! 8 . 
	jp sub_0593h		;1616	c3 93 05 	. . . 
sub_1619h:
	push hl			;1619	e5 	. 
	call sub_1634h		;161a	cd 34 16 	. 4 . 
	ld hl,l190eh		;161d	21 0e 19 	! . . 
	call sub_0593h		;1620	cd 93 05 	. . . 
	pop hl			;1623	e1 	. 
	call sub_0593h		;1624	cd 93 05 	. . . 
sub_1627h:
	ld bc,l051ah		;1627	01 1a 05 	. . . 
	jp XSETCUSR		;162a	c3 be 05 	. . . 
sub_162dh:
	ld hl,0f419h		;162d	21 19 f4 	! . . 
	ld b,020h		;1630	06 20 	.   
	jr sub_1656h		;1632	18 22 	. " 
sub_1634h:
	ld bc,l0702h+1		;1634	01 03 07 	. . . 
l1637h:
	push bc			;1637	c5 	. 
	call sub_1641h		;1638	cd 41 16 	. A . 
	pop bc			;163b	c1 	. 
	dec b			;163c	05 	. 
	dec c			;163d	0d 	. 
	jr nz,l1637h		;163e	20 f7 	  . 
	ret			;1640	c9 	. 
sub_1641h:
	ld c,000h		;1641	0e 00 	. . 
sub_1643h:
	call XSETCUSR		;1643	cd be 05 	. . . 
	ld c,005h		;1646	0e 05 	. . 
	jp sub_4d5dh		;1648	c3 5d 4d 	. ] M 
sub_164bh:
	push hl			;164b	e5 	. 
	xor a			;164c	af 	. 
	ld (hl),a			;164d	77 	w 
	inc hl			;164e	23 	# 
	ld b,020h		;164f	06 20 	.   
	call sub_1656h		;1651	cd 56 16 	. V . 
	pop hl			;1654	e1 	. 
	ret			;1655	c9 	. 
sub_1656h:
	ld (hl),020h		;1656	36 20 	6   
	inc hl			;1658	23 	# 
	djnz sub_1656h		;1659	10 fb 	. . 
	ret			;165b	c9 	. 
sub_165ch:
	push hl			;165c	e5 	. 
	push bc			;165d	c5 	. 
	ld de,0f419h		;165e	11 19 f4 	. . . 
	ldir		;1661	ed b0 	. . 
	pop bc			;1663	c1 	. 
	push bc			;1664	c5 	. 
	ld d,c			;1665	51 	Q 
	call sub_1673h		;1666	cd 73 16 	. s . 
	pop bc			;1669	c1 	. 
	jr c,l1671h		;166a	38 05 	8 . 
	pop de			;166c	d1 	. 
	push de			;166d	d5 	. 
	ldir		;166e	ed b0 	. . 
	xor a			;1670	af 	. 
l1671h:
	pop hl			;1671	e1 	. 
	ret			;1672	c9 	. 
sub_1673h:
	ld bc,l0601h		;1673	01 01 06 	. . . 
	ld hl,0f419h		;1676	21 19 f4 	! . . 
sub_1679h:
	xor a			;1679	af 	. 
	ld e,a			;167a	5f 	_ 
l167bh:
	call sub_05e0h		;167b	cd e0 05 	. . . 
	push de			;167e	d5 	. 
	push bc			;167f	c5 	. 
	push hl			;1680	e5 	. 
l1681h:
	call sub_1696h		;1681	cd 96 16 	. . . 
	inc c			;1684	0c 	. 
	jr z,l1681h		;1685	28 fa 	( . 
	pop hl			;1687	e1 	. 
	pop bc			;1688	c1 	. 
	pop de			;1689	d1 	. 
	jr c,l1695h		;168a	38 09 	8 . 
	cp 00dh		;168c	fe 0d 	. . 
	jr z,l1695h		;168e	28 05 	( . 
	cp 01bh		;1690	fe 1b 	. . 
	jr nz,l167bh		;1692	20 e7 	  . 
	scf			;1694	37 	7 
l1695h:
	ret			;1695	c9 	. 
sub_1696h:
	call sub_3802h		;1696	cd 02 38 	. . 8 
l1699h:
	call sub_380eh		;1699	cd 0e 38 	. . 8 
	jp p,l16abh		;169c	f2 ab 16 	. . . 
	ld hl,0eff0h		;169f	21 f0 ef 	! . . 
	set 4,(hl)		;16a2	cb e6 	. . 
	ld a,002h		;16a4	3e 02 	> . 
	ld (0f4ddh),a		;16a6	32 dd f4 	2 . . 
	jr l16d8h		;16a9	18 2d 	. - 
l16abh:
	call sub_16dbh		;16ab	cd db 16 	. . . 
	ld a,(0eff0h)		;16ae	3a f0 ef 	: . . 
	ld b,a			;16b1	47 	G 
	ld a,(0eff2h)		;16b2	3a f2 ef 	: . . 
	or b			;16b5	b0 	. 
	jr nz,l16d8h		;16b6	20 20 	    
	call sub_3831h		;16b8	cd 31 38 	. 1 8 
	or a			;16bb	b7 	. 
	jr nz,l16cdh		;16bc	20 0f 	  . 
	call sub_6b2bh		;16be	cd 2b 6b 	. + k 
	jr nz,l16cah		;16c1	20 07 	  . 
	call sub_5e98h		;16c3	cd 98 5e 	. . ^ 
	bit 6,h		;16c6	cb 74 	. t 
	jr nz,sub_1696h		;16c8	20 cc 	  . 
l16cah:
	halt			;16ca	76 	v 
	jr l1699h		;16cb	18 cc 	. . 
l16cdh:
	call sub_3931h		;16cd	cd 31 39 	. 1 9 
	call sub_385fh		;16d0	cd 5f 38 	. _ 8 
	cp 01bh		;16d3	fe 1b 	. . 
	ret nc			;16d5	d0 	. 
	ccf			;16d6	3f 	? 
	ret			;16d7	c9 	. 
l16d8h:
	xor a			;16d8	af 	. 
	scf			;16d9	37 	7 
	ret			;16da	c9 	. 
sub_16dbh:
	ld de,l0012h+1		;16db	11 13 00 	. . . 
	call sub_1094h		;16de	cd 94 10 	. . . 
	call sub_6b2bh		;16e1	cd 2b 6b 	. + k 
	ret nz			;16e4	c0 	. 
	call 05e9bh		;16e5	cd 9b 5e 	. . ^ 
	ex de,hl			;16e8	eb 	. 
	ld hl,0f401h		;16e9	21 01 f4 	! . . 
	ld (hl),020h		;16ec	36 20 	6   
	bit 7,d		;16ee	cb 7a 	. z 
	jr z,l16fdh		;16f0	28 0b 	( . 
	ld (hl),02dh		;16f2	36 2d 	6 - 
	push hl			;16f4	e5 	. 
	ld hl,COLDRST		;16f5	21 00 00 	! . . 
	or a			;16f8	b7 	. 
	sbc hl,de		;16f9	ed 52 	. R 
	ex de,hl			;16fb	eb 	. 
	pop hl			;16fc	e1 	. 
l16fdh:
	inc hl			;16fd	23 	# 
	call sub_17a1h		;16fe	cd a1 17 	. . . 
l1701h:
	dec hl			;1701	2b 	+ 
	ld de,0040ch		;1702	11 0c 04 	. . . 
	ld b,006h		;1705	06 06 	. . 
	jp l10a2h		;1707	c3 a2 10 	. . . 
sub_170ah:
	push hl			;170a	e5 	. 
	push hl			;170b	e5 	. 
	call sub_162dh		;170c	cd 2d 16 	. - . 
	pop hl			;170f	e1 	. 
	ld a,(hl)			;1710	7e 	~ 
	or a			;1711	b7 	. 
	jr z,l1741h		;1712	28 2d 	( - 
	ld de,0f419h		;1714	11 19 f4 	. . . 
	ld b,020h		;1717	06 20 	.   
	inc hl			;1719	23 	# 
l171ah:
	push af			;171a	f5 	. 
	ld a,(hl)			;171b	7e 	~ 
	cp 020h		;171c	fe 20 	.   
	jr c,l172bh		;171e	38 0b 	8 . 
	ld (de),a			;1720	12 	. 
	pop af			;1721	f1 	. 
	dec a			;1722	3d 	= 
	jr z,l1741h		;1723	28 1c 	( . 
	inc de			;1725	13 	. 
	inc hl			;1726	23 	# 
	djnz l171ah		;1727	10 f1 	. . 
	jr l1741h		;1729	18 16 	. . 
l172bh:
	ld c,a			;172b	4f 	O 
	ld a,05eh		;172c	3e 5e 	> ^ 
	ld (de),a			;172e	12 	. 
	pop af			;172f	f1 	. 
	inc de			;1730	13 	. 
	dec b			;1731	05 	. 
	jr z,l1741h		;1732	28 0d 	( . 
	push af			;1734	f5 	. 
	ld a,c			;1735	79 	y 
	add a,040h		;1736	c6 40 	. @ 
	ld (de),a			;1738	12 	. 
	pop af			;1739	f1 	. 
	dec a			;173a	3d 	= 
	jr z,l1741h		;173b	28 04 	( . 
	inc de			;173d	13 	. 
	inc hl			;173e	23 	# 
	djnz l171ah		;173f	10 d9 	. . 
l1741h:
	pop hl			;1741	e1 	. 
	ret			;1742	c9 	. 
sub_1743h:
	push hl			;1743	e5 	. 
	inc hl			;1744	23 	# 
	push hl			;1745	e5 	. 
	ld b,020h		;1746	06 20 	.   
	call sub_1656h		;1748	cd 56 16 	. V . 
	pop de			;174b	d1 	. 
	dec hl			;174c	2b 	+ 
	push hl			;174d	e5 	. 
	ld hl,0f419h		;174e	21 19 f4 	! . . 
	ld b,020h		;1751	06 20 	.   
l1753h:
	ld a,(hl)			;1753	7e 	~ 
	cp 05eh		;1754	fe 5e 	. ^ 
	jr z,l175fh		;1756	28 07 	( . 
	ld (de),a			;1758	12 	. 
	inc hl			;1759	23 	# 
	inc de			;175a	13 	. 
	djnz l1753h		;175b	10 f6 	. . 
	jr l1771h		;175d	18 12 	. . 
l175fh:
	dec b			;175f	05 	. 
	jr z,l1771h		;1760	28 0f 	( . 
	inc hl			;1762	23 	# 
	ld a,(hl)			;1763	7e 	~ 
	cp 060h		;1764	fe 60 	. ` 
	jr c,l176ah		;1766	38 02 	8 . 
	sub 020h		;1768	d6 20 	.   
l176ah:
	sub 040h		;176a	d6 40 	. @ 
	ld (de),a			;176c	12 	. 
	inc hl			;176d	23 	# 
	inc de			;176e	13 	. 
	djnz l1753h		;176f	10 e2 	. . 
l1771h:
	pop hl			;1771	e1 	. 
	ld b,020h		;1772	06 20 	.   
	call sub_177ah		;1774	cd 7a 17 	. z . 
	pop hl			;1777	e1 	. 
	ld (hl),b			;1778	70 	p 
	ret			;1779	c9 	. 
sub_177ah:
	ld a,(hl)			;177a	7e 	~ 
	cp 020h		;177b	fe 20 	.   
	ret nz			;177d	c0 	. 
	dec hl			;177e	2b 	+ 
	djnz sub_177ah		;177f	10 f9 	. . 
	inc hl			;1781	23 	# 
	ret			;1782	c9 	. 
sub_1783h:
	push hl			;1783	e5 	. 
	ld b,005h		;1784	06 05 	. . 
	ld hl,COLDRST		;1786	21 00 00 	! . . 
l1789h:
	add hl,hl			;1789	29 	) 
	ld d,h			;178a	54 	T 
	ld e,l			;178b	5d 	] 
	add hl,hl			;178c	29 	) 
	add hl,hl			;178d	29 	) 
	add hl,de			;178e	19 	. 
	ex (sp),hl			;178f	e3 	. 
	ld a,(hl)			;1790	7e 	~ 
	sub 030h		;1791	d6 30 	. 0 
	inc hl			;1793	23 	# 
	ex (sp),hl			;1794	e3 	. 
	ld e,a			;1795	5f 	_ 
	ld d,000h		;1796	16 00 	. . 
	add hl,de			;1798	19 	. 
	djnz l1789h		;1799	10 ee 	. . 
	pop de			;179b	d1 	. 
	ld a,h			;179c	7c 	| 
	or a			;179d	b7 	. 
	ret z			;179e	c8 	. 
	scf			;179f	37 	7 
	ret			;17a0	c9 	. 
sub_17a1h:
	push hl			;17a1	e5 	. 
	push hl			;17a2	e5 	. 
	ld hl,l17c4h		;17a3	21 c4 17 	! . . 
l17a6h:
	ld c,(hl)			;17a6	4e 	N 
	inc hl			;17a7	23 	# 
	ld b,(hl)			;17a8	46 	F 
	inc hl			;17a9	23 	# 
	ld a,c			;17aa	79 	y 
	or b			;17ab	b0 	. 
	jr z,l17c1h		;17ac	28 13 	( . 
	xor a			;17ae	af 	. 
	ex de,hl			;17af	eb 	. 
l17b0h:
	sbc hl,bc		;17b0	ed 42 	. B 
	jr c,l17b7h		;17b2	38 03 	8 . 
	inc a			;17b4	3c 	< 
	jr l17b0h		;17b5	18 f9 	. . 
l17b7h:
	add hl,bc			;17b7	09 	. 
	add a,030h		;17b8	c6 30 	. 0 
	ex de,hl			;17ba	eb 	. 
	ex (sp),hl			;17bb	e3 	. 
	ld (hl),a			;17bc	77 	w 
	inc hl			;17bd	23 	# 
	ex (sp),hl			;17be	e3 	. 
	jr l17a6h		;17bf	18 e5 	. . 
l17c1h:
	pop hl			;17c1	e1 	. 
	pop hl			;17c2	e1 	. 
	ret			;17c3	c9 	. 
l17c4h:
	djnz l17edh		;17c4	10 27 	. ' 
	ret pe			;17c6	e8 	. 
	inc bc			;17c7	03 	. 
	ld h,h			;17c8	64 	d 
	nop			;17c9	00 	. 
	ld a,(bc)			;17ca	0a 	. 
	nop			;17cb	00 	. 
	ld bc,COLDRST		;17cc	01 00 00 	. . . 
	nop			;17cf	00 	. 
	ld hl,l17d5h		;17d0	21 d5 17 	! . . 
	jr l17dbh		;17d3	18 06 	. . 
l17d5h:
	dec de			;17d5	1b 	. 
	inc sp			;17d6	33 	3 
	rst 38h			;17d7	ff 	. 
	ld hl,l17deh		;17d8	21 de 17 	! . . 
l17dbh:
	jp sub_0593h		;17db	c3 93 05 	. . . 
l17deh:
	dec de			;17de	1b 	. 
	ld (l7effh),a		;17df	32 ff 7e 	2 . ~ 
	cp 061h		;17e2	fe 61 	. a 
	jr c,l17edh		;17e4	38 07 	8 . 
	cp 07bh		;17e6	fe 7b 	. { 
	jr nc,l17edh		;17e8	30 03 	0 . 
	sub 020h		;17ea	d6 20 	.   
	ld (hl),a			;17ec	77 	w 
l17edh:
	inc hl			;17ed	23 	# 
	djnz $-13		;17ee	10 f1 	. . 
	ret			;17f0	c9 	. 
	ld a,(hl)			;17f1	7e 	~ 
	inc hl			;17f2	23 	# 
sub_17f3h:
	or a			;17f3	b7 	. 
	ret z			;17f4	c8 	. 
	ld b,a			;17f5	47 	G 
l17f6h:
	ld c,(hl)			;17f6	4e 	N 
	call sub_059dh		;17f7	cd 9d 05 	. . . 
	inc hl			;17fa	23 	# 
	djnz l17f6h		;17fb	10 f9 	. . 
	ret			;17fd	c9 	. 
l17feh:
	inc c			;17fe	0c 	. 
	ld hl,(05320h)		;17ff	2a 20 53 	*   S 
	ld e,c			;1802	59 	Y 
	ld d,e			;1803	53 	S 
	ld d,h			;1804	54 	T 
	ld b,l			;1805	45 	E 
	ld c,l			;1806	4d 	M 
	jr nz,l184dh		;1807	20 44 	  D 
	ld c,c			;1809	49 	I 
	ld d,e			;180a	53 	S 
	ld d,b			;180b	50 	P 
	ld c,h			;180c	4c 	L 
	ld b,c			;180d	41 	A 
	ld e,c			;180e	59 	Y 
	jr nz,l183bh		;180f	20 2a 	  * 
	dec c			;1811	0d 	. 
	ld a,(bc)			;1812	0a 	. 
	inc a			;1813	3c 	< 
	ld d,d			;1814	52 	R 
	ld b,c			;1815	41 	A 
	ld c,l			;1816	4d 	M 
	jr nz,l1839h		;1817	20 20 	    
	jr nz,$+70		;1819	20 44 	  D 
	ld c,c			;181b	49 	I 
	ld d,e			;181c	53 	S 
	ld c,e			;181d	4b 	K 
	ld a,01bh		;181e	3e 1b 	> . 
	dec a			;1820	3d 	= 
	ld hl,l4b34h		;1821	21 34 4b 	! 4 K 
	ld b,d			;1824	42 	B 
	dec de			;1825	1b 	. 
	dec a			;1826	3d 	= 
	ld hl,03c39h		;1827	21 39 3c 	! 9 < 
	ld b,c			;182a	41 	A 
	ld c,h			;182b	4c 	L 
	ld d,d			;182c	52 	R 
	ld c,l			;182d	4d 	M 
	ld a,00dh		;182e	3e 0d 	> . 
	ld a,(bc)			;1830	0a 	. 
	inc a			;1831	3c 	< 
	ld d,l			;1832	55 	U 
	ld d,e			;1833	53 	S 
	ld b,l			;1834	45 	E 
	ld d,d			;1835	52 	R 
	jr nz,l1858h		;1836	20 20 	    
	ld b,d			;1838	42 	B 
l1839h:
	ld c,c			;1839	49 	I 
	ld c,a			;183a	4f 	O 
l183bh:
	ld d,e			;183b	53 	S 
	ld a,01bh		;183c	3e 1b 	> . 
	dec a			;183e	3d 	= 
	ld (09d30h),hl		;183f	22 30 9d 	" 0 . 
	ld (l3635h),a		;1842	32 35 36 	2 5 6 
	jr nz,l1889h		;1845	20 42 	  B 
	dec de			;1847	1b 	. 
	dec a			;1848	3d 	= 
	ld (03c39h),hl		;1849	22 39 3c 	" 9 < 
	ld b,c			;184c	41 	A 
l184dh:
	ld d,l			;184d	55 	U 
	ld d,h			;184e	54 	T 
	ld c,a			;184f	4f 	O 
	ld a,00dh		;1850	3e 0d 	> . 
	ld a,(bc)			;1852	0a 	. 
	inc a			;1853	3c 	< 
	ld c,l			;1854	4d 	M 
	ld b,l			;1855	45 	E 
	ld c,(hl)			;1856	4e 	N 
	ld d,l			;1857	55 	U 
l1858h:
	jr nz,l189eh		;1858	20 44 	  D 
	ld d,d			;185a	52 	R 
	ld c,c			;185b	49 	I 
	ld d,(hl)			;185c	56 	V 
	ld b,l			;185d	45 	E 
	ld a,01bh		;185e	3e 1b 	> . 
	dec a			;1860	3d 	= 
	inc hl			;1861	23 	# 
	add hl,sp			;1862	39 	9 
	inc a			;1863	3c 	< 
	ld c,l			;1864	4d 	M 
	ld b,l			;1865	45 	E 
	ld c,(hl)			;1866	4e 	N 
	ld d,l			;1867	55 	U 
	ld a,00dh		;1868	3e 0d 	> . 
	ld a,(bc)			;186a	0a 	. 
	inc a			;186b	3c 	< 
	ld c,l			;186c	4d 	M 
	ld b,e			;186d	43 	C 
	ld d,h			;186e	54 	T 
	jr nz,$+34		;186f	20 20 	    
	ld b,e			;1871	43 	C 
	ld c,a			;1872	4f 	O 
	ld d,l			;1873	55 	U 
	ld c,(hl)			;1874	4e 	N 
	ld d,h			;1875	54 	T 
	ld a,0ffh		;1876	3e ff 	> . 
l1878h:
	dec l			;1878	2d 	- 
	ld d,e			;1879	53 	S 
	ld h,l			;187a	65 	e 
	ld l,h			;187b	6c 	l 
	ld h,l			;187c	65 	e 
	ld h,e			;187d	63 	c 
	ld (hl),h			;187e	74 	t 
	jr nz,l18f0h		;187f	20 6f 	  o 
	ld (hl),d			;1881	72 	r 
	jr nz,l18c9h		;1882	20 45 	  E 
	ld d,e			;1884	53 	S 
	ld b,e			;1885	43 	C 
	jr nz,l18fch		;1886	20 74 	  t 
	ld l,a			;1888	6f 	o 
l1889h:
	jr nz,l18f0h		;1889	20 65 	  e 
	ld a,b			;188b	78 	x 
	ld l,c			;188c	69 	i 
	ld (hl),h			;188d	74 	t 
	ld l,020h		;188e	2e 20 	.   
	jr nz,$+51		;1890	20 31 	  1 
	dec a			;1892	3d 	= 
	ld d,d			;1893	52 	R 
	ld b,c			;1894	41 	A 
	ld c,l			;1895	4d 	M 
	jr nz,l18fbh		;1896	20 63 	  c 
	ld h,c			;1898	61 	a 
	ld (hl),d			;1899	72 	r 
	ld (hl),h			;189a	74 	t 
	ld (hl),d			;189b	72 	r 
	ld l,c			;189c	69 	i 
	ld h,h			;189d	64 	d 
l189eh:
	ld h,a			;189e	67 	g 
	ld h,l			;189f	65 	e 
	ld (l613dh),a		;18a0	32 3d 61 	2 = a 
	ld l,h			;18a3	6c 	l 
	ld h,c			;18a4	61 	a 
	ld (hl),d			;18a5	72 	r 
	ld l,l			;18a6	6d 	m 
	jr nz,l18c9h		;18a7	20 20 	    
	jr nz,l18deh		;18a9	20 33 	  3 
	dec a			;18ab	3d 	= 
	ld h,c			;18ac	61 	a 
	ld (hl),l			;18ad	75 	u 
	ld (hl),h			;18ae	74 	t 
	ld l,a			;18af	6f 	o 
	jr nz,l1925h		;18b0	20 73 	  s 
	ld (hl),h			;18b2	74 	t 
	ld h,c			;18b3	61 	a 
	ld (hl),d			;18b4	72 	r 
	ld (hl),h			;18b5	74 	t 
	jr nz,l18d8h		;18b6	20 20 	    
	jr nz,l18eeh		;18b8	20 34 	  4 
	dec a			;18ba	3d 	= 
	ld l,l			;18bb	6d 	m 
	ld h,l			;18bc	65 	e 
	ld l,(hl)			;18bd	6e 	n 
	ld (hl),l			;18be	75 	u 
	rst 38h			;18bf	ff 	. 
	jr nz,l18e2h		;18c0	20 20 	    
	jr nz,l18f9h		;18c2	20 35 	  5 
	dec a			;18c4	3d 	= 
	ld c,l			;18c5	4d 	M 
	ld b,e			;18c6	43 	C 
	ld d,h			;18c7	54 	T 
	dec c			;18c8	0d 	. 
l18c9h:
	ld a,(bc)			;18c9	0a 	. 
	rst 38h			;18ca	ff 	. 
l18cbh:
	jr nz,l1909h		;18cb	20 3c 	  < 
	inc a			;18cd	3c 	< 
	dec l			;18ce	2d 	- 
	cpl			;18cf	2f 	/ 
	jr nz,l18f2h		;18d0	20 20 	    
	jr nz,$+34		;18d2	20 20 	    
	jr nz,l1912h		;18d4	20 3c 	  < 
	dec l			;18d6	2d 	- 
	cpl			;18d7	2f 	/ 
l18d8h:
	ld l,l			;18d8	6d 	m 
	ld l,a			;18d9	6f 	o 
	ld (hl),l			;18da	75 	u 
	jr nz,l18fdh		;18db	20 20 	    
	adc a,e			;18dd	8b 	. 
l18deh:
	cpl			;18de	2f 	/ 
	ld h,h			;18df	64 	d 
	ld l,c			;18e0	69 	i 
	ld l,(hl)			;18e1	6e 	n 
l18e2h:
	ld (hl),h			;18e2	74 	t 
	jr nz,l1905h		;18e3	20 20 	    
	dec l			;18e5	2d 	- 
	ld a,03eh		;18e6	3e 3e 	> > 
	cpl			;18e8	2f 	/ 
	ld h,l			;18e9	65 	e 
	ld (hl),d			;18ea	72 	r 
	ld h,c			;18eb	61 	a 
	jr nz,l190eh		;18ec	20 20 	    
l18eeh:
	sub b			;18ee	90 	. 
	sub b			;18ef	90 	. 
l18f0h:
	sub b			;18f0	90 	. 
	cpl			;18f1	2f 	/ 
l18f2h:
	rst 38h			;18f2	ff 	. 
l18f3h:
	jr nz,l1915h		;18f3	20 20 	    
	cpl			;18f5	2f 	/ 
	ld (hl),d			;18f6	72 	r 
	ld h,l			;18f7	65 	e 
	ld l,l			;18f8	6d 	m 
l18f9h:
	dec de			;18f9	1b 	. 
	dec a			;18fa	3d 	= 
l18fbh:
	daa			;18fb	27 	' 
l18fch:
	dec hl			;18fc	2b 	+ 
l18fdh:
	cpl			;18fd	2f 	/ 
	dec de			;18fe	1b 	. 
	dec a			;18ff	3d 	= 
	daa			;1900	27 	' 
	ld (l1b2fh),a		;1901	32 2f 1b 	2 / . 
	dec a			;1904	3d 	= 
l1905h:
	daa			;1905	27 	' 
l1906h:
	inc a			;1906	3c 	< 
	cpl			;1907	2f 	/ 
	dec de			;1908	1b 	. 
l1909h:
	dec a			;1909	3d 	= 
	daa			;190a	27 	' 
	ld b,l			;190b	45 	E 
	cpl			;190c	2f 	/ 
	rst 38h			;190d	ff 	. 
l190eh:
	dec l			;190e	2d 	- 
	ld d,e			;190f	53 	S 
	ld h,l			;1910	65 	e 
	ld l,h			;1911	6c 	l 
l1912h:
	ld h,l			;1912	65 	e 
	ld h,e			;1913	63 	c 
	ld (hl),h			;1914	74 	t 
l1915h:
	jr nz,l1986h		;1915	20 6f 	  o 
	ld (hl),d			;1917	72 	r 
	jr nz,$+71		;1918	20 45 	  E 
	ld d,e			;191a	53 	S 
	ld b,e			;191b	43 	C 
	jr nz,$+118		;191c	20 74 	  t 
	ld l,a			;191e	6f 	o 
	jr nz,l1993h		;191f	20 72 	  r 
	ld h,l			;1921	65 	e 
	ld (hl),h			;1922	74 	t 
	ld (hl),l			;1923	75 	u 
	ld (hl),d			;1924	72 	r 
l1925h:
	ld l,(hl)			;1925	6e 	n 
	ld l,00dh		;1926	2e 0d 	. . 
	ld a,(bc)			;1928	0a 	. 
	rst 38h			;1929	ff 	. 
l192ah:
	dec l			;192a	2d 	- 
	ld d,e			;192b	53 	S 
	ld h,l			;192c	65 	e 
	ld (hl),h			;192d	74 	t 
	jr nz,$+1		;192e	20 ff 	  . 
l1930h:
	dec l			;1930	2d 	- 
	ld c,c			;1931	49 	I 
	ld l,(hl)			;1932	6e 	n 
	ld (hl),b			;1933	70 	p 
	ld (hl),l			;1934	75 	u 
	ld (hl),h			;1935	74 	t 
	jr nz,$+1		;1936	20 ff 	  . 
l1938h:
	inc l			;1938	2c 	, 
	jr nz,l1980h		;1939	20 45 	  E 
	ld d,e			;193b	53 	S 
	ld b,e			;193c	43 	C 
	jr nz,l19b3h		;193d	20 74 	  t 
	ld l,a			;193f	6f 	o 
	jr nz,l19a5h		;1940	20 63 	  c 
	ld h,c			;1942	61 	a 
	ld l,(hl)			;1943	6e 	n 
	ld h,e			;1944	63 	c 
	ld h,l			;1945	65 	e 
	ld l,h			;1946	6c 	l 
	ld l,00dh		;1947	2e 0d 	. . 
	ld a,(bc)			;1949	0a 	. 
	rst 38h			;194a	ff 	. 
l194bh:
	jr nz,l1989h		;194b	20 3c 	  < 
	ld d,d			;194d	52 	R 
	ld b,c			;194e	41 	A 
	ld c,l			;194f	4d 	M 
	jr nz,l1998h		;1950	20 46 	  F 
	ld c,a			;1952	4f 	O 
	ld d,d			;1953	52 	R 
	ld c,l			;1954	4d 	M 
	ld b,c			;1955	41 	A 
	ld d,h			;1956	54 	T 
	ld a,009h		;1957	3e 09 	> . 
	ld sp,06e3dh		;1959	31 3d 6e 	1 = n 
	ld l,a			;195c	6f 	o 
	add hl,bc			;195d	09 	. 
	ld (l793dh),a		;195e	32 3d 79 	2 = y 
	ld h,l			;1961	65 	e 
	ld (hl),e			;1962	73 	s 
	rst 38h			;1963	ff 	. 
l1964h:
	jr nz,$+62		;1964	20 3c 	  < 
	ld b,c			;1966	41 	A 
	ld c,h			;1967	4c 	L 
	ld b,c			;1968	41 	A 
	ld d,d			;1969	52 	R 
	ld c,l			;196a	4d 	M 
	ld a,020h		;196b	3e 20 	>   
	jr nz,l19a0h		;196d	20 31 	  1 
	dec a			;196f	3d 	= 
	ld l,a			;1970	6f 	o 
	ld h,(hl)			;1971	66 	f 
	ld h,(hl)			;1972	66 	f 
	jr nz,l1995h		;1973	20 20 	    
	ld (l613dh),a		;1975	32 3d 61 	2 = a 
	ld l,h			;1978	6c 	l 
	ld h,c			;1979	61 	a 
	ld (hl),d			;197a	72 	r 
	ld l,l			;197b	6d 	m 
	jr nz,l199eh		;197c	20 20 	    
	inc sp			;197e	33 	3 
	dec a			;197f	3d 	= 
l1980h:
	ld (hl),a			;1980	77 	w 
	ld h,c			;1981	61 	a 
	ld l,e			;1982	6b 	k 
	ld h,l			;1983	65 	e 
	jr nz,l19a6h		;1984	20 20 	    
l1986h:
	inc (hl)			;1986	34 	4 
	dec a			;1987	3d 	= 
	ld c,l			;1988	4d 	M 
l1989h:
	ld d,e			;1989	53 	S 
	ld b,a			;198a	47 	G 
	rst 38h			;198b	ff 	. 
l198ch:
	ld h,c			;198c	61 	a 
	ld l,h			;198d	6c 	l 
	ld h,c			;198e	61 	a 
	ld (hl),d			;198f	72 	r 
	ld l,l			;1990	6d 	m 
	jr nz,l1a07h		;1991	20 74 	  t 
l1993h:
	ld l,c			;1993	69 	i 
	ld l,l			;1994	6d 	m 
l1995h:
	ld h,l			;1995	65 	e 
	rst 38h			;1996	ff 	. 
l1997h:
	ld (hl),a			;1997	77 	w 
l1998h:
	ld h,c			;1998	61 	a 
	ld l,e			;1999	6b 	k 
	ld h,l			;199a	65 	e 
	jr nz,l1a11h		;199b	20 74 	  t 
	ld l,c			;199d	69 	i 
l199eh:
	ld l,l			;199e	6d 	m 
	ld h,l			;199f	65 	e 
l19a0h:
	rst 38h			;19a0	ff 	. 
l19a1h:
	jr nz,l19f0h		;19a1	20 4d 	  M 
	ld c,l			;19a3	4d 	M 
	ld b,h			;19a4	44 	D 
l19a5h:
	ld b,h			;19a5	44 	D 
l19a6h:
	ld l,b			;19a6	68 	h 
	ld l,b			;19a7	68 	h 
	ld l,l			;19a8	6d 	m 
	ld l,l			;19a9	6d 	m 
	jr nz,$+1		;19aa	20 ff 	  . 
l19ach:
	ld l,l			;19ac	6d 	m 
	ld h,l			;19ad	65 	e 
	ld (hl),e			;19ae	73 	s 
	ld (hl),e			;19af	73 	s 
	ld h,c			;19b0	61 	a 
	ld h,a			;19b1	67 	g 
	ld h,l			;19b2	65 	e 
l19b3h:
	cpl			;19b3	2f 	/ 
	ld (hl),e			;19b4	73 	s 
	ld (hl),h			;19b5	74 	t 
	ld (hl),d			;19b6	72 	r 
	ld l,c			;19b7	69 	i 
	ld l,(hl)			;19b8	6e 	n 
	ld h,a			;19b9	67 	g 
	rst 38h			;19ba	ff 	. 
l19bbh:
	jr nz,l19f9h		;19bb	20 3c 	  < 
	ld b,c			;19bd	41 	A 
	ld d,l			;19be	55 	U 
	ld d,h			;19bf	54 	T 
	ld c,a			;19c0	4f 	O 
	jr nz,$+85		;19c1	20 53 	  S 
	ld d,h			;19c3	54 	T 
	ld b,c			;19c4	41 	A 
	ld d,d			;19c5	52 	R 
	ld d,h			;19c6	54 	T 
	ld a,009h		;19c7	3e 09 	> . 
	ld sp,l6f3dh		;19c9	31 3d 6f 	1 = o 
	ld h,(hl)			;19cc	66 	f 
	ld h,(hl)			;19cd	66 	f 
	jr nz,l19f0h		;19ce	20 20 	    
	ld (l613dh),a		;19d0	32 3d 61 	2 = a 
	ld (hl),e			;19d3	73 	s 
	ld (hl),e			;19d4	73 	s 
	ld l,c			;19d5	69 	i 
	ld h,a			;19d6	67 	g 
	ld l,(hl)			;19d7	6e 	n 
	rst 38h			;19d8	ff 	. 
l19d9h:
	ld h,c			;19d9	61 	a 
	ld (hl),l			;19da	75 	u 
	ld (hl),h			;19db	74 	t 
	ld l,a			;19dc	6f 	o 
	jr nz,l1a52h		;19dd	20 73 	  s 
	ld (hl),h			;19df	74 	t 
	ld h,c			;19e0	61 	a 
	ld (hl),d			;19e1	72 	r 
	ld (hl),h			;19e2	74 	t 
	jr nz,l1a58h		;19e3	20 73 	  s 
	ld (hl),h			;19e5	74 	t 
	ld (hl),d			;19e6	72 	r 
	ld l,c			;19e7	69 	i 
	ld l,(hl)			;19e8	6e 	n 
	ld h,a			;19e9	67 	g 
	rst 38h			;19ea	ff 	. 
l19ebh:
	jr nz,l1a29h		;19eb	20 3c 	  < 
	ld c,l			;19ed	4d 	M 
	ld b,l			;19ee	45 	E 
	ld c,(hl)			;19ef	4e 	N 
l19f0h:
	ld d,l			;19f0	55 	U 
	ld a,009h		;19f1	3e 09 	> . 
	ld sp,l6f3dh		;19f3	31 3d 6f 	1 = o 
	ld h,(hl)			;19f6	66 	f 
	ld h,(hl)			;19f7	66 	f 
	add hl,bc			;19f8	09 	. 
l19f9h:
	ld (l6f3dh),a		;19f9	32 3d 6f 	2 = o 
	ld l,(hl)			;19fc	6e 	n 
	add hl,bc			;19fd	09 	. 
	inc sp			;19fe	33 	3 
	dec a			;19ff	3d 	= 
	ld h,h			;1a00	64 	d 
	ld (hl),d			;1a01	72 	r 
	ld l,c			;1a02	69 	i 
	halt			;1a03	76 	v 
	ld h,l			;1a04	65 	e 
	dec c			;1a05	0d 	. 
	ld a,(bc)			;1a06	0a 	. 
l1a07h:
	add hl,bc			;1a07	09 	. 
	inc (hl)			;1a08	34 	4 
	dec a			;1a09	3d 	= 
	ld h,l			;1a0a	65 	e 
	ld a,b			;1a0b	78 	x 
	ld (hl),h			;1a0c	74 	t 
	ld sp,l3509h		;1a0d	31 09 35 	1 . 5 
	dec a			;1a10	3d 	= 
l1a11h:
	ld h,l			;1a11	65 	e 
	ld a,b			;1a12	78 	x 
	ld (hl),h			;1a13	74 	t 
	ld (sub_3607h+2),a		;1a14	32 09 36 	2 . 6 
	dec a			;1a17	3d 	= 
	ld h,l			;1a18	65 	e 
	ld a,b			;1a19	78 	x 
	ld (hl),h			;1a1a	74 	t 
	inc sp			;1a1b	33 	3 
	add hl,bc			;1a1c	09 	. 
	scf			;1a1d	37 	7 
	dec a			;1a1e	3d 	= 
	ld h,l			;1a1f	65 	e 
	ld a,b			;1a20	78 	x 
	ld (hl),h			;1a21	74 	t 
	inc (hl)			;1a22	34 	4 
	rst 38h			;1a23	ff 	. 
l1a24h:
	ld h,l			;1a24	65 	e 
	ld a,b			;1a25	78 	x 
	ld (hl),h			;1a26	74 	t 
	ld h,l			;1a27	65 	e 
	ld l,(hl)			;1a28	6e 	n 
l1a29h:
	ld (hl),e			;1a29	73 	s 
	ld l,c			;1a2a	69 	i 
	ld l,a			;1a2b	6f 	o 
	ld l,(hl)			;1a2c	6e 	n 
	jr nz,$+112		;1a2d	20 6e 	  n 
	ld h,c			;1a2f	61 	a 
	ld l,l			;1a30	6d 	m 
	ld h,l			;1a31	65 	e 
	jr nz,l1a54h		;1a32	20 20 	    
	rst 38h			;1a34	ff 	. 
l1a35h:
	ld h,h			;1a35	64 	d 
	ld (hl),d			;1a36	72 	r 
	ld l,c			;1a37	69 	i 
	halt			;1a38	76 	v 
	ld h,l			;1a39	65 	e 
	jr nz,l1aaah		;1a3a	20 6e 	  n 
	ld h,c			;1a3c	61 	a 
	ld l,l			;1a3d	6d 	m 
	ld h,l			;1a3e	65 	e 
	ld (hl),e			;1a3f	73 	s 
	rst 38h			;1a40	ff 	. 
l1a41h:
	jr nz,l1a7fh		;1a41	20 3c 	  < 
	ld c,l			;1a43	4d 	M 
	ld b,e			;1a44	43 	C 
	ld d,h			;1a45	54 	T 
	ld a,00dh		;1a46	3e 0d 	> . 
	ld a,(bc)			;1a48	0a 	. 
	jr nz,l1a7ch		;1a49	20 31 	  1 
	dec a			;1a4b	3d 	= 
l1a4ch:
	ld (hl),e			;1a4c	73 	s 
	ld (hl),h			;1a4d	74 	t 
	ld l,a			;1a4e	6f 	o 
	ld (hl),b			;1a4f	70 	p 
	jr nz,l1a84h		;1a50	20 32 	  2 
l1a52h:
	dec a			;1a52	3d 	= 
l1a53h:
	ld l,(hl)			;1a53	6e 	n 
l1a54h:
	ld l,a			;1a54	6f 	o 
	ld l,(hl)			;1a55	6e 	n 
	ld (hl),e			;1a56	73 	s 
	ld (hl),h			;1a57	74 	t 
l1a58h:
	ld l,a			;1a58	6f 	o 
	ld (hl),b			;1a59	70 	p 
	jr nz,l1a8fh		;1a5a	20 33 	  3 
	dec a			;1a5c	3d 	= 
l1a5dh:
	halt			;1a5d	76 	v 
	ld h,l			;1a5e	65 	e 
	ld (hl),d			;1a5f	72 	r 
	ld l,c			;1a60	69 	i 
	ld h,(hl)			;1a61	66 	f 
	ld a,c			;1a62	79 	y 
	jr nz,$+54		;1a63	20 34 	  4 
	dec a			;1a65	3d 	= 
l1a66h:
	ld l,(hl)			;1a66	6e 	n 
	ld l,a			;1a67	6f 	o 
	ld l,(hl)			;1a68	6e 	n 
	halt			;1a69	76 	v 
	ld h,l			;1a6a	65 	e 
	ld (hl),d			;1a6b	72 	r 
	ld l,c			;1a6c	69 	i 
	ld h,(hl)			;1a6d	66 	f 
	ld a,c			;1a6e	79 	y 
	rst 38h			;1a6f	ff 	. 
l1a70h:
	inc c			;1a70	0c 	. 
	ld d,d			;1a71	52 	R 
	ld b,l			;1a72	45 	E 
	ld c,l			;1a73	4d 	M 
	ld c,a			;1a74	4f 	O 
	ld d,(hl)			;1a75	56 	V 
	ld b,l			;1a76	45 	E 
	rst 38h			;1a77	ff 	. 
l1a78h:
	inc c			;1a78	0c 	. 
	ld c,l			;1a79	4d 	M 
	ld c,a			;1a7a	4f 	O 
	ld d,l			;1a7b	55 	U 
l1a7ch:
	ld c,(hl)			;1a7c	4e 	N 
	ld d,h			;1a7d	54 	T 
	rst 38h			;1a7e	ff 	. 
l1a7fh:
	inc c			;1a7f	0c 	. 
	ld b,h			;1a80	44 	D 
	ld c,c			;1a81	49 	I 
	ld d,d			;1a82	52 	R 
	ld c,c			;1a83	49 	I 
l1a84h:
	ld c,(hl)			;1a84	4e 	N 
	ld c,c			;1a85	49 	I 
	ld d,h			;1a86	54 	T 
	rst 38h			;1a87	ff 	. 
l1a88h:
	jr nz,$+71		;1a88	20 45 	  E 
	ld d,d			;1a8a	52 	R 
	ld d,d			;1a8b	52 	R 
	ld c,a			;1a8c	4f 	O 
	ld d,d			;1a8d	52 	R 
	rst 38h			;1a8e	ff 	. 
l1a8fh:
	ld de,0ea00h		;1a8f	11 00 ea 	. . . 
	ld hl,l7738h		;1a92	21 38 77 	! 8 w 
	ld bc,l00fch+2		;1a95	01 fe 00 	. . . 
	ldir		;1a98	ed b0 	. . 
	ld de,(0ef24h)		;1a9a	ed 5b 24 ef 	. [ $ . 
	ld hl,0ea00h		;1a9e	21 00 ea 	! . . 
	ld bc,l0015h		;1aa1	01 15 00 	. . . 
	call 0ed66h		;1aa4	cd 66 ed 	. f . 
sub_1aa7h:
	ld de,0f310h		;1aa7	11 10 f3 	. . . 
l1aaah:
	ld hl,07f8bh		;1aaa	21 8b 7f 	! .  
	ld bc,0004ch		;1aad	01 4c 00 	. L . 
	ldir		;1ab0	ed b0 	. . 
	ret			;1ab2	c9 	. 
sub_1ab3h:
	ld de,0eb8dh		;1ab3	11 8d eb 	. . . 
	ld hl,l7836h		;1ab6	21 36 78 	! 6 x 
	ld bc,00377h		;1ab9	01 77 03 	. w . 
	ldir		;1abc	ed b0 	. . 
	ld de,RBDOS2		;1abe	11 90 ff 	. . . 
	ld hl,00785h		;1ac1	21 85 07 	! . . 
	ld bc,l0021h		;1ac4	01 21 00 	. ! . 
	ldir		;1ac7	ed b0 	. . 
	ld de,0ef1fh		;1ac9	11 1f ef 	. . . 
	ld c,010h		;1acc	0e 10 	. . 
	ld hl,0ffc0h		;1ace	21 c0 ff 	! . . 
l1ad1h:
	ld a,0c3h		;1ad1	3e c3 	> . 
	call sub_1b14h		;1ad3	cd 14 1b 	. . . 
	jr nz,l1ad1h		;1ad6	20 f9 	  . 
	ld de,0fff0h		;1ad8	11 f0 ff 	. . . 
	ld hl,l077bh		;1adb	21 7b 07 	! { . 
	ld bc,l000fh+1		;1ade	01 10 00 	. . . 
	ldir		;1ae1	ed b0 	. . 
	call BIOSJTLD		;1ae3	cd 01 1b 	. . . 
	ld hl,0eb00h		;1ae6	21 00 eb 	! . . 
	ld de,0eb8dh		;1ae9	11 8d eb 	. . . 
	ld c,02fh		;1aec	0e 2f 	. / 
l1aeeh:
	ld a,0cdh		;1aee	3e cd 	> . 
	call sub_1b14h		;1af0	cd 14 1b 	. . . 
	jr nz,l1aeeh		;1af3	20 f9 	  . 
	ld de,0efd0h		;1af5	11 d0 ef 	. . . 
	ld hl,l7c51h		;1af8	21 51 7c 	! Q | 
	ld bc,l033ah		;1afb	01 3a 03 	. : . 
	ldir		;1afe	ed b0 	. . 
l1b00h:
	ret			;1b00	c9 	. 
BIOSJTLD:
	ld hl,(0ef26h)		;1b01	2a 26 ef 	* & . 
	ld de,0eb00h		;1b04	11 00 eb 	. . . 
	ld c,02fh		;1b07	0e 2f 	. / 
l1b09h:
	ld a,0c3h		;1b09	3e c3 	> . 
	call sub_1b14h		;1b0b	cd 14 1b 	. . . 
	inc de			;1b0e	13 	. 
	inc de			;1b0f	13 	. 
	inc de			;1b10	13 	. 
	jr nz,l1b09h		;1b11	20 f6 	  . 
	ret			;1b13	c9 	. 
sub_1b14h:
	call 0ed46h		;1b14	cd 46 ed 	. F . 
	inc hl			;1b17	23 	# 
	ld a,e			;1b18	7b 	{ 
	call 0ed46h		;1b19	cd 46 ed 	. F . 
	inc hl			;1b1c	23 	# 
	ld a,d			;1b1d	7a 	z 
	call 0ed46h		;1b1e	cd 46 ed 	. F . 
	inc hl			;1b21	23 	# 
	dec c			;1b22	0d 	. 
	ret			;1b23	c9 	. 
sub_1b24h:
	ld de,0ef1fh		;1b24	11 1f ef 	. . . 
	ld hl,l7badh		;1b27	21 ad 7b 	! . { 
	ld bc,000a4h		;1b2a	01 a4 00 	. . . 
	ldir		;1b2d	ed b0 	. . 
l1b2fh:
	ret			;1b2f	c9 	. 
sub_1b30h:
	ld hl,(0ef22h)		;1b30	2a 22 ef 	* " . 
	ex de,hl			;1b33	eb 	. 
	ld hl,CCPCODE_start		;1b34	21 85 6e 	! . n 
	ld bc,l07bbh		;1b37	01 bb 07 	. . . 
	ld (0f7b4h),bc		;1b3a	ed 43 b4 f7 	. C . . 
	ld (0f7b6h),de		;1b3e	ed 53 b6 f7 	. S . . 
	ld (0f7b8h),hl		;1b42	22 b8 f7 	" . . 
	ld a,d			;1b45	7a 	z 
	ld (0f7beh),a		;1b46	32 be f7 	2 . . 
	add hl,bc			;1b49	09 	. 
l1b4ah:
	ld c,008h		;1b4a	0e 08 	. . 
	ld b,(hl)			;1b4c	46 	F 
	ld (0f7bah),bc		;1b4d	ed 43 ba f7 	. C . . 
	inc hl			;1b51	23 	# 
	ld (0f7bch),hl		;1b52	22 bc f7 	" . . 
l1b55h:
	ld bc,(0f7b4h)		;1b55	ed 4b b4 f7 	. K . . 
	ld a,b			;1b59	78 	x 
	or c			;1b5a	b1 	. 
	ret z			;1b5b	c8 	. 
	dec bc			;1b5c	0b 	. 
	ld (0f7b4h),bc		;1b5d	ed 43 b4 f7 	. C . . 
	ld de,(0f7b6h)		;1b61	ed 5b b6 f7 	. [ . . 
	ld hl,(0f7b8h)		;1b65	2a b8 f7 	* . . 
	ld bc,(0f7bah)		;1b68	ed 4b ba f7 	. K . . 
	ld a,b			;1b6c	78 	x 
	sla a		;1b6d	cb 27 	. ' 
	ld b,a			;1b6f	47 	G 
	ld a,000h		;1b70	3e 00 	> . 
	jr nc,l1b77h		;1b72	30 03 	0 . 
	ld a,(0f7beh)		;1b74	3a be f7 	: . . 
l1b77h:
	add a,(hl)			;1b77	86 	. 
	ex de,hl			;1b78	eb 	. 
	call 0ed46h		;1b79	cd 46 ed 	. F . 
	ex de,hl			;1b7c	eb 	. 
	inc de			;1b7d	13 	. 
	inc hl			;1b7e	23 	# 
	ld (0f7b8h),hl		;1b7f	22 b8 f7 	" . . 
	ld (0f7b6h),de		;1b82	ed 53 b6 f7 	. S . . 
	dec c			;1b86	0d 	. 
	jr nz,l1b8eh		;1b87	20 05 	  . 
	ld hl,(0f7bch)		;1b89	2a bc f7 	* . . 
	jr l1b4ah		;1b8c	18 bc 	. . 
l1b8eh:
	ld (0f7bah),bc		;1b8e	ed 43 ba f7 	. C . . 
	jr l1b55h		;1b92	18 c1 	. . 
SETERR:
	ld a,0ffh		;1b94	3e ff 	> . 
	ld hl,l1bbbh		;1b96	21 bb 1b 	! . . 
	jr l1b9fh		;1b99	18 04 	. . 
RSTERR:
	xor a			;1b9b	af 	. 
	ld hl,07741h		;1b9c	21 41 77 	! A w 
l1b9fh:
	ld (0f52ah),a		;1b9f	32 2a f5 	2 * . 
	ld de,0ea09h		;1ba2	11 09 ea 	. . . 
	ld bc,l0006h+2		;1ba5	01 08 00 	. . . 
	push de			;1ba8	d5 	. 
	push bc			;1ba9	c5 	. 
	ldir		;1baa	ed b0 	. . 
	pop bc			;1bac	c1 	. 
	ld hl,(0ef24h)		;1bad	2a 24 ef 	* $ . 
	ld de,l0009h		;1bb0	11 09 00 	. . . 
	add hl,de			;1bb3	19 	. 
	ex de,hl			;1bb4	eb 	. 
	pop hl			;1bb5	e1 	. 
	ld a,0ffh		;1bb6	3e ff 	> . 
	jp 0ece6h		;1bb8	c3 e6 ec 	. . . 
l1bbbh:
	and l			;1bbb	a5 	. 
	ldd		;1bbc	ed a8 	. . 
	outd		;1bbe	ed ab 	. . 
	defb 0edh;next byte illegal after ed		;1bc0	ed 	. 
	xor (hl)			;1bc1	ae 	. 
	defb 0edh		;1bc2	ed 	. 

; BLOCK 'BDOSCODE' (start 0x1bc3 end 0x2975)
BDOSCODE_start:
	call c,00316h		;1bc3	dc 16 03 	. . . 
	nop			;1bc6	00 	. 
	ld bc,0c301h		;1bc7	01 01 c3 	. . . 
	call nc,0ea1bh		;1bca	d4 1b ea 	. . . 
	ld e,0eeh		;1bcd	1e ee 	. . 
	ld e,0f2h		;1bcf	1e f2 	. . 
	ld e,0f6h		;1bd1	1e f6 	. . 
	ld e,0ebh		;1bd3	1e eb 	. . 
	ld (0f4e3h),hl		;1bd5	22 e3 f4 	" . . 
	ex de,hl			;1bd8	eb 	. 
	ld a,e			;1bd9	7b 	{ 
	ld (0f50ah),a		;1bda	32 0a f5 	2 . . 
	ld hl,COLDRST		;1bdd	21 00 00 	! . . 
	ld (0f4e5h),hl		;1be0	22 e5 f4 	" . . 
	add hl,sp			;1be3	39 	9 
	ld (0f4e1h),hl		;1be4	22 e1 f4 	" . . 
	jp l5e0ah		;1be7	c3 0a 5e 	. . ^ 
l1beah:
	xor a			;1bea	af 	. 
	ld (0f514h),a		;1beb	32 14 f5 	2 . . 
	ld (0f512h),a		;1bee	32 12 f5 	2 . . 
l1bf1h:
	ld hl,GOBACK		;1bf1	21 37 29 	! 7 ) 
	push hl			;1bf4	e5 	. 
	ld a,c			;1bf5	79 	y 
	cp 029h		;1bf6	fe 29 	. ) 
	ret nc			;1bf8	d0 	. 
	ld c,e			;1bf9	4b 	K 
	ld hl,BDOSTABL		;1bfa	21 0a 1c 	! . . 
	ld e,a			;1bfd	5f 	_ 
	ld d,000h		;1bfe	16 00 	. . 
	add hl,de			;1c00	19 	. 
	add hl,de			;1c01	19 	. 
	ld e,(hl)			;1c02	5e 	^ 
	inc hl			;1c03	23 	# 
l1c04h:
	ld d,(hl)			;1c04	56 	V 
	ld hl,(0f4e3h)		;1c05	2a e3 f4 	* . . 
	ex de,hl			;1c08	eb 	. 
	jp (hl)			;1c09	e9 	. 
BDOSTABL:
	inc a			;1c0a	3c 	< 
	ld hl,(l1e8bh)		;1c0b	2a 8b 1e 	* . . 
	ld d,e			;1c0e	53 	S 
	dec e			;1c0f	1d 	. 
	sub c			;1c10	91 	. 
	ld e,04bh		;1c11	1e 4b 	. K 
	ld hl,(l2a48h)		;1c13	2a 48 2a 	* H * 
	sub a			;1c16	97 	. 
	ld e,0b0h		;1c17	1e b0 	. . 
	ld e,0b6h		;1c19	1e b6 	. . 
	ld e,0bbh		;1c1b	1e bb 	. . 
	ld e,0a4h		;1c1d	1e a4 	. . 
l1c1fh:
	dec e			;1c1f	1d 	. 
	pop bc			;1c20	c1 	. 
	ld e,041h		;1c21	1e 41 	. A 
	jr z,$-76		;1c23	28 b2 	( . 
	add hl,hl			;1c25	29 	) 
	ex af,af'			;1c26	08 	. 
l1c27h:
	jr z,l1c88h		;1c27	28 5f 	( _ 
	jr z,l1c93h		;1c29	28 68 	( h 
	jr z,l1c9bh		;1c2b	28 6e 	( n 
	jr z,$-115		;1c2d	28 8b 	( . 
l1c2fh:
	jr z,$-100		;1c2f	28 9a 	( . 
	jr z,$-91		;1c31	28 a3 	( . 
	jr z,$-85		;1c33	28 a9 	( . 
	jr z,$-79		;1c35	28 af 	( . 
	jr z,l1bf1h		;1c37	28 b8 	( . 
	jr z,$-61		;1c39	28 c1 	( . 
l1c3bh:
	jr z,l1c04h		;1c3b	28 c7 	( . 
	jr z,$-49		;1c3d	28 cd 	( . 
	jr z,$-42		;1c3f	28 d4 	( . 
	jr z,$-15		;1c41	28 ef 	( . 
	jr nz,l1c1fh		;1c43	20 da 	  . 
	jr z,l1c27h		;1c45	28 e0 	( . 
	jr z,$-21		;1c47	28 e9 	( . 
	jr z,l1c3bh		;1c49	28 f0 	( . 
	jr z,$+6		;1c4b	28 04 	( . 
	add hl,hl			;1c4d	29 	) 
	ld a,(bc)			;1c4e	0a 	. 
	add hl,hl			;1c4f	29 	) 
	djnz $+43		;1c50	10 29 	. ) 
	pop de			;1c52	d1 	. 
	daa			;1c53	27 	' 
	ld d,029h		;1c54	16 29 	. ) 
	rst 0			;1c56	c7 	. 
	ld e,0c7h		;1c57	1e c7 	. . 
	ld e,05eh		;1c59	1e 5e 	. ^ 
	add hl,hl			;1c5b	29 	) 
l1c5ch:
	ld hl,l1c8dh		;1c5c	21 8d 1c 	! . . 
	call sub_1ca8h		;1c5f	cd a8 1c 	. . . 
	cp 003h		;1c62	fe 03 	. . 
	jp z,l2a3ch		;1c64	ca 3c 2a 	. < * 
	ret			;1c67	c9 	. 
l1c68h:
	ld hl,l1c98h		;1c68	21 98 1c 	! . . 
	jp l1c77h		;1c6b	c3 77 1c 	. w . 
l1c6eh:
	ld hl,01ca4h		;1c6e	21 a4 1c 	! . . 
	jp l1c77h		;1c71	c3 77 1c 	. w . 
l1c74h:
	ld hl,l1c9fh		;1c74	21 9f 1c 	! . . 
l1c77h:
	call sub_1ca8h		;1c77	cd a8 1c 	. . . 
	jp l2a3ch		;1c7a	c3 3c 2a 	. < * 
l1c7dh:
	ld b,d			;1c7d	42 	B 
	ld b,h			;1c7e	44 	D 
	ld c,a			;1c7f	4f 	O 
	ld d,e			;1c80	53 	S 
	jr nz,$+71		;1c81	20 45 	  E 
	ld d,d			;1c83	52 	R 
	ld d,d			;1c84	52 	R 
	jr nz,l1cd6h		;1c85	20 4f 	  O 
	ld c,(hl)			;1c87	4e 	N 
l1c88h:
	jr nz,$+38		;1c88	20 24 	  $ 
l1c8ah:
	ld a,(l2420h)		;1c8a	3a 20 24 	:   $ 
l1c8dh:
	ld b,d			;1c8d	42 	B 
	ld b,c			;1c8e	41 	A 
	ld b,h			;1c8f	44 	D 
	jr nz,l1ce5h		;1c90	20 53 	  S 
	ld b,l			;1c92	45 	E 
l1c93h:
	ld b,e			;1c93	43 	C 
	ld d,h			;1c94	54 	T 
	ld c,a			;1c95	4f 	O 
	ld d,d			;1c96	52 	R 
	inc h			;1c97	24 	$ 
l1c98h:
	ld d,e			;1c98	53 	S 
	ld b,l			;1c99	45 	E 
	ld c,h			;1c9a	4c 	L 
l1c9bh:
	ld b,l			;1c9b	45 	E 
	ld b,e			;1c9c	43 	C 
	ld d,h			;1c9d	54 	T 
	inc h			;1c9e	24 	$ 
l1c9fh:
	ld b,(hl)			;1c9f	46 	F 
	ld c,c			;1ca0	49 	I 
	ld c,h			;1ca1	4c 	L 
	ld b,l			;1ca2	45 	E 
	jr nz,$+84		;1ca3	20 52 	  R 
	cpl			;1ca5	2f 	/ 
	ld c,a			;1ca6	4f 	O 
	inc h			;1ca7	24 	$ 
sub_1ca8h:
	push hl			;1ca8	e5 	. 
	call sub_1d8ch		;1ca9	cd 8c 1d 	. . . 
	call sub_29c3h		;1cac	cd c3 29 	. . ) 
	add a,041h		;1caf	c6 41 	. A 
	ld bc,l1c7dh		;1cb1	01 7d 1c 	. } . 
	call sub_1efch		;1cb4	cd fc 1e 	. . . 
	call sub_1d96h		;1cb7	cd 96 1d 	. . . 
	pop bc			;1cba	c1 	. 
	call sub_1d96h		;1cbb	cd 96 1d 	. . . 
sub_1cbeh:
	ld hl,0f31bh		;1cbe	21 1b f3 	! . . 
	ld a,(hl)			;1cc1	7e 	~ 
	ld (hl),000h		;1cc2	36 00 	6 . 
	or a			;1cc4	b7 	. 
	ret nz			;1cc5	c0 	. 
	jp l2a42h		;1cc6	c3 42 2a 	. B * 
sub_1cc9h:
	call sub_1cbeh		;1cc9	cd be 1c 	. . . 
	call sub_1cd7h		;1ccc	cd d7 1c 	. . . 
	ret c			;1ccf	d8 	. 
sub_1cd0h:
	push af			;1cd0	f5 	. 
	ld c,a			;1cd1	4f 	O 
	call sub_1d53h		;1cd2	cd 53 1d 	. S . 
	pop af			;1cd5	f1 	. 
l1cd6h:
	ret			;1cd6	c9 	. 
sub_1cd7h:
	cp 00dh		;1cd7	fe 0d 	. . 
	ret z			;1cd9	c8 	. 
	cp 00ah		;1cda	fe 0a 	. . 
	ret z			;1cdc	c8 	. 
	cp 009h		;1cdd	fe 09 	. . 
	ret z			;1cdf	c8 	. 
	cp 008h		;1ce0	fe 08 	. . 
	ret z			;1ce2	c8 	. 
	cp 020h		;1ce3	fe 20 	.   
l1ce5h:
	ret			;1ce5	c9 	. 
sub_1ce6h:
	ld a,(0f31bh)		;1ce6	3a 1b f3 	: . . 
	or a			;1ce9	b7 	. 
	jp nz,l1d08h		;1cea	c2 08 1d 	. . . 
	call sub_2a3fh		;1ced	cd 3f 2a 	. ? * 
	and 001h		;1cf0	e6 01 	. . 
	ret z			;1cf2	c8 	. 
	call l2a42h		;1cf3	cd 42 2a 	. B * 
	cp 013h		;1cf6	fe 13 	. . 
	jp nz,l1d05h		;1cf8	c2 05 1d 	. . . 
	call l2a42h		;1cfb	cd 42 2a 	. B * 
	cp 003h		;1cfe	fe 03 	. . 
	jp z,l2a3ch		;1d00	ca 3c 2a 	. < * 
	xor a			;1d03	af 	. 
	ret			;1d04	c9 	. 
l1d05h:
	ld (0f31bh),a		;1d05	32 1b f3 	2 . . 
l1d08h:
	ld a,001h		;1d08	3e 01 	> . 
	ret			;1d0a	c9 	. 
sub_1d0bh:
	ld a,(0f317h)		;1d0b	3a 17 f3 	: . . 
	or a			;1d0e	b7 	. 
	jp nz,l1d25h		;1d0f	c2 25 1d 	. % . 
	push bc			;1d12	c5 	. 
	call sub_1ce6h		;1d13	cd e6 1c 	. . . 
	pop bc			;1d16	c1 	. 
	push bc			;1d17	c5 	. 
	call sub_2a45h		;1d18	cd 45 2a 	. E * 
	pop bc			;1d1b	c1 	. 
	push bc			;1d1c	c5 	. 
	ld a,(0f31ah)		;1d1d	3a 1a f3 	: . . 
	or a			;1d20	b7 	. 
	call nz,l2a48h		;1d21	c4 48 2a 	. H * 
	pop bc			;1d24	c1 	. 
l1d25h:
	ld a,c			;1d25	79 	y 
	ld hl,0f319h		;1d26	21 19 f3 	! . . 
	cp 07fh		;1d29	fe 7f 	.  
	ret z			;1d2b	c8 	. 
	inc (hl)			;1d2c	34 	4 
	cp 020h		;1d2d	fe 20 	.   
	ret nc			;1d2f	d0 	. 
	dec (hl)			;1d30	35 	5 
	ld a,(hl)			;1d31	7e 	~ 
	or a			;1d32	b7 	. 
	ret z			;1d33	c8 	. 
	ld a,c			;1d34	79 	y 
	cp 008h		;1d35	fe 08 	. . 
	jp nz,l1d3ch		;1d37	c2 3c 1d 	. < . 
	dec (hl)			;1d3a	35 	5 
	ret			;1d3b	c9 	. 
l1d3ch:
	cp 00ah		;1d3c	fe 0a 	. . 
	ret nz			;1d3e	c0 	. 
	ld (hl),000h		;1d3f	36 00 	6 . 
	ret			;1d41	c9 	. 
sub_1d42h:
	ld a,c			;1d42	79 	y 
	call sub_1cd7h		;1d43	cd d7 1c 	. . . 
	jp nc,sub_1d53h		;1d46	d2 53 1d 	. S . 
	push af			;1d49	f5 	. 
	ld c,05eh		;1d4a	0e 5e 	. ^ 
	call sub_1d0bh		;1d4c	cd 0b 1d 	. . . 
	pop af			;1d4f	f1 	. 
	or 040h		;1d50	f6 40 	. @ 
	ld c,a			;1d52	4f 	O 
sub_1d53h:
	ld a,c			;1d53	79 	y 
	cp 009h		;1d54	fe 09 	. . 
	jp nz,sub_1d0bh		;1d56	c2 0b 1d 	. . . 
l1d59h:
	ld c,020h		;1d59	0e 20 	.   
	call sub_1d0bh		;1d5b	cd 0b 1d 	. . . 
	ld a,(0f319h)		;1d5e	3a 19 f3 	: . . 
	and 007h		;1d61	e6 07 	. . 
	jp nz,l1d59h		;1d63	c2 59 1d 	. Y . 
	ret			;1d66	c9 	. 
sub_1d67h:
	call sub_1d6fh		;1d67	cd 6f 1d 	. o . 
	ld c,020h		;1d6a	0e 20 	.   
	call sub_2a45h		;1d6c	cd 45 2a 	. E * 
sub_1d6fh:
	ld c,008h		;1d6f	0e 08 	. . 
	jp sub_2a45h		;1d71	c3 45 2a 	. E * 
sub_1d74h:
	ld c,023h		;1d74	0e 23 	. # 
	call sub_1d0bh		;1d76	cd 0b 1d 	. . . 
	call sub_1d8ch		;1d79	cd 8c 1d 	. . . 
l1d7ch:
	ld a,(0f319h)		;1d7c	3a 19 f3 	: . . 
	ld hl,0f318h		;1d7f	21 18 f3 	! . . 
	cp (hl)			;1d82	be 	. 
	ret nc			;1d83	d0 	. 
	ld c,020h		;1d84	0e 20 	.   
	call sub_1d0bh		;1d86	cd 0b 1d 	. . . 
	jp l1d7ch		;1d89	c3 7c 1d 	. | . 
sub_1d8ch:
	ld c,00dh		;1d8c	0e 0d 	. . 
	call sub_1d0bh		;1d8e	cd 0b 1d 	. . . 
	ld c,00ah		;1d91	0e 0a 	. . 
	jp sub_1d0bh		;1d93	c3 0b 1d 	. . . 
sub_1d96h:
	ld a,(bc)			;1d96	0a 	. 
	cp 024h		;1d97	fe 24 	. $ 
	ret z			;1d99	c8 	. 
	inc bc			;1d9a	03 	. 
	push bc			;1d9b	c5 	. 
	ld c,a			;1d9c	4f 	O 
	call sub_1d53h		;1d9d	cd 53 1d 	. S . 
	pop bc			;1da0	c1 	. 
	jp sub_1d96h		;1da1	c3 96 1d 	. . . 
l1da4h:
	ld a,(0f319h)		;1da4	3a 19 f3 	: . . 
	ld (0f318h),a		;1da7	32 18 f3 	2 . . 
	ld hl,(0f4e3h)		;1daa	2a e3 f4 	* . . 
	jp l296fh		;1dad	c3 6f 29 	. o ) 
l1db0h:
	ld b,000h		;1db0	06 00 	. . 
l1db2h:
	push bc			;1db2	c5 	. 
	push hl			;1db3	e5 	. 
l1db4h:
	call sub_1cbeh		;1db4	cd be 1c 	. . . 
	and 0ffh		;1db7	e6 ff 	. . 
	pop hl			;1db9	e1 	. 
	pop bc			;1dba	c1 	. 
	cp 00dh		;1dbb	fe 0d 	. . 
	jp z,l1e84h		;1dbd	ca 84 1e 	. . . 
	cp 00ah		;1dc0	fe 0a 	. . 
	jp z,l1e84h		;1dc2	ca 84 1e 	. . . 
	cp 008h		;1dc5	fe 08 	. . 
	jp nz,l1dd9h		;1dc7	c2 d9 1d 	. . . 
	ld a,b			;1dca	78 	x 
	or a			;1dcb	b7 	. 
	jp z,l1db2h		;1dcc	ca b2 1d 	. . . 
	dec b			;1dcf	05 	. 
	ld a,(0f319h)		;1dd0	3a 19 f3 	: . . 
	ld (0f317h),a		;1dd3	32 17 f3 	2 . . 
	jp l1e33h		;1dd6	c3 33 1e 	. 3 . 
l1dd9h:
	cp 07fh		;1dd9	fe 7f 	.  
	jp nz,l1de9h		;1ddb	c2 e9 1d 	. . . 
	ld a,b			;1dde	78 	x 
	or a			;1ddf	b7 	. 
	jp z,l1db2h		;1de0	ca b2 1d 	. . . 
	call sub_2978h		;1de3	cd 78 29 	. x ) 
	jp l1e6ch		;1de6	c3 6c 1e 	. l . 
l1de9h:
	cp 005h		;1de9	fe 05 	. . 
	jp nz,l1dfah		;1deb	c2 fa 1d 	. . . 
	push bc			;1dee	c5 	. 
	push hl			;1def	e5 	. 
	call sub_1d8ch		;1df0	cd 8c 1d 	. . . 
	xor a			;1df3	af 	. 
	ld (0f318h),a		;1df4	32 18 f3 	2 . . 
	jp l1db4h		;1df7	c3 b4 1d 	. . . 
l1dfah:
	cp 010h		;1dfa	fe 10 	. . 
	jp nz,l1e0bh		;1dfc	c2 0b 1e 	. . . 
	push hl			;1dff	e5 	. 
	ld hl,0f31ah		;1e00	21 1a f3 	! . . 
	ld a,001h		;1e03	3e 01 	> . 
	sub (hl)			;1e05	96 	. 
	ld (hl),a			;1e06	77 	w 
	pop hl			;1e07	e1 	. 
	jp l1db2h		;1e08	c3 b2 1d 	. . . 
l1e0bh:
	cp 018h		;1e0b	fe 18 	. . 
	jp nz,l1e22h		;1e0d	c2 22 1e 	. " . 
	pop hl			;1e10	e1 	. 
l1e11h:
	ld a,(0f318h)		;1e11	3a 18 f3 	: . . 
	ld hl,0f319h		;1e14	21 19 f3 	! . . 
	cp (hl)			;1e17	be 	. 
	jp nc,l1da4h		;1e18	d2 a4 1d 	. . . 
	dec (hl)			;1e1b	35 	5 
	call sub_1d67h		;1e1c	cd 67 1d 	. g . 
	jp l1e11h		;1e1f	c3 11 1e 	. . . 
l1e22h:
	cp 015h		;1e22	fe 15 	. . 
	jp nz,l1e2eh		;1e24	c2 2e 1e 	. . . 
	call sub_1d74h		;1e27	cd 74 1d 	. t . 
	pop hl			;1e2a	e1 	. 
	jp l1da4h		;1e2b	c3 a4 1d 	. . . 
l1e2eh:
	cp 012h		;1e2e	fe 12 	. . 
	jp nz,l1e69h		;1e30	c2 69 1e 	. i . 
l1e33h:
	push bc			;1e33	c5 	. 
	call sub_1d74h		;1e34	cd 74 1d 	. t . 
	pop bc			;1e37	c1 	. 
	pop hl			;1e38	e1 	. 
	push hl			;1e39	e5 	. 
	push bc			;1e3a	c5 	. 
l1e3bh:
	ld a,b			;1e3b	78 	x 
	or a			;1e3c	b7 	. 
	jp z,l1e4dh		;1e3d	ca 4d 1e 	. M . 
	call sub_2980h		;1e40	cd 80 29 	. . ) 
	push bc			;1e43	c5 	. 
	push hl			;1e44	e5 	. 
	call sub_1d42h		;1e45	cd 42 1d 	. B . 
	pop hl			;1e48	e1 	. 
	pop bc			;1e49	c1 	. 
	jp l1e3bh		;1e4a	c3 3b 1e 	. ; . 
l1e4dh:
	push hl			;1e4d	e5 	. 
	ld a,(0f317h)		;1e4e	3a 17 f3 	: . . 
	or a			;1e51	b7 	. 
	jp z,l1db4h		;1e52	ca b4 1d 	. . . 
	ld hl,0f319h		;1e55	21 19 f3 	! . . 
	sub (hl)			;1e58	96 	. 
	ld (0f317h),a		;1e59	32 17 f3 	2 . . 
l1e5ch:
	call sub_1d67h		;1e5c	cd 67 1d 	. g . 
	ld hl,0f317h		;1e5f	21 17 f3 	! . . 
	dec (hl)			;1e62	35 	5 
	jp nz,l1e5ch		;1e63	c2 5c 1e 	. \ . 
	jp l1db4h		;1e66	c3 b4 1d 	. . . 
l1e69h:
	call sub_2987h		;1e69	cd 87 29 	. . ) 
l1e6ch:
	push bc			;1e6c	c5 	. 
	push hl			;1e6d	e5 	. 
	ld c,a			;1e6e	4f 	O 
	call sub_1d42h		;1e6f	cd 42 1d 	. B . 
	jp l298fh		;1e72	c3 8f 29 	. . ) 
l1e75h:
	cp 003h		;1e75	fe 03 	. . 
	ld a,b			;1e77	78 	x 
	jp nz,l1e80h		;1e78	c2 80 1e 	. . . 
	cp 001h		;1e7b	fe 01 	. . 
	jp z,l2a3ch		;1e7d	ca 3c 2a 	. < * 
l1e80h:
	cp c			;1e80	b9 	. 
	jp c,l1db2h		;1e81	da b2 1d 	. . . 
l1e84h:
	pop hl			;1e84	e1 	. 
	call sub_2997h		;1e85	cd 97 29 	. . ) 
	jp sub_1d0bh		;1e88	c3 0b 1d 	. . . 
l1e8bh:
	call sub_1cc9h		;1e8b	cd c9 1c 	. . . 
	jp l1ec4h		;1e8e	c3 c4 1e 	. . . 
	call sub_2a4eh		;1e91	cd 4e 2a 	. N * 
	jp l1ec4h		;1e94	c3 c4 1e 	. . . 
	ld a,c			;1e97	79 	y 
	inc a			;1e98	3c 	< 
	jp z,l1ea3h		;1e99	ca a3 1e 	. . . 
	inc a			;1e9c	3c 	< 
	jp z,sub_2a3fh		;1e9d	ca 3f 2a 	. ? * 
	jp sub_2a45h		;1ea0	c3 45 2a 	. E * 
l1ea3h:
	call sub_2a3fh		;1ea3	cd 3f 2a 	. ? * 
	or a			;1ea6	b7 	. 
	jp z,l2954h		;1ea7	ca 54 29 	. T ) 
	call l2a42h		;1eaa	cd 42 2a 	. B * 
	jp l1ec4h		;1ead	c3 c4 1e 	. . . 
	call sub_1ed9h		;1eb0	cd d9 1e 	. . . 
	jp l1ec4h		;1eb3	c3 c4 1e 	. . . 
	ld a,c			;1eb6	79 	y 
	call sub_1edfh		;1eb7	cd df 1e 	. . . 
	ret			;1eba	c9 	. 
	ex de,hl			;1ebb	eb 	. 
	ld c,l			;1ebc	4d 	M 
	ld b,h			;1ebd	44 	D 
	jp sub_1d96h		;1ebe	c3 96 1d 	. . . 
	call sub_1ce6h		;1ec1	cd e6 1c 	. . . 
l1ec4h:
	ld (0f4e5h),a		;1ec4	32 e5 f4 	2 . . 
	ret			;1ec7	c9 	. 
sub_1ec8h:
	ld a,001h		;1ec8	3e 01 	> . 
	jp l1ec4h		;1eca	c3 c4 1e 	. . . 
l1ecdh:
	xor a			;1ecd	af 	. 
	ld c,000h		;1ece	0e 00 	. . 
	ld hl,l0003h+1		;1ed0	21 04 00 	! . . 
	call 0ec6ah		;1ed3	cd 6a ec 	. j . 
	jp l1c68h		;1ed6	c3 68 1c 	. h . 
sub_1ed9h:
	ld ix,0ec64h		;1ed9	dd 21 64 ec 	. ! d . 
	jr l1ee3h		;1edd	18 04 	. . 
sub_1edfh:
	ld ix,0ec6ah		;1edf	dd 21 6a ec 	. ! j . 
l1ee3h:
	ld hl,l0003h		;1ee3	21 03 00 	! . . 
	ld c,000h		;1ee6	0e 00 	. . 
	jp (ix)		;1ee8	dd e9 	. . 
l1eeah:
	ld de,COLDRST		;1eea	11 00 00 	. . . 
	ld a,(00211h)		;1eed	3a 11 02 	: . . 
	nop			;1ef0	00 	. 
	ld a,(l0411h)		;1ef1	3a 11 04 	: . . 
	nop			;1ef4	00 	. 
	ld a,(l0611h)		;1ef5	3a 11 06 	: . . 
	nop			;1ef8	00 	. 
	jp 0ed7dh		;1ef9	c3 7d ed 	. } . 
sub_1efch:
	push af			;1efc	f5 	. 
	call sub_1d96h		;1efd	cd 96 1d 	. . . 
	pop af			;1f00	f1 	. 
	call sub_1cd0h		;1f01	cd d0 1c 	. . . 
	ld bc,l1c8ah		;1f04	01 8a 1c 	. . . 
	ret			;1f07	c9 	. 
	rst 38h			;1f08	ff 	. 
	rst 38h			;1f09	ff 	. 
sub_1f0ah:
	ld hl,01bceh		;1f0a	21 ce 1b 	! . . 
l1f0dh:
	ld e,(hl)			;1f0d	5e 	^ 
	inc hl			;1f0e	23 	# 
	ld d,(hl)			;1f0f	56 	V 
	ex de,hl			;1f10	eb 	. 
	jp (hl)			;1f11	e9 	. 
sub_1f12h:
	inc c			;1f12	0c 	. 
l1f13h:
	dec c			;1f13	0d 	. 
	ret z			;1f14	c8 	. 
	ld a,(de)			;1f15	1a 	. 
	ld (hl),a			;1f16	77 	w 
	inc de			;1f17	13 	. 
	inc hl			;1f18	23 	# 
	jp l1f13h		;1f19	c3 13 1f 	. . . 
sub_1f1ch:
	ld a,(0f31dh)		;1f1c	3a 1d f3 	: . . 
	ld c,a			;1f1f	4f 	O 
	call sub_2a54h		;1f20	cd 54 2a 	. T * 
	ld a,h			;1f23	7c 	| 
	or l			;1f24	b5 	. 
	ret z			;1f25	c8 	. 
	ld e,(hl)			;1f26	5e 	^ 
	inc hl			;1f27	23 	# 
	ld d,(hl)			;1f28	56 	V 
	inc hl			;1f29	23 	# 
	ld (0f4e7h),hl		;1f2a	22 e7 f4 	" . . 
	inc hl			;1f2d	23 	# 
	inc hl			;1f2e	23 	# 
	ld (0f4e9h),hl		;1f2f	22 e9 f4 	" . . 
	inc hl			;1f32	23 	# 
	inc hl			;1f33	23 	# 
	ld (0f4ebh),hl		;1f34	22 eb f4 	" . . 
	inc hl			;1f37	23 	# 
	inc hl			;1f38	23 	# 
	ex de,hl			;1f39	eb 	. 
	ld (0f504h),hl		;1f3a	22 04 f5 	" . . 
	ld hl,0f4edh		;1f3d	21 ed f4 	! . . 
	ld c,008h		;1f40	0e 08 	. . 
	call sub_1f12h		;1f42	cd 12 1f 	. . . 
	ld hl,(0f4efh)		;1f45	2a ef f4 	* . . 
	ex de,hl			;1f48	eb 	. 
	ld hl,0f4f5h		;1f49	21 f5 f4 	! . . 
	ld c,00fh		;1f4c	0e 0f 	. . 
	call sub_1f12h		;1f4e	cd 12 1f 	. . . 
	ld hl,(0f4fah)		;1f51	2a fa f4 	* . . 
	ld a,h			;1f54	7c 	| 
	ld hl,0f511h		;1f55	21 11 f5 	! . . 
	ld (hl),0ffh		;1f58	36 ff 	6 . 
	or a			;1f5a	b7 	. 
	jp z,l1f60h		;1f5b	ca 60 1f 	. ` . 
	ld (hl),000h		;1f5e	36 00 	6 . 
l1f60h:
	ld a,0ffh		;1f60	3e ff 	> . 
	or a			;1f62	b7 	. 
	ret			;1f63	c9 	. 
sub_1f64h:
	call sub_2a51h		;1f64	cd 51 2a 	. Q * 
	xor a			;1f67	af 	. 
	ld hl,(0f4e9h)		;1f68	2a e9 f4 	* . . 
	ld (hl),a			;1f6b	77 	w 
	inc hl			;1f6c	23 	# 
	ld (hl),a			;1f6d	77 	w 
	ld hl,(0f4ebh)		;1f6e	2a eb f4 	* . . 
	ld (hl),a			;1f71	77 	w 
	inc hl			;1f72	23 	# 
	ld (hl),a			;1f73	77 	w 
	ret			;1f74	c9 	. 
sub_1f75h:
	call sub_2a60h		;1f75	cd 60 2a 	. ` * 
	jp l1f7eh		;1f78	c3 7e 1f 	. ~ . 
sub_1f7bh:
	call sub_2a63h		;1f7b	cd 63 2a 	. c * 
l1f7eh:
	or a			;1f7e	b7 	. 
	ret z			;1f7f	c8 	. 
	ld hl,01bcch		;1f80	21 cc 1b 	! . . 
	jp l1f0dh		;1f83	c3 0d 1f 	. . . 
sub_1f86h:
	ld hl,(0f51eh)		;1f86	2a 1e f5 	* . . 
	ld c,002h		;1f89	0e 02 	. . 
	call sub_20adh		;1f8b	cd ad 20 	. .   
	ld (0f519h),hl		;1f8e	22 19 f5 	" . . 
	ld (0f520h),hl		;1f91	22 20 f5 	"   . 
sub_1f94h:
	ld hl,0f519h		;1f94	21 19 f5 	! . . 
	ld c,(hl)			;1f97	4e 	N 
	inc hl			;1f98	23 	# 
	ld b,(hl)			;1f99	46 	F 
	ld hl,(0f4ebh)		;1f9a	2a eb f4 	* . . 
	ld e,(hl)			;1f9d	5e 	^ 
	inc hl			;1f9e	23 	# 
	ld d,(hl)			;1f9f	56 	V 
	ld hl,(0f4e9h)		;1fa0	2a e9 f4 	* . . 
	ld a,(hl)			;1fa3	7e 	~ 
	inc hl			;1fa4	23 	# 
	ld h,(hl)			;1fa5	66 	f 
	ld l,a			;1fa6	6f 	o 
l1fa7h:
	ld a,c			;1fa7	79 	y 
	sub e			;1fa8	93 	. 
	ld a,b			;1fa9	78 	x 
	sbc a,d			;1faa	9a 	. 
	jp nc,l1fbdh		;1fab	d2 bd 1f 	. . . 
	push hl			;1fae	e5 	. 
	ld hl,(0f4f5h)		;1faf	2a f5 f4 	* . . 
	ld a,e			;1fb2	7b 	{ 
	sub l			;1fb3	95 	. 
	ld e,a			;1fb4	5f 	_ 
	ld a,d			;1fb5	7a 	z 
	sbc a,h			;1fb6	9c 	. 
	ld d,a			;1fb7	57 	W 
	pop hl			;1fb8	e1 	. 
	dec hl			;1fb9	2b 	+ 
	jp l1fa7h		;1fba	c3 a7 1f 	. . . 
l1fbdh:
	push hl			;1fbd	e5 	. 
	ld hl,(0f4f5h)		;1fbe	2a f5 f4 	* . . 
	add hl,de			;1fc1	19 	. 
	jp c,l1fd2h		;1fc2	da d2 1f 	. . . 
	ld a,c			;1fc5	79 	y 
	sub l			;1fc6	95 	. 
	ld a,b			;1fc7	78 	x 
	sbc a,h			;1fc8	9c 	. 
	jp c,l1fd2h		;1fc9	da d2 1f 	. . . 
	ex de,hl			;1fcc	eb 	. 
	pop hl			;1fcd	e1 	. 
	inc hl			;1fce	23 	# 
	jp l1fbdh		;1fcf	c3 bd 1f 	. . . 
l1fd2h:
	pop hl			;1fd2	e1 	. 
	push bc			;1fd3	c5 	. 
	push de			;1fd4	d5 	. 
	push hl			;1fd5	e5 	. 
	ex de,hl			;1fd6	eb 	. 
	ld hl,(0f502h)		;1fd7	2a 02 f5 	* . . 
	add hl,de			;1fda	19 	. 
	ld b,h			;1fdb	44 	D 
	ld c,l			;1fdc	4d 	M 
	call sub_2a57h		;1fdd	cd 57 2a 	. W * 
	pop de			;1fe0	d1 	. 
	ld hl,(0f4e9h)		;1fe1	2a e9 f4 	* . . 
	ld (hl),e			;1fe4	73 	s 
	inc hl			;1fe5	23 	# 
	ld (hl),d			;1fe6	72 	r 
	pop de			;1fe7	d1 	. 
	ld hl,(0f4ebh)		;1fe8	2a eb f4 	* . . 
	ld (hl),e			;1feb	73 	s 
	inc hl			;1fec	23 	# 
	ld (hl),d			;1fed	72 	r 
	pop bc			;1fee	c1 	. 
	ld a,c			;1fef	79 	y 
	sub e			;1ff0	93 	. 
	ld c,a			;1ff1	4f 	O 
	ld a,b			;1ff2	78 	x 
	sbc a,d			;1ff3	9a 	. 
	ld b,a			;1ff4	47 	G 
	ld hl,(0f504h)		;1ff5	2a 04 f5 	* . . 
	ex de,hl			;1ff8	eb 	. 
	call sub_2a69h		;1ff9	cd 69 2a 	. i * 
	ld c,l			;1ffc	4d 	M 
	ld b,h			;1ffd	44 	D 
	jp l2a5ah		;1ffe	c3 5a 2a 	. Z * 
sub_2001h:
	ld hl,0f4f7h		;2001	21 f7 f4 	! . . 
	ld c,(hl)			;2004	4e 	N 
	ld a,(0f517h)		;2005	3a 17 f5 	: . . 
l2008h:
	or a			;2008	b7 	. 
	rra			;2009	1f 	. 
	dec c			;200a	0d 	. 
	jp nz,l2008h		;200b	c2 08 20 	. .   
	ld b,a			;200e	47 	G 
	ld a,008h		;200f	3e 08 	> . 
	sub (hl)			;2011	96 	. 
	ld c,a			;2012	4f 	O 
	ld a,(0f516h)		;2013	3a 16 f5 	: . . 
l2016h:
	dec c			;2016	0d 	. 
	jp z,l201fh		;2017	ca 1f 20 	. .   
	or a			;201a	b7 	. 
	rla			;201b	17 	. 
	jp l2016h		;201c	c3 16 20 	. .   
l201fh:
	add a,b			;201f	80 	. 
l2020h:
	ret			;2020	c9 	. 
sub_2021h:
	ld hl,(0f4e3h)		;2021	2a e3 f4 	* . . 
	ld de,l000fh+1		;2024	11 10 00 	. . . 
	add hl,de			;2027	19 	. 
	add hl,bc			;2028	09 	. 
	ld a,(0f511h)		;2029	3a 11 f5 	: . . 
	or a			;202c	b7 	. 
	jp z,l2034h		;202d	ca 34 20 	. 4   
	ld l,(hl)			;2030	6e 	n 
	ld h,000h		;2031	26 00 	& . 
	ret			;2033	c9 	. 
l2034h:
	add hl,bc			;2034	09 	. 
	ld e,(hl)			;2035	5e 	^ 
	inc hl			;2036	23 	# 
	ld d,(hl)			;2037	56 	V 
	ex de,hl			;2038	eb 	. 
	ret			;2039	c9 	. 
sub_203ah:
	call sub_2001h		;203a	cd 01 20 	. .   
	ld c,a			;203d	4f 	O 
	ld b,000h		;203e	06 00 	. . 
	call sub_2021h		;2040	cd 21 20 	. !   
	ld (0f519h),hl		;2043	22 19 f5 	" . . 
	ret			;2046	c9 	. 
sub_2047h:
	ld hl,(0f519h)		;2047	2a 19 f5 	* . . 
	ld a,l			;204a	7d 	} 
	or h			;204b	b4 	. 
	ret			;204c	c9 	. 
sub_204dh:
	ld a,(0f4f7h)		;204d	3a f7 f4 	: . . 
	ld hl,(0f519h)		;2050	2a 19 f5 	* . . 
l2053h:
	add hl,hl			;2053	29 	) 
	dec a			;2054	3d 	= 
	jp nz,l2053h		;2055	c2 53 20 	. S   
	ld (0f51bh),hl		;2058	22 1b f5 	" . . 
	ld a,(0f4f8h)		;205b	3a f8 f4 	: . . 
	ld c,a			;205e	4f 	O 
	ld a,(0f517h)		;205f	3a 17 f5 	: . . 
	and c			;2062	a1 	. 
	or l			;2063	b5 	. 
	ld l,a			;2064	6f 	o 
	ld (0f519h),hl		;2065	22 19 f5 	" . . 
	ret			;2068	c9 	. 
sub_2069h:
	ld hl,(0f4e3h)		;2069	2a e3 f4 	* . . 
	ld de,l000ch		;206c	11 0c 00 	. . . 
	add hl,de			;206f	19 	. 
	ret			;2070	c9 	. 
sub_2071h:
	ld hl,(0f4e3h)		;2071	2a e3 f4 	* . . 
	ld de,l000fh		;2074	11 0f 00 	. . . 
	add hl,de			;2077	19 	. 
	ex de,hl			;2078	eb 	. 
	ld hl,l000fh+2		;2079	21 11 00 	! . . 
	add hl,de			;207c	19 	. 
	ret			;207d	c9 	. 
sub_207eh:
	call sub_2071h		;207e	cd 71 20 	. q   
	ld a,(hl)			;2081	7e 	~ 
	ld (0f517h),a		;2082	32 17 f5 	2 . . 
	ex de,hl			;2085	eb 	. 
	ld a,(hl)			;2086	7e 	~ 
	ld (0f515h),a		;2087	32 15 f5 	2 . . 
	call sub_2069h		;208a	cd 69 20 	. i   
	ld a,(0f4f9h)		;208d	3a f9 f4 	: . . 
	and (hl)			;2090	a6 	. 
	ld (0f516h),a		;2091	32 16 f5 	2 . . 
	ret			;2094	c9 	. 
l2095h:
	call sub_2071h		;2095	cd 71 20 	. q   
	ld a,(0f509h)		;2098	3a 09 f5 	: . . 
	cp 002h		;209b	fe 02 	. . 
	jp nz,l20a1h		;209d	c2 a1 20 	. .   
	xor a			;20a0	af 	. 
l20a1h:
	ld c,a			;20a1	4f 	O 
	ld a,(0f517h)		;20a2	3a 17 f5 	: . . 
	add a,c			;20a5	81 	. 
	ld (hl),a			;20a6	77 	w 
	ex de,hl			;20a7	eb 	. 
	ld a,(0f515h)		;20a8	3a 15 f5 	: . . 
	ld (hl),a			;20ab	77 	w 
	ret			;20ac	c9 	. 
sub_20adh:
	inc c			;20ad	0c 	. 
l20aeh:
	dec c			;20ae	0d 	. 
	ret z			;20af	c8 	. 
	ld a,h			;20b0	7c 	| 
	or a			;20b1	b7 	. 
	rra			;20b2	1f 	. 
	ld h,a			;20b3	67 	g 
	ld a,l			;20b4	7d 	} 
	rra			;20b5	1f 	. 
	ld l,a			;20b6	6f 	o 
	jp l20aeh		;20b7	c3 ae 20 	. .   
sub_20bah:
	ld c,080h		;20ba	0e 80 	. . 
	ld hl,(0f4edh)		;20bc	2a ed f4 	* . . 
	xor a			;20bf	af 	. 
l20c0h:
	add a,(hl)			;20c0	86 	. 
	inc hl			;20c1	23 	# 
	dec c			;20c2	0d 	. 
	jp nz,l20c0h		;20c3	c2 c0 20 	. .   
	ret			;20c6	c9 	. 
sub_20c7h:
	inc c			;20c7	0c 	. 
l20c8h:
	dec c			;20c8	0d 	. 
	ret z			;20c9	c8 	. 
	add hl,hl			;20ca	29 	) 
	jp l20c8h		;20cb	c3 c8 20 	. .   
sub_20ceh:
	push bc			;20ce	c5 	. 
	ld a,(0f31dh)		;20cf	3a 1d f3 	: . . 
	ld c,a			;20d2	4f 	O 
	ld hl,l0001h		;20d3	21 01 00 	! . . 
	call sub_20c7h		;20d6	cd c7 20 	. .   
	pop bc			;20d9	c1 	. 
	ld a,c			;20da	79 	y 
	or l			;20db	b5 	. 
	ld l,a			;20dc	6f 	o 
	ld a,b			;20dd	78 	x 
	or h			;20de	b4 	. 
	ld h,a			;20df	67 	g 
	ret			;20e0	c9 	. 
sub_20e1h:
	ld hl,(0f31fh)		;20e1	2a 1f f3 	* . . 
	ld a,(0f31dh)		;20e4	3a 1d f3 	: . . 
	ld c,a			;20e7	4f 	O 
	call sub_20adh		;20e8	cd ad 20 	. .   
	ld a,l			;20eb	7d 	} 
	and 001h		;20ec	e6 01 	. . 
	ret			;20ee	c9 	. 
sub_20efh:
	ld hl,0f31fh		;20ef	21 1f f3 	! . . 
	ld c,(hl)			;20f2	4e 	N 
	inc hl			;20f3	23 	# 
	ld b,(hl)			;20f4	46 	F 
	call sub_20ceh		;20f5	cd ce 20 	. .   
	ld (0f31fh),hl		;20f8	22 1f f3 	" . . 
	ld hl,(0f4fch)		;20fb	2a fc f4 	* . . 
	inc hl			;20fe	23 	# 
	ex de,hl			;20ff	eb 	. 
	ld hl,(0f4e7h)		;2100	2a e7 f4 	* . . 
	ld (hl),e			;2103	73 	s 
	inc hl			;2104	23 	# 
	ld (hl),d			;2105	72 	r 
	ret			;2106	c9 	. 
sub_2107h:
	call sub_2121h		;2107	cd 21 21 	. ! ! 
sub_210ah:
	ld de,l0009h		;210a	11 09 00 	. . . 
	add hl,de			;210d	19 	. 
	ld a,(hl)			;210e	7e 	~ 
	rla			;210f	17 	. 
	ret nc			;2110	d0 	. 
	ld hl,01bd2h		;2111	21 d2 1b 	! . . 
	jp l1f0dh		;2114	c3 0d 1f 	. . . 
sub_2117h:
	call sub_20e1h		;2117	cd e1 20 	. .   
	ret z			;211a	c8 	. 
	ld hl,01bd0h		;211b	21 d0 1b 	! . . 
	jp l1f0dh		;211e	c3 0d 1f 	. . . 
sub_2121h:
	ld hl,(0f4edh)		;2121	2a ed f4 	* . . 
	ld a,(0f51dh)		;2124	3a 1d f5 	: . . 
sub_2127h:
	add a,l			;2127	85 	. 
	ld l,a			;2128	6f 	o 
	ret nc			;2129	d0 	. 
	inc h			;212a	24 	$ 
	ret			;212b	c9 	. 
sub_212ch:
	ld hl,(0f4e3h)		;212c	2a e3 f4 	* . . 
	ld de,l000ch+2		;212f	11 0e 00 	. . . 
	add hl,de			;2132	19 	. 
	ld a,(hl)			;2133	7e 	~ 
	ret			;2134	c9 	. 
sub_2135h:
	call sub_212ch		;2135	cd 2c 21 	. , ! 
	ld (hl),000h		;2138	36 00 	6 . 
	ret			;213a	c9 	. 
sub_213bh:
	call sub_212ch		;213b	cd 2c 21 	. , ! 
	or 080h		;213e	f6 80 	. . 
	ld (hl),a			;2140	77 	w 
	ret			;2141	c9 	. 
sub_2142h:
	ld hl,(0f51eh)		;2142	2a 1e f5 	* . . 
	ex de,hl			;2145	eb 	. 
	ld hl,(0f4e7h)		;2146	2a e7 f4 	* . . 
	ld a,e			;2149	7b 	{ 
	sub (hl)			;214a	96 	. 
	inc hl			;214b	23 	# 
	ld a,d			;214c	7a 	z 
	sbc a,(hl)			;214d	9e 	. 
	ret			;214e	c9 	. 
sub_214fh:
	call sub_2142h		;214f	cd 42 21 	. B ! 
	ret c			;2152	d8 	. 
	inc de			;2153	13 	. 
	ld (hl),d			;2154	72 	r 
	dec hl			;2155	2b 	+ 
	ld (hl),e			;2156	73 	s 
	ret			;2157	c9 	. 
sub_2158h:
	ld a,e			;2158	7b 	{ 
	sub l			;2159	95 	. 
	ld l,a			;215a	6f 	o 
	ld a,d			;215b	7a 	z 
	sbc a,h			;215c	9c 	. 
	ld h,a			;215d	67 	g 
	ret			;215e	c9 	. 
sub_215fh:
	ld c,0ffh		;215f	0e ff 	. . 
l2161h:
	ld hl,(0f520h)		;2161	2a 20 f5 	*   . 
	ex de,hl			;2164	eb 	. 
	ld hl,(0f500h)		;2165	2a 00 f5 	* . . 
	call sub_2158h		;2168	cd 58 21 	. X ! 
	ret nc			;216b	d0 	. 
	push bc			;216c	c5 	. 
	call sub_20bah		;216d	cd ba 20 	. .   
	ld hl,(0f4f1h)		;2170	2a f1 f4 	* . . 
	ex de,hl			;2173	eb 	. 
	ld hl,(0f520h)		;2174	2a 20 f5 	*   . 
	add hl,de			;2177	19 	. 
	pop bc			;2178	c1 	. 
	inc c			;2179	0c 	. 
	jp z,l2187h		;217a	ca 87 21 	. . ! 
	cp (hl)			;217d	be 	. 
	ret z			;217e	c8 	. 
	call sub_2142h		;217f	cd 42 21 	. B ! 
	ret nc			;2182	d0 	. 
	call sub_20efh		;2183	cd ef 20 	. .   
	ret			;2186	c9 	. 
l2187h:
	ld (hl),a			;2187	77 	w 
	ret			;2188	c9 	. 
sub_2189h:
	call sub_215fh		;2189	cd 5f 21 	. _ ! 
	call sub_21a3h		;218c	cd a3 21 	. . ! 
	ld c,001h		;218f	0e 01 	. . 
	call sub_1f7bh		;2191	cd 7b 1f 	. { . 
	jp l219dh		;2194	c3 9d 21 	. . ! 
sub_2197h:
	call sub_21a3h		;2197	cd a3 21 	. . ! 
	call sub_1f75h		;219a	cd 75 1f 	. u . 
l219dh:
	ld hl,0f323h		;219d	21 23 f3 	! # . 
	jp l21a6h		;21a0	c3 a6 21 	. . ! 
sub_21a3h:
	ld hl,0f4edh		;21a3	21 ed f4 	! . . 
l21a6h:
	ld c,(hl)			;21a6	4e 	N 
	inc hl			;21a7	23 	# 
	ld b,(hl)			;21a8	46 	F 
	jp l2a5dh		;21a9	c3 5d 2a 	. ] * 
l21ach:
	ld hl,(0f4edh)		;21ac	2a ed f4 	* . . 
	ex de,hl			;21af	eb 	. 
	ld hl,(0f323h)		;21b0	2a 23 f3 	* # . 
	ld c,080h		;21b3	0e 80 	. . 
	jp sub_1f12h		;21b5	c3 12 1f 	. . . 
sub_21b8h:
	ld hl,0f51eh		;21b8	21 1e f5 	! . . 
	ld a,(hl)			;21bb	7e 	~ 
	inc hl			;21bc	23 	# 
	cp (hl)			;21bd	be 	. 
	ret nz			;21be	c0 	. 
	inc a			;21bf	3c 	< 
	ret			;21c0	c9 	. 
l21c1h:
	ld hl,0ffffh		;21c1	21 ff ff 	! . . 
	ld (0f51eh),hl		;21c4	22 1e f5 	" . . 
	ret			;21c7	c9 	. 
sub_21c8h:
	ld hl,(0f4fch)		;21c8	2a fc f4 	* . . 
	ex de,hl			;21cb	eb 	. 
	ld hl,(0f51eh)		;21cc	2a 1e f5 	* . . 
	inc hl			;21cf	23 	# 
	ld (0f51eh),hl		;21d0	22 1e f5 	" . . 
	call sub_2158h		;21d3	cd 58 21 	. X ! 
	jp nc,l21dch		;21d6	d2 dc 21 	. . ! 
	jp l21c1h		;21d9	c3 c1 21 	. . ! 
l21dch:
	ld a,(0f51eh)		;21dc	3a 1e f5 	: . . 
	and 003h		;21df	e6 03 	. . 
	ld b,005h		;21e1	06 05 	. . 
l21e3h:
	add a,a			;21e3	87 	. 
	dec b			;21e4	05 	. 
	jp nz,l21e3h		;21e5	c2 e3 21 	. . ! 
	ld (0f51dh),a		;21e8	32 1d f5 	2 . . 
	or a			;21eb	b7 	. 
	ret nz			;21ec	c0 	. 
	push bc			;21ed	c5 	. 
	call sub_1f86h		;21ee	cd 86 1f 	. . . 
	call sub_2197h		;21f1	cd 97 21 	. . ! 
	pop bc			;21f4	c1 	. 
	jp l2161h		;21f5	c3 61 21 	. a ! 
sub_21f8h:
	ld a,c			;21f8	79 	y 
	and 007h		;21f9	e6 07 	. . 
	inc a			;21fb	3c 	< 
	ld e,a			;21fc	5f 	_ 
	ld d,a			;21fd	57 	W 
	ld a,c			;21fe	79 	y 
sub_21ffh:
	rrca			;21ff	0f 	. 
l2200h:
	rrca			;2200	0f 	. 
	rrca			;2201	0f 	. 
l2202h:
	and 01fh		;2202	e6 1f 	. . 
	ld c,a			;2204	4f 	O 
	ld a,b			;2205	78 	x 
	add a,a			;2206	87 	. 
	add a,a			;2207	87 	. 
	add a,a			;2208	87 	. 
	add a,a			;2209	87 	. 
l220ah:
	add a,a			;220a	87 	. 
	or c			;220b	b1 	. 
	ld c,a			;220c	4f 	O 
	ld a,b			;220d	78 	x 
	rrca			;220e	0f 	. 
	rrca			;220f	0f 	. 
	rrca			;2210	0f 	. 
	and 01fh		;2211	e6 1f 	. . 
	ld b,a			;2213	47 	G 
	ld hl,(0f4f3h)		;2214	2a f3 f4 	* . . 
	add hl,bc			;2217	09 	. 
	ld a,(hl)			;2218	7e 	~ 
l2219h:
	rlca			;2219	07 	. 
	dec e			;221a	1d 	. 
	jp nz,l2219h		;221b	c2 19 22 	. . " 
	ret			;221e	c9 	. 
sub_221fh:
	push de			;221f	d5 	. 
	call sub_21f8h		;2220	cd f8 21 	. . ! 
	and 0feh		;2223	e6 fe 	. . 
	pop bc			;2225	c1 	. 
	or c			;2226	b1 	. 
l2227h:
	rrca			;2227	0f 	. 
	dec d			;2228	15 	. 
	jp nz,l2227h		;2229	c2 27 22 	. ' " 
	ld (hl),a			;222c	77 	w 
	ret			;222d	c9 	. 
sub_222eh:
	call sub_2121h		;222e	cd 21 21 	. ! ! 
l2231h:
	ld de,l000fh+1		;2231	11 10 00 	. . . 
	add hl,de			;2234	19 	. 
	push bc			;2235	c5 	. 
	ld c,011h		;2236	0e 11 	. . 
l2238h:
	pop de			;2238	d1 	. 
	dec c			;2239	0d 	. 
	ret z			;223a	c8 	. 
	push de			;223b	d5 	. 
	ld a,(0f511h)		;223c	3a 11 f5 	: . . 
	or a			;223f	b7 	. 
	jp z,l224bh		;2240	ca 4b 22 	. K " 
	push bc			;2243	c5 	. 
	push hl			;2244	e5 	. 
	ld c,(hl)			;2245	4e 	N 
	ld b,000h		;2246	06 00 	. . 
	jp l2251h		;2248	c3 51 22 	. Q " 
l224bh:
	dec c			;224b	0d 	. 
	push bc			;224c	c5 	. 
	ld c,(hl)			;224d	4e 	N 
	inc hl			;224e	23 	# 
	ld b,(hl)			;224f	46 	F 
	push hl			;2250	e5 	. 
l2251h:
	ld a,c			;2251	79 	y 
	or b			;2252	b0 	. 
	jp z,l2260h		;2253	ca 60 22 	. ` " 
	ld hl,(0f4fah)		;2256	2a fa f4 	* . . 
	ld a,l			;2259	7d 	} 
	sub c			;225a	91 	. 
	ld a,h			;225b	7c 	| 
	sbc a,b			;225c	98 	. 
	call nc,sub_221fh		;225d	d4 1f 22 	. . " 
l2260h:
	pop hl			;2260	e1 	. 
	inc hl			;2261	23 	# 
	pop bc			;2262	c1 	. 
	jp l2238h		;2263	c3 38 22 	. 8 " 
l2266h:
	ld hl,(0f4fah)		;2266	2a fa f4 	* . . 
	ld c,003h		;2269	0e 03 	. . 
	call sub_20adh		;226b	cd ad 20 	. .   
	inc hl			;226e	23 	# 
	ld b,h			;226f	44 	D 
	ld c,l			;2270	4d 	M 
	ld hl,(0f4f3h)		;2271	2a f3 f4 	* . . 
l2274h:
	ld (hl),000h		;2274	36 00 	6 . 
	inc hl			;2276	23 	# 
	dec bc			;2277	0b 	. 
	ld a,b			;2278	78 	x 
	or c			;2279	b1 	. 
	jp nz,l2274h		;227a	c2 74 22 	. t " 
	ld hl,(0f4feh)		;227d	2a fe f4 	* . . 
	ex de,hl			;2280	eb 	. 
	ld hl,(0f4f3h)		;2281	2a f3 f4 	* . . 
	ld (hl),e			;2284	73 	s 
	inc hl			;2285	23 	# 
	ld (hl),d			;2286	72 	r 
	call sub_1f64h		;2287	cd 64 1f 	. d . 
	ld hl,(0f4e7h)		;228a	2a e7 f4 	* . . 
	ld (hl),003h		;228d	36 03 	6 . 
	inc hl			;228f	23 	# 
	ld (hl),000h		;2290	36 00 	6 . 
	call l21c1h		;2292	cd c1 21 	. . ! 
l2295h:
	ld c,0ffh		;2295	0e ff 	. . 
	call sub_21c8h		;2297	cd c8 21 	. . ! 
	call sub_21b8h		;229a	cd b8 21 	. . ! 
	ret z			;229d	c8 	. 
	call sub_2121h		;229e	cd 21 21 	. ! ! 
	ld a,0e5h		;22a1	3e e5 	> . 
	cp (hl)			;22a3	be 	. 
	jp z,l2295h		;22a4	ca 95 22 	. . " 
	ld a,(0f31ch)		;22a7	3a 1c f3 	: . . 
	cp (hl)			;22aa	be 	. 
	jp nz,l22b9h		;22ab	c2 b9 22 	. . " 
	inc hl			;22ae	23 	# 
	ld a,(hl)			;22af	7e 	~ 
	sub 024h		;22b0	d6 24 	. $ 
	jp nz,l22b9h		;22b2	c2 b9 22 	. . " 
	dec a			;22b5	3d 	= 
	ld (0f4e5h),a		;22b6	32 e5 f4 	2 . . 
l22b9h:
	ld c,001h		;22b9	0e 01 	. . 
	call sub_222eh		;22bb	cd 2e 22 	. . " 
	call sub_214fh		;22be	cd 4f 21 	. O ! 
	jp l2295h		;22c1	c3 95 22 	. . " 
l22c4h:
	ld a,(0f508h)		;22c4	3a 08 f5 	: . . 
	jp l1ec4h		;22c7	c3 c4 1e 	. . . 
sub_22cah:
	push bc			;22ca	c5 	. 
	push af			;22cb	f5 	. 
	ld a,(0f4f9h)		;22cc	3a f9 f4 	: . . 
	cpl			;22cf	2f 	/ 
	ld b,a			;22d0	47 	G 
	ld a,c			;22d1	79 	y 
	and b			;22d2	a0 	. 
	ld c,a			;22d3	4f 	O 
	pop af			;22d4	f1 	. 
	and b			;22d5	a0 	. 
	sub c			;22d6	91 	. 
	and 01fh		;22d7	e6 1f 	. . 
	pop bc			;22d9	c1 	. 
	ret			;22da	c9 	. 
sub_22dbh:
	ld a,0ffh		;22db	3e ff 	> . 
	ld (0f508h),a		;22dd	32 08 f5 	2 . . 
	ld hl,0f50ch		;22e0	21 0c f5 	! . . 
	ld (hl),c			;22e3	71 	q 
	ld hl,(0f4e3h)		;22e4	2a e3 f4 	* . . 
	ld (0f50dh),hl		;22e7	22 0d f5 	" . . 
	call l21c1h		;22ea	cd c1 21 	. . ! 
	call sub_1f64h		;22ed	cd 64 1f 	. d . 
l22f0h:
	ld c,000h		;22f0	0e 00 	. . 
	call sub_21c8h		;22f2	cd c8 21 	. . ! 
	call sub_21b8h		;22f5	cd b8 21 	. . ! 
	jp z,l2357h		;22f8	ca 57 23 	. W # 
	ld hl,(0f50dh)		;22fb	2a 0d f5 	* . . 
	ex de,hl			;22fe	eb 	. 
	ld a,(de)			;22ff	1a 	. 
	cp 0e5h		;2300	fe e5 	. . 
	jp z,l230dh		;2302	ca 0d 23 	. . # 
l2305h:
	push de			;2305	d5 	. 
	call sub_2142h		;2306	cd 42 21 	. B ! 
	pop de			;2309	d1 	. 
	jp nc,l2357h		;230a	d2 57 23 	. W # 
l230dh:
	call sub_2121h		;230d	cd 21 21 	. ! ! 
	ld a,(0f50ch)		;2310	3a 0c f5 	: . . 
	ld c,a			;2313	4f 	O 
	ld b,000h		;2314	06 00 	. . 
l2316h:
	ld a,c			;2316	79 	y 
	or a			;2317	b7 	. 
	jp z,l2346h		;2318	ca 46 23 	. F # 
	ld a,(de)			;231b	1a 	. 
	cp 03fh		;231c	fe 3f 	. ? 
	jp z,l233fh		;231e	ca 3f 23 	. ? # 
	ld a,b			;2321	78 	x 
l2322h:
	cp 00dh		;2322	fe 0d 	. . 
	jp z,l233fh		;2324	ca 3f 23 	. ? # 
	cp 00ch		;2327	fe 0c 	. . 
	ld a,(de)			;2329	1a 	. 
	jp z,l2336h		;232a	ca 36 23 	. 6 # 
	sub (hl)			;232d	96 	. 
	and 07fh		;232e	e6 7f 	.  
	jp nz,l22f0h		;2330	c2 f0 22 	. . " 
	jp l233fh		;2333	c3 3f 23 	. ? # 
l2336h:
	push bc			;2336	c5 	. 
	ld c,(hl)			;2337	4e 	N 
	call sub_22cah		;2338	cd ca 22 	. . " 
	pop bc			;233b	c1 	. 
	jp nz,l22f0h		;233c	c2 f0 22 	. . " 
l233fh:
	inc de			;233f	13 	. 
	inc hl			;2340	23 	# 
	inc b			;2341	04 	. 
	dec c			;2342	0d 	. 
	jp l2316h		;2343	c3 16 23 	. . # 
l2346h:
	ld a,(0f51eh)		;2346	3a 1e f5 	: . . 
	and 003h		;2349	e6 03 	. . 
	ld (0f4e5h),a		;234b	32 e5 f4 	2 . . 
	ld hl,0f508h		;234e	21 08 f5 	! . . 
	ld a,(hl)			;2351	7e 	~ 
	rla			;2352	17 	. 
	ret nc			;2353	d0 	. 
	xor a			;2354	af 	. 
	ld (hl),a			;2355	77 	w 
	ret			;2356	c9 	. 
l2357h:
	call l21c1h		;2357	cd c1 21 	. . ! 
	ld a,0ffh		;235a	3e ff 	> . 
	jp l1ec4h		;235c	c3 c4 1e 	. . . 
sub_235fh:
	call sub_2117h		;235f	cd 17 21 	. . ! 
	ld c,00ch		;2362	0e 0c 	. . 
	call sub_22dbh		;2364	cd db 22 	. . " 
l2367h:
	call sub_21b8h		;2367	cd b8 21 	. . ! 
	ret z			;236a	c8 	. 
	call sub_2107h		;236b	cd 07 21 	. . ! 
	call sub_2121h		;236e	cd 21 21 	. ! ! 
	ld (hl),0e5h		;2371	36 e5 	6 . 
	ld c,000h		;2373	0e 00 	. . 
	call sub_222eh		;2375	cd 2e 22 	. . " 
	call sub_2189h		;2378	cd 89 21 	. . ! 
	call l22f0h		;237b	cd f0 22 	. . " 
	jp l2367h		;237e	c3 67 23 	. g # 
sub_2381h:
	ld d,b			;2381	50 	P 
	ld e,c			;2382	59 	Y 
l2383h:
	ld a,c			;2383	79 	y 
	or b			;2384	b0 	. 
	jp z,l2394h		;2385	ca 94 23 	. . # 
	dec bc			;2388	0b 	. 
	push de			;2389	d5 	. 
	push bc			;238a	c5 	. 
	call sub_21f8h		;238b	cd f8 21 	. . ! 
	rra			;238e	1f 	. 
	jp nc,l23afh		;238f	d2 af 23 	. . # 
	pop bc			;2392	c1 	. 
	pop de			;2393	d1 	. 
l2394h:
	ld hl,(0f4fah)		;2394	2a fa f4 	* . . 
	ld a,e			;2397	7b 	{ 
	sub l			;2398	95 	. 
	ld a,d			;2399	7a 	z 
	sbc a,h			;239a	9c 	. 
	jp nc,l23b7h		;239b	d2 b7 23 	. . # 
	inc de			;239e	13 	. 
	push bc			;239f	c5 	. 
	push de			;23a0	d5 	. 
	ld b,d			;23a1	42 	B 
	ld c,e			;23a2	4b 	K 
	call sub_21f8h		;23a3	cd f8 21 	. . ! 
	rra			;23a6	1f 	. 
	jp nc,l23afh		;23a7	d2 af 23 	. . # 
	pop de			;23aa	d1 	. 
	pop bc			;23ab	c1 	. 
	jp l2383h		;23ac	c3 83 23 	. . # 
l23afh:
	rla			;23af	17 	. 
	inc a			;23b0	3c 	< 
	call l2227h		;23b1	cd 27 22 	. ' " 
	pop hl			;23b4	e1 	. 
	pop de			;23b5	d1 	. 
	ret			;23b6	c9 	. 
l23b7h:
	ld a,c			;23b7	79 	y 
	or b			;23b8	b0 	. 
	jp nz,l2383h		;23b9	c2 83 23 	. . # 
	ld hl,COLDRST		;23bc	21 00 00 	! . . 
	ret			;23bf	c9 	. 
sub_23c0h:
	ld c,000h		;23c0	0e 00 	. . 
	ld e,020h		;23c2	1e 20 	.   
sub_23c4h:
	push de			;23c4	d5 	. 
	ld b,000h		;23c5	06 00 	. . 
	ld hl,(0f4e3h)		;23c7	2a e3 f4 	* . . 
	add hl,bc			;23ca	09 	. 
	ex de,hl			;23cb	eb 	. 
	call sub_2121h		;23cc	cd 21 21 	. ! ! 
	pop bc			;23cf	c1 	. 
	call sub_1f12h		;23d0	cd 12 1f 	. . . 
l23d3h:
	call sub_1f86h		;23d3	cd 86 1f 	. . . 
	jp sub_2189h		;23d6	c3 89 21 	. . ! 
sub_23d9h:
	call sub_2117h		;23d9	cd 17 21 	. . ! 
	ld c,00ch		;23dc	0e 0c 	. . 
	call sub_22dbh		;23de	cd db 22 	. . " 
	ld hl,(0f4e3h)		;23e1	2a e3 f4 	* . . 
	ld a,(hl)			;23e4	7e 	~ 
	ld de,l000fh+1		;23e5	11 10 00 	. . . 
	add hl,de			;23e8	19 	. 
	ld (hl),a			;23e9	77 	w 
l23eah:
	call sub_21b8h		;23ea	cd b8 21 	. . ! 
	ret z			;23ed	c8 	. 
	call sub_2107h		;23ee	cd 07 21 	. . ! 
	ld c,010h		;23f1	0e 10 	. . 
	ld e,00ch		;23f3	1e 0c 	. . 
	call sub_23c4h		;23f5	cd c4 23 	. . # 
	call l22f0h		;23f8	cd f0 22 	. . " 
	jp l23eah		;23fb	c3 ea 23 	. . # 
sub_23feh:
	ld c,00ch		;23fe	0e 0c 	. . 
	call sub_22dbh		;2400	cd db 22 	. . " 
l2403h:
	call sub_21b8h		;2403	cd b8 21 	. . ! 
	ret z			;2406	c8 	. 
	ld c,000h		;2407	0e 00 	. . 
	ld e,00ch		;2409	1e 0c 	. . 
	call sub_23c4h		;240b	cd c4 23 	. . # 
	call l22f0h		;240e	cd f0 22 	. . " 
	jp l2403h		;2411	c3 03 24 	. . $ 
sub_2414h:
	ld c,00fh		;2414	0e 0f 	. . 
	call sub_22dbh		;2416	cd db 22 	. . " 
	call sub_21b8h		;2419	cd b8 21 	. . ! 
	ret z			;241c	c8 	. 
sub_241dh:
	call sub_2069h		;241d	cd 69 20 	. i   
l2420h:
	ld a,(hl)			;2420	7e 	~ 
	push af			;2421	f5 	. 
l2422h:
	push hl			;2422	e5 	. 
	call sub_2121h		;2423	cd 21 21 	. ! ! 
	ex de,hl			;2426	eb 	. 
	ld hl,(0f4e3h)		;2427	2a e3 f4 	* . . 
	ld c,020h		;242a	0e 20 	.   
	push de			;242c	d5 	. 
	call sub_1f12h		;242d	cd 12 1f 	. . . 
	call sub_213bh		;2430	cd 3b 21 	. ; ! 
	pop de			;2433	d1 	. 
	ld hl,l000ch		;2434	21 0c 00 	! . . 
	add hl,de			;2437	19 	. 
	ld c,(hl)			;2438	4e 	N 
	ld hl,l000fh		;2439	21 0f 00 	! . . 
	add hl,de			;243c	19 	. 
	ld b,(hl)			;243d	46 	F 
	pop hl			;243e	e1 	. 
	pop af			;243f	f1 	. 
	ld (hl),a			;2440	77 	w 
	ld a,c			;2441	79 	y 
	cp (hl)			;2442	be 	. 
	ld a,b			;2443	78 	x 
	jp z,l244eh		;2444	ca 4e 24 	. N $ 
	ld a,000h		;2447	3e 00 	> . 
	jp c,l244eh		;2449	da 4e 24 	. N $ 
	ld a,080h		;244c	3e 80 	> . 
l244eh:
	ld hl,(0f4e3h)		;244e	2a e3 f4 	* . . 
	ld de,l000fh		;2451	11 0f 00 	. . . 
	add hl,de			;2454	19 	. 
	ld (hl),a			;2455	77 	w 
	ret			;2456	c9 	. 
sub_2457h:
	ld a,(hl)			;2457	7e 	~ 
	inc hl			;2458	23 	# 
	or (hl)			;2459	b6 	. 
	dec hl			;245a	2b 	+ 
	ret nz			;245b	c0 	. 
	ld a,(de)			;245c	1a 	. 
	ld (hl),a			;245d	77 	w 
	inc de			;245e	13 	. 
	inc hl			;245f	23 	# 
	ld a,(de)			;2460	1a 	. 
	ld (hl),a			;2461	77 	w 
	dec de			;2462	1b 	. 
	dec hl			;2463	2b 	+ 
	ret			;2464	c9 	. 
sub_2465h:
	xor a			;2465	af 	. 
	ld (0f4e5h),a		;2466	32 e5 f4 	2 . . 
	ld (0f51eh),a		;2469	32 1e f5 	2 . . 
	ld (0f51fh),a		;246c	32 1f f5 	2 . . 
	call sub_20e1h		;246f	cd e1 20 	. .   
	ret nz			;2472	c0 	. 
	call sub_212ch		;2473	cd 2c 21 	. , ! 
	and 080h		;2476	e6 80 	. . 
	ret nz			;2478	c0 	. 
	ld c,00fh		;2479	0e 0f 	. . 
	call sub_22dbh		;247b	cd db 22 	. . " 
	call sub_21b8h		;247e	cd b8 21 	. . ! 
	ret z			;2481	c8 	. 
	ld bc,l000fh+1		;2482	01 10 00 	. . . 
	call sub_2121h		;2485	cd 21 21 	. ! ! 
	add hl,bc			;2488	09 	. 
	ex de,hl			;2489	eb 	. 
	ld hl,(0f4e3h)		;248a	2a e3 f4 	* . . 
	add hl,bc			;248d	09 	. 
	ld c,010h		;248e	0e 10 	. . 
l2490h:
	ld a,(0f511h)		;2490	3a 11 f5 	: . . 
	or a			;2493	b7 	. 
	jp z,l24abh		;2494	ca ab 24 	. . $ 
	ld a,(hl)			;2497	7e 	~ 
	or a			;2498	b7 	. 
	ld a,(de)			;2499	1a 	. 
	jp nz,l249eh		;249a	c2 9e 24 	. . $ 
	ld (hl),a			;249d	77 	w 
l249eh:
	or a			;249e	b7 	. 
	jp nz,l24a4h		;249f	c2 a4 24 	. . $ 
	ld a,(hl)			;24a2	7e 	~ 
	ld (de),a			;24a3	12 	. 
l24a4h:
	cp (hl)			;24a4	be 	. 
	jp nz,l24e2h		;24a5	c2 e2 24 	. . $ 
	jp l24c0h		;24a8	c3 c0 24 	. . $ 
l24abh:
	call sub_2457h		;24ab	cd 57 24 	. W $ 
	ex de,hl			;24ae	eb 	. 
	call sub_2457h		;24af	cd 57 24 	. W $ 
	ex de,hl			;24b2	eb 	. 
	ld a,(de)			;24b3	1a 	. 
	cp (hl)			;24b4	be 	. 
	jp nz,l24e2h		;24b5	c2 e2 24 	. . $ 
	inc de			;24b8	13 	. 
	inc hl			;24b9	23 	# 
	ld a,(de)			;24ba	1a 	. 
	cp (hl)			;24bb	be 	. 
	jp nz,l24e2h		;24bc	c2 e2 24 	. . $ 
	dec c			;24bf	0d 	. 
l24c0h:
	inc de			;24c0	13 	. 
	inc hl			;24c1	23 	# 
	dec c			;24c2	0d 	. 
	jp nz,l2490h		;24c3	c2 90 24 	. . $ 
	ld bc,0ffech		;24c6	01 ec ff 	. . . 
	add hl,bc			;24c9	09 	. 
	ex de,hl			;24ca	eb 	. 
	add hl,bc			;24cb	09 	. 
	ld a,(de)			;24cc	1a 	. 
	cp (hl)			;24cd	be 	. 
	jp c,l24dah		;24ce	da da 24 	. . $ 
	ld (hl),a			;24d1	77 	w 
	ld bc,l0003h		;24d2	01 03 00 	. . . 
	add hl,bc			;24d5	09 	. 
	ex de,hl			;24d6	eb 	. 
	add hl,bc			;24d7	09 	. 
	ld a,(hl)			;24d8	7e 	~ 
	ld (de),a			;24d9	12 	. 
l24dah:
	ld a,0ffh		;24da	3e ff 	> . 
	ld (0f506h),a		;24dc	32 06 f5 	2 . . 
	jp l23d3h		;24df	c3 d3 23 	. . # 
l24e2h:
	ld hl,0f4e5h		;24e2	21 e5 f4 	! . . 
	dec (hl)			;24e5	35 	5 
	ret			;24e6	c9 	. 
sub_24e7h:
	call sub_2117h		;24e7	cd 17 21 	. . ! 
	ld hl,(0f4e3h)		;24ea	2a e3 f4 	* . . 
	push hl			;24ed	e5 	. 
	ld hl,0f31eh		;24ee	21 1e f3 	! . . 
	ld (0f4e3h),hl		;24f1	22 e3 f4 	" . . 
	ld c,001h		;24f4	0e 01 	. . 
	call sub_22dbh		;24f6	cd db 22 	. . " 
	call sub_21b8h		;24f9	cd b8 21 	. . ! 
	pop hl			;24fc	e1 	. 
	ld (0f4e3h),hl		;24fd	22 e3 f4 	" . . 
	ret z			;2500	c8 	. 
	ex de,hl			;2501	eb 	. 
	ld hl,l000fh		;2502	21 0f 00 	! . . 
	add hl,de			;2505	19 	. 
	ld c,011h		;2506	0e 11 	. . 
	xor a			;2508	af 	. 
l2509h:
	ld (hl),a			;2509	77 	w 
	inc hl			;250a	23 	# 
	dec c			;250b	0d 	. 
	jp nz,l2509h		;250c	c2 09 25 	. . % 
	ld hl,l000ch+1		;250f	21 0d 00 	! . . 
	add hl,de			;2512	19 	. 
	ld (hl),a			;2513	77 	w 
	call sub_214fh		;2514	cd 4f 21 	. O ! 
	call sub_23c0h		;2517	cd c0 23 	. . # 
	jp sub_213bh		;251a	c3 3b 21 	. ; ! 
sub_251dh:
	xor a			;251d	af 	. 
	ld (0f506h),a		;251e	32 06 f5 	2 . . 
	call sub_2465h		;2521	cd 65 24 	. e $ 
	call sub_21b8h		;2524	cd b8 21 	. . ! 
	ret z			;2527	c8 	. 
	ld hl,(0f4e3h)		;2528	2a e3 f4 	* . . 
	ld bc,l000ch		;252b	01 0c 00 	. . . 
	add hl,bc			;252e	09 	. 
	ld a,(hl)			;252f	7e 	~ 
	inc a			;2530	3c 	< 
	and 01fh		;2531	e6 1f 	. . 
	ld (hl),a			;2533	77 	w 
	jp z,l2546h		;2534	ca 46 25 	. F % 
	ld b,a			;2537	47 	G 
	ld a,(0f4f9h)		;2538	3a f9 f4 	: . . 
	and b			;253b	a0 	. 
	ld hl,0f506h		;253c	21 06 f5 	! . . 
	and (hl)			;253f	a6 	. 
	jp z,l2551h		;2540	ca 51 25 	. Q % 
	jp l256fh		;2543	c3 6f 25 	. o % 
l2546h:
	ld bc,l0001h+1		;2546	01 02 00 	. . . 
	add hl,bc			;2549	09 	. 
	inc (hl)			;254a	34 	4 
	ld a,(hl)			;254b	7e 	~ 
	and 00fh		;254c	e6 0f 	. . 
	jp z,l2579h		;254e	ca 79 25 	. y % 
l2551h:
	ld c,00fh		;2551	0e 0f 	. . 
	call sub_22dbh		;2553	cd db 22 	. . " 
	call sub_21b8h		;2556	cd b8 21 	. . ! 
	jp nz,l256fh		;2559	c2 6f 25 	. o % 
	ld a,(0f507h)		;255c	3a 07 f5 	: . . 
	inc a			;255f	3c 	< 
	jp z,l2579h		;2560	ca 79 25 	. y % 
	call sub_24e7h		;2563	cd e7 24 	. . $ 
	call sub_21b8h		;2566	cd b8 21 	. . ! 
	jp z,l2579h		;2569	ca 79 25 	. y % 
	jp l2572h		;256c	c3 72 25 	. r % 
l256fh:
	call sub_241dh		;256f	cd 1d 24 	. . $ 
l2572h:
	call sub_207eh		;2572	cd 7e 20 	. ~   
	xor a			;2575	af 	. 
	jp l1ec4h		;2576	c3 c4 1e 	. . . 
l2579h:
	call sub_1ec8h		;2579	cd c8 1e 	. . . 
	jp sub_213bh		;257c	c3 3b 21 	. ; ! 
l257fh:
	ld a,001h		;257f	3e 01 	> . 
	ld (0f509h),a		;2581	32 09 f5 	2 . . 
sub_2584h:
	ld a,0ffh		;2584	3e ff 	> . 
	ld (0f507h),a		;2586	32 07 f5 	2 . . 
	call sub_207eh		;2589	cd 7e 20 	. ~   
	ld a,(0f517h)		;258c	3a 17 f5 	: . . 
	ld hl,0f515h		;258f	21 15 f5 	! . . 
	cp (hl)			;2592	be 	. 
	jp c,l25a9h		;2593	da a9 25 	. . % 
	cp 080h		;2596	fe 80 	. . 
	jp nz,l25beh		;2598	c2 be 25 	. . % 
	call sub_251dh		;259b	cd 1d 25 	. . % 
	xor a			;259e	af 	. 
	ld (0f517h),a		;259f	32 17 f5 	2 . . 
	ld a,(0f4e5h)		;25a2	3a e5 f4 	: . . 
	or a			;25a5	b7 	. 
	jp nz,l25beh		;25a6	c2 be 25 	. . % 
l25a9h:
	call sub_203ah		;25a9	cd 3a 20 	. :   
	call sub_2047h		;25ac	cd 47 20 	. G   
	jp z,l25beh		;25af	ca be 25 	. . % 
	call sub_204dh		;25b2	cd 4d 20 	. M   
	call sub_1f94h		;25b5	cd 94 1f 	. . . 
	call sub_1f75h		;25b8	cd 75 1f 	. u . 
	jp l2095h		;25bb	c3 95 20 	. .   
l25beh:
	jp sub_1ec8h		;25be	c3 c8 1e 	. . . 
l25c1h:
	ld a,001h		;25c1	3e 01 	> . 
	ld (0f509h),a		;25c3	32 09 f5 	2 . . 
sub_25c6h:
	ld a,000h		;25c6	3e 00 	> . 
	ld (0f507h),a		;25c8	32 07 f5 	2 . . 
	call sub_2117h		;25cb	cd 17 21 	. . ! 
	ld hl,(0f4e3h)		;25ce	2a e3 f4 	* . . 
	call sub_210ah		;25d1	cd 0a 21 	. . ! 
	call sub_207eh		;25d4	cd 7e 20 	. ~   
	ld a,(0f517h)		;25d7	3a 17 f5 	: . . 
	cp 080h		;25da	fe 80 	. . 
	jp nc,sub_1ec8h		;25dc	d2 c8 1e 	. . . 
	call sub_203ah		;25df	cd 3a 20 	. :   
	call sub_2047h		;25e2	cd 47 20 	. G   
	ld c,000h		;25e5	0e 00 	. . 
	jp nz,l2631h		;25e7	c2 31 26 	. 1 & 
	call sub_2001h		;25ea	cd 01 20 	. .   
	ld (0f50bh),a		;25ed	32 0b f5 	2 . . 
	ld bc,COLDRST		;25f0	01 00 00 	. . . 
	or a			;25f3	b7 	. 
	jp z,l25feh		;25f4	ca fe 25 	. . % 
	ld c,a			;25f7	4f 	O 
	dec bc			;25f8	0b 	. 
	call sub_2021h		;25f9	cd 21 20 	. !   
	ld b,h			;25fc	44 	D 
	ld c,l			;25fd	4d 	M 
l25feh:
	call sub_2381h		;25fe	cd 81 23 	. . # 
	ld a,l			;2601	7d 	} 
	or h			;2602	b4 	. 
	jp nz,l260bh		;2603	c2 0b 26 	. . & 
	ld a,002h		;2606	3e 02 	> . 
	jp l1ec4h		;2608	c3 c4 1e 	. . . 
l260bh:
	ld (0f519h),hl		;260b	22 19 f5 	" . . 
	ex de,hl			;260e	eb 	. 
	ld hl,(0f4e3h)		;260f	2a e3 f4 	* . . 
	ld bc,l000fh+1		;2612	01 10 00 	. . . 
	add hl,bc			;2615	09 	. 
	ld a,(0f511h)		;2616	3a 11 f5 	: . . 
	or a			;2619	b7 	. 
	ld a,(0f50bh)		;261a	3a 0b f5 	: . . 
	jp z,l2627h		;261d	ca 27 26 	. ' & 
	call sub_2127h		;2620	cd 27 21 	. ' ! 
	ld (hl),e			;2623	73 	s 
	jp l262fh		;2624	c3 2f 26 	. / & 
l2627h:
	ld c,a			;2627	4f 	O 
	ld b,000h		;2628	06 00 	. . 
l262ah:
	add hl,bc			;262a	09 	. 
	add hl,bc			;262b	09 	. 
	ld (hl),e			;262c	73 	s 
	inc hl			;262d	23 	# 
	ld (hl),d			;262e	72 	r 
l262fh:
	ld c,002h		;262f	0e 02 	. . 
l2631h:
	ld a,(0f4e5h)		;2631	3a e5 f4 	: . . 
	or a			;2634	b7 	. 
	ret nz			;2635	c0 	. 
	push bc			;2636	c5 	. 
	call sub_204dh		;2637	cd 4d 20 	. M   
	ld a,(0f509h)		;263a	3a 09 f5 	: . . 
	dec a			;263d	3d 	= 
	dec a			;263e	3d 	= 
	jp nz,l267eh		;263f	c2 7e 26 	. ~ & 
	pop bc			;2642	c1 	. 
	push bc			;2643	c5 	. 
	ld a,c			;2644	79 	y 
	dec a			;2645	3d 	= 
	dec a			;2646	3d 	= 
	jp nz,l267eh		;2647	c2 7e 26 	. ~ & 
	push hl			;264a	e5 	. 
	ld hl,(0f4edh)		;264b	2a ed f4 	* . . 
	ld d,a			;264e	57 	W 
l264fh:
	ld (hl),a			;264f	77 	w 
	inc hl			;2650	23 	# 
	inc d			;2651	14 	. 
	jp p,l264fh		;2652	f2 4f 26 	. O & 
	call sub_21a3h		;2655	cd a3 21 	. . ! 
	ld hl,(0f51bh)		;2658	2a 1b f5 	* . . 
	ld c,002h		;265b	0e 02 	. . 
l265dh:
	ld (0f519h),hl		;265d	22 19 f5 	" . . 
	push bc			;2660	c5 	. 
	call sub_1f94h		;2661	cd 94 1f 	. . . 
	pop bc			;2664	c1 	. 
	call sub_1f7bh		;2665	cd 7b 1f 	. { . 
	ld hl,(0f519h)		;2668	2a 19 f5 	* . . 
	ld c,000h		;266b	0e 00 	. . 
	ld a,(0f4f8h)		;266d	3a f8 f4 	: . . 
	ld b,a			;2670	47 	G 
	and l			;2671	a5 	. 
	cp b			;2672	b8 	. 
	inc hl			;2673	23 	# 
	jp nz,l265dh		;2674	c2 5d 26 	. ] & 
	pop hl			;2677	e1 	. 
	ld (0f519h),hl		;2678	22 19 f5 	" . . 
	call l219dh		;267b	cd 9d 21 	. . ! 
l267eh:
	call sub_1f94h		;267e	cd 94 1f 	. . . 
	pop bc			;2681	c1 	. 
	push bc			;2682	c5 	. 
	call sub_1f7bh		;2683	cd 7b 1f 	. { . 
	pop bc			;2686	c1 	. 
	ld a,(0f517h)		;2687	3a 17 f5 	: . . 
	ld hl,0f515h		;268a	21 15 f5 	! . . 
	cp (hl)			;268d	be 	. 
	jp c,l2695h		;268e	da 95 26 	. . & 
	ld (hl),a			;2691	77 	w 
	inc (hl)			;2692	34 	4 
	ld c,002h		;2693	0e 02 	. . 
l2695h:
	nop			;2695	00 	. 
	nop			;2696	00 	. 
	ld hl,COLDRST		;2697	21 00 00 	! . . 
	push af			;269a	f5 	. 
	call sub_212ch		;269b	cd 2c 21 	. , ! 
	and 07fh		;269e	e6 7f 	.  
	ld (hl),a			;26a0	77 	w 
	pop af			;26a1	f1 	. 
	cp 07fh		;26a2	fe 7f 	.  
	jp nz,l26c3h		;26a4	c2 c3 26 	. . & 
	ld a,(0f509h)		;26a7	3a 09 f5 	: . . 
	cp 001h		;26aa	fe 01 	. . 
	jp nz,l26c3h		;26ac	c2 c3 26 	. . & 
	call l2095h		;26af	cd 95 20 	. .   
	call sub_251dh		;26b2	cd 1d 25 	. . % 
	ld hl,0f4e5h		;26b5	21 e5 f4 	! . . 
	ld a,(hl)			;26b8	7e 	~ 
	or a			;26b9	b7 	. 
	jp nz,l26c1h		;26ba	c2 c1 26 	. . & 
	dec a			;26bd	3d 	= 
	ld (0f517h),a		;26be	32 17 f5 	2 . . 
l26c1h:
	ld (hl),000h		;26c1	36 00 	6 . 
l26c3h:
	jp l2095h		;26c3	c3 95 20 	. .   
sub_26c6h:
	xor a			;26c6	af 	. 
	ld (0f509h),a		;26c7	32 09 f5 	2 . . 
sub_26cah:
	push bc			;26ca	c5 	. 
	ld hl,(0f4e3h)		;26cb	2a e3 f4 	* . . 
	ex de,hl			;26ce	eb 	. 
	ld hl,l0021h		;26cf	21 21 00 	! ! . 
	add hl,de			;26d2	19 	. 
	ld a,(hl)			;26d3	7e 	~ 
	and 07fh		;26d4	e6 7f 	.  
	push af			;26d6	f5 	. 
	ld a,(hl)			;26d7	7e 	~ 
	rla			;26d8	17 	. 
	inc hl			;26d9	23 	# 
	ld a,(hl)			;26da	7e 	~ 
	rla			;26db	17 	. 
	and 01fh		;26dc	e6 1f 	. . 
	ld c,a			;26de	4f 	O 
	ld a,(hl)			;26df	7e 	~ 
	rra			;26e0	1f 	. 
	rra			;26e1	1f 	. 
	rra			;26e2	1f 	. 
	rra			;26e3	1f 	. 
	and 00fh		;26e4	e6 0f 	. . 
	ld b,a			;26e6	47 	G 
	pop af			;26e7	f1 	. 
	inc hl			;26e8	23 	# 
	ld l,(hl)			;26e9	6e 	n 
	inc l			;26ea	2c 	, 
	dec l			;26eb	2d 	- 
	ld l,006h		;26ec	2e 06 	. . 
	jp nz,l274eh		;26ee	c2 4e 27 	. N ' 
	ld hl,l001eh+2		;26f1	21 20 00 	!   . 
	add hl,de			;26f4	19 	. 
	ld (hl),a			;26f5	77 	w 
	ld hl,l000ch		;26f6	21 0c 00 	! . . 
	add hl,de			;26f9	19 	. 
	ld a,c			;26fa	79 	y 
	sub (hl)			;26fb	96 	. 
	jp nz,l270ah		;26fc	c2 0a 27 	. . ' 
	ld hl,l000ch+2		;26ff	21 0e 00 	! . . 
	add hl,de			;2702	19 	. 
	ld a,b			;2703	78 	x 
	sub (hl)			;2704	96 	. 
	and 07fh		;2705	e6 7f 	.  
	jp z,l2742h		;2707	ca 42 27 	. B ' 
l270ah:
	push bc			;270a	c5 	. 
	push de			;270b	d5 	. 
	call sub_2465h		;270c	cd 65 24 	. e $ 
	pop de			;270f	d1 	. 
	pop bc			;2710	c1 	. 
	ld l,003h		;2711	2e 03 	. . 
	ld a,(0f4e5h)		;2713	3a e5 f4 	: . . 
	inc a			;2716	3c 	< 
	jp z,l2747h		;2717	ca 47 27 	. G ' 
	ld hl,l000ch		;271a	21 0c 00 	! . . 
	add hl,de			;271d	19 	. 
	ld (hl),c			;271e	71 	q 
	ld hl,l000ch+2		;271f	21 0e 00 	! . . 
	add hl,de			;2722	19 	. 
	ld (hl),b			;2723	70 	p 
	call sub_2414h		;2724	cd 14 24 	. . $ 
	ld a,(0f4e5h)		;2727	3a e5 f4 	: . . 
	inc a			;272a	3c 	< 
	jp nz,l2742h		;272b	c2 42 27 	. B ' 
	pop bc			;272e	c1 	. 
	push bc			;272f	c5 	. 
	ld l,004h		;2730	2e 04 	. . 
	inc c			;2732	0c 	. 
	jp z,l2747h		;2733	ca 47 27 	. G ' 
	call sub_24e7h		;2736	cd e7 24 	. . $ 
	ld l,005h		;2739	2e 05 	. . 
	ld a,(0f4e5h)		;273b	3a e5 f4 	: . . 
	inc a			;273e	3c 	< 
	jp z,l2747h		;273f	ca 47 27 	. G ' 
l2742h:
	pop bc			;2742	c1 	. 
	xor a			;2743	af 	. 
	jp l1ec4h		;2744	c3 c4 1e 	. . . 
l2747h:
	push hl			;2747	e5 	. 
	call sub_212ch		;2748	cd 2c 21 	. , ! 
	ld (hl),0c0h		;274b	36 c0 	6 . 
	pop hl			;274d	e1 	. 
l274eh:
	pop bc			;274e	c1 	. 
	ld a,l			;274f	7d 	} 
	ld (0f4e5h),a		;2750	32 e5 f4 	2 . . 
	jp sub_213bh		;2753	c3 3b 21 	. ; ! 
l2756h:
	ld c,0ffh		;2756	0e ff 	. . 
	call sub_26c6h		;2758	cd c6 26 	. . & 
	call z,sub_2584h		;275b	cc 84 25 	. . % 
	ret			;275e	c9 	. 
l275fh:
	ld c,000h		;275f	0e 00 	. . 
	call sub_26c6h		;2761	cd c6 26 	. . & 
	call z,sub_25c6h		;2764	cc c6 25 	. . % 
	ret			;2767	c9 	. 
sub_2768h:
	ex de,hl			;2768	eb 	. 
	add hl,de			;2769	19 	. 
	ld c,(hl)			;276a	4e 	N 
	ld b,000h		;276b	06 00 	. . 
	ld hl,l000ch		;276d	21 0c 00 	! . . 
	add hl,de			;2770	19 	. 
	ld a,(hl)			;2771	7e 	~ 
	rrca			;2772	0f 	. 
	and 080h		;2773	e6 80 	. . 
	add a,c			;2775	81 	. 
	ld c,a			;2776	4f 	O 
	ld a,000h		;2777	3e 00 	> . 
	adc a,b			;2779	88 	. 
	ld b,a			;277a	47 	G 
	ld a,(hl)			;277b	7e 	~ 
	rrca			;277c	0f 	. 
	and 00fh		;277d	e6 0f 	. . 
	add a,b			;277f	80 	. 
	ld b,a			;2780	47 	G 
	ld hl,l000ch+2		;2781	21 0e 00 	! . . 
	add hl,de			;2784	19 	. 
	ld a,(hl)			;2785	7e 	~ 
	add a,a			;2786	87 	. 
	add a,a			;2787	87 	. 
	add a,a			;2788	87 	. 
	add a,a			;2789	87 	. 
	push af			;278a	f5 	. 
	add a,b			;278b	80 	. 
	ld b,a			;278c	47 	G 
	push af			;278d	f5 	. 
	pop hl			;278e	e1 	. 
	ld a,l			;278f	7d 	} 
	pop hl			;2790	e1 	. 
	or l			;2791	b5 	. 
	and 001h		;2792	e6 01 	. . 
	ret			;2794	c9 	. 
l2795h:
	ld c,00ch		;2795	0e 0c 	. . 
	call sub_22dbh		;2797	cd db 22 	. . " 
	ld hl,(0f4e3h)		;279a	2a e3 f4 	* . . 
	ld de,l0021h		;279d	11 21 00 	. ! . 
	add hl,de			;27a0	19 	. 
	push hl			;27a1	e5 	. 
	ld (hl),d			;27a2	72 	r 
	inc hl			;27a3	23 	# 
	ld (hl),d			;27a4	72 	r 
	inc hl			;27a5	23 	# 
	ld (hl),d			;27a6	72 	r 
l27a7h:
	call sub_21b8h		;27a7	cd b8 21 	. . ! 
	jp z,l27cfh		;27aa	ca cf 27 	. . ' 
	call sub_2121h		;27ad	cd 21 21 	. ! ! 
	ld de,l000fh		;27b0	11 0f 00 	. . . 
	call sub_2768h		;27b3	cd 68 27 	. h ' 
	pop hl			;27b6	e1 	. 
	push hl			;27b7	e5 	. 
	ld e,a			;27b8	5f 	_ 
	ld a,c			;27b9	79 	y 
	sub (hl)			;27ba	96 	. 
	inc hl			;27bb	23 	# 
	ld a,b			;27bc	78 	x 
	sbc a,(hl)			;27bd	9e 	. 
	inc hl			;27be	23 	# 
	ld a,e			;27bf	7b 	{ 
	sbc a,(hl)			;27c0	9e 	. 
	jp c,l27c9h		;27c1	da c9 27 	. . ' 
	ld (hl),e			;27c4	73 	s 
	dec hl			;27c5	2b 	+ 
	ld (hl),b			;27c6	70 	p 
	dec hl			;27c7	2b 	+ 
	ld (hl),c			;27c8	71 	q 
l27c9h:
	call l22f0h		;27c9	cd f0 22 	. . " 
	jp l27a7h		;27cc	c3 a7 27 	. . ' 
l27cfh:
	pop hl			;27cf	e1 	. 
	ret			;27d0	c9 	. 
	ld hl,(0f4e3h)		;27d1	2a e3 f4 	* . . 
	ld de,l001eh+2		;27d4	11 20 00 	.   . 
	call sub_2768h		;27d7	cd 68 27 	. h ' 
	ld hl,l0021h		;27da	21 21 00 	! ! . 
	add hl,de			;27dd	19 	. 
	ld (hl),c			;27de	71 	q 
	inc hl			;27df	23 	# 
	ld (hl),b			;27e0	70 	p 
	inc hl			;27e1	23 	# 
	ld (hl),a			;27e2	77 	w 
	ret			;27e3	c9 	. 
l27e4h:
	ld hl,(0f321h)		;27e4	2a 21 f3 	* ! . 
	ld a,(0f31dh)		;27e7	3a 1d f3 	: . . 
	ld c,a			;27ea	4f 	O 
	call sub_20adh		;27eb	cd ad 20 	. .   
	push hl			;27ee	e5 	. 
	ex de,hl			;27ef	eb 	. 
	call sub_1f1ch		;27f0	cd 1c 1f 	. . . 
	pop hl			;27f3	e1 	. 
	call z,sub_1f0ah		;27f4	cc 0a 1f 	. . . 
	ld a,l			;27f7	7d 	} 
	rra			;27f8	1f 	. 
	ret c			;27f9	d8 	. 
	ld hl,(0f321h)		;27fa	2a 21 f3 	* ! . 
	ld c,l			;27fd	4d 	M 
	ld b,h			;27fe	44 	D 
	call sub_20ceh		;27ff	cd ce 20 	. .   
	ld (0f321h),hl		;2802	22 21 f3 	" ! . 
	jp l2266h		;2805	c3 66 22 	. f " 
sub_2808h:
	ld a,(0f50ah)		;2808	3a 0a f5 	: . . 
	ld hl,0f31dh		;280b	21 1d f3 	! . . 
	cp (hl)			;280e	be 	. 
	ret z			;280f	c8 	. 
	ld b,(hl)			;2810	46 	F 
	jp l29bbh		;2811	c3 bb 29 	. . ) 
sub_2814h:
	ld a,0ffh		;2814	3e ff 	> . 
	ld (0f512h),a		;2816	32 12 f5 	2 . . 
	ld hl,(0f4e3h)		;2819	2a e3 f4 	* . . 
	ld a,(hl)			;281c	7e 	~ 
	and 01fh		;281d	e6 1f 	. . 
	dec a			;281f	3d 	= 
	ld (0f50ah),a		;2820	32 0a f5 	2 . . 
	cp 01eh		;2823	fe 1e 	. . 
	jp nc,l2838h		;2825	d2 38 28 	. 8 ( 
	ld a,(0f31dh)		;2828	3a 1d f3 	: . . 
	ld (0f513h),a		;282b	32 13 f5 	2 . . 
	ld a,(hl)			;282e	7e 	~ 
	ld (0f514h),a		;282f	32 14 f5 	2 . . 
	and 0e0h		;2832	e6 e0 	. . 
	ld (hl),a			;2834	77 	w 
	call sub_2808h		;2835	cd 08 28 	. . ( 
l2838h:
	ld a,(0f31ch)		;2838	3a 1c f3 	: . . 
	ld hl,(0f4e3h)		;283b	2a e3 f4 	* . . 
	or (hl)			;283e	b6 	. 
	ld (hl),a			;283f	77 	w 
	ret			;2840	c9 	. 
	ld a,022h		;2841	3e 22 	> " 
	jp l1ec4h		;2843	c3 c4 1e 	. . . 
l2846h:
	ld hl,COLDRST		;2846	21 00 00 	! . . 
	ld (0f321h),hl		;2849	22 21 f3 	" ! . 
	ld hl,(0f31fh)		;284c	2a 1f f3 	* . . 
	xor a			;284f	af 	. 
	ld (0f31dh),a		;2850	32 1d f3 	2 . . 
	ld hl,l007fh+1		;2853	21 80 00 	! . . 
	call sub_29a8h		;2856	cd a8 29 	. . ) 
	call l219dh		;2859	cd 9d 21 	. . ! 
	jp l27e4h		;285c	c3 e4 27 	. . ' 
	call sub_2135h		;285f	cd 35 21 	. 5 ! 
	call sub_2814h		;2862	cd 14 28 	. . ( 
	jp sub_2414h		;2865	c3 14 24 	. . $ 
	call sub_2814h		;2868	cd 14 28 	. . ( 
	jp sub_2465h		;286b	c3 65 24 	. e $ 
	ld c,000h		;286e	0e 00 	. . 
	ex de,hl			;2870	eb 	. 
	ld a,(hl)			;2871	7e 	~ 
	cp 03fh		;2872	fe 3f 	. ? 
	jp z,l2885h		;2874	ca 85 28 	. . ( 
	call sub_2069h		;2877	cd 69 20 	. i   
	ld a,(hl)			;287a	7e 	~ 
	cp 03fh		;287b	fe 3f 	. ? 
	call nz,sub_2135h		;287d	c4 35 21 	. 5 ! 
	call sub_2814h		;2880	cd 14 28 	. . ( 
	ld c,00fh		;2883	0e 0f 	. . 
l2885h:
	call sub_22dbh		;2885	cd db 22 	. . " 
	jp l21ach		;2888	c3 ac 21 	. . ! 
	ld hl,(0f50dh)		;288b	2a 0d f5 	* . . 
	ld (0f4e3h),hl		;288e	22 e3 f4 	" . . 
	call sub_2814h		;2891	cd 14 28 	. . ( 
	call l22f0h		;2894	cd f0 22 	. . " 
	jp l21ach		;2897	c3 ac 21 	. . ! 
	call sub_2814h		;289a	cd 14 28 	. . ( 
	call sub_235fh		;289d	cd 5f 23 	. _ # 
	jp l22c4h		;28a0	c3 c4 22 	. . " 
	call sub_2814h		;28a3	cd 14 28 	. . ( 
	jp l257fh		;28a6	c3 7f 25 	.  % 
	call sub_2814h		;28a9	cd 14 28 	. . ( 
	jp l25c1h		;28ac	c3 c1 25 	. . % 
	call sub_2135h		;28af	cd 35 21 	. 5 ! 
	call sub_2814h		;28b2	cd 14 28 	. . ( 
	jp sub_24e7h		;28b5	c3 e7 24 	. . $ 
	call sub_2814h		;28b8	cd 14 28 	. . ( 
	call sub_23d9h		;28bb	cd d9 23 	. . # 
	jp l22c4h		;28be	c3 c4 22 	. . " 
	ld hl,(0f321h)		;28c1	2a 21 f3 	* ! . 
	jp l28ech		;28c4	c3 ec 28 	. . ( 
	ld a,(0f31dh)		;28c7	3a 1d f3 	: . . 
	jp l1ec4h		;28ca	c3 c4 1e 	. . . 
	ex de,hl			;28cd	eb 	. 
	call sub_29a8h		;28ce	cd a8 29 	. . ) 
	jp l219dh		;28d1	c3 9d 21 	. . ! 
	ld hl,(0f4f3h)		;28d4	2a f3 f4 	* . . 
	jp l28ech		;28d7	c3 ec 28 	. . ( 
	ld hl,(0f31fh)		;28da	2a 1f f3 	* . . 
	jp l28ech		;28dd	c3 ec 28 	. . ( 
	call sub_2814h		;28e0	cd 14 28 	. . ( 
	call sub_23feh		;28e3	cd fe 23 	. . # 
	jp l22c4h		;28e6	c3 c4 22 	. . " 
	ld hl,(0f4efh)		;28e9	2a ef f4 	* . . 
l28ech:
	ld (0f4e5h),hl		;28ec	22 e5 f4 	" . . 
	ret			;28ef	c9 	. 
	ld a,(0f50ah)		;28f0	3a 0a f5 	: . . 
	cp 0ffh		;28f3	fe ff 	. . 
	jp nz,l28feh		;28f5	c2 fe 28 	. . ( 
	ld a,(0f31ch)		;28f8	3a 1c f3 	: . . 
	jp l1ec4h		;28fb	c3 c4 1e 	. . . 
l28feh:
	and 01fh		;28fe	e6 1f 	. . 
	ld (0f31ch),a		;2900	32 1c f3 	2 . . 
	ret			;2903	c9 	. 
	call sub_2814h		;2904	cd 14 28 	. . ( 
	jp l2756h		;2907	c3 56 27 	. V ' 
	call sub_2814h		;290a	cd 14 28 	. . ( 
	jp l275fh		;290d	c3 5f 27 	. _ ' 
	call sub_2814h		;2910	cd 14 28 	. . ( 
	jp l2795h		;2913	c3 95 27 	. . ' 
	ld hl,(0f4e3h)		;2916	2a e3 f4 	* . . 
	ld a,l			;2919	7d 	} 
	cpl			;291a	2f 	/ 
	ld e,a			;291b	5f 	_ 
	ld a,h			;291c	7c 	| 
	cpl			;291d	2f 	/ 
	ld hl,(0f321h)		;291e	2a 21 f3 	* ! . 
	and h			;2921	a4 	. 
	ld d,a			;2922	57 	W 
	ld a,l			;2923	7d 	} 
	and e			;2924	a3 	. 
	ld e,a			;2925	5f 	_ 
	ld hl,(0f31fh)		;2926	2a 1f f3 	* . . 
	ex de,hl			;2929	eb 	. 
	ld (0f321h),hl		;292a	22 21 f3 	" ! . 
	ld a,l			;292d	7d 	} 
	and e			;292e	a3 	. 
	ld l,a			;292f	6f 	o 
	ld a,h			;2930	7c 	| 
	and d			;2931	a2 	. 
	ld h,a			;2932	67 	g 
	ld (0f31fh),hl		;2933	22 1f f3 	" . . 
	ret			;2936	c9 	. 
GOBACK:
	ld a,(0f512h)		;2937	3a 12 f5 	: . . 
	or a			;293a	b7 	. 
	jp z,l2954h		;293b	ca 54 29 	. T ) 
	ld hl,(0f4e3h)		;293e	2a e3 f4 	* . . 
	ld (hl),000h		;2941	36 00 	6 . 
	ld a,(0f514h)		;2943	3a 14 f5 	: . . 
	or a			;2946	b7 	. 
	jp z,l2954h		;2947	ca 54 29 	. T ) 
	ld (hl),a			;294a	77 	w 
	ld a,(0f513h)		;294b	3a 13 f5 	: . . 
	ld (0f50ah),a		;294e	32 0a f5 	2 . . 
	call sub_2808h		;2951	cd 08 28 	. . ( 
l2954h:
	ld hl,(0f4e1h)		;2954	2a e1 f4 	* . . 
	ld sp,hl			;2957	f9 	. 
	ld hl,(0f4e5h)		;2958	2a e5 f4 	* . . 
	ld a,l			;295b	7d 	} 
	ld b,h			;295c	44 	D 
	ret			;295d	c9 	. 
	call sub_2814h		;295e	cd 14 28 	. . ( 
	ld a,002h		;2961	3e 02 	> . 
	ld (0f509h),a		;2963	32 09 f5 	2 . . 
	ld c,000h		;2966	0e 00 	. . 
	call sub_26cah		;2968	cd ca 26 	. . & 
	call z,sub_25c6h		;296b	cc c6 25 	. . % 
	ret			;296e	c9 	. 
l296fh:
	call sub_29a3h		;296f	cd a3 29 	. . ) 
	ld c,a			;2972	4f 	O 
	inc hl			;2973	23 	# 
	push hl			;2974	e5 	. 
BDOSCODE_end:
	jp l1db0h		;2975	c3 b0 1d 	. . . 
sub_2978h:
	push bc			;2978	c5 	. 
	call sub_29a3h		;2979	cd a3 29 	. . ) 
	pop bc			;297c	c1 	. 
	dec b			;297d	05 	. 
	dec hl			;297e	2b 	+ 
	ret			;297f	c9 	. 
sub_2980h:
	inc hl			;2980	23 	# 
	call sub_29a3h		;2981	cd a3 29 	. . ) 
	ld c,a			;2984	4f 	O 
	dec b			;2985	05 	. 
	ret			;2986	c9 	. 
sub_2987h:
	push bc			;2987	c5 	. 
	inc hl			;2988	23 	# 
	call sub_299eh		;2989	cd 9e 29 	. . ) 
	pop bc			;298c	c1 	. 
	inc b			;298d	04 	. 
	ret			;298e	c9 	. 
l298fh:
	pop hl			;298f	e1 	. 
	call sub_29a3h		;2990	cd a3 29 	. . ) 
	pop bc			;2993	c1 	. 
	jp l1e75h		;2994	c3 75 1e 	. u . 
sub_2997h:
	ld a,b			;2997	78 	x 
	call sub_299eh		;2998	cd 9e 29 	. . ) 
	ld c,00dh		;299b	0e 0d 	. . 
	ret			;299d	c9 	. 
sub_299eh:
	ld c,000h		;299e	0e 00 	. . 
	jp 0ec6ah		;29a0	c3 6a ec 	. j . 
sub_29a3h:
	ld c,000h		;29a3	0e 00 	. . 
	jp 0ec64h		;29a5	c3 64 ec 	. d . 
sub_29a8h:
	ld (0f325h),hl		;29a8	22 25 f3 	" % . 
	ld hl,0f8b1h		;29ab	21 b1 f8 	! . . 
	ld (0f323h),hl		;29ae	22 23 f3 	" # . 
	ret			;29b1	c9 	. 
	ld hl,(0f10ch)		;29b2	2a 0c f1 	* . . 
	ld (0f31fh),hl		;29b5	22 1f f3 	" . . 
	jp l2846h		;29b8	c3 46 28 	. F ( 
l29bbh:
	ld (hl),a			;29bb	77 	w 
	ld a,b			;29bc	78 	x 
	ld (0f522h),a		;29bd	32 22 f5 	2 " . 
	jp l27e4h		;29c0	c3 e4 27 	. . ' 
sub_29c3h:
	ld hl,0f31dh		;29c3	21 1d f3 	! . . 
	ld a,(0efbdh)		;29c6	3a bd ef 	: . . 
	and 020h		;29c9	e6 20 	.   
	jr z,l29d0h		;29cb	28 03 	( . 
	ld hl,0f2e2h		;29cd	21 e2 f2 	! . . 
l29d0h:
	ld a,(hl)			;29d0	7e 	~ 
	ret			;29d1	c9 	. 
sub_29d2h:
	push af			;29d2	f5 	. 
	push hl			;29d3	e5 	. 
	ld a,0ffh		;29d4	3e ff 	> . 
	ld (0efd1h),a		;29d6	32 d1 ef 	2 . . 
	ld hl,0efefh		;29d9	21 ef ef 	! . . 
	set 7,(hl)		;29dc	cb fe 	. . 
	ld hl,0eff1h		;29de	21 f1 ef 	! . . 
	set 7,(hl)		;29e1	cb fe 	. . 
	pop hl			;29e3	e1 	. 
	pop af			;29e4	f1 	. 
	ret			;29e5	c9 	. 
sub_29e6h:
	push af			;29e6	f5 	. 
	push bc			;29e7	c5 	. 
	push de			;29e8	d5 	. 
	push hl			;29e9	e5 	. 
	ld a,(0f4d2h)		;29ea	3a d2 f4 	: . . 
	inc a			;29ed	3c 	< 
	call z,sub_46ddh		;29ee	cc dd 46 	. . F 
	call sub_3931h		;29f1	cd 31 39 	. 1 9 
	ld a,(0f01bh)		;29f4	3a 1b f0 	: . . 
	or a			;29f7	b7 	. 
	jr z,l2a01h		;29f8	28 07 	( . 
	xor a			;29fa	af 	. 
	ld (0f01bh),a		;29fb	32 1b f0 	2 . . 
	call sub_0ae5h		;29fe	cd e5 0a 	. . . 
l2a01h:
	ld hl,0eff1h		;2a01	21 f1 ef 	! . . 
	res 7,(hl)		;2a04	cb be 	. . 
	bit 1,(hl)		;2a06	cb 4e 	. N 
	jr nz,l2a1dh		;2a08	20 13 	  . 
	ld a,(0eff2h)		;2a0a	3a f2 ef 	: . . 
	or a			;2a0d	b7 	. 
	jr z,l2a1dh		;2a0e	28 0d 	( . 
	and 07dh		;2a10	e6 7d 	. } 
	ld (0eff2h),a		;2a12	32 f2 ef 	2 . . 
	call z,sub_0a5ch		;2a15	cc 5c 0a 	. \ . 
	ld hl,0eff0h		;2a18	21 f0 ef 	! . . 
	res 5,(hl)		;2a1b	cb ae 	. . 
l2a1dh:
	ld hl,0efefh		;2a1d	21 ef ef 	! . . 
	res 7,(hl)		;2a20	cb be 	. . 
	ld a,(0eff0h)		;2a22	3a f0 ef 	: . . 
l2a25h:
	or a			;2a25	b7 	. 
	jr z,l2a30h		;2a26	28 08 	( . 
	and 07fh		;2a28	e6 7f 	.  
l2a2ah:
	ld (0eff0h),a		;2a2a	32 f0 ef 	2 . . 
	call z,sub_2d5eh		;2a2d	cc 5e 2d 	. ^ - 
l2a30h:
	xor a			;2a30	af 	. 
	ld (0efd1h),a		;2a31	32 d1 ef 	2 . . 
	pop hl			;2a34	e1 	. 
	pop de			;2a35	d1 	. 
	pop bc			;2a36	c1 	. 
	pop af			;2a37	f1 	. 
	ret			;2a38	c9 	. 
l2a39h:
	call sub_2ac6h		;2a39	cd c6 2a 	. . * 
l2a3ch:
	call sub_2ac6h		;2a3c	cd c6 2a 	. . * 
sub_2a3fh:
	call sub_2ac6h		;2a3f	cd c6 2a 	. . * 
l2a42h:
	call sub_2ac6h		;2a42	cd c6 2a 	. . * 
sub_2a45h:
	call sub_2ac6h		;2a45	cd c6 2a 	. . * 
l2a48h:
	call sub_2ac6h		;2a48	cd c6 2a 	. . * 
	call sub_2ac6h		;2a4b	cd c6 2a 	. . * 
sub_2a4eh:
	call sub_2ac6h		;2a4e	cd c6 2a 	. . * 
sub_2a51h:
	call sub_2ac6h		;2a51	cd c6 2a 	. . * 
sub_2a54h:
	call sub_2ac6h		;2a54	cd c6 2a 	. . * 
sub_2a57h:
	call sub_2ac6h		;2a57	cd c6 2a 	. . * 
l2a5ah:
	call sub_2ac6h		;2a5a	cd c6 2a 	. . * 
l2a5dh:
	call sub_2ac6h		;2a5d	cd c6 2a 	. . * 
sub_2a60h:
	call sub_2ac6h		;2a60	cd c6 2a 	. . * 
sub_2a63h:
	call sub_2ac6h		;2a63	cd c6 2a 	. . * 
	call sub_2ac6h		;2a66	cd c6 2a 	. . * 
sub_2a69h:
	call sub_2ac6h		;2a69	cd c6 2a 	. . * 
	call sub_2ac6h		;2a6c	cd c6 2a 	. . * 
	call sub_2ac6h		;2a6f	cd c6 2a 	. . * 
sub_2a72h:
	call sub_2ac6h		;2a72	cd c6 2a 	. . * 
	call sub_2ac6h		;2a75	cd c6 2a 	. . * 
	call sub_2ac6h		;2a78	cd c6 2a 	. . * 
	call sub_2ac6h		;2a7b	cd c6 2a 	. . * 
	call sub_2ac6h		;2a7e	cd c6 2a 	. . * 
	call sub_2ac6h		;2a81	cd c6 2a 	. . * 
	call sub_2ac6h		;2a84	cd c6 2a 	. . * 
sub_2a87h:
	call sub_2ac6h		;2a87	cd c6 2a 	. . * 
	call sub_2ac6h		;2a8a	cd c6 2a 	. . * 
	call sub_2ac6h		;2a8d	cd c6 2a 	. . * 
	call sub_2ac6h		;2a90	cd c6 2a 	. . * 
	call sub_2ac6h		;2a93	cd c6 2a 	. . * 
	call sub_2ac6h		;2a96	cd c6 2a 	. . * 
	call sub_2ac6h		;2a99	cd c6 2a 	. . * 
	call sub_2ac6h		;2a9c	cd c6 2a 	. . * 
sub_2a9fh:
	call sub_2ac6h		;2a9f	cd c6 2a 	. . * 
	call sub_2ac6h		;2aa2	cd c6 2a 	. . * 
	call sub_2ac6h		;2aa5	cd c6 2a 	. . * 
	call sub_2ac6h		;2aa8	cd c6 2a 	. . * 
	call sub_2ac6h		;2aab	cd c6 2a 	. . * 
	call sub_2ac6h		;2aae	cd c6 2a 	. . * 
	call sub_2ac6h		;2ab1	cd c6 2a 	. . * 
sub_2ab4h:
	call sub_2ac6h		;2ab4	cd c6 2a 	. . * 
l2ab7h:
	call sub_2ac6h		;2ab7	cd c6 2a 	. . * 
	call sub_2ac6h		;2aba	cd c6 2a 	. . * 
	call sub_2ac6h		;2abd	cd c6 2a 	. . * 
	call sub_2ac6h		;2ac0	cd c6 2a 	. . * 
	call sub_2ac6h		;2ac3	cd c6 2a 	. . * 
sub_2ac6h:
	push hl			;2ac6	e5 	. 
	push hl			;2ac7	e5 	. 
	push de			;2ac8	d5 	. 
	ld hl,l0006h		;2ac9	21 06 00 	! . . 
	add hl,sp			;2acc	39 	9 
	ld e,(hl)			;2acd	5e 	^ 
	inc hl			;2ace	23 	# 
	ld d,(hl)			;2acf	56 	V 
	ld hl,000c3h		;2ad0	21 c3 00 	! . . 
	add hl,de			;2ad3	19 	. 
	ex de,hl			;2ad4	eb 	. 
	ld hl,l0003h+1		;2ad5	21 04 00 	! . . 
	add hl,sp			;2ad8	39 	9 
	ld (hl),e			;2ad9	73 	s 
	inc hl			;2ada	23 	# 
	ld (hl),d			;2adb	72 	r 
	ld de,l2af4h		;2adc	11 f4 2a 	. . * 
	inc hl			;2adf	23 	# 
	ld (hl),e			;2ae0	73 	s 
	inc hl			;2ae1	23 	# 
	ld (hl),d			;2ae2	72 	r 
	ld (SAVEIX),ix		;2ae3	dd 22 40 f5 	. " @ . 
	ld (SAVEIY),iy		;2ae7	fd 22 42 f5 	. " B . 
	call sub_29d2h		;2aeb	cd d2 29 	. . ) 
	pop de			;2aee	d1 	. 
	pop hl			;2aef	e1 	. 
	call 0ffe7h		;2af0	cd e7 ff 	. . . 
	ret			;2af3	c9 	. 
l2af4h:
	ld ix,(SAVEIX)		;2af4	dd 2a 40 f5 	. * @ . 
	ld iy,(SAVEIY)		;2af8	fd 2a 42 f5 	. * B . 
	jp sub_29e6h		;2afc	c3 e6 29 	. . ) 
BIOSTBL:
	jp l2b8ch		;2aff	c3 8c 2b 	. . + 
	jp l2bcch		;2b02	c3 cc 2b 	. . + 
	jp l381dh		;2b05	c3 1d 38 	. . 8 
	jp l384dh		;2b08	c3 4d 38 	. M 8 
	jp l3871h		;2b0b	c3 71 38 	. q 8 
	jp l38a5h		;2b0e	c3 a5 38 	. . 8 
	jp l3896h		;2b11	c3 96 38 	. . 8 
	jp l3887h		;2b14	c3 87 38 	. . 8 
	jp l2e94h		;2b17	c3 94 2e 	. . . 
	jp l2e9eh		;2b1a	c3 9e 2e 	. . . 
	jp l2f18h		;2b1d	c3 18 2f 	. . / 
	jp l2f1eh		;2b20	c3 1e 2f 	. . / 
	jp l2f23h		;2b23	c3 23 2f 	. # / 
	jp l2f31h		;2b26	c3 31 2f 	. 1 / 
	jp l2f2ah		;2b29	c3 2a 2f 	. * / 
	jp l38eah		;2b2c	c3 ea 38 	. . 8 
l2b2fh:
	jp l2f27h		;2b2f	c3 27 2f 	. ' / 
	jp l40d3h		;2b32	c3 d3 40 	. . @ 
	jp 03b92h		;2b35	c3 92 3b 	. . ; 
	jp l3a69h		;2b38	c3 69 3a 	. i : 
	ret			;2b3b	c9 	. 
	nop			;2b3c	00 	. 
	nop			;2b3d	00 	. 
	ret			;2b3e	c9 	. 
	nop			;2b3f	00 	. 
	nop			;2b40	00 	. 
	ret			;2b41	c9 	. 
	nop			;2b42	00 	. 
	nop			;2b43	00 	. 
	ret			;2b44	c9 	. 
	nop			;2b45	00 	. 
	nop			;2b46	00 	. 
	ret			;2b47	c9 	. 
	nop			;2b48	00 	. 
	nop			;2b49	00 	. 
	ret			;2b4a	c9 	. 
	nop			;2b4b	00 	. 
	nop			;2b4c	00 	. 
	jp sub_4162h		;2b4d	c3 62 41 	. b A 
	jp l40b5h		;2b50	c3 b5 40 	. . @ 
	jp l42ach		;2b53	c3 ac 42 	. . B 
	ret			;2b56	c9 	. 
	nop			;2b57	00 	. 
	nop			;2b58	00 	. 
	jp l4066h		;2b59	c3 66 40 	. f @ 
	jp 0ec64h		;2b5c	c3 64 ec 	. d . 
	jp 0ec6ah		;2b5f	c3 6a ec 	. j . 
	jp 0ec5eh		;2b62	c3 5e ec 	. ^ . 
	jp 0ec94h		;2b65	c3 94 ec 	. . . 
	jp 0ec70h		;2b68	c3 70 ec 	. p . 
	jp l3977h		;2b6b	c3 77 39 	. w 9 
	jp l3996h		;2b6e	c3 96 39 	. . 9 
	jp l40bah		;2b71	c3 ba 40 	. . @ 
	ret			;2b74	c9 	. 
	nop			;2b75	00 	. 
	nop			;2b76	00 	. 
	jp l5a27h		;2b77	c3 27 5a 	. ' Z 
	jp sub_6afbh		;2b7a	c3 fb 6a 	. . j 
	jp l2d7ah		;2b7d	c3 7a 2d 	. z - 
	ret			;2b80	c9 	. 
	nop			;2b81	00 	. 
	nop			;2b82	00 	. 
	jp l411eh		;2b83	c3 1e 41 	. . A 
	jp l414bh		;2b86	c3 4b 41 	. K A 
	jp l4150h		;2b89	c3 50 41 	. P A 
l2b8ch:
	di			;2b8c	f3 	. 
	xor a			;2b8d	af 	. 
	ld hl,l0003h+1		;2b8e	21 04 00 	! . . 
	call 0ed46h		;2b91	cd 46 ed 	. F . 
	ld c,00ah		;2b94	0e 0a 	. . 
	call CMD7508		;2b96	cd 6f 3c 	. o < 
	ld b,a			;2b99	47 	G 
	rlca			;2b9a	07 	. 
	rlca			;2b9b	07 	. 
	and 0c0h		;2b9c	e6 c0 	. . 
	or 029h		;2b9e	f6 29 	. ) 
	ld (RIOBYTE),a		;2ba0	32 29 f5 	2 ) . 
	dec hl			;2ba3	2b 	+ 
	call 0ed46h		;2ba4	cd 46 ed 	. F . 
	ld a,b			;2ba7	78 	x 
	ld (0f775h),a		;2ba8	32 75 f7 	2 u . 
	and 00fh		;2bab	e6 0f 	. . 
	ld (0f776h),a		;2bad	32 76 f7 	2 v . 
	call 03a47h		;2bb0	cd 47 3a 	. G : 
	ld c,00ch		;2bb3	0e 0c 	. . 
	call sub_4d5dh		;2bb5	cd 5d 4d 	. ] M 
	call sub_2cc2h		;2bb8	cd c2 2c 	. . , 
	ld hl,l11a3h		;2bbb	21 a3 11 	! . . 
	ld (CTRLHELP),hl		;2bbe	22 d1 f0 	" . . 
	ld hl,03b92h		;2bc1	21 92 3b 	! . ; 
	ld (0f0dbh),hl		;2bc4	22 db f0 	" . . 
	call sub_2cfeh		;2bc7	cd fe 2c 	. . , 
	jr l2bf6h		;2bca	18 2a 	. * 
l2bcch:
	call sub_3016h		;2bcc	cd 16 30 	. . 0 
	di			;2bcf	f3 	. 
	call sub_61d3h		;2bd0	cd d3 61 	. . a 
	xor a			;2bd3	af 	. 
	ld (0f0fbh),a		;2bd4	32 fb f0 	2 . . 
	ld (0f0fch),a		;2bd7	32 fc f0 	2 . . 
	ld a,(DFTATR)		;2bda	3a e4 f2 	: . . 
	and 08fh		;2bdd	e6 8f 	. . 
	ld (TACATR),a		;2bdf	32 d1 f7 	2 . . 
	ld a,(VERDFLT)		;2be2	3a be ef 	: . . 
	ld (0efbfh),a		;2be5	32 bf ef 	2 . . 
	ld hl,0efbbh		;2be8	21 bb ef 	! . . 
	res 5,(hl)		;2beb	cb ae 	. . 
	call XUSRSCRN		;2bed	cd 31 59 	. 1 Y 
	ld hl,0effbh		;2bf0	21 fb ef 	! . . 
	call sub_0593h		;2bf3	cd 93 05 	. . . 
l2bf6h:
	ld sp,0ff1fh		;2bf6	31 1f ff 	1 . . 
	ld a,(0f278h)		;2bf9	3a 78 f2 	: x . 
	ld (0f7a8h),a		;2bfc	32 a8 f7 	2 . . 
	call sub_445eh		;2bff	cd 5e 44 	. ^ D 
	ld hl,l0003h		;2c02	21 03 00 	! . . 
	call 0ed4ch		;2c05	cd 4c ed 	. L . 
	ld (RIOBYTE),a		;2c08	32 29 f5 	2 ) . 
	ld a,0c3h		;2c0b	3e c3 	> . 
	ld hl,RBDOS1		;2c0d	21 05 00 	! . . 
	call 0ed46h		;2c10	cd 46 ed 	. F . 
	ld l,h			;2c13	6c 	l 
	call 0ed46h		;2c14	cd 46 ed 	. F . 
	inc hl			;2c17	23 	# 
	ld de,(0ef26h)		;2c18	ed 5b 26 ef 	. [ & . 
	inc de			;2c1c	13 	. 
	inc de			;2c1d	13 	. 
	inc de			;2c1e	13 	. 
	call sub_2d55h		;2c1f	cd 55 2d 	. U - 
	ld hl,(0ef24h)		;2c22	2a 24 ef 	* $ . 
	ld de,l0006h		;2c25	11 06 00 	. . . 
	add hl,de			;2c28	19 	. 
	ex de,hl			;2c29	eb 	. 
	call sub_2d55h		;2c2a	cd 55 2d 	. U - 
	call l1a8fh		;2c2d	cd 8f 1a 	. . . 
	call sub_29d2h		;2c30	cd d2 29 	. . ) 
	ei			;2c33	fb 	. 
	ld hl,0f371h		;2c34	21 71 f3 	! q . 
	ld a,(hl)			;2c37	7e 	~ 
	ld (hl),000h		;2c38	36 00 	6 . 
	ld hl,AUTOSTRT		;2c3a	21 bd f3 	! . . 
	dec a			;2c3d	3d 	= 
	jr z,l2c49h		;2c3e	28 09 	( . 
	dec a			;2c40	3d 	= 
	jr z,l2c49h		;2c41	28 06 	( . 
	dec a			;2c43	3d 	= 
	jr nz,l2c4eh		;2c44	20 08 	  . 
	ld hl,ALRMMSG		;2c46	21 df f3 	! . . 
l2c49h:
	ld a,(hl)			;2c49	7e 	~ 
	or a			;2c4a	b7 	. 
	call nz,sub_2cf5h		;2c4b	c4 f5 2c 	. . , 
l2c4eh:
	ld a,(0ef28h)		;2c4e	3a 28 ef 	: ( . 
	or a			;2c51	b7 	. 
	jr nz,l2c80h		;2c52	20 2c 	  , 
	call sub_2cfeh		;2c54	cd fe 2c 	. . , 
	ld c,00dh		;2c57	0e 0d 	. . 
	call 01bc9h		;2c59	cd c9 1b 	. . . 
	inc a			;2c5c	3c 	< 
	jr z,l2c66h		;2c5d	28 07 	( . 
	ld a,(MENUFG)		;2c5f	3a 44 ef 	: D . 
	or a			;2c62	b7 	. 
	call z,l0b9eh		;2c63	cc 9e 0b 	. . . 
l2c66h:
	di			;2c66	f3 	. 
	call sub_1b30h		;2c67	cd 30 1b 	. 0 . 
	ei			;2c6a	fb 	. 
	call 02d49h		;2c6b	cd 49 2d 	. I - 
	ld hl,l0003h+1		;2c6e	21 04 00 	! . . 
	call 0ec7ch		;2c71	cd 7c ec 	. | . 
	ld c,a			;2c74	4f 	O 
	xor a			;2c75	af 	. 
	ld (0f52eh),a		;2c76	32 2e f5 	2 . . 
	ld ix,(0ef22h)		;2c79	dd 2a 22 ef 	. * " . 
	call sub_2a9fh		;2c7d	cd 9f 2a 	. . * 
l2c80h:
	xor a			;2c80	af 	. 
	ld hl,l007fh+1		;2c81	21 80 00 	! . . 
	call 0ec76h		;2c84	cd 76 ec 	. v . 
	ld hl,l0003h+1		;2c87	21 04 00 	! . . 
	call 0ec7ch		;2c8a	cd 7c ec 	. | . 
	and 00fh		;2c8d	e6 0f 	. . 
	ld e,a			;2c8f	5f 	_ 
	ld c,00eh		;2c90	0e 0e 	. . 
	call 01bc9h		;2c92	cd c9 1b 	. . . 
	call 02d49h		;2c95	cd 49 2d 	. I - 
	ld ix,l00ffh+1		;2c98	dd 21 00 01 	. ! . . 
	xor a			;2c9c	af 	. 
	ld (0f52eh),a		;2c9d	32 2e f5 	2 . . 
	call sub_2a9fh		;2ca0	cd 9f 2a 	. . * 
sub_2ca3h:
	push af			;2ca3	f5 	. 
	ld b,000h		;2ca4	06 00 	. . 
	ld c,a			;2ca6	4f 	O 
l2ca7h:
	sub 00ah		;2ca7	d6 0a 	. . 
	jr c,l2cafh		;2ca9	38 04 	8 . 
	inc b			;2cab	04 	. 
	ld c,a			;2cac	4f 	O 
	jr l2ca7h		;2cad	18 f8 	. . 
l2cafh:
	push bc			;2caf	c5 	. 
	ld c,b			;2cb0	48 	H 
	call sub_2cbbh		;2cb1	cd bb 2c 	. . , 
	pop bc			;2cb4	c1 	. 
	pop af			;2cb5	f1 	. 
	jr nc,sub_2cbbh		;2cb6	30 03 	0 . 
	inc c			;2cb8	0c 	. 
	dec c			;2cb9	0d 	. 
	ret z			;2cba	c8 	. 
sub_2cbbh:
	ld a,030h		;2cbb	3e 30 	> 0 
	add a,c			;2cbd	81 	. 
	ld c,a			;2cbe	4f 	O 
	jp sub_4d5dh		;2cbf	c3 5d 4d 	. ] M 
sub_2cc2h:
	ld hl,(0ef24h)		;2cc2	2a 24 ef 	* $ . 
	ld de,01400h		;2cc5	11 00 14 	. . . 
	add hl,de			;2cc8	19 	. 
	ld a,h			;2cc9	7c 	| 
	srl h		;2cca	cb 3c 	. < 
	srl h		;2ccc	cb 3c 	. < 
	and 003h		;2cce	e6 03 	. . 
	jr z,l2cd8h		;2cd0	28 06 	( . 
	ld b,a			;2cd2	47 	G 
	xor a			;2cd3	af 	. 
l2cd4h:
	add a,019h		;2cd4	c6 19 	. . 
	djnz l2cd4h		;2cd6	10 fc 	. . 
l2cd8h:
	push af			;2cd8	f5 	. 
	ld a,h			;2cd9	7c 	| 
	or a			;2cda	b7 	. 
	call sub_2ca3h		;2cdb	cd a3 2c 	. . , 
	pop af			;2cde	f1 	. 
	or a			;2cdf	b7 	. 
	jr z,l2cedh		;2ce0	28 0b 	( . 
	push af			;2ce2	f5 	. 
	ld c,02eh		;2ce3	0e 2e 	. . 
	call sub_4d5dh		;2ce5	cd 5d 4d 	. ] M 
	pop af			;2ce8	f1 	. 
	scf			;2ce9	37 	7 
	call sub_2ca3h		;2cea	cd a3 2c 	. . , 
l2cedh:
	ld hl,TYPTXT_start		;2ced	21 d8 7f 	! .  
	ld a,010h		;2cf0	3e 10 	> . 
	jp sub_17f3h		;2cf2	c3 f3 17 	. . . 
sub_2cf5h:
	ld a,(hl)			;2cf5	7e 	~ 
	ld (0f016h),a		;2cf6	32 16 f0 	2 . . 
	inc hl			;2cf9	23 	# 
	ld (0f014h),hl		;2cfa	22 14 f0 	" . . 
	ret			;2cfd	c9 	. 
sub_2cfeh:
	ld a,(0f776h)		;2cfe	3a 76 f7 	: v . 
l2d01h:
	ld (YLCOUNTRY),a		;2d01	32 77 f7 	2 w . 
	ld hl,07d5eh		;2d04	21 5e 7d 	! ^ } 
	ld de,0f0ddh		;2d07	11 dd f0 	. . . 
	ld bc,l0018h		;2d0a	01 18 00 	. . . 
	ldir		;2d0d	ed b0 	. . 
	ld hl,0f545h		;2d0f	21 45 f5 	! E . 
	ld (0f012h),hl		;2d12	22 12 f0 	" . . 
	ld a,(0ef28h)		;2d15	3a 28 ef 	: ( . 
	or a			;2d18	b7 	. 
	ret nz			;2d19	c0 	. 
	ex de,hl			;2d1a	eb 	. 
	ld hl,0f02dh		;2d1b	21 2d f0 	! - . 
	ld bc,000a0h		;2d1e	01 a0 00 	. . . 
	ldir		;2d21	ed b0 	. . 
	ld a,(0f775h)		;2d23	3a 75 f7 	: u . 
sub_2d26h:
	rlca			;2d26	07 	. 
	jp nc,l3994h		;2d27	d2 94 39 	. . 9 
	call sub_3a02h		;2d2a	cd 02 3a 	. . : 
	ld c,005h		;2d2d	0e 05 	. . 
	call CMD7508		;2d2f	cd 6f 3c 	. o < 
	ld hl,l2d3eh		;2d32	21 3e 2d 	! > - 
	ld de,MENUDRV		;2d35	11 45 ef 	. E . 
	ld bc,l0009h+2		;2d38	01 0b 00 	. . . 
	ldir		;2d3b	ed b0 	. . 
	ret			;2d3d	c9 	. 
l2d3eh:
	ld b,c			;2d3e	41 	A 
	ld b,d			;2d3f	42 	B 
	ld b,e			;2d40	43 	C 
	ld b,h			;2d41	44 	D 
	ld c,b			;2d42	48 	H 
	ld c,c			;2d43	49 	I 
	ld c,d			;2d44	4a 	J 
	ld c,e			;2d45	4b 	K 
	jr nz,$+34		;2d46	20 20 	    
	jr nz,l2d6bh		;2d48	20 21 	  ! 
	rra			;2d4a	1f 	. 
	ret p			;2d4b	f0 	. 
	ld de,0f328h		;2d4c	11 28 f3 	. ( . 
	ld bc,l000ch+2		;2d4f	01 0e 00 	. . . 
	ldir		;2d52	ed b0 	. . 
	ret			;2d54	c9 	. 
sub_2d55h:
	ld a,e			;2d55	7b 	{ 
	call 0ed46h		;2d56	cd 46 ed 	. F . 
	inc hl			;2d59	23 	# 
	ld a,d			;2d5a	7a 	z 
	jp 0ed46h		;2d5b	c3 46 ed 	. F . 
sub_2d5eh:
	ld c,0ffh		;2d5e	0e ff 	. . 
	ld a,(0f371h)		;2d60	3a 71 f3 	: q . 
	or a			;2d63	b7 	. 
	jr nz,sub_2d75h		;2d64	20 0f 	  . 
	inc c			;2d66	0c 	. 
	ld a,(BTRYFG)		;2d67	3a ee ef 	: . . 
	or a			;2d6a	b7 	. 
l2d6bh:
	jr nz,sub_2d75h		;2d6b	20 08 	  . 
	ld a,(0f4ddh)		;2d6d	3a dd f4 	: . . 
	cp 002h		;2d70	fe 02 	. . 
	jr z,sub_2d75h		;2d72	28 01 	( . 
	inc c			;2d74	0c 	. 
sub_2d75h:
	call l2d7ah		;2d75	cd 7a 2d 	. z - 
	ei			;2d78	fb 	. 
	ret			;2d79	c9 	. 
l2d7ah:
	push bc			;2d7a	c5 	. 
	ld a,(0f53eh)		;2d7b	3a 3e f5 	: > . 
	push af			;2d7e	f5 	. 
	xor a			;2d7f	af 	. 
	out (004h),a		;2d80	d3 04 	. . 
	ld a,(0f33ch)		;2d82	3a 3c f3 	: < . 
	push af			;2d85	f5 	. 
	call sub_3016h		;2d86	cd 16 30 	. . 0 
	pop af			;2d89	f1 	. 
	ld c,a			;2d8a	4f 	O 
	inc a			;2d8b	3c 	< 
	call nz,sub_47b8h		;2d8c	c4 b8 47 	. . G 
	di			;2d8f	f3 	. 
	pop af			;2d90	f1 	. 
	ld (0f53eh),a		;2d91	32 3e f5 	2 > . 
	out (004h),a		;2d94	d3 04 	. . 
	pop bc			;2d96	c1 	. 
	inc c			;2d97	0c 	. 
	jr z,l2debh		;2d98	28 51 	( Q 
	push ix		;2d9a	dd e5 	. . 
	push iy		;2d9c	fd e5 	. . 
	ex af,af'			;2d9e	08 	. 
	exx			;2d9f	d9 	. 
	push af			;2da0	f5 	. 
	push bc			;2da1	c5 	. 
	push de			;2da2	d5 	. 
	push hl			;2da3	e5 	. 
	exx			;2da4	d9 	. 
	ex af,af'			;2da5	08 	. 
	ld (0f36bh),sp		;2da6	ed 73 6b f3 	. s k . 
	ld a,(0ef29h)		;2daa	3a 29 ef 	: ) . 
	bit 4,a		;2dad	cb 67 	. g 
	jr nz,l2dc6h		;2daf	20 15 	  . 
	ld a,(0f775h)		;2db1	3a 75 f7 	: u . 
	and 080h		;2db4	e6 80 	. . 
	ld a,(IFRCECNT)		;2db6	3a 12 f3 	: . . 
	jr nz,l2dbeh		;2db9	20 03 	  . 
	ld a,(FRCENTN)		;2dbb	3a 11 f3 	: . . 
l2dbeh:
	or a			;2dbe	b7 	. 
	jr nz,l2de1h		;2dbf	20 20 	    
	dec c			;2dc1	0d 	. 
	jr z,l2de1h		;2dc2	28 1d 	( . 
	jr l2dc9h		;2dc4	18 03 	. . 
l2dc6h:
	call sub_0339h		;2dc6	cd 39 03 	. 9 . 
l2dc9h:
	ld c,00ch		;2dc9	0e 0c 	. . 
	call sub_4d5dh		;2dcb	cd 5d 4d 	. ] M 
	xor a			;2dce	af 	. 
	ld (0efefh),a		;2dcf	32 ef ef 	2 . . 
	ld (0eff1h),a		;2dd2	32 f1 ef 	2 . . 
	ld (0efd1h),a		;2dd5	32 d1 ef 	2 . . 
	ld (0f371h),a		;2dd8	32 71 f3 	2 q . 
	dec a			;2ddb	3d 	= 
	ld (0efd2h),a		;2ddc	32 d2 ef 	2 . . 
	jr l2de8h		;2ddf	18 07 	. . 
l2de1h:
	ld a,(0efd2h)		;2de1	3a d2 ef 	: . . 
	ld (0f36dh),a		;2de4	32 6d f3 	2 m . 
	xor a			;2de7	af 	. 
l2de8h:
	ld (0f310h),a		;2de8	32 10 f3 	2 . . 
l2debh:
	xor a			;2deb	af 	. 
	ld (0eff0h),a		;2dec	32 f0 ef 	2 . . 
	ld (0eff2h),a		;2def	32 f2 ef 	2 . . 
	ld hl,0efefh		;2df2	21 ef ef 	! . . 
	ld de,0f473h		;2df5	11 73 f4 	. s . 
	ld bc,l0003h+1		;2df8	01 04 00 	. . . 
	ldir		;2dfb	ed b0 	. . 
	call sub_6b28h		;2dfd	cd 28 6b 	. ( k 
	ld (0f7c4h),a		;2e00	32 c4 f7 	2 . . 
	jr z,l2e09h		;2e03	28 04 	( . 
	sub 049h		;2e05	d6 49 	. I 
	jr nz,l2e15h		;2e07	20 0c 	  . 
l2e09h:
	call HSRK		;2e09	cd 52 47 	. R G 
	or a			;2e0c	b7 	. 
	ld b,018h		;2e0d	06 18 	. . 
	call sub_6afbh		;2e0f	cd fb 6a 	. . j 
	call l6c13h		;2e12	cd 13 6c 	. . l 
l2e15h:
	call sub_46ddh		;2e15	cd dd 46 	. . F 
	call sub_5908h		;2e18	cd 08 59 	. . Y 
	call sub_0893h		;2e1b	cd 93 08 	. . . 
	xor a			;2e1e	af 	. 
	ld (0efb6h),a		;2e1f	32 b6 ef 	2 . . 
	out (009h),a		;2e22	d3 09 	. . 
	ld a,(BTRYFG)		;2e24	3a ee ef 	: . . 
	or a			;2e27	b7 	. 
	jr z,l2e39h		;2e28	28 0f 	( . 
	call XSETSCRN		;2e2a	cd 29 59 	. ) Y 
	ld hl,l2e80h		;2e2d	21 80 2e 	! . . 
	call sub_0589h		;2e30	cd 89 05 	. . . 
	call sub_50e7h		;2e33	cd e7 50 	. . P 
	call XUSRSCRN		;2e36	cd 31 59 	. 1 Y 
l2e39h:
	call sub_0225h		;2e39	cd 25 02 	. % . 
	ld (0f373h),de		;2e3c	ed 53 73 f3 	. S s . 
	xor a			;2e40	af 	. 
	ld (0f370h),a		;2e41	32 70 f3 	2 p . 
	ld a,(BTRYFG)		;2e44	3a ee ef 	: . . 
	or a			;2e47	b7 	. 
	jr z,l2e79h		;2e48	28 2f 	( / 
	ld c,029h		;2e4a	0e 29 	. ) 
	call WRT7508		;2e4c	cd 61 3c 	. a < 
	ld hl,0d800h		;2e4f	21 00 d8 	! . . 
	ld a,h			;2e52	7c 	| 
	out (008h),a		;2e53	d3 08 	. . 
	ld h,01eh		;2e55	26 1e 	& . 
	ld d,000h		;2e57	16 00 	. . 
	ld a,(0f4dch)		;2e59	3a dc f4 	: . . 
	ld l,a			;2e5c	6f 	o 
l2e5dh:
	ld c,008h		;2e5d	0e 08 	. . 
	call CMD7508		;2e5f	cd 6f 3c 	. o < 
	and 001h		;2e62	e6 01 	. . 
	jr z,l2e76h		;2e64	28 10 	( . 
	ld l,0ffh		;2e66	2e ff 	. . 
l2e68h:
	ld a,080h		;2e68	3e 80 	> . 
	xor d			;2e6a	aa 	. 
	out (009h),a		;2e6b	d3 09 	. . 
	ld d,a			;2e6d	57 	W 
	call sub_460ch		;2e6e	cd 0c 46 	. . F 
	dec h			;2e71	25 	% 
	jr z,l2e79h		;2e72	28 05 	( . 
	jr l2e5dh		;2e74	18 e7 	. . 
l2e76h:
	or l			;2e76	b5 	. 
	jr z,l2e68h		;2e77	28 ef 	( . 
l2e79h:
	ld c,001h		;2e79	0e 01 	. . 
	call WRT7508		;2e7b	cd 61 3c 	. a < 
l2e7eh:
	jr l2e7eh		;2e7e	18 fe 	. . 
l2e80h:
	inc c			;2e80	0c 	. 
	dec de			;2e81	1b 	. 
	dec a			;2e82	3d 	= 
	inc hl			;2e83	23 	# 
	ld hl,(l4843h)		;2e84	2a 43 48 	* C H 
	ld b,c			;2e87	41 	A 
	ld d,d			;2e88	52 	R 
	ld b,a			;2e89	47 	G 
	ld b,l			;2e8a	45 	E 
	jr nz,l2ecfh		;2e8b	20 42 	  B 
	ld b,c			;2e8d	41 	A 
	ld d,h			;2e8e	54 	T 
	ld d,h			;2e8f	54 	T 
	ld b,l			;2e90	45 	E 
	ld d,d			;2e91	52 	R 
	ld e,c			;2e92	59 	Y 
	nop			;2e93	00 	. 
l2e94h:
	call sub_3016h		;2e94	cd 16 30 	. . 0 
	ei			;2e97	fb 	. 
	ld bc,COLDRST		;2e98	01 00 00 	. . . 
	jp l2f18h		;2e9b	c3 18 2f 	. . / 
l2e9eh:
	ld hl,COLDRST		;2e9e	21 00 00 	! . . 
	ld a,c			;2ea1	79 	y 
	cp 00bh		;2ea2	fe 0b 	. . 
	ret nc			;2ea4	d0 	. 
	ld b,h			;2ea5	44 	D 
	ld hl,0f0ffh		;2ea6	21 ff f0 	! . . 
	add hl,bc			;2ea9	09 	. 
	ld a,(hl)			;2eaa	7e 	~ 
	cp 00bh		;2eab	fe 0b 	. . 
	ld hl,COLDRST		;2ead	21 00 00 	! . . 
	ret nc			;2eb0	d0 	. 
	ld (0f5e5h),a		;2eb1	32 e5 f5 	2 . . 
	cp 003h		;2eb4	fe 03 	. . 
	jr c,l2ec0h		;2eb6	38 08 	8 . 
	cp 007h		;2eb8	fe 07 	. . 
	jr nc,l2ec0h		;2eba	30 04 	0 . 
	bit 0,e		;2ebc	cb 43 	. C 
	jr nz,l2ed2h		;2ebe	20 12 	  . 
l2ec0h:
	ld hl,l2ecbh		;2ec0	21 cb 2e 	! . . 
	push hl			;2ec3	e5 	. 
	ld hl,0f10eh		;2ec4	21 0e f1 	! . . 
	call sub_5e4ch		;2ec7	cd 4c 5e 	. L ^ 
	jp (hl)			;2eca	e9 	. 
l2ecbh:
	ld hl,COLDRST		;2ecb	21 00 00 	! . . 
	ret c			;2ece	d8 	. 
l2ecfh:
	ld a,(0f5e5h)		;2ecf	3a e5 f5 	: . . 
l2ed2h:
	ld l,a			;2ed2	6f 	o 
	ld h,000h		;2ed3	26 00 	& . 
	ld b,004h		;2ed5	06 04 	. . 
	call sub_33f0h		;2ed7	cd f0 33 	. . 3 
	ld de,0f150h		;2eda	11 50 f1 	. P . 
	add hl,de			;2edd	19 	. 
	ret			;2ede	c9 	. 
	or a			;2edf	b7 	. 
	ret			;2ee0	c9 	. 
	ld a,(0ef9eh)		;2ee1	3a 9e ef 	: . . 
	jr l2f14h		;2ee4	18 2e 	. . 
	ld a,(0ef9fh)		;2ee6	3a 9f ef 	: . . 
	jr l2f14h		;2ee9	18 29 	. ) 
	ld a,(0f0fbh)		;2eeb	3a fb f0 	: . . 
	or a			;2eee	b7 	. 
	jp z,l2ff1h		;2eef	ca f1 2f 	. . / 
	call sub_2fdfh		;2ef2	cd df 2f 	. . / 
	jr l2f01h		;2ef5	18 0a 	. . 
	ld a,(0f0fch)		;2ef7	3a fc f0 	: . . 
	or a			;2efa	b7 	. 
	jp z,02ff4h		;2efb	ca f4 2f 	. . / 
	call sub_2fe6h		;2efe	cd e6 2f 	. . / 
l2f01h:
	or a			;2f01	b7 	. 
	ret z			;2f02	c8 	. 
	scf			;2f03	37 	7 
	ret			;2f04	c9 	. 
	or a			;2f05	b7 	. 
	ret			;2f06	c9 	. 
	ld a,(0ef9bh)		;2f07	3a 9b ef 	: . . 
	jr l2f14h		;2f0a	18 08 	. . 
	ld a,(0efa0h)		;2f0c	3a a0 ef 	: . . 
	jr l2f14h		;2f0f	18 03 	. . 
	ld a,(0efa1h)		;2f11	3a a1 ef 	: . . 
l2f14h:
	or a			;2f14	b7 	. 
	ret nz			;2f15	c0 	. 
	scf			;2f16	37 	7 
	ret			;2f17	c9 	. 
l2f18h:
	ld h,b			;2f18	60 	` 
	ld l,c			;2f19	69 	i 
	ld (0f5e6h),hl		;2f1a	22 e6 f5 	" . . 
	ret			;2f1d	c9 	. 
l2f1eh:
	ld a,c			;2f1e	79 	y 
	ld (0f5e8h),a		;2f1f	32 e8 f5 	2 . . 
	ret			;2f22	c9 	. 
l2f23h:
	ld (0f5f9h),bc		;2f23	ed 43 f9 f5 	. C . . 
l2f27h:
	ld h,b			;2f27	60 	` 
	ld l,c			;2f28	69 	i 
	ret			;2f29	c9 	. 
l2f2ah:
	ld a,002h		;2f2a	3e 02 	> . 
	ld hl,0f13ah		;2f2c	21 3a f1 	! : . 
	jr l2f39h		;2f2f	18 08 	. . 
l2f31h:
	call sub_312ch		;2f31	cd 2c 31 	. , 1 
	ld a,001h		;2f34	3e 01 	> . 
	ld hl,0f124h		;2f36	21 24 f1 	! $ . 
l2f39h:
	ld (BIOSERROR),a		;2f39	32 2b f5 	2 + . 
	ld a,(0f5e5h)		;2f3c	3a e5 f5 	: . . 
	cp 00bh		;2f3f	fe 0b 	. . 
	ret nc			;2f41	d0 	. 
	ld de,l2f4ah		;2f42	11 4a 2f 	. J / 
	push de			;2f45	d5 	. 
	call sub_5e4ch		;2f46	cd 4c 5e 	. L ^ 
	jp (hl)			;2f49	e9 	. 
l2f4ah:
	ld hl,0f316h		;2f4a	21 16 f3 	! . . 
	ld (hl),000h		;2f4d	36 00 	6 . 
	ret			;2f4f	c9 	. 
l2f50h:
	ld a,003h		;2f50	3e 03 	> . 
	ld (BIOSERROR),a		;2f52	32 2b f5 	2 + . 
	or 0ffh		;2f55	f6 ff 	. . 
	ret			;2f57	c9 	. 
	ld a,0afh		;2f58	3e af 	> . 
	ld (0efafh),a		;2f5a	32 af ef 	2 . . 
	ld a,c			;2f5d	79 	y 
	ld (0f939h),a		;2f5e	32 39 f9 	2 9 . 
	ld a,(0f5e5h)		;2f61	3a e5 f5 	: . . 
	cp 005h		;2f64	fe 05 	. . 
	jr nc,l2f6fh		;2f66	30 07 	0 . 
	ld a,031h		;2f68	3e 31 	> 1 
	ld (0f0f9h),a		;2f6a	32 f9 f0 	2 . . 
	jr l2f74h		;2f6d	18 05 	. . 
l2f6fh:
	ld a,032h		;2f6f	3e 32 	> 2 
	ld (0f0fah),a		;2f71	32 fa f0 	2 . . 
l2f74h:
	ld (0f0fdh),a		;2f74	32 fd f0 	2 . . 
	call sub_3026h		;2f77	cd 26 30 	. & 0 
	call sub_33f7h		;2f7a	cd f7 33 	. . 3 
	jr nz,l2f90h		;2f7d	20 11 	  . 
	ld hl,(0f5f9h)		;2f7f	2a f9 f5 	* . . 
	ld de,0f93ah		;2f82	11 3a f9 	. : . 
	ld bc,l007fh+1		;2f85	01 80 00 	. . . 
	ldir		;2f88	ed b0 	. . 
	ld a,078h		;2f8a	3e 78 	> x 
	ld c,083h		;2f8c	0e 83 	. . 
	jr l2f94h		;2f8e	18 04 	. . 
l2f90h:
	ld a,077h		;2f90	3e 77 	> w 
	ld c,002h		;2f92	0e 02 	. . 
l2f94h:
	push af			;2f94	f5 	. 
	ld hl,0f937h		;2f95	21 37 f9 	! 7 . 
	ld a,(0f5e6h)		;2f98	3a e6 f5 	: . . 
	ld (hl),a			;2f9b	77 	w 
	ld a,(0f5e8h)		;2f9c	3a e8 f5 	: . . 
	inc a			;2f9f	3c 	< 
	inc hl			;2fa0	23 	# 
	ld (hl),a			;2fa1	77 	w 
	ld a,(0f5e5h)		;2fa2	3a e5 f5 	: . . 
	dec a			;2fa5	3d 	= 
	and 001h		;2fa6	e6 01 	. . 
	inc a			;2fa8	3c 	< 
	ld b,a			;2fa9	47 	G 
	pop af			;2faa	f1 	. 
	call sub_3040h		;2fab	cd 40 30 	. @ 0 
	jr nz,l2fd6h		;2fae	20 26 	  & 
	call sub_33f7h		;2fb0	cd f7 33 	. . 3 
	jr nz,l2fc2h		;2fb3	20 0d 	  . 
	ld a,(0f936h)		;2fb5	3a 36 f9 	: 6 . 
	or a			;2fb8	b7 	. 
	jp z,l30b8h		;2fb9	ca b8 30 	. . 0 
	cp 0fdh		;2fbc	fe fd 	. . 
	jp nc,l2f50h		;2fbe	d2 50 2f 	. P / 
	ret			;2fc1	c9 	. 
l2fc2h:
	ld a,(0f9b6h)		;2fc2	3a b6 f9 	: . . 
	or a			;2fc5	b7 	. 
	ret nz			;2fc6	c0 	. 
	ld hl,0f936h		;2fc7	21 36 f9 	! 6 . 
	ld de,(0f5f9h)		;2fca	ed 5b f9 f5 	. [ . . 
	ld bc,l007fh+1		;2fce	01 80 00 	. . . 
	ldir		;2fd1	ed b0 	. . 
	jp l30b8h		;2fd3	c3 b8 30 	. . 0 
l2fd6h:
	cp 063h		;2fd6	fe 63 	. c 
	ret nz			;2fd8	c0 	. 
	ld a,004h		;2fd9	3e 04 	> . 
	ld (BIOSERROR),a		;2fdb	32 2b f5 	2 + . 
	ret			;2fde	c9 	. 
sub_2fdfh:
	ld a,031h		;2fdf	3e 31 	> 1 
	ld hl,0f0f9h		;2fe1	21 f9 f0 	! . . 
	jr l2febh		;2fe4	18 05 	. . 
sub_2fe6h:
	ld a,032h		;2fe6	3e 32 	> 2 
	ld hl,0f0fah		;2fe8	21 fa f0 	! . . 
l2febh:
	ld (hl),000h		;2feb	36 00 	6 . 
	ld c,079h		;2fed	0e 79 	. y 
	jr l3036h		;2fef	18 45 	. E 
l2ff1h:
	ld a,031h		;2ff1	3e 31 	> 1 
	ld hl,l323eh		;2ff3	21 3e 32 	! > 2 
	ld c,00dh		;2ff6	0e 0d 	. . 
	call l3036h		;2ff8	cd 36 30 	. 6 0 
	scf			;2ffb	37 	7 
	ret nz			;2ffc	c0 	. 
	ld a,(0f936h)		;2ffd	3a 36 f9 	: 6 . 
	or a			;3000	b7 	. 
	scf			;3001	37 	7 
	ret nz			;3002	c0 	. 
	ld a,(0f0fdh)		;3003	3a fd f0 	: . . 
	cp 031h		;3006	fe 31 	. 1 
	ld a,0ffh		;3008	3e ff 	> . 
	jr nz,l3011h		;300a	20 05 	  . 
	ld (0f0fbh),a		;300c	32 fb f0 	2 . . 
	xor a			;300f	af 	. 
	ret			;3010	c9 	. 
l3011h:
	ld (0f0fch),a		;3011	32 fc f0 	2 . . 
	xor a			;3014	af 	. 
	ret			;3015	c9 	. 
sub_3016h:
	di			;3016	f3 	. 
	ld a,(0f0f9h)		;3017	3a f9 f0 	: . . 
	or a			;301a	b7 	. 
	call nz,sub_2fdfh		;301b	c4 df 2f 	. . / 
	di			;301e	f3 	. 
	ld a,(0f0fah)		;301f	3a fa f0 	: . . 
	or a			;3022	b7 	. 
	jr nz,sub_2fe6h		;3023	20 c1 	  . 
	ret			;3025	c9 	. 
sub_3026h:
	ld hl,0f931h		;3026	21 31 f9 	! 1 . 
	xor a			;3029	af 	. 
	ld (hl),a			;302a	77 	w 
	ld a,(0f0fdh)		;302b	3a fd f0 	: . . 
	inc hl			;302e	23 	# 
	ld (hl),a			;302f	77 	w 
l3030h:
	ld a,(0f0feh)		;3030	3a fe f0 	: . . 
	inc hl			;3033	23 	# 
	ld (hl),a			;3034	77 	w 
	ret			;3035	c9 	. 
l3036h:
	ld (0f0fdh),a		;3036	32 fd f0 	2 . . 
	call sub_3026h		;3039	cd 26 30 	. & 0 
	ld a,c			;303c	79 	y 
	ld bc,COLDRST		;303d	01 00 00 	. . . 
sub_3040h:
	ld (0f934h),a		;3040	32 34 f9 	2 4 . 
	ld (0f935h),bc		;3043	ed 43 35 f9 	. C 5 . 
	ld a,001h		;3047	3e 01 	> . 
	ld hl,0f931h		;3049	21 31 f9 	! 1 . 
	jp EPSSND		;304c	c3 94 4a 	. . J 
	ld a,0afh		;304f	3e af 	> . 
	ld (0efafh),a		;3051	32 af ef 	2 . . 
	ld a,(0ef9ch)		;3054	3a 9c ef 	: . . 
	or a			;3057	b7 	. 
	jr z,l30bdh		;3058	28 63 	( c 
	ld a,(0f5e6h)		;305a	3a e6 f5 	: . . 
	or a			;305d	b7 	. 
	jr nz,l3074h		;305e	20 14 	  . 
	ld a,(0f5e8h)		;3060	3a e8 f5 	: . . 
	xor 007h		;3063	ee 07 	. . 
	cp 004h		;3065	fe 04 	. . 
	jr nc,l3074h		;3067	30 0b 	0 . 
	call sub_33f7h		;3069	cd f7 33 	. . 3 
	jr z,l30b1h		;306c	28 43 	( C 
	call sub_312ch		;306e	cd 2c 31 	. , 1 
	jp l30b8h		;3071	c3 b8 30 	. . 0 
l3074h:
	xor a			;3074	af 	. 
	call sub_331bh		;3075	cd 1b 33 	. . 3 
	ld a,(0ef9ch)		;3078	3a 9c ef 	: . . 
	call sub_3374h		;307b	cd 74 33 	. t 3 
	jr c,l30b1h		;307e	38 31 	8 1 
	ld hl,(0efaah)		;3080	2a aa ef 	* . . 
	call sub_33ddh		;3083	cd dd 33 	. . 3 
	ld hl,(0efach)		;3086	2a ac ef 	* . . 
	ld de,(0f5f9h)		;3089	ed 5b f9 f5 	. [ . . 
	ld bc,l007fh+1		;308d	01 80 00 	. . . 
	call sub_33f7h		;3090	cd f7 33 	. . 3 
	jr nz,l3096h		;3093	20 01 	  . 
	ex de,hl			;3095	eb 	. 
l3096h:
	call 0ec88h		;3096	cd 88 ec 	. . . 
	call sub_3398h		;3099	cd 98 33 	. . 3 
	ld b,a			;309c	47 	G 
	ld de,(0efaah)		;309d	ed 5b aa ef 	. [ . . 
	add hl,de			;30a1	19 	. 
	ld de,00200h		;30a2	11 00 02 	. . . 
	add hl,de			;30a5	19 	. 
	call sub_33f7h		;30a6	cd f7 33 	. . 3 
	jr z,l30b4h		;30a9	28 09 	( . 
	call 0ec7ch		;30ab	cd 7c ec 	. | . 
	cp b			;30ae	b8 	. 
	jr z,l30b8h		;30af	28 07 	( . 
l30b1h:
	ld a,0ffh		;30b1	3e ff 	> . 
	ret			;30b3	c9 	. 
l30b4h:
	ld a,b			;30b4	78 	x 
	call 0ec76h		;30b5	cd 76 ec 	. v . 
l30b8h:
	xor a			;30b8	af 	. 
	ld (BIOSERROR),a		;30b9	32 2b f5 	2 + . 
	ret			;30bc	c9 	. 
l30bdh:
	ld a,(0ef9dh)		;30bd	3a 9d ef 	: . . 
	or a			;30c0	b7 	. 
	jr nz,l30e8h		;30c1	20 25 	  % 
	call sub_33f7h		;30c3	cd f7 33 	. . 3 
	jr z,l30b1h		;30c6	28 e9 	( . 
	ld a,(0f5e6h)		;30c8	3a e6 f5 	: . . 
	or a			;30cb	b7 	. 
	jr nz,l30b1h		;30cc	20 e3 	  . 
	ld a,(0f5e8h)		;30ce	3a e8 f5 	: . . 
	cp 004h		;30d1	fe 04 	. . 
	jr nc,l30b1h		;30d3	30 dc 	0 . 
	call sub_312ch		;30d5	cd 2c 31 	. , 1 
	inc hl			;30d8	23 	# 
	ld a,020h		;30d9	3e 20 	>   
	ld de,l001eh+2		;30db	11 20 00 	.   . 
	ld b,004h		;30de	06 04 	. . 
l30e0h:
	or a			;30e0	b7 	. 
	sbc hl,de		;30e1	ed 52 	. R 
	ld (hl),a			;30e3	77 	w 
	djnz l30e0h		;30e4	10 fa 	. . 
	jr l30b8h		;30e6	18 d0 	. . 
l30e8h:
	xor a			;30e8	af 	. 
	call sub_331bh		;30e9	cd 1b 33 	. . 3 
	ld a,(0ef9dh)		;30ec	3a 9d ef 	: . . 
	call sub_3374h		;30ef	cd 74 33 	. t 3 
	jr c,l30b1h		;30f2	38 bd 	8 . 
	ld a,003h		;30f4	3e 03 	> . 
	ld (0efb2h),a		;30f6	32 b2 ef 	2 . . 
l30f9h:
	ld hl,l311ch		;30f9	21 1c 31 	! . 1 
	push hl			;30fc	e5 	. 
	ld hl,l478dh		;30fd	21 8d 47 	! . G 
	call sub_33f7h		;3100	cd f7 33 	. . 3 
	jr nz,l3108h		;3103	20 03 	  . 
	ld hl,l478dh+1		;3105	21 8e 47 	! . G 
l3108h:
	push hl			;3108	e5 	. 
	ld a,001h		;3109	3e 01 	> . 
	ld (0ef2bh),a		;310b	32 2b ef 	2 + . 
	ld hl,(0efach)		;310e	2a ac ef 	* . . 
	ld a,(0efaeh)		;3111	3a ae ef 	: . . 
	ld c,a			;3114	4f 	O 
	ld de,(0f5f9h)		;3115	ed 5b f9 f5 	. [ . . 
	ld b,080h		;3119	06 80 	. . 
	ret			;311b	c9 	. 
l311ch:
	ld a,000h		;311c	3e 00 	> . 
	ld (0ef2bh),a		;311e	32 2b ef 	2 + . 
	jr nc,l30b8h		;3121	30 95 	0 . 
	ld hl,0efb2h		;3123	21 b2 ef 	! . . 
	dec (hl)			;3126	35 	5 
	jr nz,l30f9h		;3127	20 d0 	  . 
	jp l30b1h		;3129	c3 b1 30 	. . 0 
sub_312ch:
	ld hl,(0f5f9h)		;312c	2a f9 f5 	* . . 
	ld (hl),0e5h		;312f	36 e5 	6 . 
	push hl			;3131	e5 	. 
	pop de			;3132	d1 	. 
	inc de			;3133	13 	. 
	ld bc,l007fh		;3134	01 7f 00 	.  . 
	ldir		;3137	ed b0 	. . 
	ret			;3139	c9 	. 
l313ah:
	ld a,(0f5e5h)		;313a	3a e5 f5 	: . . 
	push af			;313d	f5 	. 
	ld de,COLDRST		;313e	11 00 00 	. . . 
	cp 001h		;3141	fe 01 	. . 
	jr z,l3146h		;3143	28 01 	( . 
	inc de			;3145	13 	. 
l3146h:
	call sub_31eeh		;3146	cd ee 31 	. . 1 
	push af			;3149	f5 	. 
	call sub_33bch		;314a	cd bc 33 	. . 3 
	jr nc,l3154h		;314d	30 05 	0 . 
	pop af			;314f	f1 	. 
	pop af			;3150	f1 	. 
	jp l30b8h		;3151	c3 b8 30 	. . 0 
l3154h:
	pop af			;3154	f1 	. 
	call sub_331bh		;3155	cd 1b 33 	. . 3 
	ld h,a			;3158	67 	g 
	ld a,b			;3159	78 	x 
	and 07fh		;315a	e6 7f 	.  
	call sub_3374h		;315c	cd 74 33 	. t 3 
	jr nc,l3186h		;315f	30 25 	0 % 
	ld a,b			;3161	78 	x 
	and 080h		;3162	e6 80 	. . 
	pop af			;3164	f1 	. 
	jp z,l30b1h		;3165	ca b1 30 	. . 0 
	ld c,a			;3168	4f 	O 
	ld de,COLDRST		;3169	11 00 00 	. . . 
	cp 001h		;316c	fe 01 	. . 
	jr nz,l3171h		;316e	20 01 	  . 
	inc de			;3170	13 	. 
l3171h:
	call sub_31eeh		;3171	cd ee 31 	. . 1 
	or a			;3174	b7 	. 
	jp nz,l30b1h		;3175	c2 b1 30 	. . 0 
	ld h,a			;3178	67 	g 
	ld a,b			;3179	78 	x 
	and 07fh		;317a	e6 7f 	.  
	call sub_3374h		;317c	cd 74 33 	. t 3 
	jp c,l30b1h		;317f	da b1 30 	. . 0 
	ld a,c			;3182	79 	y 
	xor 003h		;3183	ee 03 	. . 
	push af			;3185	f5 	. 
l3186h:
	ex de,hl			;3186	eb 	. 
	ld c,d			;3187	4a 	J 
	call sub_33ddh		;3188	cd dd 33 	. . 3 
	ld hl,(0efach)		;318b	2a ac ef 	* . . 
	ld de,0dfffh		;318e	11 ff df 	. . . 
	or a			;3191	b7 	. 
	sbc hl,de		;3192	ed 52 	. R 
	jr nc,l319ch		;3194	30 06 	0 . 
	ld a,(0efaeh)		;3196	3a ae ef 	: . . 
	or a			;3199	b7 	. 
	jr z,l31a2h		;319a	28 06 	( . 
l319ch:
	ld a,b			;319c	78 	x 
	and 07fh		;319d	e6 7f 	.  
	call sub_3374h		;319f	cd 74 33 	. t 3 
l31a2h:
	pop af			;31a2	f1 	. 
	push af			;31a3	f5 	. 
	ld hl,(0efach)		;31a4	2a ac ef 	* . . 
	push hl			;31a7	e5 	. 
	ld de,(0f5f9h)		;31a8	ed 5b f9 f5 	. [ . . 
	push de			;31ac	d5 	. 
	ld bc,l007fh+1		;31ad	01 80 00 	. . . 
	call 0ec8eh		;31b0	cd 8e ec 	. . . 
	pop hl			;31b3	e1 	. 
	ld a,(0f316h)		;31b4	3a 16 f3 	: . . 
	or a			;31b7	b7 	. 
	jr z,l31e9h		;31b8	28 2f 	( / 
	ld a,(hl)			;31ba	7e 	~ 
	cp 0ddh		;31bb	fe dd 	. . 
	jr nz,l31e9h		;31bd	20 2a 	  * 
	inc hl			;31bf	23 	# 
	ld a,(hl)			;31c0	7e 	~ 
	cp 0deh		;31c1	fe de 	. . 
	jr nz,l31e9h		;31c3	20 24 	  $ 
	ld (hl),000h		;31c5	36 00 	6 . 
	dec hl			;31c7	2b 	+ 
	ld (hl),000h		;31c8	36 00 	6 . 
	pop hl			;31ca	e1 	. 
	ld de,RBDOS1		;31cb	11 05 00 	. . . 
	ld a,(0ef28h)		;31ce	3a 28 ef 	: ( . 
	or a			;31d1	b7 	. 
	jr z,l31deh		;31d2	28 0a 	( . 
	ld de,l0006h+2		;31d4	11 08 00 	. . . 
	push hl			;31d7	e5 	. 
	push de			;31d8	d5 	. 
	call RSTERR		;31d9	cd 9b 1b 	. . . 
	pop hl			;31dc	e1 	. 
	pop de			;31dd	d1 	. 
l31deh:
	add hl,de			;31de	19 	. 
	ld (0f53bh),hl		;31df	22 3b f5 	" ; . 
	pop af			;31e2	f1 	. 
	ld (0f53ah),a		;31e3	32 3a f5 	2 : . 
	pop af			;31e6	f1 	. 
	xor a			;31e7	af 	. 
	ret			;31e8	c9 	. 
l31e9h:
	pop af			;31e9	f1 	. 
	pop af			;31ea	f1 	. 
	jp l30b8h		;31eb	c3 b8 30 	. . 0 
sub_31eeh:
	ld hl,0ef9eh		;31ee	21 9e ef 	! . . 
	add hl,de			;31f1	19 	. 
	ld a,(hl)			;31f2	7e 	~ 
	ld hl,0ef97h		;31f3	21 97 ef 	! . . 
	add hl,de			;31f6	19 	. 
	ld b,(hl)			;31f7	46 	F 
	ld hl,0efa2h		;31f8	21 a2 ef 	! . . 
l31fbh:
	sla e		;31fb	cb 23 	. # 
	add hl,de			;31fd	19 	. 
	ld e,(hl)			;31fe	5e 	^ 
	inc hl			;31ff	23 	# 
	ld d,(hl)			;3200	56 	V 
	ret			;3201	c9 	. 
	ld a,0afh		;3202	3e af 	> . 
	ld (0efafh),a		;3204	32 af ef 	2 . . 
	ld a,(0f5e6h)		;3207	3a e6 f5 	: . . 
	or a			;320a	b7 	. 
	jr nz,l3222h		;320b	20 15 	  . 
	ld a,(0f5e8h)		;320d	3a e8 f5 	: . . 
	xor 007h		;3210	ee 07 	. . 
	cp 004h		;3212	fe 04 	. . 
	jr nc,l3222h		;3214	30 0c 	0 . 
	call sub_33f7h		;3216	cd f7 33 	. . 3 
	jp z,l30b1h		;3219	ca b1 30 	. . 0 
	call sub_312ch		;321c	cd 2c 31 	. , 1 
	jp l30b8h		;321f	c3 b8 30 	. . 0 
l3222h:
	xor a			;3222	af 	. 
	call sub_331bh		;3223	cd 1b 33 	. . 3 
l3226h:
	ld a,(0ef9bh)		;3226	3a 9b ef 	: . . 
	call sub_3374h		;3229	cd 74 33 	. t 3 
	jp c,l30b1h		;322c	da b1 30 	. . 0 
	ld a,003h		;322f	3e 03 	> . 
	ld (0efb2h),a		;3231	32 b2 ef 	2 . . 
l3234h:
	ld hl,l324eh		;3234	21 4e 32 	! N 2 
	push hl			;3237	e5 	. 
	ld hl,l4672h		;3238	21 72 46 	! r F 
	call sub_33f7h		;323b	cd f7 33 	. . 3 
l323eh:
	jr nz,l3243h		;323e	20 03 	  . 
	ld hl,l467ah		;3240	21 7a 46 	! z F 
l3243h:
	push hl			;3243	e5 	. 
	ld hl,(0efach)		;3244	2a ac ef 	* . . 
	ld de,(0f5f9h)		;3247	ed 5b f9 f5 	. [ . . 
	ld b,080h		;324b	06 80 	. . 
	ret			;324d	c9 	. 
l324eh:
	jr nc,l3259h		;324e	30 09 	0 . 
	ld hl,0efb2h		;3250	21 b2 ef 	! . . 
	dec (hl)			;3253	35 	5 
	jr nz,l3234h		;3254	20 de 	  . 
	jp l30b1h		;3256	c3 b1 30 	. . 0 
l3259h:
	call sub_3398h		;3259	cd 98 33 	. . 3 
	ld de,00200h		;325c	11 00 02 	. . . 
	add hl,de			;325f	19 	. 
	ld (0efb0h),a		;3260	32 b0 ef 	2 . . 
	ld (0efb1h),a		;3263	32 b1 ef 	2 . . 
	ld a,003h		;3266	3e 03 	> . 
	ld (0efb2h),a		;3268	32 b2 ef 	2 . . 
l326bh:
	push hl			;326b	e5 	. 
	ld de,l3282h		;326c	11 82 32 	. . 2 
	push de			;326f	d5 	. 
	ld de,l4672h		;3270	11 72 46 	. r F 
	call sub_33f7h		;3273	cd f7 33 	. . 3 
	jr nz,l327bh		;3276	20 03 	  . 
	ld de,l467ah		;3278	11 7a 46 	. z F 
l327bh:
	push de			;327b	d5 	. 
	ld de,0efb0h		;327c	11 b0 ef 	. . . 
	ld b,001h		;327f	06 01 	. . 
	ret			;3281	c9 	. 
l3282h:
	jr nc,l328eh		;3282	30 0a 	0 . 
	ld hl,0efb2h		;3284	21 b2 ef 	! . . 
	dec (hl)			;3287	35 	5 
	pop hl			;3288	e1 	. 
	jr nz,l326bh		;3289	20 e0 	  . 
	jp l30b1h		;328b	c3 b1 30 	. . 0 
l328eh:
	pop hl			;328e	e1 	. 
	call sub_33f7h		;328f	cd f7 33 	. . 3 
	jp z,l30b8h		;3292	ca b8 30 	. . 0 
	ld hl,0efb0h		;3295	21 b0 ef 	! . . 
	ld a,(hl)			;3298	7e 	~ 
	inc hl			;3299	23 	# 
	cp (hl)			;329a	be 	. 
	jp nz,l30b1h		;329b	c2 b1 30 	. . 0 
	jp l30b8h		;329e	c3 b8 30 	. . 0 
l32a1h:
	ld a,(0f5e5h)		;32a1	3a e5 f5 	: . . 
	push af			;32a4	f5 	. 
	ld de,COLDRST		;32a5	11 00 00 	. . . 
	cp 009h		;32a8	fe 09 	. . 
	jr z,l32adh		;32aa	28 01 	( . 
	inc de			;32ac	13 	. 
l32adh:
	call sub_330bh		;32ad	cd 0b 33 	. . 3 
	push af			;32b0	f5 	. 
	call sub_33bch		;32b1	cd bc 33 	. . 3 
	jr nc,l32bbh		;32b4	30 05 	0 . 
	pop af			;32b6	f1 	. 
	pop af			;32b7	f1 	. 
	jp l30b8h		;32b8	c3 b8 30 	. . 0 
l32bbh:
	pop af			;32bb	f1 	. 
	call sub_331bh		;32bc	cd 1b 33 	. . 3 
	ld h,a			;32bf	67 	g 
	ld a,b			;32c0	78 	x 
	and 07fh		;32c1	e6 7f 	.  
	call sub_3374h		;32c3	cd 74 33 	. t 3 
	jr nc,l32e9h		;32c6	30 21 	0 ! 
	ld a,b			;32c8	78 	x 
	and 080h		;32c9	e6 80 	. . 
	pop af			;32cb	f1 	. 
	jp z,l30b1h		;32cc	ca b1 30 	. . 0 
	ld de,COLDRST		;32cf	11 00 00 	. . . 
	cp 009h		;32d2	fe 09 	. . 
	jr nz,l32d7h		;32d4	20 01 	  . 
	inc de			;32d6	13 	. 
l32d7h:
	call sub_330bh		;32d7	cd 0b 33 	. . 3 
	or a			;32da	b7 	. 
	jp nz,l30b1h		;32db	c2 b1 30 	. . 0 
	ld h,a			;32de	67 	g 
	ld a,b			;32df	78 	x 
	and 07fh		;32e0	e6 7f 	.  
	call sub_3374h		;32e2	cd 74 33 	. t 3 
	jp c,l30b1h		;32e5	da b1 30 	. . 0 
	push af			;32e8	f5 	. 
l32e9h:
	pop af			;32e9	f1 	. 
	ex de,hl			;32ea	eb 	. 
	call sub_33ddh		;32eb	cd dd 33 	. . 3 
	ld a,003h		;32ee	3e 03 	> . 
	ld (0efb2h),a		;32f0	32 b2 ef 	2 . . 
l32f3h:
	ld hl,(0efach)		;32f3	2a ac ef 	* . . 
	ld de,(0f5f9h)		;32f6	ed 5b f9 f5 	. [ . . 
	ld b,080h		;32fa	06 80 	. . 
	call 04675h		;32fc	cd 75 46 	. u F 
	jp nc,l30b8h		;32ff	d2 b8 30 	. . 0 
	ld hl,0efb2h		;3302	21 b2 ef 	! . . 
	dec (hl)			;3305	35 	5 
	jr nz,l32f3h		;3306	20 eb 	  . 
	jp l30b1h		;3308	c3 b1 30 	. . 0 
sub_330bh:
	ld hl,0efa0h		;330b	21 a0 ef 	! . . 
	add hl,de			;330e	19 	. 
	ld a,(hl)			;330f	7e 	~ 
	ld hl,0ef99h		;3310	21 99 ef 	! . . 
	add hl,de			;3313	19 	. 
	ld b,(hl)			;3314	46 	F 
	ld hl,0efa6h		;3315	21 a6 ef 	! . . 
	jp l31fbh		;3318	c3 fb 31 	. . 1 
sub_331bh:
	push af			;331b	f5 	. 
	push bc			;331c	c5 	. 
	push de			;331d	d5 	. 
	push hl			;331e	e5 	. 
	ld hl,COLDRST		;331f	21 00 00 	! . . 
	or a			;3322	b7 	. 
l3323h:
	jr z,l333ch		;3323	28 17 	( . 
	ld b,a			;3325	47 	G 
	ld a,(0f5e6h)		;3326	3a e6 f5 	: . . 
	or a			;3329	b7 	. 
	jr nz,l3333h		;332a	20 07 	  . 
	ld a,(0f5e8h)		;332c	3a e8 f5 	: . . 
	cp 008h		;332f	fe 08 	. . 
	jr c,l333ch		;3331	38 09 	8 . 
l3333h:
	ld a,020h		;3333	3e 20 	>   
	sub b			;3335	90 	. 
l3336h:
	ld l,a			;3336	6f 	o 
	ld b,005h		;3337	06 05 	. . 
	call sub_33f0h		;3339	cd f0 33 	. . 3 
l333ch:
	push hl			;333c	e5 	. 
	ld hl,(0f5e6h)		;333d	2a e6 f5 	* . . 
	ld h,000h		;3340	26 00 	& . 
	ld b,006h		;3342	06 06 	. . 
	call sub_33f0h		;3344	cd f0 33 	. . 3 
	ex de,hl			;3347	eb 	. 
	ld hl,(0f5e8h)		;3348	2a e8 f5 	* . . 
	ld h,000h		;334b	26 00 	& . 
	add hl,de			;334d	19 	. 
	ex de,hl			;334e	eb 	. 
	ld hl,COLDRST		;334f	21 00 00 	! . . 
	ld b,007h		;3352	06 07 	. . 
l3354h:
	sla e		;3354	cb 23 	. # 
	rl d		;3356	cb 12 	. . 
	rl l		;3358	cb 15 	. . 
	rl h		;335a	cb 14 	. . 
	djnz l3354h		;335c	10 f6 	. . 
	pop bc			;335e	c1 	. 
	ex de,hl			;335f	eb 	. 
	or a			;3360	b7 	. 
	sbc hl,bc		;3361	ed 42 	. B 
	ex de,hl			;3363	eb 	. 
	ld bc,COLDRST		;3364	01 00 00 	. . . 
	sbc hl,bc		;3367	ed 42 	. B 
	ld (0efach),de		;3369	ed 53 ac ef 	. S . . 
	ld a,l			;336d	7d 	} 
	ld (0efaeh),a		;336e	32 ae ef 	2 . . 
	jp l3602h		;3371	c3 02 36 	. . 6 
sub_3374h:
	push bc			;3374	c5 	. 
	push de			;3375	d5 	. 
	push hl			;3376	e5 	. 
	ld l,a			;3377	6f 	o 
	ld h,000h		;3378	26 00 	& . 
	ld b,002h		;337a	06 02 	. . 
	call sub_33f0h		;337c	cd f0 33 	. . 3 
	push hl			;337f	e5 	. 
	pop bc			;3380	c1 	. 
	ld de,(0efadh)		;3381	ed 5b ad ef 	. [ . . 
	or a			;3385	b7 	. 
	sbc hl,de		;3386	ed 52 	. R 
	jr z,l338ch		;3388	28 02 	( . 
	jr nc,l3394h		;338a	30 08 	0 . 
l338ch:
	ex de,hl			;338c	eb 	. 
	or a			;338d	b7 	. 
	sbc hl,bc		;338e	ed 42 	. B 
	ld (0efadh),hl		;3390	22 ad ef 	" . . 
	scf			;3393	37 	7 
l3394h:
	pop hl			;3394	e1 	. 
	pop de			;3395	d1 	. 
	pop bc			;3396	c1 	. 
	ret			;3397	c9 	. 
sub_3398h:
	push bc			;3398	c5 	. 
	push de			;3399	d5 	. 
	ld hl,(0f5e6h)		;339a	2a e6 f5 	* . . 
	ld h,000h		;339d	26 00 	& . 
	ld b,006h		;339f	06 06 	. . 
	call sub_33f0h		;33a1	cd f0 33 	. . 3 
	ld a,(0f5e8h)		;33a4	3a e8 f5 	: . . 
	ld c,a			;33a7	4f 	O 
	ld b,000h		;33a8	06 00 	. . 
	add hl,bc			;33aa	09 	. 
	push hl			;33ab	e5 	. 
	xor a			;33ac	af 	. 
	ld hl,(0f5f9h)		;33ad	2a f9 f5 	* . . 
	ld de,l007fh+1		;33b0	11 80 00 	. . . 
	ld b,e			;33b3	43 	C 
	add hl,de			;33b4	19 	. 
l33b5h:
	dec hl			;33b5	2b 	+ 
	xor (hl)			;33b6	ae 	. 
	rlca			;33b7	07 	. 
	djnz l33b5h		;33b8	10 fb 	. . 
	jr l3394h		;33ba	18 d8 	. . 
sub_33bch:
	push bc			;33bc	c5 	. 
	push de			;33bd	d5 	. 
	push hl			;33be	e5 	. 
	ld e,a			;33bf	5f 	_ 
	ld a,(0f5e6h)		;33c0	3a e6 f5 	: . . 
	or a			;33c3	b7 	. 
	jr nz,l3394h		;33c4	20 ce 	  . 
	ld a,(0f5e8h)		;33c6	3a e8 f5 	: . . 
	cp 008h		;33c9	fe 08 	. . 
	jr nc,l3394h		;33cb	30 c7 	0 . 
	ld b,a			;33cd	47 	G 
	ld a,e			;33ce	7b 	{ 
	srl a		;33cf	cb 3f 	. ? 
	srl a		;33d1	cb 3f 	. ? 
	dec a			;33d3	3d 	= 
	cp b			;33d4	b8 	. 
	jr nc,l3394h		;33d5	30 bd 	0 . 
	call sub_312ch		;33d7	cd 2c 31 	. , 1 
	scf			;33da	37 	7 
	jr l3394h		;33db	18 b7 	. . 
sub_33ddh:
	push de			;33dd	d5 	. 
	ld de,(0efach)		;33de	ed 5b ac ef 	. [ . . 
	or a			;33e2	b7 	. 
	adc hl,de		;33e3	ed 5a 	. Z 
	ld (0efach),hl		;33e5	22 ac ef 	" . . 
	jr nc,l33eeh		;33e8	30 04 	0 . 
	ld hl,0efaeh		;33ea	21 ae ef 	! . . 
	inc (hl)			;33ed	34 	4 
l33eeh:
	pop de			;33ee	d1 	. 
	ret			;33ef	c9 	. 
sub_33f0h:
	sla l		;33f0	cb 25 	. % 
	rl h		;33f2	cb 14 	. . 
	djnz sub_33f0h		;33f4	10 fa 	. . 
	ret			;33f6	c9 	. 
sub_33f7h:
	ld a,(0efafh)		;33f7	3a af ef 	: . . 
	or a			;33fa	b7 	. 
	ret			;33fb	c9 	. 
sub_33fch:
	ld hl,COLDRST		;33fc	21 00 00 	! . . 
	ld (0ef97h),hl		;33ff	22 97 ef 	" . . 
	ld (0ef9eh),hl		;3402	22 9e ef 	" . . 
	ld (0efa2h),hl		;3405	22 a2 ef 	" . . 
	ld (0efa4h),hl		;3408	22 a4 ef 	" . . 
	ld a,0a0h		;340b	3e a0 	> . 
	ld (0f532h),a		;340d	32 32 f5 	2 2 . 
	ld a,001h		;3410	3e 01 	> . 
	call sub_341ch		;3412	cd 1c 34 	. . 4 
	ld a,0e0h		;3415	3e e0 	> . 
	ld (0f533h),a		;3417	32 33 f5 	2 3 . 
	ld a,002h		;341a	3e 02 	> . 
sub_341ch:
	push af			;341c	f5 	. 
	ld hl,06000h		;341d	21 00 60 	! . ` 
	call sub_3494h		;3420	cd 94 34 	. . 4 
	jr nc,l3444h		;3423	30 1f 	0 . 
	ld b,a			;3425	47 	G 
	ld a,(0f93ch)		;3426	3a 3c f9 	: < . 
	and 07fh		;3429	e6 7f 	.  
	cp 008h		;342b	fe 08 	. . 
	jr z,l343fh		;342d	28 10 	( . 
	ld c,a			;342f	4f 	O 
	ld a,b			;3430	78 	x 
	cp 050h		;3431	fe 50 	. P 
l3433h:
	jr nz,l3444h		;3433	20 0f 	  . 
	ld a,c			;3435	79 	y 
	cp 010h		;3436	fe 10 	. . 
	jr nz,l3442h		;3438	20 08 	  . 
	ld hl,0a000h		;343a	21 00 a0 	! . . 
	jr l345dh		;343d	18 1e 	. . 
l343fh:
	ld hl,0c000h		;343f	21 00 c0 	! . . 
l3442h:
	jr l345dh		;3442	18 19 	. . 
l3444h:
	ld hl,0c000h		;3444	21 00 c0 	! . . 
	pop af			;3447	f1 	. 
	push af			;3448	f5 	. 
	call sub_3494h		;3449	cd 94 34 	. . 4 
	jr nc,l345bh		;344c	30 0d 	0 . 
	cp 04dh		;344e	fe 4d 	. M 
	jr nz,l345bh		;3450	20 09 	  . 
	ld a,(0f93ch)		;3452	3a 3c f9 	: < . 
	and 07fh		;3455	e6 7f 	.  
	cp 008h		;3457	fe 08 	. . 
	jr nz,l3442h		;3459	20 e7 	  . 
l345bh:
	pop af			;345b	f1 	. 
	ret			;345c	c9 	. 
l345dh:
	pop af			;345d	f1 	. 
	ld d,000h		;345e	16 00 	. . 
	ld e,a			;3460	5f 	_ 
	ld c,h			;3461	4c 	L 
	ld a,(0f93ch)		;3462	3a 3c f9 	: < . 
	ld b,a			;3465	47 	G 
	ld a,(0f950h)		;3466	3a 50 f9 	: P . 
	call sub_3482h		;3469	cd 82 34 	. . 4 
	ld a,b			;346c	78 	x 
	and 080h		;346d	e6 80 	. . 
	ret z			;346f	c8 	. 
	ld a,e			;3470	7b 	{ 
	srl a		;3471	cb 3f 	. ? 
	xor 003h		;3473	ee 03 	. . 
	ld e,a			;3475	5f 	_ 
	ld hl,0ef9dh		;3476	21 9d ef 	! . . 
	add hl,de			;3479	19 	. 
	ld a,(hl)			;347a	7e 	~ 
	or a			;347b	b7 	. 
	ret nz			;347c	c0 	. 
	ld a,b			;347d	78 	x 
	and 07fh		;347e	e6 7f 	.  
	ld b,a			;3480	47 	G 
	xor a			;3481	af 	. 
sub_3482h:
	ld hl,0ef9dh		;3482	21 9d ef 	! . . 
	add hl,de			;3485	19 	. 
	ld (hl),a			;3486	77 	w 
	ld hl,0ef96h		;3487	21 96 ef 	! . . 
	add hl,de			;348a	19 	. 
	ld (hl),b			;348b	70 	p 
	sla e		;348c	cb 23 	. # 
	ld hl,0efa1h		;348e	21 a1 ef 	! . . 
	add hl,de			;3491	19 	. 
	ld (hl),c			;3492	71 	q 
	ret			;3493	c9 	. 
sub_3494h:
	push bc			;3494	c5 	. 
	push hl			;3495	e5 	. 
	ld de,0f93ah		;3496	11 3a f9 	. : . 
	ld bc,l001eh+2		;3499	01 20 00 	.   . 
	call 0ec8eh		;349c	cd 8e ec 	. . . 
l349fh:
	ld a,(0f93ah)		;349f	3a 3a f9 	: : . 
	cp 0e5h		;34a2	fe e5 	. . 
	jr nz,l34d0h		;34a4	20 2a 	  * 
	ld a,(0f950h)		;34a6	3a 50 f9 	: P . 
	or a			;34a9	b7 	. 
	jr z,l34d0h		;34aa	28 24 	( $ 
	cp 021h		;34ac	fe 21 	. ! 
	jr nc,l34d0h		;34ae	30 20 	0   
	and 003h		;34b0	e6 03 	. . 
	jr nz,l34d0h		;34b2	20 1c 	  . 
	ld a,(0f93ch)		;34b4	3a 3c f9 	: < . 
	and 07fh		;34b7	e6 7f 	.  
	cp 008h		;34b9	fe 08 	. . 
	jr z,l34c5h		;34bb	28 08 	( . 
	cp 010h		;34bd	fe 10 	. . 
	jr z,l34c5h		;34bf	28 04 	( . 
	cp 020h		;34c1	fe 20 	.   
	jr nz,l34d0h		;34c3	20 0b 	  . 
l34c5h:
	ld a,(0f93bh)		;34c5	3a 3b f9 	: ; . 
	cp 050h		;34c8	fe 50 	. P 
	jr z,l34d3h		;34ca	28 07 	( . 
	cp 037h		;34cc	fe 37 	. 7 
	jr z,$+8		;34ce	28 06 	( . 
l34d0h:
	or a			;34d0	b7 	. 
	jr l34d9h		;34d1	18 06 	. . 
l34d3h:
	ld a,050h		;34d3	3e 50 	> P 
	ld hl,04d3eh		;34d5	21 3e 4d 	! > M 
	scf			;34d8	37 	7 
l34d9h:
	pop hl			;34d9	e1 	. 
	pop bc			;34da	c1 	. 
	ret			;34db	c9 	. 
sub_34dch:
	ld hl,COLDRST		;34dc	21 00 00 	! . . 
	ld (0ef99h),hl		;34df	22 99 ef 	" . . 
	ld (0efa0h),hl		;34e2	22 a0 ef 	" . . 
	ld (0efa6h),hl		;34e5	22 a6 ef 	" . . 
	ld hl,08000h		;34e8	21 00 80 	! . . 
	ld (0efa8h),hl		;34eb	22 a8 ef 	" . . 
	call CHKMOD		;34ee	cd 11 46 	. . F 
	cp 001h		;34f1	fe 01 	. . 
	ret nz			;34f3	c0 	. 
	ld hl,COLDRST		;34f4	21 00 00 	! . . 
	call sub_353dh		;34f7	cd 3d 35 	. = 5 
	jr nc,l3517h		;34fa	30 1b 	0 . 
	cp 04dh		;34fc	fe 4d 	. M 
	jr nz,l3517h		;34fe	20 17 	  . 
	ld a,(0f950h)		;3500	3a 50 f9 	: P . 
	ld (0efa0h),a		;3503	32 a0 ef 	2 . . 
	ld a,(0f93ch)		;3506	3a 3c f9 	: < . 
l3509h:
	ld (0ef99h),a		;3509	32 99 ef 	2 . . 
	ld b,a			;350c	47 	G 
	and 080h		;350d	e6 80 	. . 
	jr z,l3517h		;350f	28 06 	( . 
	ld a,b			;3511	78 	x 
	and 07fh		;3512	e6 7f 	.  
	ld (0ef9ah),a		;3514	32 9a ef 	2 . . 
l3517h:
	ld hl,08000h		;3517	21 00 80 	! . . 
	call sub_353dh		;351a	cd 3d 35 	. = 5 
	ret nc			;351d	d0 	. 
	cp 04dh		;351e	fe 4d 	. M 
	ret nz			;3520	c0 	. 
	ld a,(0f950h)		;3521	3a 50 f9 	: P . 
	ld (0efa1h),a		;3524	32 a1 ef 	2 . . 
	ld a,(0f93ch)		;3527	3a 3c f9 	: < . 
	ld (0ef9ah),a		;352a	32 9a ef 	2 . . 
	ld b,a			;352d	47 	G 
	and 080h		;352e	e6 80 	. . 
	ret z			;3530	c8 	. 
	ld a,(0ef99h)		;3531	3a 99 ef 	: . . 
	or a			;3534	b7 	. 
	ret nz			;3535	c0 	. 
	ld a,b			;3536	78 	x 
	and 07fh		;3537	e6 7f 	.  
	ld (0ef99h),a		;3539	32 99 ef 	2 . . 
	ret			;353c	c9 	. 
sub_353dh:
	push bc			;353d	c5 	. 
	push hl			;353e	e5 	. 
	ld de,0f93ah		;353f	11 3a f9 	. : . 
	ld bc,l0015h+2		;3542	01 17 00 	. . . 
	call 04675h		;3545	cd 75 46 	. u F 
	jp l349fh		;3548	c3 9f 34 	. . 4 
sub_354bh:
	push af			;354b	f5 	. 
	ld a,000h		;354c	3e 00 	> . 
	ld (0ef9bh),a		;354e	32 9b ef 	2 . . 
	call CHKMOD		;3551	cd 11 46 	. . F 
	cp 002h		;3554	fe 02 	. . 
	jr nz,l3595h		;3556	20 3d 	  = 
	ld hl,04000h		;3558	21 00 40 	! . @ 
	ld de,0f93ah		;355b	11 3a f9 	. : . 
	ld b,001h		;355e	06 01 	. . 
	ld c,002h		;3560	0e 02 	. . 
l3562h:
	call sub_35f2h		;3562	cd f2 35 	. . 5 
	ld a,(0f93ah)		;3565	3a 3a f9 	: : . 
	inc a			;3568	3c 	< 
	ld (0f93bh),a		;3569	32 3b f9 	2 ; . 
	inc de			;356c	13 	. 
	call sub_35fbh		;356d	cd fb 35 	. . 5 
	call sub_35f2h		;3570	cd f2 35 	. . 5 
	ex de,hl			;3573	eb 	. 
	cp (hl)			;3574	be 	. 
	jr nz,l3581h		;3575	20 0a 	  . 
	ex de,hl			;3577	eb 	. 
	dec de			;3578	1b 	. 
	call sub_35fbh		;3579	cd fb 35 	. . 5 
	sla h		;357c	cb 24 	. $ 
	dec c			;357e	0d 	. 
	jr nz,l3562h		;357f	20 e1 	  . 
l3581h:
	ld a,006h		;3581	3e 06 	> . 
	sub c			;3583	91 	. 
	ld b,a			;3584	47 	G 
	ld a,001h		;3585	3e 01 	> . 
l3587h:
	sla a		;3587	cb 27 	. ' 
	djnz l3587h		;3589	10 fc 	. . 
	ld (0ef9bh),a		;358b	32 9b ef 	2 . . 
	pop af			;358e	f1 	. 
	push af			;358f	f5 	. 
	jr nc,l3595h		;3590	30 03 	0 . 
	call RAMCRFMT		;3592	cd 97 35 	. . 5 
l3595h:
	pop af			;3595	f1 	. 
	ret			;3596	c9 	. 
RAMCRFMT:
	ld a,(CRGDEV)		;3597	3a 3f f5 	: ? . 
	cp 002h		;359a	fe 02 	. . 
	ret nz			;359c	c0 	. 
	ld a,(0ef9bh)		;359d	3a 9b ef 	: . . 
	or a			;35a0	b7 	. 
	ret z			;35a1	c8 	. 
	ld e,0e5h		;35a2	1e e5 	. . 
	ld hl,COLDRST		;35a4	21 00 00 	! . . 
	cp 040h		;35a7	fe 40 	. @ 
	call z,sub_35bdh		;35a9	cc bd 35 	. . 5 
	cp 020h		;35ac	fe 20 	.   
	call z,sub_35c0h		;35ae	cc c0 35 	. . 5 
	cp 010h		;35b1	fe 10 	. . 
	call z,sub_35c3h		;35b3	cc c3 35 	. . 5 
	ld e,000h		;35b6	1e 00 	. . 
	ld hl,00200h		;35b8	21 00 02 	! . . 
	jr l35c7h		;35bb	18 0a 	. . 
sub_35bdh:
	call sub_35c0h		;35bd	cd c0 35 	. . 5 
sub_35c0h:
	call sub_35c3h		;35c0	cd c3 35 	. . 5 
sub_35c3h:
	ld b,040h		;35c3	06 40 	. @ 
	jr l35cbh		;35c5	18 04 	. . 
l35c7h:
	ld b,002h		;35c7	06 02 	. . 
	jr l35cbh		;35c9	18 00 	. . 
l35cbh:
	push af			;35cb	f5 	. 
l35cch:
	ld d,b			;35cc	50 	P 
	ld a,(0f006h)		;35cd	3a 06 f0 	: . . 
	bit 3,a		;35d0	cb 5f 	. _ 
	jr nz,l35deh		;35d2	20 0a 	  . 
	set 3,a		;35d4	cb df 	. . 
	ld (0f006h),a		;35d6	32 06 f0 	2 . . 
	out (019h),a		;35d9	d3 19 	. . 
	call sub_45ffh		;35db	cd ff 45 	. . E 
l35deh:
	ld b,000h		;35de	06 00 	. . 
	ld c,012h		;35e0	0e 12 	. . 
l35e2h:
	ld a,h			;35e2	7c 	| 
	out (011h),a		;35e3	d3 11 	. . 
	ld a,l			;35e5	7d 	} 
	out (010h),a		;35e6	d3 10 	. . 
	out (c),e		;35e8	ed 59 	. Y 
	inc hl			;35ea	23 	# 
	djnz l35e2h		;35eb	10 f5 	. . 
	ld b,d			;35ed	42 	B 
	djnz l35cch		;35ee	10 dc 	. . 
	pop af			;35f0	f1 	. 
	ret			;35f1	c9 	. 
sub_35f2h:
	push af			;35f2	f5 	. 
	push bc			;35f3	c5 	. 
	push de			;35f4	d5 	. 
	push hl			;35f5	e5 	. 
	call l4672h		;35f6	cd 72 46 	. r F 
	jr l3602h		;35f9	18 07 	. . 
sub_35fbh:
	push af			;35fb	f5 	. 
	push bc			;35fc	c5 	. 
	push de			;35fd	d5 	. 
	push hl			;35fe	e5 	. 
	call l467ah		;35ff	cd 7a 46 	. z F 
l3602h:
	pop hl			;3602	e1 	. 
	pop de			;3603	d1 	. 
	pop bc			;3604	c1 	. 
	pop af			;3605	f1 	. 
	ret			;3606	c9 	. 
sub_3607h:
	call RAMCRFMT		;3607	cd 97 35 	. . 5 
	ld a,008h		;360a	3e 08 	> . 
sub_360ch:
	ld hl,0f0ffh		;360c	21 ff f0 	! . . 
	ld de,l0001h		;360f	11 01 00 	. . . 
	ld b,00bh		;3612	06 0b 	. . 
l3614h:
	cp (hl)			;3614	be 	. 
	jr z,l361dh		;3615	28 06 	( . 
	inc hl			;3617	23 	# 
	ex de,hl			;3618	eb 	. 
	add hl,hl			;3619	29 	) 
	ex de,hl			;361a	eb 	. 
	djnz l3614h		;361b	10 f7 	. . 
l361dh:
	ld hl,(0f321h)		;361d	2a 21 f3 	* ! . 
	ld a,e			;3620	7b 	{ 
	cpl			;3621	2f 	/ 
	and l			;3622	a5 	. 
	ld l,a			;3623	6f 	o 
	ld a,d			;3624	7a 	z 
	and 007h		;3625	e6 07 	. . 
	cpl			;3627	2f 	/ 
	and h			;3628	a4 	. 
	ld h,a			;3629	67 	g 
	ld (0f321h),hl		;362a	22 21 f3 	" ! . 
	ret			;362d	c9 	. 
RAMDKMNT:
	push af			;362e	f5 	. 
	ld hl,(0efaah)		;362f	2a aa ef 	* . . 
l3632h:
	ld (0efb4h),hl		;3632	22 b4 ef 	" . . 
l3635h:
	ld a,(0ef9ch)		;3635	3a 9c ef 	: . . 
	ld (0efb3h),a		;3638	32 b3 ef 	2 . . 
	ld hl,COLDRST		;363b	21 00 00 	! . . 
	ld (0efaah),hl		;363e	22 aa ef 	" . . 
	ld (0ef9ch),hl		;3641	22 9c ef 	" . . 
	call sub_4789h		;3644	cd 89 47 	. . G 
	jp nc,l36d7h		;3647	d2 d7 36 	. . 6 
	pop af			;364a	f1 	. 
	push af			;364b	f5 	. 
	or a			;364c	b7 	. 
	jp z,l36d4h		;364d	ca d4 36 	. . 6 
	ld l,a			;3650	6f 	o 
	ld b,00ah		;3651	06 0a 	. . 
	call sub_33f0h		;3653	cd f0 33 	. . 3 
	ld de,(0ef94h)		;3656	ed 5b 94 ef 	. [ . . 
	ex de,hl			;365a	eb 	. 
	or a			;365b	b7 	. 
	sbc hl,de		;365c	ed 52 	. R 
	ld (0efaah),hl		;365e	22 aa ef 	" . . 
	ld (0ef9ch),a		;3661	32 9c ef 	2 . . 
	ld b,a			;3664	47 	G 
	pop af			;3665	f1 	. 
	ld a,b			;3666	78 	x 
	push af			;3667	f5 	. 
	jr c,l36b9h		;3668	38 4f 	8 O 
	ld a,(0efb3h)		;366a	3a b3 ef 	: . . 
	ld b,a			;366d	47 	G 
	ld a,(0ef9ch)		;366e	3a 9c ef 	: . . 
	or a			;3671	b7 	. 
	jr z,l36d4h		;3672	28 60 	( ` 
	cp b			;3674	b8 	. 
	jr c,l36b9h		;3675	38 42 	8 B 
	ld a,b			;3677	78 	x 
	or a			;3678	b7 	. 
	jr z,l36b9h		;3679	28 3e 	( > 
	ex de,hl			;367b	eb 	. 
	ld l,b			;367c	68 	h 
	ld h,000h		;367d	26 00 	& . 
	ld b,00ah		;367f	06 0a 	. . 
	call sub_33f0h		;3681	cd f0 33 	. . 3 
	ld b,h			;3684	44 	D 
	ld c,l			;3685	4d 	M 
	ld hl,(0efb4h)		;3686	2a b4 ef 	* . . 
	push hl			;3689	e5 	. 
	or a			;368a	b7 	. 
	sbc hl,de		;368b	ed 52 	. R 
	pop hl			;368d	e1 	. 
	jr nz,l3693h		;368e	20 03 	  . 
	add hl,bc			;3690	09 	. 
	jr l36a6h		;3691	18 13 	. . 
l3693h:
	jr c,l369bh		;3693	38 06 	8 . 
	call 0ec88h		;3695	cd 88 ec 	. . . 
	ex de,hl			;3698	eb 	. 
	jr l36a6h		;3699	18 0b 	. . 
l369bh:
	add hl,bc			;369b	09 	. 
	dec hl			;369c	2b 	+ 
	ex de,hl			;369d	eb 	. 
	add hl,bc			;369e	09 	. 
	ex de,hl			;369f	eb 	. 
	push de			;36a0	d5 	. 
	dec de			;36a1	1b 	. 
	call 0ec82h		;36a2	cd 82 ec 	. . . 
	pop hl			;36a5	e1 	. 
l36a6h:
	ld de,(0ef94h)		;36a6	ed 5b 94 ef 	. [ . . 
	push hl			;36aa	e5 	. 
	or a			;36ab	b7 	. 
	sbc hl,de		;36ac	ed 52 	. R 
	pop hl			;36ae	e1 	. 
	jr z,l36d4h		;36af	28 23 	( # 
	dec de			;36b1	1b 	. 
	ld a,0e5h		;36b2	3e e5 	> . 
	call sub_3704h		;36b4	cd 04 37 	. . 7 
	jr l36d4h		;36b7	18 1b 	. . 
l36b9h:
	ld de,(0ef94h)		;36b9	ed 5b 94 ef 	. [ . . 
	dec de			;36bd	1b 	. 
	ld a,0e5h		;36be	3e e5 	> . 
	call sub_3704h		;36c0	cd 04 37 	. . 7 
	ld hl,(0efaah)		;36c3	2a aa ef 	* . . 
	ld de,00200h		;36c6	11 00 02 	. . . 
	add hl,de			;36c9	19 	. 
	push hl			;36ca	e5 	. 
	add hl,de			;36cb	19 	. 
	dec hl			;36cc	2b 	+ 
	ex de,hl			;36cd	eb 	. 
	pop hl			;36ce	e1 	. 
	ld a,000h		;36cf	3e 00 	> . 
	call sub_3704h		;36d1	cd 04 37 	. . 7 
l36d4h:
	pop af			;36d4	f1 	. 
	scf			;36d5	37 	7 
	ret			;36d6	c9 	. 
l36d7h:
	ld b,040h		;36d7	06 40 	. @ 
	and 008h		;36d9	e6 08 	. . 
	jr z,l36dfh		;36db	28 02 	( . 
	ld b,080h		;36dd	06 80 	. . 
l36dfh:
	ld a,b			;36df	78 	x 
	ld (0ef9dh),a		;36e0	32 9d ef 	2 . . 
	pop bc			;36e3	c1 	. 
	or a			;36e4	b7 	. 
	push af			;36e5	f5 	. 
	push bc			;36e6	c5 	. 
	pop af			;36e7	f1 	. 
	jr nc,l3702h		;36e8	30 18 	0 . 
	ld a,0e5h		;36ea	3e e5 	> . 
	ld hl,COLDRST		;36ec	21 00 00 	! . . 
	ld c,000h		;36ef	0e 00 	. . 
	call sub_3713h		;36f1	cd 13 37 	. . 7 
	ld a,(0ef9dh)		;36f4	3a 9d ef 	: . . 
	cp 080h		;36f7	fe 80 	. . 
	jr nz,l3702h		;36f9	20 07 	  . 
	ld a,0e5h		;36fb	3e e5 	> . 
	ld c,001h		;36fd	0e 01 	. . 
	call sub_3713h		;36ff	cd 13 37 	. . 7 
l3702h:
	pop af			;3702	f1 	. 
	ret			;3703	c9 	. 
sub_3704h:
	call 0ec76h		;3704	cd 76 ec 	. v . 
	ex de,hl			;3707	eb 	. 
	or a			;3708	b7 	. 
	sbc hl,de		;3709	ed 52 	. R 
	push hl			;370b	e5 	. 
	pop bc			;370c	c1 	. 
	push de			;370d	d5 	. 
	pop hl			;370e	e1 	. 
	inc de			;370f	13 	. 
	jp 0ec88h		;3710	c3 88 ec 	. . . 
sub_3713h:
	ld b,000h		;3713	06 00 	. . 
l3715h:
	ld d,b			;3715	50 	P 
	ld b,a			;3716	47 	G 
	ld a,002h		;3717	3e 02 	> . 
	call sub_4787h		;3719	cd 87 47 	. . G 
	ret c			;371c	d8 	. 
	ld a,l			;371d	7d 	} 
	out (090h),a		;371e	d3 90 	. . 
	ld a,h			;3720	7c 	| 
	out (091h),a		;3721	d3 91 	. . 
	ld a,c			;3723	79 	y 
	out (092h),a		;3724	d3 92 	. . 
	ld a,b			;3726	78 	x 
	ld b,000h		;3727	06 00 	. . 
l3729h:
	out (093h),a		;3729	d3 93 	. . 
	djnz l3729h		;372b	10 fc 	. . 
	inc h			;372d	24 	$ 
	ld b,d			;372e	42 	B 
	djnz l3715h		;372f	10 e4 	. . 
	xor a			;3731	af 	. 
	out (094h),a		;3732	d3 94 	. . 
	ret			;3734	c9 	. 
l3735h:
	di			;3735	f3 	. 
	ld hl,l37a7h		;3736	21 a7 37 	! . 7 
	ld de,0f93ah		;3739	11 3a f9 	. : . 
	ld bc,l007fh+1		;373c	01 80 00 	. . . 
	ldir		;373f	ed b0 	. . 
	ld a,(0ef9ch)		;3741	3a 9c ef 	: . . 
	or a			;3744	b7 	. 
	jr nz,l374dh		;3745	20 06 	  . 
	ld a,(0ef9dh)		;3747	3a 9d ef 	: . . 
	or a			;374a	b7 	. 
	jr z,l3758h		;374b	28 0b 	( . 
l374dh:
	ld a,(0ef96h)		;374d	3a 96 ef 	: . . 
	or a			;3750	b7 	. 
	jr nz,l3777h		;3751	20 24 	  $ 
	call 0f93ah		;3753	cd 3a f9 	. : . 
	jr c,l3777h		;3756	38 1f 	8 . 
l3758h:
	xor a			;3758	af 	. 
	ld (0ef96h),a		;3759	32 96 ef 	2 . . 
	ret			;375c	c9 	. 
l375dh:
	dec c			;375d	0d 	. 
	ld a,(bc)			;375e	0a 	. 
	ld d,d			;375f	52 	R 
	ld b,c			;3760	41 	A 
	ld c,l			;3761	4d 	M 
	jr nz,$+70		;3762	20 44 	  D 
	ld c,c			;3764	49 	I 
	ld d,e			;3765	53 	S 
	ld c,e			;3766	4b 	K 
	jr nz,l37afh		;3767	20 46 	  F 
	ld c,a			;3769	4f 	O 
	ld d,d			;376a	52 	R 
	ld c,l			;376b	4d 	M 
	ld b,c			;376c	41 	A 
	ld d,h			;376d	54 	T 
	jr nz,l3798h		;376e	20 28 	  ( 
	ld e,c			;3770	59 	Y 
	cpl			;3771	2f 	/ 
	ld c,(hl)			;3772	4e 	N 
	add hl,hl			;3773	29 	) 
	jr nz,l37b5h		;3774	20 3f 	  ? 
	nop			;3776	00 	. 
l3777h:
	ld hl,l375dh		;3777	21 5d 37 	! ] 7 
	call sub_0589h		;377a	cd 89 05 	. . . 
	ei			;377d	fb 	. 
	call sub_385fh		;377e	cd 5f 38 	. _ 8 
	di			;3781	f3 	. 
	cp 020h		;3782	fe 20 	.   
	jr c,l3777h		;3784	38 f1 	8 . 
	push af			;3786	f5 	. 
	ld c,a			;3787	4f 	O 
	call sub_4d5dh		;3788	cd 5d 4d 	. ] M 
	pop af			;378b	f1 	. 
	cp 07ah		;378c	fe 7a 	. z 
	jr nc,l3777h		;378e	30 e7 	0 . 
	and 05fh		;3790	e6 5f 	. _ 
	cp 04eh		;3792	fe 4e 	. N 
	jr z,l3758h		;3794	28 c2 	( . 
	cp 059h		;3796	fe 59 	. Y 
l3798h:
	jr nz,l3777h		;3798	20 dd 	  . 
	ld a,(0ef9ch)		;379a	3a 9c ef 	: . . 
	scf			;379d	37 	7 
	call RAMDKMNT		;379e	cd 2e 36 	. . 6 
	xor a			;37a1	af 	. 
	call sub_360ch		;37a2	cd 0c 36 	. . 6 
	jr l3758h		;37a5	18 b1 	. . 
l37a7h:
	ld a,(0ef9ch)		;37a7	3a 9c ef 	: . . 
	or a			;37aa	b7 	. 
	ret z			;37ab	c8 	. 
	ld l,a			;37ac	6f 	o 
	ld h,000h		;37ad	26 00 	& . 
l37afh:
	ld b,003h		;37af	06 03 	. . 
	call sub_33f0h		;37b1	cd f0 33 	. . 3 
	dec hl			;37b4	2b 	+ 
l37b5h:
	ld de,(0efaah)		;37b5	ed 5b aa ef 	. [ . . 
	ex de,hl			;37b9	eb 	. 
	add hl,de			;37ba	19 	. 
	ld bc,00200h		;37bb	01 00 02 	. . . 
	add hl,bc			;37be	09 	. 
	ex de,hl			;37bf	eb 	. 
	push hl			;37c0	e5 	. 
	pop bc			;37c1	c1 	. 
	ld hl,(0ef94h)		;37c2	2a 94 ef 	* . . 
	ld a,(0f53dh)		;37c5	3a 3d f5 	: = . 
	and 00fh		;37c8	e6 0f 	. . 
	or 040h		;37ca	f6 40 	. @ 
	out (005h),a		;37cc	d3 05 	. . 
l37ceh:
	push bc			;37ce	c5 	. 
	ld b,080h		;37cf	06 80 	. . 
	xor a			;37d1	af 	. 
l37d2h:
	dec hl			;37d2	2b 	+ 
	xor (hl)			;37d3	ae 	. 
	rlca			;37d4	07 	. 
	djnz l37d2h		;37d5	10 fb 	. . 
	pop bc			;37d7	c1 	. 
	inc b			;37d8	04 	. 
	dec b			;37d9	05 	. 
	push af			;37da	f5 	. 
	jr nz,l37e7h		;37db	20 0a 	  . 
	ld a,c			;37dd	79 	y 
	xor 007h		;37de	ee 07 	. . 
	cp 004h		;37e0	fe 04 	. . 
	jr nc,l37e7h		;37e2	30 03 	0 . 
	pop af			;37e4	f1 	. 
	jr l37edh		;37e5	18 06 	. . 
l37e7h:
	pop af			;37e7	f1 	. 
	ex de,hl			;37e8	eb 	. 
	cp (hl)			;37e9	be 	. 
	ex de,hl			;37ea	eb 	. 
	jr nz,l37f3h		;37eb	20 06 	  . 
l37edh:
	dec de			;37ed	1b 	. 
	dec bc			;37ee	0b 	. 
	bit 7,b		;37ef	cb 78 	. x 
	jr z,l37ceh		;37f1	28 db 	( . 
l37f3h:
	ld a,(0f53dh)		;37f3	3a 3d f5 	: = . 
	and 00fh		;37f6	e6 0f 	. . 
	or 000h		;37f8	f6 00 	. . 
	out (005h),a		;37fa	d3 05 	. . 
	or a			;37fc	b7 	. 
	bit 7,b		;37fd	cb 78 	. x 
	ret nz			;37ff	c0 	. 
	scf			;3800	37 	7 
	ret			;3801	c9 	. 
sub_3802h:
	ld hl,(ATSOTIME)		;3802	2a 41 ef 	* A . 
	ld de,(TIMER0)		;3805	ed 5b 8f ef 	. [ . . 
	add hl,de			;3809	19 	. 
	ld (0f77ch),hl		;380a	22 7c f7 	" | . 
	ret			;380d	c9 	. 
sub_380eh:
	ld a,(ATSHUTOFF)		;380e	3a 40 ef 	: @ . 
	or a			;3811	b7 	. 
	ret z			;3812	c8 	. 
	ld hl,(0f77ch)		;3813	2a 7c f7 	* | . 
	ld de,(TIMER0)		;3816	ed 5b 8f ef 	. [ . . 
	sbc hl,de		;381a	ed 52 	. R 
	ret			;381c	c9 	. 
l381dh:
	ld a,(RIOBYTE)		;381d	3a 29 f5 	: ) . 
	and 003h		;3820	e6 03 	. . 
	cp 002h		;3822	fe 02 	. . 
	jr c,sub_3831h		;3824	38 0b 	8 . 
	call sub_394fh		;3826	cd 4f 39 	. O 9 
	ld a,000h		;3829	3e 00 	> . 
	ret nz			;382b	c0 	. 
	ld b,030h		;382c	06 30 	. 0 
	jp l42ach		;382e	c3 ac 42 	. . B 
sub_3831h:
	ld a,(0f008h)		;3831	3a 08 f0 	: . . 
	or a			;3834	b7 	. 
	jr z,l383ah		;3835	28 03 	( . 
	ld a,0ffh		;3837	3e ff 	> . 
	ret			;3839	c9 	. 
l383ah:
	call sub_3cc0h		;383a	cd c0 3c 	. . < 
	ld b,001h		;383d	06 01 	. . 
	jr c,l384ah		;383f	38 09 	8 . 
	ld hl,0f008h		;3841	21 08 f0 	! . . 
	ld (hl),b			;3844	70 	p 
	inc hl			;3845	23 	# 
	ld (hl),a			;3846	77 	w 
	inc hl			;3847	23 	# 
	ld (hl),c			;3848	71 	q 
	dec b			;3849	05 	. 
l384ah:
	dec b			;384a	05 	. 
	ld a,b			;384b	78 	x 
	ret			;384c	c9 	. 
l384dh:
	ld a,(RIOBYTE)		;384d	3a 29 f5 	: ) . 
	and 003h		;3850	e6 03 	. . 
	cp 002h		;3852	fe 02 	. . 
	jr c,sub_385fh		;3854	38 09 	8 . 
l3856h:
	call sub_394fh		;3856	cd 4f 39 	. O 9 
	ret nz			;3859	c0 	. 
	ld b,050h		;385a	06 50 	. P 
	jp l42ach		;385c	c3 ac 42 	. . B 
sub_385fh:
	call sub_3802h		;385f	cd 02 38 	. . 8 
	ld hl,0f008h		;3862	21 08 f0 	! . . 
	ld a,(hl)			;3865	7e 	~ 
	ld (hl),000h		;3866	36 00 	6 . 
	or a			;3868	b7 	. 
	inc hl			;3869	23 	# 
	ld a,(hl)			;386a	7e 	~ 
	inc hl			;386b	23 	# 
	ld c,(hl)			;386c	4e 	N 
	ret nz			;386d	c0 	. 
	jp l3caeh		;386e	c3 ae 3c 	. . < 
l3871h:
	ld a,(RIOBYTE)		;3871	3a 29 f5 	: ) . 
	dec a			;3874	3d 	= 
	and 003h		;3875	e6 03 	. . 
	cp 002h		;3877	fe 02 	. . 
	jp c,sub_4d5dh		;3879	da 5d 4d 	. ] M 
l387ch:
	push bc			;387c	c5 	. 
	call sub_394fh		;387d	cd 4f 39 	. O 9 
	pop bc			;3880	c1 	. 
	ret nz			;3881	c0 	. 
	ld b,060h		;3882	06 60 	. ` 
	jp l42ach		;3884	c3 ac 42 	. . B 
l3887h:
	ld a,(RIOBYTE)		;3887	3a 29 f5 	: ) . 
	and 00ch		;388a	e6 0c 	. . 
	or a			;388c	b7 	. 
	jr z,sub_385fh		;388d	28 d0 	( . 
	cp 008h		;388f	fe 08 	. . 
	ld a,01ah		;3891	3e 1a 	> . 
	ret nz			;3893	c0 	. 
	jr l3856h		;3894	18 c0 	. . 
l3896h:
	ld a,(RIOBYTE)		;3896	3a 29 f5 	: ) . 
	and 030h		;3899	e6 30 	. 0 
	cp 010h		;389b	fe 10 	. . 
	jp z,sub_4d5dh		;389d	ca 5d 4d 	. ] M 
	cp 020h		;38a0	fe 20 	.   
	ret nz			;38a2	c0 	. 
	jr l387ch		;38a3	18 d7 	. . 
l38a5h:
	ld a,(YLCOUNTRY)		;38a5	3a 77 f7 	: w . 
	ld b,a			;38a8	47 	G 
	ld a,(RIOBYTE)		;38a9	3a 29 f5 	: ) . 
	and 0c0h		;38ac	e6 c0 	. . 
	or b			;38ae	b0 	. 
	ld hl,PRTFLG		;38af	21 39 f3 	! 9 . 
	cp (hl)			;38b2	be 	. 
	jr z,l38cch		;38b3	28 17 	( . 
	push bc			;38b5	c5 	. 
	push af			;38b6	f5 	. 
	ld e,052h		;38b7	1e 52 	. R 
	call sub_3c50h		;38b9	cd 50 3c 	. P < 
	ld a,(YLCOUNTRY)		;38bc	3a 77 f7 	: w . 
	xor 00fh		;38bf	ee 0f 	. . 
	ld c,a			;38c1	4f 	O 
	call l38cch		;38c2	cd cc 38 	. . 8 
	pop hl			;38c5	e1 	. 
	pop bc			;38c6	c1 	. 
	ret nz			;38c7	c0 	. 
	ld a,h			;38c8	7c 	| 
	ld (PRTFLG),a		;38c9	32 39 f3 	2 9 . 
l38cch:
	call sub_396bh		;38cc	cd 6b 39 	. k 9 
	jr c,l3904h		;38cf	38 33 	8 3 
	jp nz,l403fh		;38d1	c2 3f 40 	. ? @ 
	call sub_3940h		;38d4	cd 40 39 	. @ 9 
l38d7h:
	ei			;38d7	fb 	. 
	call sub_6ef9h		;38d8	cd f9 6e 	. . n 
	ret nz			;38db	c0 	. 
	di			;38dc	f3 	. 
	push bc			;38dd	c5 	. 
	call sub_38f5h		;38de	cd f5 38 	. . 8 
	pop bc			;38e1	c1 	. 
	inc a			;38e2	3c 	< 
	jr nz,l38d7h		;38e3	20 f2 	  . 
	ld a,c			;38e5	79 	y 
	out (014h),a		;38e6	d3 14 	. . 
	ei			;38e8	fb 	. 
	ret			;38e9	c9 	. 
l38eah:
	call sub_396bh		;38ea	cd 6b 39 	. k 9 
	jr c,l3917h		;38ed	38 28 	8 ( 
	jp nz,l405dh		;38ef	c2 5d 40 	. ] @ 
	call sub_3940h		;38f2	cd 40 39 	. @ 9 
sub_38f5h:
	call sub_4334h		;38f5	cd 34 43 	. 4 C 
	ret z			;38f8	c8 	. 
	ld a,b			;38f9	78 	x 
	dec a			;38fa	3d 	= 
	call sub_4580h		;38fb	cd 80 45 	. . E 
	rlca			;38fe	07 	. 
	ld a,0ffh		;38ff	3e ff 	> . 
	ret nc			;3901	d0 	. 
	xor a			;3902	af 	. 
	ret			;3903	c9 	. 
l3904h:
	call sub_6effh		;3904	cd ff 6e 	. . n 
	ret nz			;3907	c0 	. 
	ld a,(0eff0h)		;3908	3a f0 ef 	: . . 
	or a			;390b	b7 	. 
	ret nz			;390c	c0 	. 
	call l3917h		;390d	cd 17 39 	. . 9 
	inc a			;3910	3c 	< 
	jr nz,l3904h		;3911	20 f1 	  . 
	ld a,c			;3913	79 	y 
	out (010h),a		;3914	d3 10 	. . 
	ret			;3916	c9 	. 
l3917h:
	call sub_3929h		;3917	cd 29 39 	. ) 9 
	ret nz			;391a	c0 	. 
	call HSRST		;391b	cd f8 46 	. . F 
	rra			;391e	1f 	. 
	and 0a0h		;391f	e6 a0 	. . 
	ld a,0ffh		;3921	3e ff 	> . 
	ret z			;3923	c8 	. 
	inc a			;3924	3c 	< 
	ret			;3925	c9 	. 
sub_3926h:
	call CHKMOD		;3926	cd 11 46 	. . F 
sub_3929h:
	ld a,(CRGDEV)		;3929	3a 3f f5 	: ? . 
	sub 049h		;392c	d6 49 	. I 
	ld a,000h		;392e	3e 00 	> . 
	ret			;3930	c9 	. 
sub_3931h:
	ld a,(0f309h)		;3931	3a 09 f3 	: . . 
	or a			;3934	b7 	. 
	ret z			;3935	c8 	. 
	call sub_3926h		;3936	cd 26 39 	. & 9 
	ld (0f309h),a		;3939	32 09 f3 	2 . . 
	jp z,HSRK		;393c	ca 52 47 	. R G 
	ret			;393f	c9 	. 
sub_3940h:
	ld a,b			;3940	78 	x 
	push bc			;3941	c5 	. 
	call sub_4441h		;3942	cd 41 44 	. A D 
	ld (0f27bh),a		;3945	32 7b f2 	2 { . 
	ld c,000h		;3948	0e 00 	. . 
	call sub_47b8h		;394a	cd b8 47 	. . G 
	pop bc			;394d	c1 	. 
	ret			;394e	c9 	. 
sub_394fh:
	call sub_45e6h		;394f	cd e6 45 	. . E 
	ld hl,0f77eh		;3952	21 7e f7 	! ~ . 
	jr z,l395bh		;3955	28 04 	( . 
	and 00fh		;3957	e6 0f 	. . 
	or a			;3959	b7 	. 
	ret			;395a	c9 	. 
l395bh:
	push hl			;395b	e5 	. 
	ex de,hl			;395c	eb 	. 
	ld hl,0ef31h		;395d	21 31 ef 	! 1 . 
	ld bc,l0009h		;3960	01 09 00 	. . . 
	ldir		;3963	ed b0 	. . 
	pop hl			;3965	e1 	. 
	ld b,010h		;3966	06 10 	. . 
	jp l42ach		;3968	c3 ac 42 	. . B 
sub_396bh:
	ld a,(RIOBYTE)		;396b	3a 29 f5 	: ) . 
	and 0c0h		;396e	e6 c0 	. . 
	ld b,001h		;3970	06 01 	. . 
	ret z			;3972	c8 	. 
	sub 080h		;3973	d6 80 	. . 
	ld b,a			;3975	47 	G 
	ret			;3976	c9 	. 
l3977h:
	call sub_39c2h		;3977	cd c2 39 	. . 9 
	jr c,l397dh		;397a	38 01 	8 . 
	ret nz			;397c	c0 	. 
l397dh:
	push hl			;397d	e5 	. 
	ld c,a			;397e	4f 	O 
	ex de,hl			;397f	eb 	. 
	call sub_39f7h		;3980	cd f7 39 	. . 9 
	ld b,(hl)			;3983	46 	F 
	inc b			;3984	04 	. 
	ld a,(OLDBNK)		;3985	3a 2c f5 	: , . 
	ld c,a			;3988	4f 	O 
	ex de,hl			;3989	eb 	. 
l398ah:
	ld a,(de)			;398a	1a 	. 
	call 0ec6ah		;398b	cd 6a ec 	. j . 
	inc de			;398e	13 	. 
	inc hl			;398f	23 	# 
	djnz l398ah		;3990	10 f8 	. . 
	pop hl			;3992	e1 	. 
	ret			;3993	c9 	. 
l3994h:
	ld c,0ffh		;3994	0e ff 	. . 
l3996h:
	call sub_39c2h		;3996	cd c2 39 	. . 9 
	push hl			;3999	e5 	. 
	jr c,l399eh		;399a	38 02 	8 . 
	jr nz,l39d8h		;399c	20 3a 	  : 
l399eh:
	ex de,hl			;399e	eb 	. 
	ld c,a			;399f	4f 	O 
	call sub_39f7h		;39a0	cd f7 39 	. . 9 
	ex de,hl			;39a3	eb 	. 
	ld a,(OLDBNK)		;39a4	3a 2c f5 	: , . 
	ld c,a			;39a7	4f 	O 
	call 0ec64h		;39a8	cd 64 ec 	. d . 
	cp 010h		;39ab	fe 10 	. . 
	jr c,l39b1h		;39ad	38 02 	8 . 
	ld a,00fh		;39af	3e 0f 	> . 
l39b1h:
	ld (de),a			;39b1	12 	. 
	inc de			;39b2	13 	. 
	inc hl			;39b3	23 	# 
	or a			;39b4	b7 	. 
	jr z,l39c0h		;39b5	28 09 	( . 
	ld c,a			;39b7	4f 	O 
	xor a			;39b8	af 	. 
	ld b,a			;39b9	47 	G 
	ld a,(OLDBNK)		;39ba	3a 2c f5 	: , . 
	call 0ec5eh		;39bd	cd 5e ec 	. ^ . 
l39c0h:
	pop hl			;39c0	e1 	. 
	ret			;39c1	c9 	. 
sub_39c2h:
	ld a,c			;39c2	79 	y 
	cp 00ah		;39c3	fe 0a 	. . 
	ld de,(0f012h)		;39c5	ed 5b 12 f0 	. [ . . 
	ret c			;39c9	d8 	. 
	ld de,0cc00h		;39ca	11 00 cc 	. . . 
	cp 03fh		;39cd	fe 3f 	. ? 
	ccf			;39cf	3f 	? 
	ret nc			;39d0	d0 	. 
	cp 07fh		;39d1	fe 7f 	.  
	ret nc			;39d3	d0 	. 
	sub 040h		;39d4	d6 40 	. @ 
	cp a			;39d6	bf 	. 
	ret			;39d7	c9 	. 
l39d8h:
	sub 0ffh		;39d8	d6 ff 	. . 
	jr nz,l39eah		;39da	20 0e 	  . 
	ld hl,0cc00h		;39dc	21 00 cc 	! . . 
	ld de,l000fh+1		;39df	11 10 00 	. . . 
	ld b,03fh		;39e2	06 3f 	. ? 
l39e4h:
	ld (hl),a			;39e4	77 	w 
	add hl,de			;39e5	19 	. 
	djnz l39e4h		;39e6	10 fc 	. . 
	jr l39c0h		;39e8	18 d6 	. . 
l39eah:
	inc a			;39ea	3c 	< 
	jr z,l39f2h		;39eb	28 05 	( . 
	inc a			;39ed	3c 	< 
	jr nz,l39c0h		;39ee	20 d0 	  . 
	set 7,a		;39f0	cb ff 	. . 
l39f2h:
	ld (0f01dh),a		;39f2	32 1d f0 	2 . . 
	jr l39c0h		;39f5	18 c9 	. . 
sub_39f7h:
	push hl			;39f7	e5 	. 
	ld h,000h		;39f8	26 00 	& . 
	ld l,c			;39fa	69 	i 
	add hl,hl			;39fb	29 	) 
	add hl,hl			;39fc	29 	) 
	add hl,hl			;39fd	29 	) 
	add hl,hl			;39fe	29 	) 
	pop bc			;39ff	c1 	. 
	add hl,bc			;3a00	09 	. 
	ret			;3a01	c9 	. 
sub_3a02h:
	ld de,0cc00h		;3a02	11 00 cc 	. . . 
	ld hl,l3a27h		;3a05	21 27 3a 	! ' : 
	ld b,03fh		;3a08	06 3f 	. ? 
	ld c,040h		;3a0a	0e 40 	. @ 
l3a0ch:
	ld a,001h		;3a0c	3e 01 	> . 
	ld (de),a			;3a0e	12 	. 
	inc de			;3a0f	13 	. 
	ld a,c			;3a10	79 	y 
	cp 05eh		;3a11	fe 5e 	. ^ 
	jr c,l3a1bh		;3a13	38 06 	8 . 
	ld a,020h		;3a15	3e 20 	>   
	jr z,l3a1bh		;3a17	28 02 	( . 
	ld a,(hl)			;3a19	7e 	~ 
	inc hl			;3a1a	23 	# 
l3a1bh:
	ld (de),a			;3a1b	12 	. 
	inc c			;3a1c	0c 	. 
	push hl			;3a1d	e5 	. 
	ld hl,l000fh		;3a1e	21 0f 00 	! . . 
	add hl,de			;3a21	19 	. 
	ex de,hl			;3a22	eb 	. 
	pop hl			;3a23	e1 	. 
	djnz l3a0ch		;3a24	10 e6 	. . 
	ret			;3a26	c9 	. 
l3a27h:
	nop			;3a27	00 	. 
	dec de			;3a28	1b 	. 
	inc de			;3a29	13 	. 
	nop			;3a2a	00 	. 
	ld (de),a			;3a2b	12 	. 
	dec bc			;3a2c	0b 	. 
	inc c			;3a2d	0c 	. 
	ld a,a			;3a2e	7f 	 
	ex af,af'			;3a2f	08 	. 
	ld hl,l2322h		;3a30	21 22 23 	! " # 
	inc h			;3a33	24 	$ 
	dec h			;3a34	25 	% 
	ld h,027h		;3a35	26 27 	& ' 
	jr z,l3a62h		;3a37	28 29 	( ) 
	ld e,(hl)			;3a39	5e 	^ 
	ld e,a			;3a3a	5f 	_ 
	ld h,b			;3a3b	60 	` 
	ld a,e			;3a3c	7b 	{ 
	ld a,h			;3a3d	7c 	| 
	ld a,l			;3a3e	7d 	} 
	ld a,(hl)			;3a3f	7e 	~ 
	ld a,(l3c3bh)		;3a40	3a 3b 3c 	: ; < 
	dec a			;3a43	3d 	= 
	ld a,03fh		;3a44	3e 3f 	> ? 
	jr nz,l3a82h		;3a46	20 3a 	  : 
	ld (hl),l			;3a48	75 	u 
	rst 30h			;3a49	f7 	. 
	and 00fh		;3a4a	e6 0f 	. . 
	ld hl,l3a5fh		;3a4c	21 5f 3a 	! _ : 
	ld b,005h		;3a4f	06 05 	. . 
l3a51h:
	cp (hl)			;3a51	be 	. 
	inc hl			;3a52	23 	# 
	jr z,$+7		;3a53	28 05 	( . 
	inc hl			;3a55	23 	# 
	djnz l3a51h		;3a56	10 f9 	. . 
	xor a			;3a58	af 	. 
	ld b,07eh		;3a59	06 7e 	. ~ 
	ld (0f81dh),a		;3a5b	32 1d f8 	2 . . 
	ret			;3a5e	c9 	. 
l3a5fh:
	ld c,001h		;3a5f	0e 01 	. . 
	dec c			;3a61	0d 	. 
l3a62h:
	ld (bc),a			;3a62	02 	. 
	dec bc			;3a63	0b 	. 
	inc b			;3a64	04 	. 
	ld a,(bc)			;3a65	0a 	. 
	inc b			;3a66	04 	. 
	ld b,004h		;3a67	06 04 	. . 
l3a69h:
	ld a,(CSTOPFLG)		;3a69	3a 1a f0 	: . . 
	or a			;3a6c	b7 	. 
	jp nz,l3b07h		;3a6d	c2 07 3b 	. . ; 
	or c			;3a70	b1 	. 
	ret z			;3a71	c8 	. 
	push bc			;3a72	c5 	. 
	ld b,0ffh		;3a73	06 ff 	. . 
	call l4066h		;3a75	cd 66 40 	. f @ 
	ld a,(0f0f5h)		;3a78	3a f5 f0 	: . . 
	set 3,a		;3a7b	cb df 	. . 
	push af			;3a7d	f5 	. 
	xor 01eh		;3a7e	ee 1e 	. . 
	or 001h		;3a80	f6 01 	. . 
l3a82h:
	and b			;3a82	a0 	. 
	ld b,a			;3a83	47 	G 
	pop af			;3a84	f1 	. 
	push af			;3a85	f5 	. 
	and 001h		;3a86	e6 01 	. . 
	jr z,l3a8eh		;3a88	28 04 	( . 
	res 1,c		;3a8a	cb 89 	. . 
	set 0,c		;3a8c	cb c1 	. . 
l3a8eh:
	pop af			;3a8e	f1 	. 
	and 080h		;3a8f	e6 80 	. . 
	jr z,l3a95h		;3a91	28 02 	( . 
	res 3,c		;3a93	cb 99 	. . 
l3a95h:
	call l4066h		;3a95	cd 66 40 	. f @ 
	ld h,b			;3a98	60 	` 
	ld l,c			;3a99	69 	i 
	pop bc			;3a9a	c1 	. 
	push hl			;3a9b	e5 	. 
	call sub_5a10h		;3a9c	cd 10 5a 	. . Z 
	call sub_3b0ah		;3a9f	cd 0a 3b 	. . ; 
	ld a,004h		;3aa2	3e 04 	> . 
	out (001h),a		;3aa4	d3 01 	. . 
	in a,(000h)		;3aa6	db 00 	. . 
	in a,(001h)		;3aa8	db 01 	. . 
	and 0f0h		;3aaa	e6 f0 	. . 
	ld (0f7c5h),a		;3aac	32 c5 f7 	2 . . 
	jr nz,l3ab5h		;3aaf	20 04 	  . 
	ld a,004h		;3ab1	3e 04 	> . 
	out (001h),a		;3ab3	d3 01 	. . 
l3ab5h:
	ld hl,0f006h		;3ab5	21 06 f0 	! . . 
l3ab8h:
	push bc			;3ab8	c5 	. 
l3ab9h:
	djnz l3ab9h		;3ab9	10 fe 	. . 
	ld b,0fdh		;3abb	06 fd 	. . 
	dec c			;3abd	0d 	. 
	jr nz,l3ab9h		;3abe	20 f9 	  . 
	ld a,(hl)			;3ac0	7e 	~ 
	xor d			;3ac1	aa 	. 
	ld (hl),a			;3ac2	77 	w 
	out (019h),a		;3ac3	d3 19 	. . 
	in a,(004h)		;3ac5	db 04 	. . 
	and 008h		;3ac7	e6 08 	. . 
	jr z,l3aefh		;3ac9	28 24 	( $ 
	ld a,(0f7c5h)		;3acb	3a c5 f7 	: . . 
	ld b,a			;3ace	47 	G 
	in a,(000h)		;3acf	db 00 	. . 
	in a,(001h)		;3ad1	db 01 	. . 
	sub b			;3ad3	90 	. 
	jr c,l3af3h		;3ad4	38 1d 	8 . 
	ld a,004h		;3ad6	3e 04 	> . 
	out (001h),a		;3ad8	d3 01 	. . 
	dec e			;3ada	1d 	. 
	jr z,l3af7h		;3adb	28 1a 	( . 
l3addh:
	ld a,(CSTOPFLG)		;3add	3a 1a f0 	: . . 
	ld b,a			;3ae0	47 	G 
	ld a,(0eff0h)		;3ae1	3a f0 ef 	: . . 
	or b			;3ae4	b0 	. 
	ld b,a			;3ae5	47 	G 
	ld a,(0eff2h)		;3ae6	3a f2 ef 	: . . 
	or b			;3ae9	b0 	. 
	pop bc			;3aea	c1 	. 
	jr z,l3ab8h		;3aeb	28 cb 	( . 
	jr l3af8h		;3aed	18 09 	. . 
l3aefh:
	ld b,004h		;3aef	06 04 	. . 
l3af1h:
	djnz l3af1h		;3af1	10 fe 	. . 
l3af3h:
	jr l3af5h		;3af3	18 00 	. . 
l3af5h:
	jr l3addh		;3af5	18 e6 	. . 
l3af7h:
	pop bc			;3af7	c1 	. 
l3af8h:
	res 7,(hl)		;3af8	cb be 	. . 
	ld a,(hl)			;3afa	7e 	~ 
	out (019h),a		;3afb	d3 19 	. . 
	pop bc			;3afd	c1 	. 
	call l4066h		;3afe	cd 66 40 	. f @ 
	call sub_59f9h		;3b01	cd f9 59 	. . Y 
	ld a,e			;3b04	7b 	{ 
	or a			;3b05	b7 	. 
	ret z			;3b06	c8 	. 
l3b07h:
	ld a,0ffh		;3b07	3e ff 	> . 
	ret			;3b09	c9 	. 
sub_3b0ah:
	bit 7,b		;3b0a	cb 78 	. x 
	jr z,l3b15h		;3b0c	28 07 	( . 
	ld a,d			;3b0e	7a 	z 
	or e			;3b0f	b3 	. 
	ld b,a			;3b10	47 	G 
	ld a,080h		;3b11	3e 80 	> . 
	jr nz,l3b2bh		;3b13	20 16 	  . 
l3b15h:
	ld a,b			;3b15	78 	x 
	or a			;3b16	b7 	. 
	jr z,l3b1bh		;3b17	28 02 	( . 
	ld a,080h		;3b19	3e 80 	> . 
l3b1bh:
	push af			;3b1b	f5 	. 
	ld hl,l3b30h		;3b1c	21 30 3b 	! 0 ; 
	ld a,b			;3b1f	78 	x 
	sub 00ch		;3b20	d6 0c 	. . 
	add a,a			;3b22	87 	. 
	ld e,a			;3b23	5f 	_ 
	ld d,000h		;3b24	16 00 	. . 
	add hl,de			;3b26	19 	. 
	ld e,(hl)			;3b27	5e 	^ 
	inc hl			;3b28	23 	# 
	ld d,(hl)			;3b29	56 	V 
	pop af			;3b2a	f1 	. 
l3b2bh:
	push de			;3b2b	d5 	. 
	ld e,c			;3b2c	59 	Y 
	ld d,a			;3b2d	57 	W 
	pop bc			;3b2e	c1 	. 
	ret			;3b2f	c9 	. 
l3b30h:
	dec b			;3b30	05 	. 
	ld (hl),c			;3b31	71 	q 
	inc bc			;3b32	03 	. 
	rrca			;3b33	0f 	. 
	ld (bc),a			;3b34	02 	. 
	rst 28h			;3b35	ef 	. 
	ld (bc),a			;3b36	02 	. 
	jp nc,0b702h		;3b37	d2 02 b7 	. . . 
	ld (bc),a			;3b3a	02 	. 
	sbc a,l			;3b3b	9d 	. 
	ld (bc),a			;3b3c	02 	. 
	add a,l			;3b3d	85 	. 
	ld (bc),a			;3b3e	02 	. 
	ld l,(hl)			;3b3f	6e 	n 
	ld (bc),a			;3b40	02 	. 
	ld e,c			;3b41	59 	Y 
	ld (bc),a			;3b42	02 	. 
	ld b,h			;3b43	44 	D 
	ld (bc),a			;3b44	02 	. 
	ld sp,01f02h		;3b45	31 02 1f 	1 . . 
	ld (bc),a			;3b48	02 	. 
	ld c,001h		;3b49	0e 01 	. . 
	call m,0ed01h		;3b4b	fc 01 ed 	. . . 
	ld bc,sub_01ddh+2		;3b4e	01 df 01 	. . . 
	pop de			;3b51	d1 	. 
	ld bc,001c4h		;3b52	01 c4 01 	. . . 
	cp b			;3b55	b8 	. 
	ld bc,l01adh		;3b56	01 ad 01 	. . . 
	and d			;3b59	a2 	. 
	ld bc,l0198h		;3b5a	01 98 01 	. . . 
	adc a,a			;3b5d	8f 	. 
	ld bc,00185h		;3b5e	01 85 01 	. . . 
	ld a,l			;3b61	7d 	} 
	ld bc,00175h		;3b62	01 75 01 	. u . 
	ld l,l			;3b65	6d 	m 
	ld bc,00166h		;3b66	01 66 01 	. f . 
	ld e,a			;3b69	5f 	_ 
	ld bc,l0159h		;3b6a	01 59 01 	. Y . 
	ld d,e			;3b6d	53 	S 
	ld bc,0014dh		;3b6e	01 4d 01 	. M . 
	ld c,b			;3b71	48 	H 
	ld bc,00143h		;3b72	01 43 01 	. C . 
	ld a,001h		;3b75	3e 01 	> . 
	add hl,sp			;3b77	39 	9 
	ld bc,l0134h+1		;3b78	01 35 01 	. 5 . 
	ld sp,l2d01h		;3b7b	31 01 2d 	1 . - 
	ld bc,0012ah		;3b7e	01 2a 01 	. * . 
	ld h,001h		;3b81	26 01 	& . 
	inc hl			;3b83	23 	# 
	ld bc,00120h		;3b84	01 20 01 	.   . 
	dec e			;3b87	1d 	. 
	ld bc,l011bh		;3b88	01 1b 01 	. . . 
	jr $+3		;3b8b	18 01 	. . 
	ld d,001h		;3b8d	16 01 	. . 
	inc de			;3b8f	13 	. 
	ld bc,0cd11h		;3b90	01 11 cd 	. . . 
	inc a			;3b93	3c 	< 
	ld d,c			;3b94	51 	Q 
	ld a,0ffh		;3b95	3e ff 	> . 
	ld (0f337h),a		;3b97	32 37 f3 	2 7 . 
	ld (0f33ah),a		;3b9a	32 3a f3 	2 : . 
	ld (0f773h),a		;3b9d	32 73 f7 	2 s . 
	call sub_396bh		;3ba0	cd 6b 39 	. k 9 
	jr nz,l3bach		;3ba3	20 07 	  . 
	ld a,(0f338h)		;3ba5	3a 38 f3 	: 8 . 
	or a			;3ba8	b7 	. 
	jp nz,l3c3bh		;3ba9	c2 3b 3c 	. ; < 
l3bach:
	call l38eah		;3bac	cd ea 38 	. . 8 
	inc a			;3baf	3c 	< 
	jr z,l3bbah		;3bb0	28 08 	( . 
	call sub_3c58h		;3bb2	cd 58 3c 	. X < 
	jr z,l3bach		;3bb5	28 f5 	( . 
	jp l3c30h		;3bb7	c3 30 3c 	. 0 < 
l3bbah:
	call sub_3c43h		;3bba	cd 43 3c 	. C < 
	xor a			;3bbd	af 	. 
	ld hl,0f769h		;3bbe	21 69 f7 	! i . 
	ld (hl),a			;3bc1	77 	w 
	inc hl			;3bc2	23 	# 
	ld (hl),a			;3bc3	77 	w 
	ld e,041h		;3bc4	1e 41 	. A 
	call sub_3c50h		;3bc6	cd 50 3c 	. P < 
	ld c,008h		;3bc9	0e 08 	. . 
	call l38cch		;3bcb	cd cc 38 	. . 8 
	ld b,008h		;3bce	06 08 	. . 
l3bd0h:
	push bc			;3bd0	c5 	. 
	ld e,04bh		;3bd1	1e 4b 	. K 
	call sub_3c50h		;3bd3	cd 50 3c 	. P < 
	ld c,0f0h		;3bd6	0e f0 	. . 
	call l38cch		;3bd8	cd cc 38 	. . 8 
	ld c,000h		;3bdb	0e 00 	. . 
	call l38cch		;3bdd	cd cc 38 	. . 8 
	ld de,(0f769h)		;3be0	ed 5b 69 f7 	. [ i . 
	call sub_5038h		;3be4	cd 38 50 	. 8 P 
	ld b,01eh		;3be7	06 1e 	. . 
l3be9h:
	push bc			;3be9	c5 	. 
	push hl			;3bea	e5 	. 
	ld de,0f76ch		;3beb	11 6c f7 	. l . 
	ld b,008h		;3bee	06 08 	. . 
l3bf0h:
	ld a,(hl)			;3bf0	7e 	~ 
	ld (de),a			;3bf1	12 	. 
	call sub_59a1h		;3bf2	cd a1 59 	. . Y 
	inc de			;3bf5	13 	. 
	djnz l3bf0h		;3bf6	10 f8 	. . 
	pop hl			;3bf8	e1 	. 
	inc hl			;3bf9	23 	# 
	ld b,008h		;3bfa	06 08 	. . 
l3bfch:
	push bc			;3bfc	c5 	. 
	ld de,0f76ch		;3bfd	11 6c f7 	. l . 
	ld b,008h		;3c00	06 08 	. . 
l3c02h:
	ld a,(de)			;3c02	1a 	. 
	rlca			;3c03	07 	. 
	ld (de),a			;3c04	12 	. 
	rl c		;3c05	cb 11 	. . 
	inc de			;3c07	13 	. 
	djnz l3c02h		;3c08	10 f8 	. . 
	push hl			;3c0a	e5 	. 
	call l38cch		;3c0b	cd cc 38 	. . 8 
	pop hl			;3c0e	e1 	. 
	pop bc			;3c0f	c1 	. 
	djnz l3bfch		;3c10	10 ea 	. . 
	pop bc			;3c12	c1 	. 
	djnz l3be9h		;3c13	10 d4 	. . 
	call sub_3c43h		;3c15	cd 43 3c 	. C < 
	call sub_3c58h		;3c18	cd 58 3c 	. X < 
	pop bc			;3c1b	c1 	. 
	jr nz,l3c28h		;3c1c	20 0a 	  . 
	ld hl,0f76ah		;3c1e	21 6a f7 	! j . 
	inc (hl)			;3c21	34 	4 
	djnz l3bd0h		;3c22	10 ac 	. . 
	xor a			;3c24	af 	. 
	ld (0f773h),a		;3c25	32 73 f7 	2 s . 
l3c28h:
	ld e,032h		;3c28	1e 32 	. 2 
	call sub_3c50h		;3c2a	cd 50 3c 	. P < 
	call sub_3c43h		;3c2d	cd 43 3c 	. C < 
l3c30h:
	call sub_512ch		;3c30	cd 2c 51 	. , Q 
	xor a			;3c33	af 	. 
	ld (0f33ah),a		;3c34	32 3a f3 	2 : . 
	ld (0f337h),a		;3c37	32 37 f3 	2 7 . 
	ret			;3c3a	c9 	. 
l3c3bh:
	ld bc,l2202h		;3c3b	01 02 22 	. . " 
	call l3a69h		;3c3e	cd 69 3a 	. i : 
	jr l3c30h		;3c41	18 ed 	. . 
sub_3c43h:
	ld c,00dh		;3c43	0e 0d 	. . 
	call l38cch		;3c45	cd cc 38 	. . 8 
	ld c,00ah		;3c48	0e 0a 	. . 
	jr l3c55h		;3c4a	18 09 	. . 
sub_3c4ch:
	ld c,01bh		;3c4c	0e 1b 	. . 
	jr l3c55h		;3c4e	18 05 	. . 
sub_3c50h:
	push de			;3c50	d5 	. 
	call sub_3c4ch		;3c51	cd 4c 3c 	. L < 
	pop bc			;3c54	c1 	. 
l3c55h:
	jp l38cch		;3c55	c3 cc 38 	. . 8 
sub_3c58h:
	ld a,(CSTOPFLG)		;3c58	3a 1a f0 	: . . 
	ld b,a			;3c5b	47 	G 
	ld a,(0eff0h)		;3c5c	3a f0 ef 	: . . 
	or b			;3c5f	b0 	. 
	ret			;3c60	c9 	. 
WRT7508:
	in a,(005h)		;3c61	db 05 	. . 
	and 008h		;3c63	e6 08 	. . 
	jr z,WRT7508		;3c65	28 fa 	( . 
	ld a,c			;3c67	79 	y 
	out (006h),a		;3c68	d3 06 	. . 
	ld a,002h		;3c6a	3e 02 	> . 
	out (001h),a		;3c6c	d3 01 	. . 
	ret			;3c6e	c9 	. 
CMD7508:
	call WRT7508		;3c6f	cd 61 3c 	. a < 
l3c72h:
	in a,(005h)		;3c72	db 05 	. . 
	and 008h		;3c74	e6 08 	. . 
	jr z,l3c72h		;3c76	28 fa 	( . 
	in a,(006h)		;3c78	db 06 	. . 
	ret			;3c7a	c9 	. 
sub_3c7bh:
	ld a,002h		;3c7b	3e 02 	> . 
	out (001h),a		;3c7d	d3 01 	. . 
	jr l3c72h		;3c7f	18 f1 	. . 
sub_3c81h:
	ld a,(0f337h)		;3c81	3a 37 f3 	: 7 . 
	or a			;3c84	b7 	. 
	ret nz			;3c85	c0 	. 
	push bc			;3c86	c5 	. 
	ld a,(0f4d2h)		;3c87	3a d2 f4 	: . . 
	inc a			;3c8a	3c 	< 
	call z,sub_46ddh		;3c8b	cc dd 46 	. . F 
	ld a,(0eff0h)		;3c8e	3a f0 ef 	: . . 
	or a			;3c91	b7 	. 
	call nz,sub_2d5eh		;3c92	c4 5e 2d 	. ^ - 
	ld a,(0efefh)		;3c95	3a ef ef 	: . . 
	set 7,a		;3c98	cb ff 	. . 
	ld (0efefh),a		;3c9a	32 ef ef 	2 . . 
	ld a,(0eff2h)		;3c9d	3a f2 ef 	: . . 
	or a			;3ca0	b7 	. 
	call nz,sub_0a5ch		;3ca1	c4 5c 0a 	. \ . 
	ld a,(0eff1h)		;3ca4	3a f1 ef 	: . . 
	set 7,a		;3ca7	cb ff 	. . 
	ld (0eff1h),a		;3ca9	32 f1 ef 	2 . . 
	pop bc			;3cac	c1 	. 
	ret			;3cad	c9 	. 
l3caeh:
	call sub_3cc0h		;3cae	cd c0 3c 	. . < 
	ret nc			;3cb1	d0 	. 
	halt			;3cb2	76 	v 
	call sub_3c81h		;3cb3	cd 81 3c 	. . < 
	call sub_380eh		;3cb6	cd 0e 38 	. . 8 
	ld c,000h		;3cb9	0e 00 	. . 
	call m,sub_2d75h		;3cbb	fc 75 2d 	. u - 
	jr l3caeh		;3cbe	18 ee 	. . 
sub_3cc0h:
	call sub_3ce2h		;3cc0	cd e2 3c 	. . < 
	ret nc			;3cc3	d0 	. 
	ld a,(0f775h)		;3cc4	3a 75 f7 	: u . 
	bit 7,a		;3cc7	cb 7f 	.  
	jr z,l3cd1h		;3cc9	28 06 	( . 
	call sub_3fcah		;3ccb	cd ca 3f 	. . ? 
	ld c,000h		;3cce	0e 00 	. . 
	ret			;3cd0	c9 	. 
l3cd1h:
	call sub_3cf5h		;3cd1	cd f5 3c 	. . < 
	ret c			;3cd4	d8 	. 
	cp 0a2h		;3cd5	fe a2 	. . 
	jr nc,l3cddh		;3cd7	30 04 	0 . 
	call sub_3dfbh		;3cd9	cd fb 3d 	. . = 
	ret nc			;3cdc	d0 	. 
l3cddh:
	call nc,sub_3d40h		;3cdd	d4 40 3d 	. @ = 
	jr l3cd1h		;3ce0	18 ef 	. . 
sub_3ce2h:
	ld hl,0f016h		;3ce2	21 16 f0 	! . . 
	ld a,(hl)			;3ce5	7e 	~ 
	sub 001h		;3ce6	d6 01 	. . 
	ret c			;3ce8	d8 	. 
	ld (hl),a			;3ce9	77 	w 
	ld hl,(0f014h)		;3cea	2a 14 f0 	* . . 
	ld a,(hl)			;3ced	7e 	~ 
	inc hl			;3cee	23 	# 
	ld (0f014h),hl		;3cef	22 14 f0 	" . . 
	ld c,000h		;3cf2	0e 00 	. . 
	ret			;3cf4	c9 	. 
sub_3cf5h:
	call sub_0b80h		;3cf5	cd 80 0b 	. . . 
l3cf8h:
	ld a,(0f00bh)		;3cf8	3a 0b f0 	: . . 
	ld hl,(0f00dh)		;3cfb	2a 0d f0 	* . . 
	cp l			;3cfe	bd 	. 
	jr z,l3d1dh		;3cff	28 1c 	( . 
	ld b,(hl)			;3d01	46 	F 
	inc hl			;3d02	23 	# 
	ld a,l			;3d03	7d 	} 
	cp 081h		;3d04	fe 81 	. . 
	jr nz,l3d0bh		;3d06	20 03 	  . 
	ld hl,0f860h		;3d08	21 60 f8 	! ` . 
l3d0bh:
	ld (0f00dh),hl		;3d0b	22 0d f0 	" . . 
	ld a,b			;3d0e	78 	x 
	cp 0a1h		;3d0f	fe a1 	. . 
	jr z,l3d29h		;3d11	28 16 	( . 
	push af			;3d13	f5 	. 
	call sub_0b87h		;3d14	cd 87 0b 	. . . 
	pop af			;3d17	f1 	. 
	call sub_3802h		;3d18	cd 02 38 	. . 8 
	or a			;3d1b	b7 	. 
	ret			;3d1c	c9 	. 
l3d1dh:
	call sub_0b87h		;3d1d	cd 87 0b 	. . . 
	xor a			;3d20	af 	. 
	ld (CSTOPFLG),a		;3d21	32 1a f0 	2 . . 
	ld (BRKFLG),a		;3d24	32 19 f0 	2 . . 
	scf			;3d27	37 	7 
	ret			;3d28	c9 	. 
l3d29h:
	ld a,(0f3aeh)		;3d29	3a ae f3 	: . . 
	ld (0f01ch),a		;3d2c	32 1c f0 	2 . . 
	ld a,(0f3ach)		;3d2f	3a ac f3 	: . . 
	and 070h		;3d32	e6 70 	. p 
	ld c,a			;3d34	4f 	O 
	call sub_3df0h		;3d35	cd f0 3d 	. . = 
	ld a,(0f3adh)		;3d38	3a ad f3 	: . . 
	call l0898h		;3d3b	cd 98 08 	. . . 
	jr l3cf8h		;3d3e	18 b8 	. . 
sub_3d40h:
	cp 0a8h		;3d40	fe a8 	. . 
	jr c,l3d4ch		;3d42	38 08 	8 . 
	cp 0b2h		;3d44	fe b2 	. . 
	ret c			;3d46	d8 	. 
	cp 0b8h		;3d47	fe b8 	. . 
	ret nc			;3d49	d0 	. 
	sub 00ah		;3d4a	d6 0a 	. . 
l3d4ch:
	sub 0a2h		;3d4c	d6 a2 	. . 
	ld e,a			;3d4e	5f 	_ 
	ld d,000h		;3d4f	16 00 	. . 
	ld hl,l3d69h		;3d51	21 69 3d 	! i = 
	add hl,de			;3d54	19 	. 
	add hl,de			;3d55	19 	. 
	ld a,(0f00fh)		;3d56	3a 0f f0 	: . . 
	call sub_3fc5h		;3d59	cd c5 3f 	. . ? 
	ld (0f00fh),a		;3d5c	32 0f f0 	2 . . 
	ld b,a			;3d5f	47 	G 
	call sub_0b80h		;3d60	cd 80 0b 	. . . 
	call l3daah		;3d63	cd aa 3d 	. . = 
	jp sub_0b87h		;3d66	c3 87 0b 	. . . 
l3d69h:
	add a,c			;3d69	81 	. 
	dec a			;3d6a	3d 	= 
	add a,h			;3d6b	84 	. 
	dec a			;3d6c	3d 	= 
	adc a,h			;3d6d	8c 	. 
	dec a			;3d6e	3d 	= 
	adc a,d			;3d6f	8a 	. 
	dec a			;3d70	3d 	= 
	add a,a			;3d71	87 	. 
	dec a			;3d72	3d 	= 
	adc a,h			;3d73	8c 	. 
	dec a			;3d74	3d 	= 
	adc a,l			;3d75	8d 	. 
	dec a			;3d76	3d 	= 
	sub b			;3d77	90 	. 
	dec a			;3d78	3d 	= 
	sbc a,c			;3d79	99 	. 
	dec a			;3d7a	3d 	= 
	sub (hl)			;3d7b	96 	. 
	dec a			;3d7c	3d 	= 
	sub e			;3d7d	93 	. 
	dec a			;3d7e	3d 	= 
	and a			;3d7f	a7 	. 
	dec a			;3d80	3d 	= 
	and 07fh		;3d81	e6 7f 	.  
	ret			;3d83	c9 	. 
	and 0fdh		;3d84	e6 fd 	. . 
	ret			;3d86	c9 	. 
	and 0feh		;3d87	e6 fe 	. . 
	ret			;3d89	c9 	. 
	and 0bfh		;3d8a	e6 bf 	. . 
	ret			;3d8c	c9 	. 
	or 080h		;3d8d	f6 80 	. . 
	ret			;3d8f	c9 	. 
	or 002h		;3d90	f6 02 	. . 
	ret			;3d92	c9 	. 
	or 001h		;3d93	f6 01 	. . 
	ret			;3d95	c9 	. 
	or 040h		;3d96	f6 40 	. @ 
	ret			;3d98	c9 	. 
	ld b,a			;3d99	47 	G 
	and 010h		;3d9a	e6 10 	. . 
	ld a,b			;3d9c	78 	x 
	jr nz,l3da2h		;3d9d	20 03 	  . 
	xor 004h		;3d9f	ee 04 	. . 
	ret			;3da1	c9 	. 
l3da2h:
	and 0efh		;3da2	e6 ef 	. . 
	or 004h		;3da4	f6 04 	. . 
	ret			;3da6	c9 	. 
	xor 010h		;3da7	ee 10 	. . 
	ret			;3da9	c9 	. 
l3daah:
	ld a,(0f00fh)		;3daa	3a 0f f0 	: . . 
	ld hl,l4b10h		;3dad	21 10 4b 	! . K 
	ld c,000h		;3db0	0e 00 	. . 
	bit 7,a		;3db2	cb 7f 	.  
	jr nz,l3de9h		;3db4	20 33 	  3 
	ld hl,04c4eh		;3db6	21 4e 4c 	! N L 
	bit 6,a		;3db9	cb 77 	. w 
	jr nz,l3dedh		;3dbb	20 30 	  0 
	ld hl,l4c86h		;3dbd	21 86 4c 	! . L 
	ld c,020h		;3dc0	0e 20 	.   
	bit 4,a		;3dc2	cb 67 	. g 
	jr nz,l3dedh		;3dc4	20 27 	  ' 
	ld hl,04b7ah		;3dc6	21 7a 4b 	! z K 
	ld de,04be4h		;3dc9	11 e4 4b 	. . K 
	ld c,010h		;3dcc	0e 10 	. . 
	bit 2,a		;3dce	cb 57 	. W 
	jr nz,l3de2h		;3dd0	20 10 	  . 
	ld hl,04be4h		;3dd2	21 e4 4b 	! . K 
	ld c,000h		;3dd5	0e 00 	. . 
	and 003h		;3dd7	e6 03 	. . 
	jr nz,l3dedh		;3dd9	20 12 	  . 
l3ddbh:
	ld hl,04b7ah		;3ddb	21 7a 4b 	! z K 
	ld c,000h		;3dde	0e 00 	. . 
	jr l3dedh		;3de0	18 0b 	. . 
l3de2h:
	and 003h		;3de2	e6 03 	. . 
	jr z,l3dedh		;3de4	28 07 	( . 
	ex de,hl			;3de6	eb 	. 
	jr l3dedh		;3de7	18 04 	. . 
l3de9h:
	and 003h		;3de9	e6 03 	. . 
	jr nz,l3ddbh		;3deb	20 ee 	  . 
l3dedh:
	ld (0f010h),hl		;3ded	22 10 f0 	" . . 
sub_3df0h:
	ld hl,0f006h		;3df0	21 06 f0 	! . . 
	ld a,(hl)			;3df3	7e 	~ 
	and 0cfh		;3df4	e6 cf 	. . 
	or c			;3df6	b1 	. 
	ld (hl),a			;3df7	77 	w 
	out (019h),a		;3df8	d3 19 	. . 
	ret			;3dfa	c9 	. 
sub_3dfbh:
	cp 008h		;3dfb	fe 08 	. . 
	jr c,l3e3ah		;3dfd	38 3b 	8 ; 
	ld hl,l3e39h		;3dff	21 39 3e 	! 9 > 
	ld bc,l0006h+1		;3e02	01 07 00 	. . . 
	cpdr		;3e05	ed b9 	. . 
	jp nz,l3e98h		;3e07	c2 98 3e 	. . > 
	ld a,c			;3e0a	79 	y 
	cp 004h		;3e0b	fe 04 	. . 
	jp c,l3f5dh		;3e0d	da 5d 3f 	. ] ? 
	ld b,a			;3e10	47 	G 
	ld a,(0f00fh)		;3e11	3a 0f f0 	: . . 
	jr nz,l3e20h		;3e14	20 0a 	  . 
	and 083h		;3e16	e6 83 	. . 
	ld a,b			;3e18	78 	x 
	jp nz,l3f5dh		;3e19	c2 5d 3f 	. ] ? 
	ld a,012h		;3e1c	3e 12 	> . 
	jr l3e51h		;3e1e	18 31 	. 1 
l3e20h:
	ld de,l7f08h		;3e20	11 08 7f 	. .  
	and 003h		;3e23	e6 03 	. . 
	jr z,l3e2ah		;3e25	28 03 	( . 
	ld de,00c0bh		;3e27	11 0b 0c 	. . . 
l3e2ah:
	ld a,b			;3e2a	78 	x 
	sub 005h		;3e2b	d6 05 	. . 
	ld a,d			;3e2d	7a 	z 
	jr z,l3e51h		;3e2e	28 21 	( ! 
	ld a,e			;3e30	7b 	{ 
	jr l3e51h		;3e31	18 1e 	. . 
	ld h,l			;3e33	65 	e 
	ld h,e			;3e34	63 	c 
	ld d,l			;3e35	55 	U 
	ld h,h			;3e36	64 	d 
	add a,b			;3e37	80 	. 
	add a,c			;3e38	81 	. 
l3e39h:
	ld d,(hl)			;3e39	56 	V 
l3e3ah:
	ld a,(0f00fh)		;3e3a	3a 0f f0 	: . . 
	and 080h		;3e3d	e6 80 	. . 
	jr nz,l3e55h		;3e3f	20 14 	  . 
	ld a,b			;3e41	78 	x 
	cp 003h		;3e42	fe 03 	. . 
	jr nc,l3e61h		;3e44	30 1b 	0 . 
	or a			;3e46	b7 	. 
	ld a,01bh		;3e47	3e 1b 	> . 
	jr z,l3e51h		;3e49	28 06 	( . 
	dec b			;3e4b	05 	. 
	ld a,013h		;3e4c	3e 13 	> . 
	jr z,l3e51h		;3e4e	28 01 	( . 
	xor a			;3e50	af 	. 
l3e51h:
	or a			;3e51	b7 	. 
	ld c,000h		;3e52	0e 00 	. . 
	ret			;3e54	c9 	. 
l3e55h:
	ld hl,0f0cdh		;3e55	21 cd f0 	! . . 
	ld a,b			;3e58	78 	x 
	ld de,l3e5fh		;3e59	11 5f 3e 	. _ > 
	jp l3fbfh		;3e5c	c3 bf 3f 	. . ? 
l3e5fh:
	scf			;3e5f	37 	7 
	ret			;3e60	c9 	. 
l3e61h:
	ld a,b			;3e61	78 	x 
	sub 003h		;3e62	d6 03 	. . 
	ld b,a			;3e64	47 	G 
	ld a,(0f00fh)		;3e65	3a 0f f0 	: . . 
	and 003h		;3e68	e6 03 	. . 
	ld a,b			;3e6a	78 	x 
	jp z,l3e70h		;3e6b	ca 70 3e 	. p > 
	add a,005h		;3e6e	c6 05 	. . 
l3e70h:
	ld c,a			;3e70	4f 	O 
	ld a,(YPFCMFLG)		;3e71	3a 17 f0 	: . . 
	inc a			;3e74	3c 	< 
	ld a,c			;3e75	79 	y 
	jr nz,l3e7eh		;3e76	20 06 	  . 
	add a,0e0h		;3e78	c6 e0 	. . 
	ld c,0ffh		;3e7a	0e ff 	. . 
	or a			;3e7c	b7 	. 
	ret			;3e7d	c9 	. 
l3e7eh:
	sla a		;3e7e	cb 27 	. ' 
	sla a		;3e80	cb 27 	. ' 
	sla a		;3e82	cb 27 	. ' 
	sla a		;3e84	cb 27 	. ' 
	ld b,000h		;3e86	06 00 	. . 
	ld c,a			;3e88	4f 	O 
	ld hl,(0f012h)		;3e89	2a 12 f0 	* . . 
	add hl,bc			;3e8c	09 	. 
	ld a,(hl)			;3e8d	7e 	~ 
	ld (0f016h),a		;3e8e	32 16 f0 	2 . . 
	inc hl			;3e91	23 	# 
	ld (0f014h),hl		;3e92	22 14 f0 	" . . 
	jp sub_3ce2h		;3e95	c3 e2 3c 	. . < 
l3e98h:
	ld b,a			;3e98	47 	G 
	sub 010h		;3e99	d6 10 	. . 
	and 0f0h		;3e9b	e6 f0 	. . 
	srl a		;3e9d	cb 3f 	. ? 
	ld c,a			;3e9f	4f 	O 
	ld a,b			;3ea0	78 	x 
	and 00fh		;3ea1	e6 0f 	. . 
	add a,c			;3ea3	81 	. 
	ld e,a			;3ea4	5f 	_ 
	ld a,(0f00fh)		;3ea5	3a 0f f0 	: . . 
	ld c,a			;3ea8	4f 	O 
	bit 7,a		;3ea9	cb 7f 	.  
	jr nz,l3eb1h		;3eab	20 04 	  . 
	and 050h		;3ead	e6 50 	. P 
	jr nz,l3f27h		;3eaf	20 76 	  v 
l3eb1h:
	ld a,(0f775h)		;3eb1	3a 75 f7 	: u . 
	and 00fh		;3eb4	e6 0f 	. . 
	cp 00bh		;3eb6	fe 0b 	. . 
	call z,sub_3f50h		;3eb8	cc 50 3f 	. P ? 
	call sub_3eedh		;3ebb	cd ed 3e 	. . > 
	ret c			;3ebe	d8 	. 
	ld a,c			;3ebf	79 	y 
	and 080h		;3ec0	e6 80 	. . 
	jr nz,l3f13h		;3ec2	20 4f 	  O 
	bit 7,b		;3ec4	cb 78 	. x 
	jr z,l3ed9h		;3ec6	28 11 	( . 
	res 7,b		;3ec8	cb b8 	. . 
	bit 2,c		;3eca	cb 51 	. Q 
	jr z,l3ed9h		;3ecc	28 0b 	( . 
	ld a,c			;3ece	79 	y 
	and 003h		;3ecf	e6 03 	. . 
	ld a,020h		;3ed1	3e 20 	>   
	jr nz,l3ed7h		;3ed3	20 02 	  . 
	neg		;3ed5	ed 44 	. D 
l3ed7h:
	add a,b			;3ed7	80 	. 
	ld b,a			;3ed8	47 	G 
l3ed9h:
	ld a,(0f01dh)		;3ed9	3a 1d f0 	: . . 
	or a			;3edc	b7 	. 
	ld a,b			;3edd	78 	x 
	jr z,l3ee9h		;3ede	28 09 	( . 
l3ee0h:
	cp 040h		;3ee0	fe 40 	. @ 
	jr c,l3ee9h		;3ee2	38 05 	8 . 
	cp 080h		;3ee4	fe 80 	. . 
	call c,sub_4020h		;3ee6	dc 20 40 	.   @ 
l3ee9h:
	or a			;3ee9	b7 	. 
	ld c,000h		;3eea	0e 00 	. . 
	ret			;3eec	c9 	. 
sub_3eedh:
	ld d,000h		;3eed	16 00 	. . 
	ld hl,l4aa0h		;3eef	21 a0 4a 	! . J 
	add hl,de			;3ef2	19 	. 
	add hl,de			;3ef3	19 	. 
	ld d,(hl)			;3ef4	56 	V 
	inc hl			;3ef5	23 	# 
	ld e,(hl)			;3ef6	5e 	^ 
	ld a,(0f81dh)		;3ef7	3a 1d f8 	: . . 
	ld b,a			;3efa	47 	G 
	and d			;3efb	a2 	. 
	jr z,l3f07h		;3efc	28 09 	( . 
l3efeh:
	rrc d		;3efe	cb 0a 	. . 
	jr nc,l3f03h		;3f00	30 01 	0 . 
	inc e			;3f02	1c 	. 
l3f03h:
	rrc b		;3f03	cb 08 	. . 
	jr nc,l3efeh		;3f05	30 f7 	0 . 
l3f07h:
	ld hl,(0f010h)		;3f07	2a 10 f0 	* . . 
	ld d,000h		;3f0a	16 00 	. . 
	add hl,de			;3f0c	19 	. 
	ld a,(hl)			;3f0d	7e 	~ 
	ld b,a			;3f0e	47 	G 
l3f0fh:
	cp 0ffh		;3f0f	fe ff 	. . 
	ccf			;3f11	3f 	? 
	ret			;3f12	c9 	. 
l3f13h:
	ld a,c			;3f13	79 	y 
	and 003h		;3f14	e6 03 	. . 
	ld a,b			;3f16	78 	x 
	ret z			;3f17	c8 	. 
	bit 7,b		;3f18	cb 78 	. x 
	jr z,l3ee0h		;3f1a	28 c4 	( . 
	res 7,b		;3f1c	cb b8 	. . 
	bit 2,c		;3f1e	cb 51 	. Q 
	ld a,b			;3f20	78 	x 
	jr z,l3ee0h		;3f21	28 bd 	( . 
	sub 020h		;3f23	d6 20 	.   
	jr l3ee0h		;3f25	18 b9 	. . 
l3f27h:
	call l3f07h		;3f27	cd 07 3f 	. . ? 
	ret c			;3f2a	d8 	. 
	ld a,c			;3f2b	79 	y 
	and 040h		;3f2c	e6 40 	. @ 
	ld a,b			;3f2e	78 	x 
l3f2fh:
	jr z,l3f3ch		;3f2f	28 0b 	( . 
	cp 0eeh		;3f31	fe ee 	. . 
	ccf			;3f33	3f 	? 
	ret nz			;3f34	c0 	. 
	ld a,c			;3f35	79 	y 
	and 003h		;3f36	e6 03 	. . 
	ld a,b			;3f38	78 	x 
	ret z			;3f39	c8 	. 
l3f3ah:
	inc a			;3f3a	3c 	< 
	ret			;3f3b	c9 	. 
l3f3ch:
	sub 0a0h		;3f3c	d6 a0 	. . 
	jr c,l3f4dh		;3f3e	38 0d 	8 . 
	ld e,a			;3f40	5f 	_ 
	ld a,(0f81dh)		;3f41	3a 1d f8 	: . . 
	or a			;3f44	b7 	. 
	jr z,l3f48h		;3f45	28 01 	( . 
	inc e			;3f47	1c 	. 
l3f48h:
	ld hl,l4cbeh		;3f48	21 be 4c 	! . L 
	add hl,de			;3f4b	19 	. 
	ld b,(hl)			;3f4c	46 	F 
l3f4dh:
	ld a,b			;3f4d	78 	x 
	jr l3f0fh		;3f4e	18 bf 	. . 
sub_3f50h:
	ld a,e			;3f50	7b 	{ 
	cp 017h		;3f51	fe 17 	. . 
	ld d,030h		;3f53	16 30 	. 0 
	jr z,l3f5bh		;3f55	28 04 	( . 
	cp d			;3f57	ba 	. 
	ret nz			;3f58	c0 	. 
	ld d,017h		;3f59	16 17 	. . 
l3f5bh:
	ld e,d			;3f5b	5a 	Z 
	ret			;3f5c	c9 	. 
l3f5dh:
	ld b,a			;3f5d	47 	G 
	ld a,(0f00fh)		;3f5e	3a 0f f0 	: . . 
	bit 7,a		;3f61	cb 7f 	.  
	jr z,l3f69h		;3f63	28 04 	( . 
	ld a,009h		;3f65	3e 09 	> . 
	jr l3f70h		;3f67	18 07 	. . 
l3f69h:
	and 003h		;3f69	e6 03 	. . 
	ld a,004h		;3f6b	3e 04 	> . 
	jr nz,l3f70h		;3f6d	20 01 	  . 
	xor a			;3f6f	af 	. 
l3f70h:
	add a,b			;3f70	80 	. 
	ld b,000h		;3f71	06 00 	. . 
	ld c,a			;3f73	4f 	O 
	cp 004h		;3f74	fe 04 	. . 
	jr c,l3f87h		;3f76	38 0f 	8 . 
	ld a,(YSFCMFLG)		;3f78	3a 18 f0 	: . . 
	inc a			;3f7b	3c 	< 
	jr nz,l3f87h		;3f7c	20 09 	  . 
	ld hl,l3fb1h		;3f7e	21 b1 3f 	! . ? 
	add hl,bc			;3f81	09 	. 
	ld a,(hl)			;3f82	7e 	~ 
	ld c,0ffh		;3f83	0e ff 	. . 
	or a			;3f85	b7 	. 
	ret			;3f86	c9 	. 
l3f87h:
	ld hl,0f328h		;3f87	21 28 f3 	! ( . 
	add hl,bc			;3f8a	09 	. 
	ld a,(hl)			;3f8b	7e 	~ 
	cp 080h		;3f8c	fe 80 	. . 
	jr z,l3f9fh		;3f8e	28 0f 	( . 
	cp 0f6h		;3f90	fe f6 	. . 
	jr nc,l3f97h		;3f92	30 03 	0 . 
	jp l3ee9h		;3f94	c3 e9 3e 	. . > 
l3f97h:
	sub 0f6h		;3f97	d6 f6 	. . 
	ld hl,l3fa1h		;3f99	21 a1 3f 	! . ? 
	call sub_3fc0h		;3f9c	cd c0 3f 	. . ? 
l3f9fh:
	scf			;3f9f	37 	7 
	ret			;3fa0	c9 	. 
l3fa1h:
	exx			;3fa1	d9 	. 
	ld c,h			;3fa2	4c 	L 
	call nc,0f74ch		;3fa3	d4 4c f7 	. L . 
	ld c,h			;3fa6	4c 	L 
	jp p,0fc4ch		;3fa7	f2 4c fc 	. L . 
	ld c,h			;3faa	4c 	L 
	ld bc,0e34dh		;3fab	01 4d e3 	. M . 
	ld c,h			;3fae	4c 	L 
	sbc a,04ch		;3faf	de 4c 	. L 
l3fb1h:
	ret pe			;3fb1	e8 	. 
	ld c,h			;3fb2	4c 	L 
	defb 0edh;next byte illegal after ed		;3fb3	ed 	. 
	ld c,h			;3fb4	4c 	L 
	xor a			;3fb5	af 	. 
	xor (hl)			;3fb6	ae 	. 
	or e			;3fb7	b3 	. 
	or h			;3fb8	b4 	. 
	or l			;3fb9	b5 	. 
	xor l			;3fba	ad 	. 
	xor h			;3fbb	ac 	. 
	or b			;3fbc	b0 	. 
	or c			;3fbd	b1 	. 
	or d			;3fbe	b2 	. 
l3fbfh:
	push de			;3fbf	d5 	. 
sub_3fc0h:
	add a,a			;3fc0	87 	. 
	ld c,a			;3fc1	4f 	O 
	ld b,000h		;3fc2	06 00 	. . 
	add hl,bc			;3fc4	09 	. 
sub_3fc5h:
	ld b,(hl)			;3fc5	46 	F 
	inc hl			;3fc6	23 	# 
	ld h,(hl)			;3fc7	66 	f 
	ld l,b			;3fc8	68 	h 
	jp (hl)			;3fc9	e9 	. 
sub_3fcah:
	call sub_3cf5h		;3fca	cd f5 3c 	. . < 
	ret c			;3fcd	d8 	. 
	cp 0a0h		;3fce	fe a0 	. . 
	jr c,l3feah		;3fd0	38 18 	8 . 
	ld hl,0f01ch		;3fd2	21 1c f0 	! . . 
	cp 0b7h		;3fd5	fe b7 	. . 
	jr nz,sub_3fcah		;3fd7	20 f1 	  . 
	ld a,(hl)			;3fd9	7e 	~ 
	xor 020h		;3fda	ee 20 	.   
	ld (hl),a			;3fdc	77 	w 
	rra			;3fdd	1f 	. 
	ld hl,0f006h		;3fde	21 06 f0 	! . . 
	res 4,(hl)		;3fe1	cb a6 	. . 
	or (hl)			;3fe3	b6 	. 
	ld c,a			;3fe4	4f 	O 
	call sub_3df0h		;3fe5	cd f0 3d 	. . = 
	jr sub_3fcah		;3fe8	18 e0 	. . 
l3feah:
	cp 040h		;3fea	fe 40 	. @ 
	jr c,l4002h		;3fec	38 14 	8 . 
	cp 058h		;3fee	fe 58 	. X 
	jr c,l3ff4h		;3ff0	38 02 	8 . 
	sub 018h		;3ff2	d6 18 	. . 
l3ff4h:
	cp 05fh		;3ff4	fe 5f 	. _ 
	ret nc			;3ff6	d0 	. 
	ld b,a			;3ff7	47 	G 
	ld a,(0f01ch)		;3ff8	3a 1c f0 	: . . 
	add a,b			;3ffb	80 	. 
	call sub_4020h		;3ffc	cd 20 40 	.   @ 
	jr c,sub_3fcah		;3fff	38 c9 	8 . 
	ret			;4001	c9 	. 
l4002h:
	ld b,a			;4002	47 	G 
	and 0f0h		;4003	e6 f0 	. . 
	srl a		;4005	cb 3f 	. ? 
	ld c,a			;4007	4f 	O 
	ld a,b			;4008	78 	x 
	and 00fh		;4009	e6 0f 	. . 
	add a,c			;400b	81 	. 
	sub 008h		;400c	d6 08 	. . 
	ld hl,0f0ddh		;400e	21 dd f0 	! . . 
	ld c,a			;4011	4f 	O 
	ld b,000h		;4012	06 00 	. . 
	add hl,bc			;4014	09 	. 
	ld b,(hl)			;4015	46 	F 
	ld a,b			;4016	78 	x 
	inc b			;4017	04 	. 
	ret nz			;4018	c0 	. 
	ld a,003h		;4019	3e 03 	> . 
	ld hl,l4cceh+2		;401b	21 d0 4c 	! . L 
	jr l4035h		;401e	18 15 	. . 
sub_4020h:
	ld b,a			;4020	47 	G 
	sub 040h		;4021	d6 40 	. @ 
	ld l,a			;4023	6f 	o 
	ld h,000h		;4024	26 00 	& . 
	add hl,hl			;4026	29 	) 
	add hl,hl			;4027	29 	) 
	add hl,hl			;4028	29 	) 
	add hl,hl			;4029	29 	) 
	ld de,0cc00h		;402a	11 00 cc 	. . . 
	add hl,de			;402d	19 	. 
	ld a,(hl)			;402e	7e 	~ 
	or a			;402f	b7 	. 
	jr nz,l4035h		;4030	20 03 	  . 
	ld a,b			;4032	78 	x 
	scf			;4033	37 	7 
	ret			;4034	c9 	. 
l4035h:
	ld (0f016h),a		;4035	32 16 f0 	2 . . 
	inc hl			;4038	23 	# 
	ld (0f014h),hl		;4039	22 14 f0 	" . . 
	jp sub_3ce2h		;403c	c3 e2 3c 	. . < 
l403fh:
	call sub_6ef9h		;403f	cd f9 6e 	. . n 
	ret nz			;4042	c0 	. 
	call l405dh		;4043	cd 5d 40 	. ] @ 
	inc a			;4046	3c 	< 
	jr nz,l403fh		;4047	20 f6 	  . 
	ld a,c			;4049	79 	y 
	out (017h),a		;404a	d3 17 	. . 
	ld a,(0f006h)		;404c	3a 06 f0 	: . . 
	or 001h		;404f	f6 01 	. . 
	out (019h),a		;4051	d3 19 	. . 
	and 0feh		;4053	e6 fe 	. . 
	out (019h),a		;4055	d3 19 	. . 
	ld a,0ffh		;4057	3e ff 	> . 
	out (017h),a		;4059	d3 17 	. . 
	xor a			;405b	af 	. 
	ret			;405c	c9 	. 
l405dh:
	in a,(016h)		;405d	db 16 	. . 
	and 003h		;405f	e6 03 	. . 
	ld a,0ffh		;4061	3e ff 	> . 
	ret z			;4063	c8 	. 
	xor a			;4064	af 	. 
	ret			;4065	c9 	. 
l4066h:
	push af			;4066	f5 	. 
	push de			;4067	d5 	. 
	push hl			;4068	e5 	. 
	ld a,(0f53eh)		;4069	3a 3e f5 	: > . 
	ld d,a			;406c	57 	W 
	ld a,(0ef93h)		;406d	3a 93 ef 	: . . 
	ld e,a			;4070	5f 	_ 
	push de			;4071	d5 	. 
	ld a,b			;4072	78 	x 
	rla			;4073	17 	. 
	jr c,l40a8h		;4074	38 32 	8 2 
	xor a			;4076	af 	. 
	ld (0f53eh),a		;4077	32 3e f5 	2 > . 
	out (004h),a		;407a	d3 04 	. . 
	push bc			;407c	c5 	. 
	ld a,c			;407d	79 	y 
	ld (0ef93h),a		;407e	32 93 ef 	2 . . 
	xor e			;4081	ab 	. 
	or 003h		;4082	f6 03 	. . 
	ld e,a			;4084	5f 	_ 
	ld a,c			;4085	79 	y 
	ld hl,l40adh		;4086	21 ad 40 	! . @ 
	ld b,004h		;4089	06 04 	. . 
l408bh:
	rra			;408b	1f 	. 
	push af			;408c	f5 	. 
	ld a,(hl)			;408d	7e 	~ 
	inc hl			;408e	23 	# 
	jr c,l4092h		;408f	38 01 	8 . 
	ld a,(hl)			;4091	7e 	~ 
l4092h:
	inc hl			;4092	23 	# 
	rrc e		;4093	cb 0b 	. . 
	jr nc,l409eh		;4095	30 07 	0 . 
	or a			;4097	b7 	. 
	jr z,l409eh		;4098	28 04 	( . 
	ld c,a			;409a	4f 	O 
	call WRT7508		;409b	cd 61 3c 	. a < 
l409eh:
	pop af			;409e	f1 	. 
	djnz l408bh		;409f	10 ea 	. . 
	pop bc			;40a1	c1 	. 
	ld a,b			;40a2	78 	x 
	ld (0f53eh),a		;40a3	32 3e f5 	2 > . 
	out (004h),a		;40a6	d3 04 	. . 
l40a8h:
	pop bc			;40a8	c1 	. 
	pop hl			;40a9	e1 	. 
	pop de			;40aa	d1 	. 
	pop af			;40ab	f1 	. 
	ret			;40ac	c9 	. 
l40adh:
	dec de			;40ad	1b 	. 
	ld b,016h		;40ae	06 16 	. . 
	nop			;40b0	00 	. 
	add hl,sp			;40b1	39 	9 
	add hl,hl			;40b2	29 	) 
	dec e			;40b3	1d 	. 
	dec c			;40b4	0d 	. 
l40b5h:
	ld bc,(OLDBNK)		;40b5	ed 4b 2c f5 	. K , . 
	ret			;40b9	c9 	. 
l40bah:
	call sub_0b80h		;40ba	cd 80 0b 	. . . 
	ld a,c			;40bd	79 	y 
	cp 002h		;40be	fe 02 	. . 
	ld c,00ah		;40c0	0e 0a 	. . 
	jr z,l40cah		;40c2	28 06 	( . 
	cp 004h		;40c4	fe 04 	. . 
	jr nz,l40cdh		;40c6	20 05 	  . 
	ld c,008h		;40c8	0e 08 	. . 
l40cah:
	call z,CMD7508		;40ca	cc 6f 3c 	. o < 
l40cdh:
	push af			;40cd	f5 	. 
	call sub_0b87h		;40ce	cd 87 0b 	. . . 
	pop af			;40d1	f1 	. 
	ret			;40d2	c9 	. 
l40d3h:
	push hl			;40d3	e5 	. 
	ld de,l0780h		;40d4	11 80 07 	. . . 
	or a			;40d7	b7 	. 
	sbc hl,de		;40d8	ed 52 	. R 
	pop hl			;40da	e1 	. 
	ld a,001h		;40db	3e 01 	> . 
	ret nc			;40dd	d0 	. 
	push hl			;40de	e5 	. 
	call sub_513ch		;40df	cd 3c 51 	. < Q 
	ld a,(0f2a0h)		;40e2	3a a0 f2 	: . . 
	or a			;40e5	b7 	. 
	ld de,l001eh		;40e6	11 1e 00 	. . . 
l40e9h:
	sbc hl,de		;40e9	ed 52 	. R 
	jr c,l40f0h		;40eb	38 03 	8 . 
	inc a			;40ed	3c 	< 
	jr l40e9h		;40ee	18 f9 	. . 
l40f0h:
	add hl,de			;40f0	19 	. 
	ex de,hl			;40f1	eb 	. 
	push bc			;40f2	c5 	. 
	cp 040h		;40f3	fe 40 	. @ 
	jr c,l40f9h		;40f5	38 02 	8 . 
	sub 040h		;40f7	d6 40 	. @ 
l40f9h:
	ld b,a			;40f9	47 	G 
	ld c,020h		;40fa	0e 20 	.   
	call sub_59b0h		;40fc	cd b0 59 	. . Y 
	add hl,de			;40ff	19 	. 
	ld de,(0f294h)		;4100	ed 5b 94 f2 	. [ . . 
	add hl,de			;4104	19 	. 
	pop bc			;4105	c1 	. 
	ld a,b			;4106	78 	x 
	and (hl)			;4107	a6 	. 
	dec c			;4108	0d 	. 
	jr z,l4116h		;4109	28 0b 	( . 
	ld a,b			;410b	78 	x 
	or (hl)			;410c	b6 	. 
	dec c			;410d	0d 	. 
l410eh:
	jr z,l4116h		;410e	28 06 	( . 
	ld a,b			;4110	78 	x 
	xor (hl)			;4111	ae 	. 
	dec c			;4112	0d 	. 
	jr z,l4116h		;4113	28 01 	( . 
	ld a,b			;4115	78 	x 
l4116h:
	ld c,a			;4116	4f 	O 
	ld (hl),a			;4117	77 	w 
	call sub_512ch		;4118	cd 2c 51 	. , Q 
	pop hl			;411b	e1 	. 
	xor a			;411c	af 	. 
	ret			;411d	c9 	. 
l411eh:
	ld de,AUTOSTRT		;411e	11 bd f3 	. . . 
	ld a,c			;4121	79 	y 
	or a			;4122	b7 	. 
	jr nz,l4127h		;4123	20 02 	  . 
	ld (de),a			;4125	12 	. 
	ret			;4126	c9 	. 
l4127h:
	dec a			;4127	3d 	= 
	ret nz			;4128	c0 	. 
	ld bc,(OLDBNK)		;4129	ed 4b 2c f5 	. K , . 
	call 0ec64h		;412d	cd 64 ec 	. d . 
	cp 021h		;4130	fe 21 	. ! 
	jr c,l4136h		;4132	38 02 	8 . 
	ld a,020h		;4134	3e 20 	>   
l4136h:
	ld (de),a			;4136	12 	. 
	or a			;4137	b7 	. 
	ret z			;4138	c8 	. 
	ld c,a			;4139	4f 	O 
	inc de			;413a	13 	. 
	push de			;413b	d5 	. 
	ld a,020h		;413c	3e 20 	>   
l413eh:
	ld b,a			;413e	47 	G 
l413fh:
	ld (de),a			;413f	12 	. 
	inc de			;4140	13 	. 
	djnz l413fh		;4141	10 fc 	. . 
	pop de			;4143	d1 	. 
	inc hl			;4144	23 	# 
	ld a,(OLDBNK)		;4145	3a 2c f5 	: , . 
	jp 0ec8eh		;4148	c3 8e ec 	. . . 
l414bh:
	ld a,c			;414b	79 	y 
	ld (0ef28h),a		;414c	32 28 ef 	2 ( . 
	ret			;414f	c9 	. 
l4150h:
	ld a,c			;4150	79 	y 
	and 001h		;4151	e6 01 	. . 
	ld (FRCENTN),a		;4153	32 11 f3 	2 . . 
	ld a,c			;4156	79 	y 
	and 002h		;4157	e6 02 	. . 
	ld (IFRCECNT),a		;4159	32 12 f3 	2 . . 
	ret			;415c	c9 	. 
sub_415dh:
	ld a,0ffh		;415d	3e ff 	> . 
	ld (OLDBNK),a		;415f	32 2c f5 	2 , . 
sub_4162h:
	call sub_4264h		;4162	cd 64 42 	. d B 
	ld a,c			;4165	79 	y 
	inc a			;4166	3c 	< 
	jp z,l41bfh		;4167	ca bf 41 	. . A 
	dec a			;416a	3d 	= 
	jr z,l41a5h		;416b	28 38 	( 8 
	sub 080h		;416d	d6 80 	. . 
	jp c,l4274h		;416f	da 74 42 	. t B 
	cp 007h		;4172	fe 07 	. . 
	jp nc,l4274h		;4174	d2 74 42 	. t B 
	ld hl,l4274h		;4177	21 74 42 	! t B 
	push hl			;417a	e5 	. 
	ld hl,l4181h		;417b	21 81 41 	! . A 
	jp sub_3fc0h		;417e	c3 c0 3f 	. . ? 
l4181h:
	adc a,a			;4181	8f 	. 
	ld b,c			;4182	41 	A 
	sbc a,c			;4183	99 	. 
	ld b,c			;4184	41 	A 
	inc d			;4185	14 	. 
	ld b,d			;4186	42 	B 
	sbc a,0ffh		;4187	de ff 	. . 
	rst 18h			;4189	df 	. 
	ld b,c			;418a	41 	A 
	pop hl			;418b	e1 	. 
	rst 38h			;418c	ff 	. 
	call po,sub_21ffh		;418d	e4 ff 21 	. . ! 
	sub e			;4190	93 	. 
	rst 28h			;4191	ef 	. 
	ld a,(hl)			;4192	7e 	~ 
	or 004h		;4193	f6 04 	. . 
	ld c,039h		;4195	0e 39 	. 9 
	jr l41a1h		;4197	18 08 	. . 
sub_4199h:
	ld hl,0ef93h		;4199	21 93 ef 	! . . 
	ld a,(hl)			;419c	7e 	~ 
	and 0fbh		;419d	e6 fb 	. . 
	ld c,029h		;419f	0e 29 	. ) 
l41a1h:
	ld (hl),a			;41a1	77 	w 
	jp WRT7508		;41a2	c3 61 3c 	. a < 
l41a5h:
	ld c,007h		;41a5	0e 07 	. . 
	call CMD7508		;41a7	cd 6f 3c 	. o < 
	add a,a			;41aa	87 	. 
	add a,a			;41ab	87 	. 
	add a,a			;41ac	87 	. 
	add a,a			;41ad	87 	. 
	ld b,a			;41ae	47 	G 
	call sub_3c7bh		;41af	cd 7b 3c 	. { < 
	or b			;41b2	b0 	. 
	call sub_427eh		;41b3	cd 7e 42 	. ~ B 
	ld b,006h		;41b6	06 06 	. . 
	push de			;41b8	d5 	. 
	call sub_429ah		;41b9	cd 9a 42 	. . B 
	pop de			;41bc	d1 	. 
	jr l41dch		;41bd	18 1d 	. . 
l41bfh:
	ld c,017h		;41bf	0e 17 	. . 
	call WRT7508		;41c1	cd 61 3c 	. a < 
	push de			;41c4	d5 	. 
	call sub_4284h		;41c5	cd 84 42 	. . B 
	rra			;41c8	1f 	. 
	rra			;41c9	1f 	. 
	rra			;41ca	1f 	. 
	rra			;41cb	1f 	. 
	call sub_42a4h		;41cc	cd a4 42 	. . B 
	call sub_4284h		;41cf	cd 84 42 	. . B 
	call sub_42a4h		;41d2	cd a4 42 	. . B 
	ld b,006h		;41d5	06 06 	. . 
	inc de			;41d7	13 	. 
	call sub_4290h		;41d8	cd 90 42 	. . B 
	pop de			;41db	d1 	. 
l41dch:
	jp l4274h		;41dc	c3 74 42 	. t B 
	ld a,0ffh		;41df	3e ff 	> . 
	call sub_427eh		;41e1	cd 7e 42 	. ~ B 
	push de			;41e4	d5 	. 
	inc de			;41e5	13 	. 
	ld c,009h		;41e6	0e 09 	. . 
	call CMD7508		;41e8	cd 6f 3c 	. o < 
	call sub_427eh		;41eb	cd 7e 42 	. ~ B 
	ld b,003h		;41ee	06 03 	. . 
	call sub_429ah		;41f0	cd 9a 42 	. . B 
	call sub_3c7bh		;41f3	cd 7b 3c 	. { < 
	add a,a			;41f6	87 	. 
	add a,a			;41f7	87 	. 
	add a,a			;41f8	87 	. 
	add a,a			;41f9	87 	. 
	inc de			;41fa	13 	. 
	call sub_427eh		;41fb	cd 7e 42 	. ~ B 
	call sub_3c7bh		;41fe	cd 7b 3c 	. { < 
	inc de			;4201	13 	. 
	call sub_427eh		;4202	cd 7e 42 	. ~ B 
	inc de			;4205	13 	. 
	ld bc,l0003h+1		;4206	01 04 00 	. . . 
	ld hl,ALRMTP		;4209	21 8a ef 	! . . 
	call 0ec88h		;420c	cd 88 ec 	. . . 
	xor a			;420f	af 	. 
	dec hl			;4210	2b 	+ 
	ld (hl),a			;4211	77 	w 
	pop de			;4212	d1 	. 
	ret			;4213	c9 	. 
	call sub_4199h		;4214	cd 99 41 	. . A 
	ld c,019h		;4217	0e 19 	. . 
	call WRT7508		;4219	cd 61 3c 	. a < 
	push de			;421c	d5 	. 
	inc de			;421d	13 	. 
	ld b,004h		;421e	06 04 	. . 
	call sub_4290h		;4220	cd 90 42 	. . B 
	call sub_4284h		;4223	cd 84 42 	. . B 
	rra			;4226	1f 	. 
	rra			;4227	1f 	. 
	rra			;4228	1f 	. 
	rra			;4229	1f 	. 
	call sub_42a4h		;422a	cd a4 42 	. . B 
	inc de			;422d	13 	. 
	call sub_4284h		;422e	cd 84 42 	. . B 
	call sub_42a6h		;4231	cd a6 42 	. . B 
	inc de			;4234	13 	. 
	ld bc,l0003h		;4235	01 03 00 	. . . 
	ld hl,ALRMTP		;4238	21 8a ef 	! . . 
	ex de,hl			;423b	eb 	. 
	ld a,(OLDBNK)		;423c	3a 2c f5 	: , . 
	call 0ec5eh		;423f	cd 5e ec 	. ^ . 
	xor a			;4242	af 	. 
	ld (de),a			;4243	12 	. 
	ld (0eff2h),a		;4244	32 f2 ef 	2 . . 
	ld hl,(ALRMAD)		;4247	2a 8b ef 	* . . 
	ld de,ALRMMSG		;424a	11 df f3 	. . . 
	push de			;424d	d5 	. 
	ld bc,l0021h		;424e	01 21 00 	. ! . 
	ld a,(OLDBNK)		;4251	3a 2c f5 	: , . 
	call 0ec5eh		;4254	cd 5e ec 	. ^ . 
	pop de			;4257	d1 	. 
	ld a,(de)			;4258	1a 	. 
	cp 021h		;4259	fe 21 	. ! 
	jr c,l4260h		;425b	38 03 	8 . 
	ld a,020h		;425d	3e 20 	>   
	ld (de),a			;425f	12 	. 
l4260h:
	pop de			;4260	d1 	. 
	jp 0418fh		;4261	c3 8f 41 	. . A 
sub_4264h:
	xor a			;4264	af 	. 
	out (004h),a		;4265	d3 04 	. . 
	ld a,(0f53eh)		;4267	3a 3e f5 	: > . 
	pop hl			;426a	e1 	. 
	push af			;426b	f5 	. 
	res 0,a		;426c	cb 87 	. . 
	ld (0f53eh),a		;426e	32 3e f5 	2 > . 
	out (004h),a		;4271	d3 04 	. . 
	jp (hl)			;4273	e9 	. 
l4274h:
	xor a			;4274	af 	. 
	out (004h),a		;4275	d3 04 	. . 
	pop af			;4277	f1 	. 
	ld (0f53eh),a		;4278	32 3e f5 	2 > . 
	out (004h),a		;427b	d3 04 	. . 
	ret			;427d	c9 	. 
sub_427eh:
	ex de,hl			;427e	eb 	. 
	call 0ec76h		;427f	cd 76 ec 	. v . 
	ex de,hl			;4282	eb 	. 
	ret			;4283	c9 	. 
sub_4284h:
	push bc			;4284	c5 	. 
	ex de,hl			;4285	eb 	. 
	ld bc,(OLDBNK)		;4286	ed 4b 2c f5 	. K , . 
	call 0ec64h		;428a	cd 64 ec 	. d . 
	ex de,hl			;428d	eb 	. 
	pop bc			;428e	c1 	. 
	ret			;428f	c9 	. 
sub_4290h:
	call sub_4284h		;4290	cd 84 42 	. . B 
	call sub_42a6h		;4293	cd a6 42 	. . B 
	inc de			;4296	13 	. 
	djnz sub_4290h		;4297	10 f7 	. . 
	ret			;4299	c9 	. 
sub_429ah:
	call sub_3c7bh		;429a	cd 7b 3c 	. { < 
	inc de			;429d	13 	. 
	call sub_427eh		;429e	cd 7e 42 	. ~ B 
	djnz sub_429ah		;42a1	10 f7 	. . 
	ret			;42a3	c9 	. 
sub_42a4h:
	and 00fh		;42a4	e6 0f 	. . 
sub_42a6h:
	ld c,a			;42a6	4f 	O 
	set 7,c		;42a7	cb f9 	. . 
	jp WRT7508		;42a9	c3 61 3c 	. a < 
l42ach:
	ld a,b			;42ac	78 	x 
	and 0f0h		;42ad	e6 f0 	. . 
	cp 0f0h		;42af	fe f0 	. . 
	jp z,sub_45e6h		;42b1	ca e6 45 	. . E 
	cp 0a0h		;42b4	fe a0 	. . 
	jr nc,$+95		;42b6	30 5d 	0 ] 
	ld (0f79dh),hl		;42b8	22 9d f7 	" . . 
	ld a,b			;42bb	78 	x 
	and 00fh		;42bc	e6 0f 	. . 
	ld (0f7a5h),a		;42be	32 a5 f7 	2 . . 
	ld a,b			;42c1	78 	x 
	rrca			;42c2	0f 	. 
	rrca			;42c3	0f 	. 
	rrca			;42c4	0f 	. 
	rrca			;42c5	0f 	. 
	and 00fh		;42c6	e6 0f 	. . 
	ld hl,l4301h		;42c8	21 01 43 	! . C 
	call sub_5e4ch		;42cb	cd 4c 5e 	. L ^ 
	ld de,l42dbh		;42ce	11 db 42 	. . B 
	push de			;42d1	d5 	. 
	push hl			;42d2	e5 	. 
	push bc			;42d3	c5 	. 
	ld c,001h		;42d4	0e 01 	. . 
	call sub_47b8h		;42d6	cd b8 47 	. . G 
	pop bc			;42d9	c1 	. 
	ret			;42da	c9 	. 
l42dbh:
	ld h,a			;42db	67 	g 
	ld l,040h		;42dc	2e 40 	. @ 
	jr nc,l42e2h		;42de	30 02 	0 . 
	ld l,000h		;42e0	2e 00 	. . 
l42e2h:
	push hl			;42e2	e5 	. 
	push bc			;42e3	c5 	. 
	call sub_457dh		;42e4	cd 7d 45 	. } E 
	and 088h		;42e7	e6 88 	. . 
	ld b,a			;42e9	47 	G 
	ld hl,0f787h		;42ea	21 87 f7 	! . . 
	ld a,(hl)			;42ed	7e 	~ 
	and 077h		;42ee	e6 77 	. w 
	or b			;42f0	b0 	. 
	ld (hl),a			;42f1	77 	w 
	ld de,(0f79dh)		;42f2	ed 5b 9d f7 	. [ . . 
	push de			;42f6	d5 	. 
	ld bc,l0009h		;42f7	01 09 00 	. . . 
	call 0ec88h		;42fa	cd 88 ec 	. . . 
	pop hl			;42fd	e1 	. 
	pop bc			;42fe	c1 	. 
	pop af			;42ff	f1 	. 
	ret			;4300	c9 	. 
l4301h:
	dec d			;4301	15 	. 
	ld b,e			;4302	43 	C 
	add hl,sp			;4303	39 	9 
	ld b,e			;4304	43 	C 
	ld e,l			;4305	5d 	] 
	ld b,h			;4306	44 	D 
	ld (hl),d			;4307	72 	r 
	ld b,h			;4308	44 	D 
	add a,a			;4309	87 	. 
	ld b,h			;430a	44 	D 
	sub h			;430b	94 	. 
	ld b,h			;430c	44 	D 
	dec l			;430d	2d 	- 
	ld b,l			;430e	45 	E 
	ld a,c			;430f	79 	y 
	ld b,l			;4310	45 	E 
	and d			;4311	a2 	. 
	ld b,l			;4312	45 	E 
	jp z,03e45h		;4313	ca 45 3e 	. E > 
	inc b			;4316	04 	. 
	or a			;4317	b7 	. 
	ret			;4318	c9 	. 
sub_4319h:
	call sub_431fh		;4319	cd 1f 43 	. . C 
	ret nc			;431c	d0 	. 
	pop hl			;431d	e1 	. 
	ret			;431e	c9 	. 
sub_431fh:
	ld a,(0f7a6h)		;431f	3a a6 f7 	: . . 
	and 00fh		;4322	e6 0f 	. . 
	cp 00fh		;4324	fe 0f 	. . 
	ld a,002h		;4326	3e 02 	> . 
	ccf			;4328	3f 	? 
	ret nc			;4329	d0 	. 
	ld a,003h		;432a	3e 03 	> . 
	ret			;432c	c9 	. 
sub_432dh:
	ld a,(0f79ch)		;432d	3a 9c f7 	: . . 
	and 040h		;4330	e6 40 	. @ 
	scf			;4332	37 	7 
	ret nz			;4333	c0 	. 
sub_4334h:
	in a,(015h)		;4334	db 15 	. . 
	and 001h		;4336	e6 01 	. . 
	ret			;4338	c9 	. 
	call sub_431fh		;4339	cd 1f 43 	. . C 
	ret nc			;433c	d0 	. 
	ld a,001h		;433d	3e 01 	> . 
	ld (0f787h),a		;433f	32 87 f7 	2 . . 
	ld a,(0f7a5h)		;4342	3a a5 f7 	: . . 
	ld (0f7a6h),a		;4345	32 a6 f7 	2 . . 
	ld de,0f78ch		;4348	11 8c f7 	. . . 
	ld hl,(0f79dh)		;434b	2a 9d f7 	* . . 
	ld bc,l0009h		;434e	01 09 00 	. . . 
	call 0ec88h		;4351	cd 88 ec 	. . . 
	ld hl,(0f78ch)		;4354	2a 8c f7 	* . . 
	ld (0f788h),hl		;4357	22 88 f7 	" . . 
	ld (0f78ah),hl		;435a	22 8a f7 	" . . 
	ld de,(0f78eh)		;435d	ed 5b 8e f7 	. [ . . 
	add hl,de			;4361	19 	. 
	ld (0f795h),hl		;4362	22 95 f7 	" . . 
	ld a,(0f794h)		;4365	3a 94 f7 	: . . 
	bit 4,a		;4368	cb 67 	. g 
	jr nz,l4377h		;436a	20 0b 	  . 
	ld hl,0fff0h		;436c	21 f0 ff 	! . . 
	add hl,de			;436f	19 	. 
	jr c,l4377h		;4370	38 05 	8 . 
	or 010h		;4372	f6 10 	. . 
	ld (0f794h),a		;4374	32 94 f7 	2 . . 
l4377h:
	ld h,d			;4377	62 	b 
	ld l,e			;4378	6b 	k 
	srl d		;4379	cb 3a 	. : 
	rr e		;437b	cb 1b 	. . 
	srl d		;437d	cb 3a 	. : 
	rr e		;437f	cb 1b 	. . 
	ld (0f797h),de		;4381	ed 53 97 f7 	. S . . 
	or a			;4385	b7 	. 
	sbc hl,de		;4386	ed 52 	. R 
	ld (0f799h),hl		;4388	22 99 f7 	" . . 
	ld a,(0f791h)		;438b	3a 91 f7 	: . . 
	cp 002h		;438e	fe 02 	. . 
	ld a,07fh		;4390	3e 7f 	>  
	jr z,l4396h		;4392	28 02 	( . 
	ld a,0ffh		;4394	3e ff 	> . 
l4396h:
	ld (0f79bh),a		;4396	32 9b f7 	2 . . 
	jr z,l43a0h		;4399	28 05 	( . 
	ld hl,0f794h		;439b	21 94 f7 	! . . 
	set 2,(hl)		;439e	cb d6 	. . 
l43a0h:
	xor a			;43a0	af 	. 
	ld h,a			;43a1	67 	g 
	ld l,a			;43a2	6f 	o 
	ld (0f79fh),hl		;43a3	22 9f f7 	" . . 
	ld (0f7a1h),hl		;43a6	22 a1 f7 	" . . 
	ld (0f7a4h),a		;43a9	32 a4 f7 	2 . . 
	ld a,002h		;43ac	3e 02 	> . 
	ld (0f7a3h),a		;43ae	32 a3 f7 	2 . . 
	ld a,(0f794h)		;43b1	3a 94 f7 	: . . 
	and 017h		;43b4	e6 17 	. . 
	xor 014h		;43b6	ee 14 	. . 
	ld (0f79ch),a		;43b8	32 9c f7 	2 . . 
	ld de,0f27eh		;43bb	11 7e f2 	. ~ . 
	ld a,(0f790h)		;43be	3a 90 f7 	: . . 
	bit 7,a		;43c1	cb 7f 	.  
	jr z,l43c6h		;43c3	28 01 	( . 
	rlca			;43c5	07 	. 
l43c6h:
	call sub_4418h		;43c6	cd 18 44 	. . D 
	ld (de),a			;43c9	12 	. 
	ld a,(0f791h)		;43ca	3a 91 f7 	: . . 
	call sub_442ch		;43cd	cd 2c 44 	. , D 
	ld b,a			;43d0	47 	G 
	ld a,(0f792h)		;43d1	3a 92 f7 	: . . 
	call sub_4433h		;43d4	cd 33 44 	. 3 D 
	or b			;43d7	b0 	. 
	ld b,a			;43d8	47 	G 
	ld a,(0f793h)		;43d9	3a 93 f7 	: . . 
	call l4439h+1		;43dc	cd 3a 44 	. : D 
	or b			;43df	b0 	. 
	inc de			;43e0	13 	. 
l43e1h:
	ld (de),a			;43e1	12 	. 
	ld a,(0f7a5h)		;43e2	3a a5 f7 	: . . 
	and 00fh		;43e5	e6 0f 	. . 
	call sub_4441h		;43e7	cd 41 44 	. A D 
	inc de			;43ea	13 	. 
	ld (de),a			;43eb	12 	. 
	call sub_4402h		;43ec	cd 02 44 	. . D 
	ld c,001h		;43ef	0e 01 	. . 
	call sub_47bdh		;43f1	cd bd 47 	. . G 
	in a,(014h)		;43f4	db 14 	. . 
	ld a,(0f53eh)		;43f6	3a 3e f5 	: > . 
	or 002h		;43f9	f6 02 	. . 
sub_43fbh:
	ld (0f53eh),a		;43fb	32 3e f5 	2 > . 
	out (004h),a		;43fe	d3 04 	. . 
	xor a			;4400	af 	. 
	ret			;4401	c9 	. 
sub_4402h:
	ld a,(0f794h)		;4402	3a 94 f7 	: . . 
	and 003h		;4405	e6 03 	. . 
	push af			;4407	f5 	. 
l4408h:
	call sub_4448h		;4408	cd 48 44 	. H D 
	ld de,0f281h		;440b	11 81 f2 	. . . 
	ld (de),a			;440e	12 	. 
	pop af			;440f	f1 	. 
	and 001h		;4410	e6 01 	. . 
	call sub_444fh		;4412	cd 4f 44 	. O D 
	inc de			;4415	13 	. 
	ld (de),a			;4416	12 	. 
	ret			;4417	c9 	. 
sub_4418h:
	call sub_4454h		;4418	cd 54 44 	. T D 
	nop			;441b	00 	. 
	add a,b			;441c	80 	. 
	nop			;441d	00 	. 
	sub b			;441e	90 	. 
	djnz l43e1h		;441f	10 c0 	. . 
	jr nz,$+34		;4421	20 20 	    
	jr nc,l4455h		;4423	30 30 	0 0 
	ld b,b			;4425	40 	@ 
	ld b,b			;4426	40 	@ 
	ld d,b			;4427	50 	P 
	ld h,b			;4428	60 	` 
	ld (hl),b			;4429	70 	p 
	and b			;442a	a0 	. 
	or b			;442b	b0 	. 
sub_442ch:
	call sub_4454h		;442c	cd 54 44 	. T D 
	nop			;442f	00 	. 
	nop			;4430	00 	. 
	nop			;4431	00 	. 
	inc b			;4432	04 	. 
sub_4433h:
	call sub_4454h		;4433	cd 54 44 	. T D 
	nop			;4436	00 	. 
	djnz l4439h		;4437	10 00 	. . 
l4439h:
	jr nc,l4408h		;4439	30 cd 	0 . 
	ld d,h			;443b	54 	T 
	ld b,h			;443c	44 	D 
	nop			;443d	00 	. 
	nop			;443e	00 	. 
	nop			;443f	00 	. 
	add a,b			;4440	80 	. 
sub_4441h:
	call sub_4454h		;4441	cd 54 44 	. T D 
	ex af,af'			;4444	08 	. 
	inc b			;4445	04 	. 
	inc c			;4446	0c 	. 
	nop			;4447	00 	. 
sub_4448h:
	call sub_4454h		;4448	cd 54 44 	. T D 
	dec d			;444b	15 	. 
	rla			;444c	17 	. 
	dec (hl)			;444d	35 	5 
	scf			;444e	37 	7 
sub_444fh:
	call sub_4454h		;444f	cd 54 44 	. T D 
	nop			;4452	00 	. 
	inc b			;4453	04 	. 
sub_4454h:
	pop hl			;4454	e1 	. 
l4455h:
	push de			;4455	d5 	. 
	ld d,000h		;4456	16 00 	. . 
	ld e,a			;4458	5f 	_ 
	add hl,de			;4459	19 	. 
	ld a,(hl)			;445a	7e 	~ 
	pop de			;445b	d1 	. 
	ret			;445c	c9 	. 
	pop hl			;445d	e1 	. 
sub_445eh:
	ld a,(0f53eh)		;445e	3a 3e f5 	: > . 
	and 0fdh		;4461	e6 fd 	. . 
	call sub_43fbh		;4463	cd fb 43 	. . C 
	xor a			;4466	af 	. 
	ld (0f787h),a		;4467	32 87 f7 	2 . . 
	dec a			;446a	3d 	= 
	ld (0f33ch),a		;446b	32 3c f3 	2 < . 
	ld (0f7a6h),a		;446e	32 a6 f7 	2 . . 
	ret			;4471	c9 	. 
	call sub_4319h		;4472	cd 19 43 	. . C 
	ld hl,(0f79fh)		;4475	2a 9f f7 	* . . 
	ld bc,(0f7a1h)		;4478	ed 4b a1 f7 	. K . . 
	or a			;447c	b7 	. 
	sbc hl,bc		;447d	ed 42 	. B 
	ld b,h			;447f	44 	D 
	ld c,l			;4480	4d 	M 
	ld a,b			;4481	78 	x 
	or c			;4482	b1 	. 
	ret z			;4483	c8 	. 
	ld a,0ffh		;4484	3e ff 	> . 
	ret			;4486	c9 	. 
	call sub_4319h		;4487	cd 19 43 	. . C 
	call sub_432dh		;448a	cd 2d 43 	. - C 
	jr c,l4492h		;448d	38 03 	8 . 
	ld a,0ffh		;448f	3e ff 	> . 
	ret nz			;4491	c0 	. 
l4492h:
	xor a			;4492	af 	. 
	ret			;4493	c9 	. 
	call sub_4319h		;4494	cd 19 43 	. . C 
l4497h:
	ld a,(0f787h)		;4497	3a 87 f7 	: . . 
	and 004h		;449a	e6 04 	. . 
	ld a,005h		;449c	3e 05 	> . 
	scf			;449e	37 	7 
	ret nz			;449f	c0 	. 
	ld hl,(0f79fh)		;44a0	2a 9f f7 	* . . 
	ld a,h			;44a3	7c 	| 
	or l			;44a4	b5 	. 
	jr nz,l44afh		;44a5	20 08 	  . 
	call sub_6ef9h		;44a7	cd f9 6e 	. . n 
	ld a,004h		;44aa	3e 04 	> . 
	ret c			;44ac	d8 	. 
	jr l4497h		;44ad	18 e8 	. . 
l44afh:
	ld hl,(0f788h)		;44af	2a 88 f7 	* . . 
	call 0ec7ch		;44b2	cd 7c ec 	. | . 
	inc hl			;44b5	23 	# 
	ld d,h			;44b6	54 	T 
	ld e,l			;44b7	5d 	] 
	ld bc,(0f795h)		;44b8	ed 4b 95 f7 	. K . . 
	or a			;44bc	b7 	. 
	sbc hl,bc		;44bd	ed 42 	. B 
	ex de,hl			;44bf	eb 	. 
	jr nz,l44c5h		;44c0	20 03 	  . 
	ld hl,(0f78ch)		;44c2	2a 8c f7 	* . . 
l44c5h:
	ld (0f788h),hl		;44c5	22 88 f7 	" . . 
	ld hl,0f787h		;44c8	21 87 f7 	! . . 
	di			;44cb	f3 	. 
	res 1,(hl)		;44cc	cb 8e 	. . 
	ei			;44ce	fb 	. 
	call sub_4509h		;44cf	cd 09 45 	. . E 
	di			;44d2	f3 	. 
	ld hl,(0f79fh)		;44d3	2a 9f f7 	* . . 
	dec hl			;44d6	2b 	+ 
	ei			;44d7	fb 	. 
	ld (0f79fh),hl		;44d8	22 9f f7 	" . . 
	ld a,(0f79bh)		;44db	3a 9b f7 	: . . 
	and c			;44de	a1 	. 
	ld hl,0f79ch		;44df	21 9c f7 	! . . 
	bit 2,(hl)		;44e2	cb 56 	. V 
	ret z			;44e4	c8 	. 
	ld hl,0f7a4h		;44e5	21 a4 f7 	! . . 
	cp 00eh		;44e8	fe 0e 	. . 
	jr z,l44f9h		;44ea	28 0d 	( . 
	cp 00fh		;44ec	fe 0f 	. . 
	jr z,$+14		;44ee	28 0c 	( . 
	cp 020h		;44f0	fe 20 	.   
	ccf			;44f2	3f 	? 
	ret nc			;44f3	d0 	. 
	cp 07fh		;44f4	fe 7f 	.  
	ret z			;44f6	c8 	. 
	or (hl)			;44f7	b6 	. 
	ret			;44f8	c9 	. 
l44f9h:
	ld a,080h		;44f9	3e 80 	> . 
	ld b,0afh		;44fb	06 af 	. . 
	ld (hl),a			;44fd	77 	w 
	di			;44fe	f3 	. 
	ld hl,(0f7a1h)		;44ff	2a a1 f7 	* . . 
	dec hl			;4502	2b 	+ 
	ei			;4503	fb 	. 
	ld (0f7a1h),hl		;4504	22 a1 f7 	" . . 
	jr l4497h		;4507	18 8e 	. . 
sub_4509h:
	ld c,a			;4509	4f 	O 
	ld hl,0f79ch		;450a	21 9c f7 	! . . 
	bit 5,(hl)		;450d	cb 6e 	. n 
	ret z			;450f	c8 	. 
	ld de,(0f797h)		;4510	ed 5b 97 f7 	. [ . . 
	ld hl,(0f79fh)		;4514	2a 9f f7 	* . . 
	sbc hl,de		;4517	ed 52 	. R 
	ret nc			;4519	d0 	. 
	di			;451a	f3 	. 
l451bh:
	call sub_4334h		;451b	cd 34 43 	. 4 C 
	jr z,l451bh		;451e	28 fb 	( . 
	ld a,(0ef2eh)		;4520	3a 2e ef 	: . . 
	out (014h),a		;4523	d3 14 	. . 
	ld hl,0f79ch		;4525	21 9c f7 	! . . 
	ei			;4528	fb 	. 
	res 5,(hl)		;4529	cb ae 	. . 
	ld a,c			;452b	79 	y 
	ret			;452c	c9 	. 
	call sub_4319h		;452d	cd 19 43 	. . C 
	ld a,(0f79ch)		;4530	3a 9c f7 	: . . 
	and 004h		;4533	e6 04 	. . 
	jr z,l4562h		;4535	28 2b 	( + 
	ld hl,0f7a3h		;4537	21 a3 f7 	! . . 
	ld a,c			;453a	79 	y 
	rla			;453b	17 	. 
	jr nc,l4555h		;453c	30 17 	0 . 
	ld a,(0f79bh)		;453e	3a 9b f7 	: . . 
l4541h:
	and c			;4541	a1 	. 
	ld c,a			;4542	4f 	O 
	cp 020h		;4543	fe 20 	.   
	jr c,l4555h		;4545	38 0e 	8 . 
	cp 07fh		;4547	fe 7f 	.  
	jr z,l4555h		;4549	28 0a 	( . 
	ld a,(hl)			;454b	7e 	~ 
	dec a			;454c	3d 	= 
	jr z,l4562h		;454d	28 13 	( . 
	ld b,00eh		;454f	06 0e 	. . 
	ld a,001h		;4551	3e 01 	> . 
	jr l455ch		;4553	18 07 	. . 
l4555h:
	ld a,(hl)			;4555	7e 	~ 
	or a			;4556	b7 	. 
	jr z,l4562h		;4557	28 09 	( . 
	ld b,00fh		;4559	06 0f 	. . 
	xor a			;455b	af 	. 
l455ch:
	ld (hl),a			;455c	77 	w 
	ld a,b			;455d	78 	x 
	call sub_4563h		;455e	cd 63 45 	. c E 
	ret c			;4561	d8 	. 
l4562h:
	ld a,c			;4562	79 	y 
sub_4563h:
	ld b,a			;4563	47 	G 
l4564h:
	call sub_432dh		;4564	cd 2d 43 	. - C 
	jr c,l456bh		;4567	38 02 	8 . 
	jr nz,l4573h		;4569	20 08 	  . 
l456bh:
	call sub_6ef9h		;456b	cd f9 6e 	. . n 
	jr nc,l4564h		;456e	30 f4 	0 . 
	ld a,004h		;4570	3e 04 	> . 
	ret			;4572	c9 	. 
l4573h:
	ld a,b			;4573	78 	x 
	di			;4574	f3 	. 
	out (014h),a		;4575	d3 14 	. . 
	ei			;4577	fb 	. 
	ret			;4578	c9 	. 
	pop hl			;4579	e1 	. 
	call sub_4319h		;457a	cd 19 43 	. . C 
sub_457dh:
	call sub_45c3h		;457d	cd c3 45 	. . E 
sub_4580h:
	jr z,l4597h		;4580	28 15 	( . 
sub_4582h:
	ld bc,08020h		;4582	01 20 80 	.   . 
	in a,(015h)		;4585	db 15 	. . 
	and b			;4587	a0 	. 
	xor b			;4588	a8 	. 
	ld b,a			;4589	47 	G 
	in a,(016h)		;458a	db 16 	. . 
	ld d,a			;458c	57 	W 
	and c			;458d	a1 	. 
	ld c,a			;458e	4f 	O 
	ld a,d			;458f	7a 	z 
	and 010h		;4590	e6 10 	. . 
	rrca			;4592	0f 	. 
	or c			;4593	b1 	. 
	or b			;4594	b0 	. 
	cp a			;4595	bf 	. 
	ret			;4596	c9 	. 
l4597h:
	in a,(016h)		;4597	db 16 	. . 
	xor 004h		;4599	ee 04 	. . 
	rlca			;459b	07 	. 
	rlca			;459c	07 	. 
	rlca			;459d	07 	. 
	rlca			;459e	07 	. 
	rlca			;459f	07 	. 
	cp a			;45a0	bf 	. 
	ret			;45a1	c9 	. 
	pop hl			;45a2	e1 	. 
	call sub_4319h		;45a3	cd 19 43 	. . C 
	ld b,0fch		;45a6	06 fc 	. . 
	ld hl,0f79ch		;45a8	21 9c f7 	! . . 
	ld a,(hl)			;45ab	7e 	~ 
	and b			;45ac	a0 	. 
	or c			;45ad	b1 	. 
	ld (hl),a			;45ae	77 	w 
	ld hl,0f794h		;45af	21 94 f7 	! . . 
	ld a,(hl)			;45b2	7e 	~ 
	and b			;45b3	a0 	. 
	or c			;45b4	b1 	. 
	ld (hl),a			;45b5	77 	w 
	call sub_4402h		;45b6	cd 02 44 	. . D 
	ex de,hl			;45b9	eb 	. 
	call sub_4822h		;45ba	cd 22 48 	. " H 
	dec hl			;45bd	2b 	+ 
	call sub_480bh		;45be	cd 0b 48 	. . H 
	cp a			;45c1	bf 	. 
	ret			;45c2	c9 	. 
sub_45c3h:
	ld a,(0f7a6h)		;45c3	3a a6 f7 	: . . 
	and 00fh		;45c6	e6 0f 	. . 
	dec a			;45c8	3d 	= 
	ret			;45c9	c9 	. 
	pop hl			;45ca	e1 	. 
	call sub_4319h		;45cb	cd 19 43 	. . C 
	call sub_4582h		;45ce	cd 82 45 	. . E 
	and 088h		;45d1	e6 88 	. . 
	ld b,a			;45d3	47 	G 
	ld hl,0f787h		;45d4	21 87 f7 	! . . 
	di			;45d7	f3 	. 
	ld a,(hl)			;45d8	7e 	~ 
	and 074h		;45d9	e6 74 	. t 
	or b			;45db	b0 	. 
	ld c,a			;45dc	4f 	O 
	ld a,(hl)			;45dd	7e 	~ 
	and 08bh		;45de	e6 8b 	. . 
	or b			;45e0	b0 	. 
	ei			;45e1	fb 	. 
	ld (hl),a			;45e2	77 	w 
	ld a,c			;45e3	79 	y 
	cp a			;45e4	bf 	. 
	ret			;45e5	c9 	. 
sub_45e6h:
	ld a,(0f7a6h)		;45e6	3a a6 f7 	: . . 
	ld b,a			;45e9	47 	G 
	inc b			;45ea	04 	. 
	ret			;45eb	c9 	. 
sub_45ech:
	ld bc,l0001h		;45ec	01 01 00 	. . . 
l45efh:
	push af			;45ef	f5 	. 
l45f0h:
	ld a,0e6h		;45f0	3e e6 	> . 
l45f2h:
	dec a			;45f2	3d 	= 
	jr nz,l45f2h		;45f3	20 fd 	  . 
	dec bc			;45f5	0b 	. 
	ld a,b			;45f6	78 	x 
	or c			;45f7	b1 	. 
	jr nz,l45f0h		;45f8	20 f6 	  . 
	pop af			;45fa	f1 	. 
	ret			;45fb	c9 	. 
sub_45fch:
	call sub_4607h		;45fc	cd 07 46 	. . F 
sub_45ffh:
	ld bc,l0009h+1		;45ff	01 0a 00 	. . . 
	jr l45efh		;4602	18 eb 	. . 
sub_4604h:
	call sub_4607h		;4604	cd 07 46 	. . F 
sub_4607h:
	ld bc,00032h		;4607	01 32 00 	. 2 . 
	jr l45efh		;460a	18 e3 	. . 
sub_460ch:
	ld bc,003e8h		;460c	01 e8 03 	. . . 
	jr l45efh		;460f	18 de 	. . 
CHKMOD:
	call sub_46c8h		;4611	cd c8 46 	. . F 
	call sub_4662h		;4614	cd 62 46 	. b F 
	in a,(016h)		;4617	db 16 	. . 
	and 040h		;4619	e6 40 	. @ 
	jr z,l462eh		;461b	28 11 	( . 
	call sub_465ah		;461d	cd 5a 46 	. Z F 
	in a,(013h)		;4620	db 13 	. . 
	and 0f0h		;4622	e6 f0 	. . 
	rrca			;4624	0f 	. 
	rrca			;4625	0f 	. 
	rrca			;4626	0f 	. 
	rrca			;4627	0f 	. 
	cp 00eh		;4628	fe 0e 	. . 
	jr nc,l4650h		;462a	30 24 	0 $ 
	jr l463dh		;462c	18 0f 	. . 
l462eh:
	ld (CRGDEV),a		;462e	32 3f f5 	2 ? . 
l4631h:
	ld c,000h		;4631	0e 00 	. . 
	call sub_476ch		;4633	cd 6c 47 	. l G 
	inc c			;4636	0c 	. 
	dec c			;4637	0d 	. 
	jr nz,l4631h		;4638	20 f7 	  . 
	ld a,d			;463a	7a 	z 
	or 040h		;463b	f6 40 	. @ 
l463dh:
	ld d,a			;463d	57 	W 
	and 00fh		;463e	e6 0f 	. . 
	ld hl,(0efc1h)		;4640	2a c1 ef 	* . . 
	ld b,a			;4643	47 	G 
	inc b			;4644	04 	. 
l4645h:
	add hl,hl			;4645	29 	) 
	djnz l4645h		;4646	10 fd 	. . 
	call sub_46cbh		;4648	cd cb 46 	. . F 
	ld a,d			;464b	7a 	z 
	ld (CRGDEV),a		;464c	32 3f f5 	2 ? . 
	ret			;464f	c9 	. 
l4650h:
	call sub_4662h		;4650	cd 62 46 	. b F 
	call sub_465eh		;4653	cd 5e 46 	. ^ F 
	or 080h		;4656	f6 80 	. . 
	jr l463dh		;4658	18 e3 	. . 
sub_465ah:
	ld b,002h		;465a	06 02 	. . 
	jr l4664h		;465c	18 06 	. . 
sub_465eh:
	ld b,001h		;465e	06 01 	. . 
	jr l4664h		;4660	18 02 	. . 
sub_4662h:
	ld b,000h		;4662	06 00 	. . 
l4664h:
	push af			;4664	f5 	. 
	ld a,(0f005h)		;4665	3a 05 f0 	: . . 
	and 0fch		;4668	e6 fc 	. . 
	or b			;466a	b0 	. 
	ld (0f005h),a		;466b	32 05 f0 	2 . . 
	out (018h),a		;466e	d3 18 	. . 
	pop af			;4670	f1 	. 
	ret			;4671	c9 	. 
l4672h:
	ld c,002h		;4672	0e 02 	. . 
	ld a,(l010eh)		;4674	3a 0e 01 	: . . 
	xor a			;4677	af 	. 
	jr l467dh		;4678	18 03 	. . 
l467ah:
	ld c,002h		;467a	0e 02 	. . 
	ld a,c			;467c	79 	y 
l467dh:
	ld (0f7b1h),a		;467d	32 b1 f7 	2 . . 
	ld a,(CRGDEV)		;4680	3a 3f f5 	: ? . 
	cp c			;4683	b9 	. 
	scf			;4684	37 	7 
	ret nz			;4685	c0 	. 
	push bc			;4686	c5 	. 
	ld a,(0f006h)		;4687	3a 06 f0 	: . . 
	bit 3,a		;468a	cb 5f 	. _ 
	jr nz,l4691h		;468c	20 03 	  . 
	call sub_46c8h		;468e	cd c8 46 	. . F 
l4691h:
	ld a,002h		;4691	3e 02 	> . 
	ld (0f4d1h),a		;4693	32 d1 f4 	2 . . 
	ld a,(CRGDEV)		;4696	3a 3f f5 	: ? . 
	cp 001h		;4699	fe 01 	. . 
	jr nz,l46aeh		;469b	20 11 	  . 
	ld a,(0f007h)		;469d	3a 07 f0 	: . . 
	bit 0,a		;46a0	cb 47 	. G 
	jr nz,l46aeh		;46a2	20 0a 	  . 
	or 001h		;46a4	f6 01 	. . 
	ld (0f007h),a		;46a6	32 07 f0 	2 . . 
	out (013h),a		;46a9	d3 13 	. . 
	call sub_45fch		;46ab	cd fc 45 	. . E 
l46aeh:
	pop bc			;46ae	c1 	. 
l46afh:
	ld a,h			;46af	7c 	| 
	out (011h),a		;46b0	d3 11 	. . 
	ld a,l			;46b2	7d 	} 
	out (010h),a		;46b3	d3 10 	. . 
	ld a,(0f7b1h)		;46b5	3a b1 f7 	: . . 
	or a			;46b8	b7 	. 
	jr z,l46c0h		;46b9	28 05 	( . 
	ld a,(de)			;46bb	1a 	. 
	out (012h),a		;46bc	d3 12 	. . 
	jr l46c3h		;46be	18 03 	. . 
l46c0h:
	in a,(012h)		;46c0	db 12 	. . 
	ld (de),a			;46c2	12 	. 
l46c3h:
	inc hl			;46c3	23 	# 
	inc de			;46c4	13 	. 
	djnz l46afh		;46c5	10 e8 	. . 
	ret			;46c7	c9 	. 
sub_46c8h:
	scf			;46c8	37 	7 
	ld a,0afh		;46c9	3e af 	> . 
sub_46cbh:
	ld a,(0f006h)		;46cb	3a 06 f0 	: . . 
	res 3,a		;46ce	cb 9f 	. . 
	jr nc,l46d4h		;46d0	30 02 	0 . 
	set 3,a		;46d2	cb df 	. . 
l46d4h:
	ld (0f006h),a		;46d4	32 06 f0 	2 . . 
	out (019h),a		;46d7	d3 19 	. . 
	call sub_45ffh		;46d9	cd ff 45 	. . E 
	ret			;46dc	c9 	. 
sub_46ddh:
	ld a,(CRGDEV)		;46dd	3a 3f f5 	: ? . 
	cp 002h		;46e0	fe 02 	. . 
	jr z,l46f1h		;46e2	28 0d 	( . 
	cp 001h		;46e4	fe 01 	. . 
	ret nz			;46e6	c0 	. 
	ld a,(0f007h)		;46e7	3a 07 f0 	: . . 
	and 0feh		;46ea	e6 fe 	. . 
	ld (0f007h),a		;46ec	32 07 f0 	2 . . 
	out (013h),a		;46ef	d3 13 	. . 
l46f1h:
	xor a			;46f1	af 	. 
	ld (0f4d2h),a		;46f2	32 d2 f4 	2 . . 
	jp 046cah		;46f5	c3 ca 46 	. . F 
HSRST:
	push bc			;46f8	c5 	. 
	ld c,007h		;46f9	0e 07 	. . 
l46fbh:
	in a,(011h)		;46fb	db 11 	. . 
	and c			;46fd	a1 	. 
	ld b,a			;46fe	47 	G 
	in a,(011h)		;46ff	db 11 	. . 
	and c			;4701	a1 	. 
	cp b			;4702	b8 	. 
	jp nz,l46fbh		;4703	c2 fb 46 	. . F 
	bit 1,a		;4706	cb 4f 	. O 
	rra			;4708	1f 	. 
	rra			;4709	1f 	. 
	rra			;470a	1f 	. 
	pop bc			;470b	c1 	. 
	ret			;470c	c9 	. 
HSSCOM:
	ld a,c			;470d	79 	y 
l470eh:
	ld c,011h		;470e	0e 11 	. . 
	jr l4715h		;4710	18 03 	. . 
HSSDAT:
	ld a,c			;4712	79 	y 
	ld c,010h		;4713	0e 10 	. . 
l4715h:
	push af			;4715	f5 	. 
	push bc			;4716	c5 	. 
l4717h:
	call HSRST		;4717	cd f8 46 	. . F 
	and 040h		;471a	e6 40 	. @ 
	jr nz,l4717h		;471c	20 f9 	  . 
	pop bc			;471e	c1 	. 
	pop af			;471f	f1 	. 
	out (c),a		;4720	ed 79 	. y 
	ret			;4722	c9 	. 
HSRCV:
	call HSRST		;4723	cd f8 46 	. . F 
	jr z,HSRCV		;4726	28 fb 	( . 
	in a,(010h)		;4728	db 10 	. . 
	ld c,a			;472a	4f 	O 
	ret			;472b	c9 	. 
HSSBL:
	push bc			;472c	c5 	. 
	ld h,d			;472d	62 	b 
	ld l,e			;472e	6b 	k 
l472fh:
	push bc			;472f	c5 	. 
	ld c,(hl)			;4730	4e 	N 
	call HSSDAT		;4731	cd 12 47 	. . G 
	inc hl			;4734	23 	# 
	pop bc			;4735	c1 	. 
	dec bc			;4736	0b 	. 
	ld a,b			;4737	78 	x 
	or c			;4738	b1 	. 
	jr nz,l472fh		;4739	20 f4 	  . 
	jr l474eh		;473b	18 11 	. . 
HSRBL:
	push bc			;473d	c5 	. 
	ld h,d			;473e	62 	b 
	ld l,e			;473f	6b 	k 
l4740h:
	push bc			;4740	c5 	. 
	call HSRCV		;4741	cd 23 47 	. # G 
	jr c,l474eh		;4744	38 08 	8 . 
	ld (hl),c			;4746	71 	q 
	inc hl			;4747	23 	# 
	pop bc			;4748	c1 	. 
	dec bc			;4749	0b 	. 
	ld a,c			;474a	79 	y 
	or b			;474b	b0 	. 
	jr nz,l4740h		;474c	20 f2 	  . 
l474eh:
	ld h,d			;474e	62 	b 
	ld l,e			;474f	6b 	k 
	pop bc			;4750	c1 	. 
	ret			;4751	c9 	. 
HSRK:
	push af			;4752	f5 	. 
	push bc			;4753	c5 	. 
l4754h:
	ld a,(0f0f7h)		;4754	3a f7 f0 	: . . 
	out (011h),a		;4757	d3 11 	. . 
	call HSRCV		;4759	cd 23 47 	. # G 
	jr nc,l4754h		;475c	30 f6 	0 . 
	ld a,(0f0f8h)		;475e	3a f8 f0 	: . . 
	cp c			;4761	b9 	. 
	jr nz,l4754h		;4762	20 f0 	  . 
	pop bc			;4764	c1 	. 
	pop af			;4765	f1 	. 
	ret			;4766	c9 	. 
l4767h:
	call HSSCOM		;4767	cd 0d 47 	. . G 
	jr l4784h		;476a	18 18 	. . 
sub_476ch:
	call HSSCOM		;476c	cd 0d 47 	. . G 
	call HSRCV		;476f	cd 23 47 	. # G 
	push bc			;4772	c5 	. 
	call HSRCV		;4773	cd 23 47 	. # G 
	ld d,c			;4776	51 	Q 
	pop bc			;4777	c1 	. 
	ret			;4778	c9 	. 
l4779h:
	call HSSCOM		;4779	cd 0d 47 	. . G 
	ld c,d			;477c	4a 	J 
	call HSSDAT		;477d	cd 12 47 	. . G 
	ld c,e			;4780	4b 	K 
	call HSSDAT		;4781	cd 12 47 	. . G 
l4784h:
	jp HSRCV		;4784	c3 23 47 	. # G 
sub_4787h:
	out (094h),a		;4787	d3 94 	. . 
sub_4789h:
	in a,(094h)		;4789	db 94 	. . 
	rlca			;478b	07 	. 
	ret			;478c	c9 	. 
l478dh:
	ld a,0afh		;478d	3e af 	> . 
	ld (0f7b1h),a		;478f	32 b1 f7 	2 . . 
	ld a,002h		;4792	3e 02 	> . 
	call sub_4787h		;4794	cd 87 47 	. . G 
	ret c			;4797	d8 	. 
	ld a,l			;4798	7d 	} 
	out (090h),a		;4799	d3 90 	. . 
	ld a,h			;479b	7c 	| 
	out (091h),a		;479c	d3 91 	. . 
	ld a,c			;479e	79 	y 
	out (092h),a		;479f	d3 92 	. . 
	ld a,(0f7b1h)		;47a1	3a b1 f7 	: . . 
	ld c,a			;47a4	4f 	O 
l47a5h:
	inc c			;47a5	0c 	. 
	dec c			;47a6	0d 	. 
	jr nz,l47aeh		;47a7	20 05 	  . 
	ld a,(de)			;47a9	1a 	. 
	out (093h),a		;47aa	d3 93 	. . 
	jr l47b1h		;47ac	18 03 	. . 
l47aeh:
	in a,(093h)		;47ae	db 93 	. . 
	ld (de),a			;47b0	12 	. 
l47b1h:
	inc de			;47b1	13 	. 
	djnz l47a5h		;47b2	10 f1 	. . 
	xor a			;47b4	af 	. 
	out (094h),a		;47b5	d3 94 	. . 
	ret			;47b7	c9 	. 
sub_47b8h:
	ld a,(0f33ch)		;47b8	3a 3c f3 	: < . 
	sub c			;47bb	91 	. 
	ret z			;47bc	c8 	. 
sub_47bdh:
	in a,(015h)		;47bd	db 15 	. . 
	and 004h		;47bf	e6 04 	. . 
	jr z,sub_47bdh		;47c1	28 fa 	( . 
	ld a,c			;47c3	79 	y 
	ld (0f33ch),a		;47c4	32 3c f3 	2 < . 
	rlca			;47c7	07 	. 
	rlca			;47c8	07 	. 
	add a,c			;47c9	81 	. 
	ld c,a			;47ca	4f 	O 
	ld b,000h		;47cb	06 00 	. . 
	ld hl,SYSCTLR1		;47cd	21 79 f2 	! y . 
	add hl,bc			;47d0	09 	. 
	ld a,(0f004h)		;47d1	3a 04 f0 	: . . 
	and 0fah		;47d4	e6 fa 	. . 
	call sub_481ch		;47d6	cd 1c 48 	. . H 
	ld a,(hl)			;47d9	7e 	~ 
	and 0f0h		;47da	e6 f0 	. . 
	ld (hl),a			;47dc	77 	w 
	ld a,(0f001h)		;47dd	3a 01 f0 	: . . 
	and 00fh		;47e0	e6 0f 	. . 
	or (hl)			;47e2	b6 	. 
	ld (0f001h),a		;47e3	32 01 f0 	2 . . 
	out (000h),a		;47e6	d3 00 	. . 
	inc hl			;47e8	23 	# 
	ld b,(hl)			;47e9	46 	F 
	inc hl			;47ea	23 	# 
	ld a,(hl)			;47eb	7e 	~ 
	and 00ch		;47ec	e6 0c 	. . 
	ld (hl),a			;47ee	77 	w 
	ld a,(0f005h)		;47ef	3a 05 f0 	: . . 
	and 0f3h		;47f2	e6 f3 	. . 
	or (hl)			;47f4	b6 	. 
	ld (0f005h),a		;47f5	32 05 f0 	2 . . 
	out (018h),a		;47f8	d3 18 	. . 
	inc hl			;47fa	23 	# 
	call sub_480bh		;47fb	cd 0b 48 	. . H 
	inc hl			;47fe	23 	# 
	call sub_4822h		;47ff	cd 22 48 	. " H 
	ld a,b			;4802	78 	x 
	ld (0f003h),a		;4803	32 03 f0 	2 . . 
	out (015h),a		;4806	d3 15 	. . 
	xor a			;4808	af 	. 
	inc a			;4809	3c 	< 
	ret			;480a	c9 	. 
sub_480bh:
	ld a,(0f005h)		;480b	3a 05 f0 	: . . 
	and 008h		;480e	e6 08 	. . 
	ld a,(hl)			;4810	7e 	~ 
	jr nz,sub_481ch		;4811	20 09 	  . 
	and 0ddh		;4813	e6 dd 	. . 
	ld c,a			;4815	4f 	O 
	ld a,(0f004h)		;4816	3a 04 f0 	: . . 
	and 022h		;4819	e6 22 	. " 
	or c			;481b	b1 	. 
sub_481ch:
	ld (0f004h),a		;481c	32 04 f0 	2 . . 
	out (016h),a		;481f	d3 16 	. . 
	ret			;4821	c9 	. 
sub_4822h:
	ld a,(0f005h)		;4822	3a 05 f0 	: . . 
	and 004h		;4825	e6 04 	. . 
	ret z			;4827	c8 	. 
	ld a,(0f006h)		;4828	3a 06 f0 	: . . 
	and 0fbh		;482b	e6 fb 	. . 
	or (hl)			;482d	b6 	. 
	ld (0f006h),a		;482e	32 06 f0 	2 . . 
	out (019h),a		;4831	d3 19 	. . 
	ret			;4833	c9 	. 
sub_4834h:
	push af			;4834	f5 	. 
l4835h:
	call sub_4334h		;4835	cd 34 43 	. 4 C 
	jr z,l4835h		;4838	28 fb 	( . 
	pop af			;483a	f1 	. 
	out (014h),a		;483b	d3 14 	. . 
	ret			;483d	c9 	. 
sub_483eh:
	ld a,(0f289h)		;483e	3a 89 f2 	: . . 
sub_4841h:
	push bc			;4841	c5 	. 
	ld b,a			;4842	47 	G 
l4843h:
	call sub_4853h		;4843	cd 53 48 	. S H 
	jr c,l4851h		;4846	38 09 	8 . 
	jr nz,l4851h		;4848	20 07 	  . 
	inc b			;484a	04 	. 
	dec b			;484b	05 	. 
	jr z,l4843h		;484c	28 f5 	( . 
	dec b			;484e	05 	. 
	jr nz,l4843h		;484f	20 f2 	  . 
l4851h:
	pop bc			;4851	c1 	. 
	ret			;4852	c9 	. 
sub_4853h:
	push bc			;4853	c5 	. 
	ld bc,(0f28eh)		;4854	ed 4b 8e f2 	. K . . 
l4858h:
	dec bc			;4858	0b 	. 
	ld a,b			;4859	78 	x 
	or c			;485a	b1 	. 
	jr z,l4867h		;485b	28 0a 	( . 
	in a,(015h)		;485d	db 15 	. . 
	and 002h		;485f	e6 02 	. . 
	jr z,l4858h		;4861	28 f5 	( . 
	or 001h		;4863	f6 01 	. . 
	in a,(014h)		;4865	db 14 	. . 
l4867h:
	pop bc			;4867	c1 	. 
	ret			;4868	c9 	. 
sub_4869h:
	ld b,000h		;4869	06 00 	. . 
l486bh:
	ld a,(0f28bh)		;486b	3a 8b f2 	: . . 
	call sub_4841h		;486e	cd 41 48 	. A H 
	ret c			;4871	d8 	. 
	ret z			;4872	c8 	. 
	push bc			;4873	c5 	. 
	ld b,a			;4874	47 	G 
	pop af			;4875	f1 	. 
	or a			;4876	b7 	. 
	jr nz,l4880h		;4877	20 07 	  . 
	ld a,b			;4879	78 	x 
	cp 010h		;487a	fe 10 	. . 
	jr z,l486bh		;487c	28 ed 	( . 
	scf			;487e	37 	7 
	ccf			;487f	3f 	? 
l4880h:
	ret			;4880	c9 	. 
sub_4881h:
	ld (0f7b3h),a		;4881	32 b3 f7 	2 . . 
	ld (0f7bah),hl		;4884	22 ba f7 	" . . 
	ld a,(0f288h)		;4887	3a 88 f2 	: . . 
	ld (0f7b9h),a		;488a	32 b9 f7 	2 . . 
l488dh:
	ld a,(0f7b3h)		;488d	3a b3 f7 	: . . 
	ld (0f7b2h),a		;4890	32 b2 f7 	2 . . 
	ld hl,(0f7bah)		;4893	2a ba f7 	* . . 
	ld a,(0f7b7h)		;4896	3a b7 f7 	: . . 
	ld b,a			;4899	47 	G 
	call sub_4834h		;489a	cd 34 48 	. 4 H 
l489dh:
	ld a,(hl)			;489d	7e 	~ 
	call sub_4834h		;489e	cd 34 48 	. 4 H 
	add a,b			;48a1	80 	. 
	ld b,a			;48a2	47 	G 
	inc hl			;48a3	23 	# 
	ld a,(0f7b2h)		;48a4	3a b2 f7 	: . . 
	dec a			;48a7	3d 	= 
	ld (0f7b2h),a		;48a8	32 b2 f7 	2 . . 
	jr nz,l489dh		;48ab	20 f0 	  . 
	ld a,(0f7b6h)		;48ad	3a b6 f7 	: . . 
	call sub_4834h		;48b0	cd 34 48 	. 4 H 
	add a,b			;48b3	80 	. 
	neg		;48b4	ed 44 	. D 
l48b6h:
	call sub_4834h		;48b6	cd 34 48 	. 4 H 
	call sub_4869h		;48b9	cd 69 48 	. i H 
	ret c			;48bc	d8 	. 
	jr z,l48d7h		;48bd	28 18 	( . 
	cp 006h		;48bf	fe 06 	. . 
	jr z,l48eeh		;48c1	28 2b 	( + 
	cp 015h		;48c3	fe 15 	. . 
	jr z,l48d9h		;48c5	28 12 	( . 
	cp 010h		;48c7	fe 10 	. . 
	jr nz,l48d7h		;48c9	20 0c 	  . 
	ld a,b			;48cb	78 	x 
	cp 03bh		;48cc	fe 3b 	. ; 
	jr nz,l48d7h		;48ce	20 07 	  . 
	call sub_4604h		;48d0	cd 04 46 	. . F 
	ld a,005h		;48d3	3e 05 	> . 
	jr l48b6h		;48d5	18 df 	. . 
l48d7h:
	ld a,005h		;48d7	3e 05 	> . 
l48d9h:
	ld bc,(0f7b9h)		;48d9	ed 4b b9 f7 	. K . . 
	inc c			;48dd	0c 	. 
	dec c			;48de	0d 	. 
	jr z,l48e8h		;48df	28 07 	( . 
	dec c			;48e1	0d 	. 
	ld (0f7b9h),bc		;48e2	ed 43 b9 f7 	. C . . 
	jr z,l48f0h		;48e6	28 08 	( . 
l48e8h:
	cp 015h		;48e8	fe 15 	. . 
	jr z,l488dh		;48ea	28 a1 	( . 
	jr l48b6h		;48ec	18 c8 	. . 
l48eeh:
	xor a			;48ee	af 	. 
	ret			;48ef	c9 	. 
l48f0h:
	ld a,061h		;48f0	3e 61 	> a 
	ld hl,(l623dh+1)		;48f2	2a 3e 62 	* > b 
	ld hl,(l633eh)		;48f5	2a 3e 63 	* > c 
	ld hl,(0643eh)		;48f8	2a 3e 64 	* > d 
l48fbh:
	push af			;48fb	f5 	. 
	xor a			;48fc	af 	. 
	ld (0f7aah),a		;48fd	32 aa f7 	2 . . 
	pop af			;4900	f1 	. 
	jp l4a71h		;4901	c3 71 4a 	. q J 
sub_4904h:
	ld (0f7bdh),a		;4904	32 bd f7 	2 . . 
	ld (0f7b4h),hl		;4907	22 b4 f7 	" . . 
	ld a,(0f288h)		;490a	3a 88 f2 	: . . 
	ld (0f7b9h),a		;490d	32 b9 f7 	2 . . 
	ld c,002h		;4910	0e 02 	. . 
	call sub_47b8h		;4912	cd b8 47 	. . G 
	ld a,(0f28ch)		;4915	3a 8c f2 	: . . 
	or a			;4918	b7 	. 
	jr nz,l495ch		;4919	20 41 	  A 
	ld hl,(0f7b4h)		;491b	2a b4 f7 	* . . 
	inc hl			;491e	23 	# 
	cp (hl)			;491f	be 	. 
	jr z,l495ch		;4920	28 3a 	( : 
l4922h:
	ld a,004h		;4922	3e 04 	> . 
	call sub_4834h		;4924	cd 34 48 	. 4 H 
	call sub_45ech		;4927	cd ec 45 	. . E 
	ld a,031h		;492a	3e 31 	> 1 
	call sub_4834h		;492c	cd 34 48 	. 4 H 
	ld hl,(0f7b4h)		;492f	2a b4 f7 	* . . 
	inc hl			;4932	23 	# 
	ld a,(hl)			;4933	7e 	~ 
	call sub_4834h		;4934	cd 34 48 	. 4 H 
	inc hl			;4937	23 	# 
	ld a,(hl)			;4938	7e 	~ 
	call sub_4834h		;4939	cd 34 48 	. 4 H 
	ld a,005h		;493c	3e 05 	> . 
	call sub_4834h		;493e	cd 34 48 	. 4 H 
	call sub_4869h		;4941	cd 69 48 	. i H 
	jr c,l495ah		;4944	38 14 	8 . 
	jr z,l494ch		;4946	28 04 	( . 
	xor 006h		;4948	ee 06 	. . 
	jr z,l495ch		;494a	28 10 	( . 
l494ch:
	ld a,(0f7b9h)		;494c	3a b9 f7 	: . . 
	or a			;494f	b7 	. 
	jr z,l4922h		;4950	28 d0 	( . 
	dec a			;4952	3d 	= 
	ld (0f7b9h),a		;4953	32 b9 f7 	2 . . 
	jr nz,l4922h		;4956	20 ca 	  . 
	jr l48f0h		;4958	18 96 	. . 
l495ah:
	jr $-97		;495a	18 9d 	. . 
l495ch:
	ld bc,RBDOS1		;495c	01 05 00 	. . . 
	ld de,0f7a9h		;495f	11 a9 f7 	. . . 
	ld hl,(0f7b4h)		;4962	2a b4 f7 	* . . 
	ldir		;4965	ed b0 	. . 
	ld hl,(0f7adh)		;4967	2a ad f7 	* . . 
	ld h,001h		;496a	26 01 	& . 
	ld (0f7b6h),hl		;496c	22 b6 f7 	" . . 
	ld hl,(0f7b4h)		;496f	2a b4 f7 	* . . 
	ld a,004h		;4972	3e 04 	> . 
	call sub_4881h		;4974	cd 81 48 	. . H 
	jr c,l495ah		;4977	38 e1 	8 . 
	jr nz,l4990h		;4979	20 15 	  . 
	ld hl,l0201h+2		;497b	21 03 02 	! . . 
	ld (0f7b6h),hl		;497e	22 b6 f7 	" . . 
	ld hl,(0f7b4h)		;4981	2a b4 f7 	* . . 
	inc hl			;4984	23 	# 
	inc hl			;4985	23 	# 
	inc hl			;4986	23 	# 
	inc hl			;4987	23 	# 
	ld a,(hl)			;4988	7e 	~ 
	inc a			;4989	3c 	< 
	inc hl			;498a	23 	# 
	call sub_4881h		;498b	cd 81 48 	. . H 
	jr c,l495ah		;498e	38 ca 	8 . 
l4990h:
	ld hl,(0f7b4h)		;4990	2a b4 f7 	* . . 
	or a			;4993	b7 	. 
	jp nz,l48fbh		;4994	c2 fb 48 	. . H 
	ld a,(0f28ch)		;4997	3a 8c f2 	: . . 
	or a			;499a	b7 	. 
	jr z,l49a4h		;499b	28 07 	( . 
	ld a,004h		;499d	3e 04 	> . 
	call sub_4834h		;499f	cd 34 48 	. 4 H 
	jr c,l495ah		;49a2	38 b6 	8 . 
l49a4h:
	ld a,(0f7bdh)		;49a4	3a bd f7 	: . . 
	and 001h		;49a7	e6 01 	. . 
	jp z,l48fbh		;49a9	ca fb 48 	. . H 
	jr l49b1h		;49ac	18 03 	. . 
sub_49aeh:
	ld (0f7b4h),hl		;49ae	22 b4 f7 	" . . 
l49b1h:
	ld a,(0f28ch)		;49b1	3a 8c f2 	: . . 
	or a			;49b4	b7 	. 
	jr nz,l49bch		;49b5	20 05 	  . 
	ld a,004h		;49b7	3e 04 	> . 
	call sub_4834h		;49b9	cd 34 48 	. 4 H 
l49bch:
	ld a,001h		;49bc	3e 01 	> . 
l49beh:
	ld (0f7bah),a		;49be	32 ba f7 	2 . . 
	ld a,(0f288h)		;49c1	3a 88 f2 	: . . 
	ld (0f7b9h),a		;49c4	32 b9 f7 	2 . . 
l49c7h:
	ld hl,(0f7b4h)		;49c7	2a b4 f7 	* . . 
	ld a,(0f28ah)		;49ca	3a 8a f2 	: . . 
	call sub_4841h		;49cd	cd 41 48 	. A H 
	jr c,l4a21h		;49d0	38 4f 	8 O 
	jp z,048f6h		;49d2	ca f6 48 	. . H 
	ld b,004h		;49d5	06 04 	. . 
	cp 001h		;49d7	fe 01 	. . 
	jr z,l4a11h		;49d9	28 36 	( 6 
	inc hl			;49db	23 	# 
	inc hl			;49dc	23 	# 
	inc hl			;49dd	23 	# 
	inc hl			;49de	23 	# 
	inc hl			;49df	23 	# 
	ld bc,(0f7adh)		;49e0	ed 4b ad f7 	. K . . 
	ld b,c			;49e4	41 	A 
	cp 002h		;49e5	fe 02 	. . 
	jr z,l4a11h		;49e7	28 28 	( ( 
	cp 005h		;49e9	fe 05 	. . 
	jr z,l4a09h		;49eb	28 1c 	( . 
l49edh:
	call sub_4853h		;49ed	cd 53 48 	. S H 
	jr c,l4a71h		;49f0	38 7f 	8  
	jr nz,l49edh		;49f2	20 f9 	  . 
l49f4h:
	ld a,015h		;49f4	3e 15 	> . 
	ld (0f7aeh),a		;49f6	32 ae f7 	2 . . 
	ld bc,(0f7b9h)		;49f9	ed 4b b9 f7 	. K . . 
	inc c			;49fd	0c 	. 
	dec c			;49fe	0d 	. 
	jr z,l4a06h		;49ff	28 05 	( . 
	dec c			;4a01	0d 	. 
	ld (0f7b9h),bc		;4a02	ed 43 b9 f7 	. C . . 
l4a06h:
	jp z,l48f0h		;4a06	ca f0 48 	. . H 
l4a09h:
	ld a,(0f7aeh)		;4a09	3a ae f7 	: . . 
	call sub_4834h		;4a0c	cd 34 48 	. 4 H 
	jr l49c7h		;4a0f	18 b6 	. . 
l4a11h:
	inc b			;4a11	04 	. 
	ld (0f7bbh),a		;4a12	32 bb f7 	2 . . 
	ld (0f7b3h),a		;4a15	32 b3 f7 	2 . . 
	ld c,a			;4a18	4f 	O 
	ld a,b			;4a19	78 	x 
	ld (0f7b6h),a		;4a1a	32 b6 f7 	2 . . 
	ld b,c			;4a1d	41 	A 
l4a1eh:
	call sub_483eh		;4a1e	cd 3e 48 	. > H 
l4a21h:
	jp c,048f9h		;4a21	da f9 48 	. . H 
	jr z,l49f4h		;4a24	28 ce 	( . 
	ld (hl),a			;4a26	77 	w 
	inc hl			;4a27	23 	# 
	add a,b			;4a28	80 	. 
	ld b,a			;4a29	47 	G 
	ld a,(0f7b6h)		;4a2a	3a b6 f7 	: . . 
	dec a			;4a2d	3d 	= 
	ld (0f7b6h),a		;4a2e	32 b6 f7 	2 . . 
	jr nz,l4a1eh		;4a31	20 eb 	  . 
l4a33h:
	call sub_483eh		;4a33	cd 3e 48 	. > H 
	jr c,l4a21h		;4a36	38 e9 	8 . 
	jr z,l49f4h		;4a38	28 ba 	( . 
	add a,b			;4a3a	80 	. 
	ld b,a			;4a3b	47 	G 
	ld a,(0f7b3h)		;4a3c	3a b3 f7 	: . . 
	dec a			;4a3f	3d 	= 
	ld (0f7b3h),a		;4a40	32 b3 f7 	2 . . 
	jr nz,l4a33h		;4a43	20 ee 	  . 
	or b			;4a45	b0 	. 
	jr nz,l49f4h		;4a46	20 ac 	  . 
	ld a,006h		;4a48	3e 06 	> . 
	ld (0f7aeh),a		;4a4a	32 ae f7 	2 . . 
	call sub_4834h		;4a4d	cd 34 48 	. 4 H 
	jr c,l4a21h		;4a50	38 cf 	8 . 
	ld bc,(0f7bah)		;4a52	ed 4b ba f7 	. K . . 
	ld a,b			;4a56	78 	x 
	xor 001h		;4a57	ee 01 	. . 
	jr nz,l4a6ah		;4a59	20 0f 	  . 
	ld hl,(0f7b4h)		;4a5b	2a b4 f7 	* . . 
	inc hl			;4a5e	23 	# 
	inc hl			;4a5f	23 	# 
	inc hl			;4a60	23 	# 
	inc hl			;4a61	23 	# 
	ld a,(hl)			;4a62	7e 	~ 
	ld (0f7adh),a		;4a63	32 ad f7 	2 . . 
	xor a			;4a66	af 	. 
	jp l49beh		;4a67	c3 be 49 	. . I 
l4a6ah:
	ld a,(0f28ch)		;4a6a	3a 8c f2 	: . . 
	or a			;4a6d	b7 	. 
	jr z,l4a7ch		;4a6e	28 0c 	( . 
l4a70h:
	xor a			;4a70	af 	. 
l4a71h:
	ld hl,(0f7b4h)		;4a71	2a b4 f7 	* . . 
	bit 0,a		;4a74	cb 47 	. G 
	ret			;4a76	c9 	. 
l4a77h:
	ld a,006h		;4a77	3e 06 	> . 
	call sub_4834h		;4a79	cd 34 48 	. 4 H 
l4a7ch:
	xor a			;4a7c	af 	. 
	ld (0f7aah),a		;4a7d	32 aa f7 	2 . . 
	call sub_4869h		;4a80	cd 69 48 	. i H 
	jr c,l4a71h		;4a83	38 ec 	8 . 
	jr z,l4a70h		;4a85	28 e9 	( . 
	cp 005h		;4a87	fe 05 	. . 
	jr z,l4a77h		;4a89	28 ec 	( . 
	cp 004h		;4a8b	fe 04 	. . 
	jr nz,l4a70h		;4a8d	20 e1 	  . 
	call sub_4834h		;4a8f	cd 34 48 	. 4 H 
	jr l4a70h		;4a92	18 dc 	. . 
EPSSND:
	di			;4a94	f3 	. 
	call sub_4904h		;4a95	cd 04 49 	. . I 
	ei			;4a98	fb 	. 
	ret			;4a99	c9 	. 
ESPRCV:
	di			;4a9a	f3 	. 
	call sub_49aeh		;4a9b	cd ae 49 	. . I 
	ei			;4a9e	fb 	. 
	ret			;4a9f	c9 	. 
l4aa0h:
	nop			;4aa0	00 	. 
	nop			;4aa1	00 	. 
	ld bc,l0101h		;4aa2	01 01 01 	. . . 
	inc bc			;4aa5	03 	. 
	inc bc			;4aa6	03 	. 
	dec b			;4aa7	05 	. 
	ld bc,l0108h		;4aa8	01 08 01 	. . . 
	ld a,(bc)			;4aab	0a 	. 
	ld bc,l070ch		;4aac	01 0c 07 	. . . 
	ld c,001h		;4aaf	0e 01 	. . 
	ld (de),a			;4ab1	12 	. 
	ld bc,l0012h+2		;4ab2	01 14 00 	. . . 
	ld d,000h		;4ab5	16 00 	. . 
	rla			;4ab7	17 	. 
	nop			;4ab8	00 	. 
	jr l4abdh		;4ab9	18 02 	. . 
	add hl,de			;4abb	19 	. 
	nop			;4abc	00 	. 
l4abdh:
	dec de			;4abd	1b 	. 
	nop			;4abe	00 	. 
	inc e			;4abf	1c 	. 
	nop			;4ac0	00 	. 
	dec e			;4ac1	1d 	. 
	nop			;4ac2	00 	. 
	ld e,000h		;4ac3	1e 00 	. . 
	rra			;4ac5	1f 	. 
	nop			;4ac6	00 	. 
	jr nz,l4ac9h		;4ac7	20 00 	  . 
l4ac9h:
	ld hl,l2200h		;4ac9	21 00 22 	! . " 
	nop			;4acc	00 	. 
	inc hl			;4acd	23 	# 
	rlca			;4ace	07 	. 
	inc h			;4acf	24 	$ 
	nop			;4ad0	00 	. 
	jr z,l4ad3h		;4ad1	28 00 	( . 
l4ad3h:
	add hl,hl			;4ad3	29 	) 
	ld bc,l072ah		;4ad4	01 2a 07 	. * . 
	inc l			;4ad7	2c 	, 
	rlca			;4ad8	07 	. 
	jr nc,$+9		;4ad9	30 07 	0 . 
	inc (hl)			;4adb	34 	4 
	rlca			;4adc	07 	. 
	jr c,l4ae6h		;4add	38 07 	8 . 
	inc a			;4adf	3c 	< 
	ld bc,l0140h		;4ae0	01 40 01 	. @ . 
	ld b,d			;4ae3	42 	B 
	rlca			;4ae4	07 	. 
	ld b,h			;4ae5	44 	D 
l4ae6h:
	rlca			;4ae6	07 	. 
	ld c,b			;4ae7	48 	H 
	rlca			;4ae8	07 	. 
	ld c,h			;4ae9	4c 	L 
	nop			;4aea	00 	. 
	nop			;4aeb	00 	. 
	nop			;4aec	00 	. 
	nop			;4aed	00 	. 
	nop			;4aee	00 	. 
	ld d,b			;4aef	50 	P 
	nop			;4af0	00 	. 
	ld d,c			;4af1	51 	Q 
	nop			;4af2	00 	. 
	ld d,d			;4af3	52 	R 
	rlca			;4af4	07 	. 
	ld d,e			;4af5	53 	S 
	nop			;4af6	00 	. 
	nop			;4af7	00 	. 
	nop			;4af8	00 	. 
	nop			;4af9	00 	. 
	nop			;4afa	00 	. 
	nop			;4afb	00 	. 
	ld bc,l0057h		;4afc	01 57 00 	. W . 
	ld e,c			;4aff	59 	Y 
	rlca			;4b00	07 	. 
	ld e,d			;4b01	5a 	Z 
	nop			;4b02	00 	. 
	ld e,(hl)			;4b03	5e 	^ 
	rlca			;4b04	07 	. 
	ld e,a			;4b05	5f 	_ 
	nop			;4b06	00 	. 
	ld h,e			;4b07	63 	c 
	inc bc			;4b08	03 	. 
	ld h,h			;4b09	64 	d 
	nop			;4b0a	00 	. 
	ld h,a			;4b0b	67 	g 
	nop			;4b0c	00 	. 
	ld l,b			;4b0d	68 	h 
	nop			;4b0e	00 	. 
	ld l,c			;4b0f	69 	i 
l4b10h:
	inc bc			;4b10	03 	. 
	pop af			;4b11	f1 	. 
	di			;4b12	f3 	. 
	jp p,0f3f4h		;4b13	f2 f4 f3 	. . . 
	push af			;4b16	f5 	. 
	di			;4b17	f3 	. 
	call p,0f5f6h		;4b18	f4 f6 f5 	. . . 
	rst 30h			;4b1b	f7 	. 
	or 01dh		;4b1c	f6 1d 	. . 
	rst 30h			;4b1e	f7 	. 
	ret m			;4b1f	f8 	. 
	rst 30h			;4b20	f7 	. 
	rst 30h			;4b21	f7 	. 
	ld de,l1701h		;4b22	11 01 17 	. . . 
	ld a,(de)			;4b25	1a 	. 
	dec b			;4b26	05 	. 
	ld (de),a			;4b27	12 	. 
	inc d			;4b28	14 	. 
	add hl,de			;4b29	19 	. 
	ld a,(de)			;4b2a	1a 	. 
	dec d			;4b2b	15 	. 
	add hl,bc			;4b2c	09 	. 
	inc b			;4b2d	04 	. 
	ld b,007h		;4b2e	06 07 	. . 
	ex af,af'			;4b30	08 	. 
	ld a,(bc)			;4b31	0a 	. 
	dec bc			;4b32	0b 	. 
	inc c			;4b33	0c 	. 
l4b34h:
	ei			;4b34	fb 	. 
	dec c			;4b35	0d 	. 
	inc e			;4b36	1c 	. 
	inc e			;4b37	1c 	. 
	ld (bc),a			;4b38	02 	. 
	ld c,00dh		;4b39	0e 0d 	. . 
	ei			;4b3b	fb 	. 
	defb 0fdh,0fch,0fdh	;illegal sequence		;4b3c	fd fc fd 	. . . 
	defb 0fdh,0feh,0fdh	;illegal sequence		;4b3f	fd fe fd 	. . . 
	cp 0feh		;4b42	fe fe 	. . 
	rra			;4b44	1f 	. 
	cp 01fh		;4b45	fe 1f 	. . 
	rra			;4b47	1f 	. 
	dec de			;4b48	1b 	. 
	pop af			;4b49	f1 	. 
	jp m,l1dfah		;4b4a	fa fa 1d 	. . . 
	jp p,01efbh		;4b4d	f2 fb 1e 	. . . 
	ret m			;4b50	f8 	. 
	ld sp,hl			;4b51	f9 	. 
	ld sp,hl			;4b52	f9 	. 
	inc e			;4b53	1c 	. 
	ret p			;4b54	f0 	. 
	nop			;4b55	00 	. 
	ret p			;4b56	f0 	. 
	ret p			;4b57	f0 	. 
	jp m,l001bh		;4b58	fa 1b 00 	. . . 
	ei			;4b5b	fb 	. 
	ld e,01fh		;4b5c	1e 1f 	. . 
	call m,sub_0900h		;4b5e	fc 00 09 	. . . 
	rrca			;4b61	0f 	. 
	djnz l4b64h		;4b62	10 00 	. . 
l4b64h:
	ld e,01dh		;4b64	1e 1d 	. . 
	dec e			;4b66	1d 	. 
	ld bc,01311h		;4b67	01 11 13 	. . . 
	call m,01bf0h		;4b6a	fc f0 1b 	. . . 
	dec de			;4b6d	1b 	. 
	dec c			;4b6e	0d 	. 
	inc e			;4b6f	1c 	. 
	jp m,0fc1eh		;4b70	fa 1e fc 	. . . 
	jr nz,l4b8fh		;4b73	20 1a 	  . 
	rla			;4b75	17 	. 
	add hl,de			;4b76	19 	. 
	jr $+5		;4b77	18 03 	. . 
	ld d,003h		;4b79	16 03 	. . 
	ld sp,l3226h		;4b7b	31 26 32 	1 & 2 
	ld a,e			;4b7e	7b 	{ 
	inc sp			;4b7f	33 	3 
	ld (l3433h),hl		;4b80	22 33 34 	" 3 4 
	daa			;4b83	27 	' 
	dec (hl)			;4b84	35 	5 
	jr z,$+56		;4b85	28 36 	( 6 
	ld e,l			;4b87	5d 	] 
	scf			;4b88	37 	7 
	ld a,l			;4b89	7d 	} 
	scf			;4b8a	37 	7 
	scf			;4b8b	37 	7 
	pop af			;4b8c	f1 	. 
	pop hl			;4b8d	e1 	. 
	rst 30h			;4b8e	f7 	. 
l4b8fh:
	jp m,0f2e5h		;4b8f	fa e5 f2 	. . . 
	call p,0faf9h		;4b92	f4 f9 fa 	. . . 
	push af			;4b95	f5 	. 
	jp (hl)			;4b96	e9 	. 
	call po,0e7e6h		;4b97	e4 e6 e7 	. . . 
	ret pe			;4b9a	e8 	. 
	jp pe,0ecebh		;4b9b	ea eb ec 	. . . 
	dec sp			;4b9e	3b 	; 
	defb 0edh;next byte illegal after ed		;4b9f	ed 	. 
	call m,0e2fch		;4ba0	fc fc e2 	. . . 
	xor 0edh		;4ba3	ee ed 	. . 
	inc l			;4ba5	2c 	, 
	inc l			;4ba6	2c 	, 
	dec sp			;4ba7	3b 	; 
	inc l			;4ba8	2c 	, 
	inc l			;4ba9	2c 	, 
	ld l,03ah		;4baa	2e 3a 	. : 
	ld l,02eh		;4bac	2e 2e 	. . 
	cpl			;4bae	2f 	/ 
	dec a			;4baf	3d 	= 
	dec l			;4bb0	2d 	- 
	dec l			;4bb1	2d 	- 
	ld e,e			;4bb2	5b 	[ 
	inc a			;4bb3	3c 	< 
	inc a			;4bb4	3c 	< 
	inc a			;4bb5	3c 	< 
	ld e,l			;4bb6	5d 	] 
	inc hl			;4bb7	23 	# 
	inc hl			;4bb8	23 	# 
	cp 038h		;4bb9	fe 38 	. 8 
	ld hl,05c39h		;4bbb	21 39 5c 	! 9 \ 
	jr nc,l4c00h		;4bbe	30 40 	0 @ 
	jr nc,l4bf2h		;4bc0	30 30 	0 0 
	dec l			;4bc2	2d 	- 
	add hl,hl			;4bc3	29 	) 
	ld a,(hl)			;4bc4	7e 	~ 
	dec hl			;4bc5	2b 	+ 
	ld e,(hl)			;4bc6	5e 	^ 
	dec l			;4bc7	2d 	- 
	dec hl			;4bc8	2b 	+ 
	ret po			;4bc9	e0 	. 
	add hl,bc			;4bca	09 	. 
	rst 28h			;4bcb	ef 	. 
	ret p			;4bcc	f0 	. 
	ld b,b			;4bcd	40 	@ 
	ld e,(hl)			;4bce	5e 	^ 
	defb 0fdh,0fdh,0e1h	;illegal sequence		;4bcf	fd fd e1 	. . . 
	pop af			;4bd2	f1 	. 
	di			;4bd3	f3 	. 
	ld a,(0fb7ch)		;4bd4	3a 7c fb 	: | . 
	ei			;4bd7	fb 	. 
	dec c			;4bd8	0d 	. 
l4bd9h:
	ld e,h			;4bd9	5c 	\ 
	ld h,b			;4bda	60 	` 
	ld e,(hl)			;4bdb	5e 	^ 
	daa			;4bdc	27 	' 
	jr nz,l4bd9h		;4bdd	20 fa 	  . 
	rst 30h			;4bdf	f7 	. 
	ld sp,hl			;4be0	f9 	. 
	ret m			;4be1	f8 	. 
	ex (sp),hl			;4be2	e3 	. 
	or 003h		;4be3	f6 03 	. . 
	ld hl,l2231h		;4be5	21 31 22 	! 1 " 
	ld (l3323h),a		;4be8	32 23 33 	2 # 3 
	ld b,b			;4beb	40 	@ 
	inc h			;4bec	24 	$ 
	inc (hl)			;4bed	34 	4 
	dec h			;4bee	25 	% 
	dec (hl)			;4bef	35 	5 
	ld h,036h		;4bf0	26 36 	& 6 
l4bf2h:
	daa			;4bf2	27 	' 
	scf			;4bf3	37 	7 
	cpl			;4bf4	2f 	/ 
	cpl			;4bf5	2f 	/ 
	pop de			;4bf6	d1 	. 
	pop bc			;4bf7	c1 	. 
	rst 10h			;4bf8	d7 	. 
	jp c,0d2c5h		;4bf9	da c5 d2 	. . . 
	call nc,0dad9h		;4bfc	d4 d9 da 	. . . 
	push de			;4bff	d5 	. 
l4c00h:
	ret			;4c00	c9 	. 
	call nz,0c7c6h		;4c01	c4 c6 c7 	. . . 
	ret z			;4c04	c8 	. 
	jp z,0cccbh		;4c05	ca cb cc 	. . . 
	dec hl			;4c08	2b 	+ 
	call 0dcdch		;4c09	cd dc dc 	. . . 
l4c0ch:
	jp nz,0cdceh		;4c0c	c2 ce cd 	. . . 
	ccf			;4c0f	3f 	? 
	inc a			;4c10	3c 	< 
	ld l,03bh		;4c11	2e 3b 	. ; 
	dec sp			;4c13	3b 	; 
	ld a,02fh		;4c14	3e 2f 	> / 
	ld a,(l3f3ah)		;4c16	3a 3a 3f 	: : ? 
	dec hl			;4c19	2b 	+ 
	ld e,a			;4c1a	5f 	_ 
	ld e,a			;4c1b	5f 	_ 
	ld a,e			;4c1c	7b 	{ 
	ld a,03eh		;4c1d	3e 3e 	> > 
	ld a,07dh		;4c1f	3e 7d 	> } 
	inc h			;4c21	24 	$ 
	daa			;4c22	27 	' 
l4c23h:
	sbc a,028h		;4c23	de 28 	. ( 
	jr c,l4c50h		;4c25	38 29 	8 ) 
	add hl,sp			;4c27	39 	9 
	ld e,a			;4c28	5f 	_ 
	jr nc,l4c68h		;4c29	30 3d 	0 = 
	dec a			;4c2b	3d 	= 
	dec a			;4c2c	3d 	= 
	ld e,e			;4c2d	5b 	[ 
	ccf			;4c2e	3f 	? 
	ccf			;4c2f	3f 	? 
	ld a,(hl)			;4c30	7e 	~ 
	ld e,a			;4c31	5f 	_ 
	ld hl,(l09c0h)		;4c32	2a c0 09 	* . . 
	rst 8			;4c35	cf 	. 
	ret nc			;4c36	d0 	. 
	ld h,b			;4c37	60 	` 
	ld a,(hl)			;4c38	7e 	~ 
	defb 0ddh,0ddh,0c1h	;illegal sequence		;4c39	dd dd c1 	. . . 
	pop de			;4c3c	d1 	. 
	out (02ah),a		;4c3d	d3 2a 	. * 
	dec h			;4c3f	25 	% 
	in a,(0dbh)		;4c40	db db 	. . 
	dec c			;4c42	0d 	. 
	ld a,h			;4c43	7c 	| 
	ld hl,(sub_2a60h)		;4c44	2a 60 2a 	* ` * 
	jr nz,l4c23h		;4c47	20 da 	  . 
	rst 10h			;4c49	d7 	. 
	exx			;4c4a	d9 	. 
	ret c			;4c4b	d8 	. 
	jp 003d6h		;4c4c	c3 d6 03 	. . . 
	pop hl			;4c4f	e1 	. 
l4c50h:
	jp po,0e4e3h		;4c50	e2 e3 e4 	. . . 
	push hl			;4c53	e5 	. 
	and 0e7h		;4c54	e6 e7 	. . 
	add a,a			;4c56	87 	. 
	add a,d			;4c57	82 	. 
	adc a,b			;4c58	88 	. 
	add a,(hl)			;4c59	86 	. 
	add a,l			;4c5a	85 	. 
	adc a,a			;4c5b	8f 	. 
	sub b			;4c5c	90 	. 
	sub c			;4c5d	91 	. 
	add a,e			;4c5e	83 	. 
	adc a,h			;4c5f	8c 	. 
	adc a,l			;4c60	8d 	. 
	adc a,(hl)			;4c61	8e 	. 
	adc a,e			;4c62	8b 	. 
	sub l			;4c63	95 	. 
	sbc a,a			;4c64	9f 	. 
	sbc a,e			;4c65	9b 	. 
	sbc a,d			;4c66	9a 	. 
	sbc a,c			;4c67	99 	. 
l4c68h:
	sbc a,b			;4c68	98 	. 
	sub a			;4c69	97 	. 
	sbc a,h			;4c6a	9c 	. 
	sbc a,(hl)			;4c6b	9e 	. 
	call pe,0e8eeh		;4c6c	ec ee e8 	. . . 
	jp (hl)			;4c6f	e9 	. 
	ret po			;4c70	e0 	. 
	jp pe,0ffebh		;4c71	ea eb ff 	. . . 
	rst 38h			;4c74	ff 	. 
	add hl,bc			;4c75	09 	. 
	sub d			;4c76	92 	. 
	sub e			;4c77	93 	. 
	sub h			;4c78	94 	. 
	rst 38h			;4c79	ff 	. 
	rst 38h			;4c7a	ff 	. 
	rst 38h			;4c7b	ff 	. 
	add a,h			;4c7c	84 	. 
	add a,b			;4c7d	80 	. 
	sbc a,l			;4c7e	9d 	. 
	dec c			;4c7f	0d 	. 
	defb 0edh;next byte illegal after ed		;4c80	ed 	. 
	jr nz,l4c0ch		;4c81	20 89 	  . 
	add a,c			;4c83	81 	. 
	adc a,d			;4c84	8a 	. 
	sub (hl)			;4c85	96 	. 
l4c86h:
	inc bc			;4c86	03 	. 
	ld sp,03332h		;4c87	31 32 33 	1 2 3 
	inc (hl)			;4c8a	34 	4 
	dec (hl)			;4c8b	35 	5 
	ld (hl),037h		;4c8c	36 37 	6 7 
	rst 38h			;4c8e	ff 	. 
	rst 38h			;4c8f	ff 	. 
	rst 38h			;4c90	ff 	. 
	rst 38h			;4c91	ff 	. 
	rst 38h			;4c92	ff 	. 
	rst 38h			;4c93	ff 	. 
	inc (hl)			;4c94	34 	4 
	dec (hl)			;4c95	35 	5 
	rst 38h			;4c96	ff 	. 
	rst 38h			;4c97	ff 	. 
	rst 38h			;4c98	ff 	. 
	rst 38h			;4c99	ff 	. 
	ld sp,03332h		;4c9a	31 32 33 	1 2 3 
	and b			;4c9d	a0 	. 
	rst 38h			;4c9e	ff 	. 
	rst 38h			;4c9f	ff 	. 
	jr nc,l4cceh		;4ca0	30 2c 	0 , 
	ld l,0a2h		;4ca2	2e a2 	. . 
	and h			;4ca4	a4 	. 
	and (hl)			;4ca5	a6 	. 
	jr c,l4ce1h		;4ca6	38 39 	8 9 
	jr nc,$-86		;4ca8	30 a8 	0 . 
	xor d			;4caa	aa 	. 
	rst 38h			;4cab	ff 	. 
	rst 38h			;4cac	ff 	. 
	add hl,bc			;4cad	09 	. 
	ld (hl),0ach		;4cae	36 ac 	6 . 
	xor (hl)			;4cb0	ae 	. 
	rst 38h			;4cb1	ff 	. 
	rst 38h			;4cb2	ff 	. 
	rst 38h			;4cb3	ff 	. 
	rst 38h			;4cb4	ff 	. 
	rst 38h			;4cb5	ff 	. 
	or b			;4cb6	b0 	. 
	dec c			;4cb7	0d 	. 
	rst 38h			;4cb8	ff 	. 
	jr nz,$+1		;4cb9	20 ff 	  . 
	rst 38h			;4cbb	ff 	. 
	rst 38h			;4cbc	ff 	. 
	rst 38h			;4cbd	ff 	. 
l4cbeh:
	dec hl			;4cbe	2b 	+ 
	ld hl,(l3f2fh)		;4cbf	2a 2f 3f 	* / ? 
	jr z,$+1		;4cc2	28 ff 	( . 
	add hl,hl			;4cc4	29 	) 
	ld e,(hl)			;4cc5	5e 	^ 
	dec l			;4cc6	2d 	- 
	jr z,l4d27h		;4cc7	28 5e 	( ^ 
	add hl,hl			;4cc9	29 	) 
	rst 38h			;4cca	ff 	. 
	dec hl			;4ccb	2b 	+ 
	ccf			;4ccc	3f 	? 
	dec l			;4ccd	2d 	- 
l4cceh:
	ld hl,(0032fh)		;4cce	2a 2f 03 	* / . 
	jr nc,$+50		;4cd1	30 30 	0 0 
	jr nc,$+35		;4cd3	30 21 	0 ! 
	sub (hl)			;4cd5	96 	. 
	ld e,b			;4cd6	58 	X 
	jr sub_4d04h		;4cd7	18 2b 	. + 
	ld hl,l4d3fh		;4cd9	21 3f 4d 	! ? M 
	jr sub_4d04h		;4cdc	18 26 	. & 
	ld hl,l5159h		;4cde	21 59 51 	! Y Q 
l4ce1h:
	jr sub_4d04h		;4ce1	18 21 	. ! 
	ld hl,l5233h		;4ce3	21 33 52 	! 3 R 
	jr sub_4d04h		;4ce6	18 1c 	. . 
	ld hl,l54a7h		;4ce8	21 a7 54 	! . T 
	jr sub_4d04h		;4ceb	18 17 	. . 
	ld hl,l54c6h		;4ced	21 c6 54 	! . T 
	jr sub_4d04h		;4cf0	18 12 	. . 
	ld hl,l4d0dh		;4cf2	21 0d 4d 	! . M 
	jr sub_4d04h		;4cf5	18 0d 	. . 
	ld hl,l4d10h		;4cf7	21 10 4d 	! . M 
	jr sub_4d04h		;4cfa	18 08 	. . 
	ld hl,l4d27h		;4cfc	21 27 4d 	! ' M 
	jr sub_4d04h		;4cff	18 03 	. . 
	ld hl,l4d2ah		;4d01	21 2a 4d 	! * M 
sub_4d04h:
	push hl			;4d04	e5 	. 
	call sub_513ch		;4d05	cd 3c 51 	. < Q 
	ld hl,sub_512ch		;4d08	21 2c 51 	! , Q 
	ex (sp),hl			;4d0b	e3 	. 
	jp (hl)			;4d0c	e9 	. 
l4d0dh:
	xor a			;4d0d	af 	. 
	jr l4d11h		;4d0e	18 01 	. . 
l4d10h:
	scf			;4d10	37 	7 
l4d11h:
	ld hl,0f2a4h		;4d11	21 a4 f2 	! . . 
	ld a,(hl)			;4d14	7e 	~ 
	push af			;4d15	f5 	. 
	ld (hl),014h		;4d16	36 14 	6 . 
	push hl			;4d18	e5 	. 
	jr nc,l4d20h		;4d19	30 05 	0 . 
	call sub_56edh		;4d1b	cd ed 56 	. . V 
	jr l4d23h		;4d1e	18 03 	. . 
l4d20h:
	call sub_5715h		;4d20	cd 15 57 	. . W 
l4d23h:
	pop hl			;4d23	e1 	. 
	pop af			;4d24	f1 	. 
	ld (hl),a			;4d25	77 	w 
	ret			;4d26	c9 	. 
l4d27h:
	xor a			;4d27	af 	. 
	jr l4d2bh		;4d28	18 01 	. . 
l4d2ah:
	scf			;4d2a	37 	7 
l4d2bh:
	ld hl,0f2a5h		;4d2b	21 a5 f2 	! . . 
	ld a,(hl)			;4d2e	7e 	~ 
	push af			;4d2f	f5 	. 
	ld (hl),001h		;4d30	36 01 	6 . 
	push hl			;4d32	e5 	. 
	jr nc,l4d3ah		;4d33	30 05 	0 . 
	call sub_57a4h		;4d35	cd a4 57 	. . W 
	jr l4d23h		;4d38	18 e9 	. . 
l4d3ah:
	call sub_5785h		;4d3a	cd 85 57 	. . W 
	jr l4d23h		;4d3d	18 e4 	. . 
l4d3fh:
	ld hl,0f2a3h		;4d3f	21 a3 f2 	! . . 
	ld a,(hl)			;4d42	7e 	~ 
	inc a			;4d43	3c 	< 
	and 003h		;4d44	e6 03 	. . 
	ld (hl),a			;4d46	77 	w 
	sub 003h		;4d47	d6 03 	. . 
	jp nz,l55e5h		;4d49	c2 e5 55 	. . U 
	ld (hl),a			;4d4c	77 	w 
	jp l55e5h		;4d4d	c3 e5 55 	. . U 
XFONTGET:
	call sub_4fd3h		;4d50	cd d3 4f 	. . O 
	ld de,0f7c6h		;4d53	11 c6 f7 	. . . 
	ex de,hl			;4d56	eb 	. 
	ld bc,l0006h+2		;4d57	01 08 00 	. . . 
	jp 0ec88h		;4d5a	c3 88 ec 	. . . 
sub_4d5dh:
	ld a,(0f2aah)		;4d5d	3a aa f2 	: . . 
	dec a			;4d60	3d 	= 
	jr z,l4da4h		;4d61	28 41 	( A 
	dec a			;4d63	3d 	= 
	jr z,l4db3h		;4d64	28 4d 	( M 
	ld a,c			;4d66	79 	y 
	cp 020h		;4d67	fe 20 	.   
	jr nc,l4d74h		;4d69	30 09 	0 . 
	ld hl,l4df1h		;4d6b	21 f1 4d 	! . M 
l4d6eh:
	call sub_4dd3h		;4d6e	cd d3 4d 	. . M 
	ret c			;4d71	d8 	. 
	jr l4d7fh		;4d72	18 0b 	. . 
l4d74h:
	ld hl,l4f72h		;4d74	21 72 4f 	! r O 
	ld (0f2a8h),hl		;4d77	22 a8 f2 	" . . 
	ld a,0c0h		;4d7a	3e c0 	> . 
	ld (0f2a7h),a		;4d7c	32 a7 f2 	2 . . 
l4d7fh:
	push bc			;4d7f	c5 	. 
	ld a,(0f2a7h)		;4d80	3a a7 f2 	: . . 
	push af			;4d83	f5 	. 
	and 080h		;4d84	e6 80 	. . 
	call nz,sub_513ch		;4d86	c4 3c 51 	. < Q 
	pop af			;4d89	f1 	. 
	and 040h		;4d8a	e6 40 	. @ 
	jr z,l4d92h		;4d8c	28 04 	( . 
	xor a			;4d8e	af 	. 
	ld (0f2a6h),a		;4d8f	32 a6 f2 	2 . . 
l4d92h:
	pop bc			;4d92	c1 	. 
	ld hl,l4d9bh		;4d93	21 9b 4d 	! . M 
	push hl			;4d96	e5 	. 
	ld hl,(0f2a8h)		;4d97	2a a8 f2 	* . . 
	jp (hl)			;4d9a	e9 	. 
l4d9bh:
	ld a,(0f2a7h)		;4d9b	3a a7 f2 	: . . 
	and 080h		;4d9e	e6 80 	. . 
	call nz,sub_512ch		;4da0	c4 2c 51 	. , Q 
	ret			;4da3	c9 	. 
l4da4h:
	ld hl,l4e3ah		;4da4	21 3a 4e 	! : N 
	call sub_4dd3h		;4da7	cd d3 4d 	. . M 
	jr c,l4dcch		;4daa	38 20 	8   
	ld a,002h		;4dac	3e 02 	> . 
	ld (0f2aah),a		;4dae	32 aa f2 	2 . . 
	jr l4dbfh		;4db1	18 0c 	. . 
l4db3h:
	ld hl,0f2abh		;4db3	21 ab f2 	! . . 
	ld a,(hl)			;4db6	7e 	~ 
	inc (hl)			;4db7	34 	4 
	ld hl,0f2ach		;4db8	21 ac f2 	! . . 
	call sub_59a3h		;4dbb	cd a3 59 	. . Y 
	ld (hl),c			;4dbe	71 	q 
l4dbfh:
	ld hl,0f2abh		;4dbf	21 ab f2 	! . . 
	ld a,(0f2a7h)		;4dc2	3a a7 f2 	: . . 
	and 00fh		;4dc5	e6 0f 	. . 
	cp (hl)			;4dc7	be 	. 
	ret nz			;4dc8	c0 	. 
	call l4d7fh		;4dc9	cd 7f 4d 	.  M 
l4dcch:
	ld hl,COLDRST		;4dcc	21 00 00 	! . . 
	ld (0f2aah),hl		;4dcf	22 aa f2 	" . . 
	ret			;4dd2	c9 	. 
sub_4dd3h:
	ld a,(hl)			;4dd3	7e 	~ 
	or a			;4dd4	b7 	. 
	jr z,l4defh		;4dd5	28 18 	( . 
	inc hl			;4dd7	23 	# 
	cp c			;4dd8	b9 	. 
	jr z,l4de0h		;4dd9	28 05 	( . 
	inc hl			;4ddb	23 	# 
	inc hl			;4ddc	23 	# 
	inc hl			;4ddd	23 	# 
	jr sub_4dd3h		;4dde	18 f3 	. . 
l4de0h:
	ld a,(hl)			;4de0	7e 	~ 
	ld (0f2a7h),a		;4de1	32 a7 f2 	2 . . 
	inc hl			;4de4	23 	# 
	ld a,(hl)			;4de5	7e 	~ 
	ld (0f2a8h),a		;4de6	32 a8 f2 	2 . . 
	inc hl			;4de9	23 	# 
	ld a,(hl)			;4dea	7e 	~ 
	ld (0f2a9h),a		;4deb	32 a9 f2 	2 . . 
	ret			;4dee	c9 	. 
l4defh:
	scf			;4def	37 	7 
	ret			;4df0	c9 	. 
l4df1h:
	ld (bc),a			;4df1	02 	. 
	add a,b			;4df2	80 	. 
	ld e,c			;4df3	59 	Y 
	ld d,c			;4df4	51 	Q 
	dec b			;4df5	05 	. 
	add a,b			;4df6	80 	. 
	jp z,00651h		;4df7	ca 51 06 	. Q . 
	add a,b			;4dfa	80 	. 
	inc sp			;4dfb	33 	3 
	ld d,d			;4dfc	52 	R 
	rlca			;4dfd	07 	. 
	nop			;4dfe	00 	. 
	ld b,a			;4dff	47 	G 
	ld d,d			;4e00	52 	R 
	ex af,af'			;4e01	08 	. 
	ret nz			;4e02	c0 	. 
	ld d,a			;4e03	57 	W 
	ld d,l			;4e04	55 	U 
	add hl,bc			;4e05	09 	. 
	ret nz			;4e06	c0 	. 
	ld c,l			;4e07	4d 	M 
	ld d,d			;4e08	52 	R 
	ld a,(bc)			;4e09	0a 	. 
	ret nz			;4e0a	c0 	. 
	ld hl,(00b54h)		;4e0b	2a 54 0b 	* T . 
	ret nz			;4e0e	c0 	. 
	ld h,b			;4e0f	60 	` 
	ld d,h			;4e10	54 	T 
	inc c			;4e11	0c 	. 
	ret nz			;4e12	c0 	. 
	ld l,(hl)			;4e13	6e 	n 
	ld d,h			;4e14	54 	T 
	dec c			;4e15	0d 	. 
	add a,b			;4e16	80 	. 
	sub e			;4e17	93 	. 
	ld d,h			;4e18	54 	T 
	djnz l4d9bh		;4e19	10 80 	. . 
	and a			;4e1b	a7 	. 
	ld d,h			;4e1c	54 	T 
	ld de,0c680h		;4e1d	11 80 c6 	. . . 
	ld d,h			;4e20	54 	T 
	ld a,(de)			;4e21	1a 	. 
	add a,b			;4e22	80 	. 
	ret pe			;4e23	e8 	. 
	ld d,h			;4e24	54 	T 
	dec de			;4e25	1b 	. 
	nop			;4e26	00 	. 
	inc (hl)			;4e27	34 	4 
	ld d,l			;4e28	55 	U 
	inc e			;4e29	1c 	. 
	ret nz			;4e2a	c0 	. 
	ld a,(01d55h)		;4e2b	3a 55 1d 	: U . 
	ret nz			;4e2e	c0 	. 
	ld d,a			;4e2f	57 	W 
	ld d,l			;4e30	55 	U 
	ld e,0c0h		;4e31	1e c0 	. . 
	ld l,l			;4e33	6d 	m 
	ld d,l			;4e34	55 	U 
	rra			;4e35	1f 	. 
	ret nz			;4e36	c0 	. 
	halt			;4e37	76 	v 
	ld d,l			;4e38	55 	U 
	nop			;4e39	00 	. 
l4e3ah:
	dec h			;4e3a	25 	% 
	pop bc			;4e3b	c1 	. 
	ld (hl),l			;4e3c	75 	u 
	ld c,a			;4e3d	4f 	O 
	jr z,$-122		;4e3e	28 84 	( . 
	add a,l			;4e40	85 	. 
	ld d,l			;4e41	55 	U 
	ld hl,(l6ec0h)		;4e42	2a c0 6e 	* . n 
	ld d,h			;4e45	54 	T 
	jr nc,l4e48h		;4e46	30 00 	0 . 
l4e48h:
	or e			;4e48	b3 	. 
	ld d,l			;4e49	55 	U 
	ld sp,0b900h		;4e4a	31 00 b9 	1 . . 
	ld d,l			;4e4d	55 	U 
	ld (0bf80h),a		;4e4e	32 80 bf 	2 . . 
	ld d,l			;4e51	55 	U 
	inc sp			;4e52	33 	3 
	add a,b			;4e53	80 	. 
	push bc			;4e54	c5 	. 
	ld d,l			;4e55	55 	U 
	dec a			;4e56	3d 	= 
	jp nz,l55cbh		;4e57	c2 cb 55 	. . U 
	ld b,e			;4e5a	43 	C 
	ld bc,l55eah		;4e5b	01 ea 55 	. . U 
	ld d,b			;4e5e	50 	P 
	nop			;4e5f	00 	. 
	dec c			;4e60	0d 	. 
	ld d,(hl)			;4e61	56 	V 
	ld d,h			;4e62	54 	T 
	add a,b			;4e63	80 	. 
	jp z,05951h		;4e64	ca 51 59 	. Q Y 
	add a,b			;4e67	80 	. 
	ret pe			;4e68	e8 	. 
	ld d,h			;4e69	54 	T 
	ld a,e			;4e6a	7b 	{ 
	nop			;4e6b	00 	. 
	djnz l4ec4h		;4e6c	10 56 	. V 
	ld a,l			;4e6e	7d 	} 
	nop			;4e6f	00 	. 
	ld de,09056h		;4e70	11 56 90 	. V . 
	add a,d			;4e73	82 	. 
	ld d,056h		;4e74	16 56 	. V 
	sub c			;4e76	91 	. 
	add a,d			;4e77	82 	. 
	inc sp			;4e78	33 	3 
	ld d,(hl)			;4e79	56 	V 
	sub d			;4e7a	92 	. 
	add a,b			;4e7b	80 	. 
	im 1		;4e7c	ed 56 	. V 
	sub e			;4e7e	93 	. 
	add a,b			;4e7f	80 	. 
	dec d			;4e80	15 	. 
	ld d,a			;4e81	57 	W 
	sub h			;4e82	94 	. 
	ld (bc),a			;4e83	02 	. 
	ld h,(hl)			;4e84	66 	f 
	ld d,a			;4e85	57 	W 
	sub l			;4e86	95 	. 
	ld bc,l577dh		;4e87	01 7d 57 	. } W 
	sub (hl)			;4e8a	96 	. 
	add a,b			;4e8b	80 	. 
	add a,l			;4e8c	85 	. 
	ld d,a			;4e8d	57 	W 
	sub a			;4e8e	97 	. 
	add a,b			;4e8f	80 	. 
	and h			;4e90	a4 	. 
	ld d,a			;4e91	57 	W 
	sbc a,b			;4e92	98 	. 
	ld bc,l57cch		;4e93	01 cc 57 	. . W 
	and b			;4e96	a0 	. 
	nop			;4e97	00 	. 
	jp c,0a157h		;4e98	da 57 a1 	. W . 
	nop			;4e9b	00 	. 
	ex de,hl			;4e9c	eb 	. 
	ld d,a			;4e9d	57 	W 
	and d			;4e9e	a2 	. 
	nop			;4e9f	00 	. 
	defb 0ddh,057h,0a3h	;illegal sequence		;4ea0	dd 57 a3 	. W . 
	nop			;4ea3	00 	. 
	xor 057h		;4ea4	ee 57 	. W 
	and h			;4ea6	a4 	. 
	nop			;4ea7	00 	. 
	ret po			;4ea8	e0 	. 
	ld d,a			;4ea9	57 	W 
	and l			;4eaa	a5 	. 
	nop			;4eab	00 	. 
	pop af			;4eac	f1 	. 
	ld d,a			;4ead	57 	W 
	or b			;4eae	b0 	. 
	nop			;4eaf	00 	. 
	jp m,0b157h		;4eb0	fa 57 b1 	. W . 
	nop			;4eb3	00 	. 
	nop			;4eb4	00 	. 
	ld e,b			;4eb5	58 	X 
	ret nc			;4eb6	d0 	. 
	jp nz,l5803h		;4eb7	c2 03 58 	. . X 
	jp nc,03683h		;4eba	d2 83 36 	. . 6 
	ld e,b			;4ebd	58 	X 
	call nc,sub_5480h		;4ebe	d4 80 54 	. . T 
	ld e,b			;4ec1	58 	X 
	push de			;4ec2	d5 	. 
	add a,b			;4ec3	80 	. 
l4ec4h:
	ld l,a			;4ec4	6f 	o 
	ld e,b			;4ec5	58 	X 
	sub 081h		;4ec6	d6 81 	. . 
	adc a,c			;4ec8	89 	. 
	ld e,b			;4ec9	58 	X 
	rst 10h			;4eca	d7 	. 
	add a,b			;4ecb	80 	. 
	sub (hl)			;4ecc	96 	. 
	ld e,b			;4ecd	58 	X 
	ret po			;4ece	e0 	. 
	add hl,bc			;4ecf	09 	. 
	and (hl)			;4ed0	a6 	. 
	ld e,b			;4ed1	58 	X 
	ret p			;4ed2	f0 	. 
	ld bc,l58d6h		;4ed3	01 d6 58 	. . X 
	pop af			;4ed6	f1 	. 
	ld bc,l58e3h		;4ed7	01 e3 58 	. . X 
	jp p,0ed01h		;4eda	f2 01 ed 	. . . 
	ld e,b			;4edd	58 	X 
	di			;4ede	f3 	. 
	inc b			;4edf	04 	. 
	jp p,0f458h		;4ee0	f2 58 f4 	. X . 
	inc b			;4ee3	04 	. 
	cp 058h		;4ee4	fe 58 	. X 
	push af			;4ee6	f5 	. 
	inc b			;4ee7	04 	. 
	inc bc			;4ee8	03 	. 
	ld e,c			;4ee9	59 	Y 
	or 000h		;4eea	f6 00 	. . 
	ex af,af'			;4eec	08 	. 
	ld e,c			;4eed	59 	Y 
	rst 30h			;4eee	f7 	. 
	ld bc,l5916h		;4eef	01 16 59 	. . Y 
	nop			;4ef2	00 	. 
sub_4ef3h:
	ld a,c			;4ef3	79 	y 
	cp 0e0h		;4ef4	fe e0 	. . 
	ret nc			;4ef6	d0 	. 
	call sub_5996h		;4ef7	cd 96 59 	. . Y 
	ret c			;4efa	d8 	. 
	xor a			;4efb	af 	. 
	call sub_5a99h		;4efc	cd 99 5a 	. . Z 
	ret c			;4eff	d8 	. 
	call sub_59a3h		;4f00	cd a3 59 	. . Y 
	ld c,(hl)			;4f03	4e 	N 
	ret			;4f04	c9 	. 
	ret			;4f05	c9 	. 
l4f06h:
	ld a,(hl)			;4f06	7e 	~ 
	rlca			;4f07	07 	. 
	ld c,07eh		;4f08	0e 7e 	. ~ 
	ld a,(hl)			;4f0a	7e 	~ 
	dec c			;4f0b	0d 	. 
	ld a,(de)			;4f0c	1a 	. 
	ld a,(hl)			;4f0d	7e 	~ 
	dec c			;4f0e	0d 	. 
	ld a,l			;4f0f	7d 	} 
	ld b,00dh		;4f10	06 0d 	. . 
	ld a,l			;4f12	7d 	} 
	dec d			;4f13	15 	. 
	dec d			;4f14	15 	. 
	ld b,07dh		;4f15	06 7d 	. } 
	dec d			;4f17	15 	. 
	ld a,h			;4f18	7c 	| 
	dec b			;4f19	05 	. 
	inc c			;4f1a	0c 	. 
	ld a,h			;4f1b	7c 	| 
	inc d			;4f1c	14 	. 
	inc c			;4f1d	0c 	. 
	add hl,de			;4f1e	19 	. 
	rra			;4f1f	1f 	. 
	inc d			;4f20	14 	. 
	ld a,e			;4f21	7b 	{ 
	inc b			;4f22	04 	. 
	dec bc			;4f23	0b 	. 
	ld a,e			;4f24	7b 	{ 
	inc de			;4f25	13 	. 
	dec bc			;4f26	0b 	. 
	nop			;4f27	00 	. 
	rlca			;4f28	07 	. 
	inc de			;4f29	13 	. 
	ld h,b			;4f2a	60 	` 
	ld h,b			;4f2b	60 	` 
	ld h,b			;4f2c	60 	` 
	ld h,b			;4f2d	60 	` 
	ld h,b			;4f2e	60 	` 
l4f2fh:
	inc b			;4f2f	04 	. 
	dec b			;4f30	05 	. 
	ld h,b			;4f31	60 	` 
	inc b			;4f32	04 	. 
	ld e,(hl)			;4f33	5e 	^ 
	ld e,(hl)			;4f34	5e 	^ 
	ld e,(hl)			;4f35	5e 	^ 
	ld e,(hl)			;4f36	5e 	^ 
	ld e,(hl)			;4f37	5e 	^ 
	ld a,(bc)			;4f38	0a 	. 
	ld e,(hl)			;4f39	5e 	^ 
	ld e,(hl)			;4f3a	5e 	^ 
	ld a,(bc)			;4f3b	0a 	. 
	ld e,l			;4f3c	5d 	] 
	inc bc			;4f3d	03 	. 
	ld a,(bc)			;4f3e	0a 	. 
	ld e,l			;4f3f	5d 	] 
	ld (de),a			;4f40	12 	. 
	ld (de),a			;4f41	12 	. 
	inc b			;4f42	04 	. 
	ld e,012h		;4f43	1e 12 	. . 
	ld e,h			;4f45	5c 	\ 
	ld (bc),a			;4f46	02 	. 
	add hl,bc			;4f47	09 	. 
	ld e,h			;4f48	5c 	\ 
	ld de,l5c09h		;4f49	11 09 5c 	. . \ 
	dec e			;4f4c	1d 	. 
	ld de,l015bh		;4f4d	11 5b 01 	. [ . 
	ex af,af'			;4f50	08 	. 
	ld e,e			;4f51	5b 	[ 
	djnz l4f5ch		;4f52	10 08 	. . 
	ld bc,l101ch		;4f54	01 1c 10 	. . . 
	ld b,b			;4f57	40 	@ 
	nop			;4f58	00 	. 
	inc bc			;4f59	03 	. 
	ld b,b			;4f5a	40 	@ 
	ld b,b			;4f5b	40 	@ 
l4f5ch:
	ld d,040h		;4f5c	16 40 	. @ 
	ld b,b			;4f5e	40 	@ 
	ld d,024h		;4f5f	16 24 	. $ 
	inc h			;4f61	24 	$ 
	inc h			;4f62	24 	$ 
	inc h			;4f63	24 	$ 
	inc h			;4f64	24 	$ 
	jr $+38		;4f65	18 24 	. $ 
	inc h			;4f67	24 	$ 
	jr $+37		;4f68	18 23 	. # 
	inc hl			;4f6a	23 	# 
	inc hl			;4f6b	23 	# 
	rrca			;4f6c	0f 	. 
	inc hl			;4f6d	23 	# 
	inc hl			;4f6e	23 	# 
	inc hl			;4f6f	23 	# 
	dec de			;4f70	1b 	. 
	inc hl			;4f71	23 	# 
l4f72h:
	call sub_4ef3h		;4f72	cd f3 4e 	. . N 
	call sub_5996h		;4f75	cd 96 59 	. . Y 
	ld a,(0f2a2h)		;4f78	3a a2 f2 	: . . 
	or a			;4f7b	b7 	. 
	jr z,l4f80h		;4f7c	28 02 	( . 
	ld c,020h		;4f7e	0e 20 	.   
l4f80h:
	call sub_4fbah		;4f80	cd ba 4f 	. . O 
	ld (hl),c			;4f83	71 	q 
l4f84h:
	call sub_514ch		;4f84	cd 4c 51 	. L Q 
	jr c,l4fa6h		;4f87	38 1d 	8 . 
	call sub_4fd3h		;4f89	cd d3 4f 	. . O 
	ld a,(0f297h)		;4f8c	3a 97 f2 	: . . 
	and 001h		;4f8f	e6 01 	. . 
	jr z,l4fa0h		;4f91	28 0d 	( . 
	ld hl,0f7c6h		;4f93	21 c6 f7 	! . . 
	ld c,0fch		;4f96	0e fc 	. . 
	ld b,008h		;4f98	06 08 	. . 
l4f9ah:
	ld a,(hl)			;4f9a	7e 	~ 
	xor c			;4f9b	a9 	. 
	ld (hl),a			;4f9c	77 	w 
	inc hl			;4f9d	23 	# 
	djnz l4f9ah		;4f9e	10 fa 	. . 
l4fa0h:
	call sub_5027h		;4fa0	cd 27 50 	. ' P 
	call sub_5060h		;4fa3	cd 60 50 	. ` P 
l4fa6h:
	ld de,0f298h		;4fa6	11 98 f2 	. . . 
	ld hl,0f29ah		;4fa9	21 9a f2 	! . . 
	ld a,(de)			;4fac	1a 	. 
	cp (hl)			;4fad	be 	. 
	jp nz,l553ah		;4fae	c2 3a 55 	. : U 
	ld a,001h		;4fb1	3e 01 	> . 
	ld (de),a			;4fb3	12 	. 
	ld (0f2a6h),a		;4fb4	32 a6 f2 	2 . . 
	jp l542ah		;4fb7	c3 2a 54 	. * T 
sub_4fbah:
	ld de,(0f298h)		;4fba	ed 5b 98 f2 	. [ . . 
sub_4fbeh:
	push bc			;4fbe	c5 	. 
	dec d			;4fbf	15 	. 
	dec e			;4fc0	1d 	. 
	ld b,d			;4fc1	42 	B 
	ld a,(0f29ah)		;4fc2	3a 9a f2 	: . . 
	ld c,a			;4fc5	4f 	O 
	call sub_59b0h		;4fc6	cd b0 59 	. . Y 
	ld d,000h		;4fc9	16 00 	. . 
	add hl,de			;4fcb	19 	. 
	ld de,(0f290h)		;4fcc	ed 5b 90 f2 	. [ . . 
	add hl,de			;4fd0	19 	. 
	pop bc			;4fd1	c1 	. 
	ret			;4fd2	c9 	. 
sub_4fd3h:
	call sub_501ah		;4fd3	cd 1a 50 	. . P 
	ld a,020h		;4fd6	3e 20 	>   
	cp c			;4fd8	b9 	. 
	ret z			;4fd9	c8 	. 
	push hl			;4fda	e5 	. 
	push de			;4fdb	d5 	. 
	push bc			;4fdc	c5 	. 
	ld hl,l5abeh		;4fdd	21 be 5a 	! . Z 
	ld a,c			;4fe0	79 	y 
	ld c,005h		;4fe1	0e 05 	. . 
	cp 080h		;4fe3	fe 80 	. . 
	jr c,l4ff1h		;4fe5	38 0a 	8 . 
	cp 0e0h		;4fe7	fe e0 	. . 
	jr c,l4ffeh		;4fe9	38 13 	8 . 
	sub 0e0h		;4feb	d6 e0 	. . 
	ld hl,0e940h		;4fed	21 40 e9 	! @ . 
l4ff0h:
	inc c			;4ff0	0c 	. 
l4ff1h:
	push bc			;4ff1	c5 	. 
	ld b,a			;4ff2	47 	G 
	call sub_59a8h		;4ff3	cd a8 59 	. . Y 
	add hl,bc			;4ff6	09 	. 
	pop bc			;4ff7	c1 	. 
	call sub_5005h		;4ff8	cd 05 50 	. . P 
	jp l5085h		;4ffb	c3 85 50 	. . P 
l4ffeh:
	sub 080h		;4ffe	d6 80 	. . 
	ld hl,l5d3eh		;5000	21 3e 5d 	! > ] 
	jr l4ff0h		;5003	18 eb 	. . 
sub_5005h:
	ld b,000h		;5005	06 00 	. . 
	add hl,bc			;5007	09 	. 
	ex de,hl			;5008	eb 	. 
l5009h:
	ld b,008h		;5009	06 08 	. . 
	dec de			;500b	1b 	. 
	ld a,(de)			;500c	1a 	. 
	ld hl,0f7cdh		;500d	21 cd f7 	! . . 
l5010h:
	rlca			;5010	07 	. 
	rr (hl)		;5011	cb 1e 	. . 
	dec hl			;5013	2b 	+ 
	djnz l5010h		;5014	10 fa 	. . 
	dec c			;5016	0d 	. 
	jr nz,l5009h		;5017	20 f0 	  . 
	ret			;5019	c9 	. 
sub_501ah:
	push hl			;501a	e5 	. 
	push de			;501b	d5 	. 
	push bc			;501c	c5 	. 
	ld c,008h		;501d	0e 08 	. . 
	ld hl,0f7c6h		;501f	21 c6 f7 	! . . 
	call sub_5984h		;5022	cd 84 59 	. . Y 
	jr l5085h		;5025	18 5e 	. ^ 
sub_5027h:
	ld de,(0f29eh)		;5027	ed 5b 9e f2 	. [ . . 
	ld a,e			;502b	7b 	{ 
	or a			;502c	b7 	. 
	jp p,sub_5038h		;502d	f2 38 50 	. 8 P 
	ld a,(0f298h)		;5030	3a 98 f2 	: . . 
	ld hl,0f29ch		;5033	21 9c f2 	! . . 
	sub (hl)			;5036	96 	. 
	ld e,a			;5037	5f 	_ 
sub_5038h:
	push bc			;5038	c5 	. 
	ld a,d			;5039	7a 	z 
	add a,a			;503a	87 	. 
	add a,a			;503b	87 	. 
	add a,a			;503c	87 	. 
	ld hl,0f2a0h		;503d	21 a0 f2 	! . . 
	add a,(hl)			;5040	86 	. 
	cp 040h		;5041	fe 40 	. @ 
	jr c,l5047h		;5043	38 02 	8 . 
	sub 040h		;5045	d6 40 	. @ 
l5047h:
	ld b,a			;5047	47 	G 
	ld c,020h		;5048	0e 20 	.   
	call sub_59a8h		;504a	cd a8 59 	. . Y 
	ld hl,(0f294h)		;504d	2a 94 f2 	* . . 
	add hl,bc			;5050	09 	. 
	ld a,e			;5051	7b 	{ 
	add a,a			;5052	87 	. 
	add a,e			;5053	83 	. 
	srl a		;5054	cb 3f 	. ? 
	srl a		;5056	cb 3f 	. ? 
	call sub_59a3h		;5058	cd a3 59 	. . Y 
	ld a,e			;505b	7b 	{ 
	and 003h		;505c	e6 03 	. . 
	pop bc			;505e	c1 	. 
	ret			;505f	c9 	. 
sub_5060h:
	push hl			;5060	e5 	. 
	push de			;5061	d5 	. 
	push bc			;5062	c5 	. 
	ld de,0f7c6h		;5063	11 c6 f7 	. . . 
	ex de,hl			;5066	eb 	. 
	ld b,008h		;5067	06 08 	. . 
	or a			;5069	b7 	. 
	jr z,l5074h		;506a	28 08 	( . 
	dec a			;506c	3d 	= 
	jr z,l5089h		;506d	28 1a 	( . 
	dec a			;506f	3d 	= 
	jr z,l50ach		;5070	28 3a 	( : 
	jr l50d1h		;5072	18 5d 	. ] 
l5074h:
	ld c,003h		;5074	0e 03 	. . 
l5076h:
	ld a,(de)			;5076	1a 	. 
	and c			;5077	a1 	. 
	or (hl)			;5078	b6 	. 
	inc hl			;5079	23 	# 
	ld (de),a			;507a	12 	. 
	ld a,e			;507b	7b 	{ 
	add a,020h		;507c	c6 20 	.   
	ld e,a			;507e	5f 	_ 
	ld a,d			;507f	7a 	z 
	adc a,000h		;5080	ce 00 	. . 
	ld d,a			;5082	57 	W 
	djnz l5076h		;5083	10 f1 	. . 
l5085h:
	pop bc			;5085	c1 	. 
	pop de			;5086	d1 	. 
	pop hl			;5087	e1 	. 
	ret			;5088	c9 	. 
l5089h:
	ld a,(hl)			;5089	7e 	~ 
	inc hl			;508a	23 	# 
	rlca			;508b	07 	. 
	rlca			;508c	07 	. 
	push af			;508d	f5 	. 
	and 003h		;508e	e6 03 	. . 
	ld c,a			;5090	4f 	O 
	ld a,(de)			;5091	1a 	. 
	and 0fch		;5092	e6 fc 	. . 
	or c			;5094	b1 	. 
	ld (de),a			;5095	12 	. 
	inc de			;5096	13 	. 
	pop af			;5097	f1 	. 
	and 0f0h		;5098	e6 f0 	. . 
	ld c,a			;509a	4f 	O 
	ld a,(de)			;509b	1a 	. 
	and 00fh		;509c	e6 0f 	. . 
	or c			;509e	b1 	. 
	ld (de),a			;509f	12 	. 
	ld a,e			;50a0	7b 	{ 
	add a,01fh		;50a1	c6 1f 	. . 
	ld e,a			;50a3	5f 	_ 
	ld a,d			;50a4	7a 	z 
	adc a,000h		;50a5	ce 00 	. . 
	ld d,a			;50a7	57 	W 
	djnz l5089h		;50a8	10 df 	. . 
	jr l5085h		;50aa	18 d9 	. . 
l50ach:
	ld a,(hl)			;50ac	7e 	~ 
	inc hl			;50ad	23 	# 
	rlca			;50ae	07 	. 
	rlca			;50af	07 	. 
	rlca			;50b0	07 	. 
	rlca			;50b1	07 	. 
	push af			;50b2	f5 	. 
	and 00fh		;50b3	e6 0f 	. . 
	ld c,a			;50b5	4f 	O 
	ld a,(de)			;50b6	1a 	. 
	and 0f0h		;50b7	e6 f0 	. . 
	or c			;50b9	b1 	. 
	ld (de),a			;50ba	12 	. 
	inc de			;50bb	13 	. 
	pop af			;50bc	f1 	. 
	and 0c0h		;50bd	e6 c0 	. . 
	ld c,a			;50bf	4f 	O 
	ld a,(de)			;50c0	1a 	. 
	and 03fh		;50c1	e6 3f 	. ? 
	or c			;50c3	b1 	. 
	ld (de),a			;50c4	12 	. 
	ld a,e			;50c5	7b 	{ 
	add a,01fh		;50c6	c6 1f 	. . 
	ld e,a			;50c8	5f 	_ 
	ld a,d			;50c9	7a 	z 
	adc a,000h		;50ca	ce 00 	. . 
	ld d,a			;50cc	57 	W 
	djnz l50ach		;50cd	10 dd 	. . 
	jr l5085h		;50cf	18 b4 	. . 
l50d1h:
	ld a,(hl)			;50d1	7e 	~ 
	inc hl			;50d2	23 	# 
	rrca			;50d3	0f 	. 
	rrca			;50d4	0f 	. 
	ld c,a			;50d5	4f 	O 
	ld a,(de)			;50d6	1a 	. 
	and 0c0h		;50d7	e6 c0 	. . 
	or c			;50d9	b1 	. 
	ld (de),a			;50da	12 	. 
	ld a,e			;50db	7b 	{ 
	add a,020h		;50dc	c6 20 	.   
	ld e,a			;50de	5f 	_ 
	ld a,d			;50df	7a 	z 
	adc a,000h		;50e0	ce 00 	. . 
	ld d,a			;50e2	57 	W 
	djnz l50d1h		;50e3	10 ec 	. . 
	jr l5085h		;50e5	18 9e 	. . 
sub_50e7h:
	call sub_5027h		;50e7	cd 27 50 	. ' P 
	ld c,a			;50ea	4f 	O 
	ld a,(0f296h)		;50eb	3a 96 f2 	: . . 
	and 002h		;50ee	e6 02 	. . 
	jr z,l511fh		;50f0	28 2d 	( - 
	ld a,0e0h		;50f2	3e e0 	> . 
	call sub_59a3h		;50f4	cd a3 59 	. . Y 
sub_50f7h:
	ld a,c			;50f7	79 	y 
	or a			;50f8	b7 	. 
	jr z,l5106h		;50f9	28 0b 	( . 
	dec a			;50fb	3d 	= 
	jr z,l510bh		;50fc	28 0d 	( . 
	dec a			;50fe	3d 	= 
	jr z,l5115h		;50ff	28 14 	( . 
	ld a,(hl)			;5101	7e 	~ 
	xor 03fh		;5102	ee 3f 	. ? 
	ld (hl),a			;5104	77 	w 
	ret			;5105	c9 	. 
l5106h:
	ld a,(hl)			;5106	7e 	~ 
	xor 0fch		;5107	ee fc 	. . 
	ld (hl),a			;5109	77 	w 
	ret			;510a	c9 	. 
l510bh:
	ld a,(hl)			;510b	7e 	~ 
	xor 003h		;510c	ee 03 	. . 
	ld (hl),a			;510e	77 	w 
	inc hl			;510f	23 	# 
	ld a,(hl)			;5110	7e 	~ 
	xor 0f0h		;5111	ee f0 	. . 
	ld (hl),a			;5113	77 	w 
	ret			;5114	c9 	. 
l5115h:
	ld a,(hl)			;5115	7e 	~ 
	xor 00fh		;5116	ee 0f 	. . 
	ld (hl),a			;5118	77 	w 
	inc hl			;5119	23 	# 
	ld a,(hl)			;511a	7e 	~ 
	xor 0c0h		;511b	ee c0 	. . 
	ld (hl),a			;511d	77 	w 
	ret			;511e	c9 	. 
l511fh:
	ld b,008h		;511f	06 08 	. . 
l5121h:
	push hl			;5121	e5 	. 
	call sub_50f7h		;5122	cd f7 50 	. . P 
	pop hl			;5125	e1 	. 
	call sub_59a1h		;5126	cd a1 59 	. . Y 
	djnz l5121h		;5129	10 f6 	. . 
	ret			;512b	c9 	. 
sub_512ch:
	call sub_514ch		;512c	cd 4c 51 	. L Q 
	ret c			;512f	d8 	. 
	ld a,(0f296h)		;5130	3a 96 f2 	: . . 
	and 080h		;5133	e6 80 	. . 
	ret nz			;5135	c0 	. 
	call sub_5a1dh		;5136	cd 1d 5a 	. . Z 
	jp sub_59f9h		;5139	c3 f9 59 	. . Y 
sub_513ch:
	call sub_5a10h		;513c	cd 10 5a 	. . Z 
	call sub_514ch		;513f	cd 4c 51 	. L Q 
	ret c			;5142	d8 	. 
	ld a,(0f296h)		;5143	3a 96 f2 	: . . 
	and 080h		;5146	e6 80 	. . 
	ret nz			;5148	c0 	. 
	jp sub_5a1dh		;5149	c3 1d 5a 	. . Z 
sub_514ch:
	scf			;514c	37 	7 
	ld a,(0f29eh)		;514d	3a 9e f2 	: . . 
	inc a			;5150	3c 	< 
	ret z			;5151	c8 	. 
	ld a,(0f29fh)		;5152	3a 9f f2 	: . . 
	inc a			;5155	3c 	< 
	ret z			;5156	c8 	. 
	or a			;5157	b7 	. 
	ret			;5158	c9 	. 
l5159h:
	ld hl,0f29ch		;5159	21 9c f2 	! . . 
	ld a,(hl)			;515c	7e 	~ 
	dec a			;515d	3d 	= 
	ret z			;515e	c8 	. 
	ld (hl),001h		;515f	36 01 	6 . 
	ld bc,0ec00h		;5161	01 00 ec 	. . . 
l5164h:
	ld a,(0f2a1h)		;5164	3a a1 f2 	: . . 
	cp 002h		;5167	fe 02 	. . 
	jr nz,l5170h		;5169	20 05 	  . 
	call sub_5310h		;516b	cd 10 53 	. . S 
	jr l5173h		;516e	18 03 	. . 
l5170h:
	call XREDSP		;5170	cd 6e 53 	. n S 
l5173h:
	call sub_5733h		;5173	cd 33 57 	. 3 W 
	jp l5179h		;5176	c3 79 51 	. y Q 
l5179h:
	ld de,0f298h		;5179	11 98 f2 	. . . 
	ld hl,0f29ch		;517c	21 9c f2 	! . . 
	ld a,(de)			;517f	1a 	. 
	sub (hl)			;5180	96 	. 
	jr c,l51a3h		;5181	38 20 	8   
	cp 028h		;5183	fe 28 	. ( 
	jr nc,l51a3h		;5185	30 1c 	0 . 
	push af			;5187	f5 	. 
	ld a,(0f2a1h)		;5188	3a a1 f2 	: . . 
	dec a			;518b	3d 	= 
	jp p,l51abh		;518c	f2 ab 51 	. . Q 
	pop af			;518f	f1 	. 
l5190h:
	ld (0f29eh),a		;5190	32 9e f2 	2 . . 
	inc de			;5193	13 	. 
	ld hl,0f29dh		;5194	21 9d f2 	! . . 
	ld a,(de)			;5197	1a 	. 
	sub (hl)			;5198	96 	. 
	jr c,l51a7h		;5199	38 0c 	8 . 
	cp 008h		;519b	fe 08 	. . 
	jr nc,l51a7h		;519d	30 08 	0 . 
l519fh:
	ld (0f29fh),a		;519f	32 9f f2 	2 . . 
	ret			;51a2	c9 	. 
l51a3h:
	ld a,0ffh		;51a3	3e ff 	> . 
	jr l5190h		;51a5	18 e9 	. . 
l51a7h:
	ld a,0ffh		;51a7	3e ff 	> . 
	jr l519fh		;51a9	18 f4 	. . 
l51abh:
	ld hl,0f2e0h		;51ab	21 e0 f2 	! . . 
	jr z,l51c4h		;51ae	28 14 	( . 
	dec a			;51b0	3d 	= 
	jr z,l51bch		;51b1	28 09 	( . 
	pop af			;51b3	f1 	. 
l51b4h:
	dec hl			;51b4	2b 	+ 
	cp (hl)			;51b5	be 	. 
	jr nc,l5190h		;51b6	30 d8 	0 . 
	ld a,0feh		;51b8	3e fe 	> . 
	jr l5190h		;51ba	18 d4 	. . 
l51bch:
	pop af			;51bc	f1 	. 
	cp (hl)			;51bd	be 	. 
	jr c,l51b4h		;51be	38 f4 	8 . 
l51c0h:
	ld a,0fdh		;51c0	3e fd 	> . 
	jr l5190h		;51c2	18 cc 	. . 
l51c4h:
	pop af			;51c4	f1 	. 
	cp (hl)			;51c5	be 	. 
	jr nc,l51c0h		;51c6	30 f8 	0 . 
	jr l5190h		;51c8	18 c6 	. . 
	ld hl,0f298h		;51ca	21 98 f2 	! . . 
	ld a,(0f29ah)		;51cd	3a 9a f2 	: . . 
	sub (hl)			;51d0	96 	. 
	inc a			;51d1	3c 	< 
	ld c,a			;51d2	4f 	O 
	push hl			;51d3	e5 	. 
	call sub_51f8h		;51d4	cd f8 51 	. . Q 
	pop hl			;51d7	e1 	. 
	ld a,(0f29fh)		;51d8	3a 9f f2 	: . . 
	inc a			;51db	3c 	< 
	ret z			;51dc	c8 	. 
sub_51ddh:
	call sub_591dh		;51dd	cd 1d 59 	. . Y 
	sub (hl)			;51e0	96 	. 
	ret c			;51e1	d8 	. 
	ld hl,0f29eh		;51e2	21 9e f2 	! . . 
	ld a,(hl)			;51e5	7e 	~ 
	inc a			;51e6	3c 	< 
	jr nz,l51f2h		;51e7	20 09 	  . 
	inc hl			;51e9	23 	# 
	ld d,(hl)			;51ea	56 	V 
	ld e,000h		;51eb	1e 00 	. . 
	call sub_5038h		;51ed	cd 38 50 	. 8 P 
	jr l51f5h		;51f0	18 03 	. . 
l51f2h:
	call sub_5027h		;51f2	cd 27 50 	. ' P 
l51f5h:
	jp sub_5202h		;51f5	c3 02 52 	. . R 
sub_51f8h:
	ld b,000h		;51f8	06 00 	. . 
sub_51fah:
	call sub_4fbah		;51fa	cd ba 4f 	. . O 
sub_51fdh:
	ld a,020h		;51fd	3e 20 	>   
	jp sub_598bh		;51ff	c3 8b 59 	. . Y 
sub_5202h:
	push hl			;5202	e5 	. 
	ld hl,l522fh		;5203	21 2f 52 	! / R 
	call sub_59a3h		;5206	cd a3 59 	. . Y 
	ld c,(hl)			;5209	4e 	N 
	ld b,008h		;520a	06 08 	. . 
	pop hl			;520c	e1 	. 
	push hl			;520d	e5 	. 
l520eh:
	ld a,(hl)			;520e	7e 	~ 
	and c			;520f	a1 	. 
	ld (hl),a			;5210	77 	w 
	call sub_59a1h		;5211	cd a1 59 	. . Y 
	djnz l520eh		;5214	10 f8 	. . 
	pop hl			;5216	e1 	. 
	inc hl			;5217	23 	# 
	ld a,l			;5218	7d 	} 
	and 01fh		;5219	e6 1f 	. . 
	sub 020h		;521b	d6 20 	.   
	neg		;521d	ed 44 	. D 
	ld c,a			;521f	4f 	O 
	ld b,008h		;5220	06 08 	. . 
l5222h:
	push bc			;5222	c5 	. 
	push hl			;5223	e5 	. 
	call sub_5984h		;5224	cd 84 59 	. . Y 
	pop hl			;5227	e1 	. 
	pop bc			;5228	c1 	. 
	call sub_59a1h		;5229	cd a1 59 	. . Y 
	djnz l5222h		;522c	10 f4 	. . 
	ret			;522e	c9 	. 
l522fh:
	nop			;522f	00 	. 
	call m,0c0f0h		;5230	fc f0 c0 	. . . 
l5233h:
	ld hl,0f29ah		;5233	21 9a f2 	! . . 
	call sub_591dh		;5236	cd 1d 59 	. . Y 
	cp (hl)			;5239	be 	. 
	ret z			;523a	c8 	. 
	ld a,(hl)			;523b	7e 	~ 
	sub 027h		;523c	d6 27 	. ' 
	ld (0f29ch),a		;523e	32 9c f2 	2 . . 
	ld bc,01400h		;5241	01 00 14 	. . . 
	jp l5164h		;5244	c3 64 51 	. d Q 
	ld bc,l220ah		;5247	01 0a 22 	. . " 
	jp l3a69h		;524a	c3 69 3a 	. i : 
	ld de,0f298h		;524d	11 98 f2 	. . . 
	ld hl,0f29ah		;5250	21 9a f2 	! . . 
	ld a,(de)			;5253	1a 	. 
	dec a			;5254	3d 	= 
	and 0f8h		;5255	e6 f8 	. . 
	add a,009h		;5257	c6 09 	. . 
	cp (hl)			;5259	be 	. 
	jr c,l5266h		;525a	38 0a 	8 . 
	ld a,001h		;525c	3e 01 	> . 
	ld (de),a			;525e	12 	. 
	inc de			;525f	13 	. 
	inc hl			;5260	23 	# 
	ld a,(de)			;5261	1a 	. 
	cp (hl)			;5262	be 	. 
	jr z,l5267h		;5263	28 02 	( . 
	inc a			;5265	3c 	< 
l5266h:
	ld (de),a			;5266	12 	. 
l5267h:
	ld a,001h		;5267	3e 01 	> . 
	jp l5467h		;5269	c3 67 54 	. g T 
sub_526ch:
	xor a			;526c	af 	. 
sub_526dh:
	push af			;526d	f5 	. 
	call l5179h		;526e	cd 79 51 	. y Q 
	ld bc,COLDRST		;5271	01 00 00 	. . . 
	ld a,(0f2a3h)		;5274	3a a3 f2 	: . . 
	dec a			;5277	3d 	= 
	jr z,l52beh		;5278	28 44 	( D 
	dec a			;527a	3d 	= 
	jr z,l5283h		;527b	28 06 	( . 
	ld a,(0f2a1h)		;527d	3a a1 f2 	: . . 
	or a			;5280	b7 	. 
	jr nz,l52c0h		;5281	20 3d 	  = 
l5283h:
	ld hl,0f29dh		;5283	21 9d f2 	! . . 
	ld de,0f299h		;5286	11 99 f2 	. . . 
	ld a,(0f29fh)		;5289	3a 9f f2 	: . . 
	inc a			;528c	3c 	< 
	jr nz,l52beh		;528d	20 2f 	  / 
	pop af			;528f	f1 	. 
	jr c,l529ah		;5290	38 08 	8 . 
	ld a,(de)			;5292	1a 	. 
	sub (hl)			;5293	96 	. 
	jr c,l52afh		;5294	38 19 	8 . 
	sub 007h		;5296	d6 07 	. . 
	jr l52afh		;5298	18 15 	. . 
l529ah:
	ld a,(de)			;529a	1a 	. 
	cp 005h		;529b	fe 05 	. . 
	ld a,001h		;529d	3e 01 	> . 
	jr c,l52bbh		;529f	38 1a 	8 . 
	ld a,(0f29bh)		;52a1	3a 9b f2 	: . . 
	ex de,hl			;52a4	eb 	. 
	sub (hl)			;52a5	96 	. 
	ex de,hl			;52a6	eb 	. 
	cp 005h		;52a7	fe 05 	. . 
	jr c,l52b6h		;52a9	38 0b 	8 . 
	ld a,(de)			;52ab	1a 	. 
	sub (hl)			;52ac	96 	. 
	sub 003h		;52ad	d6 03 	. . 
l52afh:
	ld c,a			;52af	4f 	O 
	ld a,(hl)			;52b0	7e 	~ 
	add a,c			;52b1	81 	. 
	ld (hl),a			;52b2	77 	w 
	jp l5179h		;52b3	c3 79 51 	. y Q 
l52b6h:
	ld a,(0f29bh)		;52b6	3a 9b f2 	: . . 
	sub 007h		;52b9	d6 07 	. . 
l52bbh:
	sub (hl)			;52bb	96 	. 
	jr l52afh		;52bc	18 f1 	. . 
l52beh:
	pop af			;52be	f1 	. 
	ret			;52bf	c9 	. 
l52c0h:
	ld de,0f29ch		;52c0	11 9c f2 	. . . 
	ld a,(0f29eh)		;52c3	3a 9e f2 	: . . 
	inc a			;52c6	3c 	< 
	jr z,l52eeh		;52c7	28 25 	( % 
	inc a			;52c9	3c 	< 
	jr z,l52dah		;52ca	28 0e 	( . 
	inc a			;52cc	3c 	< 
	jr nz,l5283h		;52cd	20 b4 	  . 
	pop af			;52cf	f1 	. 
	push af			;52d0	f5 	. 
	jr z,l52eeh		;52d1	28 1b 	( . 
	dec a			;52d3	3d 	= 
	jr nz,l5283h		;52d4	20 ad 	  . 
	ld b,014h		;52d6	06 14 	. . 
	jr l52e3h		;52d8	18 09 	. . 
l52dah:
	pop af			;52da	f1 	. 
	push af			;52db	f5 	. 
	jr z,l52eeh		;52dc	28 10 	( . 
	inc a			;52de	3c 	< 
	jr nz,l5283h		;52df	20 a2 	  . 
	ld b,0ech		;52e1	06 ec 	. . 
l52e3h:
	ld a,(de)			;52e3	1a 	. 
	add a,b			;52e4	80 	. 
	ld (de),a			;52e5	12 	. 
	call sub_5733h		;52e6	cd 33 57 	. 3 W 
	call l5179h		;52e9	cd 79 51 	. y Q 
	jr l5283h		;52ec	18 95 	. . 
l52eeh:
	push de			;52ee	d5 	. 
	ld hl,0f2e0h		;52ef	21 e0 f2 	! . . 
	ld a,(0f298h)		;52f2	3a 98 f2 	: . . 
	dec a			;52f5	3d 	= 
	cp (hl)			;52f6	be 	. 
	jr c,l5307h		;52f7	38 0e 	8 . 
	ex de,hl			;52f9	eb 	. 
	ld hl,0f2a4h		;52fa	21 a4 f2 	! . . 
	sub (hl)			;52fd	96 	. 
	jr c,l5307h		;52fe	38 07 	8 . 
	ld b,(hl)			;5300	46 	F 
	ex de,hl			;5301	eb 	. 
	cp (hl)			;5302	be 	. 
	jr c,l5307h		;5303	38 02 	8 . 
	ld b,028h		;5305	06 28 	. ( 
l5307h:
	pop de			;5307	d1 	. 
	inc b			;5308	04 	. 
	ld a,(de)			;5309	1a 	. 
	sub b			;530a	90 	. 
	neg		;530b	ed 44 	. D 
	ld b,a			;530d	47 	G 
	jr l52e3h		;530e	18 d3 	. . 
sub_5310h:
	ld a,b			;5310	78 	x 
	or c			;5311	b1 	. 
	ret z			;5312	c8 	. 
	ld a,b			;5313	78 	x 
	cp 028h		;5314	fe 28 	. ( 
	jr z,XREDSP		;5316	28 56 	( V 
	sub 0d8h		;5318	d6 d8 	. . 
	jr z,XREDSP		;531a	28 52 	( R 
	ld a,c			;531c	79 	y 
	add a,007h		;531d	c6 07 	. . 
	cp 00fh		;531f	fe 0f 	. . 
	jr nc,XREDSP		;5321	30 4b 	0 K 
	ld a,c			;5323	79 	y 
	or a			;5324	b7 	. 
	jr nz,l533ah		;5325	20 13 	  . 
sub_5327h:
	bit 7,b		;5327	cb 78 	. x 
	jr nz,l5332h		;5329	20 07 	  . 
	call sub_53cah		;532b	cd ca 53 	. . S 
	ld c,014h		;532e	0e 14 	. . 
	jr l5337h		;5330	18 05 	. . 
l5332h:
	call sub_53e4h		;5332	cd e4 53 	. . S 
	ld c,000h		;5335	0e 00 	. . 
l5337h:
	jp l539bh		;5337	c3 9b 53 	. . S 
l533ah:
	push bc			;533a	c5 	. 
	ld a,b			;533b	78 	x 
	or a			;533c	b7 	. 
	call nz,sub_5327h		;533d	c4 27 53 	. ' S 
	pop bc			;5340	c1 	. 
	ld hl,0f2a0h		;5341	21 a0 f2 	! . . 
	ld a,c			;5344	79 	y 
	add a,a			;5345	87 	. 
	add a,a			;5346	87 	. 
	add a,a			;5347	87 	. 
	add a,(hl)			;5348	86 	. 
	and 03fh		;5349	e6 3f 	. ? 
	call sub_5362h		;534b	cd 62 53 	. b S 
	bit 7,c		;534e	cb 79 	. y 
	jr nz,l5359h		;5350	20 07 	  . 
	ld b,c			;5352	41 	A 
	ld a,008h		;5353	3e 08 	> . 
	sub c			;5355	91 	. 
	ld c,a			;5356	4f 	O 
	jr l535fh		;5357	18 06 	. . 
l5359h:
	ld a,c			;5359	79 	y 
	neg		;535a	ed 44 	. D 
	ld b,a			;535c	47 	G 
	ld c,000h		;535d	0e 00 	. . 
l535fh:
	jp l53b3h		;535f	c3 b3 53 	. . S 
sub_5362h:
	push hl			;5362	e5 	. 
	ld (0f2a0h),a		;5363	32 a0 f2 	2 . . 
	ld hl,0efb6h		;5366	21 b6 ef 	! . . 
	or (hl)			;5369	b6 	. 
	out (009h),a		;536a	d3 09 	. . 
	pop hl			;536c	e1 	. 
	ret			;536d	c9 	. 
XREDSP:
	xor a			;536e	af 	. 
	call sub_5362h		;536f	cd 62 53 	. b S 
	ld de,(0f29ch)		;5372	ed 5b 9c f2 	. [ . . 
	call sub_4fbeh		;5376	cd be 4f 	. . O 
	ld bc,l0828h		;5379	01 28 08 	. ( . 
	ex de,hl			;537c	eb 	. 
	ld hl,(0f294h)		;537d	2a 94 f2 	* . . 
l5380h:
	call sub_5400h		;5380	cd 00 54 	. . T 
	inc h			;5383	24 	$ 
	ld a,h			;5384	7c 	| 
	sub 008h		;5385	d6 08 	. . 
	push hl			;5387	e5 	. 
	ld hl,0f295h		;5388	21 95 f2 	! . . 
	cp (hl)			;538b	be 	. 
	pop hl			;538c	e1 	. 
	jr c,l5390h		;538d	38 01 	8 . 
	ld h,a			;538f	67 	g 
l5390h:
	ld a,(0f29ah)		;5390	3a 9a f2 	: . . 
	ex de,hl			;5393	eb 	. 
	call sub_59a3h		;5394	cd a3 59 	. . Y 
	ex de,hl			;5397	eb 	. 
	djnz l5380h		;5398	10 e6 	. . 
	ret			;539a	c9 	. 
l539bh:
	ld de,(0f29ch)		;539b	ed 5b 9c f2 	. [ . . 
	ld a,e			;539f	7b 	{ 
	add a,c			;53a0	81 	. 
	ld e,a			;53a1	5f 	_ 
	call sub_4fbeh		;53a2	cd be 4f 	. . O 
	push hl			;53a5	e5 	. 
	ld d,000h		;53a6	16 00 	. . 
	ld e,c			;53a8	59 	Y 
	call sub_5038h		;53a9	cd 38 50 	. 8 P 
	pop de			;53ac	d1 	. 
	ld bc,l0814h		;53ad	01 14 08 	. . . 
	jp l5380h		;53b0	c3 80 53 	. . S 
l53b3h:
	ld de,(0f29ch)		;53b3	ed 5b 9c f2 	. [ . . 
	ld a,d			;53b7	7a 	z 
	add a,c			;53b8	81 	. 
	ld d,a			;53b9	57 	W 
	call sub_4fbeh		;53ba	cd be 4f 	. . O 
	push hl			;53bd	e5 	. 
	ld d,c			;53be	51 	Q 
	ld e,000h		;53bf	1e 00 	. . 
	call sub_5038h		;53c1	cd 38 50 	. 8 P 
	pop de			;53c4	d1 	. 
	ld c,028h		;53c5	0e 28 	. ( 
	jp l5380h		;53c7	c3 80 53 	. . S 
sub_53cah:
	push bc			;53ca	c5 	. 
	ld hl,(0f294h)		;53cb	2a 94 f2 	* . . 
	ld b,040h		;53ce	06 40 	. @ 
l53d0h:
	push bc			;53d0	c5 	. 
	ld d,h			;53d1	54 	T 
	ld e,l			;53d2	5d 	] 
	ld a,00fh		;53d3	3e 0f 	> . 
	call sub_59a3h		;53d5	cd a3 59 	. . Y 
	ld bc,l000fh		;53d8	01 0f 00 	. . . 
	ldir		;53db	ed b0 	. . 
	inc hl			;53dd	23 	# 
	inc hl			;53de	23 	# 
	pop bc			;53df	c1 	. 
	djnz l53d0h		;53e0	10 ee 	. . 
	pop bc			;53e2	c1 	. 
	ret			;53e3	c9 	. 
sub_53e4h:
	push bc			;53e4	c5 	. 
	ld hl,(0f294h)		;53e5	2a 94 f2 	* . . 
	ld b,040h		;53e8	06 40 	. @ 
l53eah:
	push bc			;53ea	c5 	. 
	ld d,h			;53eb	54 	T 
	ld e,l			;53ec	5d 	] 
	ld a,00fh		;53ed	3e 0f 	> . 
	call sub_59a3h		;53ef	cd a3 59 	. . Y 
	ex de,hl			;53f2	eb 	. 
	ld bc,l000fh		;53f3	01 0f 00 	. . . 
	ldir		;53f6	ed b0 	. . 
	ex de,hl			;53f8	eb 	. 
	inc hl			;53f9	23 	# 
	inc hl			;53fa	23 	# 
	pop bc			;53fb	c1 	. 
	djnz l53eah		;53fc	10 ec 	. . 
	pop bc			;53fe	c1 	. 
	ret			;53ff	c9 	. 
sub_5400h:
	push hl			;5400	e5 	. 
	push de			;5401	d5 	. 
	push bc			;5402	c5 	. 
	srl c		;5403	cb 39 	. 9 
	srl c		;5405	cb 39 	. 9 
	ld b,000h		;5407	06 00 	. . 
l5409h:
	push bc			;5409	c5 	. 
	ld c,000h		;540a	0e 00 	. . 
l540ch:
	ld a,(de)			;540c	1a 	. 
	cp c			;540d	b9 	. 
	jr z,l5414h		;540e	28 04 	( . 
	ld c,a			;5410	4f 	O 
	call sub_4fd3h		;5411	cd d3 4f 	. . O 
l5414h:
	ld a,b			;5414	78 	x 
	call sub_5060h		;5415	cd 60 50 	. ` P 
	ld a,b			;5418	78 	x 
	or a			;5419	b7 	. 
	jr z,l541dh		;541a	28 01 	( . 
	inc hl			;541c	23 	# 
l541dh:
	inc de			;541d	13 	. 
	inc b			;541e	04 	. 
	cp 003h		;541f	fe 03 	. . 
	jr nz,l540ch		;5421	20 e9 	  . 
	pop bc			;5423	c1 	. 
	dec c			;5424	0d 	. 
	jr nz,l5409h		;5425	20 e2 	  . 
	jp l5085h		;5427	c3 85 50 	. . P 
l542ah:
	ld de,0f299h		;542a	11 99 f2 	. . . 
	ld hl,(0f29ah)		;542d	2a 9a f2 	* . . 
	ld a,(de)			;5430	1a 	. 
	cp h			;5431	bc 	. 
	jr nz,l5459h		;5432	20 25 	  % 
	ld b,h			;5434	44 	D 
	dec b			;5435	05 	. 
	ld c,l			;5436	4d 	M 
	call sub_59a8h		;5437	cd a8 59 	. . Y 
	ld hl,(0f290h)		;543a	2a 90 f2 	* . . 
	ld d,h			;543d	54 	T 
	ld e,l			;543e	5d 	] 
	ld a,(0f29ah)		;543f	3a 9a f2 	: . . 
	call sub_59a3h		;5442	cd a3 59 	. . Y 
	call sub_59c5h		;5445	cd c5 59 	. . Y 
	ex de,hl			;5448	eb 	. 
	ld a,(0f29ah)		;5449	3a 9a f2 	: . . 
	ld c,a			;544c	4f 	O 
	ld b,000h		;544d	06 00 	. . 
	call sub_51fdh		;544f	cd fd 51 	. . Q 
	call sub_526ch		;5452	cd 6c 52 	. l R 
	ld c,001h		;5455	0e 01 	. . 
	jr l546bh		;5457	18 12 	. . 
l5459h:
	inc a			;5459	3c 	< 
	ld (de),a			;545a	12 	. 
	call sub_526ch		;545b	cd 6c 52 	. l R 
	jr l546bh		;545e	18 0b 	. . 
	ld hl,l0101h		;5460	21 01 01 	! . . 
	ld (0f298h),hl		;5463	22 98 f2 	" . . 
	xor a			;5466	af 	. 
l5467h:
	or a			;5467	b7 	. 
l5468h:
	call sub_526dh		;5468	cd 6d 52 	. m R 
l546bh:
	jp sub_5310h		;546b	c3 10 53 	. . S 
l546eh:
	ld bc,(0f292h)		;546e	ed 4b 92 f2 	. K . . 
	ld hl,(0f290h)		;5472	2a 90 f2 	* . . 
	ld a,020h		;5475	3e 20 	>   
	call sub_598bh		;5477	cd 8b 59 	. . Y 
	ld hl,l0101h		;547a	21 01 01 	! . . 
	ld (0f298h),hl		;547d	22 98 f2 	" . . 
sub_5480h:
	call sub_5733h		;5480	cd 33 57 	. 3 W 
	call sub_526dh		;5483	cd 6d 52 	. m R 
l5486h:
	ld hl,(0f294h)		;5486	2a 94 f2 	* . . 
	ld bc,l0800h		;5489	01 00 08 	. . . 
	call sub_5986h		;548c	cd 86 59 	. . Y 
	xor a			;548f	af 	. 
	jp sub_5362h		;5490	c3 62 53 	. b S 
	ld hl,0f298h		;5493	21 98 f2 	! . . 
	ld (hl),001h		;5496	36 01 	6 . 
	ld a,(0f2a6h)		;5498	3a a6 f2 	: . . 
	or a			;549b	b7 	. 
	jr z,l54a0h		;549c	28 02 	( . 
	inc hl			;549e	23 	# 
	dec (hl)			;549f	35 	5 
l54a0h:
	xor a			;54a0	af 	. 
	ld (0f2a6h),a		;54a1	32 a6 f2 	2 . . 
	jp l5467h		;54a4	c3 67 54 	. g T 
l54a7h:
	ld hl,0f29dh		;54a7	21 9d f2 	! . . 
	ld a,(hl)			;54aa	7e 	~ 
	dec a			;54ab	3d 	= 
	ret z			;54ac	c8 	. 
	cp 008h		;54ad	fe 08 	. . 
	jr c,l54b9h		;54af	38 08 	8 . 
	sub 007h		;54b1	d6 07 	. . 
	ld (hl),a			;54b3	77 	w 
	call XREDSP		;54b4	cd 6e 53 	. n S 
	jr l54c3h		;54b7	18 0a 	. . 
l54b9h:
	neg		;54b9	ed 44 	. D 
	ld c,a			;54bb	4f 	O 
	ld b,000h		;54bc	06 00 	. . 
	ld (hl),001h		;54be	36 01 	6 . 
l54c0h:
	call sub_5310h		;54c0	cd 10 53 	. . S 
l54c3h:
	jp l5179h		;54c3	c3 79 51 	. y Q 
l54c6h:
	ld de,0f29bh		;54c6	11 9b f2 	. . . 
	ld hl,0f29dh		;54c9	21 9d f2 	! . . 
	ld a,(de)			;54cc	1a 	. 
	sub (hl)			;54cd	96 	. 
	sub 007h		;54ce	d6 07 	. . 
	ret z			;54d0	c8 	. 
	cp 008h		;54d1	fe 08 	. . 
	jr c,l54dfh		;54d3	38 0a 	8 . 
	ld a,(hl)			;54d5	7e 	~ 
	add a,008h		;54d6	c6 08 	. . 
	ld (hl),a			;54d8	77 	w 
	call XREDSP		;54d9	cd 6e 53 	. n S 
	jp l5179h		;54dc	c3 79 51 	. y Q 
l54dfh:
	ld c,a			;54df	4f 	O 
	ld b,000h		;54e0	06 00 	. . 
	ld a,(de)			;54e2	1a 	. 
	sub 007h		;54e3	d6 07 	. . 
	ld (hl),a			;54e5	77 	w 
	jr l54c0h		;54e6	18 d8 	. . 
	ld hl,0f29ah		;54e8	21 9a f2 	! . . 
	ld de,0f299h		;54eb	11 99 f2 	. . . 
	push de			;54ee	d5 	. 
	ld a,(de)			;54ef	1a 	. 
	dec a			;54f0	3d 	= 
	ld b,a			;54f1	47 	G 
	ld c,(hl)			;54f2	4e 	N 
	call sub_59b0h		;54f3	cd b0 59 	. . Y 
	dec de			;54f6	1b 	. 
	ld a,(de)			;54f7	1a 	. 
	dec a			;54f8	3d 	= 
	call sub_59a3h		;54f9	cd a3 59 	. . Y 
	ex de,hl			;54fc	eb 	. 
	ld hl,(0f292h)		;54fd	2a 92 f2 	* . . 
	or a			;5500	b7 	. 
	sbc hl,de		;5501	ed 52 	. R 
	ld b,h			;5503	44 	D 
	ld c,l			;5504	4d 	M 
	call sub_51fah		;5505	cd fa 51 	. . Q 
	pop hl			;5508	e1 	. 
	call sub_5923h		;5509	cd 23 59 	. # Y 
	sub (hl)			;550c	96 	. 
	ret c			;550d	d8 	. 
	ld a,(0f29fh)		;550e	3a 9f f2 	: . . 
	inc a			;5511	3c 	< 
	jp z,l5486h		;5512	ca 86 54 	. . T 
	dec hl			;5515	2b 	+ 
	call sub_51ddh		;5516	cd dd 51 	. . Q 
	ld a,(0f29fh)		;5519	3a 9f f2 	: . . 
	cp 007h		;551c	fe 07 	. . 
	ret z			;551e	c8 	. 
	ld d,a			;551f	57 	W 
	ld e,000h		;5520	1e 00 	. . 
l5522h:
	inc d			;5522	14 	. 
	call sub_5038h		;5523	cd 38 50 	. 8 P 
	ld bc,l00ffh+1		;5526	01 00 01 	. . . 
	push de			;5529	d5 	. 
	call sub_5986h		;552a	cd 86 59 	. . Y 
	pop de			;552d	d1 	. 
	ld a,d			;552e	7a 	z 
	cp 007h		;552f	fe 07 	. . 
	ret z			;5531	c8 	. 
	jr l5522h		;5532	18 ee 	. . 
	ld a,001h		;5534	3e 01 	> . 
	ld (0f2aah),a		;5536	32 aa f2 	2 . . 
	ret			;5539	c9 	. 
l553ah:
	ld de,0f298h		;553a	11 98 f2 	. . . 
	ld hl,0f29ah		;553d	21 9a f2 	! . . 
	ld a,(de)			;5540	1a 	. 
	cp (hl)			;5541	be 	. 
	jr nz,l5550h		;5542	20 0c 	  . 
	inc hl			;5544	23 	# 
	inc de			;5545	13 	. 
	ld a,(de)			;5546	1a 	. 
	cp (hl)			;5547	be 	. 
	ret z			;5548	c8 	. 
	inc a			;5549	3c 	< 
	ld (de),a			;554a	12 	. 
	dec de			;554b	1b 	. 
	ld a,001h		;554c	3e 01 	> . 
	jr l5551h		;554e	18 01 	. . 
l5550h:
	inc a			;5550	3c 	< 
l5551h:
	ld (de),a			;5551	12 	. 
	ld a,001h		;5552	3e 01 	> . 
	jp l5467h		;5554	c3 67 54 	. g T 
	ld hl,0f298h		;5557	21 98 f2 	! . . 
	ld a,(hl)			;555a	7e 	~ 
	dec a			;555b	3d 	= 
	jr nz,l5567h		;555c	20 09 	  . 
	inc hl			;555e	23 	# 
	ld a,(hl)			;555f	7e 	~ 
	dec a			;5560	3d 	= 
	ret z			;5561	c8 	. 
	ld (hl),a			;5562	77 	w 
	dec hl			;5563	2b 	+ 
	ld a,(0f29ah)		;5564	3a 9a f2 	: . . 
l5567h:
	ld (hl),a			;5567	77 	w 
	ld a,0ffh		;5568	3e ff 	> . 
	jp l5467h		;556a	c3 67 54 	. g T 
	ld hl,0f299h		;556d	21 99 f2 	! . . 
	ld a,(hl)			;5570	7e 	~ 
	dec a			;5571	3d 	= 
	ret z			;5572	c8 	. 
	ld (hl),a			;5573	77 	w 
	jr l5581h		;5574	18 0b 	. . 
	ld de,0f299h		;5576	11 99 f2 	. . . 
	ld hl,0f29bh		;5579	21 9b f2 	! . . 
	ld a,(de)			;557c	1a 	. 
	cp (hl)			;557d	be 	. 
	ret z			;557e	c8 	. 
	inc a			;557f	3c 	< 
	ld (de),a			;5580	12 	. 
l5581h:
	xor a			;5581	af 	. 
	jp l5467h		;5582	c3 67 54 	. g T 
	ld hl,0f2ach		;5585	21 ac f2 	! . . 
	ld d,(hl)			;5588	56 	V 
	dec d			;5589	15 	. 
	ld a,d			;558a	7a 	z 
	cp 008h		;558b	fe 08 	. . 
	ret nc			;558d	d0 	. 
	inc hl			;558e	23 	# 
	ld e,(hl)			;558f	5e 	^ 
	dec e			;5590	1d 	. 
	ld a,e			;5591	7b 	{ 
	cp 028h		;5592	fe 28 	. ( 
	ret nc			;5594	d0 	. 
	inc hl			;5595	23 	# 
	ld b,(hl)			;5596	46 	F 
l5597h:
	ld a,b			;5597	78 	x 
	or c			;5598	b1 	. 
	ret z			;5599	c8 	. 
	call sub_5038h		;559a	cd 38 50 	. 8 P 
	push bc			;559d	c5 	. 
	ld c,a			;559e	4f 	O 
	call l511fh		;559f	cd 1f 51 	. . Q 
	pop bc			;55a2	c1 	. 
	dec bc			;55a3	0b 	. 
	inc e			;55a4	1c 	. 
	ld a,e			;55a5	7b 	{ 
	cp 028h		;55a6	fe 28 	. ( 
	jr c,l5597h		;55a8	38 ed 	8 . 
	ld e,000h		;55aa	1e 00 	. . 
	inc d			;55ac	14 	. 
	ld a,d			;55ad	7a 	z 
	cp 008h		;55ae	fe 08 	. . 
	jr c,l5597h		;55b0	38 e5 	8 . 
	ret			;55b2	c9 	. 
	ld hl,0f297h		;55b3	21 97 f2 	! . . 
	set 0,(hl)		;55b6	cb c6 	. . 
	ret			;55b8	c9 	. 
	ld hl,0f297h		;55b9	21 97 f2 	! . . 
	res 0,(hl)		;55bc	cb 86 	. . 
	ret			;55be	c9 	. 
	ld hl,0f296h		;55bf	21 96 f2 	! . . 
	set 7,(hl)		;55c2	cb fe 	. . 
	ret			;55c4	c9 	. 
	ld hl,0f296h		;55c5	21 96 f2 	! . . 
	res 7,(hl)		;55c8	cb be 	. . 
	ret			;55ca	c9 	. 
l55cbh:
	ld hl,0f29ah		;55cb	21 9a f2 	! . . 
	ld a,c			;55ce	79 	y 
	sub 01fh		;55cf	d6 1f 	. . 
	ld e,a			;55d1	5f 	_ 
	dec a			;55d2	3d 	= 
	ret m			;55d3	f8 	. 
	cp (hl)			;55d4	be 	. 
	ret nc			;55d5	d0 	. 
	ld a,(0f2ach)		;55d6	3a ac f2 	: . . 
	sub 01fh		;55d9	d6 1f 	. . 
	ld d,a			;55db	57 	W 
	dec a			;55dc	3d 	= 
	ret m			;55dd	f8 	. 
	inc hl			;55de	23 	# 
	cp (hl)			;55df	be 	. 
	ret nc			;55e0	d0 	. 
	ld (0f298h),de		;55e1	ed 53 98 f2 	. S . . 
l55e5h:
	xor a			;55e5	af 	. 
	scf			;55e6	37 	7 
	jp l5468h		;55e7	c3 68 54 	. h T 
l55eah:
	ld a,c			;55ea	79 	y 
	ld b,0fch		;55eb	06 fc 	. . 
	ld b,009h		;55ed	06 09 	. . 
	ld hl,l5604h		;55ef	21 04 56 	! . V 
l55f2h:
	cp (hl)			;55f2	be 	. 
	jr z,l55f9h		;55f3	28 04 	( . 
	inc hl			;55f5	23 	# 
	djnz l55f2h		;55f6	10 fa 	. . 
	ret			;55f8	c9 	. 
l55f9h:
	ld a,b			;55f9	78 	x 
	dec b			;55fa	05 	. 
	jr nz,l55feh		;55fb	20 01 	  . 
	dec a			;55fd	3d 	= 
l55feh:
	add a,006h		;55fe	c6 06 	. . 
	ld (YLCOUNTRY),a		;5600	32 77 f7 	2 w . 
	ret			;5603	c9 	. 
l5604h:
	ld d,l			;5604	55 	U 
	ld b,(hl)			;5605	46 	F 
	ld b,a			;5606	47 	G 
	ld b,l			;5607	45 	E 
	ld b,h			;5608	44 	D 
	ld d,a			;5609	57 	W 
	ld c,c			;560a	49 	I 
	ld d,e			;560b	53 	S 
	ld c,(hl)			;560c	4e 	N 
	jp 03b92h		;560d	c3 92 3b 	. . ; 
	ld a,0afh		;5610	3e af 	> . 
	ld (0f2a2h),a		;5612	32 a2 f2 	2 . . 
	ret			;5615	c9 	. 
	call sub_5654h		;5616	cd 54 56 	. T V 
	ret c			;5619	d8 	. 
	push de			;561a	d5 	. 
	call sub_5677h		;561b	cd 77 56 	. w V 
	call sub_59c5h		;561e	cd c5 59 	. . Y 
	ex de,hl			;5621	eb 	. 
	ld a,(0f29ah)		;5622	3a 9a f2 	: . . 
	ld c,a			;5625	4f 	O 
	ld b,000h		;5626	06 00 	. . 
	call sub_51fdh		;5628	cd fd 51 	. . Q 
	pop de			;562b	d1 	. 
	call sub_5690h		;562c	cd 90 56 	. . V 
	ret c			;562f	d8 	. 
	jp l56b1h		;5630	c3 b1 56 	. . V 
	call sub_5654h		;5633	cd 54 56 	. T V 
	ret c			;5636	d8 	. 
	push de			;5637	d5 	. 
	call sub_5677h		;5638	cd 77 56 	. w V 
	ex de,hl			;563b	eb 	. 
	call sub_59c5h		;563c	cd c5 59 	. . Y 
	inc hl			;563f	23 	# 
	ld a,(0f29ah)		;5640	3a 9a f2 	: . . 
	ld c,a			;5643	4f 	O 
	ld b,000h		;5644	06 00 	. . 
	call sub_51fdh		;5646	cd fd 51 	. . Q 
	pop de			;5649	d1 	. 
	call sub_5690h		;564a	cd 90 56 	. . V 
	ret c			;564d	d8 	. 
	ld a,h			;564e	7c 	| 
	ld h,l			;564f	65 	e 
	ld l,a			;5650	6f 	o 
	jp l56b1h		;5651	c3 b1 56 	. . V 
sub_5654h:
	ld hl,l5675h		;5654	21 75 56 	! u V 
	push hl			;5657	e5 	. 
	ld hl,0f2ach		;5658	21 ac f2 	! . . 
	ld d,(hl)			;565b	56 	V 
	inc hl			;565c	23 	# 
	ld e,(hl)			;565d	5e 	^ 
	ld a,d			;565e	7a 	z 
	or a			;565f	b7 	. 
	ret m			;5660	f8 	. 
	ld hl,0f29bh		;5661	21 9b f2 	! . . 
	cp (hl)			;5664	be 	. 
	ret nc			;5665	d0 	. 
	inc d			;5666	14 	. 
	ld a,e			;5667	7b 	{ 
	dec a			;5668	3d 	= 
	ret m			;5669	f8 	. 
	cp (hl)			;566a	be 	. 
	ret nc			;566b	d0 	. 
	add a,d			;566c	82 	. 
	cp (hl)			;566d	be 	. 
	jr c,l5671h		;566e	38 01 	8 . 
	ld a,(hl)			;5670	7e 	~ 
l5671h:
	ld e,a			;5671	5f 	_ 
	pop hl			;5672	e1 	. 
	or a			;5673	b7 	. 
	ret			;5674	c9 	. 
l5675h:
	scf			;5675	37 	7 
	ret			;5676	c9 	. 
sub_5677h:
	push de			;5677	d5 	. 
	ld e,001h		;5678	1e 01 	. . 
	call sub_4fbeh		;567a	cd be 4f 	. . O 
	pop de			;567d	d1 	. 
	push hl			;567e	e5 	. 
	ld a,e			;567f	7b 	{ 
	sub d			;5680	92 	. 
	ld b,a			;5681	47 	G 
	ld a,(0f29ah)		;5682	3a 9a f2 	: . . 
	ld c,a			;5685	4f 	O 
	call sub_59a8h		;5686	cd a8 59 	. . Y 
	pop de			;5689	d1 	. 
	ld a,(0f29ah)		;568a	3a 9a f2 	: . . 
	jp sub_59a3h		;568d	c3 a3 59 	. . Y 
sub_5690h:
	ld hl,0f29dh		;5690	21 9d f2 	! . . 
	call sub_5923h		;5693	cd 23 59 	. # Y 
	cp d			;5696	ba 	. 
	ret c			;5697	d8 	. 
	ld a,e			;5698	7b 	{ 
	cp (hl)			;5699	be 	. 
	ret c			;569a	d8 	. 
	ld a,d			;569b	7a 	z 
	sub (hl)			;569c	96 	. 
	jr nc,l56a0h		;569d	30 01 	0 . 
	xor a			;569f	af 	. 
l56a0h:
	ld h,a			;56a0	67 	g 
	ld a,e			;56a1	7b 	{ 
	push hl			;56a2	e5 	. 
	ld hl,0f29dh		;56a3	21 9d f2 	! . . 
	sub (hl)			;56a6	96 	. 
	pop hl			;56a7	e1 	. 
	cp 008h		;56a8	fe 08 	. . 
	jr c,l56aeh		;56aa	38 02 	8 . 
	ld a,007h		;56ac	3e 07 	> . 
l56aeh:
	ld l,a			;56ae	6f 	o 
	or a			;56af	b7 	. 
	ret			;56b0	c9 	. 
l56b1h:
	ld a,h			;56b1	7c 	| 
	cp l			;56b2	bd 	. 
	jr z,l56d3h		;56b3	28 1e 	( . 
	ld b,h			;56b5	44 	D 
	dec h			;56b6	25 	% 
	jr nc,l56bbh		;56b7	30 02 	0 . 
	inc h			;56b9	24 	$ 
	inc h			;56ba	24 	$ 
l56bbh:
	ld c,h			;56bb	4c 	L 
	push hl			;56bc	e5 	. 
	ld d,b			;56bd	50 	P 
	ld e,000h		;56be	1e 00 	. . 
	call sub_5038h		;56c0	cd 38 50 	. 8 P 
	push hl			;56c3	e5 	. 
	ld d,c			;56c4	51 	Q 
	ld e,000h		;56c5	1e 00 	. . 
	call sub_5038h		;56c7	cd 38 50 	. 8 P 
	pop de			;56ca	d1 	. 
	ld bc,l00ffh+1		;56cb	01 00 01 	. . . 
	ldir		;56ce	ed b0 	. . 
	pop hl			;56d0	e1 	. 
	jr l56b1h		;56d1	18 de 	. . 
l56d3h:
	ld d,l			;56d3	55 	U 
	push de			;56d4	d5 	. 
	ld hl,0f29dh		;56d5	21 9d f2 	! . . 
	ld a,(hl)			;56d8	7e 	~ 
	add a,d			;56d9	82 	. 
	ld d,a			;56da	57 	W 
	dec hl			;56db	2b 	+ 
	ld e,(hl)			;56dc	5e 	^ 
	call sub_4fbeh		;56dd	cd be 4f 	. . O 
	pop de			;56e0	d1 	. 
	push hl			;56e1	e5 	. 
	ld e,000h		;56e2	1e 00 	. . 
	call sub_5038h		;56e4	cd 38 50 	. 8 P 
	pop de			;56e7	d1 	. 
	ld c,028h		;56e8	0e 28 	. ( 
	jp sub_5400h		;56ea	c3 00 54 	. . T 
sub_56edh:
	ld de,0f2a4h		;56ed	11 a4 f2 	. . . 
	ld hl,0f29ah		;56f0	21 9a f2 	! . . 
	call sub_591dh		;56f3	cd 1d 59 	. . Y 
	cp (hl)			;56f6	be 	. 
	ret z			;56f7	c8 	. 
	ex de,hl			;56f8	eb 	. 
	add a,(hl)			;56f9	86 	. 
	ex de,hl			;56fa	eb 	. 
	cp (hl)			;56fb	be 	. 
	jr nc,l5702h		;56fc	30 04 	0 . 
	ex de,hl			;56fe	eb 	. 
	ld b,(hl)			;56ff	46 	F 
	jr l5705h		;5700	18 03 	. . 
l5702h:
	ld a,(hl)			;5702	7e 	~ 
	ld b,014h		;5703	06 14 	. . 
l5705h:
	ld c,000h		;5705	0e 00 	. . 
	sub 027h		;5707	d6 27 	. ' 
	ld (0f29ch),a		;5709	32 9c f2 	2 . . 
l570ch:
	call sub_5310h		;570c	cd 10 53 	. . S 
	call sub_5733h		;570f	cd 33 57 	. 3 W 
	jp l5179h		;5712	c3 79 51 	. y Q 
sub_5715h:
	ld hl,0f2a4h		;5715	21 a4 f2 	! . . 
	ld de,0f29ch		;5718	11 9c f2 	. . . 
	ld a,(de)			;571b	1a 	. 
	cp 001h		;571c	fe 01 	. . 
	ret z			;571e	c8 	. 
	sub (hl)			;571f	96 	. 
	jr c,l5729h		;5720	38 07 	8 . 
	ld (de),a			;5722	12 	. 
	ld a,(hl)			;5723	7e 	~ 
	neg		;5724	ed 44 	. D 
	ld b,a			;5726	47 	G 
	jr l572eh		;5727	18 05 	. . 
l5729h:
	ld a,001h		;5729	3e 01 	> . 
	ld (de),a			;572b	12 	. 
	ld b,0ech		;572c	06 ec 	. . 
l572eh:
	ld c,000h		;572e	0e 00 	. . 
	jp l570ch		;5730	c3 0c 57 	. . W 
sub_5733h:
	ld a,(0f29ah)		;5733	3a 9a f2 	: . . 
	cp 028h		;5736	fe 28 	. ( 
	jr nz,l573dh		;5738	20 03 	  . 
	xor a			;573a	af 	. 
	jr l5762h		;573b	18 25 	. % 
l573dh:
	ld a,(0f2a4h)		;573d	3a a4 f2 	: . . 
	cp 028h		;5740	fe 28 	. ( 
	jr nz,l5751h		;5742	20 0d 	  . 
	ld a,(0f29ch)		;5744	3a 9c f2 	: . . 
	dec a			;5747	3d 	= 
	jr nz,l574dh		;5748	20 03 	  . 
	dec a			;574a	3d 	= 
	jr l5762h		;574b	18 15 	. . 
l574dh:
	ld a,0ffh		;574d	3e ff 	> . 
	jr l5762h		;574f	18 11 	. . 
l5751h:
	ld a,(0f29ch)		;5751	3a 9c f2 	: . . 
	cp 001h		;5754	fe 01 	. . 
	jr z,l5762h		;5756	28 0a 	( . 
	cp 015h		;5758	fe 15 	. . 
	jr z,l5760h		;575a	28 04 	( . 
	ld a,003h		;575c	3e 03 	> . 
	jr l5762h		;575e	18 02 	. . 
l5760h:
	ld a,002h		;5760	3e 02 	> . 
l5762h:
	ld (0f2a1h),a		;5762	32 a1 f2 	2 . . 
	ret			;5765	c9 	. 
	ld de,(0f2ach)		;5766	ed 5b ac f2 	. [ . . 
	ld a,e			;576a	7b 	{ 
	cp 014h		;576b	fe 14 	. . 
	jr z,l5772h		;576d	28 03 	( . 
	cp 028h		;576f	fe 28 	. ( 
	ret nz			;5771	c0 	. 
l5772h:
	ld a,d			;5772	7a 	z 
	cp 009h		;5773	fe 09 	. . 
	ret nc			;5775	d0 	. 
	or a			;5776	b7 	. 
	ret z			;5777	c8 	. 
	ld (0f2a4h),de		;5778	ed 53 a4 f2 	. S . . 
	ret			;577c	c9 	. 
l577dh:
	ld a,c			;577d	79 	y 
	cp 003h		;577e	fe 03 	. . 
	ret nc			;5780	d0 	. 
	ld (0f2a3h),a		;5781	32 a3 f2 	2 . . 
	ret			;5784	c9 	. 
sub_5785h:
	ld hl,0f2a5h		;5785	21 a5 f2 	! . . 
	ld de,0f29dh		;5788	11 9d f2 	. . . 
	ld a,(de)			;578b	1a 	. 
	cp 001h		;578c	fe 01 	. . 
	ret z			;578e	c8 	. 
	sub (hl)			;578f	96 	. 
	jp p,l579ah		;5790	f2 9a 57 	. . W 
	ld a,001h		;5793	3e 01 	> . 
	ld (de),a			;5795	12 	. 
	ex de,hl			;5796	eb 	. 
	sub (hl)			;5797	96 	. 
	jr l579eh		;5798	18 04 	. . 
l579ah:
	ld (de),a			;579a	12 	. 
	ld a,(hl)			;579b	7e 	~ 
	neg		;579c	ed 44 	. D 
l579eh:
	ld c,a			;579e	4f 	O 
	ld b,000h		;579f	06 00 	. . 
	jp l570ch		;57a1	c3 0c 57 	. . W 
sub_57a4h:
	ld de,0f2a5h		;57a4	11 a5 f2 	. . . 
	ld hl,0f29bh		;57a7	21 9b f2 	! . . 
	call sub_5923h		;57aa	cd 23 59 	. # Y 
	cp (hl)			;57ad	be 	. 
	ret z			;57ae	c8 	. 
	ex de,hl			;57af	eb 	. 
	add a,(hl)			;57b0	86 	. 
	ex de,hl			;57b1	eb 	. 
	cp (hl)			;57b2	be 	. 
	jr nc,l57b9h		;57b3	30 04 	0 . 
	ld b,a			;57b5	47 	G 
	ld a,(de)			;57b6	1a 	. 
	jr l57c0h		;57b7	18 07 	. . 
l57b9h:
	ld b,(hl)			;57b9	46 	F 
	ld hl,0f29dh		;57ba	21 9d f2 	! . . 
	sub (hl)			;57bd	96 	. 
	sub 007h		;57be	d6 07 	. . 
l57c0h:
	ld c,a			;57c0	4f 	O 
	ld a,b			;57c1	78 	x 
	sub 007h		;57c2	d6 07 	. . 
	ld (0f29dh),a		;57c4	32 9d f2 	2 . . 
	ld b,000h		;57c7	06 00 	. . 
	jp l570ch		;57c9	c3 0c 57 	. . W 
l57cch:
	ld a,c			;57cc	79 	y 
	cp 00bh		;57cd	fe 0b 	. . 
	ret nc			;57cf	d0 	. 
	ld hl,0f2dfh		;57d0	21 df f2 	! . . 
	ld (hl),a			;57d3	77 	w 
	inc hl			;57d4	23 	# 
	ld a,028h		;57d5	3e 28 	> ( 
	sub c			;57d7	91 	. 
	ld (hl),a			;57d8	77 	w 
	ret			;57d9	c9 	. 
	ld b,040h		;57da	06 40 	. @ 
	ld a,(01006h)		;57dc	3a 06 10 	: . . 
	ld a,(02006h)		;57df	3a 06 20 	: .   
	ld hl,0f006h		;57e2	21 06 f0 	! . . 
	ld a,(hl)			;57e5	7e 	~ 
	or b			;57e6	b0 	. 
l57e7h:
	ld (hl),a			;57e7	77 	w 
	out (019h),a		;57e8	d3 19 	. . 
	ret			;57ea	c9 	. 
	ld b,0bfh		;57eb	06 bf 	. . 
	ld a,(0ef06h)		;57ed	3a 06 ef 	: . . 
	ld a,(0df06h)		;57f0	3a 06 df 	: . . 
	ld hl,0f006h		;57f3	21 06 f0 	! . . 
	ld a,(hl)			;57f6	7e 	~ 
	and b			;57f7	a0 	. 
	jr l57e7h		;57f8	18 ed 	. . 
	ld a,0ffh		;57fa	3e ff 	> . 
l57fch:
	ld (YPFCMFLG),a		;57fc	32 17 f0 	2 . . 
	ret			;57ff	c9 	. 
	xor a			;5800	af 	. 
	jr l57fch		;5801	18 f9 	. . 
l5803h:
	ld a,(0f2deh)		;5803	3a de f2 	: . . 
	or a			;5806	b7 	. 
	ret z			;5807	c8 	. 
	ld a,(0f2ach)		;5808	3a ac f2 	: . . 
	cp 008h		;580b	fe 08 	. . 
	ret c			;580d	d8 	. 
	cp 033h		;580e	fe 33 	. 3 
	ret nc			;5810	d0 	. 
	ld b,a			;5811	47 	G 
	ld a,c			;5812	79 	y 
	cp 028h		;5813	fe 28 	. ( 
	jr z,l581ah		;5815	28 03 	( . 
	cp 050h		;5817	fe 50 	. P 
	ret nz			;5819	c0 	. 
l581ah:
	push bc			;581a	c5 	. 
	call sub_59b0h		;581b	cd b0 59 	. . Y 
	pop bc			;581e	c1 	. 
	ld de,l0800h+1		;581f	11 01 08 	. . . 
	call sub_59d9h		;5822	cd d9 59 	. . Y 
	ret nc			;5825	d0 	. 
	ld (0f29ah),bc		;5826	ed 43 9a f2 	. C . . 
	ld (0f292h),hl		;582a	22 92 f2 	" . . 
	ld hl,l0101h		;582d	21 01 01 	! . . 
	ld (0f29ch),hl		;5830	22 9c f2 	" . . 
	jp l546eh		;5833	c3 6e 54 	. n T 
	ld hl,0f2ach		;5836	21 ac f2 	! . . 
	ld a,(hl)			;5839	7e 	~ 
	dec a			;583a	3d 	= 
	ret m			;583b	f8 	. 
	ld d,a			;583c	57 	W 
	cp 008h		;583d	fe 08 	. . 
	ret nc			;583f	d0 	. 
	inc hl			;5840	23 	# 
	ld a,(hl)			;5841	7e 	~ 
	dec a			;5842	3d 	= 
	ret m			;5843	f8 	. 
	cp 028h		;5844	fe 28 	. ( 
	ret nc			;5846	d0 	. 
	ld e,a			;5847	5f 	_ 
	call sub_5996h		;5848	cd 96 59 	. . Y 
sub_584bh:
	call sub_4fd3h		;584b	cd d3 4f 	. . O 
	call sub_5038h		;584e	cd 38 50 	. 8 P 
	jp sub_5060h		;5851	c3 60 50 	. ` P 
	ld hl,0f29ch		;5854	21 9c f2 	! . . 
	ld a,(hl)			;5857	7e 	~ 
	dec a			;5858	3d 	= 
	jr nz,l585fh		;5859	20 04 	  . 
	inc hl			;585b	23 	# 
	ld a,(hl)			;585c	7e 	~ 
	dec a			;585d	3d 	= 
	ret z			;585e	c8 	. 
l585fh:
	ld de,l0101h		;585f	11 01 01 	. . . 
l5862h:
	ld (0f29ch),de		;5862	ed 53 9c f2 	. S . . 
	call sub_5733h		;5866	cd 33 57 	. 3 W 
	call l5179h		;5869	cd 79 51 	. y Q 
	jp XREDSP		;586c	c3 6e 53 	. n S 
	ld hl,0f29ah		;586f	21 9a f2 	! . . 
	call sub_591dh		;5872	cd 1d 59 	. . Y 
	cp (hl)			;5875	be 	. 
	inc hl			;5876	23 	# 
	jr nz,l587eh		;5877	20 05 	  . 
	call sub_5923h		;5879	cd 23 59 	. # Y 
	cp (hl)			;587c	be 	. 
	ret z			;587d	c8 	. 
l587eh:
	ld a,(hl)			;587e	7e 	~ 
	sub 007h		;587f	d6 07 	. . 
	ld d,a			;5881	57 	W 
	dec hl			;5882	2b 	+ 
	ld a,(hl)			;5883	7e 	~ 
	sub 027h		;5884	d6 27 	. ' 
	ld e,a			;5886	5f 	_ 
	jr l5862h		;5887	18 d9 	. . 
	ld a,c			;5889	79 	y 
	cp 004h		;588a	fe 04 	. . 
	ret nc			;588c	d0 	. 
	ld hl,0f296h		;588d	21 96 f2 	! . . 
	ld a,(hl)			;5890	7e 	~ 
	and 0fch		;5891	e6 fc 	. . 
	or c			;5893	b1 	. 
	ld (hl),a			;5894	77 	w 
	ret			;5895	c9 	. 
	ld a,(0f2a3h)		;5896	3a a3 f2 	: . . 
	push af			;5899	f5 	. 
	xor a			;589a	af 	. 
	ld (0f2a3h),a		;589b	32 a3 f2 	2 . . 
	call l55e5h		;589e	cd e5 55 	. . U 
	pop af			;58a1	f1 	. 
	ld (0f2a3h),a		;58a2	32 a3 f2 	2 . . 
	ret			;58a5	c9 	. 
	ld hl,0f2ach		;58a6	21 ac f2 	! . . 
	ld a,(hl)			;58a9	7e 	~ 
	sub 0e0h		;58aa	d6 e0 	. . 
	ret c			;58ac	d8 	. 
	add a,a			;58ad	87 	. 
	ld b,a			;58ae	47 	G 
	add a,a			;58af	87 	. 
	add a,b			;58b0	80 	. 
	ld hl,0e940h		;58b1	21 40 e9 	! @ . 
	call sub_59a3h		;58b4	cd a3 59 	. . Y 
	ex de,hl			;58b7	eb 	. 
	push de			;58b8	d5 	. 
	ld c,002h		;58b9	0e 02 	. . 
	call sub_58c1h		;58bb	cd c1 58 	. . X 
	pop de			;58be	d1 	. 
	ld c,006h		;58bf	0e 06 	. . 
sub_58c1h:
	ld hl,0f2adh		;58c1	21 ad f2 	! . . 
	ld b,008h		;58c4	06 08 	. . 
	push bc			;58c6	c5 	. 
l58c7h:
	ld c,(hl)			;58c7	4e 	N 
	rlc c		;58c8	cb 01 	. . 
	ld (hl),c			;58ca	71 	q 
	rra			;58cb	1f 	. 
	inc hl			;58cc	23 	# 
	djnz l58c7h		;58cd	10 f8 	. . 
	pop bc			;58cf	c1 	. 
	ld (de),a			;58d0	12 	. 
	inc de			;58d1	13 	. 
	dec c			;58d2	0d 	. 
	ret z			;58d3	c8 	. 
	jr sub_58c1h		;58d4	18 eb 	. . 
l58d6h:
	ld de,l1501h		;58d6	11 01 15 	. . . 
	ld a,c			;58d9	79 	y 
	or a			;58da	b7 	. 
	jr z,l58e0h		;58db	28 03 	( . 
	ld de,l0501h		;58dd	11 01 05 	. . . 
l58e0h:
	jp l5969h		;58e0	c3 69 59 	. i Y 
l58e3h:
	ld de,l0402h		;58e3	11 02 04 	. . . 
l58e6h:
	ld a,c			;58e6	79 	y 
	cp 080h		;58e7	fe 80 	. . 
	call c,l5969h		;58e9	dc 69 59 	. i Y 
	ret			;58ec	c9 	. 
	ld de,01402h		;58ed	11 02 14 	. . . 
	jr l58e6h		;58f0	18 f4 	. . 
	ld de,0f328h		;58f2	11 28 f3 	. ( . 
l58f5h:
	ld hl,0f2ach		;58f5	21 ac f2 	! . . 
	ld bc,l0003h+1		;58f8	01 04 00 	. . . 
	ldir		;58fb	ed b0 	. . 
	ret			;58fd	c9 	. 
	ld de,0f32ch		;58fe	11 2c f3 	. , . 
	jr l58f5h		;5901	18 f2 	. . 
	ld de,0f331h		;5903	11 31 f3 	. 1 . 
	jr l58f5h		;5906	18 ed 	. . 
sub_5908h:
	ld hl,0f860h		;5908	21 60 f8 	! ` . 
	ld (0f00bh),hl		;590b	22 0b f0 	" . . 
	ld (0f00dh),hl		;590e	22 0d f0 	" . . 
	ld c,021h		;5911	0e 21 	. ! 
	jp sub_5984h		;5913	c3 84 59 	. . Y 
l5916h:
	ld a,c			;5916	79 	y 
	ld (0f00fh),a		;5917	32 0f f0 	2 . . 
	jp l3daah		;591a	c3 aa 3d 	. . = 
sub_591dh:
	ld a,(0f29ch)		;591d	3a 9c f2 	: . . 
	add a,027h		;5920	c6 27 	. ' 
	ret			;5922	c9 	. 
sub_5923h:
	ld a,(0f29dh)		;5923	3a 9d f2 	: . . 
	add a,007h		;5926	c6 07 	. . 
	ret			;5928	c9 	. 
XSETSCRN:
	ld a,(0f2deh)		;5929	3a de f2 	: . . 
	or a			;592c	b7 	. 
	ret z			;592d	c8 	. 
	xor a			;592e	af 	. 
	jr l5937h		;592f	18 06 	. . 
XUSRSCRN:
	ld a,(0f2deh)		;5931	3a de f2 	: . . 
	or a			;5934	b7 	. 
	ret nz			;5935	c0 	. 
	inc a			;5936	3c 	< 
l5937h:
	push af			;5937	f5 	. 
	call sub_5a10h		;5938	cd 10 5a 	. . Z 
	pop af			;593b	f1 	. 
	ld (0f2deh),a		;593c	32 de f2 	2 . . 
	call sub_5953h		;593f	cd 53 59 	. S Y 
	xor a			;5942	af 	. 
	out (009h),a		;5943	d3 09 	. . 
	ld a,(0f295h)		;5945	3a 95 f2 	: . . 
	out (008h),a		;5948	d3 08 	. . 
	ld a,(0f2a0h)		;594a	3a a0 f2 	: . . 
	call sub_5362h		;594d	cd 62 53 	. b S 
	jp sub_59f9h		;5950	c3 f9 59 	. . Y 
sub_5953h:
	ld hl,0f2b7h		;5953	21 b7 f2 	! . . 
	ld de,0f290h		;5956	11 90 f2 	. . . 
	push hl			;5959	e5 	. 
	xor a			;595a	af 	. 
	sbc hl,de		;595b	ed 52 	. R 
	ld b,l			;595d	45 	E 
	pop hl			;595e	e1 	. 
l595fh:
	ld c,(hl)			;595f	4e 	N 
	ld a,(de)			;5960	1a 	. 
	ld (hl),a			;5961	77 	w 
	ld a,c			;5962	79 	y 
	ld (de),a			;5963	12 	. 
	inc hl			;5964	23 	# 
	inc de			;5965	13 	. 
	djnz l595fh		;5966	10 f7 	. . 
	ret			;5968	c9 	. 
l5969h:
	ld a,(0f53eh)		;5969	3a 3e f5 	: > . 
l596ch:
	push af			;596c	f5 	. 
	res 0,a		;596d	cb 87 	. . 
	out (004h),a		;596f	d3 04 	. . 
l5971h:
	push bc			;5971	c5 	. 
	ld c,d			;5972	4a 	J 
	call WRT7508		;5973	cd 61 3c 	. a < 
	pop bc			;5976	c1 	. 
	dec e			;5977	1d 	. 
	jr z,l5980h		;5978	28 06 	( . 
	ld a,c			;597a	79 	y 
	or 080h		;597b	f6 80 	. . 
	ld d,a			;597d	57 	W 
	jr l5971h		;597e	18 f1 	. . 
l5980h:
	pop af			;5980	f1 	. 
	out (004h),a		;5981	d3 04 	. . 
	ret			;5983	c9 	. 
sub_5984h:
	ld b,000h		;5984	06 00 	. . 
sub_5986h:
	xor a			;5986	af 	. 
	jr sub_598bh		;5987	18 02 	. . 
	ld b,000h		;5989	06 00 	. . 
sub_598bh:
	ld d,h			;598b	54 	T 
	ld e,l			;598c	5d 	] 
	inc de			;598d	13 	. 
	dec bc			;598e	0b 	. 
	ld (hl),a			;598f	77 	w 
	ld a,b			;5990	78 	x 
	or c			;5991	b1 	. 
	ret z			;5992	c8 	. 
	ldir		;5993	ed b0 	. . 
	ret			;5995	c9 	. 
sub_5996h:
	ld a,c			;5996	79 	y 
	cp 0e0h		;5997	fe e0 	. . 
	ret nc			;5999	d0 	. 
	cp 0a0h		;599a	fe a0 	. . 
	ccf			;599c	3f 	? 
	ret nc			;599d	d0 	. 
	ld c,020h		;599e	0e 20 	.   
	ret			;59a0	c9 	. 
sub_59a1h:
	ld a,020h		;59a1	3e 20 	>   
sub_59a3h:
	add a,l			;59a3	85 	. 
	ld l,a			;59a4	6f 	o 
	ret nc			;59a5	d0 	. 
	inc h			;59a6	24 	$ 
	ret			;59a7	c9 	. 
sub_59a8h:
	push hl			;59a8	e5 	. 
	call sub_59b0h		;59a9	cd b0 59 	. . Y 
	ld b,h			;59ac	44 	D 
	ld c,l			;59ad	4d 	M 
	pop hl			;59ae	e1 	. 
	ret			;59af	c9 	. 
sub_59b0h:
	ld a,b			;59b0	78 	x 
	cp c			;59b1	b9 	. 
	jr c,l59b6h		;59b2	38 02 	8 . 
	ld b,c			;59b4	41 	A 
	ld c,a			;59b5	4f 	O 
l59b6h:
	ld hl,COLDRST		;59b6	21 00 00 	! . . 
	ld a,b			;59b9	78 	x 
	or a			;59ba	b7 	. 
	ret z			;59bb	c8 	. 
l59bch:
	ld a,c			;59bc	79 	y 
	add a,l			;59bd	85 	. 
	ld l,a			;59be	6f 	o 
	jr nc,l59c2h		;59bf	30 01 	0 . 
	inc h			;59c1	24 	$ 
l59c2h:
	djnz l59bch		;59c2	10 f8 	. . 
	ret			;59c4	c9 	. 
sub_59c5h:
	ld a,b			;59c5	78 	x 
	or c			;59c6	b1 	. 
	ret z			;59c7	c8 	. 
	call sub_59d9h		;59c8	cd d9 59 	. . Y 
	jr c,l59d0h		;59cb	38 03 	8 . 
	ldir		;59cd	ed b0 	. . 
	ret			;59cf	c9 	. 
l59d0h:
	ex de,hl			;59d0	eb 	. 
	add hl,bc			;59d1	09 	. 
	dec hl			;59d2	2b 	+ 
	ex de,hl			;59d3	eb 	. 
	add hl,bc			;59d4	09 	. 
	dec hl			;59d5	2b 	+ 
	lddr		;59d6	ed b8 	. . 
	ret			;59d8	c9 	. 
sub_59d9h:
	ld a,h			;59d9	7c 	| 
	cp d			;59da	ba 	. 
	ret nz			;59db	c0 	. 
	ld a,l			;59dc	7d 	} 
	cp e			;59dd	bb 	. 
	ret			;59de	c9 	. 
l59dfh:
	ld a,(0efb7h)		;59df	3a b7 ef 	: . . 
	or a			;59e2	b7 	. 
	ret z			;59e3	c8 	. 
	ld hl,0efb8h		;59e4	21 b8 ef 	! . . 
	inc (hl)			;59e7	34 	4 
	ld a,(0efbah)		;59e8	3a ba ef 	: . . 
	sub (hl)			;59eb	96 	. 
	ret nc			;59ec	d0 	. 
	ld (hl),a			;59ed	77 	w 
	call sub_5a1dh		;59ee	cd 1d 5a 	. . Z 
	ld hl,0efb9h		;59f1	21 b9 ef 	! . . 
	ld a,(hl)			;59f4	7e 	~ 
	xor 0ffh		;59f5	ee ff 	. . 
	ld (hl),a			;59f7	77 	w 
	ret			;59f8	c9 	. 
sub_59f9h:
	xor a			;59f9	af 	. 
	ld (0efb7h),a		;59fa	32 b7 ef 	2 . . 
	call sub_514ch		;59fd	cd 4c 51 	. L Q 
	ret c			;5a00	d8 	. 
	ld a,(0f296h)		;5a01	3a 96 f2 	: . . 
	and 081h		;5a04	e6 81 	. . 
	ret nz			;5a06	c0 	. 
	xor a			;5a07	af 	. 
	ld (0efb9h),a		;5a08	32 b9 ef 	2 . . 
	inc a			;5a0b	3c 	< 
	ld (0efb7h),a		;5a0c	32 b7 ef 	2 . . 
	ret			;5a0f	c9 	. 
sub_5a10h:
	xor a			;5a10	af 	. 
	ld (0efb7h),a		;5a11	32 b7 ef 	2 . . 
	ld a,(0efb9h)		;5a14	3a b9 ef 	: . . 
	or a			;5a17	b7 	. 
	ret z			;5a18	c8 	. 
	xor a			;5a19	af 	. 
	ld (0efb9h),a		;5a1a	32 b9 ef 	2 . . 
sub_5a1dh:
	push hl			;5a1d	e5 	. 
	push de			;5a1e	d5 	. 
	push bc			;5a1f	c5 	. 
	call sub_50e7h		;5a20	cd e7 50 	. . P 
	pop bc			;5a23	c1 	. 
	pop de			;5a24	d1 	. 
	pop hl			;5a25	e1 	. 
	ret			;5a26	c9 	. 
l5a27h:
	push hl			;5a27	e5 	. 
	ld hl,(0f29ah)		;5a28	2a 9a f2 	* . . 
	ld a,b			;5a2b	78 	x 
	or a			;5a2c	b7 	. 
	jr z,l5a95h		;5a2d	28 66 	( f 
	dec a			;5a2f	3d 	= 
	cp l			;5a30	bd 	. 
	jr nc,l5a95h		;5a31	30 62 	0 b 
	ld a,c			;5a33	79 	y 
	or a			;5a34	b7 	. 
	jr z,l5a95h		;5a35	28 5e 	( ^ 
	dec a			;5a37	3d 	= 
	cp h			;5a38	bc 	. 
	jr nc,l5a95h		;5a39	30 5a 	0 Z 
	push de			;5a3b	d5 	. 
	ld d,c			;5a3c	51 	Q 
	ld e,b			;5a3d	58 	X 
	call sub_4fbeh		;5a3e	cd be 4f 	. . O 
	pop de			;5a41	d1 	. 
	ex (sp),hl			;5a42	e3 	. 
	push hl			;5a43	e5 	. 
	call sub_59a8h		;5a44	cd a8 59 	. . Y 
	dec bc			;5a47	0b 	. 
	ld hl,(0f292h)		;5a48	2a 92 f2 	* . . 
	or a			;5a4b	b7 	. 
	sbc hl,bc		;5a4c	ed 42 	. B 
	ex de,hl			;5a4e	eb 	. 
	call sub_59d9h		;5a4f	cd d9 59 	. . Y 
	jr c,l5a58h		;5a52	38 04 	8 . 
	sbc hl,de		;5a54	ed 52 	. R 
	jr l5a5ch		;5a56	18 04 	. . 
l5a58h:
	ex de,hl			;5a58	eb 	. 
	ld hl,COLDRST		;5a59	21 00 00 	! . . 
l5a5ch:
	ld b,d			;5a5c	42 	B 
	ld c,e			;5a5d	4b 	K 
	pop de			;5a5e	d1 	. 
	ex (sp),hl			;5a5f	e3 	. 
	ex de,hl			;5a60	eb 	. 
l5a61h:
	ld a,b			;5a61	78 	x 
	or c			;5a62	b1 	. 
	jr z,l5a84h		;5a63	28 1f 	( . 
	ld a,(de)			;5a65	1a 	. 
	push bc			;5a66	c5 	. 
	push de			;5a67	d5 	. 
	push hl			;5a68	e5 	. 
	ld c,a			;5a69	4f 	O 
	call sub_5aadh		;5a6a	cd ad 5a 	. . Z 
	call nc,sub_5a99h		;5a6d	d4 99 5a 	. . Z 
	jr c,l5a78h		;5a70	38 06 	8 . 
	ld b,000h		;5a72	06 00 	. . 
	ld c,a			;5a74	4f 	O 
	sbc hl,bc		;5a75	ed 42 	. B 
	ld c,(hl)			;5a77	4e 	N 
l5a78h:
	ld a,c			;5a78	79 	y 
	pop hl			;5a79	e1 	. 
	pop de			;5a7a	d1 	. 
	pop bc			;5a7b	c1 	. 
	call 0ec76h		;5a7c	cd 76 ec 	. v . 
	inc hl			;5a7f	23 	# 
	inc de			;5a80	13 	. 
	dec bc			;5a81	0b 	. 
	jr l5a61h		;5a82	18 dd 	. . 
l5a84h:
	pop bc			;5a84	c1 	. 
	ld a,b			;5a85	78 	x 
	or c			;5a86	b1 	. 
	ret z			;5a87	c8 	. 
l5a88h:
	ld a,020h		;5a88	3e 20 	>   
	call 0ec76h		;5a8a	cd 76 ec 	. v . 
	inc hl			;5a8d	23 	# 
	dec bc			;5a8e	0b 	. 
	ld a,b			;5a8f	78 	x 
	or c			;5a90	b1 	. 
	jr nz,l5a88h		;5a91	20 f5 	  . 
	inc a			;5a93	3c 	< 
	ret			;5a94	c9 	. 
l5a95h:
	pop hl			;5a95	e1 	. 
	ld a,0ffh		;5a96	3e ff 	> . 
	ret			;5a98	c9 	. 
sub_5a99h:
	ld hl,l4f06h		;5a99	21 06 4f 	! . O 
	call sub_59a3h		;5a9c	cd a3 59 	. . Y 
	ld de,l0009h		;5a9f	11 09 00 	. . . 
	ld a,c			;5aa2	79 	y 
	ld b,00ch		;5aa3	06 0c 	. . 
l5aa5h:
	cp (hl)			;5aa5	be 	. 
	jr z,sub_5aadh		;5aa6	28 05 	( . 
	add hl,de			;5aa8	19 	. 
	djnz l5aa5h		;5aa9	10 fa 	. . 
	scf			;5aab	37 	7 
	ret			;5aac	c9 	. 
sub_5aadh:
	ld a,(YLCOUNTRY)		;5aad	3a 77 f7 	: w . 
	sub 006h		;5ab0	d6 06 	. . 
	ret c			;5ab2	d8 	. 
	jr z,l5ab8h		;5ab3	28 03 	( . 
	dec a			;5ab5	3d 	= 
	scf			;5ab6	37 	7 
	ret z			;5ab7	c8 	. 
l5ab8h:
	dec a			;5ab8	3d 	= 
	and 00fh		;5ab9	e6 0f 	. . 
	xor 007h		;5abb	ee 07 	. . 
	ret			;5abd	c9 	. 
l5abeh:
	inc h			;5abe	24 	$ 
	ld d,l			;5abf	55 	U 
	ld d,(hl)			;5ac0	56 	V 
	ld d,h			;5ac1	54 	T 
	ld a,b			;5ac2	78 	x 
	ld (bc),a			;5ac3	02 	. 
	dec b			;5ac4	05 	. 
	dec b			;5ac5	05 	. 
	ld (bc),a			;5ac6	02 	. 
	nop			;5ac7	00 	. 
	inc c			;5ac8	0c 	. 
	ld d,d			;5ac9	52 	R 
	ld d,d			;5aca	52 	R 
	ld (l0a12h),a		;5acb	32 12 0a 	2 . . 
	ld d,l			;5ace	55 	U 
	ld d,l			;5acf	55 	U 
	ld d,l			;5ad0	55 	U 
	jr z,l5b0bh		;5ad1	28 38 	( 8 
	ld d,h			;5ad3	54 	T 
	ld d,(hl)			;5ad4	56 	V 
	ld d,l			;5ad5	55 	U 
	ld e,b			;5ad6	58 	X 
	inc a			;5ad7	3c 	< 
	ld b,c			;5ad8	41 	A 
	ld b,d			;5ad9	42 	B 
	ld b,b			;5ada	40 	@ 
	ld a,h			;5adb	7c 	| 
	jr c,l5b33h		;5adc	38 55 	8 U 
	ld d,(hl)			;5ade	56 	V 
	ld d,h			;5adf	54 	T 
	ld e,b			;5ae0	58 	X 
	nop			;5ae1	00 	. 
	ld bc,l00ffh+1		;5ae2	01 00 01 	. . . 
	nop			;5ae5	00 	. 
	ld (hl),b			;5ae6	70 	p 
	add hl,hl			;5ae7	29 	) 
	inc h			;5ae8	24 	$ 
	add hl,hl			;5ae9	29 	) 
	ld (hl),b			;5aea	70 	p 
	jr c,l5b32h		;5aeb	38 45 	8 E 
	ld b,h			;5aed	44 	D 
	ld b,l			;5aee	45 	E 
	jr c,l5b2dh		;5aef	38 3c 	8 < 
	ld b,c			;5af1	41 	A 
	ld b,b			;5af2	40 	@ 
	ld b,c			;5af3	41 	A 
	inc a			;5af4	3c 	< 
	inc h			;5af5	24 	$ 
	ld d,l			;5af6	55 	U 
	ld d,h			;5af7	54 	T 
	ld d,l			;5af8	55 	U 
	ld a,b			;5af9	78 	x 
	jr nc,l5b45h		;5afa	30 49 	0 I 
	ld c,b			;5afc	48 	H 
	ld c,c			;5afd	49 	I 
	jr nc,l5b38h		;5afe	30 38 	0 8 
	ld b,c			;5b00	41 	A 
	ld b,b			;5b01	40 	@ 
	ld b,c			;5b02	41 	A 
	ld a,b			;5b03	78 	x 
	ld a,(hl)			;5b04	7e 	~ 
	ld bc,03649h		;5b05	01 49 36 	. I 6 
	nop			;5b08	00 	. 
	ld c,b			;5b09	48 	H 
	ld a,(hl)			;5b0a	7e 	~ 
l5b0bh:
	ld c,c			;5b0b	49 	I 
	ld b,c			;5b0c	41 	A 
	ld b,d			;5b0d	42 	B 
	ld a,(hl)			;5b0e	7e 	~ 
	add hl,bc			;5b0f	09 	. 
	ld a,(hl)			;5b10	7e 	~ 
	ld c,c			;5b11	49 	I 
	ld b,c			;5b12	41 	A 
	ld e,h			;5b13	5c 	\ 
	ld (l262ah),a		;5b14	32 2a 26 	2 * & 
	dec e			;5b17	1d 	. 
	ld (hl),b			;5b18	70 	p 
	ld hl,(l2a25h)		;5b19	2a 25 2a 	* % * 
	ld (hl),b			;5b1c	70 	p 
	inc h			;5b1d	24 	$ 
	ld d,h			;5b1e	54 	T 
	ld a,b			;5b1f	78 	x 
	ld d,h			;5b20	54 	T 
	ld e,b			;5b21	58 	X 
	jr l5b88h		;5b22	18 64 	. d 
	inc a			;5b24	3c 	< 
	ld h,018h		;5b25	26 18 	& . 
	inc h			;5b27	24 	$ 
	ld d,h			;5b28	54 	T 
	ld d,l			;5b29	55 	U 
	ld d,h			;5b2a	54 	T 
	ld a,b			;5b2b	78 	x 
	ld a,h			;5b2c	7c 	| 
l5b2dh:
	ld d,h			;5b2d	54 	T 
	ld d,(hl)			;5b2e	56 	V 
	ld d,l			;5b2f	55 	U 
	ld b,h			;5b30	44 	D 
	inc h			;5b31	24 	$ 
l5b32h:
	ld d,(hl)			;5b32	56 	V 
l5b33h:
	ld d,l			;5b33	55 	U 
	ld d,(hl)			;5b34	56 	V 
	ld a,b			;5b35	78 	x 
	ld e,d			;5b36	5a 	Z 
	inc h			;5b37	24 	$ 
l5b38h:
	inc h			;5b38	24 	$ 
	inc h			;5b39	24 	$ 
	ld e,d			;5b3a	5a 	Z 
	jr nc,l5b86h		;5b3b	30 49 	0 I 
	ld c,d			;5b3d	4a 	J 
	ld c,b			;5b3e	48 	H 
	jr nc,l5b41h		;5b3f	30 00 	0 . 
l5b41h:
	ld c,c			;5b41	49 	I 
	ld a,d			;5b42	7a 	z 
	ld b,b			;5b43	40 	@ 
	nop			;5b44	00 	. 
l5b45h:
	ld a,a			;5b45	7f 	 
	dec b			;5b46	05 	. 
	dec d			;5b47	15 	. 
	ld a,d			;5b48	7a 	z 
	ld d,b			;5b49	50 	P 
	nop			;5b4a	00 	. 
	nop			;5b4b	00 	. 
	ld a,c			;5b4c	79 	y 
	nop			;5b4d	00 	. 
	nop			;5b4e	00 	. 
	ld a,d			;5b4f	7a 	z 
	add hl,bc			;5b50	09 	. 
	ld (de),a			;5b51	12 	. 
	ld (03079h),hl		;5b52	22 79 30 	" y 0 
	ld c,b			;5b55	48 	H 
	ld b,l			;5b56	45 	E 
	ld b,b			;5b57	40 	@ 
	jr nz,l5bd4h		;5b58	20 7a 	  z 
	add hl,bc			;5b5a	09 	. 
	ld a,(bc)			;5b5b	0a 	. 
	ld a,(bc)			;5b5c	0a 	. 
	ld (hl),c			;5b5d	71 	q 
	nop			;5b5e	00 	. 
	nop			;5b5f	00 	. 
	nop			;5b60	00 	. 
	nop			;5b61	00 	. 
	nop			;5b62	00 	. 
	nop			;5b63	00 	. 
	nop			;5b64	00 	. 
	ld c,a			;5b65	4f 	O 
	nop			;5b66	00 	. 
	nop			;5b67	00 	. 
	nop			;5b68	00 	. 
	rlca			;5b69	07 	. 
	nop			;5b6a	00 	. 
	rlca			;5b6b	07 	. 
	nop			;5b6c	00 	. 
	inc d			;5b6d	14 	. 
	ld a,a			;5b6e	7f 	 
	inc d			;5b6f	14 	. 
	ld a,a			;5b70	7f 	 
	inc d			;5b71	14 	. 
	inc h			;5b72	24 	$ 
	ld hl,(02a7fh)		;5b73	2a 7f 2a 	*  * 
	ld (de),a			;5b76	12 	. 
	inc hl			;5b77	23 	# 
	inc de			;5b78	13 	. 
	ex af,af'			;5b79	08 	. 
	ld h,h			;5b7a	64 	d 
	ld h,d			;5b7b	62 	b 
	ld (hl),049h		;5b7c	36 49 	6 I 
	ld d,l			;5b7e	55 	U 
	ld (00050h),hl		;5b7f	22 50 00 	" P . 
	dec b			;5b82	05 	. 
	inc bc			;5b83	03 	. 
	nop			;5b84	00 	. 
	nop			;5b85	00 	. 
l5b86h:
	nop			;5b86	00 	. 
	inc e			;5b87	1c 	. 
l5b88h:
	ld (00041h),hl		;5b88	22 41 00 	" A . 
	nop			;5b8b	00 	. 
	ld b,c			;5b8c	41 	A 
	ld (l001bh+1),hl		;5b8d	22 1c 00 	" . . 
	ld (de),a			;5b90	12 	. 
	inc c			;5b91	0c 	. 
	ccf			;5b92	3f 	? 
	inc c			;5b93	0c 	. 
	ld (de),a			;5b94	12 	. 
	ex af,af'			;5b95	08 	. 
	ex af,af'			;5b96	08 	. 
	ld a,008h		;5b97	3e 08 	> . 
	ex af,af'			;5b99	08 	. 
	nop			;5b9a	00 	. 
	ld d,b			;5b9b	50 	P 
	jr nc,l5b9eh		;5b9c	30 00 	0 . 
l5b9eh:
	nop			;5b9e	00 	. 
	ex af,af'			;5b9f	08 	. 
	ex af,af'			;5ba0	08 	. 
	ex af,af'			;5ba1	08 	. 
	ex af,af'			;5ba2	08 	. 
	ex af,af'			;5ba3	08 	. 
	nop			;5ba4	00 	. 
	ld h,b			;5ba5	60 	` 
	ld h,b			;5ba6	60 	` 
	nop			;5ba7	00 	. 
	nop			;5ba8	00 	. 
	jr nz,l5bbbh		;5ba9	20 10 	  . 
	ex af,af'			;5bab	08 	. 
	inc b			;5bac	04 	. 
	ld (bc),a			;5bad	02 	. 
	ld a,051h		;5bae	3e 51 	> Q 
	ld c,c			;5bb0	49 	I 
	ld b,l			;5bb1	45 	E 
	ld a,000h		;5bb2	3e 00 	> . 
	ld b,d			;5bb4	42 	B 
	ld a,a			;5bb5	7f 	 
	ld b,b			;5bb6	40 	@ 
	nop			;5bb7	00 	. 
	ld b,d			;5bb8	42 	B 
	ld h,c			;5bb9	61 	a 
	ld d,c			;5bba	51 	Q 
l5bbbh:
	ld c,c			;5bbb	49 	I 
	ld b,(hl)			;5bbc	46 	F 
	ld hl,l4541h		;5bbd	21 41 45 	! A E 
	ld c,e			;5bc0	4b 	K 
	ld sp,l1418h		;5bc1	31 18 14 	1 . . 
	ld (de),a			;5bc4	12 	. 
	ld a,a			;5bc5	7f 	 
	djnz l5befh		;5bc6	10 27 	. ' 
	ld b,l			;5bc8	45 	E 
	ld b,l			;5bc9	45 	E 
	ld b,l			;5bca	45 	E 
	add hl,sp			;5bcb	39 	9 
	inc a			;5bcc	3c 	< 
	ld c,d			;5bcd	4a 	J 
	ld c,c			;5bce	49 	I 
	ld c,c			;5bcf	49 	I 
	jr nc,l5bd3h		;5bd0	30 01 	0 . 
	ld (hl),c			;5bd2	71 	q 
l5bd3h:
	add hl,bc			;5bd3	09 	. 
l5bd4h:
	dec b			;5bd4	05 	. 
	inc bc			;5bd5	03 	. 
	ld (hl),049h		;5bd6	36 49 	6 I 
	ld c,c			;5bd8	49 	I 
	ld c,c			;5bd9	49 	I 
	ld (hl),006h		;5bda	36 06 	6 . 
	ld c,c			;5bdc	49 	I 
	ld c,c			;5bdd	49 	I 
	add hl,hl			;5bde	29 	) 
	ld e,000h		;5bdf	1e 00 	. . 
	ld (hl),036h		;5be1	36 36 	6 6 
	nop			;5be3	00 	. 
	nop			;5be4	00 	. 
	nop			;5be5	00 	. 
	ld d,(hl)			;5be6	56 	V 
	ld (hl),000h		;5be7	36 00 	6 . 
	nop			;5be9	00 	. 
	ex af,af'			;5bea	08 	. 
	inc d			;5beb	14 	. 
	ld (00041h),hl		;5bec	22 41 00 	" A . 
l5befh:
	inc d			;5bef	14 	. 
	inc d			;5bf0	14 	. 
	inc d			;5bf1	14 	. 
	inc d			;5bf2	14 	. 
	inc d			;5bf3	14 	. 
	nop			;5bf4	00 	. 
	ld b,c			;5bf5	41 	A 
	ld (l0814h),hl		;5bf6	22 14 08 	" . . 
	ld (bc),a			;5bf9	02 	. 
	ld bc,00951h		;5bfa	01 51 09 	. Q . 
	ld b,03eh		;5bfd	06 3e 	. > 
	ld b,c			;5bff	41 	A 
	ld e,l			;5c00	5d 	] 
	ld d,l			;5c01	55 	U 
	ld e,07ch		;5c02	1e 7c 	. | 
	ld (de),a			;5c04	12 	. 
	ld de,07c12h		;5c05	11 12 7c 	. . | 
	ld a,a			;5c08	7f 	 
l5c09h:
	ld c,c			;5c09	49 	I 
	ld c,c			;5c0a	49 	I 
	ld c,c			;5c0b	49 	I 
	ld (hl),03eh		;5c0c	36 3e 	6 > 
	ld b,c			;5c0e	41 	A 
	ld b,c			;5c0f	41 	A 
	ld b,c			;5c10	41 	A 
	ld (0417fh),hl		;5c11	22 7f 41 	"  A 
	ld b,c			;5c14	41 	A 
	ld (l7f1ch),hl		;5c15	22 1c 7f 	" .  
	ld c,c			;5c18	49 	I 
	ld c,c			;5c19	49 	I 
	ld c,c			;5c1a	49 	I 
	ld b,c			;5c1b	41 	A 
	ld a,a			;5c1c	7f 	 
	add hl,bc			;5c1d	09 	. 
	add hl,bc			;5c1e	09 	. 
	add hl,bc			;5c1f	09 	. 
	ld bc,l413eh		;5c20	01 3e 41 	. > A 
	ld c,c			;5c23	49 	I 
	ld c,c			;5c24	49 	I 
	ld a,d			;5c25	7a 	z 
	ld a,a			;5c26	7f 	 
	ex af,af'			;5c27	08 	. 
	ex af,af'			;5c28	08 	. 
	ex af,af'			;5c29	08 	. 
	ld a,a			;5c2a	7f 	 
	nop			;5c2b	00 	. 
	ld b,c			;5c2c	41 	A 
	ld a,a			;5c2d	7f 	 
	ld b,c			;5c2e	41 	A 
	nop			;5c2f	00 	. 
	jr nz,l5c72h		;5c30	20 40 	  @ 
	ld b,c			;5c32	41 	A 
	ccf			;5c33	3f 	? 
	ld bc,l087eh+1		;5c34	01 7f 08 	.  . 
	inc d			;5c37	14 	. 
	ld (07f41h),hl		;5c38	22 41 7f 	" A  
	ld b,b			;5c3b	40 	@ 
	ld b,b			;5c3c	40 	@ 
	ld b,b			;5c3d	40 	@ 
	ld b,b			;5c3e	40 	@ 
	ld a,a			;5c3f	7f 	 
	ld (bc),a			;5c40	02 	. 
	inc c			;5c41	0c 	. 
	ld (bc),a			;5c42	02 	. 
	ld a,a			;5c43	7f 	 
	ld a,a			;5c44	7f 	 
	inc b			;5c45	04 	. 
	ex af,af'			;5c46	08 	. 
	djnz l5cc8h		;5c47	10 7f 	.  
	ld a,041h		;5c49	3e 41 	> A 
	ld b,c			;5c4b	41 	A 
	ld b,c			;5c4c	41 	A 
	ld a,07fh		;5c4d	3e 7f 	>  
	add hl,bc			;5c4f	09 	. 
	add hl,bc			;5c50	09 	. 
	add hl,bc			;5c51	09 	. 
	ld b,03eh		;5c52	06 3e 	. > 
	ld b,c			;5c54	41 	A 
	ld d,c			;5c55	51 	Q 
	ld hl,l7f5eh		;5c56	21 5e 7f 	! ^  
	add hl,bc			;5c59	09 	. 
	add hl,de			;5c5a	19 	. 
	add hl,hl			;5c5b	29 	) 
	ld b,(hl)			;5c5c	46 	F 
	ld h,049h		;5c5d	26 49 	& I 
	ld c,c			;5c5f	49 	I 
	ld c,c			;5c60	49 	I 
	ld (l0101h),a		;5c61	32 01 01 	2 . . 
	ld a,a			;5c64	7f 	 
	ld bc,03f01h		;5c65	01 01 3f 	. . ? 
	ld b,b			;5c68	40 	@ 
	ld b,b			;5c69	40 	@ 
	ld b,b			;5c6a	40 	@ 
	ccf			;5c6b	3f 	? 
	rra			;5c6c	1f 	. 
	jr nz,l5cafh		;5c6d	20 40 	  @ 
	jr nz,l5c90h		;5c6f	20 1f 	  . 
	ccf			;5c71	3f 	? 
l5c72h:
	ld b,b			;5c72	40 	@ 
	jr c,l5cb5h		;5c73	38 40 	8 @ 
	ccf			;5c75	3f 	? 
	ld h,e			;5c76	63 	c 
	inc d			;5c77	14 	. 
	ex af,af'			;5c78	08 	. 
	inc d			;5c79	14 	. 
	ld h,e			;5c7a	63 	c 
	rlca			;5c7b	07 	. 
	ex af,af'			;5c7c	08 	. 
	ld (hl),b			;5c7d	70 	p 
	ex af,af'			;5c7e	08 	. 
	rlca			;5c7f	07 	. 
	ld h,c			;5c80	61 	a 
	ld d,c			;5c81	51 	Q 
	ld c,c			;5c82	49 	I 
	ld b,l			;5c83	45 	E 
	ld b,e			;5c84	43 	C 
	nop			;5c85	00 	. 
	ld a,a			;5c86	7f 	 
	ld b,c			;5c87	41 	A 
	ld b,c			;5c88	41 	A 
	nop			;5c89	00 	. 
	ld (bc),a			;5c8a	02 	. 
	inc b			;5c8b	04 	. 
	ex af,af'			;5c8c	08 	. 
	djnz l5cafh		;5c8d	10 20 	.   
	nop			;5c8f	00 	. 
l5c90h:
	ld b,c			;5c90	41 	A 
	ld b,c			;5c91	41 	A 
	ld a,a			;5c92	7f 	 
	nop			;5c93	00 	. 
	inc b			;5c94	04 	. 
	ld (bc),a			;5c95	02 	. 
	ld bc,l0402h		;5c96	01 02 04 	. . . 
	ld b,b			;5c99	40 	@ 
	ld b,b			;5c9a	40 	@ 
	ld b,b			;5c9b	40 	@ 
	ld b,b			;5c9c	40 	@ 
	ld b,b			;5c9d	40 	@ 
	nop			;5c9e	00 	. 
	nop			;5c9f	00 	. 
	inc bc			;5ca0	03 	. 
	dec b			;5ca1	05 	. 
	nop			;5ca2	00 	. 
	inc h			;5ca3	24 	$ 
	ld d,h			;5ca4	54 	T 
	ld d,h			;5ca5	54 	T 
	ld d,h			;5ca6	54 	T 
	ld a,b			;5ca7	78 	x 
	ld a,a			;5ca8	7f 	 
	ld b,h			;5ca9	44 	D 
	ld b,h			;5caa	44 	D 
	ld b,h			;5cab	44 	D 
	jr c,l5ce6h		;5cac	38 38 	8 8 
	ld b,h			;5cae	44 	D 
l5cafh:
	ld b,h			;5caf	44 	D 
	ld b,h			;5cb0	44 	D 
	ld b,h			;5cb1	44 	D 
	jr c,l5cf8h		;5cb2	38 44 	8 D 
	ld b,h			;5cb4	44 	D 
l5cb5h:
	ld b,h			;5cb5	44 	D 
	ld a,a			;5cb6	7f 	 
	jr c,l5d0dh		;5cb7	38 54 	8 T 
	ld d,h			;5cb9	54 	T 
	ld d,h			;5cba	54 	T 
	ld e,b			;5cbb	58 	X 
	inc b			;5cbc	04 	. 
	inc b			;5cbd	04 	. 
	ld a,(hl)			;5cbe	7e 	~ 
	dec b			;5cbf	05 	. 
	dec b			;5cc0	05 	. 
	ex af,af'			;5cc1	08 	. 
	ld d,h			;5cc2	54 	T 
	ld d,h			;5cc3	54 	T 
	ld d,h			;5cc4	54 	T 
	inc a			;5cc5	3c 	< 
	ld a,a			;5cc6	7f 	 
	inc b			;5cc7	04 	. 
l5cc8h:
	inc b			;5cc8	04 	. 
	inc b			;5cc9	04 	. 
	ld a,b			;5cca	78 	x 
	nop			;5ccb	00 	. 
	ld b,h			;5ccc	44 	D 
	ld a,l			;5ccd	7d 	} 
	ld b,b			;5cce	40 	@ 
	nop			;5ccf	00 	. 
	jr nz,l5d12h		;5cd0	20 40 	  @ 
	ld b,h			;5cd2	44 	D 
	dec a			;5cd3	3d 	= 
	nop			;5cd4	00 	. 
	ld a,a			;5cd5	7f 	 
	djnz l5d00h		;5cd6	10 28 	. ( 
	ld b,h			;5cd8	44 	D 
	nop			;5cd9	00 	. 
	nop			;5cda	00 	. 
	ld b,c			;5cdb	41 	A 
	ld a,a			;5cdc	7f 	 
	ld b,b			;5cdd	40 	@ 
	nop			;5cde	00 	. 
	ld a,h			;5cdf	7c 	| 
	inc b			;5ce0	04 	. 
	ld a,h			;5ce1	7c 	| 
	inc b			;5ce2	04 	. 
	ld a,b			;5ce3	78 	x 
	ld a,h			;5ce4	7c 	| 
	inc b			;5ce5	04 	. 
l5ce6h:
	inc b			;5ce6	04 	. 
	inc b			;5ce7	04 	. 
	ld a,b			;5ce8	78 	x 
	jr c,l5d2fh		;5ce9	38 44 	8 D 
	ld b,h			;5ceb	44 	D 
	ld b,h			;5cec	44 	D 
	jr c,l5d6bh		;5ced	38 7c 	8 | 
	inc d			;5cef	14 	. 
	inc d			;5cf0	14 	. 
	inc d			;5cf1	14 	. 
	ex af,af'			;5cf2	08 	. 
	ex af,af'			;5cf3	08 	. 
	inc d			;5cf4	14 	. 
	inc d			;5cf5	14 	. 
	inc d			;5cf6	14 	. 
	ld a,h			;5cf7	7c 	| 
l5cf8h:
	ld a,h			;5cf8	7c 	| 
	ex af,af'			;5cf9	08 	. 
	inc b			;5cfa	04 	. 
	inc b			;5cfb	04 	. 
	nop			;5cfc	00 	. 
	ld c,b			;5cfd	48 	H 
	ld d,h			;5cfe	54 	T 
	ld d,h			;5cff	54 	T 
l5d00h:
	ld d,h			;5d00	54 	T 
	inc h			;5d01	24 	$ 
	inc b			;5d02	04 	. 
	inc b			;5d03	04 	. 
	ccf			;5d04	3f 	? 
	ld b,h			;5d05	44 	D 
	ld b,h			;5d06	44 	D 
	inc a			;5d07	3c 	< 
	ld b,b			;5d08	40 	@ 
	ld b,b			;5d09	40 	@ 
	ld b,b			;5d0a	40 	@ 
	ld a,h			;5d0b	7c 	| 
	inc e			;5d0c	1c 	. 
l5d0dh:
	jr nz,l5d4fh		;5d0d	20 40 	  @ 
	jr nz,l5d2dh		;5d0f	20 1c 	  . 
	inc a			;5d11	3c 	< 
l5d12h:
	ld b,b			;5d12	40 	@ 
	jr nc,l5d55h		;5d13	30 40 	0 @ 
	inc a			;5d15	3c 	< 
	ld b,h			;5d16	44 	D 
	jr z,l5d29h		;5d17	28 10 	( . 
	jr z,l5d5fh		;5d19	28 44 	( D 
	inc c			;5d1b	0c 	. 
	ld d,b			;5d1c	50 	P 
	ld d,b			;5d1d	50 	P 
	ld d,b			;5d1e	50 	P 
	inc a			;5d1f	3c 	< 
	ld b,h			;5d20	44 	D 
	ld h,h			;5d21	64 	d 
	ld d,h			;5d22	54 	T 
	ld c,h			;5d23	4c 	L 
	ld b,h			;5d24	44 	D 
	ex af,af'			;5d25	08 	. 
	ld (hl),041h		;5d26	36 41 	6 A 
	ld b,c			;5d28	41 	A 
l5d29h:
	nop			;5d29	00 	. 
	nop			;5d2a	00 	. 
	nop			;5d2b	00 	. 
	ld (hl),a			;5d2c	77 	w 
l5d2dh:
	nop			;5d2d	00 	. 
	nop			;5d2e	00 	. 
l5d2fh:
	nop			;5d2f	00 	. 
	ld b,c			;5d30	41 	A 
	ld b,c			;5d31	41 	A 
	ld (hl),008h		;5d32	36 08 	6 . 
	ld (bc),a			;5d34	02 	. 
	ld bc,l0402h		;5d35	01 02 04 	. . . 
	ld (bc),a			;5d38	02 	. 
	ld h,b			;5d39	60 	` 
	ld d,b			;5d3a	50 	P 
	ld c,b			;5d3b	48 	H 
	ld d,b			;5d3c	50 	P 
	ld h,b			;5d3d	60 	` 
l5d3eh:
	ex af,af'			;5d3e	08 	. 
	ex af,af'			;5d3f	08 	. 
	rst 38h			;5d40	ff 	. 
	ex af,af'			;5d41	08 	. 
	ex af,af'			;5d42	08 	. 
	ex af,af'			;5d43	08 	. 
	ex af,af'			;5d44	08 	. 
	ex af,af'			;5d45	08 	. 
	rrca			;5d46	0f 	. 
	ex af,af'			;5d47	08 	. 
	ex af,af'			;5d48	08 	. 
	ex af,af'			;5d49	08 	. 
	ex af,af'			;5d4a	08 	. 
	ex af,af'			;5d4b	08 	. 
	ret m			;5d4c	f8 	. 
	ex af,af'			;5d4d	08 	. 
	ex af,af'			;5d4e	08 	. 
l5d4fh:
	ex af,af'			;5d4f	08 	. 
	ex af,af'			;5d50	08 	. 
	ex af,af'			;5d51	08 	. 
	rst 38h			;5d52	ff 	. 
	nop			;5d53	00 	. 
	nop			;5d54	00 	. 
l5d55h:
	nop			;5d55	00 	. 
	nop			;5d56	00 	. 
	nop			;5d57	00 	. 
	rst 38h			;5d58	ff 	. 
	ex af,af'			;5d59	08 	. 
	ex af,af'			;5d5a	08 	. 
	ex af,af'			;5d5b	08 	. 
	ex af,af'			;5d5c	08 	. 
	ex af,af'			;5d5d	08 	. 
	ex af,af'			;5d5e	08 	. 
l5d5fh:
	ex af,af'			;5d5f	08 	. 
	ex af,af'			;5d60	08 	. 
	ex af,af'			;5d61	08 	. 
	nop			;5d62	00 	. 
	nop			;5d63	00 	. 
	rst 38h			;5d64	ff 	. 
	nop			;5d65	00 	. 
	nop			;5d66	00 	. 
	nop			;5d67	00 	. 
	nop			;5d68	00 	. 
	nop			;5d69	00 	. 
	ret m			;5d6a	f8 	. 
l5d6bh:
	ex af,af'			;5d6b	08 	. 
	ex af,af'			;5d6c	08 	. 
	ex af,af'			;5d6d	08 	. 
	ex af,af'			;5d6e	08 	. 
	ex af,af'			;5d6f	08 	. 
	ret m			;5d70	f8 	. 
	nop			;5d71	00 	. 
	nop			;5d72	00 	. 
	nop			;5d73	00 	. 
	nop			;5d74	00 	. 
	nop			;5d75	00 	. 
	rrca			;5d76	0f 	. 
	ex af,af'			;5d77	08 	. 
	ex af,af'			;5d78	08 	. 
	ex af,af'			;5d79	08 	. 
	ex af,af'			;5d7a	08 	. 
	ex af,af'			;5d7b	08 	. 
	rrca			;5d7c	0f 	. 
	nop			;5d7d	00 	. 
	nop			;5d7e	00 	. 
	nop			;5d7f	00 	. 
	xor d			;5d80	aa 	. 
	ld d,l			;5d81	55 	U 
	xor d			;5d82	aa 	. 
	ld d,l			;5d83	55 	U 
	xor d			;5d84	aa 	. 
	ld d,l			;5d85	55 	U 
	rst 38h			;5d86	ff 	. 
	rst 38h			;5d87	ff 	. 
	rst 38h			;5d88	ff 	. 
	rst 38h			;5d89	ff 	. 
	rst 38h			;5d8a	ff 	. 
	rst 38h			;5d8b	ff 	. 
	ret p			;5d8c	f0 	. 
	ret p			;5d8d	f0 	. 
	ret p			;5d8e	f0 	. 
	ret p			;5d8f	f0 	. 
	ret p			;5d90	f0 	. 
	ret p			;5d91	f0 	. 
	rst 38h			;5d92	ff 	. 
	rst 38h			;5d93	ff 	. 
	rst 38h			;5d94	ff 	. 
	nop			;5d95	00 	. 
	nop			;5d96	00 	. 
	nop			;5d97	00 	. 
	inc e			;5d98	1c 	. 
	ld a,03eh		;5d99	3e 3e 	> > 
	ld a,01ch		;5d9b	3e 1c 	> . 
	nop			;5d9d	00 	. 
	inc e			;5d9e	1c 	. 
	ld (02222h),hl		;5d9f	22 22 22 	" " " 
	inc e			;5da2	1c 	. 
	nop			;5da3	00 	. 
	inc e			;5da4	1c 	. 
	ld e,(hl)			;5da5	5e 	^ 
	ld a,a			;5da6	7f 	 
	ld e,(hl)			;5da7	5e 	^ 
	inc e			;5da8	1c 	. 
	nop			;5da9	00 	. 
	inc e			;5daa	1c 	. 
	ld a,07ch		;5dab	3e 7c 	> | 
	ld a,01ch		;5dad	3e 1c 	> . 
	nop			;5daf	00 	. 
	jr $+62		;5db0	18 3c 	. < 
	ld a,(hl)			;5db2	7e 	~ 
	inc a			;5db3	3c 	< 
	jr l5db6h		;5db4	18 00 	. . 
l5db6h:
	jr l5e16h		;5db6	18 5e 	. ^ 
	ld a,(hl)			;5db8	7e 	~ 
	ld e,(hl)			;5db9	5e 	^ 
	jr l5dbch		;5dba	18 00 	. . 
l5dbch:
	ld h,b			;5dbc	60 	` 
	ld (hl),b			;5dbd	70 	p 
	ccf			;5dbe	3f 	? 
	ld (bc),a			;5dbf	02 	. 
	inc e			;5dc0	1c 	. 
	nop			;5dc1	00 	. 
	ld l,b			;5dc2	68 	h 
	ld (hl),h			;5dc3	74 	t 
	ld d,h			;5dc4	54 	T 
	ld (hl),h			;5dc5	74 	t 
	ld l,b			;5dc6	68 	h 
	nop			;5dc7	00 	. 
	djnz l5e22h		;5dc8	10 58 	. X 
	ld a,(hl)			;5dca	7e 	~ 
	ld e,b			;5dcb	58 	X 
	djnz l5dceh		;5dcc	10 00 	. . 
l5dceh:
	jr nc,sub_5e4ch		;5dce	30 7c 	0 | 
	inc (hl)			;5dd0	34 	4 
	ld a,h			;5dd1	7c 	| 
	inc a			;5dd2	3c 	< 
	nop			;5dd3	00 	. 
	ld c,050h		;5dd4	0e 50 	. P 
	ld (hl),b			;5dd6	70 	p 
	ld d,b			;5dd7	50 	P 
	ld c,000h		;5dd8	0e 00 	. . 
	ld b,d			;5dda	42 	B 
	ld h,d			;5ddb	62 	b 
	rra			;5ddc	1f 	. 
	ld (00064h),a		;5ddd	32 64 00 	2 d . 
	inc b			;5de0	04 	. 
	ld (bc),a			;5de1	02 	. 
	ld a,a			;5de2	7f 	 
	ld (bc),a			;5de3	02 	. 
	inc b			;5de4	04 	. 
	nop			;5de5	00 	. 
	djnz $+34		;5de6	10 20 	.   
	ld a,a			;5de8	7f 	 
	jr nz,l5dfbh		;5de9	20 10 	  . 
	nop			;5deb	00 	. 
	ld (l0814h),hl		;5dec	22 14 08 	" . . 
	inc d			;5def	14 	. 
	ld (l0800h),hl		;5df0	22 00 08 	" . . 
	ex af,af'			;5df3	08 	. 
	ld hl,(00808h)		;5df4	2a 08 08 	* . . 
	nop			;5df7	00 	. 
	ld b,h			;5df8	44 	D 
	ld b,h			;5df9	44 	D 
	ld e,a			;5dfa	5f 	_ 
l5dfbh:
	ld b,h			;5dfb	44 	D 
	ld b,h			;5dfc	44 	D 
	nop			;5dfd	00 	. 
l5dfeh:
	ld h,b			;5dfe	60 	` 
	ld d,b			;5dff	50 	P 
	ld c,b			;5e00	48 	H 
	ld d,b			;5e01	50 	P 
	ld h,b			;5e02	60 	` 
	nop			;5e03	00 	. 
	djnz $+58		;5e04	10 38 	. 8 
	ld d,h			;5e06	54 	T 
	djnz l5e28h		;5e07	10 1f 	. . 
	nop			;5e09	00 	. 
l5e0ah:
	ld a,(0efbbh)		;5e0a	3a bb ef 	: . . 
	and 001h		;5e0d	e6 01 	. . 
	jr nz,l5e49h		;5e0f	20 38 	  8 
	ld a,c			;5e11	79 	y 
	sub 00dh		;5e12	d6 0d 	. . 
	jr c,l5e49h		;5e14	38 33 	8 3 
l5e16h:
	cp 021h		;5e16	fe 21 	. ! 
	jr nc,l5e49h		;5e18	30 2f 	0 / 
	ld (0f7f2h),bc		;5e1a	ed 43 f2 f7 	. C . . 
	ld (0f7f4h),de		;5e1e	ed 53 f4 f7 	. S . . 
l5e22h:
	ld hl,COLDRST		;5e22	21 00 00 	! . . 
	ld (0f7ceh),hl		;5e25	22 ce f7 	" . . 
l5e28h:
	ex de,hl			;5e28	eb 	. 
	ld hl,l6aa9h		;5e29	21 a9 6a 	! . j 
	push hl			;5e2c	e5 	. 
	ld hl,MTOSTBL		;5e2d	21 56 5e 	! V ^ 
	call sub_5e4ch		;5e30	cd 4c 5e 	. L ^ 
	ld de,(0f4e3h)		;5e33	ed 5b e3 f4 	. [ . . 
	ld a,(0efbdh)		;5e37	3a bd ef 	: . . 
	and 097h		;5e3a	e6 97 	. . 
	ld (0efbdh),a		;5e3c	32 bd ef 	2 . . 
	jp (hl)			;5e3f	e9 	. 
l5e40h:
	pop bc			;5e40	c1 	. 
	ld bc,(0f7f2h)		;5e41	ed 4b f2 f7 	. K . . 
	ld de,(0f7f4h)		;5e45	ed 5b f4 f7 	. [ . . 
l5e49h:
	jp l1beah		;5e49	c3 ea 1b 	. . . 
sub_5e4ch:
	ld e,a			;5e4c	5f 	_ 
sub_5e4dh:
	ld d,000h		;5e4d	16 00 	. . 
	add hl,de			;5e4f	19 	. 
	add hl,de			;5e50	19 	. 
	ld e,(hl)			;5e51	5e 	^ 
	inc hl			;5e52	23 	# 
	ld d,(hl)			;5e53	56 	V 
	ex de,hl			;5e54	eb 	. 
	ret			;5e55	c9 	. 
MTOSTBL:
	ld (hl),e			;5e56	73 	s 
	ld l,c			;5e57	69 	i 
	ld a,h			;5e58	7c 	| 
	ld l,c			;5e59	69 	i 
	sub e			;5e5a	93 	. 
	ld l,c			;5e5b	69 	i 
	sbc a,c			;5e5c	99 	. 
	ld l,c			;5e5d	69 	i 
	sbc a,a			;5e5e	9f 	. 
	ld l,c			;5e5f	69 	i 
	jp nz,0ce69h		;5e60	c2 69 ce 	. i . 
	ld l,c			;5e63	69 	i 
	rst 18h			;5e64	df 	. 
	ld l,c			;5e65	69 	i 
	push hl			;5e66	e5 	. 
	ld l,c			;5e67	69 	i 
	ex de,hl			;5e68	eb 	. 
	ld l,c			;5e69	69 	i 
	pop af			;5e6a	f1 	. 
	ld l,c			;5e6b	69 	i 
	rst 30h			;5e6c	f7 	. 
	ld l,c			;5e6d	69 	i 
	ld de,0406ah		;5e6e	11 6a 40 	. j @ 
	ld e,(hl)			;5e71	5e 	^ 
	rla			;5e72	17 	. 
	ld l,d			;5e73	6a 	j 
	ld (02b6ah),hl		;5e74	22 6a 2b 	" j + 
	ld l,d			;5e77	6a 	j 
	dec (hl)			;5e78	35 	5 
	ld l,d			;5e79	6a 	j 
	dec sp			;5e7a	3b 	; 
	ld l,d			;5e7b	6a 	j 
	ld b,b			;5e7c	40 	@ 
	ld e,(hl)			;5e7d	5e 	^ 
	ld b,l			;5e7e	45 	E 
	ld l,d			;5e7f	6a 	j 
	ld c,e			;5e80	4b 	K 
	ld l,d			;5e81	6a 	j 
	ld d,c			;5e82	51 	Q 
	ld l,d			;5e83	6a 	j 
	ld b,b			;5e84	40 	@ 
	ld e,(hl)			;5e85	5e 	^ 
	ld d,a			;5e86	57 	W 
	ld l,d			;5e87	6a 	j 
	ld b,b			;5e88	40 	@ 
	ld e,(hl)			;5e89	5e 	^ 
	ld b,b			;5e8a	40 	@ 
	ld e,(hl)			;5e8b	5e 	^ 
	ld b,b			;5e8c	40 	@ 
	ld e,(hl)			;5e8d	5e 	^ 
	rla			;5e8e	17 	. 
	ld l,c			;5e8f	69 	i 
	ld h,l			;5e90	65 	e 
	ld h,l			;5e91	65 	e 
	jp z,l7864h		;5e92	ca 64 78 	. d x 
	ld l,d			;5e95	6a 	j 
	sbc a,a			;5e96	9f 	. 
	ld h,h			;5e97	64 	d 
sub_5e98h:
	ld b,000h		;5e98	06 00 	. . 
	ld a,(00106h)		;5e9a	3a 06 01 	: . . 
	ld a,(00206h)		;5e9d	3a 06 02 	: . . 
	ld a,(00306h)		;5ea0	3a 06 03 	: . . 
	ld a,(00506h)		;5ea3	3a 06 05 	: . . 
	ld a,(00a06h)		;5ea6	3a 06 0a 	: . . 
	ld a,(l0b06h)		;5ea9	3a 06 0b 	: . . 
	ld a,(00c06h)		;5eac	3a 06 0c 	: . . 
	ld a,(sub_0d03h+3)		;5eaf	3a 06 0d 	: . . 
	ld a,(l0e06h)		;5eb2	3a 06 0e 	: . . 
	ld a,(l1106h)		;5eb5	3a 06 11 	: . . 
	ld a,(l1406h)		;5eb8	3a 06 14 	: . . 
	ld a,(01506h)		;5ebb	3a 06 15 	: . . 
	ld a,(01606h)		;5ebe	3a 06 16 	: . . 
	ld a,(l1906h)		;5ec1	3a 06 19 	: . . 
	ld a,(01006h)		;5ec4	3a 06 10 	: . . 
	jp sub_2ab4h		;5ec7	c3 b4 2a 	. . * 
l5ecah:
	nop			;5eca	00 	. 
	nop			;5ecb	00 	. 
	rst 38h			;5ecc	ff 	. 
	dec b			;5ecd	05 	. 
	rst 38h			;5ece	ff 	. 
	dec b			;5ecf	05 	. 
	rst 38h			;5ed0	ff 	. 
	dec b			;5ed1	05 	. 
	rst 38h			;5ed2	ff 	. 
	dec b			;5ed3	05 	. 
	rst 38h			;5ed4	ff 	. 
	nop			;5ed5	00 	. 
	rst 38h			;5ed6	ff 	. 
	nop			;5ed7	00 	. 
	rst 38h			;5ed8	ff 	. 
	dec b			;5ed9	05 	. 
	rst 38h			;5eda	ff 	. 
	nop			;5edb	00 	. 
	rst 38h			;5edc	ff 	. 
	dec b			;5edd	05 	. 
	ld bc,0ff00h		;5ede	01 00 ff 	. . . 
	dec b			;5ee1	05 	. 
	ld bc,00400h		;5ee2	01 00 04 	. . . 
	nop			;5ee5	00 	. 
	rst 38h			;5ee6	ff 	. 
	dec b			;5ee7	05 	. 
	rst 38h			;5ee8	ff 	. 
	nop			;5ee9	00 	. 
	rst 38h			;5eea	ff 	. 
	nop			;5eeb	00 	. 
	rst 38h			;5eec	ff 	. 
	dec b			;5eed	05 	. 
	rst 38h			;5eee	ff 	. 
	dec b			;5eef	05 	. 
l5ef0h:
	ld c,001h		;5ef0	0e 01 	. . 
	ld a,(0020eh)		;5ef2	3a 0e 02 	: . . 
	ld a,(l030dh+1)		;5ef5	3a 0e 03 	: . . 
	ld a,(l040eh)		;5ef8	3a 0e 04 	: . . 
	ld a,(0050eh)		;5efb	3a 0e 05 	: . . 
	ld a,(0060eh)		;5efe	3a 0e 06 	: . . 
	ld a,(l070ch+2)		;5f01	3a 0e 07 	: . . 
	ld a,(l080eh)		;5f04	3a 0e 08 	: . . 
	ld a,(0090eh)		;5f07	3a 0e 09 	: . . 
	ld a,(00a0eh)		;5f0a	3a 0e 0a 	: . . 
	ld a,(l0b0eh)		;5f0d	3a 0e 0b 	: . . 
	ld a,(00c0eh)		;5f10	3a 0e 0c 	: . . 
	ld a,(l0d0dh+1)		;5f13	3a 0e 0d 	: . . 
	ld a,(l0f0eh)		;5f16	3a 0e 0f 	: . . 
	ld a,(0100eh)		;5f19	3a 0e 10 	: . . 
	ld a,(0110eh)		;5f1c	3a 0e 11 	: . . 
	ld a,(l120eh)		;5f1f	3a 0e 12 	: . . 
	ld a,c			;5f22	79 	y 
	ld (0f7ceh),a		;5f23	32 ce f7 	2 . . 
	ld a,(0efbdh)		;5f26	3a bd ef 	: . . 
	and 040h		;5f29	e6 40 	. @ 
	ret nz			;5f2b	c0 	. 
	jp sub_61d3h		;5f2c	c3 d3 61 	. . a 
sub_5f2fh:
	ld hl,(0f351h)		;5f2f	2a 51 f3 	* Q . 
	ld (hl),c			;5f32	71 	q 
	ld bc,(0f7d3h)		;5f33	ed 4b d3 f7 	. K . . 
	call sub_5f97h		;5f37	cd 97 5f 	. . _ 
	ld (hl),000h		;5f3a	36 00 	6 . 
	ld h,b			;5f3c	60 	` 
l5f3dh:
	ld l,c			;5f3d	69 	i 
	ret			;5f3e	c9 	. 
sub_5f3fh:
	ld hl,l7ff8h		;5f3f	21 f8 7f 	! .  
	jr l5f47h		;5f42	18 03 	. . 
sub_5f44h:
	ld hl,l5f4dh		;5f44	21 4d 5f 	! M _ 
l5f47h:
	ld bc,l0006h+2		;5f47	01 08 00 	. . . 
	ldir		;5f4a	ed b0 	. . 
	ret			;5f4c	c9 	. 
l5f4dh:
	ccf			;5f4d	3f 	? 
	ccf			;5f4e	3f 	? 
	ccf			;5f4f	3f 	? 
	ccf			;5f50	3f 	? 
	ccf			;5f51	3f 	? 
	ccf			;5f52	3f 	? 
	ccf			;5f53	3f 	? 
	ccf			;5f54	3f 	? 
sub_5f55h:
	ld de,0f882h		;5f55	11 82 f8 	. . . 
	push hl			;5f58	e5 	. 
	push de			;5f59	d5 	. 
	ld c,000h		;5f5a	0e 00 	. . 
	call sub_4162h		;5f5c	cd 62 41 	. b A 
	pop hl			;5f5f	e1 	. 
	ld a,(hl)			;5f60	7e 	~ 
	inc hl			;5f61	23 	# 
	ld b,(hl)			;5f62	46 	F 
	inc hl			;5f63	23 	# 
	ld c,(hl)			;5f64	4e 	N 
	ld (hl),a			;5f65	77 	w 
	dec hl			;5f66	2b 	+ 
	ld (hl),c			;5f67	71 	q 
	dec hl			;5f68	2b 	+ 
	ld (hl),b			;5f69	70 	p 
	ex de,hl			;5f6a	eb 	. 
	pop hl			;5f6b	e1 	. 
	ld b,006h		;5f6c	06 06 	. . 
l5f6eh:
	ld a,(de)			;5f6e	1a 	. 
	call sub_5f7ah		;5f6f	cd 7a 5f 	. z _ 
	ld (hl),c			;5f72	71 	q 
	inc hl			;5f73	23 	# 
	ld (hl),a			;5f74	77 	w 
	inc hl			;5f75	23 	# 
	inc de			;5f76	13 	. 
	djnz l5f6eh		;5f77	10 f5 	. . 
	ret			;5f79	c9 	. 
sub_5f7ah:
	push af			;5f7a	f5 	. 
	rra			;5f7b	1f 	. 
	rra			;5f7c	1f 	. 
	rra			;5f7d	1f 	. 
	rra			;5f7e	1f 	. 
	call sub_5f84h		;5f7f	cd 84 5f 	. . _ 
	ld c,a			;5f82	4f 	O 
	pop af			;5f83	f1 	. 
sub_5f84h:
	and 00fh		;5f84	e6 0f 	. . 
	or 030h		;5f86	f6 30 	. 0 
	ret			;5f88	c9 	. 
sub_5f89h:
	xor a			;5f89	af 	. 
l5f8ah:
	ld (hl),a			;5f8a	77 	w 
	ld d,h			;5f8b	54 	T 
	ld e,l			;5f8c	5d 	] 
	inc de			;5f8d	13 	. 
	ldir		;5f8e	ed b0 	. . 
	ret			;5f90	c9 	. 
sub_5f91h:
	push hl			;5f91	e5 	. 
	call sub_6242h		;5f92	cd 42 62 	. B b 
	pop hl			;5f95	e1 	. 
	dec hl			;5f96	2b 	+ 
sub_5f97h:
	inc hl			;5f97	23 	# 
sub_5f98h:
	ld (hl),b			;5f98	70 	p 
	inc hl			;5f99	23 	# 
	ld (hl),c			;5f9a	71 	q 
	inc hl			;5f9b	23 	# 
	ret			;5f9c	c9 	. 
sub_5f9dh:
	ld de,COLDRST		;5f9d	11 00 00 	. . . 
	ld a,(TAPMOD)		;5fa0	3a e1 f2 	: . . 
	or a			;5fa3	b7 	. 
	ret z			;5fa4	c8 	. 
	ld a,(0f2e2h)		;5fa5	3a e2 f2 	: . . 
	ld b,a			;5fa8	47 	G 
	inc b			;5fa9	04 	. 
	and 00fh		;5faa	e6 0f 	. . 
	scf			;5fac	37 	7 
	ld a,b			;5fad	78 	x 
l5faeh:
	ret z			;5fae	c8 	. 
	rl e		;5faf	cb 13 	. . 
	rl d		;5fb1	cb 12 	. . 
	dec a			;5fb3	3d 	= 
	jr l5faeh		;5fb4	18 f8 	. . 
sub_5fb6h:
	ld a,(0f7d2h)		;5fb6	3a d2 f7 	: . . 
l5fb9h:
	ld de,00104h		;5fb9	11 04 01 	. . . 
	ld c,03fh		;5fbc	0e 3f 	. ? 
	call sub_5f2fh		;5fbe	cd 2f 5f 	. / _ 
	ld c,a			;5fc1	4f 	O 
	ld a,001h		;5fc2	3e 01 	> . 
	call 05ec5h		;5fc4	cd c5 5e 	. . ^ 
	or a			;5fc7	b7 	. 
	ret			;5fc8	c9 	. 
sub_5fc9h:
	ld a,(0f7d2h)		;5fc9	3a d2 f7 	: . . 
sub_5fcch:
	ld c,044h		;5fcc	0e 44 	. D 
l5fceh:
	ld de,00104h		;5fce	11 04 01 	. . . 
	call sub_5f2fh		;5fd1	cd 2f 5f 	. / _ 
	ld c,a			;5fd4	4f 	O 
	call 05eb6h		;5fd5	cd b6 5e 	. . ^ 
	or a			;5fd8	b7 	. 
	ret			;5fd9	c9 	. 
sub_5fdah:
	call sub_5ffah		;5fda	cd fa 5f 	. . _ 
	ld a,(0f2e6h)		;5fdd	3a e6 f2 	: . . 
	and 07fh		;5fe0	e6 7f 	.  
	jr l5fb9h		;5fe2	18 d5 	. . 
sub_5fe4h:
	ldir		;5fe4	ed b0 	. . 
	xor a			;5fe6	af 	. 
	call sub_5fcch		;5fe7	cd cc 5f 	. . _ 
	jr sub_5ffah		;5fea	18 0e 	. . 
sub_5fech:
	ld a,080h		;5fec	3e 80 	> . 
	jr l5fceh		;5fee	18 de 	. . 
sub_5ff0h:
	ld hl,COLDRST		;5ff0	21 00 00 	! . . 
sub_5ff3h:
	call 05ec2h		;5ff3	cd c2 5e 	. . ^ 
	call nz,sub_61d3h		;5ff6	c4 d3 61 	. . a 
	ret			;5ff9	c9 	. 
sub_5ffah:
	ld hl,(0f7d7h)		;5ffa	2a d7 f7 	* . . 
	inc hl			;5ffd	23 	# 
	inc hl			;5ffe	23 	# 
	ld (0f7d7h),hl		;5fff	22 d7 f7 	" . . 
sub_6002h:
	ld hl,(0f7d3h)		;6002	2a d3 f7 	* . . 
	inc hl			;6005	23 	# 
	ld (0f7d3h),hl		;6006	22 d3 f7 	" . . 
	ret			;6009	c9 	. 
sub_600ah:
	ld hl,(0f7dfh)		;600a	2a df f7 	* . . 
	inc hl			;600d	23 	# 
	ld (0f7dfh),hl		;600e	22 df f7 	" . . 
	ret			;6011	c9 	. 
sub_6012h:
	ld hl,(0f7d7h)		;6012	2a d7 f7 	* . . 
	ld d,h			;6015	54 	T 
	ld e,l			;6016	5d 	] 
	inc hl			;6017	23 	# 
	inc hl			;6018	23 	# 
	ld a,h			;6019	7c 	| 
	or l			;601a	b5 	. 
	ret z			;601b	c8 	. 
	ld hl,(0f7d5h)		;601c	2a d5 f7 	* . . 
	push hl			;601f	e5 	. 
	sbc hl,de		;6020	ed 52 	. R 
	pop hl			;6022	e1 	. 
	ret c			;6023	d8 	. 
	inc de			;6024	13 	. 
	inc de			;6025	13 	. 
	inc de			;6026	13 	. 
	inc de			;6027	13 	. 
	sbc hl,de		;6028	ed 52 	. R 
	ccf			;602a	3f 	? 
	ret c			;602b	d8 	. 
	ld de,RBDOS1		;602c	11 05 00 	. . . 
	add hl,de			;602f	19 	. 
	ld a,l			;6030	7d 	} 
	ld b,a			;6031	47 	G 
	cp 003h		;6032	fe 03 	. . 
	jp nc,l60e4h		;6034	d2 e4 60 	. . ` 
l6037h:
	ld hl,(0f351h)		;6037	2a 51 f3 	* Q . 
	ld de,l0003h+1		;603a	11 04 00 	. . . 
	dec a			;603d	3d 	= 
	jr z,l6043h		;603e	28 03 	( . 
	ld de,00084h		;6040	11 84 00 	. . . 
l6043h:
	add hl,de			;6043	19 	. 
	ex de,hl			;6044	eb 	. 
	ld a,b			;6045	78 	x 
	or a			;6046	b7 	. 
	ret			;6047	c9 	. 
sub_6048h:
	ld a,001h		;6048	3e 01 	> . 
	jr l6037h		;604a	18 eb 	. . 
l604ch:
	call sub_6012h		;604c	cd 12 60 	. . ` 
	jr c,l608eh		;604f	38 3d 	8 = 
	jr nz,l6071h		;6051	20 1e 	  . 
	call sub_647fh		;6053	cd 7f 64 	.  d 
	jr nc,l608bh		;6056	30 33 	0 3 
	call sub_5ffah		;6058	cd fa 5f 	. . _ 
	ld hl,(0f7d3h)		;605b	2a d3 f7 	* . . 
	ld de,(0f7dfh)		;605e	ed 5b df f7 	. [ . . 
	sbc hl,de		;6062	ed 52 	. R 
	jr nc,l608eh		;6064	30 28 	0 ( 
	call sub_5fb6h		;6066	cd b6 5f 	. . _ 
	ret nz			;6069	c0 	. 
	ld a,003h		;606a	3e 03 	> . 
	ld (0f7d9h),a		;606c	32 d9 f7 	2 . . 
	jr l604ch		;606f	18 db 	. . 
l6071h:
	ld a,(0f7d9h)		;6071	3a d9 f7 	: . . 
	and b			;6074	a0 	. 
	jr z,l608bh		;6075	28 14 	( . 
	ld hl,(0f7d5h)		;6077	2a d5 f7 	* . . 
	ld bc,(0f7e1h)		;607a	ed 4b e1 f7 	. K . . 
	sbc hl,bc		;607e	ed 42 	. B 
	jr nc,l608eh		;6080	30 0c 	0 . 
	ld hl,(0f323h)		;6082	2a 23 f3 	* # . 
	ex de,hl			;6085	eb 	. 
	jr l60dfh		;6086	18 57 	. W 
l6088h:
	jp 05f0eh		;6088	c3 0e 5f 	. . _ 
l608bh:
	jp 05f11h		;608b	c3 11 5f 	. . _ 
l608eh:
	ld a,(0f7e9h)		;608e	3a e9 f7 	: . . 
	and 080h		;6091	e6 80 	. . 
	jr z,l608bh		;6093	28 f6 	( . 
	jp 05f14h		;6095	c3 14 5f 	. . _ 
sub_6098h:
	call sub_647fh		;6098	cd 7f 64 	.  d 
	jr c,l6088h		;609b	38 eb 	8 . 
l609dh:
	call sub_6012h		;609d	cd 12 60 	. . ` 
	jr c,l6088h		;60a0	38 e6 	8 . 
	jr nz,l60c2h		;60a2	20 1e 	  . 
	ld a,(0f7d9h)		;60a4	3a d9 f7 	: . . 
	sub 003h		;60a7	d6 03 	. . 
	jr nz,l6088h		;60a9	20 dd 	  . 
	call sub_5fc9h		;60ab	cd c9 5f 	. . _ 
	ret nz			;60ae	c0 	. 
	call sub_5ffah		;60af	cd fa 5f 	. . _ 
	call sub_600ah		;60b2	cd 0a 60 	. . ` 
	ld hl,(0fa0eh)		;60b5	2a 0e fa 	* . . 
	inc hl			;60b8	23 	# 
	ld (0fa0eh),hl		;60b9	22 0e fa 	" . . 
	xor a			;60bc	af 	. 
	ld (0f7d9h),a		;60bd	32 d9 f7 	2 . . 
	jr l609dh		;60c0	18 db 	. . 
l60c2h:
	ld a,(0f7d9h)		;60c2	3a d9 f7 	: . . 
	ld c,a			;60c5	4f 	O 
	and b			;60c6	a0 	. 
	jr nz,l60dch		;60c7	20 13 	  . 
	ld hl,(0f7e1h)		;60c9	2a e1 f7 	* . . 
	inc hl			;60cc	23 	# 
	ld (0f7e1h),hl		;60cd	22 e1 f7 	" . . 
	ld hl,(0fa10h)		;60d0	2a 10 fa 	* . . 
	inc hl			;60d3	23 	# 
	ld (0fa10h),hl		;60d4	22 10 fa 	" . . 
	ld a,c			;60d7	79 	y 
	or b			;60d8	b0 	. 
	ld (0f7d9h),a		;60d9	32 d9 f7 	2 . . 
l60dch:
	ld hl,(0f323h)		;60dc	2a 23 f3 	* # . 
l60dfh:
	ld bc,l007fh+1		;60df	01 80 00 	. . . 
	ldir		;60e2	ed b0 	. . 
l60e4h:
	xor a			;60e4	af 	. 
	ret			;60e5	c9 	. 
sub_60e6h:
	ld hl,0eff1h		;60e6	21 f1 ef 	! . . 
	set 1,(hl)		;60e9	cb ce 	. . 
	ret			;60eb	c9 	. 
sub_60ech:
	call sub_60e6h		;60ec	cd e6 60 	. . ` 
	call sub_6206h		;60ef	cd 06 62 	. . b 
	ret nz			;60f2	c0 	. 
	ld hl,(0f2e7h)		;60f3	2a e7 f2 	* . . 
	call sub_6200h		;60f6	cd 00 62 	. . b 
	ret nz			;60f9	c0 	. 
sub_60fah:
	ld hl,COLDRST		;60fa	21 00 00 	! . . 
	ld (0f7d3h),hl		;60fd	22 d3 f7 	" . . 
	ld c,048h		;6100	0e 48 	. H 
	ld a,(0450eh)		;6102	3a 0e 45 	: . E 
	ld a,(0f2e6h)		;6105	3a e6 f2 	: . . 
	or 080h		;6108	f6 80 	. . 
	push bc			;610a	c5 	. 
	call l5fb9h		;610b	cd b9 5f 	. . _ 
	pop bc			;610e	c1 	. 
	ret nz			;610f	c0 	. 
	ld a,c			;6110	79 	y 
	sub 045h		;6111	d6 45 	. E 
	ret z			;6113	c8 	. 
	xor a			;6114	af 	. 
	call sub_6197h		;6115	cd 97 61 	. . a 
	dec hl			;6118	2b 	+ 
	ld (0f7d3h),hl		;6119	22 d3 f7 	" . . 
	dec hl			;611c	2b 	+ 
	dec hl			;611d	2b 	+ 
	ld (0f7d7h),hl		;611e	22 d7 f7 	" . . 
	ret			;6121	c9 	. 
sub_6122h:
	ld hl,(0f351h)		;6122	2a 51 f3 	* Q . 
	ld de,00040h		;6125	11 40 00 	. @ . 
	add hl,de			;6128	19 	. 
	ld a,(hl)			;6129	7e 	~ 
	xor b			;612a	a8 	. 
	ret nz			;612b	c0 	. 
	inc hl			;612c	23 	# 
	ld a,(hl)			;612d	7e 	~ 
	xor c			;612e	a9 	. 
	ret			;612f	c9 	. 
sub_6130h:
	push bc			;6130	c5 	. 
	push de			;6131	d5 	. 
	push af			;6132	f5 	. 
	push hl			;6133	e5 	. 
	call sub_6048h		;6134	cd 48 60 	. H ` 
	ex de,hl			;6137	eb 	. 
	ld (hl),048h		;6138	36 48 	6 H 
	inc hl			;613a	23 	# 
	ld (hl),044h		;613b	36 44 	6 D 
l613dh:
	inc hl			;613d	23 	# 
	ld (hl),052h		;613e	36 52 	6 R 
	inc hl			;6140	23 	# 
	ld (hl),031h		;6141	36 31 	6 1 
	inc hl			;6143	23 	# 
	pop de			;6144	d1 	. 
	ex de,hl			;6145	eb 	. 
	ld bc,l000fh+1		;6146	01 10 00 	. . . 
	ldir		;6149	ed b0 	. . 
	ex de,hl			;614b	eb 	. 
	ld a,(BIOSFN)		;614c	3a 57 f3 	: W . 
	call sub_5f84h		;614f	cd 84 5f 	. . _ 
	ld (hl),a			;6152	77 	w 
	inc hl			;6153	23 	# 
	pop af			;6154	f1 	. 
	ld (hl),a			;6155	77 	w 
	inc hl			;6156	23 	# 
	ld (hl),030h		;6157	36 30 	6 0 
	inc hl			;6159	23 	# 
	ld (hl),030h		;615a	36 30 	6 0 
	inc hl			;615c	23 	# 
	ld (hl),032h		;615d	36 32 	6 2 
	inc hl			;615f	23 	# 
	ld (hl),035h		;6160	36 35 	6 5 
	inc hl			;6162	23 	# 
	ld (hl),036h		;6163	36 36 	6 6 
	inc hl			;6165	23 	# 
	call sub_5f91h		;6166	cd 91 5f 	. . _ 
	pop bc			;6169	c1 	. 
	call sub_5f98h		;616a	cd 98 5f 	. . _ 
	inc hl			;616d	23 	# 
	call sub_5f55h		;616e	cd 55 5f 	. U _ 
	ld de,l0006h		;6171	11 06 00 	. . . 
	add hl,de			;6174	19 	. 
	ld bc,(0f9eah)		;6175	ed 4b ea f9 	. K . . 
	call sub_5f98h		;6179	cd 98 5f 	. . _ 
	ex de,hl			;617c	eb 	. 
	call sub_5f3fh		;617d	cd 3f 5f 	. ? _ 
	ex de,hl			;6180	eb 	. 
	pop bc			;6181	c1 	. 
	call sub_5f98h		;6182	cd 98 5f 	. . _ 
	ex de,hl			;6185	eb 	. 
	call sub_5f44h		;6186	cd 44 5f 	. D _ 
	ld c,048h		;6189	0e 48 	. H 
	ld hl,COLDRST		;618b	21 00 00 	! . . 
	ld (0f7d3h),hl		;618e	22 d3 f7 	" . . 
	call sub_5fech		;6191	cd ec 5f 	. . _ 
	jp nz,sub_61d3h		;6194	c2 d3 61 	. . a 
sub_6197h:
	ld h,a			;6197	67 	g 
	ld l,a			;6198	6f 	o 
	ld (0f7d5h),hl		;6199	22 d5 f7 	" . . 
	ld (0f7d7h),hl		;619c	22 d7 f7 	" . . 
	ld (0f7dfh),hl		;619f	22 df f7 	" . . 
	ld (0f7e1h),hl		;61a2	22 e1 f7 	" . . 
	ld (0f7d9h),a		;61a5	32 d9 f7 	2 . . 
	inc hl			;61a8	23 	# 
	ld (0f7d3h),hl		;61a9	22 d3 f7 	" . . 
	ret			;61ac	c9 	. 
sub_61adh:
	push bc			;61ad	c5 	. 
	push de			;61ae	d5 	. 
	call sub_6048h		;61af	cd 48 60 	. H ` 
	ex de,hl			;61b2	eb 	. 
	ld (hl),045h		;61b3	36 45 	6 E 
	inc hl			;61b5	23 	# 
	ld (hl),04fh		;61b6	36 4f 	6 O 
	inc hl			;61b8	23 	# 
	ld (hl),046h		;61b9	36 46 	6 F 
	inc hl			;61bb	23 	# 
	ld (hl),020h		;61bc	36 20 	6   
	inc hl			;61be	23 	# 
	pop de			;61bf	d1 	. 
	ex de,hl			;61c0	eb 	. 
	ld bc,l000fh+1		;61c1	01 10 00 	. . . 
	ldir		;61c4	ed b0 	. . 
	ex de,hl			;61c6	eb 	. 
	pop bc			;61c7	c1 	. 
	call sub_5f98h		;61c8	cd 98 5f 	. . _ 
	call sub_5f91h		;61cb	cd 91 5f 	. . _ 
	ld c,045h		;61ce	0e 45 	. E 
	jp sub_5fech		;61d0	c3 ec 5f 	. . _ 
sub_61d3h:
	push af			;61d3	f5 	. 
	ld hl,(0f7ceh)		;61d4	2a ce f7 	* . . 
	push hl			;61d7	e5 	. 
	ld a,(BIOSERROR)		;61d8	3a 2b f5 	: + . 
	push af			;61db	f5 	. 
	call 05ea1h		;61dc	cd a1 5e 	. . ^ 
	call 05eadh		;61df	cd ad 5e 	. . ^ 
	pop af			;61e2	f1 	. 
	ld (BIOSERROR),a		;61e3	32 2b f5 	2 + . 
	pop hl			;61e6	e1 	. 
	ld (0f7ceh),hl		;61e7	22 ce f7 	" . . 
	pop af			;61ea	f1 	. 
	ret			;61eb	c9 	. 
sub_61ech:
	call sub_622ah		;61ec	cd 2a 62 	. * b 
	ret nz			;61ef	c0 	. 
	ld a,(0f7dch)		;61f0	3a dc f7 	: . . 
	call sub_628fh		;61f3	cd 8f 62 	. . b 
	ld d,(hl)			;61f6	56 	V 
	inc hl			;61f7	23 	# 
	ld e,(hl)			;61f8	5e 	^ 
	ld hl,(0f2f1h)		;61f9	2a f1 f2 	* . . 
	ex de,hl			;61fc	eb 	. 
	xor a			;61fd	af 	. 
	sbc hl,de		;61fe	ed 52 	. R 
sub_6200h:
	ex de,hl			;6200	eb 	. 
sub_6201h:
	ld hl,05eb0h		;6201	21 b0 5e 	! . ^ 
	jr l620ch		;6204	18 06 	. . 
sub_6206h:
	ld hl,05ea7h		;6206	21 a7 5e 	! . ^ 
	call sub_623ah		;6209	cd 3a 62 	. : b 
l620ch:
	ld a,003h		;620c	3e 03 	> . 
l620eh:
	ld (0f7e4h),a		;620e	32 e4 f7 	2 . . 
	push hl			;6211	e5 	. 
	push de			;6212	d5 	. 
	ld bc,l6218h		;6213	01 18 62 	. . b 
	push bc			;6216	c5 	. 
	jp (hl)			;6217	e9 	. 
l6218h:
	pop de			;6218	d1 	. 
	pop hl			;6219	e1 	. 
	or a			;621a	b7 	. 
	ret z			;621b	c8 	. 
	cp 007h		;621c	fe 07 	. . 
	jr nz,l6228h		;621e	20 08 	  . 
	ld a,(0f7e4h)		;6220	3a e4 f7 	: . . 
	dec a			;6223	3d 	= 
	jr nz,l620eh		;6224	20 e8 	  . 
	ld a,007h		;6226	3e 07 	> . 
l6228h:
	or a			;6228	b7 	. 
	ret			;6229	c9 	. 
sub_622ah:
	ld a,(0efbbh)		;622a	3a bb ef 	: . . 
	and 040h		;622d	e6 40 	. @ 
	ret z			;622f	c8 	. 
	ld a,(0f2fch)		;6230	3a fc f2 	: . . 
	dec a			;6233	3d 	= 
	jr nz,l623dh		;6234	20 07 	  . 
	call sub_6206h		;6236	cd 06 62 	. . b 
	ret nz			;6239	c0 	. 
sub_623ah:
	ld a,(0f2fbh)		;623a	3a fb f2 	: . . 
l623dh:
	ld (0f2fch),a		;623d	32 fc f2 	2 . . 
	xor a			;6240	af 	. 
	ret			;6241	c9 	. 
sub_6242h:
	call 05e9bh		;6242	cd 9b 5e 	. . ^ 
	ld b,h			;6245	44 	D 
	ld c,l			;6246	4d 	M 
	ret			;6247	c9 	. 
sub_6248h:
	ld de,COLDRST		;6248	11 00 00 	. . . 
	jp 05e9eh		;624b	c3 9e 5e 	. . ^ 
sub_624eh:
	call 05eb9h		;624e	cd b9 5e 	. . ^ 
	or a			;6251	b7 	. 
	ret			;6252	c9 	. 
sub_6253h:
	push de			;6253	d5 	. 
	ld hl,0f9e2h		;6254	21 e2 f9 	! . . 
	ld bc,00034h		;6257	01 34 00 	. 4 . 
	call sub_5f89h		;625a	cd 89 5f 	. . _ 
	ld de,0f9e2h		;625d	11 e2 f9 	. . . 
	pop hl			;6260	e1 	. 
	call sub_63f4h		;6261	cd f4 63 	. . c 
	ld de,0f9ech		;6264	11 ec f9 	. . . 
	call sub_5f44h		;6267	cd 44 5f 	. D _ 
	ld hl,0f9f4h		;626a	21 f4 f9 	! . . 
	jp sub_5f55h		;626d	c3 55 5f 	. U _ 
sub_6270h:
	ld hl,0fa17h		;6270	21 17 fa 	! . . 
	ld bc,0017fh		;6273	01 7f 01 	.  . 
	ld a,0ffh		;6276	3e ff 	> . 
	jp l5f8ah		;6278	c3 8a 5f 	. . _ 
sub_627bh:
	ld hl,COLDRST		;627b	21 00 00 	! . . 
	jr l62b0h		;627e	18 30 	. 0 
sub_6280h:
	ld hl,l0003h		;6280	21 03 00 	! . . 
	jr l62b0h		;6283	18 2b 	. + 
sub_6285h:
	ld hl,l0018h		;6285	21 18 00 	! . . 
	jr l62b0h		;6288	18 26 	. & 
sub_628ah:
	ld hl,l000fh		;628a	21 0f 00 	! . . 
	jr l62b0h		;628d	18 21 	. ! 
sub_628fh:
	ld hl,l0009h		;628f	21 09 00 	! . . 
	jr l62b0h		;6292	18 1c 	. . 
sub_6294h:
	ld hl,l0009h+2		;6294	21 0b 00 	! . . 
	jr l62b0h		;6297	18 17 	. . 
sub_6299h:
	ld hl,RBDOS1		;6299	21 05 00 	! . . 
	jr l62b0h		;629c	18 12 	. . 
sub_629eh:
	ld hl,l000fh+1		;629e	21 10 00 	! . . 
	jr l62b0h		;62a1	18 0d 	. . 
sub_62a3h:
	ld hl,l000ch+1		;62a3	21 0d 00 	! . . 
	jr l62b0h		;62a6	18 08 	. . 
sub_62a8h:
	ld hl,l0006h+1		;62a8	21 07 00 	! . . 
	jr l62b0h		;62ab	18 03 	. . 
sub_62adh:
	ld hl,l0001h+1		;62ad	21 02 00 	! . . 
l62b0h:
	push de			;62b0	d5 	. 
	push af			;62b1	f5 	. 
	ld de,0fa17h		;62b2	11 17 fa 	. . . 
	add hl,de			;62b5	19 	. 
	dec a			;62b6	3d 	= 
	ld e,a			;62b7	5f 	_ 
	ld d,000h		;62b8	16 00 	. . 
	ld a,005h		;62ba	3e 05 	> . 
l62bch:
	sla e		;62bc	cb 23 	. # 
	rl d		;62be	cb 12 	. . 
	dec a			;62c0	3d 	= 
	jr nz,l62bch		;62c1	20 f9 	  . 
	add hl,de			;62c3	19 	. 
	pop af			;62c4	f1 	. 
	pop de			;62c5	d1 	. 
	ret			;62c6	c9 	. 
sub_62c7h:
	push hl			;62c7	e5 	. 
	ld hl,(0f7ddh)		;62c8	2a dd f7 	* . . 
	push hl			;62cb	e5 	. 
	call sub_62d5h		;62cc	cd d5 62 	. . b 
	pop hl			;62cf	e1 	. 
	ld (0f7ddh),hl		;62d0	22 dd f7 	" . . 
	pop hl			;62d3	e1 	. 
	ret			;62d4	c9 	. 
sub_62d5h:
	push hl			;62d5	e5 	. 
	ld hl,(0f4e3h)		;62d6	2a e3 f4 	* . . 
	ld (0f7ddh),hl		;62d9	22 dd f7 	" . . 
	pop hl			;62dc	e1 	. 
	ld a,00dh		;62dd	3e 0d 	> . 
	ld (0f7dbh),a		;62df	32 db f7 	2 . . 
sub_62e2h:
	push hl			;62e2	e5 	. 
	push de			;62e3	d5 	. 
	push bc			;62e4	c5 	. 
l62e5h:
	ld a,(0f7dbh)		;62e5	3a db f7 	: . . 
	dec a			;62e8	3d 	= 
	jr z,l6304h		;62e9	28 19 	( . 
	ld (0f7dbh),a		;62eb	32 db f7 	2 . . 
	call sub_62adh		;62ee	cd ad 62 	. . b 
	ld b,(hl)			;62f1	46 	F 
	inc b			;62f2	04 	. 
	jr z,l62e5h		;62f3	28 f0 	( . 
	ld c,a			;62f5	4f 	O 
	ld hl,(0f7ddh)		;62f6	2a dd f7 	* . . 
	ld a,(hl)			;62f9	7e 	~ 
	cp 03fh		;62fa	fe 3f 	. ? 
	ld a,c			;62fc	79 	y 
	jr z,l6304h		;62fd	28 05 	( . 
	call sub_6309h		;62ff	cd 09 63 	. . c 
	jr nz,l62e5h		;6302	20 e1 	  . 
l6304h:
	or a			;6304	b7 	. 
	pop bc			;6305	c1 	. 
	pop de			;6306	d1 	. 
	pop hl			;6307	e1 	. 
	ret			;6308	c9 	. 
sub_6309h:
	call sub_628ah		;6309	cd 8a 62 	. . b 
	ld b,(hl)			;630c	46 	F 
	ld c,a			;630d	4f 	O 
	ld a,(0f31ch)		;630e	3a 1c f3 	: . . 
	cp b			;6311	b8 	. 
	ld a,c			;6312	79 	y 
	ret nz			;6313	c0 	. 
	inc hl			;6314	23 	# 
	ld de,(0f7ddh)		;6315	ed 5b dd f7 	. [ . . 
	inc de			;6319	13 	. 
	ld b,00bh		;631a	06 0b 	. . 
l631ch:
	push af			;631c	f5 	. 
l631dh:
	ld a,(de)			;631d	1a 	. 
	and 07fh		;631e	e6 7f 	.  
	cp 03fh		;6320	fe 3f 	. ? 
	jr z,l632bh		;6322	28 07 	( . 
	ld c,a			;6324	4f 	O 
	ld a,(hl)			;6325	7e 	~ 
	and 07fh		;6326	e6 7f 	.  
	cp c			;6328	b9 	. 
	jr nz,l632fh		;6329	20 04 	  . 
l632bh:
	inc hl			;632b	23 	# 
	inc de			;632c	13 	. 
	djnz l631dh		;632d	10 ee 	. . 
l632fh:
	pop af			;632f	f1 	. 
	inc b			;6330	04 	. 
	dec b			;6331	05 	. 
	ret			;6332	c9 	. 
sub_6333h:
	ld a,(0fa13h)		;6333	3a 13 fa 	: . . 
	and 040h		;6336	e6 40 	. @ 
	jr z,l633fh		;6338	28 05 	( . 
	ld de,(0f7e7h)		;633a	ed 5b e7 f7 	. [ . . 
l633eh:
	ret			;633e	c9 	. 
l633fh:
	ld a,00dh		;633f	3e 0d 	> . 
	ld hl,(0f2ebh)		;6341	2a eb f2 	* . . 
	ld de,(0f2edh)		;6344	ed 5b ed f2 	. [ . . 
	add hl,de			;6348	19 	. 
l6349h:
	ld (0f7e5h),hl		;6349	22 e5 f7 	" . . 
l634ch:
	dec a			;634c	3d 	= 
	jr z,l6367h		;634d	28 18 	( . 
	call sub_62adh		;634f	cd ad 62 	. . b 
	ld c,(hl)			;6352	4e 	N 
	inc c			;6353	0c 	. 
	jr z,l634ch		;6354	28 f6 	( . 
	call sub_6294h		;6356	cd 94 62 	. . b 
	ld d,(hl)			;6359	56 	V 
	inc hl			;635a	23 	# 
	ld e,(hl)			;635b	5e 	^ 
	ld hl,(0f7e5h)		;635c	2a e5 f7 	* . . 
	or a			;635f	b7 	. 
	sbc hl,de		;6360	ed 52 	. R 
	jr nc,l634ch		;6362	30 e8 	0 . 
	ex de,hl			;6364	eb 	. 
	jr l6349h		;6365	18 e2 	. . 
l6367h:
	ld hl,(0f7e5h)		;6367	2a e5 f7 	* . . 
	ld bc,(0f2efh)		;636a	ed 4b ef f2 	. K . . 
	add hl,bc			;636e	09 	. 
	ex de,hl			;636f	eb 	. 
	ret			;6370	c9 	. 
sub_6371h:
	ld a,00dh		;6371	3e 0d 	> . 
l6373h:
	dec a			;6373	3d 	= 
	ret z			;6374	c8 	. 
	call sub_62adh		;6375	cd ad 62 	. . b 
	ld c,(hl)			;6378	4e 	N 
	inc c			;6379	0c 	. 
	ret z			;637a	c8 	. 
	jr l6373h		;637b	18 f6 	. . 
sub_637dh:
	ld b,0ffh		;637d	06 ff 	. . 
	ld hl,(l0006h)		;637f	2a 06 00 	* . . 
	push bc			;6382	c5 	. 
	call sub_629eh		;6383	cd 9e 62 	. . b 
	ld de,(0f4e3h)		;6386	ed 5b e3 f4 	. [ . . 
	inc de			;638a	13 	. 
	pop bc			;638b	c1 	. 
	inc b			;638c	04 	. 
	jr z,l6390h		;638d	28 01 	( . 
	ex de,hl			;638f	eb 	. 
l6390h:
	ld bc,l0009h+2		;6390	01 0b 00 	. . . 
	ldir		;6393	ed b0 	. . 
	ret			;6395	c9 	. 
sub_6396h:
	push hl			;6396	e5 	. 
	ld a,(0f7dch)		;6397	3a dc f7 	: . . 
	call sub_627bh		;639a	cd 7b 62 	. { b 
	ld bc,(0fa15h)		;639d	ed 4b 15 fa 	. K . . 
	call sub_5f98h		;63a1	cd 98 5f 	. . _ 
	ld (hl),000h		;63a4	36 00 	6 . 
	ld de,(TACATR)		;63a6	ed 5b d1 f7 	. [ . . 
	inc hl			;63aa	23 	# 
	ld (hl),e			;63ab	73 	s 
	inc hl			;63ac	23 	# 
	call sub_628fh		;63ad	cd 8f 62 	. . b 
	pop bc			;63b0	c1 	. 
	call sub_5f98h		;63b1	cd 98 5f 	. . _ 
	xor a			;63b4	af 	. 
	inc hl			;63b5	23 	# 
	inc hl			;63b6	23 	# 
	ld (hl),a			;63b7	77 	w 
	inc hl			;63b8	23 	# 
	ld (hl),a			;63b9	77 	w 
	ld a,(0f31ch)		;63ba	3a 1c f3 	: . . 
	inc hl			;63bd	23 	# 
	ld (hl),a			;63be	77 	w 
sub_63bfh:
	call sub_6242h		;63bf	cd 42 62 	. B b 
	ex de,hl			;63c2	eb 	. 
	ld a,(0f7dch)		;63c3	3a dc f7 	: . . 
	call sub_6299h		;63c6	cd 99 62 	. . b 
	ld bc,(0f7dfh)		;63c9	ed 4b df f7 	. K . . 
	call sub_5f98h		;63cd	cd 98 5f 	. . _ 
	ld bc,(0f7e1h)		;63d0	ed 4b e1 f7 	. K . . 
	call sub_5f98h		;63d4	cd 98 5f 	. . _ 
	inc hl			;63d7	23 	# 
	inc hl			;63d8	23 	# 
	ld (hl),d			;63d9	72 	r 
	inc hl			;63da	23 	# 
	ld (hl),e			;63db	73 	s 
sub_63dch:
	ld a,(0f7dch)		;63dc	3a dc f7 	: . . 
sub_63dfh:
	ld de,(0f4e3h)		;63df	ed 5b e3 f4 	. [ . . 
	ld hl,l000ch+1		;63e3	21 0d 00 	! . . 
	add hl,de			;63e6	19 	. 
	ld (hl),000h		;63e7	36 00 	6 . 
	inc hl			;63e9	23 	# 
	ld (hl),000h		;63ea	36 00 	6 . 
	ld hl,l0015h		;63ec	21 15 00 	! . . 
	add hl,de			;63ef	19 	. 
	ex de,hl			;63f0	eb 	. 
	call sub_6280h		;63f1	cd 80 62 	. . b 
sub_63f4h:
	ld bc,l0009h+1		;63f4	01 0a 00 	. . . 
	ldir		;63f7	ed b0 	. . 
	ret			;63f9	c9 	. 
l63fah:
	ld bc,(0f7d5h)		;63fa	ed 4b d5 f7 	. K . . 
	inc bc			;63fe	03 	. 
l63ffh:
	ld a,c			;63ff	79 	y 
	and 07fh		;6400	e6 7f 	.  
	sla c		;6402	cb 21 	. ! 
	rl b		;6404	cb 10 	. . 
l6406h:
	call sub_643ah		;6406	cd 3a 64 	. : d 
	ld (hl),a			;6409	77 	w 
sub_640ah:
	call sub_643fh		;640a	cd 3f 64 	. ? d 
	ld (hl),b			;640d	70 	p 
	inc hl			;640e	23 	# 
	inc hl			;640f	23 	# 
	inc hl			;6410	23 	# 
	ld (hl),a			;6411	77 	w 
	ret			;6412	c9 	. 
sub_6413h:
	ld a,(0f7e9h)		;6413	3a e9 f7 	: . . 
	and 080h		;6416	e6 80 	. . 
	jr z,l6423h		;6418	28 09 	( . 
	call sub_643ah		;641a	cd 3a 64 	. : d 
	inc hl			;641d	23 	# 
	ld c,(hl)			;641e	4e 	N 
	inc hl			;641f	23 	# 
	ld b,(hl)			;6420	46 	F 
	jr l6431h		;6421	18 0e 	. . 
l6423h:
	call sub_643fh		;6423	cd 3f 64 	. ? d 
	ld b,(hl)			;6426	46 	F 
	call sub_643ah		;6427	cd 3a 64 	. : d 
	ld c,(hl)			;642a	4e 	N 
	rlc c		;642b	cb 01 	. . 
	rr b		;642d	cb 18 	. . 
	rr c		;642f	cb 19 	. . 
l6431h:
	ld (0f7d5h),bc		;6431	ed 43 d5 f7 	. C . . 
	ret			;6435	c9 	. 
l6436h:
	xor a			;6436	af 	. 
	ld b,a			;6437	47 	G 
	jr l6406h		;6438	18 cc 	. . 
sub_643ah:
	ld de,l001eh+2		;643a	11 20 00 	.   . 
	jr l6442h		;643d	18 03 	. . 
sub_643fh:
	ld de,l000ch		;643f	11 0c 00 	. . . 
l6442h:
	ld hl,(0f4e3h)		;6442	2a e3 f4 	* . . 
	add hl,de			;6445	19 	. 
	ret			;6446	c9 	. 
l6447h:
	call sub_628ah		;6447	cd 8a 62 	. . b 
	ld b,(hl)			;644a	46 	F 
	ld hl,(0f323h)		;644b	2a 23 f3 	* # . 
	ld (hl),b			;644e	70 	p 
	ex de,hl			;644f	eb 	. 
	call sub_629eh		;6450	cd 9e 62 	. . b 
	inc de			;6453	13 	. 
	call l6390h		;6454	cd 90 63 	. . c 
	ld hl,(0f4e3h)		;6457	2a e3 f4 	* . . 
	push hl			;645a	e5 	. 
	ld hl,(0f323h)		;645b	2a 23 f3 	* # . 
	ld (0f4e3h),hl		;645e	22 e3 f4 	" . . 
	call sub_63dfh		;6461	cd df 63 	. . c 
	call sub_62a8h		;6464	cd a8 62 	. . b 
	ld b,(hl)			;6467	46 	F 
	inc hl			;6468	23 	# 
	ld a,(hl)			;6469	7e 	~ 
	or a			;646a	b7 	. 
	rl a		;646b	cb 17 	. . 
	rl b		;646d	cb 10 	. . 
	rrc a		;646f	cb 0f 	. . 
	call sub_640ah		;6471	cd 0a 64 	. . d 
	pop hl			;6474	e1 	. 
	ld (0f4e3h),hl		;6475	22 e3 f4 	" . . 
	xor a			;6478	af 	. 
	ret			;6479	c9 	. 
sub_647ah:
	ld a,(TAPMOD)		;647a	3a e1 f2 	: . . 
	or a			;647d	b7 	. 
	ret			;647e	c9 	. 
sub_647fh:
	ld a,(OPNMOD)		;647f	3a 55 f3 	: U . 
	or a			;6482	b7 	. 
	rra			;6483	1f 	. 
	ret			;6484	c9 	. 
sub_6485h:
	ld hl,(0f4e3h)		;6485	2a e3 f4 	* . . 
	ld (0f7ddh),hl		;6488	22 dd f7 	" . . 
	ld a,(0f7dch)		;648b	3a dc f7 	: . . 
	jp sub_6309h		;648e	c3 09 63 	. . c 
sub_6491h:
	push hl			;6491	e5 	. 
	call sub_6285h		;6492	cd 85 62 	. . b 
	ld a,(hl)			;6495	7e 	~ 
	cpl			;6496	2f 	/ 
	and 080h		;6497	e6 80 	. . 
	ld a,(0f2e3h)		;6499	3a e3 f2 	: . . 
	rra			;649c	1f 	. 
	pop hl			;649d	e1 	. 
	ret			;649e	c9 	. 
l649fh:
	call sub_647ah		;649f	cd 7a 64 	. z d 
	jp nz,l5ef0h		;64a2	c2 f0 5e 	. . ^ 
	call sub_6253h		;64a5	cd 53 62 	. S b 
	call sub_6270h		;64a8	cd 70 62 	. p b 
	call sub_657fh		;64ab	cd 7f 65 	.  e 
	ret nz			;64ae	c0 	. 
	ld h,a			;64af	67 	g 
	ld l,a			;64b0	6f 	o 
	ld (0fa15h),hl		;64b1	22 15 fa 	" . . 
	jp l6528h		;64b4	c3 28 65 	. ( e 
sub_64b7h:
	call sub_647ah		;64b7	cd 7a 64 	. z d 
	ret z			;64ba	c8 	. 
	ld hl,0f9e2h		;64bb	21 e2 f9 	! . . 
	ld de,(0f323h)		;64be	ed 5b 23 f3 	. [ # . 
	ld bc,00035h		;64c2	01 35 00 	. 5 . 
	ldir		;64c5	ed b0 	. . 
	ld a,0ffh		;64c7	3e ff 	> . 
	ret			;64c9	c9 	. 
l64cah:
	call sub_647ah		;64ca	cd 7a 64 	. z d 
	jp nz,l5ef0h		;64cd	c2 f0 5e 	. . ^ 
sub_64d0h:
	call sub_60ech		;64d0	cd ec 60 	. . ` 
	jr nz,l654ch		;64d3	20 77 	  w 
	ld bc,0ffffh		;64d5	01 ff ff 	. . . 
	call sub_6122h		;64d8	cd 22 61 	. " a 
	jp nz,l654ch		;64db	c2 4c 65 	. L e 
	call sub_5fdah		;64de	cd da 5f 	. . _ 
	jr nz,l654ch		;64e1	20 69 	  i 
	call sub_6048h		;64e3	cd 48 60 	. H ` 
	ld hl,0f9e2h		;64e6	21 e2 f9 	! . . 
	ex de,hl			;64e9	eb 	. 
	ld bc,00035h		;64ea	01 35 00 	. 5 . 
	ldir		;64ed	ed b0 	. . 
	call sub_5fdah		;64ef	cd da 5f 	. . _ 
	jr nz,l654ch		;64f2	20 58 	  X 
	call sub_6048h		;64f4	cd 48 60 	. H ` 
	ld hl,0fa17h		;64f7	21 17 fa 	! . . 
	ex de,hl			;64fa	eb 	. 
	ld bc,l00ffh+1		;64fb	01 00 01 	. . . 
	ldir		;64fe	ed b0 	. . 
	call sub_5fdah		;6500	cd da 5f 	. . _ 
	jr nz,l654ch		;6503	20 47 	  G 
	call sub_6048h		;6505	cd 48 60 	. H ` 
	ld hl,0fb17h		;6508	21 17 fb 	! . . 
	ex de,hl			;650b	eb 	. 
	ld bc,l007fh+1		;650c	01 80 00 	. . . 
	ldir		;650f	ed b0 	. . 
	ld hl,(0fa0ch)		;6511	2a 0c fa 	* . . 
	inc hl			;6514	23 	# 
	ld (0fa0ch),hl		;6515	22 0c fa 	" . . 
	ld b,050h		;6518	06 50 	. P 
	ld a,(0fa13h)		;651a	3a 13 fa 	: . . 
	and 080h		;651d	e6 80 	. . 
	ld a,b			;651f	78 	x 
	jr z,l6525h		;6520	28 03 	( . 
	ld a,(0fa14h)		;6522	3a 14 fa 	: . . 
l6525h:
	ld (0efbbh),a		;6525	32 bb ef 	2 . . 
l6528h:
	call 05ebfh		;6528	cd bf 5e 	. . ^ 
sub_652bh:
	call sub_61d3h		;652b	cd d3 61 	. . a 
sub_652eh:
	xor a			;652e	af 	. 
	ld (OPNMOD),a		;652f	32 55 f3 	2 U . 
	ld (0f7e3h),a		;6532	32 e3 f7 	2 . . 
	inc a			;6535	3c 	< 
	ld (TAPMOD),a		;6536	32 e1 f2 	2 . . 
	xor a			;6539	af 	. 
	ret			;653a	c9 	. 
sub_653bh:
	ld a,(0efbbh)		;653b	3a bb ef 	: . . 
	and 010h		;653e	e6 10 	. . 
	ret z			;6540	c8 	. 
	call sub_647ah		;6541	cd 7a 64 	. z d 
	ret nz			;6544	c0 	. 
	call sub_64d0h		;6545	cd d0 64 	. . d 
	or a			;6548	b7 	. 
	ret z			;6549	c8 	. 
	pop hl			;654a	e1 	. 
	ret			;654b	c9 	. 
l654ch:
	call sub_6a9fh		;654c	cd 9f 6a 	. . j 
	call 05ef9h		;654f	cd f9 5e 	. . ^ 
	ld a,(0efbdh)		;6552	3a bd ef 	: . . 
	and 008h		;6555	e6 08 	. . 
	ret nz			;6557	c0 	. 
	call sub_6af5h		;6558	cd f5 6a 	. . j 
	jp 01eeeh		;655b	c3 ee 1e 	. . . 
sub_655eh:
	call sub_647ah		;655e	cd 7a 64 	. z d 
	ret nz			;6561	c0 	. 
	jp sub_64d0h		;6562	c3 d0 64 	. . d 
l6565h:
	call sub_647ah		;6565	cd 7a 64 	. z d 
	jp z,05ef3h		;6568	ca f3 5e 	. . ^ 
	ld a,(OPNMOD)		;656b	3a 55 f3 	: U . 
	dec a			;656e	3d 	= 
	dec a			;656f	3d 	= 
	jp z,05ef6h		;6570	ca f6 5e 	. . ^ 
	ld a,(0f7e3h)		;6573	3a e3 f7 	: . . 
	or a			;6576	b7 	. 
	jr z,l65e5h		;6577	28 6c 	( l 
	call sub_65f4h		;6579	cd f4 65 	. . e 
	jp nz,05f20h		;657c	c2 20 5f 	.   _ 
sub_657fh:
	call sub_60e6h		;657f	cd e6 60 	. . ` 
	call sub_6206h		;6582	cd 06 62 	. . b 
	ret nz			;6585	c0 	. 
	ld hl,(0f2e7h)		;6586	2a e7 f2 	* . . 
	ld de,l0006h+1		;6589	11 07 00 	. . . 
	or a			;658c	b7 	. 
	sbc hl,de		;658d	ed 52 	. R 
	push hl			;658f	e5 	. 
	call sub_6200h		;6590	cd 00 62 	. . b 
	pop de			;6593	d1 	. 
	ret nz			;6594	c0 	. 
	ld hl,(0f2e9h)		;6595	2a e9 f2 	* . . 
	sbc hl,de		;6598	ed 52 	. R 
	call sub_5ff3h		;659a	cd f3 5f 	. . _ 
	ret nz			;659d	c0 	. 
	ld de,04200h		;659e	11 00 42 	. . B 
	ld hl,l7fe8h		;65a1	21 e8 7f 	! .  
	ld bc,0ffffh		;65a4	01 ff ff 	. . . 
	ld a,053h		;65a7	3e 53 	> S 
	call sub_6130h		;65a9	cd 30 61 	. 0 a 
	or a			;65ac	b7 	. 
	ret nz			;65ad	c0 	. 
	ld hl,0fa00h		;65ae	21 00 fa 	! . . 
	call sub_5f55h		;65b1	cd 55 5f 	. U _ 
	call sub_6048h		;65b4	cd 48 60 	. H ` 
	ld hl,0f9e2h		;65b7	21 e2 f9 	! . . 
	ld bc,00035h		;65ba	01 35 00 	. 5 . 
	call sub_5fe4h		;65bd	cd e4 5f 	. . _ 
	ret nz			;65c0	c0 	. 
	call sub_6048h		;65c1	cd 48 60 	. H ` 
	ld hl,0fa17h		;65c4	21 17 fa 	! . . 
	ld bc,l00ffh+1		;65c7	01 00 01 	. . . 
	call sub_5fe4h		;65ca	cd e4 5f 	. . _ 
	ret nz			;65cd	c0 	. 
	call sub_6048h		;65ce	cd 48 60 	. H ` 
	ld hl,0fb17h		;65d1	21 17 fb 	! . . 
	ld bc,l007fh+1		;65d4	01 80 00 	. . . 
	call sub_5fe4h		;65d7	cd e4 5f 	. . _ 
	ret nz			;65da	c0 	. 
	ld de,l7fe8h		;65db	11 e8 7f 	. .  
	ld bc,0ffffh		;65de	01 ff ff 	. . . 
	call sub_61adh		;65e1	cd ad 61 	. . a 
	ret nz			;65e4	c0 	. 
l65e5h:
	call 05ebch		;65e5	cd bc 5e 	. . ^ 
	call sub_652bh		;65e8	cd 2b 65 	. + e 
l65ebh:
	ld (TAPMOD),a		;65eb	32 e1 f2 	2 . . 
	ret			;65ee	c9 	. 
sub_65efh:
	call sub_652eh		;65ef	cd 2e 65 	. . e 
	jr l65ebh		;65f2	18 f7 	. . 
sub_65f4h:
	ld a,(0efbbh)		;65f4	3a bb ef 	: . . 
	and 008h		;65f7	e6 08 	. . 
	ret z			;65f9	c8 	. 
	call sub_60ech		;65fa	cd ec 60 	. . ` 
	ret nz			;65fd	c0 	. 
	call sub_5fdah		;65fe	cd da 5f 	. . _ 
	ret nz			;6601	c0 	. 
	ld hl,(0f351h)		;6602	2a 51 f3 	* Q . 
	ld de,l0015h+1		;6605	11 16 00 	. . . 
	add hl,de			;6608	19 	. 
	ex de,hl			;6609	eb 	. 
	ld hl,0f9f4h		;660a	21 f4 f9 	! . . 
	ld b,00ch		;660d	06 0c 	. . 
	jp l631ch		;660f	c3 1c 63 	. . c 
sub_6612h:
	call sub_653bh		;6612	cd 3b 65 	. ; e 
	call sub_647fh		;6615	cd 7f 64 	.  d 
	jr z,l661dh		;6618	28 03 	( . 
	jp nc,05f08h		;661a	d2 08 5f 	. . _ 
l661dh:
	call sub_62c7h		;661d	cd c7 62 	. . b 
	jp z,05f05h		;6620	ca 05 5f 	. . _ 
	ld (0f7dch),a		;6623	32 dc f7 	2 . . 
	call sub_61ech		;6626	cd ec 61 	. . a 
	jr nz,l662fh		;6629	20 04 	  . 
	call sub_60fah		;662b	cd fa 60 	. . ` 
	or a			;662e	b7 	. 
l662fh:
	jp nz,05f05h		;662f	c2 05 5f 	. . _ 
	ld a,(0f7dch)		;6632	3a dc f7 	: . . 
	call sub_627bh		;6635	cd 7b 62 	. { b 
	ld b,(hl)			;6638	46 	F 
	inc hl			;6639	23 	# 
	ld c,(hl)			;663a	4e 	N 
	call sub_6122h		;663b	cd 22 61 	. " a 
	jp nz,05f1dh		;663e	c2 1d 5f 	. . _ 
	ld a,(0f7dch)		;6641	3a dc f7 	: . . 
	call sub_62a3h		;6644	cd a3 62 	. . b 
	ld b,(hl)			;6647	46 	F 
	inc hl			;6648	23 	# 
	ld c,(hl)			;6649	4e 	N 
	inc bc			;664a	03 	. 
	ld (hl),c			;664b	71 	q 
	dec hl			;664c	2b 	+ 
	ld (hl),b			;664d	70 	p 
	call sub_6299h		;664e	cd 99 62 	. . b 
	ld b,(hl)			;6651	46 	F 
	inc hl			;6652	23 	# 
	ld c,(hl)			;6653	4e 	N 
	ld (0f7dfh),bc		;6654	ed 43 df f7 	. C . . 
	inc hl			;6658	23 	# 
	ld a,(hl)			;6659	7e 	~ 
	inc hl			;665a	23 	# 
	ld l,(hl)			;665b	6e 	n 
	ld h,a			;665c	67 	g 
	ld (0f7e1h),hl		;665d	22 e1 f7 	" . . 
	ld a,(0efbbh)		;6660	3a bb ef 	: . . 
	and 020h		;6663	e6 20 	.   
	ld a,(TACATR)		;6665	3a d1 f7 	: . . 
	jr nz,l6671h		;6668	20 07 	  . 
	ld a,(0f7dch)		;666a	3a dc f7 	: . . 
	call sub_6280h		;666d	cd 80 62 	. . b 
	ld a,(hl)			;6670	7e 	~ 
l6671h:
	ld (0f7d2h),a		;6671	32 d2 f7 	2 . . 
	call sub_63dch		;6674	cd dc 63 	. . c 
	call sub_637dh		;6677	cd 7d 63 	. } c 
	ld de,(0f4e3h)		;667a	ed 5b e3 f4 	. [ . . 
	ld hl,l000ch		;667e	21 0c 00 	! . . 
	add hl,de			;6681	19 	. 
	ld bc,(0f7e1h)		;6682	ed 4b e1 f7 	. K . . 
	ld a,b			;6686	78 	x 
	rlc c		;6687	cb 01 	. . 
	rla			;6689	17 	. 
	srl c		;668a	cb 39 	. 9 
	cp (hl)			;668c	be 	. 
	ld a,c			;668d	79 	y 
	jr z,l6696h		;668e	28 06 	( . 
	ld a,000h		;6690	3e 00 	> . 
	jr c,l6696h		;6692	38 02 	8 . 
	ld a,080h		;6694	3e 80 	> . 
l6696h:
	ld hl,l000fh		;6696	21 0f 00 	! . . 
	add hl,de			;6699	19 	. 
	ld (hl),a			;669a	77 	w 
	ld a,001h		;669b	3e 01 	> . 
	ld (OPNMOD),a		;669d	32 55 f3 	2 U . 
	xor a			;66a0	af 	. 
	ret			;66a1	c9 	. 
l66a2h:
	call sub_647ah		;66a2	cd 7a 64 	. z d 
	jp z,05ef3h		;66a5	ca f3 5e 	. . ^ 
	call sub_647fh		;66a8	cd 7f 64 	.  d 
	jp z,05f05h		;66ab	ca 05 5f 	. . _ 
	call sub_6485h		;66ae	cd 85 64 	. . d 
	jp nz,05f05h		;66b1	c2 05 5f 	. . _ 
	call sub_647fh		;66b4	cd 7f 64 	.  d 
	jr c,l66e7h		;66b7	38 2e 	8 . 
	ld a,(0f7d9h)		;66b9	3a d9 f7 	: . . 
	or a			;66bc	b7 	. 
	jr z,l66c8h		;66bd	28 09 	( . 
	call sub_5fc9h		;66bf	cd c9 5f 	. . _ 
	call sub_6002h		;66c2	cd 02 60 	. . ` 
	call sub_600ah		;66c5	cd 0a 60 	. . ` 
l66c8h:
	ld a,(0f7dch)		;66c8	3a dc f7 	: . . 
	call sub_629eh		;66cb	cd 9e 62 	. . b 
	ex de,hl			;66ce	eb 	. 
	call sub_627bh		;66cf	cd 7b 62 	. { b 
	ld b,(hl)			;66d2	46 	F 
	inc hl			;66d3	23 	# 
	ld c,(hl)			;66d4	4e 	N 
	call sub_61adh		;66d5	cd ad 61 	. . a 
	or a			;66d8	b7 	. 
	ret nz			;66d9	c0 	. 
	call sub_63bfh		;66da	cd bf 63 	. . c 
	ld hl,(0f2f5h)		;66dd	2a f5 f2 	* . . 
	call sub_5ff3h		;66e0	cd f3 5f 	. . _ 
	ret nz			;66e3	c0 	. 
	call sub_68fdh		;66e4	cd fd 68 	. . h 
l66e7h:
	call sub_61d3h		;66e7	cd d3 61 	. . a 
sub_66eah:
	xor a			;66ea	af 	. 
	ld (OPNMOD),a		;66eb	32 55 f3 	2 U . 
	ld (0f7dch),a		;66ee	32 dc f7 	2 . . 
	ret			;66f1	c9 	. 
sub_66f2h:
	ld (0f7ddh),de		;66f2	ed 53 dd f7 	. S . . 
	call sub_653bh		;66f6	cd 3b 65 	. ; e 
	call sub_62d5h		;66f9	cd d5 62 	. . b 
	jr l6704h		;66fc	18 06 	. . 
sub_66feh:
	call sub_653bh		;66fe	cd 3b 65 	. ; e 
	call sub_62e2h		;6701	cd e2 62 	. . b 
l6704h:
	push af			;6704	f5 	. 
	ld hl,(0f323h)		;6705	2a 23 f3 	* # . 
	ld bc,l007fh		;6708	01 7f 00 	.  . 
	ld a,0e5h		;670b	3e e5 	> . 
	call l5f8ah		;670d	cd 8a 5f 	. . _ 
	pop af			;6710	f1 	. 
	jp nz,l6447h		;6711	c2 47 64 	. G d 
	ld a,0ffh		;6714	3e ff 	> . 
	ret			;6716	c9 	. 
sub_6717h:
	call sub_653bh		;6717	cd 3b 65 	. ; e 
	call sub_624eh		;671a	cd 4e 62 	. N b 
	ret nz			;671d	c0 	. 
	ld a,0ffh		;671e	3e ff 	> . 
l6720h:
	ld (0f4e5h),a		;6720	32 e5 f4 	2 . . 
	call sub_62c7h		;6723	cd c7 62 	. . b 
	ret z			;6726	c8 	. 
	ld b,a			;6727	47 	G 
	call sub_6491h		;6728	cd 91 64 	. . d 
	jp z,05effh		;672b	ca ff 5e 	. . ^ 
	jp c,05f17h		;672e	da 17 5f 	. . _ 
	ld a,b			;6731	78 	x 
	call sub_6299h		;6732	cd 99 62 	. . b 
	ld d,(hl)			;6735	56 	V 
	inc hl			;6736	23 	# 
	ld e,(hl)			;6737	5e 	^ 
	or a			;6738	b7 	. 
	ld hl,(0fa0eh)		;6739	2a 0e fa 	* . . 
	sbc hl,de		;673c	ed 52 	. R 
	ld (0fa0eh),hl		;673e	22 0e fa 	" . . 
	call sub_62a8h		;6741	cd a8 62 	. . b 
	ld d,(hl)			;6744	56 	V 
	inc hl			;6745	23 	# 
	ld e,(hl)			;6746	5e 	^ 
	or a			;6747	b7 	. 
	ld hl,(0fa10h)		;6748	2a 10 fa 	* . . 
	sbc hl,de		;674b	ed 52 	. R 
	ld (0fa10h),hl		;674d	22 10 fa 	" . . 
	call sub_62adh		;6750	cd ad 62 	. . b 
	ld a,0ffh		;6753	3e ff 	> . 
	ld (hl),a			;6755	77 	w 
	ld (0f7e3h),a		;6756	32 e3 f7 	2 . . 
	ld hl,0fa12h		;6759	21 12 fa 	! . . 
	dec (hl)			;675c	35 	5 
	xor a			;675d	af 	. 
	jr l6720h		;675e	18 c0 	. . 
sub_6760h:
	xor a			;6760	af 	. 
	ld hl,(0013eh)		;6761	2a 3e 01 	* > . 
	ld hl,(0803eh)		;6764	2a 3e 80 	* > . 
	ld hl,(0813eh)		;6767	2a 3e 81 	* > . 
	ld (0f7e9h),a		;676a	32 e9 f7 	2 . . 
	call sub_653bh		;676d	cd 3b 65 	. ; e 
	call sub_647fh		;6770	cd 7f 64 	.  d 
	jp z,05f0bh		;6773	ca 0b 5f 	. . _ 
	call sub_6485h		;6776	cd 85 64 	. . d 
	jp nz,05f08h		;6779	c2 08 5f 	. . _ 
	call sub_6413h		;677c	cd 13 64 	. . d 
	ld a,(0f7e9h)		;677f	3a e9 f7 	: . . 
	and 07fh		;6782	e6 7f 	.  
	jr z,l679ch		;6784	28 16 	( . 
	ld a,(0f7dch)		;6786	3a dc f7 	: . . 
	call sub_6491h		;6789	cd 91 64 	. . d 
	jp z,05effh		;678c	ca ff 5e 	. . ^ 
	jp c,05f17h		;678f	da 17 5f 	. . _ 
	call sub_6098h		;6792	cd 98 60 	. . ` 
	or a			;6795	b7 	. 
	ret nz			;6796	c0 	. 
	call sub_63bfh		;6797	cd bf 63 	. . c 
	jr l67a1h		;679a	18 05 	. . 
l679ch:
	call l604ch		;679c	cd 4c 60 	. L ` 
	or a			;679f	b7 	. 
	ret nz			;67a0	c0 	. 
l67a1h:
	ld a,(0f7e9h)		;67a1	3a e9 f7 	: . . 
	and 080h		;67a4	e6 80 	. . 
	jp z,l63fah		;67a6	ca fa 63 	. . c 
	ld bc,(0f7d5h)		;67a9	ed 4b d5 f7 	. K . . 
	jp l63ffh		;67ad	c3 ff 63 	. . c 
	ld a,(0f7e2h)		;67b0	3a e2 f7 	: . . 
	srl b		;67b3	cb 38 	. 8 
	sub b			;67b5	90 	. 
	ret z			;67b6	c8 	. 
	ld (hl),07fh		;67b7	36 7f 	6  
	xor a			;67b9	af 	. 
	ret			;67ba	c9 	. 
l67bbh:
	call sub_653bh		;67bb	cd 3b 65 	. ; e 
	call sub_6491h		;67be	cd 91 64 	. . d 
	jp c,05f17h		;67c1	da 17 5f 	. . _ 
	call sub_647fh		;67c4	cd 7f 64 	.  d 
	jr z,l67cfh		;67c7	28 06 	( . 
	jp nc,05f08h		;67c9	d2 08 5f 	. . _ 
	call sub_66eah		;67cc	cd ea 66 	. . f 
l67cfh:
	ld a,(0fa12h)		;67cf	3a 12 fa 	: . . 
	cp 00ch		;67d2	fe 0c 	. . 
	jp z,05efch		;67d4	ca fc 5e 	. . ^ 
	call sub_62c7h		;67d7	cd c7 62 	. . b 
	jp nz,05f02h		;67da	c2 02 5f 	. . _ 
	call sub_6371h		;67dd	cd 71 63 	. q c 
	ld (0f7dch),a		;67e0	32 dc f7 	2 . . 
	call sub_622ah		;67e3	cd 2a 62 	. * b 
	ret nz			;67e6	c0 	. 
	call sub_6333h		;67e7	cd 33 63 	. 3 c 
	ld hl,(0f2f3h)		;67ea	2a f3 f2 	* . . 
	ex de,hl			;67ed	eb 	. 
	or a			;67ee	b7 	. 
	sbc hl,de		;67ef	ed 52 	. R 
	ex de,hl			;67f1	eb 	. 
	call sub_6201h		;67f2	cd 01 62 	. . b 
	ret nz			;67f5	c0 	. 
	ld hl,(0f2f3h)		;67f6	2a f3 f2 	* . . 
	call sub_5ff3h		;67f9	cd f3 5f 	. . _ 
	ret nz			;67fc	c0 	. 
	call sub_6242h		;67fd	cd 42 62 	. B b 
	push bc			;6800	c5 	. 
	ld a,(0f7dch)		;6801	3a dc f7 	: . . 
	call 06380h		;6804	cd 80 63 	. . c 
	inc hl			;6807	23 	# 
	inc hl			;6808	23 	# 
	inc hl			;6809	23 	# 
	ld bc,RBDOS1		;680a	01 05 00 	. . . 
	ldir		;680d	ed b0 	. . 
	ld bc,(0fa15h)		;680f	ed 4b 15 fa 	. K . . 
	call sub_629eh		;6813	cd 9e 62 	. . b 
	ld a,(TACATR)		;6816	3a d1 f7 	: . . 
	ld (0f7d2h),a		;6819	32 d2 f7 	2 . . 
	ld e,a			;681c	5f 	_ 
	and 080h		;681d	e6 80 	. . 
	ld a,020h		;681f	3e 20 	>   
	jr nz,l6825h		;6821	20 02 	  . 
	ld a,053h		;6823	3e 53 	> S 
l6825h:
	call sub_6130h		;6825	cd 30 61 	. 0 a 
	pop hl			;6828	e1 	. 
	or a			;6829	b7 	. 
	ret nz			;682a	c0 	. 
	call sub_6396h		;682b	cd 96 63 	. . c 
	ld hl,(0fa15h)		;682e	2a 15 fa 	* . . 
	inc hl			;6831	23 	# 
	inc hl			;6832	23 	# 
	ld a,h			;6833	7c 	| 
	or l			;6834	b5 	. 
	jr z,l6838h		;6835	28 01 	( . 
	dec hl			;6837	2b 	+ 
l6838h:
	ld (0fa15h),hl		;6838	22 15 fa 	" . . 
	ld hl,0fa12h		;683b	21 12 fa 	! . . 
	inc (hl)			;683e	34 	4 
	ld a,002h		;683f	3e 02 	> . 
	ld (OPNMOD),a		;6841	32 55 f3 	2 U . 
	ld (0f7e3h),a		;6844	32 e3 f7 	2 . . 
	jp l6436h		;6847	c3 36 64 	. 6 d 
l684ah:
	call sub_653bh		;684a	cd 3b 65 	. ; e 
	call sub_624eh		;684d	cd 4e 62 	. N b 
	ret nz			;6850	c0 	. 
	call sub_62c7h		;6851	cd c7 62 	. . b 
	jp z,05f05h		;6854	ca 05 5f 	. . _ 
	ld b,a			;6857	47 	G 
	call sub_6491h		;6858	cd 91 64 	. . d 
	jp z,05effh		;685b	ca ff 5e 	. . ^ 
	jp c,05f17h		;685e	da 17 5f 	. . _ 
	ld a,b			;6861	78 	x 
	ld (0f7e3h),a		;6862	32 e3 f7 	2 . . 
	ld hl,(0f4e3h)		;6865	2a e3 f4 	* . . 
	ld de,l000fh+1		;6868	11 10 00 	. . . 
	push hl			;686b	e5 	. 
	add hl,de			;686c	19 	. 
	ld (0f4e3h),hl		;686d	22 e3 f4 	" . . 
	call 06380h		;6870	cd 80 63 	. . c 
	pop hl			;6873	e1 	. 
	ld (0f4e3h),hl		;6874	22 e3 f4 	" . . 
	xor a			;6877	af 	. 
	ret			;6878	c9 	. 
sub_6879h:
	call sub_655eh		;6879	cd 5e 65 	. ^ e 
	ld hl,(0f353h)		;687c	2a 53 f3 	* S . 
	ld bc,l0006h+2		;687f	01 08 00 	. . . 
	call sub_5f89h		;6882	cd 89 5f 	. . _ 
	ld d,a			;6885	57 	W 
	ld bc,(0fa10h)		;6886	ed 4b 10 fa 	. K . . 
	ld e,006h		;688a	1e 06 	. . 
l688ch:
	srl b		;688c	cb 38 	. 8 
	rr c		;688e	cb 19 	. . 
	rra			;6890	1f 	. 
	dec e			;6891	1d 	. 
	jr nz,l688ch		;6892	20 f8 	  . 
	rra			;6894	1f 	. 
	rra			;6895	1f 	. 
	rra			;6896	1f 	. 
	rra			;6897	1f 	. 
	rra			;6898	1f 	. 
	and 007h		;6899	e6 07 	. . 
	ld e,a			;689b	5f 	_ 
	ld hl,l68b7h		;689c	21 b7 68 	! . h 
	add hl,de			;689f	19 	. 
	ld a,(hl)			;68a0	7e 	~ 
	push af			;68a1	f5 	. 
	ld hl,(0f353h)		;68a2	2a 53 f3 	* S . 
	ld b,000h		;68a5	06 00 	. . 
	ld a,c			;68a7	79 	y 
	and 007h		;68a8	e6 07 	. . 
	jr z,l68b4h		;68aa	28 08 	( . 
	ld c,a			;68ac	4f 	O 
	ld a,0ffh		;68ad	3e ff 	> . 
	call l5f8ah		;68af	cd 8a 5f 	. . _ 
	ex de,hl			;68b2	eb 	. 
	dec hl			;68b3	2b 	+ 
l68b4h:
	pop af			;68b4	f1 	. 
	ld (hl),a			;68b5	77 	w 
	ret			;68b6	c9 	. 
l68b7h:
	add a,b			;68b7	80 	. 
	ret nz			;68b8	c0 	. 
	ret po			;68b9	e0 	. 
	ret p			;68ba	f0 	. 
	ret m			;68bb	f8 	. 
	call m,0fffeh		;68bc	fc fe ff 	. . . 
l68bfh:
	call sub_653bh		;68bf	cd 3b 65 	. ; e 
	call sub_624eh		;68c2	cd 4e 62 	. N b 
	ret nz			;68c5	c0 	. 
	call sub_62c7h		;68c6	cd c7 62 	. . b 
	jp z,05f05h		;68c9	ca 05 5f 	. . _ 
	ld (0f7e3h),a		;68cc	32 e3 f7 	2 . . 
	jp 06380h		;68cf	c3 80 63 	. . c 
	ld a,0afh		;68d2	3e af 	> . 
	ld hl,(0f4e3h)		;68d4	2a e3 f4 	* . . 
	ld de,l0021h		;68d7	11 21 00 	. ! . 
	add hl,de			;68da	19 	. 
	ld (hl),d			;68db	72 	r 
	inc hl			;68dc	23 	# 
	ld (hl),d			;68dd	72 	r 
	inc hl			;68de	23 	# 
	ld (hl),d			;68df	72 	r 
	ld bc,(0f7d5h)		;68e0	ed 4b d5 f7 	. K . . 
	inc bc			;68e4	03 	. 
	or a			;68e5	b7 	. 
	jr nz,l68f2h		;68e6	20 0a 	  . 
	call sub_62c7h		;68e8	cd c7 62 	. . b 
	ret z			;68eb	c8 	. 
	call sub_62a8h		;68ec	cd a8 62 	. . b 
	ld b,(hl)			;68ef	46 	F 
	inc hl			;68f0	23 	# 
	ld c,(hl)			;68f1	4e 	N 
l68f2h:
	ld hl,(0f4e3h)		;68f2	2a e3 f4 	* . . 
	ld de,l0021h		;68f5	11 21 00 	. ! . 
	add hl,de			;68f8	19 	. 
	ld (hl),c			;68f9	71 	q 
	inc hl			;68fa	23 	# 
	ld (hl),b			;68fb	70 	p 
	ret			;68fc	c9 	. 
sub_68fdh:
	ld a,(0efbfh)		;68fd	3a bf ef 	: . . 
	or a			;6900	b7 	. 
	ret z			;6901	c8 	. 
	ld a,(0f7dch)		;6902	3a dc f7 	: . . 
	call sub_62adh		;6905	cd ad 62 	. . b 
	ld (hl),000h		;6908	36 00 	6 . 
	push hl			;690a	e5 	. 
	call sub_66eah		;690b	cd ea 66 	. . f 
	call sub_6917h		;690e	cd 17 69 	. . i 
	pop hl			;6911	e1 	. 
	or a			;6912	b7 	. 
	ret z			;6913	c8 	. 
	ld (hl),0ffh		;6914	36 ff 	6 . 
	ret			;6916	c9 	. 
sub_6917h:
	call sub_6612h		;6917	cd 12 66 	. . f 
	ld hl,(0f7ceh)		;691a	2a ce f7 	* . . 
	ld a,h			;691d	7c 	| 
	or l			;691e	b5 	. 
	ret nz			;691f	c0 	. 
	ld a,(0efbdh)		;6920	3a bd ef 	: . . 
	or 040h		;6923	f6 40 	. @ 
	ld (0efbdh),a		;6925	32 bd ef 	2 . . 
	ld de,(0f4e3h)		;6928	ed 5b e3 f4 	. [ . . 
	ld hl,l000ch		;692c	21 0c 00 	! . . 
	add hl,de			;692f	19 	. 
	ld (hl),000h		;6930	36 00 	6 . 
	ld hl,l001eh+2		;6932	21 20 00 	!   . 
	add hl,de			;6935	19 	. 
	ld (hl),000h		;6936	36 00 	6 . 
l6938h:
	call sub_6760h		;6938	cd 60 67 	. ` g 
	ld hl,(0f7ceh)		;693b	2a ce f7 	* . . 
	ld a,h			;693e	7c 	| 
	or a			;693f	b7 	. 
	ret nz			;6940	c0 	. 
	or l			;6941	b5 	. 
	jr z,l6938h		;6942	28 f4 	( . 
	sub 00ch		;6944	d6 0c 	. . 
	jp nz,05f1ah		;6946	c2 1a 5f 	. . _ 
	ld (0f7ceh),a		;6949	32 ce f7 	2 . . 
	ld (0f4e5h),a		;694c	32 e5 f4 	2 . . 
	ret			;694f	c9 	. 
sub_6950h:
	ld a,(0f2e2h)		;6950	3a e2 f2 	: . . 
	ld c,a			;6953	4f 	O 
	inc c			;6954	0c 	. 
	ld hl,(0f4e3h)		;6955	2a e3 f4 	* . . 
	ld a,(hl)			;6958	7e 	~ 
	and 01fh		;6959	e6 1f 	. . 
	cp 01fh		;695b	fe 1f 	. . 
	jr z,l696ch		;695d	28 0d 	( . 
	or a			;695f	b7 	. 
	jr nz,l6966h		;6960	20 04 	  . 
	ld a,(0f7d0h)		;6962	3a d0 f7 	: . . 
	inc a			;6965	3c 	< 
l6966h:
	sub c			;6966	91 	. 
	ret z			;6967	c8 	. 
l6968h:
	pop hl			;6968	e1 	. 
l6969h:
	jp l5e40h		;6969	c3 40 5e 	. @ ^ 
l696ch:
	ld a,(0f7d0h)		;696c	3a d0 f7 	: . . 
	or a			;696f	b7 	. 
	jr z,l6968h		;6970	28 f6 	( . 
	ret			;6972	c9 	. 
	xor a			;6973	af 	. 
	ld (0f2e3h),a		;6974	32 e3 f2 	2 . . 
	ld (0f7d0h),a		;6977	32 d0 f7 	2 . . 
	jr l6969h		;697a	18 ed 	. . 
	ld a,(0f2e2h)		;697c	3a e2 f2 	: . . 
	ld c,a			;697f	4f 	O 
	ld a,(0f50ah)		;6980	3a 0a f5 	: . . 
	cp c			;6983	b9 	. 
	jp nz,l698dh		;6984	c2 8d 69 	. . i 
	ld (0f7d0h),a		;6987	32 d0 f7 	2 . . 
	jp sub_655eh		;698a	c3 5e 65 	. ^ e 
l698dh:
	xor a			;698d	af 	. 
	ld (0f7d0h),a		;698e	32 d0 f7 	2 . . 
	jr l6969h		;6991	18 d6 	. . 
	call sub_6950h		;6993	cd 50 69 	. P i 
	jp sub_6612h		;6996	c3 12 66 	. . f 
	call sub_6950h		;6999	cd 50 69 	. P i 
	jp l66a2h		;699c	c3 a2 66 	. . f 
	ld hl,0efbdh		;699f	21 bd ef 	! . . 
	res 7,(hl)		;69a2	cb be 	. . 
	call sub_6950h		;69a4	cd 50 69 	. P i 
	call sub_66f2h		;69a7	cd f2 66 	. . f 
	push af			;69aa	f5 	. 
	ld hl,(0f4e3h)		;69ab	2a e3 f4 	* . . 
	ld a,(hl)			;69ae	7e 	~ 
	cp 03fh		;69af	fe 3f 	. ? 
	jr nz,l69b9h		;69b1	20 06 	  . 
	ld hl,l69c1h		;69b3	21 c1 69 	! . i 
	ld (0f7ddh),hl		;69b6	22 dd f7 	" . . 
l69b9h:
	pop af			;69b9	f1 	. 
l69bah:
	ld hl,0efbdh		;69ba	21 bd ef 	! . . 
	set 7,(hl)		;69bd	cb fe 	. . 
	jr l6a14h		;69bf	18 53 	. S 
l69c1h:
	ccf			;69c1	3f 	? 
	ld a,(0efbdh)		;69c2	3a bd ef 	: . . 
	and 080h		;69c5	e6 80 	. . 
	jr z,l6969h		;69c7	28 a0 	( . 
	call sub_66feh		;69c9	cd fe 66 	. . f 
	jr l69bah		;69cc	18 ec 	. . 
	call sub_6950h		;69ce	cd 50 69 	. P i 
	call sub_6717h		;69d1	cd 17 67 	. . g 
	ld hl,(0f7ceh)		;69d4	2a ce f7 	* . . 
	ld a,h			;69d7	7c 	| 
	or a			;69d8	b7 	. 
	ret nz			;69d9	c0 	. 
	or l			;69da	b5 	. 
	jp z,l6aefh		;69db	ca ef 6a 	. . j 
	ret			;69de	c9 	. 
	call sub_6950h		;69df	cd 50 69 	. P i 
	jp sub_6760h		;69e2	c3 60 67 	. ` g 
	call sub_6950h		;69e5	cd 50 69 	. P i 
	jp 06762h		;69e8	c3 62 67 	. b g 
	call sub_6950h		;69eb	cd 50 69 	. P i 
	jp l67bbh		;69ee	c3 bb 67 	. . g 
	call sub_6950h		;69f1	cd 50 69 	. P i 
	jp l684ah		;69f4	c3 4a 68 	. J h 
	ld hl,(0f321h)		;69f7	2a 21 f3 	* ! . 
	ld a,(TAPMOD)		;69fa	3a e1 f2 	: . . 
	dec a			;69fd	3d 	= 
	jr nz,l6a0fh		;69fe	20 0f 	  . 
	ld a,(0f7d0h)		;6a00	3a d0 f7 	: . . 
	or a			;6a03	b7 	. 
	jr z,l6a0fh		;6a04	28 09 	( . 
l6a06h:
	call sub_5f9dh		;6a06	cd 9d 5f 	. . _ 
	ld a,d			;6a09	7a 	z 
	or h			;6a0a	b4 	. 
	ld h,a			;6a0b	67 	g 
	ld a,e			;6a0c	7b 	{ 
	or l			;6a0d	b5 	. 
	ld l,a			;6a0e	6f 	o 
l6a0fh:
	jr l6a41h		;6a0f	18 30 	. 0 
	call l696ch		;6a11	cd 6c 69 	. l i 
l6a14h:
	jp l6aech		;6a14	c3 ec 6a 	. . j 
	call l696ch		;6a17	cd 6c 69 	. l i 
	call sub_6879h		;6a1a	cd 79 68 	. y h 
	ld hl,(0f353h)		;6a1d	2a 53 f3 	* S . 
	jr l6a41h		;6a20	18 1f 	. . 
	call l696ch		;6a22	cd 6c 69 	. l i 
	ld a,001h		;6a25	3e 01 	> . 
	ld (0f2e3h),a		;6a27	32 e3 f2 	2 . . 
	ret			;6a2a	c9 	. 
	ld hl,(0f31fh)		;6a2b	2a 1f f3 	* . . 
	call sub_6491h		;6a2e	cd 91 64 	. . d 
	jr c,l6a06h		;6a31	38 d3 	8 . 
	jr l6a0fh		;6a33	18 da 	. . 
	call sub_6950h		;6a35	cd 50 69 	. P i 
	jp l68bfh		;6a38	c3 bf 68 	. . h 
	call l696ch		;6a3b	cd 6c 69 	. l i 
	ld hl,0f23ch		;6a3e	21 3c f2 	! < . 
l6a41h:
	pop af			;6a41	f1 	. 
	jp l6ae3h		;6a42	c3 e3 6a 	. . j 
	call sub_6950h		;6a45	cd 50 69 	. P i 
	jp 06765h		;6a48	c3 65 67 	. e g 
	call sub_6950h		;6a4b	cd 50 69 	. P i 
	jp 06768h		;6a4e	c3 68 67 	. h g 
	call sub_6950h		;6a51	cd 50 69 	. P i 
	jp 068d3h		;6a54	c3 d3 68 	. . h 
	call sub_5f9dh		;6a57	cd 9d 5f 	. . _ 
	ld hl,(0f4e3h)		;6a5a	2a e3 f4 	* . . 
	ld a,d			;6a5d	7a 	z 
	and h			;6a5e	a4 	. 
	jr nz,l6a69h		;6a5f	20 08 	  . 
	ld a,e			;6a61	7b 	{ 
	and l			;6a62	a5 	. 
	jr z,l6a75h		;6a63	28 10 	( . 
	xor l			;6a65	ad 	. 
	ld l,a			;6a66	6f 	o 
	jr l6a6bh		;6a67	18 02 	. . 
l6a69h:
	xor h			;6a69	ac 	. 
	ld h,a			;6a6a	67 	g 
l6a6bh:
	xor a			;6a6b	af 	. 
	ld (0f2e3h),a		;6a6c	32 e3 f2 	2 . . 
	ld (0f7d0h),a		;6a6f	32 d0 f7 	2 . . 
	ld (0f4e3h),hl		;6a72	22 e3 f4 	" . . 
l6a75h:
	jp l5e40h		;6a75	c3 40 5e 	. @ ^ 
	call sub_64b7h		;6a78	cd b7 64 	. . d 
	jp l6aech		;6a7b	c3 ec 6a 	. . j 
XMAKDIR:
	ld hl,l649fh		;6a7e	21 9f 64 	! . d 
	jr l6a8bh		;6a81	18 08 	. . 
XMOUNT:
	ld hl,l64cah		;6a83	21 ca 64 	! . d 
	jr l6a8bh		;6a86	18 03 	. . 
XREMOVE:
	ld hl,l6565h		;6a88	21 65 65 	! e e 
l6a8bh:
	ld bc,COLDRST		;6a8b	01 00 00 	. . . 
	ld (0f7ceh),bc		;6a8e	ed 43 ce f7 	. C . . 
	ld a,(0efbdh)		;6a92	3a bd ef 	: . . 
	or 008h		;6a95	f6 08 	. . 
	ld (0efbdh),a		;6a97	32 bd ef 	2 . . 
	ld bc,sub_6a9fh		;6a9a	01 9f 6a 	. . j 
	push bc			;6a9d	c5 	. 
	jp (hl)			;6a9e	e9 	. 
sub_6a9fh:
	ld hl,0eff1h		;6a9f	21 f1 ef 	! . . 
	res 1,(hl)		;6aa2	cb 8e 	. . 
	ld hl,(0f7ceh)		;6aa4	2a ce f7 	* . . 
	ld a,l			;6aa7	7d 	} 
	ret			;6aa8	c9 	. 
l6aa9h:
	call sub_6a9fh		;6aa9	cd 9f 6a 	. . j 
	ld hl,l6ae6h		;6aac	21 e6 6a 	! . j 
	push hl			;6aaf	e5 	. 
	ld hl,l00ffh		;6ab0	21 ff 00 	! . . 
	inc h			;6ab3	24 	$ 
	ld a,(0f7cfh)		;6ab4	3a cf f7 	: . . 
	or a			;6ab7	b7 	. 
	jr z,l6ac4h		;6ab8	28 0a 	( . 
	call sub_6af2h		;6aba	cd f2 6a 	. . j 
	xor a			;6abd	af 	. 
	ld (OPNMOD),a		;6abe	32 55 f3 	2 U . 
	jp l1eeah		;6ac1	c3 ea 1e 	. . . 
l6ac4h:
	inc h			;6ac4	24 	$ 
	ld a,(0f7ceh)		;6ac5	3a ce f7 	: . . 
	cp 00fh		;6ac8	fe 0f 	. . 
	jr nz,l6ad2h		;6aca	20 06 	  . 
	call sub_6af2h		;6acc	cd f2 6a 	. . j 
	jp 01ef2h		;6acf	c3 f2 1e 	. . . 
l6ad2h:
	inc h			;6ad2	24 	$ 
	cp 006h		;6ad3	fe 06 	. . 
	jr nz,l6addh		;6ad5	20 06 	  . 
	call sub_6af2h		;6ad7	cd f2 6a 	. . j 
	jp 01ef6h		;6ada	c3 f6 1e 	. . . 
l6addh:
	ld hl,l5ecah		;6add	21 ca 5e 	! . ^ 
	call sub_5e4ch		;6ae0	cd 4c 5e 	. L ^ 
l6ae3h:
	ld (0f4e5h),hl		;6ae3	22 e5 f4 	" . . 
l6ae6h:
	call sub_6a9fh		;6ae6	cd 9f 6a 	. . j 
	jp l2954h		;6ae9	c3 54 29 	. T ) 
l6aech:
	ld (0f4e5h),a		;6aec	32 e5 f4 	2 . . 
l6aefh:
	pop hl			;6aef	e1 	. 
	jr l6ae6h		;6af0	18 f4 	. . 
sub_6af2h:
	ld (0f4e5h),hl		;6af2	22 e5 f4 	" . . 
sub_6af5h:
	ld hl,0efbdh		;6af5	21 bd ef 	! . . 
	set 5,(hl)		;6af8	cb ee 	. . 
	ret			;6afa	c9 	. 
sub_6afbh:
	push hl			;6afb	e5 	. 
	push de			;6afc	d5 	. 
	ld h,a			;6afd	67 	g 
	call sub_6b2bh		;6afe	cd 2b 6b 	. + k 
	jr nz,l6b17h		;6b01	20 14 	  . 
	xor a			;6b03	af 	. 
	ld (BIOSERROR),a		;6b04	32 2b f5 	2 + . 
	ld a,b			;6b07	78 	x 
	cp 01bh		;6b08	fe 1b 	. . 
	jr nc,l6b25h		;6b0a	30 19 	0 . 
	ld e,a			;6b0c	5f 	_ 
	ld a,h			;6b0d	7c 	| 
	ld hl,MIOSTBL		;6b0e	21 31 6b 	! 1 k 
	call sub_5e4dh		;6b11	cd 4d 5e 	. M ^ 
	pop de			;6b14	d1 	. 
	ex (sp),hl			;6b15	e3 	. 
	ret			;6b16	c9 	. 
l6b17h:
	ld a,(0efc0h)		;6b17	3a c0 ef 	: . . 
	or a			;6b1a	b7 	. 
	call nz,sub_65efh		;6b1b	c4 ef 65 	. . e 
	ld a,008h		;6b1e	3e 08 	> . 
	ld c,008h		;6b20	0e 08 	. . 
	call sub_6c49h		;6b22	cd 49 6c 	. I l 
l6b25h:
	pop de			;6b25	d1 	. 
	pop hl			;6b26	e1 	. 
	ret			;6b27	c9 	. 
sub_6b28h:
	call CHKMOD		;6b28	cd 11 46 	. . F 
sub_6b2bh:
	ld a,(CRGDEV)		;6b2b	3a 3f f5 	: ? . 
	cp 048h		;6b2e	fe 48 	. H 
	ret			;6b30	c9 	. 
MIOSTBL:
	jp (hl)			;6b31	e9 	. 
	ld l,e			;6b32	6b 	k 
	ret p			;6b33	f0 	. 
	ld l,e			;6b34	6b 	k 
	ld (bc),a			;6b35	02 	. 
	ld l,h			;6b36	6c 	l 
	add hl,bc			;6b37	09 	. 
	ld l,h			;6b38	6c 	l 
	dec e			;6b39	1d 	. 
	ld l,h			;6b3a	6c 	l 
	add hl,hl			;6b3b	29 	) 
	ld l,h			;6b3c	6c 	l 
	inc l			;6b3d	2c 	, 
	ld l,h			;6b3e	6c 	l 
	cpl			;6b3f	2f 	/ 
	ld l,h			;6b40	6c 	l 
	ld (l596ch),a		;6b41	32 6c 59 	2 l Y 
	ld l,h			;6b44	6c 	l 
	add a,a			;6b45	87 	. 
	ld l,h			;6b46	6c 	l 
	jr c,l6bb5h		;6b47	38 6c 	8 l 
	dec sp			;6b49	3b 	; 
	ld l,h			;6b4a	6c 	l 
	sub d			;6b4b	92 	. 
	ld l,h			;6b4c	6c 	l 
	rst 0			;6b4d	c7 	. 
	ld l,h			;6b4e	6c 	l 
	dec (hl)			;6b4f	35 	5 
	ld l,h			;6b50	6c 	l 
	call z,09f6ch		;6b51	cc 6c 9f 	. l . 
	ld l,l			;6b54	6d 	m 
	daa			;6b55	27 	' 
	ld l,e			;6b56	6b 	k 
	daa			;6b57	27 	' 
	ld l,e			;6b58	6b 	k 
	cpl			;6b59	2f 	/ 
	ld l,(hl)			;6b5a	6e 	n 
	jr nz,$+112		;6b5b	20 6e 	  n 
	ld hl,l4d6eh		;6b5d	21 6e 4d 	! n M 
	ld l,(hl)			;6b60	6e 	n 
	ccf			;6b61	3f 	? 
	ld l,(hl)			;6b62	6e 	n 
	ld h,c			;6b63	61 	a 
	ld l,(hl)			;6b64	6e 	n 
l6b65h:
	call sub_6b7bh		;6b65	cd 7b 6b 	. { k 
	ret nz			;6b68	c0 	. 
	call HSRST		;6b69	cd f8 46 	. . F 
	jr z,l6b65h		;6b6c	28 f7 	( . 
	xor a			;6b6e	af 	. 
	ret			;6b6f	c9 	. 
l6b70h:
	call sub_6b83h		;6b70	cd 83 6b 	. . k 
	ret nz			;6b73	c0 	. 
	call HSRST		;6b74	cd f8 46 	. . F 
	jr z,l6b70h		;6b77	28 f7 	( . 
	xor a			;6b79	af 	. 
	ret			;6b7a	c9 	. 
sub_6b7bh:
	ld b,007h		;6b7b	06 07 	. . 
	ld a,(0eff0h)		;6b7d	3a f0 ef 	: . . 
	or a			;6b80	b7 	. 
	jr nz,l6b8ah		;6b81	20 07 	  . 
sub_6b83h:
	ld b,006h		;6b83	06 06 	. . 
	ld a,(CSTOPFLG)		;6b85	3a 1a f0 	: . . 
	or a			;6b88	b7 	. 
	ret z			;6b89	c8 	. 
l6b8ah:
	ld a,(0ef29h)		;6b8a	3a 29 ef 	: ) . 
	and 004h		;6b8d	e6 04 	. . 
	jr z,l6b93h		;6b8f	28 02 	( . 
	ld b,006h		;6b91	06 06 	. . 
l6b93h:
	push bc			;6b93	c5 	. 
	call HSRK		;6b94	cd 52 47 	. R G 
	pop af			;6b97	f1 	. 
	ld (0f7cfh),a		;6b98	32 cf f7 	2 . . 
	or a			;6b9b	b7 	. 
	ret			;6b9c	c9 	. 
sub_6b9dh:
	ld a,d			;6b9d	7a 	z 
	xor h			;6b9e	ac 	. 
	rla			;6b9f	17 	. 
	ld a,000h		;6ba0	3e 00 	> . 
	jr c,l6bb2h		;6ba2	38 0e 	8 . 
	sbc hl,de		;6ba4	ed 52 	. R 
	jr z,l6bc3h		;6ba6	28 1b 	( . 
	inc a			;6ba8	3c 	< 
	jr nc,l6bc2h		;6ba9	30 17 	0 . 
	add hl,de			;6bab	19 	. 
	ex de,hl			;6bac	eb 	. 
	or a			;6bad	b7 	. 
	sbc hl,de		;6bae	ed 52 	. R 
	jr l6bc3h		;6bb0	18 11 	. . 
l6bb2h:
	inc a			;6bb2	3c 	< 
	bit 7,d		;6bb3	cb 7a 	. z 
l6bb5h:
	jr nz,l6bb9h		;6bb5	20 02 	  . 
	ex de,hl			;6bb7	eb 	. 
	dec a			;6bb8	3d 	= 
l6bb9h:
	push hl			;6bb9	e5 	. 
	ld hl,COLDRST		;6bba	21 00 00 	! . . 
	sbc hl,de		;6bbd	ed 52 	. R 
	pop de			;6bbf	d1 	. 
	adc hl,de		;6bc0	ed 5a 	. Z 
l6bc2h:
	inc a			;6bc2	3c 	< 
l6bc3h:
	or a			;6bc3	b7 	. 
	ret			;6bc4	c9 	. 
sub_6bc5h:
	call HSRCV		;6bc5	cd 23 47 	. # G 
	ld b,c			;6bc8	41 	A 
	call HSRCV		;6bc9	cd 23 47 	. # G 
	ld (0f7f6h),bc		;6bcc	ed 43 f6 f7 	. C . . 
	ret			;6bd0	c9 	. 
sub_6bd1h:
	ld c,a			;6bd1	4f 	O 
	jp HSSDAT		;6bd2	c3 12 47 	. . G 
sub_6bd5h:
	ld a,(0f356h)		;6bd5	3a 56 f3 	: V . 
	and 080h		;6bd8	e6 80 	. . 
	ret z			;6bda	c8 	. 
	ld c,055h		;6bdb	0e 55 	. U 
	ld de,(0f35ah)		;6bdd	ed 5b 5a f3 	. [ Z . 
	jp l4779h		;6be1	c3 79 47 	. y G 
l6be4h:
	ld c,056h		;6be4	0e 56 	. V 
	jp l4767h		;6be6	c3 67 47 	. g G 
sub_6be9h:
	ld c,040h		;6be9	0e 40 	. @ 
	call sub_476ch		;6beb	cd 6c 47 	. l G 
	jr l6bffh		;6bee	18 0f 	. . 
sub_6bf0h:
	ld c,04ch		;6bf0	0e 4c 	. L 
	call l4767h		;6bf2	cd 67 47 	. g G 
	push bc			;6bf5	c5 	. 
	call HSRCV		;6bf6	cd 23 47 	. # G 
	ld d,c			;6bf9	51 	Q 
	call HSRCV		;6bfa	cd 23 47 	. # G 
	ld e,c			;6bfd	59 	Y 
	pop bc			;6bfe	c1 	. 
l6bffh:
	ex de,hl			;6bff	eb 	. 
	jr l6c40h		;6c00	18 3e 	. > 
l6c02h:
	ld c,04dh		;6c02	0e 4d 	. M 
l6c04h:
	call l4779h		;6c04	cd 79 47 	. y G 
	jr l6c40h		;6c07	18 37 	. 7 
sub_6c09h:
	call l6c13h		;6c09	cd 13 6c 	. . l 
	ld c,04ah		;6c0c	0e 4a 	. J 
	call sub_6c3dh		;6c0e	cd 3d 6c 	. = l 
	jr l6be4h		;6c11	18 d1 	. . 
l6c13h:
	ld hl,0f005h		;6c13	21 05 f0 	! . . 
	ld a,(hl)			;6c16	7e 	~ 
	and 0efh		;6c17	e6 ef 	. . 
	ld (hl),a			;6c19	77 	w 
	out (018h),a		;6c1a	d3 18 	. . 
	ret			;6c1c	c9 	. 
	ld hl,0f005h		;6c1d	21 05 f0 	! . . 
	ld a,(hl)			;6c20	7e 	~ 
	or 010h		;6c21	f6 10 	. . 
	ld (hl),a			;6c23	77 	w 
	out (018h),a		;6c24	d3 18 	. . 
	ld c,048h		;6c26	0e 48 	. H 
	ld a,(0490eh)		;6c28	3a 0e 49 	: . I 
	ld a,(sub_460ch+2)		;6c2b	3a 0e 46 	: . F 
	ld a,(l470eh)		;6c2e	3a 0e 47 	: . G 
	ld a,(0450eh)		;6c31	3a 0e 45 	: . E 
	ld a,(0560eh)		;6c34	3a 0e 56 	: . V 
	ld a,(l410eh)		;6c37	3a 0e 41 	: . A 
	ld a,(0420eh)		;6c3a	3a 0e 42 	: . B 
sub_6c3dh:
	call l4767h		;6c3d	cd 67 47 	. g G 
l6c40h:
	ld a,c			;6c40	79 	y 
	or a			;6c41	b7 	. 
	jr z,sub_6c49h		;6c42	28 05 	( . 
	sub 040h		;6c44	d6 40 	. @ 
	ld c,a			;6c46	4f 	O 
	ld a,0feh		;6c47	3e fe 	> . 
sub_6c49h:
	push af			;6c49	f5 	. 
	ld a,c			;6c4a	79 	y 
	ld (0f7cfh),a		;6c4b	32 cf f7 	2 . . 
	pop af			;6c4e	f1 	. 
l6c4fh:
	ld (BIOSERROR),a		;6c4f	32 2b f5 	2 + . 
	or a			;6c52	b7 	. 
	ret			;6c53	c9 	. 
sub_6c54h:
	call HSRCV		;6c54	cd 23 47 	. # G 
	jr l6c40h		;6c57	18 e7 	. . 
	ld c,046h		;6c59	0e 46 	. F 
sub_6c5bh:
	push bc			;6c5b	c5 	. 
	call 06c35h		;6c5c	cd 35 6c 	. 5 l 
	pop bc			;6c5f	c1 	. 
	call l4767h		;6c60	cd 67 47 	. g G 
	ld hl,sub_00efh+1		;6c63	21 f0 00 	! . . 
	ld (0ef91h),hl		;6c66	22 91 ef 	" . . 
l6c69h:
	call sub_6b7bh		;6c69	cd 7b 6b 	. { k 
	ret nz			;6c6c	c0 	. 
	ld hl,(0ef91h)		;6c6d	2a 91 ef 	* . . 
	rlc h		;6c70	cb 04 	. . 
	jr c,l6c7eh		;6c72	38 0a 	8 . 
	call sub_6be9h		;6c74	cd e9 6b 	. . k 
	ld a,h			;6c77	7c 	| 
	and 040h		;6c78	e6 40 	. @ 
	jr nz,l6c69h		;6c7a	20 ed 	  . 
l6c7ch:
	jr l6c40h		;6c7c	18 c2 	. . 
l6c7eh:
	call sub_6c09h		;6c7e	cd 09 6c 	. . l 
	ld c,007h		;6c81	0e 07 	. . 
	ld a,005h		;6c83	3e 05 	> . 
	jr sub_6c49h		;6c85	18 c2 	. . 
	ld c,045h		;6c87	0e 45 	. E 
	call sub_6c5bh		;6c89	cd 5b 6c 	. [ l 
	ret nz			;6c8c	c0 	. 
	ld d,a			;6c8d	57 	W 
	ld e,a			;6c8e	5f 	_ 
	jp l6c02h		;6c8f	c3 02 6c 	. . l 
sub_6c92h:
	ld (0f7c0h),de		;6c92	ed 53 c0 f7 	. S . . 
	call sub_6c09h		;6c96	cd 09 6c 	. . l 
	call sub_6bf0h		;6c99	cd f0 6b 	. . k 
	ld de,(0f7c0h)		;6c9c	ed 5b c0 f7 	. [ . . 
	ex de,hl			;6ca0	eb 	. 
	call sub_6b9dh		;6ca1	cd 9d 6b 	. . k 
	jp z,l6c40h		;6ca4	ca 40 6c 	. @ l 
	ld c,043h		;6ca7	0e 43 	. C 
	dec a			;6ca9	3d 	= 
	jr z,l6caeh		;6caa	28 02 	( . 
	ld c,044h		;6cac	0e 44 	. D 
l6caeh:
	call HSSCOM		;6cae	cd 0d 47 	. . G 
	ld c,h			;6cb1	4c 	L 
	call HSSDAT		;6cb2	cd 12 47 	. . G 
	ld c,l			;6cb5	4d 	M 
	call HSSDAT		;6cb6	cd 12 47 	. . G 
	ld c,001h		;6cb9	0e 01 	. . 
	call HSSDAT		;6cbb	cd 12 47 	. . G 
	call l6b65h		;6cbe	cd 65 6b 	. e k 
	ret nz			;6cc1	c0 	. 
	call HSRCV		;6cc2	cd 23 47 	. # G 
	jr l6c7ch		;6cc5	18 b5 	. . 
sub_6cc7h:
	ld c,055h		;6cc7	0e 55 	. U 
	jp l6c04h		;6cc9	c3 04 6c 	. . l 
	ld (0f7b4h),a		;6ccc	32 b4 f7 	2 . . 
	ld a,c			;6ccf	79 	y 
	ld (0f7b5h),a		;6cd0	32 b5 f7 	2 . . 
	ld (0f7b6h),de		;6cd3	ed 53 b6 f7 	. S . . 
	ld (0f7b8h),hl		;6cd7	22 b8 f7 	" . . 
	and 00fh		;6cda	e6 0f 	. . 
	ld (0f7bah),a		;6cdc	32 ba f7 	2 . . 
	ld a,(BIOSFN)		;6cdf	3a 57 f3 	: W . 
	ld (0f7bbh),a		;6ce2	32 bb f7 	2 . . 
l6ce5h:
	call sub_6bf0h		;6ce5	cd f0 6b 	. . k 
	ld (0f7bch),hl		;6ce8	22 bc f7 	" . . 
	xor a			;6ceb	af 	. 
	ld (0f316h),a		;6cec	32 16 f3 	2 . . 
l6cefh:
	ld (0f7bfh),a		;6cef	32 bf f7 	2 . . 
	call sub_6b83h		;6cf2	cd 83 6b 	. . k 
	ret nz			;6cf5	c0 	. 
	call sub_6bd5h		;6cf6	cd d5 6b 	. . k 
	call sub_6d80h		;6cf9	cd 80 6d 	. . m 
	call l6b70h		;6cfc	cd 70 6b 	. p k 
	ret nz			;6cff	c0 	. 
	call sub_6e14h		;6d00	cd 14 6e 	. . n 
	push bc			;6d03	c5 	. 
	call sub_6bc5h		;6d04	cd c5 6b 	. . k 
	ld bc,(0f7b6h)		;6d07	ed 4b b6 f7 	. K . . 
	ld de,(0f351h)		;6d0b	ed 5b 51 f3 	. [ Q . 
	call HSRBL		;6d0f	cd 3d 47 	. = G 
	pop bc			;6d12	c1 	. 
	call l4066h		;6d13	cd 66 40 	. f @ 
	call sub_6c54h		;6d16	cd 54 6c 	. T l 
	jr nz,l6d3fh		;6d19	20 24 	  $ 
	ld hl,(0f351h)		;6d1b	2a 51 f3 	* Q . 
	ld a,(0f7b4h)		;6d1e	3a b4 f7 	: . . 
	add a,l			;6d21	85 	. 
	ld l,a			;6d22	6f 	o 
	ld a,000h		;6d23	3e 00 	> . 
	adc a,h			;6d25	8c 	. 
	ld de,(0f7b8h)		;6d26	ed 5b b8 f7 	. [ . . 
	ld a,(hl)			;6d2a	7e 	~ 
	inc hl			;6d2b	23 	# 
	ld l,(hl)			;6d2c	6e 	n 
	ld h,a			;6d2d	67 	g 
	or a			;6d2e	b7 	. 
	sbc hl,de		;6d2f	ed 52 	. R 
	jp z,l6d9dh		;6d31	ca 9d 6d 	. . m 
	jr nc,l6d76h		;6d34	30 40 	0 @ 
	inc hl			;6d36	23 	# 
	inc hl			;6d37	23 	# 
	inc hl			;6d38	23 	# 
	ld a,h			;6d39	7c 	| 
	or a			;6d3a	b7 	. 
	jr nz,l6d76h		;6d3b	20 39 	  9 
	jr l6ce5h		;6d3d	18 a6 	. . 
l6d3fh:
	ld a,c			;6d3f	79 	y 
	cp 002h		;6d40	fe 02 	. . 
	jr z,l6d71h		;6d42	28 2d 	( - 
	cp 006h		;6d44	fe 06 	. . 
	jr nz,l6d50h		;6d46	20 08 	  . 
	ld hl,0f7bbh		;6d48	21 bb f7 	! . . 
	dec (hl)			;6d4b	35 	5 
	jr nz,l6ce5h		;6d4c	20 97 	  . 
	jr l6d6eh		;6d4e	18 1e 	. . 
l6d50h:
	ld a,(0f7bfh)		;6d50	3a bf f7 	: . . 
	inc a			;6d53	3c 	< 
	ld hl,BIOSFN		;6d54	21 57 f3 	! W . 
	cp (hl)			;6d57	be 	. 
	jr nz,l6cefh		;6d58	20 95 	  . 
	ld a,(0f7bah)		;6d5a	3a ba f7 	: . . 
	dec a			;6d5d	3d 	= 
	ld (0f7bah),a		;6d5e	32 ba f7 	2 . . 
	rla			;6d61	17 	. 
	jr c,l6d76h		;6d62	38 12 	8 . 
	ld de,(0f7bch)		;6d64	ed 5b bc f7 	. [ . . 
	call sub_6c92h		;6d68	cd 92 6c 	. . l 
	jp z,l6ce5h		;6d6b	ca e5 6c 	. . l 
l6d6eh:
	call sub_6c09h		;6d6e	cd 09 6c 	. . l 
l6d71h:
	ld a,001h		;6d71	3e 01 	> . 
	jp l6c4fh		;6d73	c3 4f 6c 	. O l 
l6d76h:
	call sub_6c09h		;6d76	cd 09 6c 	. . l 
	ld a,001h		;6d79	3e 01 	> . 
	ld c,080h		;6d7b	0e 80 	. . 
	jp sub_6c49h		;6d7d	c3 49 6c 	. I l 
sub_6d80h:
	ld a,(0f7b5h)		;6d80	3a b5 f7 	: . . 
	ld c,053h		;6d83	0e 53 	. S 
	rla			;6d85	17 	. 
	jp nc,l6d8bh		;6d86	d2 8b 6d 	. . m 
	ld c,054h		;6d89	0e 54 	. T 
l6d8bh:
	call HSSCOM		;6d8b	cd 0d 47 	. . G 
	ld a,(0f7b7h)		;6d8e	3a b7 f7 	: . . 
	call sub_6bd1h		;6d91	cd d1 6b 	. . k 
	ld a,(0f7b6h)		;6d94	3a b6 f7 	: . . 
	jp sub_6bd1h		;6d97	c3 d1 6b 	. . k 
	call sub_6bc5h		;6d9a	cd c5 6b 	. . k 
l6d9dh:
	xor a			;6d9d	af 	. 
	ret			;6d9e	c9 	. 
	push bc			;6d9f	c5 	. 
	push de			;6da0	d5 	. 
	call sub_6bd5h		;6da1	cd d5 6b 	. . k 
	pop de			;6da4	d1 	. 
	pop bc			;6da5	c1 	. 
	ld (0f7b4h),de		;6da6	ed 53 b4 f7 	. S . . 
	ld a,(0f2fdh)		;6daa	3a fd f2 	: . . 
	ld (0f7b9h),a		;6dad	32 b9 f7 	2 . . 
	ld a,c			;6db0	79 	y 
	ld (0f7b8h),a		;6db1	32 b8 f7 	2 . . 
l6db4h:
	ld a,(0f7b9h)		;6db4	3a b9 f7 	: . . 
	dec a			;6db7	3d 	= 
	ld (0f7b9h),a		;6db8	32 b9 f7 	2 . . 
	jr z,l6d9dh		;6dbb	28 e0 	( . 
	dec a			;6dbd	3d 	= 
	jr nz,l6dc8h		;6dbe	20 08 	  . 
	ld a,(0f7b8h)		;6dc0	3a b8 f7 	: . . 
	ld c,052h		;6dc3	0e 52 	. R 
	rla			;6dc5	17 	. 
	jr c,l6dcah		;6dc6	38 02 	8 . 
l6dc8h:
	ld c,051h		;6dc8	0e 51 	. Q 
l6dcah:
	push bc			;6dca	c5 	. 
	call sub_6e14h		;6dcb	cd 14 6e 	. . n 
	pop de			;6dce	d1 	. 
	push bc			;6dcf	c5 	. 
	ld c,e			;6dd0	4b 	K 
	call HSSCOM		;6dd1	cd 0d 47 	. . G 
	ld a,(0f7b5h)		;6dd4	3a b5 f7 	: . . 
	call sub_6bd1h		;6dd7	cd d1 6b 	. . k 
	ld a,(0f7b4h)		;6dda	3a b4 f7 	: . . 
	call sub_6bd1h		;6ddd	cd d1 6b 	. . k 
	ld bc,(0f7b4h)		;6de0	ed 4b b4 f7 	. K . . 
	ld de,(0f351h)		;6de4	ed 5b 51 f3 	. [ Q . 
	call HSSBL		;6de8	cd 2c 47 	. , G 
	pop bc			;6deb	c1 	. 
	call l4066h		;6dec	cd 66 40 	. f @ 
	call l6b70h		;6def	cd 70 6b 	. p k 
	ret nz			;6df2	c0 	. 
	call HSRCV		;6df3	cd 23 47 	. # G 
	call l6c40h		;6df6	cd 40 6c 	. @ l 
	jr nz,l6e07h		;6df9	20 0c 	  . 
	call sub_6bc5h		;6dfb	cd c5 6b 	. . k 
	ld hl,(0f351h)		;6dfe	2a 51 f3 	* Q . 
	inc hl			;6e01	23 	# 
	inc hl			;6e02	23 	# 
	inc hl			;6e03	23 	# 
	inc (hl)			;6e04	34 	4 
	jr l6db4h		;6e05	18 ad 	. . 
l6e07h:
	ld a,c			;6e07	79 	y 
	ld c,003h		;6e08	0e 03 	. . 
	cp 01bh		;6e0a	fe 1b 	. . 
	ld a,c			;6e0c	79 	y 
	jr z,l6e11h		;6e0d	28 02 	( . 
	ld a,002h		;6e0f	3e 02 	> . 
l6e11h:
	jp l6c4fh		;6e11	c3 4f 6c 	. O l 
sub_6e14h:
	ld b,080h		;6e14	06 80 	. . 
	call l4066h		;6e16	cd 66 40 	. f @ 
	ld a,b			;6e19	78 	x 
	and 0f6h		;6e1a	e6 f6 	. . 
	ld b,a			;6e1c	47 	G 
	jp l4066h		;6e1d	c3 66 40 	. f @ 
	ld a,0afh		;6e20	3e af 	> . 
	ld b,a			;6e22	47 	G 
	ld c,05ah		;6e23	0e 5a 	. Z 
	call HSSCOM		;6e25	cd 0d 47 	. . G 
	ld c,b			;6e28	48 	H 
	call HSSDAT		;6e29	cd 12 47 	. . G 
	jp HSRCV		;6e2c	c3 23 47 	. # G 
	ld c,04bh		;6e2f	0e 4b 	. K 
	call sub_476ch		;6e31	cd 6c 47 	. l G 
	ld a,d			;6e34	7a 	z 
	or a			;6e35	b7 	. 
	jp nz,l6d9dh		;6e36	c2 9d 6d 	. . m 
	ld a,003h		;6e39	3e 03 	> . 
	ld c,a			;6e3b	4f 	O 
	jp sub_6c49h		;6e3c	c3 49 6c 	. I l 
	ld c,05bh		;6e3f	0e 5b 	. [ 
	call l4767h		;6e41	cd 67 47 	. g G 
	ld de,0f7fch		;6e44	11 fc f7 	. . . 
	ld bc,l001eh+2		;6e47	01 20 00 	.   . 
	jp HSRBL		;6e4a	c3 3d 47 	. = G 
sub_6e4dh:
	ld c,05ch		;6e4d	0e 5c 	. \ 
	call HSSCOM		;6e4f	cd 0d 47 	. . G 
	ld de,0f7fch		;6e52	11 fc f7 	. . . 
	ld bc,l001eh+2		;6e55	01 20 00 	.   . 
	call HSSBL		;6e58	cd 2c 47 	. , G 
	jp HSRCV		;6e5b	c3 23 47 	. # G 
sub_6e5eh:
	jp HSRK		;6e5e	c3 52 47 	. R G 
	ex de,hl			;6e61	eb 	. 
	ld a,d			;6e62	7a 	z 
	or e			;6e63	b3 	. 
	jr z,l6e7fh		;6e64	28 19 	( . 
	call sub_6cc7h		;6e66	cd c7 6c 	. . l 
	call l6e7fh		;6e69	cd 7f 6e 	.  n 
	ret nz			;6e6c	c0 	. 
l6e6dh:
	ld c,040h		;6e6d	0e 40 	. @ 
	call HSSCOM		;6e6f	cd 0d 47 	. . G 
	call l6b70h		;6e72	cd 70 6b 	. p k 
	ret nz			;6e75	c0 	. 
	call sub_6bc5h		;6e76	cd c5 6b 	. . k 
	ld a,c			;6e79	79 	y 
	and 040h		;6e7a	e6 40 	. @ 
	jr nz,l6e6dh		;6e7c	20 ef 	  . 
	ret			;6e7e	c9 	. 
l6e7fh:
	call 06c38h		;6e7f	cd 38 6c 	. 8 l 
	jp 06c29h		;6e82	c3 29 6c 	. ) l 

; BLOCK 'CCPCODE' (start 0x6e85 end 0x7651)
CCPCODE_start:
	jp 0035ch		;6e85	c3 5c 03 	. \ . 
	jp l0358h		;6e88	c3 58 03 	. X . 
	ld a,a			;6e8b	7f 	 
	nop			;6e8c	00 	. 
	jr nz,l6eafh		;6e8d	20 20 	    
	jr nz,l6eb1h		;6e8f	20 20 	    
	jr nz,l6eb3h		;6e91	20 20 	    
	jr nz,l6eb5h		;6e93	20 20 	    
	jr nz,l6eb7h		;6e95	20 20 	    
	jr nz,l6eb9h		;6e97	20 20 	    
	jr nz,l6ebbh		;6e99	20 20 	    
	jr nz,l6ebdh		;6e9b	20 20 	    

; BLOCK 'CCPCOPYR' (start 0x6e9d end 0x6ec4)
CCPCOPYR_start:
	defb 043h		;6e9d	43 	C 
	defb 04fh		;6e9e	4f 	O 
	defb 050h		;6e9f	50 	P 
	defb 059h		;6ea0	59 	Y 
	defb 052h		;6ea1	52 	R 
	defb 049h		;6ea2	49 	I 
	defb 047h		;6ea3	47 	G 
	defb 048h		;6ea4	48 	H 
	defb 054h		;6ea5	54 	T 
	defb 020h		;6ea6	20 	  
	defb 028h		;6ea7	28 	( 
	defb 043h		;6ea8	43 	C 
	defb 029h		;6ea9	29 	) 
	defb 020h		;6eaa	20 	  
	defb 031h		;6eab	31 	1 
	defb 039h		;6eac	39 	9 
	defb 037h		;6ead	37 	7 
	defb 039h		;6eae	39 	9 
l6eafh:
	defb 02ch		;6eaf	2c 	, 
	defb 020h		;6eb0	20 	  
l6eb1h:
	defb 044h		;6eb1	44 	D 
	defb 049h		;6eb2	49 	I 
l6eb3h:
	defb 047h		;6eb3	47 	G 
	defb 049h		;6eb4	49 	I 
l6eb5h:
	defb 054h		;6eb5	54 	T 
	defb 041h		;6eb6	41 	A 
l6eb7h:
	defb 04ch		;6eb7	4c 	L 
	defb 020h		;6eb8	20 	  
l6eb9h:
	defb 052h		;6eb9	52 	R 
	defb 045h		;6eba	45 	E 
l6ebbh:
	defb 053h		;6ebb	53 	S 
	defb 045h		;6ebc	45 	E 
l6ebdh:
	defb 041h		;6ebd	41 	A 
	defb 052h		;6ebe	52 	R 
	defb 043h		;6ebf	43 	C 
l6ec0h:
	defb 048h		;6ec0	48 	H 
	defb 020h		;6ec1	20 	  
	defb 020h		;6ec2	20 	  
sub_6ec3h:
	defb 00eh		;6ec3	0e 	. 
CCPCOPYR_end:
	ld bc,l0538h+2		;6ec4	01 3a 05 	. : . 
	ret p			;6ec7	f0 	. 
	push af			;6ec8	f5 	. 
	and 0efh		;6ec9	e6 ef 	. . 
	out (018h),a		;6ecb	d3 18 	. . 
	ld (0f7b4h),hl		;6ecd	22 b4 f7 	" . . 
l6ed0h:
	ld a,(hl)			;6ed0	7e 	~ 
	or a			;6ed1	b7 	. 
	jr nz,l6edch		;6ed2	20 08 	  . 
	dec c			;6ed4	0d 	. 
	jr z,l6eeah		;6ed5	28 13 	( . 
	ld hl,(0f7b4h)		;6ed7	2a b4 f7 	* . . 
	jr l6ed0h		;6eda	18 f4 	. . 
l6edch:
	push bc			;6edc	c5 	. 
	ld c,a			;6edd	4f 	O 
	inc hl			;6ede	23 	# 
	ld b,(hl)			;6edf	46 	F 
	inc hl			;6ee0	23 	# 
	push hl			;6ee1	e5 	. 
	call sub_2a72h		;6ee2	cd 72 2a 	. r * 
	pop hl			;6ee5	e1 	. 
	pop bc			;6ee6	c1 	. 
	or a			;6ee7	b7 	. 
	jr z,l6ed0h		;6ee8	28 e6 	( . 
l6eeah:
	pop af			;6eea	f1 	. 
	out (018h),a		;6eeb	d3 18 	. . 
	ret			;6eed	c9 	. 
	ld bc,l0024h+1		;6eee	01 25 00 	. % . 
	inc bc			;6ef1	03 	. 
	dec h			;6ef2	25 	% 
	nop			;6ef3	00 	. 
	ld bc,l0125h		;6ef4	01 25 01 	. % . 
	add hl,hl			;6ef7	29 	) 
	nop			;6ef8	00 	. 
sub_6ef9h:
	ld a,(0f33ah)		;6ef9	3a 3a f3 	: : . 
	or a			;6efc	b7 	. 
	jr nz,l6f08h		;6efd	20 09 	  . 
sub_6effh:
	call sub_3c81h		;6eff	cd 81 3c 	. . < 
	ld a,(CSTOPFLG)		;6f02	3a 1a f0 	: . . 
	or a			;6f05	b7 	. 
	scf			;6f06	37 	7 
	ret nz			;6f07	c0 	. 
l6f08h:
	xor a			;6f08	af 	. 
	ret			;6f09	c9 	. 
	rst 38h			;6f0a	ff 	. 
	rst 38h			;6f0b	ff 	. 
	rst 38h			;6f0c	ff 	. 
	ex af,af'			;6f0d	08 	. 
	nop			;6f0e	00 	. 
	ld (l5f3dh),a		;6f0f	32 3d 5f 	2 = _ 
	ld c,002h		;6f12	0e 02 	. . 
	jp RBDOS1		;6f14	c3 05 00 	. . . 
	push bc			;6f17	c5 	. 
	call sub_008ch		;6f18	cd 8c 00 	. . . 
	pop bc			;6f1b	c1 	. 
	ret			;6f1c	c9 	. 
	ld a,00dh		;6f1d	3e 0d 	> . 
	call sub_0092h		;6f1f	cd 92 00 	. . . 
	ld a,00ah		;6f22	3e 0a 	> . 
	jp sub_0092h		;6f24	c3 92 00 	. . . 
	ld a,020h		;6f27	3e 20 	>   
	jp sub_0092h		;6f29	c3 92 00 	. . . 
	push bc			;6f2c	c5 	. 
	call 00098h		;6f2d	cd 98 00 	. . . 
	pop hl			;6f30	e1 	. 
	ld a,(hl)			;6f31	7e 	~ 
	or a			;6f32	b7 	. 
	ret z			;6f33	c8 	. 
	inc hl			;6f34	23 	# 
	push hl			;6f35	e5 	. 
	call sub_008ch		;6f36	cd 8c 00 	. . . 
	pop hl			;6f39	e1 	. 
	jp l00ach		;6f3a	c3 ac 00 	. . . 
l6f3dh:
	ld c,00dh		;6f3d	0e 0d 	. . 
	jp RBDOS1		;6f3f	c3 05 00 	. . . 
	ld e,a			;6f42	5f 	_ 
	ld c,00eh		;6f43	0e 0e 	. . 
	jp RBDOS1		;6f45	c3 05 00 	. . . 
	call RBDOS1		;6f48	cd 05 00 	. . . 
	ld (l07edh+1),a		;6f4b	32 ee 07 	2 . . 
	inc a			;6f4e	3c 	< 
	ret			;6f4f	c9 	. 
	ld c,00fh		;6f50	0e 0f 	. . 
	jp 000c3h		;6f52	c3 c3 00 	. . . 
	xor a			;6f55	af 	. 
	ld (l07edh),a		;6f56	32 ed 07 	2 . . 
	ld de,l07cdh		;6f59	11 cd 07 	. . . 
	jp l00cbh		;6f5c	c3 cb 00 	. . . 
	ld c,010h		;6f5f	0e 10 	. . 
	jp 000c3h		;6f61	c3 c3 00 	. . . 
	ld c,011h		;6f64	0e 11 	. . 
	jp 000c3h		;6f66	c3 c3 00 	. . . 
	ld c,012h		;6f69	0e 12 	. . 
	jp 000c3h		;6f6b	c3 c3 00 	. . . 
	ld de,l07cdh		;6f6e	11 cd 07 	. . . 
	jp 000dfh		;6f71	c3 df 00 	. . . 
	ld c,013h		;6f74	0e 13 	. . 
	jp RBDOS1		;6f76	c3 05 00 	. . . 
	call 0ea95h		;6f79	cd 95 ea 	. . . 
	or a			;6f7c	b7 	. 
	ret			;6f7d	c9 	. 
	ld c,014h		;6f7e	0e 14 	. . 
	jp l00f4h		;6f80	c3 f4 00 	. . . 
	ld de,l07cdh		;6f83	11 cd 07 	. . . 
	jp 000f9h		;6f86	c3 f9 00 	. . . 
	ld c,015h		;6f89	0e 15 	. . 
	jp l00f4h		;6f8b	c3 f4 00 	. . . 
	ld c,016h		;6f8e	0e 16 	. . 
	jp 000c3h		;6f90	c3 c3 00 	. . . 
	ld c,017h		;6f93	0e 17 	. . 
	jp RBDOS1		;6f95	c3 05 00 	. . . 
	ld e,0ffh		;6f98	1e ff 	. . 
	ld c,020h		;6f9a	0e 20 	.   
	jp RBDOS1		;6f9c	c3 05 00 	. . . 
	call sub_0113h		;6f9f	cd 13 01 	. . . 
	add a,a			;6fa2	87 	. 
	add a,a			;6fa3	87 	. 
	add a,a			;6fa4	87 	. 
	add a,a			;6fa5	87 	. 
	ld hl,l07edh+2		;6fa6	21 ef 07 	! . . 
	or (hl)			;6fa9	b6 	. 
	ld (l0003h+1),a		;6faa	32 04 00 	2 . . 
	ret			;6fad	c9 	. 
	ld a,(l07edh+2)		;6fae	3a ef 07 	: . . 
	ld (l0003h+1),a		;6fb1	32 04 00 	2 . . 
	ret			;6fb4	c9 	. 
	cp 061h		;6fb5	fe 61 	. a 
	ret c			;6fb7	d8 	. 
	cp 07bh		;6fb8	fe 7b 	. { 
	ret nc			;6fba	d0 	. 
	and 05fh		;6fbb	e6 5f 	. _ 
	ret			;6fbd	c9 	. 
	ld a,(l07abh)		;6fbe	3a ab 07 	: . . 
	or a			;6fc1	b7 	. 
	jp z,l0196h		;6fc2	ca 96 01 	. . . 
	ld a,(l07edh+2)		;6fc5	3a ef 07 	: . . 
	or a			;6fc8	b7 	. 
	ld a,000h		;6fc9	3e 00 	> . 
	call nz,sub_00bdh		;6fcb	c4 bd 00 	. . . 
	ld de,l07ach		;6fce	11 ac 07 	. . . 
	call l00cbh		;6fd1	cd cb 00 	. . . 
	jp z,l0196h		;6fd4	ca 96 01 	. . . 
	ld a,(l07bbh)		;6fd7	3a bb 07 	: . . 
	dec a			;6fda	3d 	= 
	ld (007cch),a		;6fdb	32 cc 07 	2 . . 
	ld de,l07ach		;6fde	11 ac 07 	. . . 
	call 000f9h		;6fe1	cd f9 00 	. . . 
	jp nz,l0196h		;6fe4	c2 96 01 	. . . 
	ld de,l0006h+1		;6fe7	11 07 00 	. . . 
	ld hl,l007fh+1		;6fea	21 80 00 	! . . 
	ld b,080h		;6fed	06 80 	. . 
	call sub_0440h+2		;6fef	cd 42 04 	. B . 
	ld hl,007bah		;6ff2	21 ba 07 	! . . 
	ld (hl),000h		;6ff5	36 00 	6 . 
	inc hl			;6ff7	23 	# 
	dec (hl)			;6ff8	35 	5 
	ld de,l07ach		;6ff9	11 ac 07 	. . . 
	call 000dah		;6ffc	cd da 00 	. . . 
	jp z,l0196h		;6fff	ca 96 01 	. . . 
	ld a,(l07edh+2)		;7002	3a ef 07 	: . . 
	or a			;7005	b7 	. 
	call nz,sub_00bdh		;7006	c4 bd 00 	. . . 
	ld hl,l0006h+2		;7009	21 08 00 	! . . 
	call l00ach		;700c	cd ac 00 	. . . 
	call 001c2h		;700f	cd c2 01 	. . . 
	jp z,l01a7h		;7012	ca a7 01 	. . . 
	call sub_01ddh		;7015	cd dd 01 	. . . 
	jp 00382h		;7018	c3 82 03 	. . . 
	call sub_01ddh		;701b	cd dd 01 	. . . 
	call 0011ah		;701e	cd 1a 01 	. . . 
	ld c,00ah		;7021	0e 0a 	. . 
	ld de,l0006h		;7023	11 06 00 	. . . 
	call RBDOS1		;7026	cd 05 00 	. . . 
	call 00129h		;7029	cd 29 01 	. ) . 
	ld hl,l0006h+1		;702c	21 07 00 	! . . 
	ld b,(hl)			;702f	46 	F 
	inc hl			;7030	23 	# 
	ld a,b			;7031	78 	x 
	or a			;7032	b7 	. 
	jp z,001bah		;7033	ca ba 01 	. . . 
	ld a,(hl)			;7036	7e 	~ 
	call l012fh+1		;7037	cd 30 01 	. 0 . 
	ld (hl),a			;703a	77 	w 
	dec b			;703b	05 	. 
	jp 001abh		;703c	c3 ab 01 	. . . 
	ld (hl),a			;703f	77 	w 
	ld hl,l0006h+2		;7040	21 08 00 	! . . 
	ld (00088h),hl		;7043	22 88 00 	" . . 
	ret			;7046	c9 	. 
	ld c,00bh		;7047	0e 0b 	. . 
	call RBDOS1		;7049	cd 05 00 	. . . 
	or a			;704c	b7 	. 
	ret z			;704d	c8 	. 
	ld c,001h		;704e	0e 01 	. . 
	call RBDOS1		;7050	cd 05 00 	. . . 
	or a			;7053	b7 	. 
	ret			;7054	c9 	. 
	ld c,019h		;7055	0e 19 	. . 
	jp RBDOS1		;7057	c3 05 00 	. . . 
	ld de,l007fh+1		;705a	11 80 00 	. . . 
	ld c,01ah		;705d	0e 1a 	. . 
	jp RBDOS1		;705f	c3 05 00 	. . . 
	ld hl,l07abh		;7062	21 ab 07 	! . . 
	ld a,(hl)			;7065	7e 	~ 
	or a			;7066	b7 	. 
	ret z			;7067	c8 	. 
	ld (hl),000h		;7068	36 00 	6 . 
	xor a			;706a	af 	. 
	call sub_00bdh		;706b	cd bd 00 	. . . 
	ld de,l07ach		;706e	11 ac 07 	. . . 
	call sub_00efh		;7071	cd ef 00 	. . . 
	ld a,(l07edh+2)		;7074	3a ef 07 	: . . 
	jp sub_00bdh		;7077	c3 bd 00 	. . . 
	ld de,l0327h+1		;707a	11 28 03 	. ( . 
	ld hl,l0800h		;707d	21 00 08 	! . . 
	ld b,006h		;7080	06 06 	. . 
	ld a,(de)			;7082	1a 	. 
	cp (hl)			;7083	be 	. 
	jp nz,l03cfh		;7084	c2 cf 03 	. . . 
	inc de			;7087	13 	. 
	inc hl			;7088	23 	# 
	dec b			;7089	05 	. 
	jp nz,l01fdh		;708a	c2 fd 01 	. . . 
	ret			;708d	c9 	. 
	call 00098h		;708e	cd 98 00 	. . . 
	ld hl,(l0089h+1)		;7091	2a 8a 00 	* . . 
	ld a,(hl)			;7094	7e 	~ 
	cp 020h		;7095	fe 20 	.   
	jp z,l0222h		;7097	ca 22 02 	. " . 
	or a			;709a	b7 	. 
	jp z,l0222h		;709b	ca 22 02 	. " . 
	push hl			;709e	e5 	. 
	call sub_008ch		;709f	cd 8c 00 	. . . 
	pop hl			;70a2	e1 	. 
	inc hl			;70a3	23 	# 
	jp l020fh		;70a4	c3 0f 02 	. . . 
	ld a,03fh		;70a7	3e 3f 	> ? 
	call sub_008ch		;70a9	cd 8c 00 	. . . 
	call 00098h		;70ac	cd 98 00 	. . . 
	call sub_01ddh		;70af	cd dd 01 	. . . 
	jp 00382h		;70b2	c3 82 03 	. . . 
	ld a,(de)			;70b5	1a 	. 
	or a			;70b6	b7 	. 
	ret z			;70b7	c8 	. 
	cp 020h		;70b8	fe 20 	.   
	jp c,l0209h		;70ba	da 09 02 	. . . 
	ret z			;70bd	c8 	. 
	cp 03dh		;70be	fe 3d 	. = 
	ret z			;70c0	c8 	. 
	cp 05fh		;70c1	fe 5f 	. _ 
	ret z			;70c3	c8 	. 
	cp 02eh		;70c4	fe 2e 	. . 
	ret z			;70c6	c8 	. 
	cp 03ah		;70c7	fe 3a 	. : 
	ret z			;70c9	c8 	. 
	cp 03bh		;70ca	fe 3b 	. ; 
	ret z			;70cc	c8 	. 
	cp 03ch		;70cd	fe 3c 	. < 
	ret z			;70cf	c8 	. 
	cp 03eh		;70d0	fe 3e 	. > 
	ret z			;70d2	c8 	. 
	ret			;70d3	c9 	. 
	ld a,(de)			;70d4	1a 	. 
	or a			;70d5	b7 	. 
	ret z			;70d6	c8 	. 
	cp 020h		;70d7	fe 20 	.   
	ret nz			;70d9	c0 	. 
	inc de			;70da	13 	. 
	jp sub_024eh+1		;70db	c3 4f 02 	. O . 
	add a,l			;70de	85 	. 
	ld l,a			;70df	6f 	o 
	ret nc			;70e0	d0 	. 
	inc h			;70e1	24 	$ 
	ret			;70e2	c9 	. 
	ld a,000h		;70e3	3e 00 	> . 
	ld hl,l07cdh		;70e5	21 cd 07 	! . . 
	call 00259h		;70e8	cd 59 02 	. Y . 
	push hl			;70eb	e5 	. 
	push hl			;70ec	e5 	. 
	xor a			;70ed	af 	. 
	ld (l07f0h),a		;70ee	32 f0 07 	2 . . 
	ld hl,(00088h)		;70f1	2a 88 00 	* . . 
	ex de,hl			;70f4	eb 	. 
	call sub_024eh+1		;70f5	cd 4f 02 	. O . 
	ex de,hl			;70f8	eb 	. 
	ld (l0089h+1),hl		;70f9	22 8a 00 	" . . 
	ex de,hl			;70fc	eb 	. 
	pop hl			;70fd	e1 	. 
	ld a,(de)			;70fe	1a 	. 
	or a			;70ff	b7 	. 
	jp z,l0289h		;7100	ca 89 02 	. . . 
	sbc a,040h		;7103	de 40 	. @ 
	ld b,a			;7105	47 	G 
	inc de			;7106	13 	. 
	ld a,(de)			;7107	1a 	. 
	cp 03ah		;7108	fe 3a 	. : 
	jp z,00290h		;710a	ca 90 02 	. . . 
	dec de			;710d	1b 	. 
	ld a,(l07edh+2)		;710e	3a ef 07 	: . . 
	ld (hl),a			;7111	77 	w 
	jp 00296h		;7112	c3 96 02 	. . . 
	ld a,b			;7115	78 	x 
	ld (l07f0h),a		;7116	32 f0 07 	2 . . 
	ld (hl),b			;7119	70 	p 
	inc de			;711a	13 	. 
	ld b,008h		;711b	06 08 	. . 
	call sub_0230h		;711d	cd 30 02 	. 0 . 
	jp z,002b9h		;7120	ca b9 02 	. . . 
	inc hl			;7123	23 	# 
	cp 02ah		;7124	fe 2a 	. * 
	jp nz,l02a9h		;7126	c2 a9 02 	. . . 
	ld (hl),03fh		;7129	36 3f 	6 ? 
	jp l02abh		;712b	c3 ab 02 	. . . 
	ld (hl),a			;712e	77 	w 
	inc de			;712f	13 	. 
	dec b			;7130	05 	. 
	jp nz,00298h		;7131	c2 98 02 	. . . 
	call sub_0230h		;7134	cd 30 02 	. 0 . 
	jp z,002c0h		;7137	ca c0 02 	. . . 
	inc de			;713a	13 	. 
	jp 002afh		;713b	c3 af 02 	. . . 
	inc hl			;713e	23 	# 
	ld (hl),020h		;713f	36 20 	6   
	dec b			;7141	05 	. 
	jp nz,002b9h		;7142	c2 b9 02 	. . . 
	ld b,003h		;7145	06 03 	. . 
	cp 02eh		;7147	fe 2e 	. . 
	jp nz,l02e9h		;7149	c2 e9 02 	. . . 
	inc de			;714c	13 	. 
	call sub_0230h		;714d	cd 30 02 	. 0 . 
	jp z,l02e9h		;7150	ca e9 02 	. . . 
	inc hl			;7153	23 	# 
	cp 02ah		;7154	fe 2a 	. * 
	jp nz,l02d7h+2		;7156	c2 d9 02 	. . . 
	ld (hl),03fh		;7159	36 3f 	6 ? 
	jp l02dbh		;715b	c3 db 02 	. . . 
	ld (hl),a			;715e	77 	w 
	inc de			;715f	13 	. 
	dec b			;7160	05 	. 
	jp nz,002c8h		;7161	c2 c8 02 	. . . 
	call sub_0230h		;7164	cd 30 02 	. 0 . 
	jp z,l02f0h		;7167	ca f0 02 	. . . 
	inc de			;716a	13 	. 
	jp sub_02dfh		;716b	c3 df 02 	. . . 
	inc hl			;716e	23 	# 
	ld (hl),020h		;716f	36 20 	6   
	dec b			;7171	05 	. 
	jp nz,l02e9h		;7172	c2 e9 02 	. . . 
	ld b,003h		;7175	06 03 	. . 
	inc hl			;7177	23 	# 
	ld (hl),000h		;7178	36 00 	6 . 
	dec b			;717a	05 	. 
	jp nz,l02f2h		;717b	c2 f2 02 	. . . 
	ex de,hl			;717e	eb 	. 
	ld (00088h),hl		;717f	22 88 00 	" . . 
	pop hl			;7182	e1 	. 
	ld bc,l0009h+2		;7183	01 0b 00 	. . . 
	inc hl			;7186	23 	# 
	ld a,(hl)			;7187	7e 	~ 
	cp 03fh		;7188	fe 3f 	. ? 
	jp nz,00309h		;718a	c2 09 03 	. . . 
	inc b			;718d	04 	. 
	dec c			;718e	0d 	. 
	jp nz,l0301h		;718f	c2 01 03 	. . . 
	ld a,b			;7192	78 	x 
	or a			;7193	b7 	. 
	ret			;7194	c9 	. 
	ld b,h			;7195	44 	D 
	ld c,c			;7196	49 	I 
	ld d,d			;7197	52 	R 
	jr nz,$+71		;7198	20 45 	  E 
	ld d,d			;719a	52 	R 
	ld b,c			;719b	41 	A 
	jr nz,$+86		;719c	20 54 	  T 
	ld e,c			;719e	59 	Y 
	ld d,b			;719f	50 	P 
	ld b,l			;71a0	45 	E 
	ld d,e			;71a1	53 	S 
	ld b,c			;71a2	41 	A 
	ld d,(hl)			;71a3	56 	V 
	ld b,l			;71a4	45 	E 
	ld d,d			;71a5	52 	R 
	ld b,l			;71a6	45 	E 
	ld c,(hl)			;71a7	4e 	N 
	jr nz,$+87		;71a8	20 55 	  U 
	ld d,e			;71aa	53 	S 
	ld b,l			;71ab	45 	E 
	ld d,d			;71ac	52 	R 
	call c,00316h		;71ad	dc 16 03 	. . . 
	nop			;71b0	00 	. 
	ld bc,02101h		;71b1	01 01 21 	. . ! 
	djnz l71b9h		;71b4	10 03 	. . 
	ld c,000h		;71b6	0e 00 	. . 
	ld a,c			;71b8	79 	y 
l71b9h:
	cp 006h		;71b9	fe 06 	. . 
	ret nc			;71bb	d0 	. 
	ld de,l07ceh		;71bc	11 ce 07 	. . . 
	ld b,004h		;71bf	06 04 	. . 
	ld a,(de)			;71c1	1a 	. 
	cp (hl)			;71c2	be 	. 
	jp nz,l034fh		;71c3	c2 4f 03 	. O . 
	inc de			;71c6	13 	. 
	inc hl			;71c7	23 	# 
	dec b			;71c8	05 	. 
	jp nz,l033ah+2		;71c9	c2 3c 03 	. < . 
	ld a,(de)			;71cc	1a 	. 
	cp 020h		;71cd	fe 20 	.   
	jp nz,sub_0352h+2		;71cf	c2 54 03 	. T . 
	ld a,c			;71d2	79 	y 
	ret			;71d3	c9 	. 
	inc hl			;71d4	23 	# 
	dec b			;71d5	05 	. 
	jp nz,l034fh		;71d6	c2 4f 03 	. O . 
	inc c			;71d9	0c 	. 
	jp l0333h		;71da	c3 33 03 	. 3 . 
	xor a			;71dd	af 	. 
	ld (l0006h+1),a		;71de	32 07 00 	2 . . 
	ld sp,l07abh		;71e1	31 ab 07 	1 . . 
	push bc			;71e4	c5 	. 
	ld a,c			;71e5	79 	y 
	rra			;71e6	1f 	. 
	rra			;71e7	1f 	. 
	rra			;71e8	1f 	. 
	rra			;71e9	1f 	. 
	and 00fh		;71ea	e6 0f 	. . 
	ld e,a			;71ec	5f 	_ 
	call sub_0113h+2		;71ed	cd 15 01 	. . . 
	call sub_00b8h		;71f0	cd b8 00 	. . . 
	ld (l07abh),a		;71f3	32 ab 07 	2 . . 
	pop bc			;71f6	c1 	. 
	ld a,c			;71f7	79 	y 
	and 00fh		;71f8	e6 0f 	. . 
	ld (l07edh+2),a		;71fa	32 ef 07 	2 . . 
	call sub_00bdh		;71fd	cd bd 00 	. . . 
	ld a,(l0006h+1)		;7200	3a 07 00 	: . . 
	or a			;7203	b7 	. 
	jp nz,l0398h		;7204	c2 98 03 	. . . 
	ld sp,l07abh		;7207	31 ab 07 	1 . . 
	call 00098h		;720a	cd 98 00 	. . . 
	call sub_01d0h		;720d	cd d0 01 	. . . 
	add a,041h		;7210	c6 41 	. A 
	call sub_008ch		;7212	cd 8c 00 	. . . 
	ld a,03eh		;7215	3e 3e 	> > 
	call sub_008ch		;7217	cd 8c 00 	. . . 
	call sub_0139h		;721a	cd 39 01 	. 9 . 
	ld de,l007fh+1		;721d	11 80 00 	. . . 
	call sub_01d8h		;7220	cd d8 01 	. . . 
	call sub_01d0h		;7223	cd d0 01 	. . . 
	ld (l07edh+2),a		;7226	32 ef 07 	2 . . 
	call sub_025eh		;7229	cd 5e 02 	. ^ . 
	call nz,l0209h		;722c	c4 09 02 	. . . 
	ld a,(l07f0h)		;722f	3a f0 07 	: . . 
	or a			;7232	b7 	. 
	jp nz,l06a5h		;7233	c2 a5 06 	. . . 
	call 0032eh		;7236	cd 2e 03 	. . . 
	ld hl,l03c1h		;7239	21 c1 03 	! . . 
	ld e,a			;723c	5f 	_ 
	ld d,000h		;723d	16 00 	. . 
	add hl,de			;723f	19 	. 
	add hl,de			;7240	19 	. 
	ld a,(hl)			;7241	7e 	~ 
	inc hl			;7242	23 	# 
	ld h,(hl)			;7243	66 	f 
	ld l,a			;7244	6f 	o 
	jp (hl)			;7245	e9 	. 
	ld (hl),a			;7246	77 	w 
	inc b			;7247	04 	. 
	rra			;7248	1f 	. 
	dec b			;7249	05 	. 
	ld e,l			;724a	5d 	] 
	dec b			;724b	05 	. 
	xor l			;724c	ad 	. 
	dec b			;724d	05 	. 
	djnz l7256h		;724e	10 06 	. . 
	adc a,(hl)			;7250	8e 	. 
	ld b,0a5h		;7251	06 a5 	. . 
	ld b,021h		;7253	06 21 	. ! 
	di			;7255	f3 	. 
l7256h:
	halt			;7256	76 	v 
	ld (COLDRST),hl		;7257	22 00 00 	" . . 
	ld hl,COLDRST		;725a	21 00 00 	! . . 
	jp (hl)			;725d	e9 	. 
	ld bc,003dfh		;725e	01 df 03 	. . . 
	jp l00a7h		;7261	c3 a7 00 	. . . 
	ld d,d			;7264	52 	R 
	ld b,l			;7265	45 	E 
	ld b,c			;7266	41 	A 
	ld b,h			;7267	44 	D 
	jr nz,l72afh		;7268	20 45 	  E 
	ld d,d			;726a	52 	R 
	ld d,d			;726b	52 	R 
	ld c,a			;726c	4f 	O 
	ld d,d			;726d	52 	R 
	nop			;726e	00 	. 
	ld bc,003f0h		;726f	01 f0 03 	. . . 
	jp l00a7h		;7272	c3 a7 00 	. . . 
	ld c,(hl)			;7275	4e 	N 
	ld c,a			;7276	4f 	O 
	jr nz,l72bfh		;7277	20 46 	  F 
	ld c,c			;7279	49 	I 
	ld c,h			;727a	4c 	L 
	ld b,l			;727b	45 	E 
	nop			;727c	00 	. 
	call sub_025eh		;727d	cd 5e 02 	. ^ . 
	ld a,(l07f0h)		;7280	3a f0 07 	: . . 
	or a			;7283	b7 	. 
	jp nz,l0209h		;7284	c2 09 02 	. . . 
	ld hl,l07ceh		;7287	21 ce 07 	! . . 
	ld bc,l0009h+2		;728a	01 0b 00 	. . . 
	ld a,(hl)			;728d	7e 	~ 
	cp 020h		;728e	fe 20 	.   
	jp z,00433h		;7290	ca 33 04 	. 3 . 
	inc hl			;7293	23 	# 
	sub 030h		;7294	d6 30 	. 0 
	cp 00ah		;7296	fe 0a 	. . 
	jp nc,l0209h		;7298	d2 09 02 	. . . 
	ld d,a			;729b	57 	W 
	ld a,b			;729c	78 	x 
	and 0e0h		;729d	e6 e0 	. . 
	jp nz,l0209h		;729f	c2 09 02 	. . . 
	ld a,b			;72a2	78 	x 
	rlca			;72a3	07 	. 
	rlca			;72a4	07 	. 
	rlca			;72a5	07 	. 
	add a,b			;72a6	80 	. 
	jp c,l0209h		;72a7	da 09 02 	. . . 
	add a,b			;72aa	80 	. 
	jp c,l0209h		;72ab	da 09 02 	. . . 
	add a,d			;72ae	82 	. 
l72afh:
	jp c,l0209h		;72af	da 09 02 	. . . 
	ld b,a			;72b2	47 	G 
	dec c			;72b3	0d 	. 
	jp nz,l0408h		;72b4	c2 08 04 	. . . 
	ret			;72b7	c9 	. 
	ld a,(hl)			;72b8	7e 	~ 
	cp 020h		;72b9	fe 20 	.   
	jp nz,l0209h		;72bb	c2 09 02 	. . . 
	inc hl			;72be	23 	# 
l72bfh:
	dec c			;72bf	0d 	. 
	jp nz,00433h		;72c0	c2 33 04 	. 3 . 
	ld a,b			;72c3	78 	x 
	ret			;72c4	c9 	. 
	ld b,003h		;72c5	06 03 	. . 
	ld a,(hl)			;72c7	7e 	~ 
	ld (de),a			;72c8	12 	. 
	inc hl			;72c9	23 	# 
	inc de			;72ca	13 	. 
	dec b			;72cb	05 	. 
	jp nz,sub_0440h+2		;72cc	c2 42 04 	. B . 
	ret			;72cf	c9 	. 
	ld hl,l007fh+1		;72d0	21 80 00 	! . . 
	add a,c			;72d3	81 	. 
	call 00259h		;72d4	cd 59 02 	. Y . 
	ld a,(hl)			;72d7	7e 	~ 
	ret			;72d8	c9 	. 
	xor a			;72d9	af 	. 
	ld (l07cdh),a		;72da	32 cd 07 	2 . . 
	ld a,(l07f0h)		;72dd	3a f0 07 	: . . 
	or a			;72e0	b7 	. 
	ret z			;72e1	c8 	. 
	dec a			;72e2	3d 	= 
	ld hl,l07edh+2		;72e3	21 ef 07 	! . . 
	cp (hl)			;72e6	be 	. 
	ret z			;72e7	c8 	. 
	jp sub_00bdh		;72e8	c3 bd 00 	. . . 
	ld a,(l07f0h)		;72eb	3a f0 07 	: . . 
	or a			;72ee	b7 	. 
	ret z			;72ef	c8 	. 
	dec a			;72f0	3d 	= 
	ld hl,l07edh+2		;72f1	21 ef 07 	! . . 
	cp (hl)			;72f4	be 	. 
	ret z			;72f5	c8 	. 
	ld a,(l07edh+2)		;72f6	3a ef 07 	: . . 
	jp sub_00bdh		;72f9	c3 bd 00 	. . . 
	call sub_025eh		;72fc	cd 5e 02 	. ^ . 
	call 00454h		;72ff	cd 54 04 	. T . 
	ld hl,l07ceh		;7302	21 ce 07 	! . . 
	ld a,(hl)			;7305	7e 	~ 
	cp 020h		;7306	fe 20 	.   
	jp nz,l048fh		;7308	c2 8f 04 	. . . 
	ld b,00bh		;730b	06 0b 	. . 
	ld (hl),03fh		;730d	36 3f 	6 ? 
	inc hl			;730f	23 	# 
	dec b			;7310	05 	. 
	jp nz,l0488h		;7311	c2 88 04 	. . . 
	ld e,000h		;7314	1e 00 	. . 
	push de			;7316	d5 	. 
	call 000e9h		;7317	cd e9 00 	. . . 
	call z,003eah		;731a	cc ea 03 	. . . 
	jp z,l051ah+1		;731d	ca 1b 05 	. . . 
	ld a,(l07edh+1)		;7320	3a ee 07 	: . . 
	rrca			;7323	0f 	. 
	rrca			;7324	0f 	. 
	rrca			;7325	0f 	. 
	and 060h		;7326	e6 60 	. ` 
	ld c,a			;7328	4f 	O 
	ld a,00ah		;7329	3e 0a 	> . 
	call 0044bh		;732b	cd 4b 04 	. K . 
	rla			;732e	17 	. 
	jp c,0050fh		;732f	da 0f 05 	. . . 
	pop de			;7332	d1 	. 
	ld a,e			;7333	7b 	{ 
	inc e			;7334	1c 	. 
	push de			;7335	d5 	. 
	and 001h		;7336	e6 01 	. . 
	push af			;7338	f5 	. 
	jp nz,l04cch		;7339	c2 cc 04 	. . . 
	call 00098h		;733c	cd 98 00 	. . . 
	push bc			;733f	c5 	. 
	call sub_01d0h		;7340	cd d0 01 	. . . 
	pop bc			;7343	c1 	. 
	add a,041h		;7344	c6 41 	. A 
	call sub_0092h		;7346	cd 92 00 	. . . 
	ld a,03ah		;7349	3e 3a 	> : 
	call sub_0092h		;734b	cd 92 00 	. . . 
	jp l04d4h		;734e	c3 d4 04 	. . . 
	call 000a2h		;7351	cd a2 00 	. . . 
	ld a,03ah		;7354	3e 3a 	> : 
	call sub_0092h		;7356	cd 92 00 	. . . 
	call 000a2h		;7359	cd a2 00 	. . . 
	ld b,001h		;735c	06 01 	. . 
	ld a,b			;735e	78 	x 
	call 0044bh		;735f	cd 4b 04 	. K . 
	and 07fh		;7362	e6 7f 	.  
	cp 020h		;7364	fe 20 	.   
	jp nz,CALADRS+1		;7366	c2 f9 04 	. . . 
	pop af			;7369	f1 	. 
	push af			;736a	f5 	. 
	cp 003h		;736b	fe 03 	. . 
	jp nz,l04f7h		;736d	c2 f7 04 	. . . 
	ld a,009h		;7370	3e 09 	> . 
	call 0044bh		;7372	cd 4b 04 	. K . 
	and 07fh		;7375	e6 7f 	.  
	cp 020h		;7377	fe 20 	.   
	jp z,0050eh		;7379	ca 0e 05 	. . . 
	ld a,020h		;737c	3e 20 	>   
	call sub_0092h		;737e	cd 92 00 	. . . 
	inc b			;7381	04 	. 
	ld a,b			;7382	78 	x 
	cp 00ch		;7383	fe 0c 	. . 
	jp nc,0050eh		;7385	d2 0e 05 	. . . 
	cp 009h		;7388	fe 09 	. . 
	jp nz,004d9h		;738a	c2 d9 04 	. . . 
	call 000a2h		;738d	cd a2 00 	. . . 
	jp 004d9h		;7390	c3 d9 04 	. . . 
	pop af			;7393	f1 	. 
	call 001c2h		;7394	cd c2 01 	. . . 
	jp nz,l051ah+1		;7397	c2 1b 05 	. . . 
	call 000e4h		;739a	cd e4 00 	. . . 
	jp 00498h		;739d	c3 98 04 	. . . 
	pop de			;73a0	d1 	. 
	jp l0786h		;73a1	c3 86 07 	. . . 
	call sub_025eh		;73a4	cd 5e 02 	. ^ . 
	cp 00bh		;73a7	fe 0b 	. . 
	jp nz,l0542h		;73a9	c2 42 05 	. B . 
	ld bc,l0552h		;73ac	01 52 05 	. R . 
	call l00a7h		;73af	cd a7 00 	. . . 
	call sub_0139h		;73b2	cd 39 01 	. 9 . 
	ld hl,l0006h+1		;73b5	21 07 00 	! . . 
	dec (hl)			;73b8	35 	5 
	jp nz,00382h		;73b9	c2 82 03 	. . . 
	inc hl			;73bc	23 	# 
	ld a,(hl)			;73bd	7e 	~ 
	cp 059h		;73be	fe 59 	. Y 
	jp nz,00382h		;73c0	c2 82 03 	. . . 
	inc hl			;73c3	23 	# 
	ld (00088h),hl		;73c4	22 88 00 	" . . 
	call 00454h		;73c7	cd 54 04 	. T . 
	ld de,l07cdh		;73ca	11 cd 07 	. . . 
	call sub_00efh		;73cd	cd ef 00 	. . . 
	inc a			;73d0	3c 	< 
	call z,003eah		;73d1	cc ea 03 	. . . 
	jp l0786h		;73d4	c3 86 07 	. . . 
	ld b,c			;73d7	41 	A 
	ld c,h			;73d8	4c 	L 
	ld c,h			;73d9	4c 	L 
	jr nz,$+42		;73da	20 28 	  ( 
	ld e,c			;73dc	59 	Y 
	cpl			;73dd	2f 	/ 
	ld c,(hl)			;73de	4e 	N 
	add hl,hl			;73df	29 	) 
	ccf			;73e0	3f 	? 
	nop			;73e1	00 	. 
	call sub_025eh		;73e2	cd 5e 02 	. ^ . 
	jp nz,l0209h		;73e5	c2 09 02 	. . . 
	call 00454h		;73e8	cd 54 04 	. T . 
	call l00ceh+2		;73eb	cd d0 00 	. . . 
	jp z,l05a6h+1		;73ee	ca a7 05 	. . . 
	call 00098h		;73f1	cd 98 00 	. . . 
	ld hl,l07f1h		;73f4	21 f1 07 	! . . 
	ld (hl),0ffh		;73f7	36 ff 	6 . 
	ld hl,l07f1h		;73f9	21 f1 07 	! . . 
	ld a,(hl)			;73fc	7e 	~ 
	cp 080h		;73fd	fe 80 	. . 
	jp c,l0587h		;73ff	da 87 05 	. . . 
	push hl			;7402	e5 	. 
	call l00fch+2		;7403	cd fe 00 	. . . 
	pop hl			;7406	e1 	. 
	jp nz,l05a0h		;7407	c2 a0 05 	. . . 
	xor a			;740a	af 	. 
	ld (hl),a			;740b	77 	w 
	inc (hl)			;740c	34 	4 
	ld hl,l007fh+1		;740d	21 80 00 	! . . 
	call 00259h		;7410	cd 59 02 	. Y . 
	ld a,(hl)			;7413	7e 	~ 
	cp 01ah		;7414	fe 1a 	. . 
	jp z,l0786h		;7416	ca 86 07 	. . . 
	call sub_008ch		;7419	cd 8c 00 	. . . 
	call 001c2h		;741c	cd c2 01 	. . . 
	jp nz,l0786h		;741f	c2 86 07 	. . . 
	jp l0574h		;7422	c3 74 05 	. t . 
	dec a			;7425	3d 	= 
	jp z,l0786h		;7426	ca 86 07 	. . . 
	call 003d9h		;7429	cd d9 03 	. . . 
	call l0466h		;742c	cd 66 04 	. f . 
	jp l0209h		;742f	c3 09 02 	. . . 
	call 003f8h		;7432	cd f8 03 	. . . 
	push af			;7435	f5 	. 
	call sub_025eh		;7436	cd 5e 02 	. ^ . 
	jp nz,l0209h		;7439	c2 09 02 	. . . 
	call 00454h		;743c	cd 54 04 	. T . 
	ld de,l07cdh		;743f	11 cd 07 	. . . 
	push de			;7442	d5 	. 
	call sub_00efh		;7443	cd ef 00 	. . . 
	pop de			;7446	d1 	. 
	call sub_0109h		;7447	cd 09 01 	. . . 
	jp z,l05fbh		;744a	ca fb 05 	. . . 
	xor a			;744d	af 	. 
	ld (l07edh),a		;744e	32 ed 07 	2 . . 
	pop af			;7451	f1 	. 
	ld l,a			;7452	6f 	o 
	ld h,000h		;7453	26 00 	& . 
	add hl,hl			;7455	29 	) 
	ld de,l00ffh+1		;7456	11 00 01 	. . . 
	ld a,h			;7459	7c 	| 
	or l			;745a	b5 	. 
	jp z,005f1h		;745b	ca f1 05 	. . . 
	dec hl			;745e	2b 	+ 
	push hl			;745f	e5 	. 
	ld hl,l007fh+1		;7460	21 80 00 	! . . 
	add hl,de			;7463	19 	. 
	push hl			;7464	e5 	. 
	call sub_01d8h		;7465	cd d8 01 	. . . 
	ld de,l07cdh		;7468	11 cd 07 	. . . 
	call 00104h		;746b	cd 04 01 	. . . 
	pop de			;746e	d1 	. 
	pop hl			;746f	e1 	. 
	jp nz,l05fbh		;7470	c2 fb 05 	. . . 
	jp 005d4h		;7473	c3 d4 05 	. . . 
	ld de,l07cdh		;7476	11 cd 07 	. . . 
	call 000dah		;7479	cd da 00 	. . . 
	inc a			;747c	3c 	< 
	jp nz,l0601h		;747d	c2 01 06 	. . . 
	ld bc,00607h		;7480	01 07 06 	. . . 
	call l00a7h		;7483	cd a7 00 	. . . 
	call sub_01d5h		;7486	cd d5 01 	. . . 
	jp l0786h		;7489	c3 86 07 	. . . 
	ld c,(hl)			;748c	4e 	N 
	ld c,a			;748d	4f 	O 
	jr nz,l74e3h		;748e	20 53 	  S 
	ld d,b			;7490	50 	P 
	ld b,c			;7491	41 	A 
	ld b,e			;7492	43 	C 
	ld b,l			;7493	45 	E 
	nop			;7494	00 	. 
	call sub_025eh		;7495	cd 5e 02 	. ^ . 
	jp nz,l0209h		;7498	c2 09 02 	. . . 
	ld a,(l07f0h)		;749b	3a f0 07 	: . . 
	push af			;749e	f5 	. 
	call 00454h		;749f	cd 54 04 	. T . 
	call 000e9h		;74a2	cd e9 00 	. . . 
	jp nz,l0679h		;74a5	c2 79 06 	. y . 
	ld hl,l07cdh		;74a8	21 cd 07 	! . . 
	ld de,l07ddh		;74ab	11 dd 07 	. . . 
	ld b,010h		;74ae	06 10 	. . 
	call sub_0440h+2		;74b0	cd 42 04 	. B . 
	ld hl,(00088h)		;74b3	2a 88 00 	* . . 
	ex de,hl			;74b6	eb 	. 
	call sub_024eh+1		;74b7	cd 4f 02 	. O . 
	cp 03dh		;74ba	fe 3d 	. = 
	jp z,l063fh		;74bc	ca 3f 06 	. ? . 
	cp 05fh		;74bf	fe 5f 	. _ 
	jp nz,00673h		;74c1	c2 73 06 	. s . 
	ex de,hl			;74c4	eb 	. 
	inc hl			;74c5	23 	# 
	ld (00088h),hl		;74c6	22 88 00 	" . . 
	call sub_025eh		;74c9	cd 5e 02 	. ^ . 
	jp nz,00673h		;74cc	c2 73 06 	. s . 
	pop af			;74cf	f1 	. 
	ld b,a			;74d0	47 	G 
	ld hl,l07f0h		;74d1	21 f0 07 	! . . 
	ld a,(hl)			;74d4	7e 	~ 
	or a			;74d5	b7 	. 
	jp z,00659h		;74d6	ca 59 06 	. Y . 
	cp b			;74d9	b8 	. 
	ld (hl),b			;74da	70 	p 
	jp nz,00673h		;74db	c2 73 06 	. s . 
	ld (hl),b			;74de	70 	p 
	xor a			;74df	af 	. 
	ld (l07cdh),a		;74e0	32 cd 07 	2 . . 
l74e3h:
	call 000e9h		;74e3	cd e9 00 	. . . 
	jp z,0066dh		;74e6	ca 6d 06 	. m . 
	ld de,l07cdh		;74e9	11 cd 07 	. . . 
	call l010eh		;74ec	cd 0e 01 	. . . 
	jp l0786h		;74ef	c3 86 07 	. . . 
	call 003eah		;74f2	cd ea 03 	. . . 
	jp l0786h		;74f5	c3 86 07 	. . . 
	call l0466h		;74f8	cd 66 04 	. f . 
	jp l0209h		;74fb	c3 09 02 	. . . 
	ld bc,l0682h		;74fe	01 82 06 	. . . 
	call l00a7h		;7501	cd a7 00 	. . . 
	jp l0786h		;7504	c3 86 07 	. . . 

; BLOCK 'FILEXTXT' (start 0x7507 end 0x7512)
FILEXTXT_start:
	defb 046h		;7507	46 	F 
	defb 049h		;7508	49 	I 
	defb 04ch		;7509	4c 	L 
	defb 045h		;750a	45 	E 
	defb 020h		;750b	20 	  
	defb 045h		;750c	45 	E 
	defb 058h		;750d	58 	X 
	defb 049h		;750e	49 	I 
	defb 053h		;750f	53 	S 
	defb 054h		;7510	54 	T 
	defb 053h		;7511	53 	S 
FILEXTXT_end:
	nop			;7512	00 	. 
	call 003f8h		;7513	cd f8 03 	. . . 
	cp 010h		;7516	fe 10 	. . 
	jp nc,l0209h		;7518	d2 09 02 	. . . 
	ld e,a			;751b	5f 	_ 
	ld a,(l07ceh)		;751c	3a ce 07 	: . . 
	cp 020h		;751f	fe 20 	.   
	jp z,l0209h		;7521	ca 09 02 	. . . 
	call sub_0113h+2		;7524	cd 15 01 	. . . 
	jp 00789h		;7527	c3 89 07 	. . . 
	call 001f5h		;752a	cd f5 01 	. . . 
	ld a,(l07ceh)		;752d	3a ce 07 	: . . 
	cp 020h		;7530	fe 20 	.   
	jp nz,l06c4h		;7532	c2 c4 06 	. . . 
	ld a,(l07f0h)		;7535	3a f0 07 	: . . 
	or a			;7538	b7 	. 
	jp z,00789h		;7539	ca 89 07 	. . . 
	dec a			;753c	3d 	= 
	ld (l07edh+2),a		;753d	32 ef 07 	2 . . 
	call 00129h		;7540	cd 29 01 	. ) . 
	call sub_00bdh		;7543	cd bd 00 	. . . 
	jp 00789h		;7546	c3 89 07 	. . . 
	ld de,l07d6h		;7549	11 d6 07 	. . . 
	ld a,(de)			;754c	1a 	. 
	cp 020h		;754d	fe 20 	.   
	jp nz,l0209h		;754f	c2 09 02 	. . . 
	push de			;7552	d5 	. 
	call 00454h		;7553	cd 54 04 	. T . 
	pop de			;7556	d1 	. 
	ld hl,00783h		;7557	21 83 07 	! . . 
	call sub_0440h		;755a	cd 40 04 	. @ . 
	call l00ceh+2		;755d	cd d0 00 	. . . 
	jp z,l076bh		;7560	ca 6b 07 	. k . 
	call 0ea8ch		;7563	cd 8c ea 	. . . 
	push hl			;7566	e5 	. 
	ex de,hl			;7567	eb 	. 
	call sub_01d8h		;7568	cd d8 01 	. . . 
	ld de,l07cdh		;756b	11 cd 07 	. . . 
	call 000f9h		;756e	cd f9 00 	. . . 
	jp nz,00701h		;7571	c2 01 07 	. . . 
	pop hl			;7574	e1 	. 
	ld de,l007fh+1		;7575	11 80 00 	. . . 
	add hl,de			;7578	19 	. 
	ld de,COLDRST		;7579	11 00 00 	. . . 
	ld a,l			;757c	7d 	} 
	sub e			;757d	93 	. 
	ld a,h			;757e	7c 	| 
	sbc a,d			;757f	9a 	. 
	jp nc,l0771h		;7580	d2 71 07 	. q . 
	jp 006e1h		;7583	c3 e1 06 	. . . 
	pop hl			;7586	e1 	. 
	dec a			;7587	3d 	= 
	jp nz,l0771h		;7588	c2 71 07 	. q . 
	call l0466h		;758b	cd 66 04 	. f . 
	call sub_025eh		;758e	cd 5e 02 	. ^ . 
	ld hl,l07f0h		;7591	21 f0 07 	! . . 
	push hl			;7594	e5 	. 
	ld a,(hl)			;7595	7e 	~ 
	ld (l07cdh),a		;7596	32 cd 07 	2 . . 
	ld a,010h		;7599	3e 10 	> . 
	call sub_025eh+2		;759b	cd 60 02 	. ` . 
	pop hl			;759e	e1 	. 
	ld a,(hl)			;759f	7e 	~ 
	ld (l07ddh),a		;75a0	32 dd 07 	2 . . 
	xor a			;75a3	af 	. 
	ld (l07edh),a		;75a4	32 ed 07 	2 . . 
	ld de,0005ch		;75a7	11 5c 00 	. \ . 
	ld hl,l07cdh		;75aa	21 cd 07 	! . . 
	ld b,021h		;75ad	06 21 	. ! 
	call sub_0440h+2		;75af	cd 42 04 	. B . 
	ld hl,l0006h+2		;75b2	21 08 00 	! . . 
	ld a,(hl)			;75b5	7e 	~ 
	or a			;75b6	b7 	. 
	jp z,0073eh		;75b7	ca 3e 07 	. > . 
	cp 020h		;75ba	fe 20 	.   
	jp z,0073eh		;75bc	ca 3e 07 	. > . 
	inc hl			;75bf	23 	# 
	jp l0730h		;75c0	c3 30 07 	. 0 . 
	ld b,000h		;75c3	06 00 	. . 
	ld de,l007fh+2		;75c5	11 81 00 	. . . 
	ld a,(hl)			;75c8	7e 	~ 
	ld (de),a			;75c9	12 	. 
	or a			;75ca	b7 	. 
	jp z,0074fh		;75cb	ca 4f 07 	. O . 
	inc b			;75ce	04 	. 
	inc hl			;75cf	23 	# 
	inc de			;75d0	13 	. 
	jp 00743h		;75d1	c3 43 07 	. C . 
	ld a,b			;75d4	78 	x 
	ld (l007fh+1),a		;75d5	32 80 00 	2 . . 
	call 00098h		;75d8	cd 98 00 	. . . 
	call sub_01d5h		;75db	cd d5 01 	. . . 
	call 0011ah		;75de	cd 1a 01 	. . . 
	call 0eac5h		;75e1	cd c5 ea 	. . . 
	ld sp,l07abh		;75e4	31 ab 07 	1 . . 
	call 00129h		;75e7	cd 29 01 	. ) . 
	call sub_00bdh		;75ea	cd bd 00 	. . . 
	jp 00382h		;75ed	c3 82 03 	. . . 
l75f0h:
	call l0466h		;75f0	cd 66 04 	. f . 
	jp l0209h		;75f3	c3 09 02 	. . . 
	ld bc,l077ah		;75f6	01 7a 07 	. z . 
	call l00a7h		;75f9	cd a7 00 	. . . 
	jp l0786h		;75fc	c3 86 07 	. . . 
	ld b,d			;75ff	42 	B 
	ld b,c			;7600	41 	A 
	ld b,h			;7601	44 	D 
	jr nz,l7650h		;7602	20 4c 	  L 
	ld c,a			;7604	4f 	O 
	ld b,c			;7605	41 	A 
	ld b,h			;7606	44 	D 
	nop			;7607	00 	. 
	ld b,e			;7608	43 	C 
	ld c,a			;7609	4f 	O 
	ld c,l			;760a	4d 	M 
	call l0466h		;760b	cd 66 04 	. f . 
	call sub_025eh		;760e	cd 5e 02 	. ^ . 
	ld a,(l07ceh)		;7611	3a ce 07 	: . . 
	sub 020h		;7614	d6 20 	.   
	ld hl,l07f0h		;7616	21 f0 07 	! . . 
	or (hl)			;7619	b6 	. 
	jp nz,l0209h		;761a	c2 09 02 	. . . 
	jp 00382h		;761d	c3 82 03 	. . . 

; BLOCK 'EPSONTXT2' (start 0x7620 end 0x763d)
EPSONTXT2_start:
	defb 045h		;7620	45 	E 
	defb 050h		;7621	50 	P 
	defb 053h		;7622	53 	S 
	defb 04fh		;7623	4f 	O 
	defb 04eh		;7624	4e 	N 
	defb 020h		;7625	20 	  
	defb 053h		;7626	53 	S 
	defb 044h		;7627	44 	D 
	defb 030h		;7628	30 	0 
	defb 031h		;7629	31 	1 
	defb 020h		;762a	20 	  
	defb 020h		;762b	20 	  
	defb 031h		;762c	31 	1 
	defb 039h		;762d	39 	9 
	defb 038h		;762e	38 	8 
	defb 033h		;762f	33 	3 
	defb 000h		;7630	00 	. 
	defb 000h		;7631	00 	. 
	defb 024h		;7632	24 	$ 
	defb 024h		;7633	24 	$ 
	defb 024h		;7634	24 	$ 
	defb 020h		;7635	20 	  
	defb 020h		;7636	20 	  
	defb 020h		;7637	20 	  
	defb 020h		;7638	20 	  
	defb 020h		;7639	20 	  
	defb 053h		;763a	53 	S 
	defb 055h		;763b	55 	U 
	defb 042h		;763c	42 	B 
EPSONTXT2_end:
	nop			;763d	00 	. 
	nop			;763e	00 	. 
	nop			;763f	00 	. 
	inc h			;7640	24 	$ 
	nop			;7641	00 	. 
	nop			;7642	00 	. 
	nop			;7643	00 	. 
	nop			;7644	00 	. 
	nop			;7645	00 	. 
	nop			;7646	00 	. 
	nop			;7647	00 	. 
	nop			;7648	00 	. 
	nop			;7649	00 	. 
	nop			;764a	00 	. 
	nop			;764b	00 	. 
	nop			;764c	00 	. 
	nop			;764d	00 	. 
	nop			;764e	00 	. 
	nop			;764f	00 	. 
l7650h:
	nop			;7650	00 	. 
CCPCODE_end:
	ld b,b			;7651	40 	@ 
	inc b			;7652	04 	. 
	ex af,af'			;7653	08 	. 
	ld b,d			;7654	42 	B 
	jr nz,$+19		;7655	20 11 	  . 
	nop			;7657	00 	. 
	nop			;7658	00 	. 
	add a,c			;7659	81 	. 
	ld (de),a			;765a	12 	. 
	ld b,d			;765b	42 	B 
	djnz l75f0h		;765c	10 92 	. . 
	nop			;765e	00 	. 
	inc b			;765f	04 	. 
	sub b			;7660	90 	. 
	add a,h			;7661	84 	. 
	nop			;7662	00 	. 
	ex af,af'			;7663	08 	. 
	djnz CCPEND		;7664	10 10 	. . 
	nop			;7666	00 	. 
	ld de,09220h		;7667	11 20 92 	.   . 
	ld c,b			;766a	48 	H 
	sub d			;766b	92 	. 
l766ch:
	ld c,b			;766c	48 	H 
	add hl,bc			;766d	09 	. 
	ld (bc),a			;766e	02 	. 
	ld c,c			;766f	49 	I 
	ld (de),a			;7670	12 	. 
	ld c,c			;7671	49 	I 
	inc h			;7672	24 	$ 
	sub b			;7673	90 	. 
	add a,d			;7674	82 	. 
	ld b,b			;7675	40 	@ 
CCPEND:
	adc a,b			;7676	88 	. 
	ld b,h			;7677	44 	D 
	add a,b			;7678	80 	. 
	nop			;7679	00 	. 
	nop			;767a	00 	. 
	ld bc,09200h		;767b	01 00 92 	. . . 
	ld c,c			;767e	49 	I 
	jr nz,l76c2h		;767f	20 41 	  A 
	ld (de),a			;7681	12 	. 
	ex af,af'			;7682	08 	. 
	adc a,b			;7683	88 	. 
	ld b,d			;7684	42 	B 
	ld c,c			;7685	49 	I 
	ld bc,COLDRST		;7686	01 00 00 	. . . 
	nop			;7689	00 	. 
	nop			;768a	00 	. 
	add a,b			;768b	80 	. 
	inc h			;768c	24 	$ 
	ld (de),a			;768d	12 	. 
	ld (00104h),hl		;768e	22 04 01 	" . . 
	ld de,02410h		;7691	11 10 24 	. . $ 
	djnz $-124		;7694	10 82 	. . 
	ld c,b			;7696	48 	H 
	add a,c			;7697	81 	. 
	ld (bc),a			;7698	02 	. 
	inc h			;7699	24 	$ 
	djnz $-124		;769a	10 82 	. . 
	ld c,b			;769c	48 	H 
	add a,c			;769d	81 	. 
	nop			;769e	00 	. 
	adc a,b			;769f	88 	. 
	ld bc,l0006h+2		;76a0	01 08 00 	. . . 
	nop			;76a3	00 	. 
	nop			;76a4	00 	. 
	nop			;76a5	00 	. 
	add a,b			;76a6	80 	. 
	ld b,b			;76a7	40 	@ 
l76a8h:
	add a,d			;76a8	82 	. 
	ex af,af'			;76a9	08 	. 
	ld de,l0012h		;76aa	11 12 00 	. . . 
	inc h			;76ad	24 	$ 
	add a,c			;76ae	81 	. 
	inc h			;76af	24 	$ 
	ld c,c			;76b0	49 	I 
	ld hl,l0408h+1		;76b1	21 09 04 	! . . 
	sub d			;76b4	92 	. 
	ld c,b			;76b5	48 	H 
	sub d			;76b6	92 	. 
	nop			;76b7	00 	. 
	ld hl,(l09a9h+1)		;76b8	2a aa 09 	* . . 
	ld (de),a			;76bb	12 	. 
	nop			;76bc	00 	. 
	add hl,bc			;76bd	09 	. 
	nop			;76be	00 	. 
	inc h			;76bf	24 	$ 
	ld c,b			;76c0	48 	H 
	inc b			;76c1	04 	. 
l76c2h:
	inc b			;76c2	04 	. 
	ex af,af'			;76c3	08 	. 
	ex af,af'			;76c4	08 	. 
	adc a,b			;76c5	88 	. 
	ld b,b			;76c6	40 	@ 
	add a,h			;76c7	84 	. 
	nop			;76c8	00 	. 
	ld b,b			;76c9	40 	@ 
	ld b,c			;76ca	41 	A 
	jr nz,CCPCODE_end		;76cb	20 84 	  . 
	add a,d			;76cd	82 	. 
	ld (de),a			;76ce	12 	. 
	ld c,c			;76cf	49 	I 
	inc b			;76d0	04 	. 
	ld (bc),a			;76d1	02 	. 
	add hl,bc			;76d2	09 	. 
	inc h			;76d3	24 	$ 
	nop			;76d4	00 	. 
	adc a,b			;76d5	88 	. 
	ld (bc),a			;76d6	02 	. 
	ld b,h			;76d7	44 	D 
	djnz l766ch		;76d8	10 92 	. . 
	ld (de),a			;76da	12 	. 
	ex af,af'			;76db	08 	. 
	djnz l76ffh		;76dc	10 21 	. ! 
	ld (bc),a			;76de	02 	. 
	djnz l7702h		;76df	10 21 	. ! 
	inc h			;76e1	24 	$ 
	ld c,c			;76e2	49 	I 
	ld (04942h),hl		;76e3	22 42 49 	" B I 
	ld (sub_4904h),hl		;76e6	22 04 49 	" . I 
	ld (l0140h),hl		;76e9	22 40 01 	" @ . 
	inc h			;76ec	24 	$ 
	sub d			;76ed	92 	. 
	ld b,d			;76ee	42 	B 
	ex af,af'			;76ef	08 	. 
	adc a,b			;76f0	88 	. 
	inc b			;76f1	04 	. 
	ld (de),a			;76f2	12 	. 
	ld c,c			;76f3	49 	I 
	ld (de),a			;76f4	12 	. 
	ld c,c			;76f5	49 	I 
	ld (de),a			;76f6	12 	. 
	ld c,b			;76f7	48 	H 
	adc a,c			;76f8	89 	. 
	djnz l76fbh		;76f9	10 00 	. . 
l76fbh:
	add a,b			;76fb	80 	. 
	inc h			;76fc	24 	$ 
	add a,h			;76fd	84 	. 
	sub d			;76fe	92 	. 
l76ffh:
	inc h			;76ff	24 	$ 
	sub d			;7700	92 	. 
	nop			;7701	00 	. 
l7702h:
	inc h			;7702	24 	$ 
	adc a,c			;7703	89 	. 
	inc h			;7704	24 	$ 
	add a,h			;7705	84 	. 
	adc a,b			;7706	88 	. 
	ld b,d			;7707	42 	B 
	ld (de),a			;7708	12 	. 
	ld b,d			;7709	42 	B 
	djnz $-122		;770a	10 84 	. . 
	sub d			;770c	92 	. 
	ld c,c			;770d	49 	I 
	inc h			;770e	24 	$ 
	sub d			;770f	92 	. 
	ld b,b			;7710	40 	@ 
	nop			;7711	00 	. 
	add a,h			;7712	84 	. 
	ld b,d			;7713	42 	B 
	ld c,c			;7714	49 	I 
	ld hl,l2422h		;7715	21 22 24 	! " $ 
	sub d			;7718	92 	. 
	ex af,af'			;7719	08 	. 
	adc a,c			;771a	89 	. 
	inc h			;771b	24 	$ 
	inc b			;771c	04 	. 
	sub d			;771d	92 	. 
	ld (bc),a			;771e	02 	. 
	inc b			;771f	04 	. 
	add a,h			;7720	84 	. 
	sub d			;7721	92 	. 
	djnz l76a8h		;7722	10 84 	. . 
	ld b,c			;7724	41 	A 
	add hl,bc			;7725	09 	. 
	ex af,af'			;7726	08 	. 
	ld b,h			;7727	44 	D 
	nop			;7728	00 	. 
	add a,d			;7729	82 	. 
	inc b			;772a	04 	. 
	sub b			;772b	90 	. 
	ld c,c			;772c	49 	I 
	inc h			;772d	24 	$ 
	sub d			;772e	92 	. 
	ld b,b			;772f	40 	@ 
	nop			;7730	00 	. 
	sub d			;7731	92 	. 
	ld de,l001eh+2		;7732	11 20 00 	.   . 
	nop			;7735	00 	. 
	nop			;7736	00 	. 
	nop			;7737	00 	. 
l7738h:
	call c,00316h		;7738	dc 16 03 	. . . 
	nop			;773b	00 	. 
	ld bc,0c301h		;773c	01 01 c3 	. . . 
	ld de,08feah		;773f	11 ea 8f 	. . . 
	defb 0edh;next byte illegal after ed		;7742	ed 	. 
	sub h			;7743	94 	. 
	defb 0edh;next byte illegal after ed		;7744	ed 	. 
	sbc a,c			;7745	99 	. 
	defb 0edh;next byte illegal after ed		;7746	ed 	. 
	sbc a,(hl)			;7747	9e 	. 
	defb 0edh;next byte illegal after ed		;7748	ed 	. 
	ld (0f523h),sp		;7749	ed 73 23 f5 	. s # . 
	ld sp,0ff8fh		;774d	31 8f ff 	1 . . 
	ld (0f525h),de		;7750	ed 53 25 f5 	. S % . 
	ld a,(l0003h)		;7754	3a 03 00 	: . . 
	ld (RIOBYTE),a		;7757	32 29 f5 	2 ) . 
	ld a,c			;775a	79 	y 
	cp 009h		;775b	fe 09 	. . 
	jr nz,l7778h		;775d	20 19 	  . 
	ex de,hl			;775f	eb 	. 
l7760h:
	ld a,(hl)			;7760	7e 	~ 
	cp 024h		;7761	fe 24 	. $ 
	jr z,l77bah		;7763	28 55 	( U 
	inc hl			;7765	23 	# 
	push af			;7766	f5 	. 
	call 0eca0h		;7767	cd a0 ec 	. . . 
	pop af			;776a	f1 	. 
	push bc			;776b	c5 	. 
	ld c,a			;776c	4f 	O 
	push hl			;776d	e5 	. 
	call sub_1d53h		;776e	cd 53 1d 	. S . 
	pop hl			;7771	e1 	. 
	pop bc			;7772	c1 	. 
	call 0ec9ah		;7773	cd 9a ec 	. . . 
	jr l7760h		;7776	18 e8 	. . 
l7778h:
	cp 029h		;7778	fe 29 	. ) 
	jr c,l7782h		;777a	38 06 	8 . 
	cp 0fbh		;777c	fe fb 	. . 
	jr c,l77b5h		;777e	38 35 	8 5 
	sub 0d2h		;7780	d6 d2 	. . 
l7782h:
	ld (0f527h),a		;7782	32 27 f5 	2 ' . 
	ld c,a			;7785	4f 	O 
	push bc			;7786	c5 	. 
	ld a,(0f534h)		;7787	3a 34 f5 	: 4 . 
	ld (0f528h),a		;778a	32 28 f5 	2 ( . 
	call 0ee2eh		;778d	cd 2e ee 	. . . 
	call 0ee43h		;7790	cd 43 ee 	. C . 
	call 0eca0h		;7793	cd a0 ec 	. . . 
	pop bc			;7796	c1 	. 
	jr nc,l779ch		;7797	30 03 	0 . 
	ld de,0f88dh		;7799	11 8d f8 	. . . 
l779ch:
	call 01bc9h		;779c	cd c9 1b 	. . . 
	push bc			;779f	c5 	. 
	push af			;77a0	f5 	. 
	ld bc,(0f528h)		;77a1	ed 4b 28 f5 	. K ( . 
	call 0ec9ah		;77a5	cd 9a ec 	. . . 
	call 0ee44h		;77a8	cd 44 ee 	. D . 
	ld a,(0f527h)		;77ab	3a 27 f5 	: ' . 
	cp 015h		;77ae	fe 15 	. . 
	call nz,0ee2fh		;77b0	c4 2f ee 	. / . 
	pop af			;77b3	f1 	. 
	pop bc			;77b4	c1 	. 
l77b5h:
	ld sp,(0f523h)		;77b5	ed 7b 23 f5 	. { # . 
	ret			;77b9	c9 	. 
l77bah:
	ld hl,COLDRST		;77ba	21 00 00 	! . . 
	ld (0f4e5h),hl		;77bd	22 e5 f4 	" . . 
	ld a,l			;77c0	7d 	} 
	ld b,h			;77c1	44 	D 
	jr l77b5h		;77c2	18 f1 	. . 
	ld hl,0f316h		;77c4	21 16 f3 	! . . 
	ld (hl),0ffh		;77c7	36 ff 	6 . 
	ld hl,l00ffh+1		;77c9	21 00 01 	! . . 
	ret			;77cc	c9 	. 
	push bc			;77cd	c5 	. 
	ld b,a			;77ce	47 	G 
	xor a			;77cf	af 	. 
	ld (0f539h),a		;77d0	32 39 f5 	2 9 . 
	ld a,c			;77d3	79 	y 
	cp 014h		;77d4	fe 14 	. . 
	ld a,b			;77d6	78 	x 
	pop bc			;77d7	c1 	. 
	jp nz,RBDOS1		;77d8	c2 05 00 	. . . 
	call RBDOS1		;77db	cd 05 00 	. . . 
	push bc			;77de	c5 	. 
	ld b,a			;77df	47 	G 
	ld a,(0f316h)		;77e0	3a 16 f3 	: . . 
	or a			;77e3	b7 	. 
	ld a,b			;77e4	78 	x 
	pop bc			;77e5	c1 	. 
	ret z			;77e6	c8 	. 
	push bc			;77e7	c5 	. 
	ld b,a			;77e8	47 	G 
	xor a			;77e9	af 	. 
	ld (0f316h),a		;77ea	32 16 f3 	2 . . 
	ld a,b			;77ed	78 	x 
	pop bc			;77ee	c1 	. 
	or a			;77ef	b7 	. 
	jr z,l77f5h		;77f0	28 03 	( . 
	dec a			;77f2	3d 	= 
	jr nz,l77fbh		;77f3	20 06 	  . 
l77f5h:
	ld a,001h		;77f5	3e 01 	> . 
	ld (0f539h),a		;77f7	32 39 f5 	2 9 . 
	ret			;77fa	c9 	. 
l77fbh:
	inc a			;77fb	3c 	< 
	ret			;77fc	c9 	. 
	push bc			;77fd	c5 	. 
	ld b,a			;77fe	47 	G 
	ld a,(0f539h)		;77ff	3a 39 f5 	: 9 . 
	or a			;7802	b7 	. 
	ld a,b			;7803	78 	x 
	pop bc			;7804	c1 	. 
	jp z,l00ffh+1		;7805	ca 00 01 	. . . 
	push hl			;7808	e5 	. 
	ld (USRSBI),sp		;7809	ed 73 35 f5 	. s 5 . 
	ld sp,0ff1fh		;780d	31 1f ff 	1 . . 
	push bc			;7810	c5 	. 
	ld b,a			;7811	47 	G 
	xor a			;7812	af 	. 
	ld (0f539h),a		;7813	32 39 f5 	2 9 . 
	ld a,(0f53ah)		;7816	3a 3a f5 	: : . 
	ld c,a			;7819	4f 	O 
	call 0ec9ah		;781a	cd 9a ec 	. . . 
	ld a,b			;781d	78 	x 
	pop bc			;781e	c1 	. 
	ld hl,(0f53bh)		;781f	2a 3b f5 	* ; . 
	jp (hl)			;7822	e9 	. 
	push bc			;7823	c5 	. 
	call 0ecach		;7824	cd ac ec 	. . . 
	pop de			;7827	d1 	. 
	push bc			;7828	c5 	. 
	ld b,d			;7829	42 	B 
	ld c,e			;782a	4b 	K 
	call l4066h		;782b	cd 66 40 	. f @ 
	pop de			;782e	d1 	. 
	push bc			;782f	c5 	. 
	ld c,e			;7830	4b 	K 
	call 0ecb2h		;7831	cd b2 ec 	. . . 
	pop bc			;7834	c1 	. 
	ret			;7835	c9 	. 
l7836h:
	ld (USRSBI),sp		;7836	ed 73 35 f5 	. s 5 . 
	ld sp,0ff1fh		;783a	31 1f ff 	1 . . 
	push hl			;783d	e5 	. 
	ld sp,(USRSBI)		;783e	ed 7b 35 f5 	. { 5 . 
	pop hl			;7842	e1 	. 
	ld (USRSBI),sp		;7843	ed 73 35 f5 	. s 5 . 
	ld sp,0ff1dh		;7847	31 1d ff 	1 . . 
	push de			;784a	d5 	. 
	push af			;784b	f5 	. 
	push bc			;784c	c5 	. 
	ld de,0eb03h		;784d	11 03 eb 	. . . 
	xor a			;7850	af 	. 
	sbc hl,de		;7851	ed 52 	. R 
	ld a,h			;7853	7c 	| 
	or a			;7854	b7 	. 
	jr nz,l78a1h		;7855	20 4a 	  J 
	ld a,l			;7857	7d 	} 
	cp 08eh		;7858	fe 8e 	. . 
	jr nc,l78a1h		;785a	30 45 	0 E 
	ld (0f537h),hl		;785c	22 37 f5 	" 7 . 
	cp 024h		;785f	fe 24 	. $ 
	jr nz,l786bh		;7861	20 08 	  . 
	pop hl			;7863	e1 	. 
l7864h:
	ld (0f325h),hl		;7864	22 25 f3 	" % . 
	ld hl,0f8b1h		;7867	21 b1 f8 	! . . 
	push hl			;786a	e5 	. 
l786bh:
	cp 02ah		;786b	fe 2a 	. * 
	call z,0ee36h		;786d	cc 36 ee 	. 6 . 
	ld a,(l0003h)		;7870	3a 03 00 	: . . 
	ld (RIOBYTE),a		;7873	32 29 f5 	2 ) . 
	call 0eca0h		;7876	cd a0 ec 	. . . 
	ld a,c			;7879	79 	y 
	ld (OLDBNK),a		;787a	32 2c f5 	2 , . 
	ld hl,(0f537h)		;787d	2a 37 f5 	* 7 . 
	ld de,l2a39h		;7880	11 39 2a 	. 9 * 
	add hl,de			;7883	19 	. 
	ld (0ebe3h),hl		;7884	22 e3 eb 	" . . 
	pop bc			;7887	c1 	. 
	pop af			;7888	f1 	. 
	pop de			;7889	d1 	. 
	pop hl			;788a	e1 	. 
	call COLDRST		;788b	cd 00 00 	. . . 
	push bc			;788e	c5 	. 
	push af			;788f	f5 	. 
	ld bc,(OLDBNK)		;7890	ed 4b 2c f5 	. K , . 
	call 0ec9ah		;7894	cd 9a ec 	. . . 
	ld a,(0f537h)		;7897	3a 37 f5 	: 7 . 
	cp 027h		;789a	fe 27 	. ' 
	ld c,000h		;789c	0e 00 	. . 
	call z,0ee35h		;789e	cc 35 ee 	. 5 . 
l78a1h:
	pop af			;78a1	f1 	. 
	pop bc			;78a2	c1 	. 
	ld sp,(USRSBI)		;78a3	ed 7b 35 f5 	. { 5 . 
	ret			;78a7	c9 	. 
	push de			;78a8	d5 	. 
	call 0eca0h		;78a9	cd a0 ec 	. . . 
	push bc			;78ac	c5 	. 
	call SETERR		;78ad	cd 94 1b 	. . . 
	pop bc			;78b0	c1 	. 
	call 0ec9ah		;78b1	cd 9a ec 	. . . 
	pop de			;78b4	d1 	. 
	ld a,(0f10ah)		;78b5	3a 0a f1 	: . . 
	call 0ec31h		;78b8	cd 31 ec 	. 1 . 
	jr nz,l78c4h		;78bb	20 07 	  . 
	ld a,(0f10bh)		;78bd	3a 0b f1 	: . . 
	call 0ec31h		;78c0	cd 31 ec 	. 1 . 
	ret z			;78c3	c8 	. 
l78c4h:
	call 0ea8ch		;78c4	cd 8c ea 	. . . 
	ld c,014h		;78c7	0e 14 	. . 
	call 0ec35h		;78c9	cd 35 ec 	. 5 . 
	ld hl,0f316h		;78cc	21 16 f3 	! . . 
	ld a,(hl)			;78cf	7e 	~ 
	or a			;78d0	b7 	. 
	ret z			;78d1	c8 	. 
	ld (0f539h),a		;78d2	32 39 f5 	2 9 . 
	xor a			;78d5	af 	. 
	ld (hl),a			;78d6	77 	w 
	jp 0eac5h		;78d7	c3 c5 ea 	. . . 
	inc a			;78da	3c 	< 
	ld (de),a			;78db	12 	. 
	ld c,00fh		;78dc	0e 0f 	. . 
	push de			;78de	d5 	. 
	call 0ea06h		;78df	cd 06 ea 	. . . 
	pop de			;78e2	d1 	. 
	inc a			;78e3	3c 	< 
	ret			;78e4	c9 	. 
	ld hl,sub_29d2h		;78e5	21 d2 29 	! . ) 
	jr l78edh		;78e8	18 03 	. . 
	ld hl,sub_29e6h		;78ea	21 e6 29 	! . ) 
l78edh:
	ld (USRSBI),sp		;78ed	ed 73 35 f5 	. s 5 . 
	ld sp,0ff1fh		;78f1	31 1f ff 	1 . . 
	call 0eca0h		;78f4	cd a0 ec 	. . . 
	push bc			;78f7	c5 	. 
	ld bc,0ec55h		;78f8	01 55 ec 	. U . 
	push bc			;78fb	c5 	. 
	push hl			;78fc	e5 	. 
	ret			;78fd	c9 	. 
	pop bc			;78fe	c1 	. 
	call 0ec9ah		;78ff	cd 9a ec 	. . . 
	ld sp,(USRSBI)		;7902	ed 7b 35 f5 	. { 5 . 
	ret			;7906	c9 	. 
	di			;7907	f3 	. 
	call 0ece6h		;7908	cd e6 ec 	. . . 
	ei			;790b	fb 	. 
	ret			;790c	c9 	. 
	di			;790d	f3 	. 
	call 0ecd5h		;790e	cd d5 ec 	. . . 
	ei			;7911	fb 	. 
	ret			;7912	c9 	. 
	di			;7913	f3 	. 
	call 0ecdch		;7914	cd dc ec 	. . . 
	ei			;7917	fb 	. 
	ret			;7918	c9 	. 
	di			;7919	f3 	. 
	call 0ed20h		;791a	cd 20 ed 	.   . 
	ei			;791d	fb 	. 
	ret			;791e	c9 	. 
	di			;791f	f3 	. 
	call 0ed46h		;7920	cd 46 ed 	. F . 
	ei			;7923	fb 	. 
	ret			;7924	c9 	. 
	di			;7925	f3 	. 
	call 0ed4ch		;7926	cd 4c ed 	. L . 
	ei			;7929	fb 	. 
	ret			;792a	c9 	. 
	di			;792b	f3 	. 
	call 0ed5fh		;792c	cd 5f ed 	. _ . 
	ei			;792f	fb 	. 
	ret			;7930	c9 	. 
	di			;7931	f3 	. 
	call 0ed66h		;7932	cd 66 ed 	. f . 
	ei			;7935	fb 	. 
	ret			;7936	c9 	. 
	di			;7937	f3 	. 
	call 0ed52h		;7938	cd 52 ed 	. R . 
	ei			;793b	fb 	. 
	ret			;793c	c9 	. 
l793dh:
	di			;793d	f3 	. 
	call 0ed15h		;793e	cd 15 ed 	. . . 
	ei			;7941	fb 	. 
	ret			;7942	c9 	. 
	di			;7943	f3 	. 
	call 0ecb2h		;7944	cd b2 ec 	. . . 
	ei			;7947	fb 	. 
	ret			;7948	c9 	. 
	di			;7949	f3 	. 
	call 0ecach		;794a	cd ac ec 	. . . 
	ei			;794d	fb 	. 
	ret			;794e	c9 	. 
	di			;794f	f3 	. 
	call 0ecb0h		;7950	cd b0 ec 	. . . 
	ei			;7953	fb 	. 
	ret			;7954	c9 	. 
	ld c,0ffh		;7955	0e ff 	. . 
	jr l795bh		;7957	18 02 	. . 
	ld c,000h		;7959	0e 00 	. . 
l795bh:
	push af			;795b	f5 	. 
	push hl			;795c	e5 	. 
	push bc			;795d	c5 	. 
	ld a,c			;795e	79 	y 
	inc c			;795f	0c 	. 
	ld b,000h		;7960	06 00 	. . 
	ld hl,0f530h		;7962	21 30 f5 	! 0 . 
	add hl,bc			;7965	09 	. 
	ld bc,(0f534h)		;7966	ed 4b 34 f5 	. K 4 . 
	ld (0f534h),a		;796a	32 34 f5 	2 4 . 
	ld a,c			;796d	79 	y 
	pop bc			;796e	c1 	. 
	ld c,a			;796f	4f 	O 
	ld a,(0f53dh)		;7970	3a 3d f5 	: = . 
	and 00fh		;7973	e6 0f 	. . 
	or (hl)			;7975	b6 	. 
	ld (0f53dh),a		;7976	32 3d f5 	2 = . 
	out (005h),a		;7979	d3 05 	. . 
	pop hl			;797b	e1 	. 
	pop af			;797c	f1 	. 
	ret			;797d	c9 	. 
	push bc			;797e	c5 	. 
	call 0ecb2h		;797f	cd b2 ec 	. . . 
	ld a,(hl)			;7982	7e 	~ 
	jr l798ah		;7983	18 05 	. . 
	push bc			;7985	c5 	. 
	call 0ecb2h		;7986	cd b2 ec 	. . . 
	ld (hl),a			;7989	77 	w 
l798ah:
	call 0ecb2h		;798a	cd b2 ec 	. . . 
	pop bc			;798d	c1 	. 
	ret			;798e	c9 	. 
	push af			;798f	f5 	. 
	ld (0f52dh),a		;7990	32 2d f5 	2 - . 
	ld a,(0f534h)		;7993	3a 34 f5 	: 4 . 
	push af			;7996	f5 	. 
l7997h:
	push bc			;7997	c5 	. 
	ld bc,(0f52dh)		;7998	ed 4b 2d f5 	. K - . 
	call 0ecd5h		;799c	cd d5 ec 	. . . 
	ex de,hl			;799f	eb 	. 
	ld c,000h		;79a0	0e 00 	. . 
	call 0ecdch		;79a2	cd dc ec 	. . . 
	ex de,hl			;79a5	eb 	. 
	inc de			;79a6	13 	. 
	inc hl			;79a7	23 	# 
	pop bc			;79a8	c1 	. 
	dec bc			;79a9	0b 	. 
	ld a,b			;79aa	78 	x 
	or c			;79ab	b1 	. 
	jr nz,l7997h		;79ac	20 e9 	  . 
	pop af			;79ae	f1 	. 
	ld c,a			;79af	4f 	O 
	call 0ecb2h		;79b0	cd b2 ec 	. . . 
	pop bc			;79b3	c1 	. 
	ld a,c			;79b4	79 	y 
	and 0c1h		;79b5	e6 c1 	. . 
	ld c,a			;79b7	4f 	O 
	ld b,000h		;79b8	06 00 	. . 
	push bc			;79ba	c5 	. 
	pop af			;79bb	f1 	. 
	ld c,a			;79bc	4f 	O 
	ret			;79bd	c9 	. 
	push bc			;79be	c5 	. 
	ld bc,(0f52eh)		;79bf	ed 4b 2e f5 	. K . . 
	call 0ecb2h		;79c3	cd b2 ec 	. . . 
	pop bc			;79c6	c1 	. 
	jp (ix)		;79c7	dd e9 	. . 
	push bc			;79c9	c5 	. 
	push af			;79ca	f5 	. 
	ld bc,(0f52eh)		;79cb	ed 4b 2e f5 	. K . . 
	call 0ecb2h		;79cf	cd b2 ec 	. . . 
	ld a,c			;79d2	79 	y 
	ld (0f52fh),a		;79d3	32 2f f5 	2 / . 
	ld (0ed34h),ix		;79d6	dd 22 34 ed 	. " 4 . 
	pop af			;79da	f1 	. 
	pop bc			;79db	c1 	. 
	call COLDRST		;79dc	cd 00 00 	. . . 
	push bc			;79df	c5 	. 
	ld bc,(0f52fh)		;79e0	ed 4b 2f f5 	. K / . 
	jr l798ah		;79e4	18 a4 	. . 
	call 0ecb0h		;79e6	cd b0 ec 	. . . 
	ld bc,0ecach		;79e9	01 ac ec 	. . . 
	push bc			;79ec	c5 	. 
	jp (ix)		;79ed	dd e9 	. . 
	call 0ed71h		;79ef	cd 71 ed 	. q . 
	ld (hl),a			;79f2	77 	w 
	jr l7a14h		;79f3	18 1f 	. . 
	call 0ed71h		;79f5	cd 71 ed 	. q . 
	ld a,(hl)			;79f8	7e 	~ 
	jr l7a14h		;79f9	18 19 	. . 
	push bc			;79fb	c5 	. 
	ld c,a			;79fc	4f 	O 
	call 0ecb2h		;79fd	cd b2 ec 	. . . 
	ld a,c			;7a00	79 	y 
	pop bc			;7a01	c1 	. 
	ldir		;7a02	ed b0 	. . 
	ld c,a			;7a04	4f 	O 
	jp 0ecb2h		;7a05	c3 b2 ec 	. . . 
	call 0ed71h		;7a08	cd 71 ed 	. q . 
	lddr		;7a0b	ed b8 	. . 
	jr l7a14h		;7a0d	18 05 	. . 
	call 0ed71h		;7a0f	cd 71 ed 	. q . 
	ldir		;7a12	ed b0 	. . 
l7a14h:
	push af			;7a14	f5 	. 
	ld a,(0f53dh)		;7a15	3a 3d f5 	: = . 
	jr l7a22h		;7a18	18 08 	. . 
	push af			;7a1a	f5 	. 
	ld a,(0f53dh)		;7a1b	3a 3d f5 	: = . 
	and 00fh		;7a1e	e6 0f 	. . 
	or 040h		;7a20	f6 40 	. @ 
l7a22h:
	out (005h),a		;7a22	d3 05 	. . 
	pop af			;7a24	f1 	. 
	ret			;7a25	c9 	. 
	push de			;7a26	d5 	. 
	call 0eca6h		;7a27	cd a6 ec 	. . . 
	ld hl,(0ef24h)		;7a2a	2a 24 ef 	* $ . 
	ld de,l0009h		;7a2d	11 09 00 	. . . 
	add hl,de			;7a30	19 	. 
	pop de			;7a31	d1 	. 
	add hl,de			;7a32	19 	. 
	ld a,(hl)			;7a33	7e 	~ 
	inc hl			;7a34	23 	# 
	ld h,(hl)			;7a35	66 	f 
	ld l,a			;7a36	6f 	o 
	jp (hl)			;7a37	e9 	. 
	ld hl,l1c5ch		;7a38	21 5c 1c 	! \ . 
	jr l7a4ah		;7a3b	18 0d 	. . 
	ld hl,l1ecdh		;7a3d	21 cd 1e 	! . . 
	jr l7a4ah		;7a40	18 08 	. . 
	ld hl,l1c6eh		;7a42	21 6e 1c 	! n . 
	jr l7a4ah		;7a45	18 03 	. . 
	ld hl,l1c74h		;7a47	21 74 1c 	! t . 
l7a4ah:
	call 0eca0h		;7a4a	cd a0 ec 	. . . 
	jp (hl)			;7a4d	e9 	. 
	ld h,001h		;7a4e	26 01 	& . 
	ld a,(sub_0225h+1)		;7a50	3a 26 02 	: & . 
	ld a,(00326h)		;7a53	3a 26 03 	: & . 
	ld a,(00426h)		;7a56	3a 26 04 	: & . 
	ld l,0ffh		;7a59	2e ff 	. . 
	ld (0f4e5h),hl		;7a5b	22 e5 f4 	" . . 
	call 0eca0h		;7a5e	cd a0 ec 	. . . 
	jp GOBACK		;7a61	c3 37 29 	. 7 ) 

; BLOCK 'NOPBLK1' (start 0x7a64 end 0x7ac9)
NOPBLK1_start:
	defb 000h		;7a64	00 	. 
	defb 000h		;7a65	00 	. 
	defb 000h		;7a66	00 	. 
	defb 000h		;7a67	00 	. 
	defb 000h		;7a68	00 	. 
	defb 000h		;7a69	00 	. 
	defb 000h		;7a6a	00 	. 
	defb 000h		;7a6b	00 	. 
	defb 000h		;7a6c	00 	. 
	defb 000h		;7a6d	00 	. 
	defb 000h		;7a6e	00 	. 
	defb 000h		;7a6f	00 	. 
	defb 000h		;7a70	00 	. 
	defb 000h		;7a71	00 	. 
	defb 000h		;7a72	00 	. 
	defb 001h		;7a73	01 	. 
	defb 001h		;7a74	01 	. 
	defb 001h		;7a75	01 	. 
	defb 000h		;7a76	00 	. 
	defb 001h		;7a77	01 	. 
	defb 001h		;7a78	01 	. 
	defb 001h		;7a79	01 	. 
	defb 001h		;7a7a	01 	. 
	defb 001h		;7a7b	01 	. 
	defb 000h		;7a7c	00 	. 
	defb 000h		;7a7d	00 	. 
	defb 000h		;7a7e	00 	. 
	defb 000h		;7a7f	00 	. 
	defb 000h		;7a80	00 	. 
	defb 000h		;7a81	00 	. 
	defb 001h		;7a82	01 	. 
	defb 000h		;7a83	00 	. 
	defb 000h		;7a84	00 	. 
	defb 001h		;7a85	01 	. 
	defb 001h		;7a86	01 	. 
	defb 001h		;7a87	01 	. 
	defb 001h		;7a88	01 	. 
	defb 000h		;7a89	00 	. 
	defb 000h		;7a8a	00 	. 
	defb 000h		;7a8b	00 	. 
	defb 001h		;7a8c	01 	. 
	defb 001h		;7a8d	01 	. 
	defb 000h		;7a8e	00 	. 
	defb 000h		;7a8f	00 	. 
	defb 000h		;7a90	00 	. 
	defb 001h		;7a91	01 	. 
	defb 000h		;7a92	00 	. 
	defb 000h		;7a93	00 	. 
	defb 000h		;7a94	00 	. 
	defb 000h		;7a95	00 	. 
	defb 000h		;7a96	00 	. 
	defb 000h		;7a97	00 	. 
	defb 000h		;7a98	00 	. 
	defb 000h		;7a99	00 	. 
	defb 000h		;7a9a	00 	. 
	defb 000h		;7a9b	00 	. 
	defb 000h		;7a9c	00 	. 
	defb 000h		;7a9d	00 	. 
	defb 000h		;7a9e	00 	. 
	defb 000h		;7a9f	00 	. 
	defb 000h		;7aa0	00 	. 
	defb 000h		;7aa1	00 	. 
	defb 000h		;7aa2	00 	. 
	defb 001h		;7aa3	01 	. 
	defb 001h		;7aa4	01 	. 
	defb 000h		;7aa5	00 	. 
	defb 001h		;7aa6	01 	. 
	defb 001h		;7aa7	01 	. 
	defb 000h		;7aa8	00 	. 
	defb 000h		;7aa9	00 	. 
	defb 000h		;7aaa	00 	. 
	defb 000h		;7aab	00 	. 
	defb 000h		;7aac	00 	. 
	defb 000h		;7aad	00 	. 
	defb 000h		;7aae	00 	. 
	defb 000h		;7aaf	00 	. 
	defb 000h		;7ab0	00 	. 
	defb 000h		;7ab1	00 	. 
	defb 000h		;7ab2	00 	. 
	defb 001h		;7ab3	01 	. 
	defb 001h		;7ab4	01 	. 
	defb 000h		;7ab5	00 	. 
	defb 000h		;7ab6	00 	. 
	defb 000h		;7ab7	00 	. 
	defb 000h		;7ab8	00 	. 
	defb 000h		;7ab9	00 	. 
	defb 001h		;7aba	01 	. 
	defb 000h		;7abb	00 	. 
	defb 000h		;7abc	00 	. 
	defb 000h		;7abd	00 	. 
	defb 001h		;7abe	01 	. 
	defb 000h		;7abf	00 	. 
	defb 0e5h		;7ac0	e5 	. 
	defb 021h		;7ac1	21 	! 
	defb 0e9h		;7ac2	e9 	. 
	defb 0edh		;7ac3	ed 	. 
	defb 018h		;7ac4	18 	. 
	defb 004h		;7ac5	04 	. 
	defb 0e5h		;7ac6	e5 	. 
	defb 021h		;7ac7	21 	! 
	defb 0bbh		;7ac8	bb 	. 
NOPBLK1_end:
	defb 0edh;next byte illegal after ed		;7ac9	ed 	. 
	ld a,(0f527h)		;7aca	3a 27 f5 	: ' . 
	add a,l			;7acd	85 	. 
	ld l,a			;7ace	6f 	o 
	ld a,000h		;7acf	3e 00 	> . 
	adc a,h			;7ad1	8c 	. 
	ld h,a			;7ad2	67 	g 
	ld a,(hl)			;7ad3	7e 	~ 
	rra			;7ad4	1f 	. 
	pop hl			;7ad5	e1 	. 
	ret			;7ad6	c9 	. 
	ld bc,l000ch+2		;7ad7	01 0e 00 	. . . 
	call 0ee17h		;7ada	cd 17 ee 	. . . 
	ret nc			;7add	d0 	. 
	ld a,c			;7ade	79 	y 
	push hl			;7adf	e5 	. 
	push de			;7ae0	d5 	. 
	ld hl,(0f325h)		;7ae1	2a 25 f3 	* % . 
	ld de,0f8b1h		;7ae4	11 b1 f8 	. . . 
	ld bc,l007fh+1		;7ae7	01 80 00 	. . . 
	jr l7affh		;7aea	18 13 	. . 
	ld bc,l000ch+2		;7aec	01 0e 00 	. . . 
	call 0ee1dh		;7aef	cd 1d ee 	. . . 
	ret nc			;7af2	d0 	. 
	push hl			;7af3	e5 	. 
	push de			;7af4	d5 	. 
	ld a,c			;7af5	79 	y 
	ld hl,(0f525h)		;7af6	2a 25 f5 	* % . 
	ld de,0f88dh		;7af9	11 8d f8 	. . . 
	ld bc,l0024h		;7afc	01 24 00 	. $ . 
l7affh:
	inc a			;7aff	3c 	< 
	dec a			;7b00	3d 	= 
	jr nz,l7b04h		;7b01	20 01 	  . 
	ex de,hl			;7b03	eb 	. 
l7b04h:
	ldir		;7b04	ed b0 	. . 
	pop de			;7b06	d1 	. 
	pop hl			;7b07	e1 	. 
	ret			;7b08	c9 	. 
	ld (0f4d3h),sp		;7b09	ed 73 d3 f4 	. s . . 
	push af			;7b0d	f5 	. 
	ld a,(0efd2h)		;7b0e	3a d2 ef 	: . . 
	inc a			;7b11	3c 	< 
	ld (0efd2h),a		;7b12	32 d2 ef 	2 . . 
	jr nz,l7b1dh		;7b15	20 06 	  . 
	pop af			;7b17	f1 	. 
	ld sp,(0efd4h)		;7b18	ed 7b d4 ef 	. { . . 
	push af			;7b1c	f5 	. 
l7b1dh:
	push bc			;7b1d	c5 	. 
	push de			;7b1e	d5 	. 
	push hl			;7b1f	e5 	. 
	ld hl,(0f4d3h)		;7b20	2a d3 f4 	* . . 
	push hl			;7b23	e5 	. 
	call 0ecach		;7b24	cd ac ec 	. . . 
	push bc			;7b27	c5 	. 
	call sub_07a6h		;7b28	cd a6 07 	. . . 
	pop bc			;7b2b	c1 	. 
	call 0ecb2h		;7b2c	cd b2 ec 	. . . 
	ld hl,0efd2h		;7b2f	21 d2 ef 	! . . 
	dec (hl)			;7b32	35 	5 
	pop hl			;7b33	e1 	. 
	ld (0f4d3h),hl		;7b34	22 d3 f4 	" . . 
	jr l7b50h		;7b37	18 17 	. . 
	ld (0f4d3h),sp		;7b39	ed 73 d3 f4 	. s . . 
	ld sp,(0efd6h)		;7b3d	ed 7b d6 ef 	. { . . 
	push af			;7b41	f5 	. 
	push bc			;7b42	c5 	. 
	push de			;7b43	d5 	. 
	push hl			;7b44	e5 	. 
	call 0ecach		;7b45	cd ac ec 	. . . 
	push bc			;7b48	c5 	. 
	call sub_09aeh		;7b49	cd ae 09 	. . . 
	pop bc			;7b4c	c1 	. 
	call 0ecb2h		;7b4d	cd b2 ec 	. . . 
l7b50h:
	pop hl			;7b50	e1 	. 
	pop de			;7b51	d1 	. 
	pop bc			;7b52	c1 	. 
	pop af			;7b53	f1 	. 
l7b54h:
	ld sp,(0f4d3h)		;7b54	ed 7b d3 f4 	. { . . 
	ei			;7b58	fb 	. 
	reti		;7b59	ed 4d 	. M 
	ld (0f4d3h),sp		;7b5b	ed 73 d3 f4 	. s . . 
	ld sp,(0efd8h)		;7b5f	ed 7b d8 ef 	. { . . 
	push hl			;7b63	e5 	. 
	ld hl,0efd3h		;7b64	21 d3 ef 	! . . 
	set 4,(hl)		;7b67	cb e6 	. . 
	push bc			;7b69	c5 	. 
	call 0ecb0h		;7b6a	cd b0 ec 	. . . 
	call 0ffd5h		;7b6d	cd d5 ff 	. . . 
l7b70h:
	call 0ecb2h		;7b70	cd b2 ec 	. . . 
	pop bc			;7b73	c1 	. 
	pop hl			;7b74	e1 	. 
	jr l7b54h		;7b75	18 dd 	. . 
	ld (0f4d3h),sp		;7b77	ed 73 d3 f4 	. s . . 
	ld sp,(0efdah)		;7b7b	ed 7b da ef 	. { . . 
	push af			;7b7f	f5 	. 
	push bc			;7b80	c5 	. 
	push de			;7b81	d5 	. 
	push hl			;7b82	e5 	. 
	call 0ecb0h		;7b83	cd b0 ec 	. . . 
	push bc			;7b86	c5 	. 
	call 0ffd8h		;7b87	cd d8 ff 	. . . 
	call 0ecach		;7b8a	cd ac ec 	. . . 
	call sub_0b92h		;7b8d	cd 92 0b 	. . . 
	pop bc			;7b90	c1 	. 
	call 0ecb2h		;7b91	cd b2 ec 	. . . 
	jr l7b50h		;7b94	18 ba 	. . 
	ld (0f4d3h),sp		;7b96	ed 73 d3 f4 	. s . . 
	ld sp,(0efdch)		;7b9a	ed 7b dc ef 	. { . . 
	push hl			;7b9e	e5 	. 
	ld hl,0efd3h		;7b9f	21 d3 ef 	! . . 
	set 2,(hl)		;7ba2	cb d6 	. . 
	push bc			;7ba4	c5 	. 
	call 0ecb0h		;7ba5	cd b0 ec 	. . . 
	call 0ffdbh		;7ba8	cd db ff 	. . . 
	jr l7b70h		;7bab	18 c3 	. . 
l7badh:
	ret			;7bad	c9 	. 
	nop			;7bae	00 	. 
	ld e,a			;7baf	5f 	_ 
	nop			;7bb0	00 	. 
	ld d,(hl)			;7bb1	56 	V 
	nop			;7bb2	00 	. 
	ld e,(hl)			;7bb3	5e 	^ 
	nop			;7bb4	00 	. 
	ld e,a			;7bb5	5f 	_ 
	nop			;7bb6	00 	. 
	nop			;7bb7	00 	. 
	ld bc,l1b00h		;7bb8	01 00 1b 	. . . 
	nop			;7bbb	00 	. 
	ld de,l0012h+1		;7bbc	11 13 00 	. . . 
	sbc a,e			;7bbf	9b 	. 
	call m,sub_00efh+1		;7bc0	fc f0 00 	. . . 
	dec c			;7bc3	0d 	. 
	inc bc			;7bc4	03 	. 
	nop			;7bc5	00 	. 
	inc bc			;7bc6	03 	. 
	rst 38h			;7bc7	ff 	. 
	xor 06eh		;7bc8	ee 6e 	. n 
	pop af			;7bca	f1 	. 
	ld l,(hl)			;7bcb	6e 	n 
	call p,0056eh		;7bcc	f4 6e 05 	. n . 
	inc l			;7bcf	2c 	, 
	ld bc,COLDRST		;7bd0	01 00 00 	. . . 
l7bd3h:
	ld b,e			;7bd3	43 	C 
	ld b,d			;7bd4	42 	B 
	ld b,c			;7bd5	41 	A 
	jr nz,$+34		;7bd6	20 20 	    
	jr nz,$+34		;7bd8	20 20 	    
	jr nz,$+34		;7bda	20 20 	    
	jr nz,$+34		;7bdc	20 20 	    
	ld b,e			;7bde	43 	C 
	ld c,a			;7bdf	4f 	O 
	ld c,l			;7be0	4d 	M 
	jr nz,l7c03h		;7be1	20 20 	    
	jr nz,l7c05h		;7be3	20 20 	    
	jr nz,l7c07h		;7be5	20 20 	    
	jr nz,l7c09h		;7be7	20 20 	    
	jr nz,l7c0bh		;7be9	20 20 	    
	jr nz,l7c2fh		;7beb	20 42 	  B 
	ld b,c			;7bed	41 	A 
	ld d,e			;7bee	53 	S 
	jr nz,l7c33h		;7bef	20 42 	  B 
	ld a,(04142h)		;7bf1	3a 42 41 	: B A 
	ld d,e			;7bf4	53 	S 
	ld c,c			;7bf5	49 	I 
	ld b,e			;7bf6	43 	C 
	jr nz,l7c19h		;7bf7	20 20 	    
	jr nz,l7c1bh		;7bf9	20 20 	    
	jr nz,l7c1dh		;7bfb	20 20 	    
	jr nz,l7c1fh		;7bfd	20 20 	    
	jr nz,l7c21h		;7bff	20 20 	    
	jr nz,l7c23h		;7c01	20 20 	    
l7c03h:
	jr nz,l7c25h		;7c03	20 20 	    
l7c05h:
	jr nz,l7c27h		;7c05	20 20 	    
l7c07h:
	jr nz,l7c29h		;7c07	20 20 	    
l7c09h:
	jr nz,l7c2bh		;7c09	20 20 	    
l7c0bh:
	jr nz,l7c2dh		;7c0b	20 20 	    
	jr nz,l7c2fh		;7c0d	20 20 	    
	jr nz,l7c31h		;7c0f	20 20 	    
	jr nz,l7c33h		;7c11	20 20 	    
	jr nz,l7c35h		;7c13	20 20 	    
	jr nz,l7c1ah		;7c15	20 03 	  . 
	nop			;7c17	00 	. 
	nop			;7c18	00 	. 
l7c19h:
	rst 18h			;7c19	df 	. 
l7c1ah:
	di			;7c1a	f3 	. 
l7c1bh:
	nop			;7c1b	00 	. 
	nop			;7c1c	00 	. 
l7c1dh:
	nop			;7c1d	00 	. 
	nop			;7c1e	00 	. 
l7c1fh:
	nop			;7c1f	00 	. 
	nop			;7c20	00 	. 
l7c21h:
	ld a,(bc)			;7c21	0a 	. 
	nop			;7c22	00 	. 
l7c23h:
	nop			;7c23	00 	. 
	nop			;7c24	00 	. 
l7c25h:
	nop			;7c25	00 	. 
	nop			;7c26	00 	. 
l7c27h:
	nop			;7c27	00 	. 
	nop			;7c28	00 	. 
l7c29h:
	nop			;7c29	00 	. 
	nop			;7c2a	00 	. 
l7c2bh:
	nop			;7c2b	00 	. 
	nop			;7c2c	00 	. 
l7c2dh:
	nop			;7c2d	00 	. 
	nop			;7c2e	00 	. 
l7c2fh:
	nop			;7c2f	00 	. 
	nop			;7c30	00 	. 
l7c31h:
	nop			;7c31	00 	. 
	nop			;7c32	00 	. 
l7c33h:
	nop			;7c33	00 	. 
	nop			;7c34	00 	. 
l7c35h:
	nop			;7c35	00 	. 
	nop			;7c36	00 	. 
	nop			;7c37	00 	. 
	nop			;7c38	00 	. 
	nop			;7c39	00 	. 
	nop			;7c3a	00 	. 
	nop			;7c3b	00 	. 
	nop			;7c3c	00 	. 
	nop			;7c3d	00 	. 
	nop			;7c3e	00 	. 
	nop			;7c3f	00 	. 
	nop			;7c40	00 	. 
	nop			;7c41	00 	. 
	nop			;7c42	00 	. 
	nop			;7c43	00 	. 
	nop			;7c44	00 	. 
	nop			;7c45	00 	. 
	nop			;7c46	00 	. 
	nop			;7c47	00 	. 
	inc b			;7c48	04 	. 
	ld d,b			;7c49	50 	P 
	nop			;7c4a	00 	. 
	nop			;7c4b	00 	. 
	nop			;7c4c	00 	. 
	nop			;7c4d	00 	. 
	rst 38h			;7c4e	ff 	. 
	ld b,c			;7c4f	41 	A 
	ld b,b			;7c50	40 	@ 
l7c51h:
	scf			;7c51	37 	7 
	nop			;7c52	00 	. 
	rst 38h			;7c53	ff 	. 
	nop			;7c54	00 	. 
	jp l57fch+2		;7c55	c3 fe 57 	. . W 
	cp 0fbh		;7c58	fe fb 	. . 
	dec iy		;7c5a	fd 2b 	. + 
	cp 0ebh		;7c5c	fe eb 	. . 
	defb 0fdh,000h,010h	;illegal sequence		;7c5e	fd 00 10 	. . . 
	inc b			;7c61	04 	. 
	nop			;7c62	00 	. 
	ld (bc),a			;7c63	02 	. 
	ld (de),a			;7c64	12 	. 
	inc b			;7c65	04 	. 
	ld (bc),a			;7c66	02 	. 
	ex af,af'			;7c67	08 	. 
	djnz l7c72h		;7c68	10 08 	. . 
	ex af,af'			;7c6a	08 	. 
	ex af,af'			;7c6b	08 	. 
	djnz l7c76h		;7c6c	10 08 	. . 
	ex af,af'			;7c6e	08 	. 
	nop			;7c6f	00 	. 
	nop			;7c70	00 	. 
	nop			;7c71	00 	. 
l7c72h:
	nop			;7c72	00 	. 
	nop			;7c73	00 	. 
	dec de			;7c74	1b 	. 
	ret nc			;7c75	d0 	. 
l7c76h:
	add hl,de			;7c76	19 	. 
	ld d,b			;7c77	50 	P 
	dec de			;7c78	1b 	. 
	sub l			;7c79	95 	. 
	ld (bc),a			;7c7a	02 	. 
	nop			;7c7b	00 	. 
	dec de			;7c7c	1b 	. 
	inc sp			;7c7d	33 	3 
	dec de			;7c7e	1b 	. 
	sub 000h		;7c7f	d6 00 	. . 
	rst 38h			;7c81	ff 	. 
	ld h,b			;7c82	60 	` 
	nop			;7c83	00 	. 
	add a,h			;7c84	84 	. 
	nop			;7c85	00 	. 
	ld a,(bc)			;7c86	0a 	. 
	ld c,000h		;7c87	0e 00 	. . 
	nop			;7c89	00 	. 
	nop			;7c8a	00 	. 
	nop			;7c8b	00 	. 
	ld h,b			;7c8c	60 	` 
	ret m			;7c8d	f8 	. 
	ld h,b			;7c8e	60 	` 
	ret m			;7c8f	f8 	. 
	nop			;7c90	00 	. 
	ld a,d			;7c91	7a 	z 
	ld c,e			;7c92	4b 	K 
	dec l			;7c93	2d 	- 
	ret p			;7c94	f0 	. 
	nop			;7c95	00 	. 
	nop			;7c96	00 	. 
	nop			;7c97	00 	. 
	nop			;7c98	00 	. 
	nop			;7c99	00 	. 
	nop			;7c9a	00 	. 
	nop			;7c9b	00 	. 
	nop			;7c9c	00 	. 
	nop			;7c9d	00 	. 
	nop			;7c9e	00 	. 
	inc bc			;7c9f	03 	. 
	inc e			;7ca0	1c 	. 
	dec e			;7ca1	1d 	. 
	ld e,01fh		;7ca2	1e 1f 	. . 
	ret m			;7ca4	f8 	. 
	ld sp,hl			;7ca5	f9 	. 
	jp m,0f6fbh		;7ca6	fa fb f6 	. . . 
	call m,0fefdh		;7ca9	fc fd fe 	. . . 
	rst 38h			;7cac	ff 	. 
	rst 30h			;7cad	f7 	. 

; BLOCK 'DIRTXT' (start 0x7cae end 0x7cb3)
DIRTXT_start:
	defb 004h		;7cae	04 	. 
	defb 064h		;7caf	64 	d 
	defb 069h		;7cb0	69 	i 
	defb 072h		;7cb1	72 	r 
	defb 020h		;7cb2	20 	  
DIRTXT_end:
	rst 38h			;7cb3	ff 	. 

; BLOCK 'COPYRTXT' (start 0x7cb4 end 0x7cc4)
COPYRTXT_start:
	defb 043h		;7cb4	43 	C 
	defb 04fh		;7cb5	4f 	O 
	defb 050h		;7cb6	50 	P 
	defb 059h		;7cb7	59 	Y 
	defb 052h		;7cb8	52 	R 
	defb 049h		;7cb9	49 	I 
	defb 047h		;7cba	47 	G 
	defb 048h		;7cbb	48 	H 
	defb 054h		;7cbc	54 	T 
	defb 020h		;7cbd	20 	  
	defb 005h		;7cbe	05 	. 
	defb 074h		;7cbf	74 	t 
	defb 079h		;7cc0	79 	y 
	defb 070h		;7cc1	70 	p 
	defb 065h		;7cc2	65 	e 
	defb 020h		;7cc3	20 	  
COPYRTXT_end:
	rst 38h			;7cc4	ff 	. 

; BLOCK 'CYEARTXT' (start 0x7cc5 end 0x7cd4)
CYEARTXT_start:
	defb 028h		;7cc5	28 	( 
	defb 043h		;7cc6	43 	C 
	defb 029h		;7cc7	29 	) 
	defb 020h		;7cc8	20 	  
	defb 031h		;7cc9	31 	1 
	defb 039h		;7cca	39 	9 
	defb 038h		;7ccb	38 	8 
	defb 034h		;7ccc	34 	4 
	defb 020h		;7ccd	20 	  
	defb 005h		;7cce	05 	. 
	defb 073h		;7ccf	73 	s 
	defb 074h		;7cd0	74 	t 
	defb 061h		;7cd1	61 	a 
	defb 074h		;7cd2	74 	t 
	defb 020h		;7cd3	20 	  
CYEARTXT_end:
	rst 38h			;7cd4	ff 	. 

; BLOCK 'EPSONTXT' (start 0x7cd5 end 0x7ce2)
EPSONTXT_start:
	defb 020h		;7cd5	20 	  
	defb 045h		;7cd6	45 	E 
	defb 050h		;7cd7	50 	P 
	defb 053h		;7cd8	53 	S 
	defb 04fh		;7cd9	4f 	O 
	defb 04eh		;7cda	4e 	N 
	defb 020h		;7cdb	20 	  
	defb 020h		;7cdc	20 	  
	defb 020h		;7cdd	20 	  
	defb 003h		;7cde	03 	. 
	defb 070h		;7cdf	70 	p 
	defb 069h		;7ce0	69 	i 
	defb 070h		;7ce1	70 	p 
EPSONTXT_end:
	rst 38h			;7ce2	ff 	. 

; BLOCK 'COLTDTXT' (start 0x7ce3 end 0x7cf5)
COLTDTXT_start:
	defb 020h		;7ce3	20 	  
	defb 020h		;7ce4	20 	  
	defb 043h		;7ce5	43 	C 
	defb 04fh		;7ce6	4f 	O 
	defb 02eh		;7ce7	2e 	. 
	defb 02ch		;7ce8	2c 	, 
	defb 020h		;7ce9	20 	  
	defb 04ch		;7cea	4c 	L 
	defb 054h		;7ceb	54 	T 
	defb 044h		;7cec	44 	D 
	defb 02eh		;7ced	2e 	. 
	defb 006h		;7cee	06 	. 
	defb 062h		;7cef	62 	b 
	defb 061h		;7cf0	61 	a 
	defb 073h		;7cf1	73 	s 
	defb 069h		;7cf2	69 	i 
	defb 063h		;7cf3	63 	c 
	defb 020h		;7cf4	20 	  
COLTDTXT_end:
	rst 38h			;7cf5	ff 	. 
	ld (hl),h			;7cf6	74 	t 
	ld h,l			;7cf7	65 	e 
	ld l,h			;7cf8	6c 	l 
	jr nz,l7d2bh		;7cf9	20 30 	  0 
	ld (l3336h),a		;7cfb	32 36 33 	2 6 3 
	rlca			;7cfe	07 	. 
	ld h,e			;7cff	63 	c 
	ld l,a			;7d00	6f 	o 
	ld l,(hl)			;7d01	6e 	n 
	ld h,(hl)			;7d02	66 	f 
	ld l,c			;7d03	69 	i 
	ld h,a			;7d04	67 	g 
	dec c			;7d05	0d 	. 
	rst 38h			;7d06	ff 	. 

; BLOCK 'SUMBITXT' (start 0x7d07 end 0x7d24)
SUMBITXT_start:
	defb 035h		;7d07	35 	5 
	defb 032h		;7d08	32 	2 
	defb 02dh		;7d09	2d 	- 
	defb 032h		;7d0a	32 	2 
	defb 035h		;7d0b	35 	5 
	defb 035h		;7d0c	35 	5 
	defb 032h		;7d0d	32 	2 
	defb 007h		;7d0e	07 	. 
	defb 073h		;7d0f	73 	s 
	defb 075h		;7d10	75 	u 
	defb 062h		;7d11	62 	b 
	defb 06dh		;7d12	6d 	m 
	defb 069h		;7d13	69 	i 
	defb 074h		;7d14	74 	t 
	defb 020h		;7d15	20 	  
	defb 0ffh		;7d16	ff 	. 
	defb 033h		;7d17	33 	3 
	defb 039h		;7d18	39 	9 
	defb 039h		;7d19	39 	9 
	defb 02dh		;7d1a	2d 	- 
	defb 030h		;7d1b	30 	0 
	defb 037h		;7d1c	37 	7 
	defb 020h		;7d1d	20 	  
	defb 005h		;7d1e	05 	. 
	defb 074h		;7d1f	74 	t 
	defb 065h		;7d20	65 	e 
	defb 072h		;7d21	72 	r 
	defb 06dh		;7d22	6d 	m 
	defb 00dh		;7d23	0d 	. 
SUMBITXT_end:
	rst 38h			;7d24	ff 	. 

; BLOCK 'SHIOJTXT' (start 0x7d25 end 0x7d36)
SHIOJTXT_start:
	defb 053h		;7d25	53 	S 
	defb 048h		;7d26	48 	H 
	defb 049h		;7d27	49 	I 
	defb 04fh		;7d28	4f 	O 
	defb 04ah		;7d29	4a 	J 
	defb 049h		;7d2a	49 	I 
l7d2bh:
	defb 052h		;7d2b	52 	R 
	defb 049h		;7d2c	49 	I 
	defb 020h		;7d2d	20 	  
	defb 007h		;7d2e	07 	. 
	defb 066h		;7d2f	66 	f 
	defb 069h		;7d30	69 	i 
	defb 06ch		;7d31	6c 	l 
	defb 069h		;7d32	69 	i 
	defb 06eh		;7d33	6e 	n 
	defb 06bh		;7d34	6b 	k 
	defb 00dh		;7d35	0d 	. 
SHIOJTXT_end:
	rst 38h			;7d36	ff 	. 

; BLOCK 'JAPANTXT' (start 0x7d37 end 0x7d44)
JAPANTXT_start:
	defb 020h		;7d37	20 	  
	defb 04ah		;7d38	4a 	J 
	defb 041h		;7d39	41 	A 
	defb 050h		;7d3a	50 	P 
	defb 041h		;7d3b	41 	A 
	defb 04eh		;7d3c	4e 	N 
	defb 020h		;7d3d	20 	  
	defb 005h		;7d3e	05 	. 
	defb 045h		;7d3f	45 	E 
	defb 050h		;7d40	50 	P 
	defb 049h		;7d41	49 	I 
	defb 043h		;7d42	43 	C 
	defb 00dh		;7d43	0d 	. 
JAPANTXT_end:
	rst 38h			;7d44	ff 	. 
	jr nz,l7d67h		;7d45	20 20 	    
	jr nz,$+34		;7d47	20 20 	    
	jr nz,l7d6bh		;7d49	20 20 	    
	jr nz,l7d6dh		;7d4b	20 20 	    
	jr nz,l7daeh		;7d4d	20 5f 	  _ 
	ld a,05fh		;7d4f	3e 5f 	> _ 
	ld a,05fh		;7d51	3e 5f 	> _ 
	ld a,05fh		;7d53	3e 5f 	> _ 
	ld a,05fh		;7d55	3e 5f 	> _ 
	ld a,05fh		;7d57	3e 5f 	> _ 
	ld a,05fh		;7d59	3e 5f 	> _ 
	ld a,05fh		;7d5b	3e 5f 	> _ 
	ld a,003h		;7d5d	3e 03 	> . 
	ld e,01fh		;7d5f	1e 1f 	. . 
	dec e			;7d61	1d 	. 
	inc e			;7d62	1c 	. 
	ld hl,(l2b2fh)		;7d63	2a 2f 2b 	* / + 
	dec l			;7d66	2d 	- 
l7d67h:
	scf			;7d67	37 	7 
	jr c,l7da3h		;7d68	38 39 	8 9 
	dec a			;7d6a	3d 	= 
l7d6bh:
	inc (hl)			;7d6b	34 	4 
	dec (hl)			;7d6c	35 	5 
l7d6dh:
	ld (hl),02ch		;7d6d	36 2c 	6 , 
	ld sp,03332h		;7d6f	31 32 33 	1 2 3 
	jr nc,$+1		;7d72	30 ff 	0 . 
	ld l,00dh		;7d74	2e 0d 	. . 
	ld bc,l0f00h		;7d76	01 00 0f 	. . . 
	ld (bc),a			;7d79	02 	. 
	nop			;7d7a	00 	. 
	nop			;7d7b	00 	. 
	nop			;7d7c	00 	. 
	nop			;7d7d	00 	. 
	ld sp,l0021h+2		;7d7e	31 23 00 	1 # . 
	ld bc,l0301h+1		;7d81	01 02 03 	. . . 
	inc b			;7d84	04 	. 
	dec b			;7d85	05 	. 
	ld b,007h		;7d86	06 07 	. . 
	ex af,af'			;7d88	08 	. 
	add hl,bc			;7d89	09 	. 
	ld a,(bc)			;7d8a	0a 	. 
	ld bc,l0602h		;7d8b	01 02 06 	. . . 
	ld b,0dfh		;7d8e	06 df 	. . 
	ld l,0e1h		;7d90	2e e1 	. . 
	ld l,0e6h		;7d92	2e e6 	. . 
	ld l,0ebh		;7d94	2e eb 	. . 
	ld l,0ebh		;7d96	2e eb 	. . 
	ld l,0f7h		;7d98	2e f7 	. . 
	ld l,0f7h		;7d9a	2e f7 	. . 
	ld l,005h		;7d9c	2e 05 	. . 
	cpl			;7d9e	2f 	/ 
	rlca			;7d9f	07 	. 
	cpl			;7da0	2f 	/ 
	inc c			;7da1	0c 	. 
	cpl			;7da2	2f 	/ 
l7da3h:
	ld de,l4f2fh		;7da3	11 2f 4f 	. / O 
	jr nc,l7de2h		;7da6	30 3a 	0 : 
	ld sp,l313ah		;7da8	31 3a 31 	1 : 1 
	ld e,b			;7dab	58 	X 
	cpl			;7dac	2f 	/ 
	ld e,b			;7dad	58 	X 
l7daeh:
	cpl			;7dae	2f 	/ 
	ld e,b			;7daf	58 	X 
	cpl			;7db0	2f 	/ 
	ld e,b			;7db1	58 	X 
	cpl			;7db2	2f 	/ 
	cp 0f2h		;7db3	fe f2 	. . 
	ld (bc),a			;7db5	02 	. 
	ld (l32a1h),a		;7db6	32 a1 32 	2 . 2 
	and c			;7db9	a1 	. 
	ld (03050h),a		;7dba	32 50 30 	2 P 0 
	ld d,b			;7dbd	50 	P 
	cpl			;7dbe	2f 	/ 
	ld d,b			;7dbf	50 	P 
	cpl			;7dc0	2f 	/ 
	ld e,c			;7dc1	59 	Y 
	cpl			;7dc2	2f 	/ 
	ld e,c			;7dc3	59 	Y 
	cpl			;7dc4	2f 	/ 
	ld e,c			;7dc5	59 	Y 
	cpl			;7dc6	2f 	/ 
	ld e,c			;7dc7	59 	Y 
	cpl			;7dc8	2f 	/ 
	ld (bc),a			;7dc9	02 	. 
	di			;7dca	f3 	. 
	inc bc			;7dcb	03 	. 
	ld (l2f50h),a		;7dcc	32 50 2f 	2 P / 
	ld d,b			;7dcf	50 	P 
	cpl			;7dd0	2f 	/ 
	nop			;7dd1	00 	. 
	nop			;7dd2	00 	. 
	nop			;7dd3	00 	. 
	nop			;7dd4	00 	. 
	nop			;7dd5	00 	. 
	nop			;7dd6	00 	. 
	nop			;7dd7	00 	. 
	nop			;7dd8	00 	. 
	ei			;7dd9	fb 	. 
	push af			;7dda	f5 	. 
	nop			;7ddb	00 	. 
	jp p,0f69bh		;7ddc	f2 9b f6 	. . . 
	ld a,e			;7ddf	7b 	{ 
	or 000h		;7de0	f6 00 	. . 
l7de2h:
	nop			;7de2	00 	. 
	nop			;7de3	00 	. 
	nop			;7de4	00 	. 
	nop			;7de5	00 	. 
	nop			;7de6	00 	. 
	nop			;7de7	00 	. 
	nop			;7de8	00 	. 
	ei			;7de9	fb 	. 
	push af			;7dea	f5 	. 
	rrca			;7deb	0f 	. 
	jp p,0f6a4h		;7dec	f2 a4 f6 	. . . 
	sbc a,e			;7def	9b 	. 
	or 000h		;7df0	f6 00 	. . 
	nop			;7df2	00 	. 
	nop			;7df3	00 	. 
	nop			;7df4	00 	. 
	nop			;7df5	00 	. 
	nop			;7df6	00 	. 
	nop			;7df7	00 	. 
	nop			;7df8	00 	. 
	ei			;7df9	fb 	. 
	push af			;7dfa	f5 	. 
	ld e,0f2h		;7dfb	1e f2 	. . 
	xor l			;7dfd	ad 	. 
	or 0a4h		;7dfe	f6 a4 	. . 
	or 000h		;7e00	f6 00 	. . 
	nop			;7e02	00 	. 
	nop			;7e03	00 	. 
	nop			;7e04	00 	. 
	nop			;7e05	00 	. 
	nop			;7e06	00 	. 
	nop			;7e07	00 	. 
	nop			;7e08	00 	. 
	ei			;7e09	fb 	. 
	push af			;7e0a	f5 	. 
	dec l			;7e0b	2d 	- 
	jp p,0f6bfh		;7e0c	f2 bf f6 	. . . 
	xor l			;7e0f	ad 	. 
	or 000h		;7e10	f6 00 	. . 
	nop			;7e12	00 	. 
	nop			;7e13	00 	. 
	nop			;7e14	00 	. 
	nop			;7e15	00 	. 
	nop			;7e16	00 	. 
	nop			;7e17	00 	. 
	nop			;7e18	00 	. 
	ei			;7e19	fb 	. 
	push af			;7e1a	f5 	. 
	dec l			;7e1b	2d 	- 
	jp p,0f6e1h		;7e1c	f2 e1 f6 	. . . 
	rst 8			;7e1f	cf 	. 
	or 000h		;7e20	f6 00 	. . 
	nop			;7e22	00 	. 
	nop			;7e23	00 	. 
	nop			;7e24	00 	. 
	nop			;7e25	00 	. 
	nop			;7e26	00 	. 
	nop			;7e27	00 	. 
	nop			;7e28	00 	. 
	ei			;7e29	fb 	. 
	push af			;7e2a	f5 	. 
	dec l			;7e2b	2d 	- 
	jp p,0f703h		;7e2c	f2 03 f7 	. . . 
	pop af			;7e2f	f1 	. 
	or 000h		;7e30	f6 00 	. . 
	nop			;7e32	00 	. 
	nop			;7e33	00 	. 
	nop			;7e34	00 	. 
	nop			;7e35	00 	. 
	nop			;7e36	00 	. 
	nop			;7e37	00 	. 
	nop			;7e38	00 	. 
	ei			;7e39	fb 	. 
	push af			;7e3a	f5 	. 
	dec l			;7e3b	2d 	- 
	jp p,0f725h		;7e3c	f2 25 f7 	. % . 
	inc de			;7e3f	13 	. 
	rst 30h			;7e40	f7 	. 
	nop			;7e41	00 	. 
	nop			;7e42	00 	. 
	nop			;7e43	00 	. 
	nop			;7e44	00 	. 
	nop			;7e45	00 	. 
	nop			;7e46	00 	. 
	nop			;7e47	00 	. 
	nop			;7e48	00 	. 
	ei			;7e49	fb 	. 
	push af			;7e4a	f5 	. 
	inc a			;7e4b	3c 	< 
	jp p,0f73dh		;7e4c	f2 3d f7 	. = . 
	dec (hl)			;7e4f	35 	5 
	rst 30h			;7e50	f7 	. 
	nop			;7e51	00 	. 
	nop			;7e52	00 	. 
	nop			;7e53	00 	. 
	nop			;7e54	00 	. 
	nop			;7e55	00 	. 
	nop			;7e56	00 	. 
	nop			;7e57	00 	. 
	nop			;7e58	00 	. 
	ei			;7e59	fb 	. 
	push af			;7e5a	f5 	. 
	ld c,e			;7e5b	4b 	K 
	jp p,0f755h		;7e5c	f2 55 f7 	. U . 
	ld c,l			;7e5f	4d 	M 
	rst 30h			;7e60	f7 	. 
	nop			;7e61	00 	. 
	nop			;7e62	00 	. 
	nop			;7e63	00 	. 
	nop			;7e64	00 	. 
	nop			;7e65	00 	. 
	nop			;7e66	00 	. 
	nop			;7e67	00 	. 
	nop			;7e68	00 	. 
	ei			;7e69	fb 	. 
	push af			;7e6a	f5 	. 
	ld e,d			;7e6b	5a 	Z 
	jp p,0f761h		;7e6c	f2 61 f7 	. a . 
	ld e,c			;7e6f	59 	Y 
	rst 30h			;7e70	f7 	. 
	nop			;7e71	00 	. 
	nop			;7e72	00 	. 
	nop			;7e73	00 	. 
	nop			;7e74	00 	. 
	nop			;7e75	00 	. 
	nop			;7e76	00 	. 
	nop			;7e77	00 	. 
	nop			;7e78	00 	. 
	ei			;7e79	fb 	. 
	push af			;7e7a	f5 	. 
	ld l,c			;7e7b	69 	i 
	jp p,0f769h		;7e7c	f2 69 f7 	. i . 
	ld h,c			;7e7f	61 	a 
	rst 30h			;7e80	f7 	. 
	ld b,b			;7e81	40 	@ 
	nop			;7e82	00 	. 
	inc bc			;7e83	03 	. 
	rlca			;7e84	07 	. 
	nop			;7e85	00 	. 
	ex af,af'			;7e86	08 	. 
	nop			;7e87	00 	. 
	rrca			;7e88	0f 	. 
	nop			;7e89	00 	. 
	add a,b			;7e8a	80 	. 
	nop			;7e8b	00 	. 
	nop			;7e8c	00 	. 
	nop			;7e8d	00 	. 
	nop			;7e8e	00 	. 
	nop			;7e8f	00 	. 
	ld b,b			;7e90	40 	@ 
	nop			;7e91	00 	. 
	inc bc			;7e92	03 	. 
	rlca			;7e93	07 	. 
	nop			;7e94	00 	. 
	ccf			;7e95	3f 	? 
	nop			;7e96	00 	. 
	rra			;7e97	1f 	. 
	nop			;7e98	00 	. 
	add a,b			;7e99	80 	. 
	nop			;7e9a	00 	. 
	nop			;7e9b	00 	. 
	nop			;7e9c	00 	. 
	nop			;7e9d	00 	. 
	nop			;7e9e	00 	. 
	ld b,b			;7e9f	40 	@ 
	nop			;7ea0	00 	. 
	inc bc			;7ea1	03 	. 
	rlca			;7ea2	07 	. 
	nop			;7ea3	00 	. 
	ccf			;7ea4	3f 	? 
	nop			;7ea5	00 	. 
	rra			;7ea6	1f 	. 
	nop			;7ea7	00 	. 
	add a,b			;7ea8	80 	. 
	nop			;7ea9	00 	. 
	nop			;7eaa	00 	. 
	nop			;7eab	00 	. 
	nop			;7eac	00 	. 
	nop			;7ead	00 	. 
	ld b,b			;7eae	40 	@ 
	nop			;7eaf	00 	. 
	inc b			;7eb0	04 	. 
	rrca			;7eb1	0f 	. 
	ld bc,l0089h+2		;7eb2	01 8b 00 	. . . 
	ccf			;7eb5	3f 	? 
	nop			;7eb6	00 	. 
	add a,b			;7eb7	80 	. 
	nop			;7eb8	00 	. 
	djnz l7ebbh		;7eb9	10 00 	. . 
l7ebbh:
	inc b			;7ebb	04 	. 
	nop			;7ebc	00 	. 
	ld b,b			;7ebd	40 	@ 
	nop			;7ebe	00 	. 
	inc bc			;7ebf	03 	. 
	rlca			;7ec0	07 	. 
	nop			;7ec1	00 	. 
	dec e			;7ec2	1d 	. 
	nop			;7ec3	00 	. 
	dec bc			;7ec4	0b 	. 
	nop			;7ec5	00 	. 
	add a,b			;7ec6	80 	. 
	nop			;7ec7	00 	. 
	nop			;7ec8	00 	. 
	nop			;7ec9	00 	. 
	nop			;7eca	00 	. 
	nop			;7ecb	00 	. 
	ld b,b			;7ecc	40 	@ 
	nop			;7ecd	00 	. 
	inc bc			;7ece	03 	. 
	rlca			;7ecf	07 	. 
	nop			;7ed0	00 	. 
	ccf			;7ed1	3f 	? 
	nop			;7ed2	00 	. 
	rrca			;7ed3	0f 	. 
	nop			;7ed4	00 	. 
	add a,b			;7ed5	80 	. 
	nop			;7ed6	00 	. 
	inc b			;7ed7	04 	. 
	nop			;7ed8	00 	. 
	nop			;7ed9	00 	. 
	nop			;7eda	00 	. 
	ld b,b			;7edb	40 	@ 
	nop			;7edc	00 	. 
	inc bc			;7edd	03 	. 
	rlca			;7ede	07 	. 
	nop			;7edf	00 	. 
	ccf			;7ee0	3f 	? 
	nop			;7ee1	00 	. 
	rra			;7ee2	1f 	. 
	nop			;7ee3	00 	. 
	add a,b			;7ee4	80 	. 
	nop			;7ee5	00 	. 
	nop			;7ee6	00 	. 
	nop			;7ee7	00 	. 
	nop			;7ee8	00 	. 
	nop			;7ee9	00 	. 
	ld b,b			;7eea	40 	@ 
	nop			;7eeb	00 	. 
	inc bc			;7eec	03 	. 
	rlca			;7eed	07 	. 
	nop			;7eee	00 	. 
	ccf			;7eef	3f 	? 
	nop			;7ef0	00 	. 
	rra			;7ef1	1f 	. 
	nop			;7ef2	00 	. 
	add a,b			;7ef3	80 	. 
	nop			;7ef4	00 	. 
	nop			;7ef5	00 	. 
	nop			;7ef6	00 	. 
	nop			;7ef7	00 	. 
	nop			;7ef8	00 	. 
	rst 38h			;7ef9	ff 	. 
	ld h,b			;7efa	60 	` 
	add a,h			;7efb	84 	. 
	ex af,af'			;7efc	08 	. 
	scf			;7efd	37 	7 
	inc b			;7efe	04 	. 
l7effh:
	ld h,b			;7eff	60 	` 
	add a,h			;7f00	84 	. 
	ex af,af'			;7f01	08 	. 
	scf			;7f02	37 	7 
	inc b			;7f03	04 	. 
	or b			;7f04	b0 	. 
	inc b			;7f05	04 	. 
	inc b			;7f06	04 	. 
	scf			;7f07	37 	7 
l7f08h:
	inc b			;7f08	04 	. 
	inc bc			;7f09	03 	. 
	ld a,(bc)			;7f0a	0a 	. 
	ld h,h			;7f0b	64 	d 
	ld a,(bc)			;7f0c	0a 	. 
	nop			;7f0d	00 	. 
	ld bc,l1c2fh		;7f0e	01 2f 1c 	. / . 
	nop			;7f11	00 	. 
	ret nc			;7f12	d0 	. 
	nop			;7f13	00 	. 
	ex af,af'			;7f14	08 	. 
	nop			;7f15	00 	. 
	ret po			;7f16	e0 	. 
	nop			;7f17	00 	. 
	nop			;7f18	00 	. 
	ld bc,05001h		;7f19	01 01 50 	. . P 
l7f1ch:
	add hl,de			;7f1c	19 	. 
	ld bc,l0001h		;7f1d	01 01 00 	. . . 
	nop			;7f20	00 	. 
	nop			;7f21	00 	. 
	ld bc,COLDRST		;7f22	01 00 00 	. . . 
	inc d			;7f25	14 	. 
	ld bc,COLDRST		;7f26	01 00 00 	. . . 
	nop			;7f29	00 	. 
	nop			;7f2a	00 	. 
	nop			;7f2b	00 	. 
	nop			;7f2c	00 	. 
	nop			;7f2d	00 	. 
	nop			;7f2e	00 	. 
	nop			;7f2f	00 	. 
	nop			;7f30	00 	. 
	nop			;7f31	00 	. 
	nop			;7f32	00 	. 
	nop			;7f33	00 	. 
	nop			;7f34	00 	. 
	nop			;7f35	00 	. 
	nop			;7f36	00 	. 
	nop			;7f37	00 	. 
	nop			;7f38	00 	. 
	ret pe			;7f39	e8 	. 
	ld b,b			;7f3a	40 	@ 
	ld bc,0d800h		;7f3b	01 00 d8 	. . . 
	nop			;7f3e	00 	. 
	nop			;7f3f	00 	. 
	ld bc,02801h		;7f40	01 01 28 	. . ( 
	ex af,af'			;7f43	08 	. 
	ld bc,l0001h		;7f44	01 01 00 	. . . 
	nop			;7f47	00 	. 
	nop			;7f48	00 	. 
	nop			;7f49	00 	. 
	nop			;7f4a	00 	. 
	nop			;7f4b	00 	. 
	inc d			;7f4c	14 	. 
	ld bc,COLDRST		;7f4d	01 00 00 	. . . 
	nop			;7f50	00 	. 
	nop			;7f51	00 	. 
	nop			;7f52	00 	. 
	nop			;7f53	00 	. 
	nop			;7f54	00 	. 
	nop			;7f55	00 	. 
	nop			;7f56	00 	. 
	nop			;7f57	00 	. 
	nop			;7f58	00 	. 
	nop			;7f59	00 	. 
	nop			;7f5a	00 	. 
	nop			;7f5b	00 	. 
	nop			;7f5c	00 	. 
	nop			;7f5d	00 	. 
l7f5eh:
	nop			;7f5e	00 	. 
	ld bc,l2305h		;7f5f	01 05 23 	. . # 
	nop			;7f62	00 	. 
	rlca			;7f63	07 	. 
	nop			;7f64	00 	. 
	jp nz,0c2c2h		;7f65	c2 c2 c2 	. . . 
	inc a			;7f68	3c 	< 
	nop			;7f69	00 	. 
	ld c,l			;7f6a	4d 	M 
	nop			;7f6b	00 	. 
	exx			;7f6c	d9 	. 
	nop			;7f6d	00 	. 
	ld l,b			;7f6e	68 	h 
	nop			;7f6f	00 	. 
	ld l,b			;7f70	68 	h 
	nop			;7f71	00 	. 
	inc (hl)			;7f72	34 	4 
	nop			;7f73	00 	. 
	inc (hl)			;7f74	34 	4 
	nop			;7f75	00 	. 
	ld c,(hl)			;7f76	4e 	N 
	nop			;7f77	00 	. 
	ld (bc),a			;7f78	02 	. 
	nop			;7f79	00 	. 
	inc b			;7f7a	04 	. 
	nop			;7f7b	00 	. 
	dec b			;7f7c	05 	. 
	dec b			;7f7d	05 	. 
	inc bc			;7f7e	03 	. 
	ld a,0ffh		;7f7f	3e ff 	> . 
	jr l7f85h		;7f81	18 02 	. . 
	ld a,0ffh		;7f83	3e ff 	> . 
l7f85h:
	ld (BIOSERROR),a		;7f85	32 2b f5 	2 + . 
	ret			;7f88	c9 	. 
	ld (0ff00h),a		;7f89	32 00 ff 	2 . . 
	nop			;7f8c	00 	. 
	rst 38h			;7f8d	ff 	. 
	nop			;7f8e	00 	. 
	nop			;7f8f	00 	. 
	nop			;7f90	00 	. 
	nop			;7f91	00 	. 
	nop			;7f92	00 	. 
	nop			;7f93	00 	. 
	nop			;7f94	00 	. 
	nop			;7f95	00 	. 
	nop			;7f96	00 	. 
	nop			;7f97	00 	. 
	nop			;7f98	00 	. 
	push hl			;7f99	e5 	. 
	nop			;7f9a	00 	. 
	nop			;7f9b	00 	. 
	nop			;7f9c	00 	. 
	nop			;7f9d	00 	. 
	nop			;7f9e	00 	. 
	nop			;7f9f	00 	. 
	add a,b			;7fa0	80 	. 
	nop			;7fa1	00 	. 
	nop			;7fa2	00 	. 
l7fa3h:
	inc e			;7fa3	1c 	. 
	dec e			;7fa4	1d 	. 
	ld e,01fh		;7fa5	1e 1f 	. . 
	ld b,002h		;7fa7	06 02 	. . 
	djnz l7fbch		;7fa9	10 11 	. . 
	or 016h		;7fab	f6 16 	. . 
	rla			;7fad	17 	. 
	inc d			;7fae	14 	. 
	dec d			;7faf	15 	. 
	rst 30h			;7fb0	f7 	. 
	jr nz,l7fb3h		;7fb1	20 00 	  . 
l7fb3h:
	nop			;7fb3	00 	. 
	nop			;7fb4	00 	. 
	nop			;7fb5	00 	. 
	rst 38h			;7fb6	ff 	. 
	rst 38h			;7fb7	ff 	. 
	ld d,b			;7fb8	50 	P 
	jr z,l7fbbh		;7fb9	28 00 	( . 
l7fbbh:
	ld (hl),d			;7fbb	72 	r 
l7fbch:
	nop			;7fbc	00 	. 
	ld (0d500h),a		;7fbd	32 00 d5 	2 . . 
	ld bc,OSTART		;7fc0	01 69 00 	. i . 
	ex af,af'			;7fc3	08 	. 
	add a,h			;7fc4	84 	. 
	ld a,(bc)			;7fc5	0a 	. 
	ld h,h			;7fc6	64 	d 
	ld hl,(l2a2ah)		;7fc7	2a 2a 2a 	* * * 
	ld hl,(0972ah)		;7fca	2a 2a 97 	* * . 
	ei			;7fcd	fb 	. 
	dec (hl)			;7fce	35 	5 
	rst 30h			;7fcf	f7 	. 
	nop			;7fd0	00 	. 
	ret po			;7fd1	e0 	. 
	ld (bc),a			;7fd2	02 	. 
	ccf			;7fd3	3f 	? 
	nop			;7fd4	00 	. 
	ret z			;7fd5	c8 	. 
	nop			;7fd6	00 	. 
	rst 38h			;7fd7	ff 	. 

; BLOCK 'TYPTXT' (start 0x7fd8 end 0x7fff)
TYPTXT_start:
	defb 06bh		;7fd8	6b 	k 
	defb 020h		;7fd9	20 	  
	defb 043h		;7fda	43 	C 
	defb 050h		;7fdb	50 	P 
	defb 02fh		;7fdc	2f 	/ 
	defb 04dh		;7fdd	4d 	M 
	defb 020h		;7fde	20 	  
	defb 020h		;7fdf	20 	  
	defb 020h		;7fe0	20 	  
	defb 076h		;7fe1	76 	v 
	defb 065h		;7fe2	65 	e 
	defb 072h		;7fe3	72 	r 
	defb 020h		;7fe4	20 	  
	defb 032h		;7fe5	32 	2 
	defb 02eh		;7fe6	2e 	. 
	defb 032h		;7fe7	32 	2 
l7fe8h:
	defb 050h		;7fe8	50 	P 
	defb 049h		;7fe9	49 	I 
	defb 04eh		;7fea	4e 	N 
	defb 044h		;7feb	44 	D 
	defb 049h		;7fec	49 	I 
	defb 052h		;7fed	52 	R 
	defb 045h		;7fee	45 	E 
	defb 043h		;7fef	43 	C 
	defb 053h		;7ff0	53 	S 
	defb 059h		;7ff1	59 	Y 
	defb 053h		;7ff2	53 	S 
	defb 045h		;7ff3	45 	E 
	defb 050h		;7ff4	50 	P 
	defb 053h		;7ff5	53 	S 
	defb 04fh		;7ff6	4f 	O 
	defb 04eh		;7ff7	4e 	N 
l7ff8h:
	defb 050h		;7ff8	50 	P 
	defb 049h		;7ff9	49 	I 
	defb 04eh		;7ffa	4e 	N 
	defb 045h		;7ffb	45 	E 
	defb 032h		;7ffc	32 	2 
	defb 031h		;7ffd	31 	1 
	defb 032h		;7ffe	32 	2 
TYPTXT_end:
	defb 030h		;7fff	30 	0 
