************************************************************************
*       UART2 test program for the SPC16/10 Philips P800/P851          *
*                Microprocessor SBC bj Jos Andreesen                   *
*                                                                      *
*            Program created by Fred Jan Kraan, 2025-11-13             *
************************************************************************

        IDENT   UART2TST

* -----SCC2691 UART 2-----
* I have 100's of 'em....
MR2   	 EQU	0x10	Mode register
SR2   	 EQU	0x12	Status
CSR2  	 EQU	0x12
BRG2  	 EQU	0x14
CR2   	 EQU	0x14
RHR2  	 EQU    0x16
THR2  	 EQU	0x16
T16X2 	 EQU	0x18
ACR2  	 EQU	0x18
IR2   	 EQU	0x1A
CTU2  	 EQU	0x1C
CTL2  	 EQU	0x1E

ESC     EQU     0x001B

       
        AORG    0xC200

* Initialize UART2, check for received char UART2, write it to UART1, Loop
* ToDo: check received chat UART1, write it to UART2 
START   
        CF      A14,TXTOUT
        DATA    /0A0D,'UART2 TEST',/0A0D,00
        CF      A14,SERSET2     * Initialize UART2
TSTLOOP
        CF      A14,SERIN2NB    * check UART2
        LDR     A6,A7
        ANKL    A6,/FF00        * mask out lower byte, 0xFF00 is no char
        RF(NZ)  NOCHAR2
        CWK     A7,ESC
        RF(Z)   BACK2MON
        CF      A14,SEROUT
NOCHAR2
        CF      A14,SERIN1NB    * check UART1
        LDR     A6,A7
        ANKL    A6,/FF00        * mask out lower byte, 0xFF00 is no char
        RF(NZ)  NOCHAR1
        CWK     A7,ESC
        RF(Z)   BACK2MON
        CF      A14,SEROUT2
NOCHAR1
        RB      TSTLOOP

BACK2MON
*        RTN     A14            * when called as subroutine
        ABL      /02EA           * when called with jump

* Driver routines

* =============================================	
*       R S 2 3 2   I N P U T 2
* input from serial terminal. Uses A5 & A7
* read hex input, return a word, byte or nibble in A5.
* Results are shifted in right to left. 
* [A5,A7]
*================================================
SERWRD2 CF	A14,SERBYT2		
SERBYT2	CF	A14,SERNIB2 
SERNIB2 	CF	A14,SERIN2	* read a hex nibble
        CWK 	A7,'0'	
	RB(L) 	SERNIB2		Smaller than '0', go for next byte	
        CWK 	A7,'F'	
	RB(G)	SERNIB2		Greater than 'F', also ignore
        CWK 	A7,'A'	
	RF(L) 	CHR2		Smaller than 'A',
	SUK 	A7,7  
CHR2	ANK 	A7,/0F          isolate nibble
	SLL 	A5,4		Shift left 4 places
	ORR 	A5,A7		OR with previous contents
	RTN 	A14
*
* receive a character in A7 on RS232 chan 1, blocking
* [A7]
SERIN2	INR 	A7,0,SR2
	ANK	A7,/01
	RB(Z)	SERIN2	        loop until RX not empty
	INR	A7,0,RHR2
*	CF	A14,SEROUT2      echo character read
	ANKL 	A7,/00FF	* Mask out upper bits. These are invalid 
*                               * as the RS232 channel is only 8 bit wide.
	RTN 	A14	
*
* receive a character in A7 on RS232 chan 2, not blocking
* [A7] On exit, one of two cases: 
*      - character received; in A7 LSB, MSB == /00
*      - no character received; A7 LSB == /00, A7 MSB == /FF
SERIN2NB
	INR 	A7,0,SR2
	ANK	A7,/01
	RF(Z)	SERIN2DN2	* done when no char
	INR	A7,0,RHR2
	ANKL 	A7,/00FF	* Mask out upper bits. These are invalid 
*                               * as the RS232 channel is only 8 bit wide.	        
        RF      SERIN2DN3        * Branch always
SERIN2DN2
	LDKL 	A7,/FF00	* Set upper bits to signal no char.
SERIN2DN3
	RTN 	A14	
  
* This routine should (functionally) be part of the monitor...
*
* receive a character in A7 on RS232 chan 1, not blocking
* [A7] On exit, one of two cases: 
*      - character received; in A7 LSB, MSB == /00
*      - no character received; A7 LSB == /00, A7 MSB == /FF
RHR  	 EQU    0x06
SR   	 EQU	0x02	Status
SERIN1NB
	INR 	A7,0,SR
	ANK	A7,/01
	RF(Z)	SERIN1DN2	* done when no char
	INR	A7,0,RHR
	ANKL 	A7,/00FF	* Mask out upper bits. These are invalid 
*                               * as the RS232 channel is only 8 bit wide.	        
        RF      SERIN1DN3        * Branch always
SERIN1DN2
	LDKL 	A7,/FF00	* Set upper bits to signal no char.
SERIN1DN3
	RTN 	A14	
        
*	
* =============================================	
*     R S 2 3 2   O U T P U T 2
* Textoutput on serial terminal. Uses A4 & A7
* Text is stored after initial subroutine call.
* Stack is updated to point to first instruction after call
* [A4,A7]
*================================================
TXTOUT2 LDR     A4,A14          Copy system stack pointer  
	ADK     A4,4	        Find pointer to first text
	LDR*    A4,A4	        A13 now points to ASCII string
TXTR2   LDR*    A7,A4		Load 2 characters
        ADK     A4,2		increment pointer
        SLC     A7,8		Swap bytes
        RF(Z)   TXTEX2		if char=0 then exit
        CF      A14,SEROUT2	Output first byte
        SRL     A7,8	        Shift bytes
        RF(Z)   TXTEX2		if char=0 then exit
        CF      A14,SEROUT2	Output second byte       
        RB(7)   TXTR2	        Next character
TXTEX2	ST      A4,/0004,A14    restore pointer
        RTN     A14		Exit from textroutine
*
* CR/LF on serial channel #1
* [A6,A7]
CRLF2    LDK	A7,/0D          Load CR
	CF 	A14,SEROUT2
        LDK	A7,/0A          Load LF
	CF 	A14,SEROUT2
	RTN	A14
*
*---- Display word in A5 in hex on serial #1----
* [A5,A6,A7]
WRDOUT2	LDK	A7,/020         Load space
	CF 	A14,SEROUT2
        SLC     A5,4            Rotate left 4 bit
	CF	A14,NIBBLE2      output one nibble
	SLC     A5,4
	CF	A14,NIBBLE2
        SLC     A5,4
	CF	A14,NIBBLE2
        SLC     A5,4        
NIBBLE2	LDR 	A7,A5
	ANK	A7,/0F
	ORK	A7,/30
	CWK	A7,/003A
	RF(L)   SEROUT2
	ADK	A7,/07 		Continues below !
* send a character in A7 to  RS232 chan 0
* [A6,A7]
SEROUT2	INR 	A6,0,SR2
	ANK	A6,/08
	RB(Z)	SEROUT2	        loop until TX-empty
	OTR	A7,0,THR2
	RTN 	A14

*
* =============================================	
*     R S 2 3 2    I N I T 2
* initialize the RS232 chip to 19200 8n1
* [A7]
* ===========================================
SERSET2	LDK 	A7,/0
	OTR 	A7,0,IR2	      disable all IRQ's
	LDK 	A7,/53	      Set to 8N1
	OTR 	A7,0,MR2	      write mode register 1
	LDK 	A7,/08           
	OTR 	A7,0,MR2	      write mode register 2
	LDK 	A7,/89		
	OTR 	A7,0,ACR2      aux control
	LDK 	A7,/CC	      select 19200 baud
*	LDK 	A7,/BB	      select 9600 baud
	OTR 	A7,0,CSR2      
	LDK 	A7,/05		
	OTR 	A7,0,CR2       set rx & tx active
	RTN 	A14
*===================================================
*
